/************************************************************************
*FILE: BlurWidget3DBase.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ***************************************************************************************
 * FILE:          Generated intermediate file from HMIContract.exe
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  This file is part of HMI-Base Widget Library 
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "widget2D_std_if.h"

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "BlurWidget3DBase.h"

namespace hmibase {
} // namespace hmibase

namespace hmibase {
namespace widget {
namespace blur {
// ------------------------------------------------------------------------
CGI_WIDGET_RTTI_DEFINITION(BlurWidget3DBase)

BlurWidget3DBase::BlurWidget3DBase() :
    m_BlurShaderVariant(enShaderVariant::DynamicShader),
    m_BlurMaskVariant(enBlurMaskVariant::NoBlurMask),
    m_Multipass(true),
    m_CombineMask(false),
    m_UseManualDirtyArea(false),
    m_BlurRadius(0),
    m_Darken(DarkenType()),
    m_BlurEnabled(BlurEnabledType()),
    m_BlurRadiusToSigma(0.5F),
    m_BlendOutput(BlendOutputType()),
    m_RenderTargetMask(RenderTargetMaskType()),
    m_SubsamplingFactor(1),
    m_BillboardMask(BillboardMaskType()),
    m_BitmapMask(BitmapMaskType()),
    m_KeepFrameBufferContent(true),
    m_DirtyAreaRectangle(DirtyAreaRectangleType())
{
}

BlurWidget3DBase::~BlurWidget3DBase()
{
    m_RenderTargetMask = 0;
    m_BillboardMask = 0;
}

void BlurWidget3DBase::SetBlurShaderVariant(const BlurShaderVariantType& blurshadervariant)
{
    if (m_BlurShaderVariant != blurshadervariant) {
        m_BlurShaderVariant = blurshadervariant;
        OnChanged(static_cast< ::FeatStd::UInt32>(BlurShaderVariantPropertyId));
    }
}

void BlurWidget3DBase::SetBlurMaskVariant(const BlurMaskVariantType& blurmaskvariant)
{
    if (m_BlurMaskVariant != blurmaskvariant) {
        m_BlurMaskVariant = blurmaskvariant;
        OnChanged(static_cast< ::FeatStd::UInt32>(BlurMaskVariantPropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("BlurMaskVariant");
        }
    }
}

void BlurWidget3DBase::SetMultipass(const MultipassType& multipass)
{
    if (m_Multipass != multipass) {
        m_Multipass = multipass;
        OnChanged(static_cast< ::FeatStd::UInt32>(MultipassPropertyId));
    }
}

void BlurWidget3DBase::SetCombineMask(const CombineMaskType& combinemask)
{
    if (m_CombineMask != combinemask) {
        m_CombineMask = combinemask;
        OnChanged(static_cast< ::FeatStd::UInt32>(CombineMaskPropertyId));
    }
}

void BlurWidget3DBase::SetUseManualDirtyArea(const UseManualDirtyAreaType& usemanualdirtyarea)
{
    if (m_UseManualDirtyArea != usemanualdirtyarea) {
        m_UseManualDirtyArea = usemanualdirtyarea;
        OnChanged(static_cast< ::FeatStd::UInt32>(UseManualDirtyAreaPropertyId));
    }
}

void BlurWidget3DBase::SetBlurRadius(const BlurRadiusType& blurradius)
{
    if (m_BlurRadius != blurradius) {
        m_BlurRadius = blurradius;
        OnChanged(static_cast< ::FeatStd::UInt32>(BlurRadiusPropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("BlurRadius");
        }
    }
}

void BlurWidget3DBase::SetDarken(const DarkenType& darken)
{
    if (m_Darken != darken) {
        m_Darken = darken;
        OnChanged(static_cast< ::FeatStd::UInt32>(DarkenPropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("Darken");
        }
    }
}

void BlurWidget3DBase::SetBlurEnabled(const BlurEnabledType& blurenabled)
{
    if (m_BlurEnabled != blurenabled) {
        m_BlurEnabled = blurenabled;
        OnChanged(static_cast< ::FeatStd::UInt32>(BlurEnabledPropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("BlurEnabled");
        }
    }
}

void BlurWidget3DBase::SetBlurRadiusToSigma(const BlurRadiusToSigmaType& blurradiustosigma)
{
    if (m_BlurRadiusToSigma != blurradiustosigma) {
        m_BlurRadiusToSigma = blurradiustosigma;
        OnChanged(static_cast< ::FeatStd::UInt32>(BlurRadiusToSigmaPropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("BlurRadiusToSigma");
        }
    }
}

void BlurWidget3DBase::SetBlendOutput(const BlendOutputType& blendoutput)
{
    if (m_BlendOutput != blendoutput) {
        m_BlendOutput = blendoutput;
        OnChanged(static_cast< ::FeatStd::UInt32>(BlendOutputPropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("BlendOutput");
        }
    }
}

void BlurWidget3DBase::SetRenderTargetMask(const RenderTargetMaskType rendertargetmask)
{
    if (m_RenderTargetMask != rendertargetmask) {
        m_RenderTargetMask = rendertargetmask;
        OnChanged(static_cast< ::FeatStd::UInt32>(RenderTargetMaskPropertyId));
    }
}

void BlurWidget3DBase::SetSubsamplingFactor(const SubsamplingFactorType& subsamplingfactor)
{
    if (m_SubsamplingFactor != subsamplingfactor) {
        m_SubsamplingFactor = subsamplingfactor;
        OnChanged(static_cast< ::FeatStd::UInt32>(SubsamplingFactorPropertyId));
    }
}

void BlurWidget3DBase::SetBillboardMask(const BillboardMaskType billboardmask)
{
    if (m_BillboardMask != billboardmask) {
        m_BillboardMask = billboardmask;
        OnChanged(static_cast< ::FeatStd::UInt32>(BillboardMaskPropertyId));
    }
}

void BlurWidget3DBase::SetBitmapMask(const BitmapMaskType& bitmapmask)
{
    if (m_BitmapMask != bitmapmask) {
        m_BitmapMask = bitmapmask;
        OnChanged(static_cast< ::FeatStd::UInt32>(BitmapMaskPropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("BitmapMask");
        }
    }
}

void BlurWidget3DBase::SetKeepFrameBufferContent(const KeepFrameBufferContentType& keepframebuffercontent)
{
    if (m_KeepFrameBufferContent != keepframebuffercontent) {
        m_KeepFrameBufferContent = keepframebuffercontent;
        OnChanged(static_cast< ::FeatStd::UInt32>(KeepFrameBufferContentPropertyId));
    }
}

void BlurWidget3DBase::SetDirtyAreaRectangle(const DirtyAreaRectangleType& dirtyarearectangle)
{
    if (m_DirtyAreaRectangle != dirtyarearectangle) {
        m_DirtyAreaRectangle = dirtyarearectangle;
        OnChanged(static_cast< ::FeatStd::UInt32>(DirtyAreaRectanglePropertyId));
    }
}
} // namespace blur
} // namespace widget
} // namespace hmibase
