/************************************************************************
*FILE: AnimationWidget3DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(AnimationWidget3DBase_h)
#define AnimationWidget3DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/MetaInfo/BaseInternalMacros.h>
#include <Candera/System/MetaInfo/EnumDataTypeInternal.h>
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/3D/BaseWidget3D.h>
#include <Candera/System/Mathematics/Vector3.h>
namespace enAnimationProperty3D {
// =========================================================================
enum Enum {
    AnimatePosition,
    AnimateRotation,
    AnimateDiffuseColor,
    AnimateClearColor
};
} // namespace enAnimationProperty3D

CANDERA_INTERNAL_ENUM_METAINFO_BEGIN(::enAnimationProperty3D::Enum, _enAnimationProperty3D_Enum)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(AnimatePosition)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(AnimateRotation)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(AnimateDiffuseColor)
CANDERA_INTERNAL_ENUM_METAINFO_ITEM(AnimateClearColor)
CANDERA_INTERNAL_ENUM_METAINFO_END()

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enAnimationProperty3D::Enum >::Append(::FeatStd::StringBuffer& stringBuffer, ::enAnimationProperty3D::Enum const & object);
} // namespace FeatStd
#endif
// ------------------------------------------------------------------------
//! [AnimationWidget3DBase_Declaration]
class AnimationWidget3DBase : public BaseWidget3D
{
    public:
        typedef enAnimationProperty3D::Enum PropertyAnimationType;

        typedef Candera::Vector3 TargetValueType;

        typedef Candera::Color TargetColorType;

        typedef FeatStd::UInt32 DurationType;

        //! [Property_IDs]
        static const FeatStd::UInt32 PropertyAnimationPropertyId = 0xA4D5501C;
        static const FeatStd::UInt32 TargetValuePropertyId = 0xDADBBBCA;
        static const FeatStd::UInt32 TargetColorPropertyId = 0xE90428C2;
        static const FeatStd::UInt32 DurationPropertyId = 0x82C3352E;
        //! [Property_IDs]

        AnimationWidget3DBase();
        virtual ~AnimationWidget3DBase();

        CGI_WIDGET_RTTI_DECLARATION(AnimationWidget3DBase, BaseWidget3D);

        virtual void Update();

        void SetPropertyAnimation(const PropertyAnimationType& propertyanimation);
        const PropertyAnimationType& GetPropertyAnimation() const { return m_PropertyAnimation; }

        //! [DataBinding_TargetValuePropertyGetterSetter]
        void SetTargetValue(const TargetValueType& targetvalue);
        const TargetValueType& GetTargetValue() const { return m_TargetValue; }
        //! [DataBinding_TargetValuePropertyGetterSetter]

        //! [DataBinding_TargetColorPropertyGetterSetter]
        void SetTargetColor(const TargetColorType& targetcolor);
        const TargetColorType& GetTargetColor() const { return m_TargetColor; }
        //! [DataBinding_TargetColorPropertyGetterSetter]

        //! [DataBinding_DurationPropertyGetterSetter]
        void SetDuration(const DurationType& duration);
        const DurationType& GetDuration() const { return m_Duration; }
        //! [DataBinding_DurationPropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidgetDef(AnimationWidget3DBase, BaseWidget3D)
            CdaDescription("Provides support to create simple animations")
            CdaReadableName("AnimationWidget3DBase")
            CdaCategory("Animation")

            CdaProperties()
                CdaProperty(PropertyAnimation, PropertyAnimationType, GetPropertyAnimation, SetPropertyAnimation)
                    CdaDescription("Animation Type")
                    CdaCategory("Animation")
                CdaPropertyEnd()
                CdaBindableProperty(TargetValue, TargetValueType, GetTargetValue, SetTargetValue)
                    CdaDescription("Set the target value of animation")
                    CdaVisibilityTest(IsVector3Selected)
                    CdaCategory("Animation")
                CdaBindablePropertyEnd()
                CdaBindableProperty(TargetColor, TargetColorType, GetTargetColor, SetTargetColor)
                    CdaDescription("Set the target color of animation")
                    CdaVisibilityTest(IsColorSelected)
                    CdaCategory("Animation")
                CdaBindablePropertyEnd()
                CdaBindableProperty(Duration, DurationType, GetDuration, SetDuration)
                    CdaDescription("Set the duration of the animation")
                    CdaCategory("Animation")
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:
        bool IsColorSelected() const { return (GetPropertyAnimation() == enAnimationProperty3D::AnimateDiffuseColor || GetPropertyAnimation() == enAnimationProperty3D::AnimateClearColor); }
        bool IsVector3Selected() const { return (GetPropertyAnimation() == enAnimationProperty3D::AnimatePosition || GetPropertyAnimation() == enAnimationProperty3D::AnimateRotation); }

    private:
        PropertyAnimationType m_PropertyAnimation;
        TargetValueType m_TargetValue;
        TargetColorType m_TargetColor;
        DurationType m_Duration;

        ::FeatStd::Internal::Vector< ::FeatStd::UInt32 > m_ChangeSetAnimationWidget3DBase;
};

#endif // AnimationWidget3DBase_h
