/************************************************************************
*FILE: AnimationWidget3DBase.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ***************************************************************************************
 * FILE:          Generated intermediate file from HMIContract.exe
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  This file is part of HMI-Base Widget Library 
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "widget2D_std_if.h"

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "AnimationWidget3DBase.h"

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
template<> ::FeatStd::UInt32 StringBufferAppender< ::enAnimationProperty3D::Enum >::Append(::FeatStd::StringBuffer& stringBuffer, ::enAnimationProperty3D::Enum const & object)
{
    ::FeatStd::UInt32 tcharCount = 0;
    switch (object) {
        case ::enAnimationProperty3D::AnimatePosition:
            tcharCount += stringBuffer.Append("::enAnimationProperty3D::AnimatePosition");
            break;
        case ::enAnimationProperty3D::AnimateRotation:
            tcharCount += stringBuffer.Append("::enAnimationProperty3D::AnimateRotation");
            break;
        case ::enAnimationProperty3D::AnimateDiffuseColor:
            tcharCount += stringBuffer.Append("::enAnimationProperty3D::AnimateDiffuseColor");
            break;
        case ::enAnimationProperty3D::AnimateClearColor:
            tcharCount += stringBuffer.Append("::enAnimationProperty3D::AnimateClearColor");
            break;
        default:
            tcharCount += stringBuffer.Append("##unknown##");
            break;
    }
    return tcharCount;
}
}
#endif
// ------------------------------------------------------------------------
CGI_WIDGET_RTTI_DEFINITION(AnimationWidget3DBase)

AnimationWidget3DBase::AnimationWidget3DBase() :
    m_PropertyAnimation(enAnimationProperty3D::AnimatePosition),
    m_TargetValue(Candera::Vector3(0.0f, 0.0f, 0.0f)),
    m_TargetColor(Candera::Color(0.0f, 0.0f, 0.0f, 0.0f)),
    m_Duration(1000),
    m_ChangeSetAnimationWidget3DBase()
{
    if (!m_ChangeSetAnimationWidget3DBase.Reserve(1)) {
        FEATSTD_DEBUG_FAIL();
    }
}

AnimationWidget3DBase::~AnimationWidget3DBase()
{
}

void AnimationWidget3DBase::Update()
{
    Base::Update();
    while (!m_ChangeSetAnimationWidget3DBase.Empty()) {
        ::FeatStd::UInt32 propertyId = m_ChangeSetAnimationWidget3DBase[0];
        bool ok = m_ChangeSetAnimationWidget3DBase.Remove(0);
        FEATSTD_DEBUG_ASSERT(ok);
        OnChanged(propertyId);
        FEATSTD_UNUSED(ok);
    }
}

void AnimationWidget3DBase::SetPropertyAnimation(const PropertyAnimationType& propertyanimation)
{
    if (m_PropertyAnimation != propertyanimation) {
        m_PropertyAnimation = propertyanimation;
        if (!m_ChangeSetAnimationWidget3DBase.Contains(static_cast< ::FeatStd::UInt32>(PropertyAnimationPropertyId))) {
            if (!m_ChangeSetAnimationWidget3DBase.Add(static_cast< ::FeatStd::UInt32>(PropertyAnimationPropertyId))) {
                FEATSTD_DEBUG_FAIL();
            }
        }
        WakeUpAllRenderComponents();
    }
}

void AnimationWidget3DBase::SetTargetValue(const TargetValueType& targetvalue)
{
    if (m_TargetValue != targetvalue) {
        m_TargetValue = targetvalue;
        if (!m_ChangeSetAnimationWidget3DBase.Contains(static_cast< ::FeatStd::UInt32>(TargetValuePropertyId))) {
            if (!m_ChangeSetAnimationWidget3DBase.Add(static_cast< ::FeatStd::UInt32>(TargetValuePropertyId))) {
                FEATSTD_DEBUG_FAIL();
            }
        }
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("TargetValue");
        }
        WakeUpAllRenderComponents();
    }
}

void AnimationWidget3DBase::SetTargetColor(const TargetColorType& targetcolor)
{
    if (m_TargetColor != targetcolor) {
        m_TargetColor = targetcolor;
        if (!m_ChangeSetAnimationWidget3DBase.Contains(static_cast< ::FeatStd::UInt32>(TargetColorPropertyId))) {
            if (!m_ChangeSetAnimationWidget3DBase.Add(static_cast< ::FeatStd::UInt32>(TargetColorPropertyId))) {
                FEATSTD_DEBUG_FAIL();
            }
        }
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("TargetColor");
        }
        WakeUpAllRenderComponents();
    }
}

void AnimationWidget3DBase::SetDuration(const DurationType& duration)
{
    if (m_Duration != duration) {
        m_Duration = duration;
        if (!m_ChangeSetAnimationWidget3DBase.Contains(static_cast< ::FeatStd::UInt32>(DurationPropertyId))) {
            if (!m_ChangeSetAnimationWidget3DBase.Add(static_cast< ::FeatStd::UInt32>(DurationPropertyId))) {
                FEATSTD_DEBUG_FAIL();
            }
        }
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("Duration");
        }
        WakeUpAllRenderComponents();
    }
}
