/************************************************************************
*FILE: Touchable2DBase.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ***************************************************************************************
 * FILE:          Generated intermediate file from HMIContract.exe
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  This file is part of HMI-Base Widget Library 
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "widget2D_std_if.h"

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "Touchable2DBase.h"

// ------------------------------------------------------------------------
CGI_WIDGET_RTTI_DEFINITION(Touchable2DBase)

Touchable2DBase::Touchable2DBase() :
    m_Touchable(TouchableType()),
    m_TouchPriority(TouchPriorityType()),
    m_GestureConfigId(GestureConfigIdType()),
    m_Tap(false),
    m_DoubleTap(true),
    m_PressHold(true),
    m_PressRepeat(true),
    m_Drag(false),
    m_DragDirection(Candera::en2D),
    m_Swipe(false),
    m_SwipeDirection(Candera::enVertical),
    m_PinchSpread(false),
    m_Rotate(false),
    m_RawTouch(false),
    m_DragDropSourceEnabled(DragDropSourceEnabledType()),
    m_DragDropDestinationEnabled(DragDropDestinationEnabledType())
{
}

Touchable2DBase::~Touchable2DBase()
{
}

void Touchable2DBase::SetTouchable(const TouchableType& touchable)
{
    if (m_Touchable != touchable) {
        m_Touchable = touchable;
        OnChanged(static_cast< ::FeatStd::UInt32>(TouchablePropertyId));
    }
}

void Touchable2DBase::SetTouchPriority(const TouchPriorityType& touchpriority)
{
    if (m_TouchPriority != touchpriority) {
        m_TouchPriority = touchpriority;
        OnChanged(static_cast< ::FeatStd::UInt32>(TouchPriorityPropertyId));
    }
}

void Touchable2DBase::SetGestureConfigId(const GestureConfigIdType& gestureconfigid)
{
    if (m_GestureConfigId != gestureconfigid) {
        m_GestureConfigId = gestureconfigid;
    }
}

void Touchable2DBase::SetTap(const TapType& tap)
{
    if (m_Tap != tap) {
        m_Tap = tap;
    }
}

void Touchable2DBase::SetDoubleTap(const DoubleTapType& doubletap)
{
    if (m_DoubleTap != doubletap) {
        m_DoubleTap = doubletap;
    }
}

void Touchable2DBase::SetPressHold(const PressHoldType& presshold)
{
    if (m_PressHold != presshold) {
        m_PressHold = presshold;
    }
}

void Touchable2DBase::SetPressRepeat(const PressRepeatType& pressrepeat)
{
    if (m_PressRepeat != pressrepeat) {
        m_PressRepeat = pressrepeat;
    }
}

void Touchable2DBase::SetDrag(const DragType& drag)
{
    if (m_Drag != drag) {
        m_Drag = drag;
    }
}

void Touchable2DBase::SetDragDirection(const DragDirectionType& dragdirection)
{
    if (m_DragDirection != dragdirection) {
        m_DragDirection = dragdirection;
        OnChanged(static_cast< ::FeatStd::UInt32>(DragDirectionPropertyId));
    }
}

void Touchable2DBase::SetSwipe(const SwipeType& swipe)
{
    if (m_Swipe != swipe) {
        m_Swipe = swipe;
    }
}

void Touchable2DBase::SetSwipeDirection(const SwipeDirectionType& swipedirection)
{
    if (m_SwipeDirection != swipedirection) {
        m_SwipeDirection = swipedirection;
    }
}

void Touchable2DBase::SetPinchSpread(const PinchSpreadType& pinchspread)
{
    if (m_PinchSpread != pinchspread) {
        m_PinchSpread = pinchspread;
    }
}

void Touchable2DBase::SetRotate(const RotateType& rotate)
{
    if (m_Rotate != rotate) {
        m_Rotate = rotate;
    }
}

void Touchable2DBase::SetRawTouch(const RawTouchType& rawtouch)
{
    if (m_RawTouch != rawtouch) {
        m_RawTouch = rawtouch;
    }
}

void Touchable2DBase::SetDragDropSourceEnabled(const DragDropSourceEnabledType& dragdropsourceenabled)
{
    if (m_DragDropSourceEnabled != dragdropsourceenabled) {
        m_DragDropSourceEnabled = dragdropsourceenabled;
    }
}

void Touchable2DBase::SetDragDropDestinationEnabled(const DragDropDestinationEnabledType& dragdropdestinationenabled)
{
    if (m_DragDropDestinationEnabled != dragdropdestinationenabled) {
        m_DragDropDestinationEnabled = dragdropdestinationenabled;
    }
}
