/************************************************************************
*FILE: TimerWidget2DBase.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ***************************************************************************************
 * FILE:          Generated intermediate file from HMIContract.exe
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  This file is part of HMI-Base Widget Library 
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "widget2D_std_if.h"

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "TimerWidget2DBase.h"

// ------------------------------------------------------------------------
CGI_WIDGET_RTTI_DEFINITION(TimerWidget2DBase)

TimerWidget2DBase::TimerWidget2DBase() :
    m_AutoStartEnabled(AutoStartEnabledType()),
    m_TimerDuration(TimerDurationType()),
    m_AutoRestartEnabled(AutoRestartEnabledType()),
    m_StartStopTrigger(StartStopTriggerType()),
    m_PauseTrigger(PauseTriggerType())
{
}

TimerWidget2DBase::~TimerWidget2DBase()
{
}

void TimerWidget2DBase::SetAutoStartEnabled(const AutoStartEnabledType& autostartenabled)
{
    if (m_AutoStartEnabled != autostartenabled) {
        m_AutoStartEnabled = autostartenabled;
        OnChanged(static_cast< ::FeatStd::UInt32>(AutoStartEnabledPropertyId));
    }
}

void TimerWidget2DBase::SetTimerDuration(const TimerDurationType& timerduration)
{
    if (m_TimerDuration != timerduration) {
        m_TimerDuration = timerduration;
        OnChanged(static_cast< ::FeatStd::UInt32>(TimerDurationPropertyId));
    }
}

void TimerWidget2DBase::SetAutoRestartEnabled(const AutoRestartEnabledType& autorestartenabled)
{
    if (m_AutoRestartEnabled != autorestartenabled) {
        m_AutoRestartEnabled = autorestartenabled;
        OnChanged(static_cast< ::FeatStd::UInt32>(AutoRestartEnabledPropertyId));
    }
}

void TimerWidget2DBase::SetStartStopTrigger(const StartStopTriggerType& startstoptrigger)
{
    m_StartStopTrigger = startstoptrigger;
    OnChanged(static_cast< ::FeatStd::UInt32>(StartStopTriggerPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("StartStopTrigger");
    }
}

void TimerWidget2DBase::SetPauseTrigger(const PauseTriggerType& pausetrigger)
{
    m_PauseTrigger = pausetrigger;
    OnChanged(static_cast< ::FeatStd::UInt32>(PauseTriggerPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("PauseTrigger");
    }
}
