/************************************************************************
*FILE: TextHighlightWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(hmibase_widget_text_TextHighlightWidget2DBase_h)
#define hmibase_widget_text_TextHighlightWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/BaseWidget2D.h>
#include <Widgets/2D/TextHighlight/generated/TextHighlightWidget2DTypes.h>

namespace hmibase {
} // namespace hmibase
namespace hmibase {
namespace widget {
namespace text {
// ------------------------------------------------------------------------
//! [TextHighlightWidget2DBase_Declaration]
class TextHighlightWidget2DBase : public ::BaseWidget2D
{
    public:
        typedef Candera::Color ColorType;

        typedef enHighlightMode::Enum ModeType;

        typedef Candera::String TextType;

        //! [Property_IDs]
        static const FeatStd::UInt32 ColorPropertyId = 0x4E036667;
        static const FeatStd::UInt32 TextPropertyId = 0xB5A7CD47;
        //! [Property_IDs]

        TextHighlightWidget2DBase();
        virtual ~TextHighlightWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(TextHighlightWidget2DBase, ::BaseWidget2D);

        //! [DataBinding_ColorPropertyGetterSetter]
        void SetColor(const ColorType& color);
        const ColorType& GetColor() const { return m_Color; }
        //! [DataBinding_ColorPropertyGetterSetter]

        void SetMode(const ModeType& mode);
        const ModeType& GetMode() const { return m_Mode; }

        //! [DataBinding_TextPropertyGetterSetter]
        void SetText(const TextType& text);
        const TextType& GetText() const { return m_Text; }
        //! [DataBinding_TextPropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(TextHighlightWidget2DBase, ::BaseWidget2D)
            CdaDescription("UNDER DEVELOPMENT! Don't use this widget yet.\n Highlights segments from a text using the specified color. Attach this widget to a text render node.")
            CdaReadableName("TextHighlightWidget2DBase")
            CdaCategory("Under construction")

            CdaProperties()
                CdaBindableProperty(Color, ColorType, GetColor, SetColor)
                    CdaDescription("Color used for text highlight.")
                CdaBindablePropertyEnd()
                CdaProperty(Mode, ModeType, GetMode, SetMode)
                    CdaDescription("Mode : enHighlightMode::Enum")
                CdaPropertyEnd()
                CdaBindableProperty(Text, TextType, GetText, SetText)
                    CdaDescription("Configures text to be highlight.")
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        ColorType m_Color;
        ModeType m_Mode;
        TextType m_Text;
};
} // namespace text
} // namespace widget
} // namespace hmibase

#endif // hmibase_widget_text_TextHighlightWidget2DBase_h
