/************************************************************************
*FILE: TextAreaWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(TextAreaWidget2DBase_h)
#define TextAreaWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Courier/DataBinding/DataBinding.h>
#include <Widgets/2D/BaseWidget2D.h>
#include <Widgets/2D/RichTextBase/RichTextBaseWidget2D.h>
#include <Widgets/2D/Text/TextWidget2D.h>
//Start - Candera Style Enum
/* Description about TEXTWIDGET Mode Enum
* NORMAL - The default mode for the TextWidget2D
* INVISIBLE  - The Visibility of the TextBox will be set to false
* COLORFILL - The TextBox will be filled with color. Default - White
*/
#define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(TextWidgetMode)        \
        ENUM_DATA_TYPE_ITEM_VALUE(Normal, 0)    \
        ENUM_DATA_TYPE_ITEM_VALUE(Invisible, 1) \
        ENUM_DATA_TYPE_ITEM_VALUE(ColorFill, 2) \
        ENUM_DATA_TYPE_ITEM_VALUE(Active, 3) \
    ENUM_DATA_TYPE_END(TextWidgetMode)
#include <Candera/System/MetaInfo/EnumDataType.h>

// Enum data types
#define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(TruncationMode)  \
    ENUM_DATA_TYPE_ITEM(HardTruncation)   \
    ENUM_DATA_TYPE_ITEM(SoftTruncation)   \
    ENUM_DATA_TYPE_ITEM(TextTruncation)   \
    ENUM_DATA_TYPE_END(TruncationMode)
#include <Candera/System/MetaInfo/EnumDataType.h>

#define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(HighlightMode)  \
    ENUM_DATA_TYPE_ITEM(IndexMode)       \
    ENUM_DATA_TYPE_ITEM(TextMode)        \
    ENUM_DATA_TYPE_END(HighlightMode)
#include <Candera/System/MetaInfo/EnumDataType.h>
// ------------------------------------------------------------------------
//! [TextAreaWidget2DBase_Declaration]
class TextAreaWidget2DBase : public ::RichTextBaseWidget2D
{
    public:
        typedef Candera::TruncationMode TruncationModeType;

        typedef FeatStd::String TruncationTextType;

        typedef Candera::TextWidgetMode TextWidgetModeType;

        typedef Candera::UInt8 ItemOrderType;

        typedef Candera::Color DisabledTextColorType;

        typedef Candera::Color HighlightTextColorType;

        typedef Candera::Color ActiveTextColorType;

        typedef Candera::UInt16 ScrollSpeedType;

        typedef Candera::UInt16 ScrollStartDelayType;

        typedef Candera::UInt16 ScrollEndDelayType;

        typedef Candera::HighlightMode HighlightModeType;

        typedef Candera::UInt16 HighlightStartIndexType;

        typedef Candera::UInt16 HighlightCountType;

        typedef FeatStd::String HighlightTextType;

        typedef bool EnableDynamicTextType;

        typedef FeatStd::String TextParameter1Type;

        typedef FeatStd::String TextParameter2Type;

        typedef FeatStd::String TextParameter3Type;

        typedef FeatStd::String TextParameter4Type;

        typedef FeatStd::String TextParameter5Type;

        typedef FeatStd::String TextParameter6Type;

        typedef bool MultiLineLayoutingType;

        typedef Candera::Float LinespacingFactorType;

        typedef Candera::RT_TextWrapMode TextWrapModeType;

        typedef Candera::UInt16 MaximumNumberOfLinesType;

        //! [Property_IDs]
        static const FeatStd::UInt32 TruncationModePropertyId = 0xAEF8860F;
        static const FeatStd::UInt32 TruncationTextPropertyId = 0x979670E0;
        static const FeatStd::UInt32 TextWidgetModePropertyId = 0x3E5D1993;
        static const FeatStd::UInt32 ItemOrderPropertyId = 0xB178B191;
        static const FeatStd::UInt32 DisabledTextColorPropertyId = 0xA2474CE1;
        static const FeatStd::UInt32 HighlightTextColorPropertyId = 0x2F9CF1E3;
        static const FeatStd::UInt32 ActiveTextColorPropertyId = 0xCD2D090E;
        static const FeatStd::UInt32 ScrollSpeedPropertyId = 0x757705E7;
        static const FeatStd::UInt32 ScrollStartDelayPropertyId = 0x39B676BB;
        static const FeatStd::UInt32 ScrollEndDelayPropertyId = 0x6CA2F5F1;
        static const FeatStd::UInt32 HighlightModePropertyId = 0xA69B5DD6;
        static const FeatStd::UInt32 HighlightStartIndexPropertyId = 0xFFB3A28C;
        static const FeatStd::UInt32 HighlightCountPropertyId = 0x84CA15D0;
        static const FeatStd::UInt32 HighlightTextPropertyId = 0xB1384D7C;
        static const FeatStd::UInt32 EnableDynamicTextPropertyId = 0xFFC963D4;
        static const FeatStd::UInt32 TextParameter1PropertyId = 0x1C93D194;
        static const FeatStd::UInt32 TextParameter2PropertyId = 0x0CE23231;
        static const FeatStd::UInt32 TextParameter3PropertyId = 0x938E3F8B;
        static const FeatStd::UInt32 TextParameter4PropertyId = 0x7BFC1067;
        static const FeatStd::UInt32 TextParameter5PropertyId = 0xEE57751C;
        static const FeatStd::UInt32 TextParameter6PropertyId = 0xD88A4982;
        static const FeatStd::UInt32 MultiLineLayoutingPropertyId = 0x76E966BA;
        static const FeatStd::UInt32 LinespacingFactorPropertyId = 0x1719BC93;
        static const FeatStd::UInt32 TextWrapModePropertyId = 0x220B156F;
        static const FeatStd::UInt32 MaximumNumberOfLinesPropertyId = 0x776015EF;
        //! [Property_IDs]

        TextAreaWidget2DBase();
        virtual ~TextAreaWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(TextAreaWidget2DBase, ::RichTextBaseWidget2D);

        void SetTruncationMode(const TruncationModeType& truncationmode);
        const TruncationModeType& GetTruncationMode() const { return m_TruncationMode; }

        void SetTruncationText(const TruncationTextType& truncationtext);
        const TruncationTextType& GetTruncationText() const { return m_TruncationText; }

        //! [DataBinding_TextWidgetModePropertyGetterSetter]
        void SetTextWidgetMode(const TextWidgetModeType& textwidgetmode);
        const TextWidgetModeType& GetTextWidgetMode() const { return m_TextWidgetMode; }
        //! [DataBinding_TextWidgetModePropertyGetterSetter]

        void SetItemOrder(const ItemOrderType& itemorder);
        const ItemOrderType& GetItemOrder() const { return m_ItemOrder; }

        //! [DataBinding_DisabledTextColorPropertyGetterSetter]
        void SetDisabledTextColor(const DisabledTextColorType& disabledtextcolor);
        const DisabledTextColorType& GetDisabledTextColor() const { return m_DisabledTextColor; }
        //! [DataBinding_DisabledTextColorPropertyGetterSetter]

        //! [DataBinding_HighlightTextColorPropertyGetterSetter]
        void SetHighlightTextColor(const HighlightTextColorType& highlighttextcolor);
        const HighlightTextColorType& GetHighlightTextColor() const { return m_HighlightTextColor; }
        //! [DataBinding_HighlightTextColorPropertyGetterSetter]

        //! [DataBinding_ActiveTextColorPropertyGetterSetter]
        void SetActiveTextColor(const ActiveTextColorType& activetextcolor);
        const ActiveTextColorType& GetActiveTextColor() const { return m_ActiveTextColor; }
        //! [DataBinding_ActiveTextColorPropertyGetterSetter]

        //! [DataBinding_ScrollSpeedPropertyGetterSetter]
        void SetScrollSpeed(const ScrollSpeedType& scrollspeed);
        const ScrollSpeedType& GetScrollSpeed() const { return m_ScrollSpeed; }
        //! [DataBinding_ScrollSpeedPropertyGetterSetter]

        //! [DataBinding_ScrollStartDelayPropertyGetterSetter]
        void SetScrollStartDelay(const ScrollStartDelayType& scrollstartdelay);
        const ScrollStartDelayType& GetScrollStartDelay() const { return m_ScrollStartDelay; }
        //! [DataBinding_ScrollStartDelayPropertyGetterSetter]

        //! [DataBinding_ScrollEndDelayPropertyGetterSetter]
        void SetScrollEndDelay(const ScrollEndDelayType& scrollenddelay);
        const ScrollEndDelayType& GetScrollEndDelay() const { return m_ScrollEndDelay; }
        //! [DataBinding_ScrollEndDelayPropertyGetterSetter]

        //! [DataBinding_HighlightModePropertyGetterSetter]
        void SetHighlightMode(const HighlightModeType& highlightmode);
        const HighlightModeType& GetHighlightMode() const { return m_HighlightMode; }
        //! [DataBinding_HighlightModePropertyGetterSetter]

        //! [DataBinding_HighlightStartIndexPropertyGetterSetter]
        void SetHighlightStartIndex(const HighlightStartIndexType& highlightstartindex);
        const HighlightStartIndexType& GetHighlightStartIndex() const { return m_HighlightStartIndex; }
        //! [DataBinding_HighlightStartIndexPropertyGetterSetter]

        //! [DataBinding_HighlightCountPropertyGetterSetter]
        void SetHighlightCount(const HighlightCountType& highlightcount);
        const HighlightCountType& GetHighlightCount() const { return m_HighlightCount; }
        //! [DataBinding_HighlightCountPropertyGetterSetter]

        //! [DataBinding_HighlightTextPropertyGetterSetter]
        void SetHighlightText(const HighlightTextType& highlighttext);
        const HighlightTextType& GetHighlightText() const { return m_HighlightText; }
        //! [DataBinding_HighlightTextPropertyGetterSetter]

        //! [DataBinding_EnableDynamicTextPropertyGetterSetter]
        void SetEnableDynamicText(const EnableDynamicTextType& enabledynamictext);
        const EnableDynamicTextType& GetEnableDynamicText() const { return m_EnableDynamicText; }
        //! [DataBinding_EnableDynamicTextPropertyGetterSetter]

        //! [DataBinding_TextParameter1PropertyGetterSetter]
        void SetTextParameter1(const TextParameter1Type& textparameter1);
        const TextParameter1Type& GetTextParameter1() const { return m_TextParameter1; }
        //! [DataBinding_TextParameter1PropertyGetterSetter]

        //! [DataBinding_TextParameter2PropertyGetterSetter]
        void SetTextParameter2(const TextParameter2Type& textparameter2);
        const TextParameter2Type& GetTextParameter2() const { return m_TextParameter2; }
        //! [DataBinding_TextParameter2PropertyGetterSetter]

        //! [DataBinding_TextParameter3PropertyGetterSetter]
        void SetTextParameter3(const TextParameter3Type& textparameter3);
        const TextParameter3Type& GetTextParameter3() const { return m_TextParameter3; }
        //! [DataBinding_TextParameter3PropertyGetterSetter]

        //! [DataBinding_TextParameter4PropertyGetterSetter]
        void SetTextParameter4(const TextParameter4Type& textparameter4);
        const TextParameter4Type& GetTextParameter4() const { return m_TextParameter4; }
        //! [DataBinding_TextParameter4PropertyGetterSetter]

        //! [DataBinding_TextParameter5PropertyGetterSetter]
        void SetTextParameter5(const TextParameter5Type& textparameter5);
        const TextParameter5Type& GetTextParameter5() const { return m_TextParameter5; }
        //! [DataBinding_TextParameter5PropertyGetterSetter]

        //! [DataBinding_TextParameter6PropertyGetterSetter]
        void SetTextParameter6(const TextParameter6Type& textparameter6);
        const TextParameter6Type& GetTextParameter6() const { return m_TextParameter6; }
        //! [DataBinding_TextParameter6PropertyGetterSetter]

        void SetMultiLineLayouting(const MultiLineLayoutingType& multilinelayouting);
        const MultiLineLayoutingType& GetMultiLineLayouting() const { return m_MultiLineLayouting; }

        void SetLinespacingFactor(const LinespacingFactorType& linespacingfactor);
        const LinespacingFactorType& GetLinespacingFactor() const { return m_LinespacingFactor; }

        void SetTextWrapMode(const TextWrapModeType& textwrapmode);
        const TextWrapModeType& GetTextWrapMode() const { return m_TextWrapMode; }

        void SetMaximumNumberOfLines(const MaximumNumberOfLinesType& maximumnumberoflines);
        const MaximumNumberOfLinesType& GetMaximumNumberOfLines() const { return m_MaximumNumberOfLines; }

        // @WidgetBaseClass
        CdaWidget2DDef(TextAreaWidget2DBase, ::RichTextBaseWidget2D)
            CdaDescription("Renders formated text into a given area.")
            CdaReadableName("TextAreaWidget2DBase")
            CdaCategory("Text")

            CdaProperties()
                CdaProperty(TruncationMode, TruncationModeType, GetTruncationMode, SetTruncationMode)
                    CdaDescription("Text truncation method. Truncation is only active if the text size is bigger than 0. HardTruncation: Characters are cut off hard on text size boundries. SoftTruncation: Only completely fitting characters are displayed. TextTruncation: None fitting characters are substituted with the truncation text.")
                    CdaCategory("Truncation")
                CdaPropertyEnd()
                CdaProperty(TruncationText, TruncationTextType, GetTruncationText, SetTruncationText)
                    CdaDescription("Truncation text to be rendered.")
                    CdaCategory("Truncation")
                CdaPropertyEnd()
                CdaBindableProperty(TextWidgetMode, TextWidgetModeType, GetTextWidgetMode, SetTextWidgetMode)
                    CdaDescription("The widget mode Normal - default mode, Invisible - the text box is not displayed, ColorFill - TextBox is filled with Color, Active - ActiveColor is used")
                    CdaCategory("Mode")
                CdaBindablePropertyEnd()
                CdaProperty(ItemOrder, ItemOrderType, GetItemOrder, SetItemOrder)
                    CdaDescription("Item order for widget which would be useful inside a list.")
                    CdaCategory("Item")
                CdaPropertyEnd()
                CdaBindableProperty(DisabledTextColor, DisabledTextColorType, GetDisabledTextColor, SetDisabledTextColor)
                    CdaDescription("Color to be used to display the text in disabled state.")
                    CdaCategory("Color")
                CdaBindablePropertyEnd()
                CdaBindableProperty(HighlightTextColor, HighlightTextColorType, GetHighlightTextColor, SetHighlightTextColor)
                    CdaDescription("Color for highlighted text characters.")
                    CdaCategory("Color")
                CdaBindablePropertyEnd()
                CdaBindableProperty(ActiveTextColor, ActiveTextColorType, GetActiveTextColor, SetActiveTextColor)
                    CdaDescription("Color to be used to display the text in active state.")
                    CdaCategory("Color")
                CdaBindablePropertyEnd()
                CdaBindableProperty(ScrollSpeed, ScrollSpeedType, GetScrollSpeed, SetScrollSpeed)
                    CdaDescription("Scroll speed in pixel per seconds.")
                    CdaCategory("Scrolling")
                CdaBindablePropertyEnd()
                CdaBindableProperty(ScrollStartDelay, ScrollStartDelayType, GetScrollStartDelay, SetScrollStartDelay)
                    CdaDescription("Delay before the scrolling is started in milliseconds after receiving the start event.")
                    CdaCategory("Scrolling")
                CdaBindablePropertyEnd()
                CdaBindableProperty(ScrollEndDelay, ScrollEndDelayType, GetScrollEndDelay, SetScrollEndDelay)
                    CdaDescription("Delay after the scrolling reached the end position in milliseconds before jumping to the normal position.")
                    CdaCategory("Scrolling")
                CdaBindablePropertyEnd()
                CdaBindableProperty(HighlightMode, HighlightModeType, GetHighlightMode, SetHighlightMode)
                    CdaDescription("Switch between start/count and string based highlighting.")
                    CdaCategory("Highlighting")
                CdaBindablePropertyEnd()
                CdaBindableProperty(HighlightStartIndex, HighlightStartIndexType, GetHighlightStartIndex, SetHighlightStartIndex)
                    CdaDescription("The index of the character where the highlighting starts. This property is ignored if HighlightText is set.")
                    CdaCategory("Highlighting")
                CdaBindablePropertyEnd()
                CdaBindableProperty(HighlightCount, HighlightCountType, GetHighlightCount, SetHighlightCount)
                    CdaDescription("The number of the characters which are highlighted. This property is ignored if HighlightText is set.")
                    CdaCategory("Highlighting")
                CdaBindablePropertyEnd()
                CdaBindableProperty(HighlightText, HighlightTextType, GetHighlightText, SetHighlightText)
                    CdaDescription("Sub-string of the set text which should be highlighted. Only the first occurrance will be highlighted.")
                    CdaCategory("Highlighting")
                CdaBindablePropertyEnd()
                CdaBindableProperty(EnableDynamicText, EnableDynamicTextType, GetEnableDynamicText, SetEnableDynamicText)
                    CdaDescription("Enables dynamic text processing.")
                    CdaCategory("Dynamic Text")
                CdaBindablePropertyEnd()
                CdaBindableProperty(TextParameter1, TextParameter1Type, GetTextParameter1, SetTextParameter1)
                    CdaDescription("This text will replace any '%1' found in the text string. Use '%%x' to write '%x'.")
                    CdaCategory("Dynamic Text")
                CdaBindablePropertyEnd()
                CdaBindableProperty(TextParameter2, TextParameter2Type, GetTextParameter2, SetTextParameter2)
                    CdaDescription("This text will replace any '%2' found in the text string. Use '%%x' to write '%x'.")
                    CdaCategory("Dynamic Text")
                CdaBindablePropertyEnd()
                CdaBindableProperty(TextParameter3, TextParameter3Type, GetTextParameter3, SetTextParameter3)
                    CdaDescription("This text will replace any '%3' found in the text string. Use '%%x' to write '%x'.")
                    CdaCategory("Dynamic Text")
                CdaBindablePropertyEnd()
                CdaBindableProperty(TextParameter4, TextParameter4Type, GetTextParameter4, SetTextParameter4)
                    CdaDescription("This text will replace any '%4' found in the text string. Use '%%x' to write '%x'.")
                    CdaCategory("Dynamic Text")
                CdaBindablePropertyEnd()
                CdaBindableProperty(TextParameter5, TextParameter5Type, GetTextParameter5, SetTextParameter5)
                    CdaDescription("This text will replace any '%5' found in the text string. Use '%%x' to write '%x'.")
                    CdaCategory("Dynamic Text")
                CdaBindablePropertyEnd()
                CdaBindableProperty(TextParameter6, TextParameter6Type, GetTextParameter6, SetTextParameter6)
                    CdaDescription("This text will replace any '%6' found in the text string. Use '%%x' to write '%x'.")
                    CdaCategory("Dynamic Text")
                CdaBindablePropertyEnd()
                CdaProperty(MultiLineLayouting, MultiLineLayoutingType, GetMultiLineLayouting, SetMultiLineLayouting)
                    CdaDescription("Sets the property of MultiLineLayouting to show content in multiple lines")
                    CdaCategory("Alignment")
                CdaPropertyEnd()
                CdaProperty(LinespacingFactor, LinespacingFactorType, GetLinespacingFactor, SetLinespacingFactor)
                    CdaDescription("LineSpacing used e.g. buttons with two lines, a value of one is the font height")
                    CdaCategory("Alignment")
                CdaPropertyEnd()
                CdaProperty(TextWrapMode, TextWrapModeType, GetTextWrapMode, SetTextWrapMode)
                    CdaDescription("Controlls how to long lines should be wrapped. RT_WrapNone: No wrapping happens. RT_WrapWords: Whole words will be wrapped. If the word doesn't fit inside an empty line RT_WrapCharacters will be used. RT_WrapCharacters: Individual characters will be wrapped. If no character fits an empty line at least one will be drawn.")
                    CdaCategory("Alignment")
                CdaPropertyEnd()
                CdaProperty(MaximumNumberOfLines, MaximumNumberOfLinesType, GetMaximumNumberOfLines, SetMaximumNumberOfLines)
                    CdaDescription("Maximum Number Of Lines, default is one.")
                    CdaCategory("Alignment")
                CdaPropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        TruncationModeType m_TruncationMode;
        TruncationTextType m_TruncationText;
        TextWidgetModeType m_TextWidgetMode;
        ItemOrderType m_ItemOrder;
        DisabledTextColorType m_DisabledTextColor;
        HighlightTextColorType m_HighlightTextColor;
        ActiveTextColorType m_ActiveTextColor;
        ScrollSpeedType m_ScrollSpeed;
        ScrollStartDelayType m_ScrollStartDelay;
        ScrollEndDelayType m_ScrollEndDelay;
        HighlightModeType m_HighlightMode;
        HighlightStartIndexType m_HighlightStartIndex;
        HighlightCountType m_HighlightCount;
        HighlightTextType m_HighlightText;
        EnableDynamicTextType m_EnableDynamicText;
        TextParameter1Type m_TextParameter1;
        TextParameter2Type m_TextParameter2;
        TextParameter3Type m_TextParameter3;
        TextParameter4Type m_TextParameter4;
        TextParameter5Type m_TextParameter5;
        TextParameter6Type m_TextParameter6;
        MultiLineLayoutingType m_MultiLineLayouting;
        LinespacingFactorType m_LinespacingFactor;
        TextWrapModeType m_TextWrapMode;
        MaximumNumberOfLinesType m_MaximumNumberOfLines;
};

#endif // TextAreaWidget2DBase_h
