/************************************************************************
*FILE: StepAnimationWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(StepAnimationWidget2DBase_h)
#define StepAnimationWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/BaseWidget2D.h>
#include <Widgets/2D/Animation/generated/AnimationWidget2DBase.h>
#include <CanderaWidget/String/String.h>
// ------------------------------------------------------------------------
//! [StepAnimationWidget2DBase_Declaration]
class StepAnimationWidget2DBase : public ::BaseWidget2D
{
    public:
        typedef Candera::enAnimationPropertySetter PropertyAnimationType;

        typedef Candera::WidgetBase* AnimatedWidgetType;

        typedef Candera::String WidgetPropertyType;

        typedef Candera::UInt8 ChannelCountType;

        typedef bool ShouldRunType;

        typedef Candera::UInt8 SharedTimerInstanceType;

        typedef Candera::UInt32 TimerDelayType;

        typedef Candera::Int32 EndKeyframeIndexType;

        //! [Property_IDs]
        static const FeatStd::UInt32 PropertyAnimationPropertyId = 0xA4D5501C;
        static const FeatStd::UInt32 ChannelCountPropertyId = 0xF27169B9;
        static const FeatStd::UInt32 ShouldRunPropertyId = 0xC90F056A;
        static const FeatStd::UInt32 SharedTimerInstancePropertyId = 0x1D1EC66E;
        static const FeatStd::UInt32 TimerDelayPropertyId = 0x8CC6EB65;
        static const FeatStd::UInt32 EndKeyframeIndexPropertyId = 0xDFEA0078;
        //! [Property_IDs]

        StepAnimationWidget2DBase();
        virtual ~StepAnimationWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(StepAnimationWidget2DBase, ::BaseWidget2D);

        void SetPropertyAnimation(const PropertyAnimationType& propertyanimation);
        const PropertyAnimationType& GetPropertyAnimation() const { return m_PropertyAnimation; }

        void SetAnimatedWidget(const AnimatedWidgetType& animatedwidget);
        const AnimatedWidgetType& GetAnimatedWidget() const { return m_AnimatedWidget; }
        AnimatedWidgetType& GetAnimatedWidget() { return m_AnimatedWidget; }

        void SetWidgetProperty(const WidgetPropertyType& widgetproperty);
        const WidgetPropertyType& GetWidgetProperty() const { return m_WidgetProperty; }
        WidgetPropertyType& GetWidgetProperty() { return m_WidgetProperty; }

        void SetChannelCount(const ChannelCountType& channelcount);
        const ChannelCountType& GetChannelCount() const { return m_ChannelCount; }

        //! [DataBinding_ShouldRunPropertyGetterSetter]
        void SetShouldRun(const ShouldRunType& shouldrun);
        const ShouldRunType& GetShouldRun() const { return m_ShouldRun; }
        //! [DataBinding_ShouldRunPropertyGetterSetter]

        //! [DataBinding_SharedTimerInstancePropertyGetterSetter]
        void SetSharedTimerInstance(const SharedTimerInstanceType& sharedtimerinstance);
        const SharedTimerInstanceType& GetSharedTimerInstance() const { return m_SharedTimerInstance; }
        //! [DataBinding_SharedTimerInstancePropertyGetterSetter]

        //! [DataBinding_TimerDelayPropertyGetterSetter]
        void SetTimerDelay(const TimerDelayType& timerdelay);
        const TimerDelayType& GetTimerDelay() const { return m_TimerDelay; }
        //! [DataBinding_TimerDelayPropertyGetterSetter]

        //! [DataBinding_EndKeyframeIndexPropertyGetterSetter]
        void SetEndKeyframeIndex(const EndKeyframeIndexType& endkeyframeindex);
        const EndKeyframeIndexType& GetEndKeyframeIndex() const { return m_EndKeyframeIndex; }
        //! [DataBinding_EndKeyframeIndexPropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(StepAnimationWidget2DBase, ::BaseWidget2D)
            CdaDescription("Provides support to animate properties with discrete values. This has the advantage that update is not performed continously resulting in reduced CPU usage. It is suited for wait animations, blink animations and other situations when animations have to run for a longer time. The widget uses a timer to trigger the updates and this timer can be shared between multiple instances so they all update in the same time.")
            CdaReadableName("StepAnimationWidget2DBase")
            CdaCategory("Animation")

            CdaProperties()
                CdaProperty(PropertyAnimation, PropertyAnimationType, GetPropertyAnimation, SetPropertyAnimation)
                    CdaDescription("Identifies the property which has to be animated. Additional information is required for widget properties.")
                    CdaCategory("Animation")
                CdaPropertyEnd()
                CdaProperty(AnimatedWidget, AnimatedWidgetType, GetAnimatedWidget, SetAnimatedWidget)
                    CdaDescription("Widget to be animated.")
                    CdaVisibilityTest(isWidgetPropertyVisible)
                    CdaCategory("Animation")
                CdaPropertyEnd()
                CdaProperty(WidgetProperty, WidgetPropertyType, GetWidgetProperty, SetWidgetProperty)
                    CdaDescription("Widget property to be animated.")
                    CdaVisibilityTest(isWidgetPropertyVisible)
                    CdaCategory("Animation")
                CdaPropertyEnd()
                CdaProperty(ChannelCount, ChannelCountType, GetChannelCount, SetChannelCount)
                    CdaDescription("Channel count specifies how many values are required for each keyframe. Depending on the type of the animated property the number of values for each keyframe is between 1 and 4. \n1 value is required for simple types (bool, int, float);  \n2 values are required for Vector2;  \n3 values are required for Vector3;  \n4 values are required for Color, Rectangle and Margin; \nFor example if it is required to animate a property of type Vector2, the ChannelCount must be specified as 2 so that 2 values will be required for each keyframe (values at positions 0 and 1 are for the first keyframe and so on).")
                    CdaVisibilityTest(isWidgetPropertyVisible)
                    CdaCategory("Animation")
                CdaPropertyEnd()
                CdaBindableProperty(ShouldRun, ShouldRunType, GetShouldRun, SetShouldRun)
                    CdaDescription("Animation runs when this property is enabled.")
                    CdaCategory("Animation")
                CdaBindablePropertyEnd()
                CdaBindableProperty(SharedTimerInstance, SharedTimerInstanceType, GetSharedTimerInstance, SetSharedTimerInstance)
                    CdaDescription("Identifies the shared instance of the internal timer. Within the same scene all widgets can use the same timer instance so that they are updated in the same time.")
                    CdaCategory("Animation")
                CdaBindablePropertyEnd()
                CdaBindableProperty(TimerDelay, TimerDelayType, GetTimerDelay, SetTimerDelay)
                    CdaDescription("Timeout used by the timer. If multiple widgets share the same timer, only the timeout value of the first started animation will be used.")
                    CdaCategory("Animation")
                CdaBindablePropertyEnd()
                CdaBindableProperty(EndKeyframeIndex, EndKeyframeIndexType, GetEndKeyframeIndex, SetEndKeyframeIndex)
                    CdaDescription("Index of the keyframe which will be set when the animation is stopped. Useful for blink animations where the final node state should be visble.")
                    CdaCategory("Animation")
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
              bool isWidgetPropertyVisible() const { return (GetPropertyAnimation() == Candera::AnimateWidgetProperty); }
        PropertyAnimationType m_PropertyAnimation;
        AnimatedWidgetType m_AnimatedWidget;
        WidgetPropertyType m_WidgetProperty;
        ChannelCountType m_ChannelCount;
        ShouldRunType m_ShouldRun;
        SharedTimerInstanceType m_SharedTimerInstance;
        TimerDelayType m_TimerDelay;
        EndKeyframeIndexType m_EndKeyframeIndex;
};

#endif // StepAnimationWidget2DBase_h
