/************************************************************************
*FILE: StepAnimationWidget2DBase.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ***************************************************************************************
 * FILE:          Generated intermediate file from HMIContract.exe
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  This file is part of HMI-Base Widget Library 
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "widget2D_std_if.h"

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "StepAnimationWidget2DBase.h"

// ------------------------------------------------------------------------
CGI_WIDGET_RTTI_DEFINITION(StepAnimationWidget2DBase)

StepAnimationWidget2DBase::StepAnimationWidget2DBase() :
    m_PropertyAnimation(Candera::AnimateRotation),
    m_AnimatedWidget(AnimatedWidgetType()),
    m_WidgetProperty("Index"),
    m_ChannelCount(1),
    m_ShouldRun(true),
    m_SharedTimerInstance(SharedTimerInstanceType()),
    m_TimerDelay(100),
    m_EndKeyframeIndex(-1)
{
}

StepAnimationWidget2DBase::~StepAnimationWidget2DBase()
{
}

void StepAnimationWidget2DBase::SetPropertyAnimation(const PropertyAnimationType& propertyanimation)
{
    if (m_PropertyAnimation != propertyanimation) {
        m_PropertyAnimation = propertyanimation;
        OnChanged(static_cast< ::FeatStd::UInt32>(PropertyAnimationPropertyId));
    }
}

void StepAnimationWidget2DBase::SetAnimatedWidget(const AnimatedWidgetType& animatedwidget)
{
    m_AnimatedWidget = animatedwidget;
}

void StepAnimationWidget2DBase::SetWidgetProperty(const WidgetPropertyType& widgetproperty)
{
    m_WidgetProperty = widgetproperty;
}

void StepAnimationWidget2DBase::SetChannelCount(const ChannelCountType& channelcount)
{
    if (m_ChannelCount != channelcount) {
        m_ChannelCount = channelcount;
        OnChanged(static_cast< ::FeatStd::UInt32>(ChannelCountPropertyId));
    }
}

void StepAnimationWidget2DBase::SetShouldRun(const ShouldRunType& shouldrun)
{
    if (m_ShouldRun != shouldrun) {
        m_ShouldRun = shouldrun;
        OnChanged(static_cast< ::FeatStd::UInt32>(ShouldRunPropertyId));
    }
}

void StepAnimationWidget2DBase::SetSharedTimerInstance(const SharedTimerInstanceType& sharedtimerinstance)
{
    if (m_SharedTimerInstance != sharedtimerinstance) {
        m_SharedTimerInstance = sharedtimerinstance;
        OnChanged(static_cast< ::FeatStd::UInt32>(SharedTimerInstancePropertyId));
    }
}

void StepAnimationWidget2DBase::SetTimerDelay(const TimerDelayType& timerdelay)
{
    if (m_TimerDelay != timerdelay) {
        m_TimerDelay = timerdelay;
        OnChanged(static_cast< ::FeatStd::UInt32>(TimerDelayPropertyId));
    }
}

void StepAnimationWidget2DBase::SetEndKeyframeIndex(const EndKeyframeIndexType& endkeyframeindex)
{
    if (m_EndKeyframeIndex != endkeyframeindex) {
        m_EndKeyframeIndex = endkeyframeindex;
        OnChanged(static_cast< ::FeatStd::UInt32>(EndKeyframeIndexPropertyId));
    }
}
