/************************************************************************
*FILE: SpellerWidget2DMessages.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(SpellerWidget2DMessages_h)
#define SpellerWidget2DMessages_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Courier/Messaging/Message.h>
#include <Widgets/generated/BaseWidgetMessages.h>
#include <Widgets/2D/Speller/generated/SpellerWidget2DTypes.h>
#include <CanderaWidget/String/String.h>
#include <Courier/Visualization/ViewScene.h>
#include <Widgets/2D/Speller/SpellerWidget2D_Constants.h>
// ------------------------------------------------------------------------
            /** Courier Message from Speller to notify the subscribers about the key pressed
            * - This message is fired only in Match mode. In Free mode, the character pressed is updated via DataBinding
            * - ViewId: corresponds to the view from where the message is fired
            * - Sender: corresponds to the widget instance which fires the message
            * - KeyChar: corresponds to the character which is pressed (will be changed to UCS4(UTF-32) encoded code point in future)
            */
class SpellerKeyPressed : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SpellerKeyPressed, ::Courier::Message, 0x136F01AA);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SpellerKeyPressed(::Courier::ViewId const & aViewId, ::Courier::Identifier const & aSender, Candera::String const & aKeyChar);
        virtual ~SpellerKeyPressed();

        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }
        ::Courier::Identifier const & GetSender() const { return mSender; }
        void SetSender(::Courier::Identifier const & value) { mSender = value; }
        Candera::String const & GetKeyChar() const { return mKeyChar; }
        void SetKeyChar(Candera::String const & value) { mKeyChar = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(SpellerKeyPressed);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSpellerKeyPressedMetaData;
        static ::Courier::Message::ModifiableMetadata mSpellerKeyPressedModifiableMetadata;
        static const ::Courier::ComponentId mSpellerKeyPressedSubscriberList[];

        ::Courier::ViewId mViewId;
        ::Courier::Identifier mSender;
        Candera::String mKeyChar;
};

// ------------------------------------------------------------------------
            /** Courier Message from Speller to notify the subscribers about the Control key pressed
            * - This message is applicable for both FreeMode and MatchMode Speller
            * - ViewId: corresponds to the view from where the message is fired
            * - Sender: corresponds to the widget instance which fires the message
            * - CtrlKeyChar: corresponds to the UCS4(UTF-32) encoded code point Control character which is pressed
            */
class SpellerCtrlKeyPressed : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SpellerCtrlKeyPressed, ::Courier::Message, 0x1B0C85CF);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        SpellerCtrlKeyPressed(::Courier::ViewId const & aViewId, ::Courier::Identifier const & aSender, Candera::UInt32 const & aCtrlKeyChar);
        virtual ~SpellerCtrlKeyPressed();

        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }
        ::Courier::Identifier const & GetSender() const { return mSender; }
        void SetSender(::Courier::Identifier const & value) { mSender = value; }
        Candera::UInt32 const & GetCtrlKeyChar() const { return mCtrlKeyChar; }
        void SetCtrlKeyChar(Candera::UInt32 const & value) { mCtrlKeyChar = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(SpellerCtrlKeyPressed);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSpellerCtrlKeyPressedMetaData;
        static ::Courier::Message::ModifiableMetadata mSpellerCtrlKeyPressedModifiableMetadata;
        static const ::Courier::ComponentId mSpellerCtrlKeyPressedSubscriberList[];

        ::Courier::ViewId mViewId;
        ::Courier::Identifier mSender;
        Candera::UInt32 mCtrlKeyChar;
};

// ------------------------------------------------------------------------
            /** Courier Message which Speller expects when its child-button is explicitly disabled by external source dynamically.
            * - This message notifies Speller to re-evaluate the focus handling (if required).
            * - Do note that this message is applicable only for FreeMode Speller and should not never be fired in MatchMode Speller -
            * - as the focus handling in MatchMode will always be re-evaluated on receiving the update for ValidCharSet.
            */
class SpellerStatusChangedUpdMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SpellerStatusChangedUpdMsg, ::Courier::Message, 0x3E834A6F);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        SpellerStatusChangedUpdMsg(::Courier::ViewId const & aViewId, ::Courier::Identifier const & aSender, ::Courier::ViewId const & aLayoutId);
        virtual ~SpellerStatusChangedUpdMsg();

        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }
        ::Courier::Identifier const & GetSender() const { return mSender; }
        void SetSender(::Courier::Identifier const & value) { mSender = value; }
        ::Courier::ViewId const & GetLayoutId() const { return mLayoutId; }
        void SetLayoutId(::Courier::ViewId const & value) { mLayoutId = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(SpellerStatusChangedUpdMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSpellerStatusChangedUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSpellerStatusChangedUpdMsgModifiableMetadata;
        static const ::Courier::ComponentId mSpellerStatusChangedUpdMsgSubscriberList[];

        ::Courier::ViewId mViewId;
        ::Courier::Identifier mSender;
        ::Courier::ViewId mLayoutId;
};

// ------------------------------------------------------------------------
               /** Courier Message to notify the status of a Sub Speller to the subscribers for the key pressed
               * - ViewId: corresponds to the view from where the message is fired
               * - Sender: corresponds to the widget instance which fires the message
               * - KeyChar: corresponds to the character which is pressed (will be changed to UCS4(UTF-32) encoded code point in future)
               * - Status: Sub Speller status like sub Speller shown, hidden etc
               */
class SubSpellerStatusUpdMsg : public ::hmibase::widget::SenderMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SubSpellerStatusUpdMsg, ::hmibase::widget::SenderMessage, 0x83938A4C);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(3);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        SubSpellerStatusUpdMsg();
        SubSpellerStatusUpdMsg(::Courier::ViewId const & aView, ::Courier::Identifier const & aSender, ::FeatStd::UInt32 const & aUserData, Candera::String const & aKeyChar, hmibase::widget::speller::enSubSpllerStatus::Enum const & aStatus);
        virtual ~SubSpellerStatusUpdMsg();

        Candera::String const & GetKeyChar() const { return mKeyChar; }
        void SetKeyChar(Candera::String const & value) { mKeyChar = value; }
        hmibase::widget::speller::enSubSpllerStatus::Enum const & GetStatus() const { return mStatus; }
        void SetStatus(hmibase::widget::speller::enSubSpllerStatus::Enum const & value) { mStatus = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSubSpellerStatusUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSubSpellerStatusUpdMsgModifiableMetadata;
        static ::Courier::ComponentId mSubSpellerStatusUpdMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        Candera::String mKeyChar;
        hmibase::widget::speller::enSubSpllerStatus::Enum mStatus;
};

#endif // SpellerWidget2DMessages_h
