/************************************************************************
*FILE: SpellerWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(SpellerWidget2DBase_h)
#define SpellerWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/Speller/generated/SpellerWidget2DMessages.h>
#include <Widgets/2D/Touchable2D.h>
#include <Widgets/2D/Speller/SpellerWidget2D_Constants.h>
#include <CanderaWidget/String/String.h>
#include <CanderaWidget/WidgetBase/StringDataTypes.h>
// ------------------------------------------------------------------------
//! [SpellerWidget2DBase_Declaration]
class SpellerWidget2DBase : public ::Touchable2D
{
    public:
							virtual bool IsSpellerInMatchMode() const { return (1 == GetMode()); }
        typedef Candera::enSpellerMode ModeType;

        typedef Candera::enSpellerType TypeType;

        typedef Candera::String UserDefinedSequenceType;

        typedef bool ZeroKeyLongPressedType;

        typedef Candera::String SpellerScenesPathType;

        typedef bool ConfigureSpellerScenesType;

        typedef bool UseOnlyButtonsWithTextType;

        typedef Candera::UInt32 ActiveLanguageType;

        typedef  Candera::UInt32 ActiveCountryType;

        typedef Candera::String ValidCharSetType;

        typedef Candera::enKeypadFormat KeypadFormatType;

        typedef bool AllCharLayoutDisableType;

        typedef Candera::String SpellerKeyPressedType;

        typedef bool AutoLayoutToggleType;

        typedef Candera::UInt32 ActivateLayoutIndexType;

        //! [Property_IDs]
        static const FeatStd::UInt32 ModePropertyId = 0x86B8EEAD;
        static const FeatStd::UInt32 TypePropertyId = 0xEF3665C9;
        static const FeatStd::UInt32 UserDefinedSequencePropertyId = 0x636A4182;
        static const FeatStd::UInt32 ZeroKeyLongPressedPropertyId = 0x5479E4ED;
        static const FeatStd::UInt32 SpellerScenesPathPropertyId = 0x15CE7DA7;
        static const FeatStd::UInt32 ConfigureSpellerScenesPropertyId = 0x14ACEE2E;
        static const FeatStd::UInt32 ActiveLanguagePropertyId = 0x8F91A94A;
        static const FeatStd::UInt32 ActiveCountryPropertyId = 0x789815A0;
        static const FeatStd::UInt32 ValidCharSetPropertyId = 0xE9042B8F;
        static const FeatStd::UInt32 KeypadFormatPropertyId = 0x0D63C75B;
        static const FeatStd::UInt32 AllCharLayoutDisablePropertyId = 0xE58C227D;
        static const FeatStd::UInt32 SpellerKeyPressedPropertyId = 0x136F01AA;
        static const FeatStd::UInt32 AutoLayoutTogglePropertyId = 0x872887B6;
        static const FeatStd::UInt32 ActivateLayoutIndexPropertyId = 0x4AA7649B;
        //! [Property_IDs]

        SpellerWidget2DBase();
        virtual ~SpellerWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(SpellerWidget2DBase, ::Touchable2D);

        void SetMode(const ModeType& mode);
        const ModeType& GetMode() const { return m_Mode; }

        void SetType(const TypeType& type);
        const TypeType& GetType() const { return m_Type; }

        void SetUserDefinedSequence(const UserDefinedSequenceType& userdefinedsequence);
        const UserDefinedSequenceType& GetUserDefinedSequence() const { return m_UserDefinedSequence; }

        void SetZeroKeyLongPressed(const ZeroKeyLongPressedType& zerokeylongpressed);
        const ZeroKeyLongPressedType& GetZeroKeyLongPressed() const { return m_ZeroKeyLongPressed; }

        void SetSpellerScenesPath(const SpellerScenesPathType& spellerscenespath);
        const SpellerScenesPathType& GetSpellerScenesPath() const { return m_SpellerScenesPath; }

        void SetConfigureSpellerScenes(const ConfigureSpellerScenesType& configurespellerscenes);
        const ConfigureSpellerScenesType& GetConfigureSpellerScenes() const { return m_ConfigureSpellerScenes; }

        void SetUseOnlyButtonsWithText(const UseOnlyButtonsWithTextType& useonlybuttonswithtext);
        const UseOnlyButtonsWithTextType& GetUseOnlyButtonsWithText() const { return m_UseOnlyButtonsWithText; }

        //! [DataBinding_ActiveLanguagePropertyGetterSetter]
        void SetActiveLanguage(const ActiveLanguageType& activelanguage);
        const ActiveLanguageType& GetActiveLanguage() const { return m_ActiveLanguage; }
        //! [DataBinding_ActiveLanguagePropertyGetterSetter]

        //! [DataBinding_ActiveCountryPropertyGetterSetter]
        void SetActiveCountry(const ActiveCountryType& activecountry);
        const ActiveCountryType& GetActiveCountry() const { return m_ActiveCountry; }
        //! [DataBinding_ActiveCountryPropertyGetterSetter]

        //! [DataBinding_ValidCharSetPropertyGetterSetter]
        void SetValidCharSet(const ValidCharSetType& validcharset);
        const ValidCharSetType& GetValidCharSet() const { return m_ValidCharSet; }
        //! [DataBinding_ValidCharSetPropertyGetterSetter]

        //! [DataBinding_KeypadFormatPropertyGetterSetter]
        void SetKeypadFormat(const KeypadFormatType& keypadformat);
        const KeypadFormatType& GetKeypadFormat() const { return m_KeypadFormat; }
        //! [DataBinding_KeypadFormatPropertyGetterSetter]

        //! [DataBinding_AllCharLayoutDisablePropertyGetterSetter]
        void SetAllCharLayoutDisable(const AllCharLayoutDisableType& allcharlayoutdisable);
        const AllCharLayoutDisableType& GetAllCharLayoutDisable() const { return m_AllCharLayoutDisable; }
        //! [DataBinding_AllCharLayoutDisablePropertyGetterSetter]

        //! [DataBinding_SpellerKeyPressedPropertyGetterSetter]
        void SetSpellerKeyPressed(const SpellerKeyPressedType& spellerkeypressed);
        const SpellerKeyPressedType& GetSpellerKeyPressed() const { return m_SpellerKeyPressed; }
        //! [DataBinding_SpellerKeyPressedPropertyGetterSetter]

        //! [DataBinding_AutoLayoutTogglePropertyGetterSetter]
        void SetAutoLayoutToggle(const AutoLayoutToggleType& autolayouttoggle);
        const AutoLayoutToggleType& GetAutoLayoutToggle() const { return m_AutoLayoutToggle; }
        //! [DataBinding_AutoLayoutTogglePropertyGetterSetter]

        //! [DataBinding_ActivateLayoutIndexPropertyGetterSetter]
        void SetActivateLayoutIndex(const ActivateLayoutIndexType& activatelayoutindex);
        const ActivateLayoutIndexType& GetActivateLayoutIndex() const { return m_ActivateLayoutIndex; }
        //! [DataBinding_ActivateLayoutIndexPropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(SpellerWidget2DBase, ::Touchable2D)
            CdaDescription("SpellerWidget2D provides an on-screen keyboard to interact with user input")
            CdaReadableName("speller widget")
            CdaCategory("Input")

            CdaProperties()
                CdaProperty(Mode, ModeType, GetMode, SetMode)
                    CdaDescription("The SpellerMode - either FreeMode or MatchMode.")
                    CdaCategory("SpellerWidget2DPrivateProperty")
                CdaPropertyEnd()
                CdaProperty(Type, TypeType, GetType, SetType)
                    CdaDescription("Speller type.")
                    CdaCategory("SpellerWidget2DPrivateProperty")
                CdaPropertyEnd()
                CdaProperty(UserDefinedSequence, UserDefinedSequenceType, GetUserDefinedSequence, SetUserDefinedSequence)
                    CdaDescription("UserDefined Sequence")
                    CdaCategory("SpellerWidget2DPrivateProperty")
                CdaPropertyEnd()
                CdaProperty(ZeroKeyLongPressed, ZeroKeyLongPressedType, GetZeroKeyLongPressed, SetZeroKeyLongPressed)
                    CdaDescription("To update zero long press with '+' sign")
                    CdaCategory("SpellerWidget2DPrivateProperty")
                CdaPropertyEnd()
                CdaProperty(SpellerScenesPath, SpellerScenesPathType, GetSpellerScenesPath, SetSpellerScenesPath)
                    CdaDescription("All speller layout scenes should be in this Candera path.")
                    CdaCategory("SpellerWidget2DPrivateProperty")
                CdaPropertyEnd()
                CdaProperty(ConfigureSpellerScenes, ConfigureSpellerScenesType, GetConfigureSpellerScenes, SetConfigureSpellerScenes)
                    CdaDescription("Replace the render target of the cameras in the speller layout scenes with the one associated to the first camera in current scene.")
                    CdaCategory("SpellerWidget2DPrivateProperty")
                CdaPropertyEnd()
                CdaProperty(UseOnlyButtonsWithText, UseOnlyButtonsWithTextType, GetUseOnlyButtonsWithText, SetUseOnlyButtonsWithText)
                    CdaDescription("If enabled only the buttons which have a text widget will be used for the speller layout (legacy behaviour), otherwise all the buttons will be used allowing to use non text buttons for control/delete/space ")
                    CdaCategory("SpellerWidget2DPrivateProperty")
                CdaPropertyEnd()
                CdaBindableProperty(ActiveLanguage, ActiveLanguageType, GetActiveLanguage, SetActiveLanguage)
                    CdaDescription("Currently active language")
                    CdaCategory("SpellerWidget2DBindableProperty")
                CdaBindablePropertyEnd()
                CdaBindableProperty(ActiveCountry, ActiveCountryType, GetActiveCountry, SetActiveCountry)
                    CdaDescription("Name for the clock face image.")
                    CdaCategory("SpellerWidget2DBindableProperty")
                CdaBindablePropertyEnd()
                CdaBindableProperty(ValidCharSet, ValidCharSetType, GetValidCharSet, SetValidCharSet)
                    CdaDescription("Valid char set, requested by match mode")
                    CdaCategory("SpellerWidget2DBindableProperty")
                CdaBindablePropertyEnd()
                CdaBindableProperty(KeypadFormat, KeypadFormatType, GetKeypadFormat, SetKeypadFormat)
                    CdaDescription("Currently active keypad format - e.g. QWERTY or QBC.")
                    CdaCategory("SpellerWidget2DBindableProperty")
                CdaBindablePropertyEnd()
                CdaBindableProperty(AllCharLayoutDisable, AllCharLayoutDisableType, GetAllCharLayoutDisable, SetAllCharLayoutDisable)
                    CdaDescription("Disable all Char layout buttons")
                    CdaCategory("SpellerWidget2DBindableProperty")
                CdaBindablePropertyEnd()
                CdaBindableProperty(SpellerKeyPressed, SpellerKeyPressedType, GetSpellerKeyPressed, SetSpellerKeyPressed)
                    CdaDescription("To update EditField when Speller is in FreeMode.")
                    CdaCategory("SpellerWidget2DBindableProperty")
                CdaBindablePropertyEnd()
                CdaBindableProperty(AutoLayoutToggle, AutoLayoutToggleType, GetAutoLayoutToggle, SetAutoLayoutToggle)
                    CdaDescription("Auto Toggle Layout Based on ValidCharSet and layout sequence in Match Mode")
                    CdaVisibilityTest(IsSpellerInMatchMode)
                    CdaCategory("SpellerWidget2DBindableProperty")
                CdaBindablePropertyEnd()
                CdaBindableProperty(ActivateLayoutIndex, ActivateLayoutIndexType, GetActivateLayoutIndex, SetActivateLayoutIndex)
                    CdaDescription("The Layout Index which has to be shown currently")
                    CdaCategory("SpellerWidget2DBindableProperty")
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        ModeType m_Mode;
        TypeType m_Type;
        UserDefinedSequenceType m_UserDefinedSequence;
        ZeroKeyLongPressedType m_ZeroKeyLongPressed;
        SpellerScenesPathType m_SpellerScenesPath;
        ConfigureSpellerScenesType m_ConfigureSpellerScenes;
        UseOnlyButtonsWithTextType m_UseOnlyButtonsWithText;
        ActiveLanguageType m_ActiveLanguage;
        ActiveCountryType m_ActiveCountry;
        ValidCharSetType m_ValidCharSet;
        KeypadFormatType m_KeypadFormat;
        AllCharLayoutDisableType m_AllCharLayoutDisable;
        SpellerKeyPressedType m_SpellerKeyPressed;
        AutoLayoutToggleType m_AutoLayoutToggle;
        ActivateLayoutIndexType m_ActivateLayoutIndex;
};

#endif // SpellerWidget2DBase_h
