/************************************************************************
*FILE: SolidColorEffectWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(SolidColorEffectWidget2DBase_h)
#define SolidColorEffectWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/BaseWidget2D.h>
// ------------------------------------------------------------------------
//! [SolidColorEffectWidget2DBase_Declaration]
class SolidColorEffectWidget2DBase : public ::BaseWidget2D
{
    public:
        typedef Candera::Vector2 SizeType;

        typedef Candera::Color FillColorType;

        //! [Property_IDs]
        static const FeatStd::UInt32 SizePropertyId = 0xD1E4788A;
        static const FeatStd::UInt32 FillColorPropertyId = 0xF7C09B7B;
        //! [Property_IDs]

        SolidColorEffectWidget2DBase();
        virtual ~SolidColorEffectWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(SolidColorEffectWidget2DBase, ::BaseWidget2D);

        //! [DataBinding_SizePropertyGetterSetter]
        void SetSize(const SizeType& size);
        const SizeType& GetSize() const { return m_Size; }
        //! [DataBinding_SizePropertyGetterSetter]

        //! [DataBinding_FillColorPropertyGetterSetter]
        void SetFillColor(const FillColorType& fillcolor);
        const FillColorType& GetFillColor() const { return m_FillColor; }
        //! [DataBinding_FillColorPropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(SolidColorEffectWidget2DBase, ::BaseWidget2D)
            CdaDescription("Manipulates the Size and the FillColor properties of the existing SolidColorBrush effect of a RenderNode.")
            CdaReadableName("SolidColorEffectWidget2DBase")
            CdaCategory("Common")

            CdaProperties()
                CdaBindableProperty(Size, SizeType, GetSize, SetSize)
                    CdaDescription("Size to be set on the SolidColorBrush effect inside the RenderNode. The property value is not used if the X field or the Y field is less than zero.")
                CdaBindablePropertyEnd()
                CdaBindableProperty(FillColor, FillColorType, GetFillColor, SetFillColor)
                    CdaDescription("Fill color to be set on the SolidColorBrush effect inside the RenderNode.")
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        SizeType m_Size;
        FillColorType m_FillColor;
};

#endif // SolidColorEffectWidget2DBase_h
