/************************************************************************
*FILE: SliderWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(SliderWidget2DBase_h)
#define SliderWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/Slider/generated/SliderWidget2DTypes.h>
#include <Widgets/2D/Touchable2D.h>
// Enum data types
#define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(SliderOrientation)  \
    ENUM_DATA_TYPE_ITEM(HorizontalLeft)   \
    ENUM_DATA_TYPE_ITEM(HorizontalRight)   \
    ENUM_DATA_TYPE_ITEM(VerticalTop)   \
    ENUM_DATA_TYPE_ITEM(VerticalBottom)   \
    ENUM_DATA_TYPE_END(SliderOrientation)
#include <Candera/System/MetaInfo/EnumDataType.h>

#define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(MarkerMovement)  \
    ENUM_DATA_TYPE_ITEM(StepMovement)       \
    ENUM_DATA_TYPE_ITEM(DirectMovement)        \
    ENUM_DATA_TYPE_ITEM(TimedStepMovement)       \
    ENUM_DATA_TYPE_END(MarkerMovement)

#include <Candera/System/MetaInfo/EnumDataType.h>
// ------------------------------------------------------------------------
//! [SliderWidget2DBase_Declaration]
class SliderWidget2DBase : public ::Touchable2D
{
    public:
virtual bool ComposerPropFilterNumOfSteps() const { return (true && ComposerPropFilterNotProgressbarMode()); }
virtual bool ComposerPropFilterStepSize() const { return (false && ComposerPropFilterNotProgressbarMode()); }
virtual bool ComposerPropFilterFillerNodeConnected() const { return false; }
virtual bool ComposerPropFilterNotProgressbarMode() const { return true; }
virtual bool ComposerPropFilterNotAngularSlider() const { return true; }
virtual bool ComposerPropFilterIsMarkerSelectedBitmapConfigurable() const { return (ComposerPropFilterNotProgressbarMode() && ComposerPropFilterNotAngularSlider()); }
        typedef Candera::Node2D* SliderBackGroundType;

        typedef Candera::Node2D* MarkerNodeType;

        typedef Candera::Node2D* BitmapFillNodeType;

        typedef Candera::Float MinValType;

        typedef Candera::Float MaxValType;

        typedef Candera::Float CurrentValueType;

        typedef Candera::SliderOrientation SliderOrientationType;

        typedef Candera::Float PaddingMinValType;

        typedef Candera::Float PaddingMaxValType;

        typedef Candera::MarkerMovement MarkerMovementType;

        typedef bool UseNumofStepsType;

        typedef FeatStd::UInt16 NumOfStepsType;

        typedef FeatStd::Float StepSizeType;

        typedef Candera::Id MarkerNormalBitmapType;

        typedef Candera::Id MarkerSelectedBitmapType;

        typedef bool ContinuousUpdateOnDragType;

        typedef bool FillerPositionIsKnobCenterType;

        //! [Property_IDs]
        static const FeatStd::UInt32 SliderBackGroundPropertyId = 0xBB7EFE6A;
        static const FeatStd::UInt32 MarkerNodePropertyId = 0x856650D8;
        static const FeatStd::UInt32 BitmapFillNodePropertyId = 0x1528FC8F;
        static const FeatStd::UInt32 MinValPropertyId = 0x4419EF21;
        static const FeatStd::UInt32 MaxValPropertyId = 0xCDBD61F1;
        static const FeatStd::UInt32 CurrentValuePropertyId = 0x3F4BD799;
        static const FeatStd::UInt32 SliderOrientationPropertyId = 0x29ED0ACB;
        static const FeatStd::UInt32 PaddingMinValPropertyId = 0x8B82E815;
        static const FeatStd::UInt32 PaddingMaxValPropertyId = 0xDB7BA5A0;
        static const FeatStd::UInt32 MarkerMovementPropertyId = 0xE47218F1;
        static const FeatStd::UInt32 UseNumofStepsPropertyId = 0x07CF9001;
        static const FeatStd::UInt32 NumOfStepsPropertyId = 0x0ED3EC43;
        static const FeatStd::UInt32 StepSizePropertyId = 0x70E315C8;
        static const FeatStd::UInt32 MarkerNormalBitmapPropertyId = 0x33BEACE8;
        static const FeatStd::UInt32 MarkerSelectedBitmapPropertyId = 0x105BF00E;
        static const FeatStd::UInt32 ContinuousUpdateOnDragPropertyId = 0x28AC2394;
        static const FeatStd::UInt32 FillerPositionIsKnobCenterPropertyId = 0x90D15E3C;
        //! [Property_IDs]

        SliderWidget2DBase();
        virtual ~SliderWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(SliderWidget2DBase, ::Touchable2D);

        void SetSliderBackGround(const SliderBackGroundType& sliderbackground);
        const SliderBackGroundType& GetSliderBackGround() const { return m_SliderBackGround; }

        void SetMarkerNode(const MarkerNodeType& markernode);
        const MarkerNodeType& GetMarkerNode() const { return m_MarkerNode; }
        MarkerNodeType& GetMarkerNode() { return m_MarkerNode; }

        void SetBitmapFillNode(const BitmapFillNodeType& bitmapfillnode);
        const BitmapFillNodeType& GetBitmapFillNode() const { return m_BitmapFillNode; }

        //! [DataBinding_MinValPropertyGetterSetter]
        void SetMinVal(const MinValType& minval);
        const MinValType& GetMinVal() const { return m_MinVal; }
        //! [DataBinding_MinValPropertyGetterSetter]

        //! [DataBinding_MaxValPropertyGetterSetter]
        void SetMaxVal(const MaxValType& maxval);
        const MaxValType& GetMaxVal() const { return m_MaxVal; }
        //! [DataBinding_MaxValPropertyGetterSetter]

        //! [DataBinding_CurrentValuePropertyGetterSetter]
        void SetCurrentValue(const CurrentValueType& currentvalue);
        const CurrentValueType& GetCurrentValue() const { return m_CurrentValue; }
        //! [DataBinding_CurrentValuePropertyGetterSetter]

        void SetSliderOrientation(const SliderOrientationType& sliderorientation);
        const SliderOrientationType& GetSliderOrientation() const { return m_SliderOrientation; }

        void SetPaddingMinVal(const PaddingMinValType& paddingminval);
        const PaddingMinValType& GetPaddingMinVal() const { return m_PaddingMinVal; }

        void SetPaddingMaxVal(const PaddingMaxValType& paddingmaxval);
        const PaddingMaxValType& GetPaddingMaxVal() const { return m_PaddingMaxVal; }

        void SetMarkerMovement(const MarkerMovementType& markermovement);
        const MarkerMovementType& GetMarkerMovement() const { return m_MarkerMovement; }

        void SetUseNumofSteps(const UseNumofStepsType& usenumofsteps);
        const UseNumofStepsType& GetUseNumofSteps() const { return m_UseNumofSteps; }

        //! [DataBinding_NumOfStepsPropertyGetterSetter]
        void SetNumOfSteps(const NumOfStepsType& numofsteps);
        const NumOfStepsType& GetNumOfSteps() const { return m_NumOfSteps; }
        //! [DataBinding_NumOfStepsPropertyGetterSetter]

        //! [DataBinding_StepSizePropertyGetterSetter]
        void SetStepSize(const StepSizeType& stepsize);
        const StepSizeType& GetStepSize() const { return m_StepSize; }
        //! [DataBinding_StepSizePropertyGetterSetter]

        void SetMarkerNormalBitmap(const MarkerNormalBitmapType& markernormalbitmap);
        const MarkerNormalBitmapType& GetMarkerNormalBitmap() const { return m_MarkerNormalBitmap; }

        void SetMarkerSelectedBitmap(const MarkerSelectedBitmapType& markerselectedbitmap);
        const MarkerSelectedBitmapType& GetMarkerSelectedBitmap() const { return m_MarkerSelectedBitmap; }

        void SetContinuousUpdateOnDrag(const ContinuousUpdateOnDragType& continuousupdateondrag);
        const ContinuousUpdateOnDragType& GetContinuousUpdateOnDrag() const { return m_ContinuousUpdateOnDrag; }

        void SetFillerPositionIsKnobCenter(const FillerPositionIsKnobCenterType& fillerpositionisknobcenter);
        const FillerPositionIsKnobCenterType& GetFillerPositionIsKnobCenter() const { return m_FillerPositionIsKnobCenter; }

        // @WidgetBaseClass
        CdaWidget2DDef(SliderWidget2DBase, ::Touchable2D)
            CdaDescription("The slider is the widget for controlling a value by positioning a knob / thumb in a legal range.")
            CdaReadableName("SliderWidget2DBase")
            CdaCategory("Range")

            CdaProperties()
                CdaProperty(SliderBackGround, SliderBackGroundType, GetSliderBackGround, SetSliderBackGround)
                    CdaDescription("The Scene Tree Node that renders sliders background grid with scale markers on top.")
                CdaPropertyEnd()
                CdaProperty(MarkerNode, MarkerNodeType, GetMarkerNode, SetMarkerNode)
                    CdaDescription("The Scene Tree Node that supports a bitmap used for the slider marker (Knob, Thumb).")
                    CdaVisibilityTest(ComposerPropFilterNotProgressbarMode)
                CdaPropertyEnd()
                CdaProperty(BitmapFillNode, BitmapFillNodeType, GetBitmapFillNode, SetBitmapFillNode)
                    CdaDescription("Node to be used for the bitmap corresponding to the current value.")
                    CdaVisibilityTest(ComposerPropFilterNotAngularSlider)
                CdaPropertyEnd()
                CdaBindableProperty(MinVal, MinValType, GetMinVal, SetMinVal)
                    CdaDescription("Minimum value for slider at first marker (e.g Tuner 88.0 Mhz)")
                CdaBindablePropertyEnd()
                CdaBindableProperty(MaxVal, MaxValType, GetMaxVal, SetMaxVal)
                    CdaDescription("Maximum value for slider at last marker (e.g Tuner 108.0 Mhz)")
                CdaBindablePropertyEnd()
                CdaBindableProperty(CurrentValue, CurrentValueType, GetCurrentValue, SetCurrentValue)
                    CdaDescription("Current value of the slider marker, should be in the range between MinVal and MaxVal.")
                CdaBindablePropertyEnd()
                CdaProperty(SliderOrientation, SliderOrientationType, GetSliderOrientation, SetSliderOrientation)
                    CdaDescription("Defines the orientation of the slider marker movement and the slider bar.")
                CdaPropertyEnd()
                CdaProperty(PaddingMinVal, PaddingMinValType, GetPaddingMinVal, SetPaddingMinVal)
                    CdaDescription("Minimum graphical padding value on left hand, offset in pixel to the first valid marker for minimum value (calculated from the beginning of the background scale bitmap).")
                    CdaVisibilityTest(ComposerPropFilterNotAngularSlider)
                CdaPropertyEnd()
                CdaProperty(PaddingMaxVal, PaddingMaxValType, GetPaddingMaxVal, SetPaddingMaxVal)
                    CdaDescription("Maximum graphical padding value on right hand, offset in pixel to the last valid marker for maximum value (calculated from the end of the background scale bitmap)")
                    CdaVisibilityTest(ComposerPropFilterNotAngularSlider)
                CdaPropertyEnd()
                CdaProperty(MarkerMovement, MarkerMovementType, GetMarkerMovement, SetMarkerMovement)
                    CdaDescription("Defines the way the slider marker moves on tap or drag.\n For TimedStepMovement the marker will move one step on Press and will keep moving one step for every Repeat, this means that PressRepeat needs to be enabled and Drag needs to be disabled to prevent jumping on Drag.")
                    CdaVisibilityTest(ComposerPropFilterNotProgressbarMode)
                CdaPropertyEnd()
                CdaProperty(UseNumofSteps, UseNumofStepsType, GetUseNumofSteps, SetUseNumofSteps)
                    CdaDescription("If this property is set to true NumOfSteps will be visible and used, else StepSize will be visible and used.")
                    CdaVisibilityTest(ComposerPropFilterNotProgressbarMode)
                CdaPropertyEnd()
                CdaBindableProperty(NumOfSteps, NumOfStepsType, GetNumOfSteps, SetNumOfSteps)
                    CdaDescription("Total number steps for the marker movement. The stepsize will be calculated based on given range and number of steps. (e.g. range 0..20, steps=10 -> stepsize 2)")
                    CdaVisibilityTest(ComposerPropFilterNumOfSteps)
                CdaBindablePropertyEnd()
                CdaBindableProperty(StepSize, StepSizeType, GetStepSize, SetStepSize)
                    CdaDescription("Defines the stepsize for movement of slidermarker.")
                    CdaVisibilityTest(ComposerPropFilterStepSize)
                CdaBindablePropertyEnd()
                CdaProperty(MarkerNormalBitmap, MarkerNormalBitmapType, GetMarkerNormalBitmap, SetMarkerNormalBitmap)
                    CdaDescription("Bitmap to be rendered when a slider marker is normal.")
                    CdaVisibilityTest(ComposerPropFilterIsMarkerSelectedBitmapConfigurable)
                CdaPropertyEnd()
                CdaProperty(MarkerSelectedBitmap, MarkerSelectedBitmapType, GetMarkerSelectedBitmap, SetMarkerSelectedBitmap)
                    CdaDescription("Bitmap to be rendered when a slider marker is selected.")
                    CdaVisibilityTest(ComposerPropFilterIsMarkerSelectedBitmapConfigurable)
                CdaPropertyEnd()
                CdaProperty(ContinuousUpdateOnDrag, ContinuousUpdateOnDragType, GetContinuousUpdateOnDrag, SetContinuousUpdateOnDrag)
                    CdaDescription("Set to true if value updates are required while dragging, set to false if update is required only at the end of drag.")
                    CdaVisibilityTest(ComposerPropFilterNotProgressbarMode)
                CdaPropertyEnd()
                CdaProperty(FillerPositionIsKnobCenter, FillerPositionIsKnobCenterType, GetFillerPositionIsKnobCenter, SetFillerPositionIsKnobCenter)
                    CdaDescription("Filler starts at center of marker, for example round knob.")
                    CdaVisibilityTest(ComposerPropFilterFillerNodeConnected)
                CdaPropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        SliderBackGroundType m_SliderBackGround;
        MarkerNodeType m_MarkerNode;
        BitmapFillNodeType m_BitmapFillNode;
        MinValType m_MinVal;
        MaxValType m_MaxVal;
        CurrentValueType m_CurrentValue;
        SliderOrientationType m_SliderOrientation;
        PaddingMinValType m_PaddingMinVal;
        PaddingMaxValType m_PaddingMaxVal;
        MarkerMovementType m_MarkerMovement;
        UseNumofStepsType m_UseNumofSteps;
        NumOfStepsType m_NumOfSteps;
        StepSizeType m_StepSize;
        MarkerNormalBitmapType m_MarkerNormalBitmap;
        MarkerSelectedBitmapType m_MarkerSelectedBitmap;
        ContinuousUpdateOnDragType m_ContinuousUpdateOnDrag;
        FillerPositionIsKnobCenterType m_FillerPositionIsKnobCenter;
};

#endif // SliderWidget2DBase_h
