/************************************************************************
*FILE: ScrollableTextWidget2DBase.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ***************************************************************************************
 * FILE:          Generated intermediate file from HMIContract.exe
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  This file is part of HMI-Base Widget Library 
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "widget2D_std_if.h"

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "ScrollableTextWidget2DBase.h"

// ------------------------------------------------------------------------
CGI_WIDGET_RTTI_DEFINITION(ScrollableTextWidget2DBase)

ScrollableTextWidget2DBase::ScrollableTextWidget2DBase() :
    m_TextId(TextIdType()),
    m_FileName(FileNameType()),
    m_TextSource(TextSourceType()),
    m_ColorTable(ColorTableType()),
    m_TabStopTable(TabStopTableType()),
    m_LinespacingFactor(LinespacingFactorType()),
    m_TextWrapMode(TextWrapModeType()),
    m_SwipeFriction(SwipeFrictionType()),
    m_PostUpdateMessage(false),
    m_ScrollableTextId(0)
{
}

ScrollableTextWidget2DBase::~ScrollableTextWidget2DBase()
{
}

void ScrollableTextWidget2DBase::SetTextId(const TextIdType& textid)
{
    if (m_TextId != textid) {
        m_TextId = textid;
        OnChanged(static_cast< ::FeatStd::UInt32>(TextIdPropertyId));
    }
}

void ScrollableTextWidget2DBase::SetFileName(const FileNameType& filename)
{
    if (m_FileName != filename) {
        m_FileName = filename;
        OnChanged(static_cast< ::FeatStd::UInt32>(FileNamePropertyId));
    }
}

void ScrollableTextWidget2DBase::SetTextSource(const TextSourceType& textsource)
{
    if (m_TextSource != textsource) {
        m_TextSource = textsource;
        OnChanged(static_cast< ::FeatStd::UInt32>(TextSourcePropertyId));
    }
}

void ScrollableTextWidget2DBase::SetColorTable(const ColorTableType& colortable)
{
    m_ColorTable = colortable;
    OnChanged(static_cast< ::FeatStd::UInt32>(ColorTablePropertyId));
}

void ScrollableTextWidget2DBase::SetTabStopTable(const TabStopTableType& tabstoptable)
{
    m_TabStopTable = tabstoptable;
    OnChanged(static_cast< ::FeatStd::UInt32>(TabStopTablePropertyId));
}

void ScrollableTextWidget2DBase::SetLinespacingFactor(const LinespacingFactorType& linespacingfactor)
{
    if (m_LinespacingFactor != linespacingfactor) {
        m_LinespacingFactor = linespacingfactor;
        OnChanged(static_cast< ::FeatStd::UInt32>(LinespacingFactorPropertyId));
    }
}

void ScrollableTextWidget2DBase::SetTextWrapMode(const TextWrapModeType& textwrapmode)
{
    if (m_TextWrapMode != textwrapmode) {
        m_TextWrapMode = textwrapmode;
        OnChanged(static_cast< ::FeatStd::UInt32>(TextWrapModePropertyId));
    }
}

void ScrollableTextWidget2DBase::SetSwipeFriction(const SwipeFrictionType& swipefriction)
{
    if (m_SwipeFriction != swipefriction) {
        m_SwipeFriction = swipefriction;
        OnChanged(static_cast< ::FeatStd::UInt32>(SwipeFrictionPropertyId));
    }
}

void ScrollableTextWidget2DBase::SetPostUpdateMessage(const PostUpdateMessageType& postupdatemessage)
{
    if (m_PostUpdateMessage != postupdatemessage) {
        m_PostUpdateMessage = postupdatemessage;
        OnChanged(static_cast< ::FeatStd::UInt32>(PostUpdateMessagePropertyId));
    }
}

void ScrollableTextWidget2DBase::SetScrollableTextId(const ScrollableTextIdType& scrollabletextid)
{
    if (m_ScrollableTextId != scrollabletextid) {
        m_ScrollableTextId = scrollabletextid;
        OnChanged(static_cast< ::FeatStd::UInt32>(ScrollableTextIdPropertyId));
    }
}
