/************************************************************************
*FILE: RichTextBaseWidget2DBase.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ***************************************************************************************
 * FILE:          Generated intermediate file from HMIContract.exe
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  This file is part of HMI-Base Widget Library 
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "widget2D_std_if.h"

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "RichTextBaseWidget2DBase.h"

// ------------------------------------------------------------------------
CGI_WIDGET_RTTI_DEFINITION(RichTextBaseWidget2DBase)

RichTextBaseWidget2DBase::RichTextBaseWidget2DBase() :
    m_Text(TextType()),
    m_Style(StyleType()),
    m_TextAreaSize(TextAreaSizeType()),
    m_HorizontalAlignment(HorizontalAlignmentType()),
    m_VerticalAlignment(VerticalAlignmentType()),
    m_NormalTextColor(NormalTextColorType()),
    m_AlphaValue(AlphaValueType()),
    m_ChangeSetRichTextBaseWidget2DBase()
{
    if (!m_ChangeSetRichTextBaseWidget2DBase.Reserve(1)) {
        FEATSTD_DEBUG_FAIL();
    }
}

RichTextBaseWidget2DBase::~RichTextBaseWidget2DBase()
{
}

void RichTextBaseWidget2DBase::Update()
{
    Base::Update();
    while (!m_ChangeSetRichTextBaseWidget2DBase.Empty()) {
        ::FeatStd::UInt32 propertyId = m_ChangeSetRichTextBaseWidget2DBase[0];
        bool ok = m_ChangeSetRichTextBaseWidget2DBase.Remove(0);
        FEATSTD_DEBUG_ASSERT(ok);
        OnChanged(propertyId);
        FEATSTD_UNUSED(ok);
    }
}

void RichTextBaseWidget2DBase::SetText(const TextType& text)
{
    if (m_Text != text) {
        m_Text = text;
        if (!m_ChangeSetRichTextBaseWidget2DBase.Contains(static_cast< ::FeatStd::UInt32>(TextPropertyId))) {
            if (!m_ChangeSetRichTextBaseWidget2DBase.Add(static_cast< ::FeatStd::UInt32>(TextPropertyId))) {
                FEATSTD_DEBUG_FAIL();
            }
        }
        WakeUpAllRenderComponents();
    }
}

void RichTextBaseWidget2DBase::SetStyle(const StyleType& style)
{
    if (m_Style != style) {
        m_Style = style;
        if (!m_ChangeSetRichTextBaseWidget2DBase.Contains(static_cast< ::FeatStd::UInt32>(StylePropertyId))) {
            if (!m_ChangeSetRichTextBaseWidget2DBase.Add(static_cast< ::FeatStd::UInt32>(StylePropertyId))) {
                FEATSTD_DEBUG_FAIL();
            }
        }
    }
}

void RichTextBaseWidget2DBase::SetTextAreaSize(const TextAreaSizeType& textareasize)
{
    if (m_TextAreaSize != textareasize) {
        m_TextAreaSize = textareasize;
        if (!m_ChangeSetRichTextBaseWidget2DBase.Contains(static_cast< ::FeatStd::UInt32>(TextAreaSizePropertyId))) {
            if (!m_ChangeSetRichTextBaseWidget2DBase.Add(static_cast< ::FeatStd::UInt32>(TextAreaSizePropertyId))) {
                FEATSTD_DEBUG_FAIL();
            }
        }
    }
}

void RichTextBaseWidget2DBase::SetHorizontalAlignment(const HorizontalAlignmentType& horizontalalignment)
{
    if (m_HorizontalAlignment != horizontalalignment) {
        m_HorizontalAlignment = horizontalalignment;
        if (!m_ChangeSetRichTextBaseWidget2DBase.Contains(static_cast< ::FeatStd::UInt32>(HorizontalAlignmentPropertyId))) {
            if (!m_ChangeSetRichTextBaseWidget2DBase.Add(static_cast< ::FeatStd::UInt32>(HorizontalAlignmentPropertyId))) {
                FEATSTD_DEBUG_FAIL();
            }
        }
    }
}

void RichTextBaseWidget2DBase::SetVerticalAlignment(const VerticalAlignmentType& verticalalignment)
{
    if (m_VerticalAlignment != verticalalignment) {
        m_VerticalAlignment = verticalalignment;
        if (!m_ChangeSetRichTextBaseWidget2DBase.Contains(static_cast< ::FeatStd::UInt32>(VerticalAlignmentPropertyId))) {
            if (!m_ChangeSetRichTextBaseWidget2DBase.Add(static_cast< ::FeatStd::UInt32>(VerticalAlignmentPropertyId))) {
                FEATSTD_DEBUG_FAIL();
            }
        }
    }
}

void RichTextBaseWidget2DBase::SetNormalTextColor(const NormalTextColorType& normaltextcolor)
{
    if (m_NormalTextColor != normaltextcolor) {
        m_NormalTextColor = normaltextcolor;
        if (!m_ChangeSetRichTextBaseWidget2DBase.Contains(static_cast< ::FeatStd::UInt32>(NormalTextColorPropertyId))) {
            if (!m_ChangeSetRichTextBaseWidget2DBase.Add(static_cast< ::FeatStd::UInt32>(NormalTextColorPropertyId))) {
                FEATSTD_DEBUG_FAIL();
            }
        }
    }
}

void RichTextBaseWidget2DBase::SetAlphaValue(const AlphaValueType& alphavalue)
{
    if (m_AlphaValue != alphavalue) {
        m_AlphaValue = alphavalue;
        if (!m_ChangeSetRichTextBaseWidget2DBase.Contains(static_cast< ::FeatStd::UInt32>(AlphaValuePropertyId))) {
            if (!m_ChangeSetRichTextBaseWidget2DBase.Add(static_cast< ::FeatStd::UInt32>(AlphaValuePropertyId))) {
                FEATSTD_DEBUG_FAIL();
            }
        }
    }
}
