/************************************************************************
*FILE: ScrollableRichTextWidget2DBase.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ***************************************************************************************
 * FILE:          Generated intermediate file from HMIContract.exe
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  This file is part of HMI-Base Widget Library 
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "widget2D_std_if.h"

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "ScrollableRichTextWidget2DBase.h"

namespace hmibase {
} // namespace hmibase

namespace hmibase {
namespace widget {
namespace richtext {
// ------------------------------------------------------------------------
CGI_WIDGET_RTTI_DEFINITION(ScrollableRichTextWidget2DBase)

ScrollableRichTextWidget2DBase::ScrollableRichTextWidget2DBase() :
    m_ScrollId(ScrollIdType()),
    m_SwipeDeceleration(200),
    m_SwipeMaxDistance(0)
{
}

ScrollableRichTextWidget2DBase::~ScrollableRichTextWidget2DBase()
{
}

void ScrollableRichTextWidget2DBase::SetScrollId(const ScrollIdType& scrollid)
{
    if (m_ScrollId != scrollid) {
        m_ScrollId = scrollid;
        OnChanged(static_cast< ::FeatStd::UInt32>(ScrollIdPropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("ScrollId");
        }
    }
}

void ScrollableRichTextWidget2DBase::SetSwipeDeceleration(const SwipeDecelerationType& swipedeceleration)
{
    if (m_SwipeDeceleration != swipedeceleration) {
        m_SwipeDeceleration = swipedeceleration;
    }
}

void ScrollableRichTextWidget2DBase::SetSwipeMaxDistance(const SwipeMaxDistanceType& swipemaxdistance)
{
    if (m_SwipeMaxDistance != swipemaxdistance) {
        m_SwipeMaxDistance = swipemaxdistance;
    }
}
} // namespace richtext
} // namespace widget
} // namespace hmibase
