/************************************************************************
*FILE: RichTextWidget2DBase.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ***************************************************************************************
 * FILE:          Generated intermediate file from HMIContract.exe
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  This file is part of HMI-Base Widget Library 
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "widget2D_std_if.h"

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "RichTextWidget2DBase.h"

namespace hmibase {
} // namespace hmibase

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
template<> ::FeatStd::UInt32 StringBufferAppender< ::hmibase::widget::richtext::SrcType::Enum >::Append(::FeatStd::StringBuffer& stringBuffer, ::hmibase::widget::richtext::SrcType::Enum const & object)
{
    ::FeatStd::UInt32 tcharCount = 0;
    switch (object) {
        case ::hmibase::widget::richtext::SrcType::String:
            tcharCount += stringBuffer.Append("::hmibase::widget::richtext::SrcType::String");
            break;
        case ::hmibase::widget::richtext::SrcType::URL:
            tcharCount += stringBuffer.Append("::hmibase::widget::richtext::SrcType::URL");
            break;
        default:
            tcharCount += stringBuffer.Append("##unknown##");
            break;
    }
    return tcharCount;
}
}
#endif
namespace hmibase {
} // namespace hmibase

namespace hmibase {
namespace widget {
namespace richtext {
// ------------------------------------------------------------------------
CGI_WIDGET_RTTI_DEFINITION(RichTextWidget2DBase)

RichTextWidget2DBase::RichTextWidget2DBase() :
    m_SourceType(SrcType::String),
    m_Source(SourceType()),
    m_TextStyle(TextStyleType()),
    m_StyleSheetUrl(StyleSheetUrlType()),
    m_Style(StyleType()),
    m_ColorEnabled(ColorEnabledType()),
    m_Color(Candera::Color(1.0F, 1.0F, 1.0F, 1.0F)),
    m_Offset(OffsetType()),
    m_MaxNumberOfLines(0),
    m_HorizontalAlignmentEnabled(false),
    m_HorizontalAlignment(Candera::HLeft),
    m_CultureDependentAlignment(true),
    m_BaselineOffset(-1),
    m_AsynchronousRendering(false),
    m_SlicedRendering(false),
    m_SliceHeight(0)
{
}

RichTextWidget2DBase::~RichTextWidget2DBase()
{
}

void RichTextWidget2DBase::SetSourceType(const SourceTypeType& sourcetype)
{
    if (m_SourceType != sourcetype) {
        m_SourceType = sourcetype;
        OnChanged(static_cast< ::FeatStd::UInt32>(SourceTypePropertyId));
    }
}

void RichTextWidget2DBase::SetSource(const SourceType& source)
{
    if (m_Source != source) {
        m_Source = source;
        OnChanged(static_cast< ::FeatStd::UInt32>(SourcePropertyId));
    }
}

void RichTextWidget2DBase::SetTextStyle(const TextStyleType& textstyle)
{
    if (m_TextStyle != textstyle) {
        m_TextStyle = textstyle;
        OnChanged(static_cast< ::FeatStd::UInt32>(TextStylePropertyId));
    }
}

void RichTextWidget2DBase::SetStyleSheetUrl(const StyleSheetUrlType& stylesheeturl)
{
    if (m_StyleSheetUrl != stylesheeturl) {
        m_StyleSheetUrl = stylesheeturl;
        OnChanged(static_cast< ::FeatStd::UInt32>(StyleSheetUrlPropertyId));
    }
}

void RichTextWidget2DBase::SetStyle(const StyleType& style)
{
    if (m_Style != style) {
        m_Style = style;
        OnChanged(static_cast< ::FeatStd::UInt32>(StylePropertyId));
    }
}

void RichTextWidget2DBase::SetColorEnabled(const ColorEnabledType& colorenabled)
{
    if (m_ColorEnabled != colorenabled) {
        m_ColorEnabled = colorenabled;
        OnChanged(static_cast< ::FeatStd::UInt32>(ColorEnabledPropertyId));
    }
}

void RichTextWidget2DBase::SetColor(const ColorType& color)
{
    if (m_Color != color) {
        m_Color = color;
        OnChanged(static_cast< ::FeatStd::UInt32>(ColorPropertyId));
    }
}

void RichTextWidget2DBase::SetOffset(const OffsetType& offset)
{
    if (m_Offset != offset) {
        m_Offset = offset;
        OnChanged(static_cast< ::FeatStd::UInt32>(OffsetPropertyId));
    }
}

void RichTextWidget2DBase::SetMaxNumberOfLines(const MaxNumberOfLinesType& maxnumberoflines)
{
    if (m_MaxNumberOfLines != maxnumberoflines) {
        m_MaxNumberOfLines = maxnumberoflines;
        OnChanged(static_cast< ::FeatStd::UInt32>(MaxNumberOfLinesPropertyId));
    }
}

void RichTextWidget2DBase::SetHorizontalAlignmentEnabled(const HorizontalAlignmentEnabledType& horizontalalignmentenabled)
{
    if (m_HorizontalAlignmentEnabled != horizontalalignmentenabled) {
        m_HorizontalAlignmentEnabled = horizontalalignmentenabled;
        OnChanged(static_cast< ::FeatStd::UInt32>(HorizontalAlignmentEnabledPropertyId));
    }
}

void RichTextWidget2DBase::SetHorizontalAlignment(const HorizontalAlignmentType& horizontalalignment)
{
    if (m_HorizontalAlignment != horizontalalignment) {
        m_HorizontalAlignment = horizontalalignment;
        OnChanged(static_cast< ::FeatStd::UInt32>(HorizontalAlignmentPropertyId));
    }
}

void RichTextWidget2DBase::SetCultureDependentAlignment(const CultureDependentAlignmentType& culturedependentalignment)
{
    if (m_CultureDependentAlignment != culturedependentalignment) {
        m_CultureDependentAlignment = culturedependentalignment;
        OnChanged(static_cast< ::FeatStd::UInt32>(CultureDependentAlignmentPropertyId));
    }
}

void RichTextWidget2DBase::SetBaselineOffset(const BaselineOffsetType& baselineoffset)
{
    if (m_BaselineOffset != baselineoffset) {
        m_BaselineOffset = baselineoffset;
        OnChanged(static_cast< ::FeatStd::UInt32>(BaselineOffsetPropertyId));
    }
}

void RichTextWidget2DBase::SetAsynchronousRendering(const AsynchronousRenderingType& asynchronousrendering)
{
    if (m_AsynchronousRendering != asynchronousrendering) {
        m_AsynchronousRendering = asynchronousrendering;
    }
}

void RichTextWidget2DBase::SetSlicedRendering(const SlicedRenderingType& slicedrendering)
{
    if (m_SlicedRendering != slicedrendering) {
        m_SlicedRendering = slicedrendering;
    }
}

void RichTextWidget2DBase::SetSliceHeight(const SliceHeightType& sliceheight)
{
    if (m_SliceHeight != sliceheight) {
        m_SliceHeight = sliceheight;
    }
}
} // namespace richtext
} // namespace widget
} // namespace hmibase
