/************************************************************************
*FILE: RichTextHighlightWidget2DBase.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ***************************************************************************************
 * FILE:          Generated intermediate file from HMIContract.exe
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  This file is part of HMI-Base Widget Library 
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "widget2D_std_if.h"

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "RichTextHighlightWidget2DBase.h"

namespace hmibase {
} // namespace hmibase

namespace hmibase {
namespace widget {
namespace richtext {
// ------------------------------------------------------------------------
CGI_WIDGET_RTTI_DEFINITION(RichTextHighlightWidget2DBase)

RichTextHighlightWidget2DBase::RichTextHighlightWidget2DBase() :
    m_HighlightMode(Highlighter::Mask),
    m_HighlightText(HighlightTextType()),
    m_AllOccurrences(false),
    m_CaseSensitive(false),
    m_TextColorEnabled(TextColorEnabledType()),
    m_TextColor(Candera::Color(1.0F, 1.0F, 1.0F, 1.0F)),
    m_BackgroundColorEnabled(BackgroundColorEnabledType()),
    m_BackgroundColor(Candera::Color(1.0F, 1.0F, 1.0F, 1.0F))
{
}

RichTextHighlightWidget2DBase::~RichTextHighlightWidget2DBase()
{
}

void RichTextHighlightWidget2DBase::SetHighlightMode(const HighlightModeType& highlightmode)
{
    if (m_HighlightMode != highlightmode) {
        m_HighlightMode = highlightmode;
        OnChanged(static_cast< ::FeatStd::UInt32>(HighlightModePropertyId));
    }
}

void RichTextHighlightWidget2DBase::SetHighlightText(const HighlightTextType& highlighttext)
{
    if (m_HighlightText != highlighttext) {
        m_HighlightText = highlighttext;
        OnChanged(static_cast< ::FeatStd::UInt32>(HighlightTextPropertyId));
    }
}

void RichTextHighlightWidget2DBase::SetAllOccurrences(const AllOccurrencesType& alloccurrences)
{
    if (m_AllOccurrences != alloccurrences) {
        m_AllOccurrences = alloccurrences;
        OnChanged(static_cast< ::FeatStd::UInt32>(AllOccurrencesPropertyId));
    }
}

void RichTextHighlightWidget2DBase::SetCaseSensitive(const CaseSensitiveType& casesensitive)
{
    if (m_CaseSensitive != casesensitive) {
        m_CaseSensitive = casesensitive;
        OnChanged(static_cast< ::FeatStd::UInt32>(CaseSensitivePropertyId));
    }
}

void RichTextHighlightWidget2DBase::SetTextColorEnabled(const TextColorEnabledType& textcolorenabled)
{
    if (m_TextColorEnabled != textcolorenabled) {
        m_TextColorEnabled = textcolorenabled;
        OnChanged(static_cast< ::FeatStd::UInt32>(TextColorEnabledPropertyId));
    }
}

void RichTextHighlightWidget2DBase::SetTextColor(const TextColorType& textcolor)
{
    if (m_TextColor != textcolor) {
        m_TextColor = textcolor;
        OnChanged(static_cast< ::FeatStd::UInt32>(TextColorPropertyId));
    }
}

void RichTextHighlightWidget2DBase::SetBackgroundColorEnabled(const BackgroundColorEnabledType& backgroundcolorenabled)
{
    if (m_BackgroundColorEnabled != backgroundcolorenabled) {
        m_BackgroundColorEnabled = backgroundcolorenabled;
        OnChanged(static_cast< ::FeatStd::UInt32>(BackgroundColorEnabledPropertyId));
    }
}

void RichTextHighlightWidget2DBase::SetBackgroundColor(const BackgroundColorType& backgroundcolor)
{
    if (m_BackgroundColor != backgroundcolor) {
        m_BackgroundColor = backgroundcolor;
        OnChanged(static_cast< ::FeatStd::UInt32>(BackgroundColorPropertyId));
    }
}
} // namespace richtext
} // namespace widget
} // namespace hmibase
