/************************************************************************
*FILE: ProgressBarWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(ProgressBarWidget2DBase_h)
#define ProgressBarWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/BaseWidget2D.h>

          /*ProgressBarOrientationType : ProgressBar supports 8 types of Orientation
 Basic and Intermediate type Progress bar support 4 orientation:
 eHorizontalLeft : When set to this type the origin of the bitmap filling will be from left side of the progressbar.
 eHorizontalRight : When set to this type the origin of the bitmap filling will be from Right side of the progressbar.
 eVerticalTop : When set to this type the origin of the bitmap filling will be from top of the progressbar.
 eVerticalBottom : When set to this type the origin of the bitmap filling will be from bottom of the progressbar.

 BitmapFill progress bar support 2 orientation:
 eBitmapHorizontal : when set to this type the origin of filling 3 bitmap will be in Horizontal left order.
 eBitmapVertical : when set to this type the origin of filling 3 bitmap will be in vertical top order.

 Segmented Progress bar support 2 orientation:
 eSegVerticalUp : when set to this type the origin of filling of bitmap will be in Vertical up.
 eSegShiftVerticalUp : when set to this type the origin of filling bitmap will be overlayed in vertical up.(based on position)

 */

          #define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(ProgressBarOrientationType)     \
    ENUM_DATA_TYPE_ITEM(eHorizontalLeft)        \
    ENUM_DATA_TYPE_ITEM(eHorizontalRight)        \
    ENUM_DATA_TYPE_ITEM(eVerticalTop)        \
    ENUM_DATA_TYPE_ITEM(eVerticalBottom)        \
    ENUM_DATA_TYPE_END(ProgressBarOrientationType)
    #include <Candera/System/MetaInfo/EnumDataType.h>   

    #define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(ProgressBarFillType)     \
    ENUM_DATA_TYPE_ITEM(eValueBased)        \
    ENUM_DATA_TYPE_ITEM(eTimerBased)        \
    ENUM_DATA_TYPE_END(ProgressBarFillType)
    #include <Candera/System/MetaInfo/EnumDataType.h>

/*ProgressBarType2D : ProgressBar supports 4 different types
eBasicProgressBar :  is represented by filling the bitmap continously on background image, where the bitmap fill indicates the current value.
eIntermediateProgressBar : is represented by displaying the small rectangles separated by gap, here ongoing operation is represented interms of level.
eBitmapFillProgressBar : is represented by filling continously on background bitmap image, where the bitmap fill indicates the current progress state.
eSegmentedProgressBar : is represented by filling or overlaying of foreground bitmap image over background image based on current and total value.

      #define ENUM_DATA_TYPE \
      ENUM_DATA_TYPE_BEGIN(ProgressBarType2D)     \
      ENUM_DATA_TYPE_ITEM(eBasicProgressBar)        \
      ENUM_DATA_TYPE_ITEM(eRoundedCornerProgressBar)        \
      ENUM_DATA_TYPE_END(ProgressBarType2D)      
#include <Candera/System/MetaInfo/EnumDataType.h>
     */                   
// ------------------------------------------------------------------------
//! [ProgressBarWidget2DBase_Declaration]
class ProgressBarWidget2DBase : public ::BaseWidget2D
{
    public:
        typedef Candera::ProgressBarFillType ProgressFillTypeType;

        typedef Candera::Node2D* ProgressFillNodeType;

        typedef Candera::Node2D* ProgressBufferNodeType;

        typedef Candera::Node2D* MaskNodeType;

        typedef Candera::Node2D* BufferMaskNodeType;

        typedef Candera::ProgressBarOrientationType ProgressBarOrientationTypeType;

        typedef Candera::Float TotalValueType;

        typedef Candera::Float CurrentValueType;

        typedef Candera::Float BufferValueType;

        typedef Candera::UInt32 TimerValueType;

        typedef Candera::UInt16 TimerStepCountType;

        typedef bool StartTimerType;

        typedef bool RestartTimerType;

        //! [Property_IDs]
        static const FeatStd::UInt32 ProgressFillTypePropertyId = 0xAE12BCC9;
        static const FeatStd::UInt32 ProgressFillNodePropertyId = 0x6A8A4EEB;
        static const FeatStd::UInt32 ProgressBufferNodePropertyId = 0xB4D0FE1A;
        static const FeatStd::UInt32 MaskNodePropertyId = 0xC6E998C4;
        static const FeatStd::UInt32 BufferMaskNodePropertyId = 0x2AE58C05;
        static const FeatStd::UInt32 ProgressBarOrientationTypePropertyId = 0x05ACE0D3;
        static const FeatStd::UInt32 TotalValuePropertyId = 0xEA1918C1;
        static const FeatStd::UInt32 CurrentValuePropertyId = 0x3F4BD799;
        static const FeatStd::UInt32 BufferValuePropertyId = 0xBA2697E7;
        static const FeatStd::UInt32 StartTimerPropertyId = 0xAC12C5EA;
        static const FeatStd::UInt32 RestartTimerPropertyId = 0xF8A57FFC;
        //! [Property_IDs]

        ProgressBarWidget2DBase();
        virtual ~ProgressBarWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(ProgressBarWidget2DBase, ::BaseWidget2D);

        void SetProgressFillType(const ProgressFillTypeType& progressfilltype);
        const ProgressFillTypeType& GetProgressFillType() const { return m_ProgressFillType; }

        void SetProgressFillNode(const ProgressFillNodeType& progressfillnode);
        const ProgressFillNodeType& GetProgressFillNode() const { return m_ProgressFillNode; }

        void SetProgressBufferNode(const ProgressBufferNodeType& progressbuffernode);
        const ProgressBufferNodeType& GetProgressBufferNode() const { return m_ProgressBufferNode; }

        void SetMaskNode(const MaskNodeType& masknode);
        const MaskNodeType& GetMaskNode() const { return m_MaskNode; }
        MaskNodeType& GetMaskNode() { return m_MaskNode; }

        void SetBufferMaskNode(const BufferMaskNodeType& buffermasknode);
        const BufferMaskNodeType& GetBufferMaskNode() const { return m_BufferMaskNode; }
        BufferMaskNodeType& GetBufferMaskNode() { return m_BufferMaskNode; }

        void SetProgressBarOrientationType(const ProgressBarOrientationTypeType& progressbarorientationtype);
        const ProgressBarOrientationTypeType& GetProgressBarOrientationType() const { return m_ProgressBarOrientationType; }

        //! [DataBinding_TotalValuePropertyGetterSetter]
        void SetTotalValue(const TotalValueType& totalvalue);
        const TotalValueType& GetTotalValue() const { return m_TotalValue; }
        //! [DataBinding_TotalValuePropertyGetterSetter]

        //! [DataBinding_CurrentValuePropertyGetterSetter]
        void SetCurrentValue(const CurrentValueType& currentvalue);
        const CurrentValueType& GetCurrentValue() const { return m_CurrentValue; }
        //! [DataBinding_CurrentValuePropertyGetterSetter]

        //! [DataBinding_BufferValuePropertyGetterSetter]
        void SetBufferValue(const BufferValueType& buffervalue);
        const BufferValueType& GetBufferValue() const { return m_BufferValue; }
        //! [DataBinding_BufferValuePropertyGetterSetter]

        void SetTimerValue(const TimerValueType& timervalue);
        const TimerValueType& GetTimerValue() const { return m_TimerValue; }
        TimerValueType& GetTimerValue() { return m_TimerValue; }

        void SetTimerStepCount(const TimerStepCountType& timerstepcount);
        const TimerStepCountType& GetTimerStepCount() const { return m_TimerStepCount; }
        TimerStepCountType& GetTimerStepCount() { return m_TimerStepCount; }

        //! [DataBinding_StartTimerPropertyGetterSetter]
        void SetStartTimer(const StartTimerType& starttimer);
        const StartTimerType& GetStartTimer() const { return m_StartTimer; }
        StartTimerType& GetStartTimer() { return m_StartTimer; }
        //! [DataBinding_StartTimerPropertyGetterSetter]

        //! [DataBinding_RestartTimerPropertyGetterSetter]
        void SetRestartTimer(const RestartTimerType& restarttimer);
        const RestartTimerType& GetRestartTimer() const { return m_RestartTimer; }
        RestartTimerType& GetRestartTimer() { return m_RestartTimer; }
        //! [DataBinding_RestartTimerPropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(ProgressBarWidget2DBase, ::BaseWidget2D)
            CdaDescription("ProgressBarWidget2D implements the Non Interactive functionality.")
            CdaReadableName("ProgressBarWidget2DBase")
            CdaCategory("Range")

            CdaProperties()
                CdaProperty(ProgressFillType, ProgressFillTypeType, GetProgressFillType, SetProgressFillType)
                    CdaDescription("The strategy used to fill the Progressbar which can be either based on Value or a Timer")
                CdaPropertyEnd()
                CdaProperty(ProgressFillNode, ProgressFillNodeType, GetProgressFillNode, SetProgressFillNode)
                    CdaDescription("The fill node is the indicator of the current value of the progressbarWidget")
                CdaPropertyEnd()
                CdaProperty(ProgressBufferNode, ProgressBufferNodeType, GetProgressBufferNode, SetProgressBufferNode)
                    CdaDescription("The buffer node is the indicator of the current buffer value of the progressbarWidget")
                CdaPropertyEnd()
                CdaProperty(MaskNode, MaskNodeType, GetMaskNode, SetMaskNode)
                    CdaDescription("This property holds the Mask Node which is used to selectively render parts of the FillNode")
                CdaPropertyEnd()
                CdaProperty(BufferMaskNode, BufferMaskNodeType, GetBufferMaskNode, SetBufferMaskNode)
                    CdaDescription("This property holds the Mask Node which is used to selectively render parts of the BufferNode")
                    CdaVisibilityTest(IsBufferNodeConfigured)
                CdaPropertyEnd()
                CdaProperty(ProgressBarOrientationType, ProgressBarOrientationTypeType, GetProgressBarOrientationType, SetProgressBarOrientationType)
                    CdaDescription("Select the orientation of the ProgressBar. Horizontal(Left, right), Vertical(Top, Bottom)")
                CdaPropertyEnd()
                CdaBindableProperty(TotalValue, TotalValueType, GetTotalValue, SetTotalValue)
                    CdaDescription("This property holds the progress bar's maximum value")
                    CdaVisibilityTest(IsValueBasedProgressBar)
                CdaBindablePropertyEnd()
                CdaBindableProperty(CurrentValue, CurrentValueType, GetCurrentValue, SetCurrentValue)
                    CdaDescription("This property holds the current position of progress with respect to the TotalValue")
                    CdaVisibilityTest(IsValueBasedProgressBar)
                CdaBindablePropertyEnd()
                CdaBindableProperty(BufferValue, BufferValueType, GetBufferValue, SetBufferValue)
                    CdaDescription("This property holds the buffer's position with respect to the TotalValue")
                    CdaVisibilityTest(IsBufferNodeConfigured)
                CdaBindablePropertyEnd()
                CdaProperty(TimerValue, TimerValueType, GetTimerValue, SetTimerValue)
                    CdaDescription("The timer duration in which the ProgressBar will be filled completely based on an internal timer value.The internal timer is started based on the StartTimer property value")
                    CdaVisibilityTest(IsTimerValueConfigured)
                CdaPropertyEnd()
                CdaProperty(TimerStepCount, TimerStepCountType, GetTimerStepCount, SetTimerStepCount)
                    CdaDescription("Total number of steps for Progressbar to fill completely for the given TimerValue")
                    CdaVisibilityTest(IsTimerValueConfigured)
                    CdaRange(1, 99)
                CdaPropertyEnd()
                CdaBindableProperty(StartTimer, StartTimerType, GetStartTimer, SetStartTimer)
                    CdaDescription("This property controls when to start the internal timer which will update the Progressbar current position")
                    CdaVisibilityTest(IsTimerValueConfigured)
                CdaBindablePropertyEnd()
                CdaBindableProperty(RestartTimer, RestartTimerType, GetRestartTimer, SetRestartTimer)
                    CdaDescription("This property controls when to Restart the internal timer which will update the Progressbar current position")
                    CdaVisibilityTest(IsTimerValueConfigured)
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:

          bool IsBufferNodeConfigured() const { return GetProgressFillType() == Candera::eValueBased && GetProgressBufferNode() != 0; }
          bool IsTimerValueConfigured() const { return GetProgressFillType() == Candera::eTimerBased; }
          bool IsValueBasedProgressBar() const { return GetProgressFillType() == Candera::eValueBased; }

        ProgressFillTypeType m_ProgressFillType;
        ProgressFillNodeType m_ProgressFillNode;
        ProgressBufferNodeType m_ProgressBufferNode;
        MaskNodeType m_MaskNode;
        BufferMaskNodeType m_BufferMaskNode;
        ProgressBarOrientationTypeType m_ProgressBarOrientationType;
        TotalValueType m_TotalValue;
        CurrentValueType m_CurrentValue;
        BufferValueType m_BufferValue;
        TimerValueType m_TimerValue;
        TimerStepCountType m_TimerStepCount;
        StartTimerType m_StartTimer;
        RestartTimerType m_RestartTimer;
};

#endif // ProgressBarWidget2DBase_h
