/************************************************************************
*FILE: PanelSlideWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(PanelSlideWidget2DBase_h)
#define PanelSlideWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/PanelSlide/generated/PanelSlideWidget2DMessages.h>
#include <Widgets/2D/Touchable2D.h>
            #define ENUM_DATA_TYPE \
            ENUM_DATA_TYPE_BEGIN(PanelDirection) \
            ENUM_DATA_TYPE_ITEM(enHorizontalLeft) \
            ENUM_DATA_TYPE_ITEM(enHorizontalRight) \
            ENUM_DATA_TYPE_ITEM(enVerticalTop) \
            ENUM_DATA_TYPE_ITEM(enVerticalBottom) \
            ENUM_DATA_TYPE_END(PanelDirection)
            #include <Candera/System/MetaInfo/EnumDataType.h>       
// ------------------------------------------------------------------------
//! [PanelSlideWidget2DBase_Declaration]
class PanelSlideWidget2DBase : public ::Touchable2D
{
    public:
        typedef Candera::WidgetBase* PanelButtonType;

        typedef ::Candera::Node2D* PanelNodeType;

        typedef Candera::Float DragThresholdType;

        typedef Candera::PanelDirection DirectionType;

        typedef Candera::Float PanelSizeType;

        typedef bool PanelOpenType;

        //! [Property_IDs]
        static const FeatStd::UInt32 PanelNodePropertyId = 0x75DD4DF5;
        static const FeatStd::UInt32 PanelOpenPropertyId = 0x0BCEA5FB;
        //! [Property_IDs]

        PanelSlideWidget2DBase();
        virtual ~PanelSlideWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(PanelSlideWidget2DBase, ::Touchable2D);

        void SetPanelButton(const PanelButtonType& panelbutton);
        const PanelButtonType& GetPanelButton() const { return m_PanelButton; }

        void SetPanelNode(const PanelNodeType& panelnode);
        const PanelNodeType& GetPanelNode() const { return m_PanelNode; }

        void SetDragThreshold(const DragThresholdType& dragthreshold);
        const DragThresholdType& GetDragThreshold() const { return m_DragThreshold; }

        void SetDirection(const DirectionType& direction);
        const DirectionType& GetDirection() const { return m_Direction; }

        void SetPanelSize(const PanelSizeType& panelsize);
        const PanelSizeType& GetPanelSize() const { return m_PanelSize; }

        //! [DataBinding_PanelOpenPropertyGetterSetter]
        void SetPanelOpen(const PanelOpenType& panelopen);
        const PanelOpenType& GetPanelOpen() const { return m_PanelOpen; }
        //! [DataBinding_PanelOpenPropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(PanelSlideWidget2DBase, ::Touchable2D)
            CdaDescription("Supports to slide the panel from 4 directions(HorizontalLeft, HorizontalRight, VeriticalTop and VerticalBottom) using drag and swipe gestures. It also can be opened and closed with PanelButton.\n")
            CdaReadableName("PanelSlideWidget2DBase")
            CdaCategory("Gesture")

            CdaProperties()
                CdaProperty(PanelButton, PanelButtonType, GetPanelButton, SetPanelButton)
                    CdaDescription("The button will open and close the Panel.This is an optional button, Panel can also be opend and closed with swipe/drag getstures.")
                CdaPropertyEnd()
                CdaProperty(PanelNode, PanelNodeType, GetPanelNode, SetPanelNode)
                    CdaDescription("Node which will contain the childrerens of the panel. This will be visible when panel is opend and invisible when is panel is closed")
                CdaPropertyEnd()
                CdaProperty(DragThreshold, DragThresholdType, GetDragThreshold, SetDragThreshold)
                    CdaDescription("It is a minimum limit to show or hide the panel in case of drag(value should be in percentage ex: 0.5 for 1/2 of bg lengh/width)")
                CdaPropertyEnd()
                CdaProperty(Direction, DirectionType, GetDirection, SetDirection)
                    CdaDescription("Direction in which panel should be opened")
                CdaPropertyEnd()
                CdaProperty(PanelSize, PanelSizeType, GetPanelSize, SetPanelSize)
                    CdaDescription("Size of the panel(i.e panel width in case horizontal direction and panel hieght in case of vertical direction)")
                CdaPropertyEnd()
                CdaBindableProperty(PanelOpen, PanelOpenType, GetPanelOpen, SetPanelOpen)
                    CdaDescription("Panel will be in Opened state if it's true and Closed if it's false")
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        PanelButtonType m_PanelButton;
        PanelNodeType m_PanelNode;
        DragThresholdType m_DragThreshold;
        DirectionType m_Direction;
        PanelSizeType m_PanelSize;
        PanelOpenType m_PanelOpen;
};

#endif // PanelSlideWidget2DBase_h
