/************************************************************************
*FILE: PageEditWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(hmibase_widget_pageedit_PageEditWidget2DBase_h)
#define hmibase_widget_pageedit_PageEditWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/PageEdit/generated/PageEditWidget2DMessages.h>
#include <Widgets/2D/Touchable2D.h>

namespace hmibase {
} // namespace hmibase
namespace hmibase {
namespace widget {
namespace pageedit {
// ------------------------------------------------------------------------
//! [PageEditWidget2DBase_Declaration]
class PageEditWidget2DBase : public ::Touchable2D
{
    public:
        typedef ::Candera::UInt32 AlbumIdType;

        typedef ::Candera::UInt16 ColumnCountType;

        typedef ::Candera::UInt16 RowCountType;

        typedef ::Candera::Vector2 CellSizeType;

        typedef ::Candera::Node2D* ItemsNodeType;

        typedef bool ArrangeItemsType;

        typedef bool AutoArrangeType;

        typedef ::Candera::Node2D* EditingCellsNodeType;

        typedef ::Candera::ArrayProperty< ::Candera::Rectangle> ItemCellsType;

        //! [Property_IDs]
        static const FeatStd::UInt32 AlbumIdPropertyId = 0x052A9EFC;
        static const FeatStd::UInt32 ColumnCountPropertyId = 0x336823CE;
        static const FeatStd::UInt32 RowCountPropertyId = 0x5A25602C;
        static const FeatStd::UInt32 CellSizePropertyId = 0x0C70D409;
        static const FeatStd::UInt32 ItemsNodePropertyId = 0x15D5CB63;
        static const FeatStd::UInt32 ArrangeItemsPropertyId = 0xCF5AD876;
        static const FeatStd::UInt32 AutoArrangePropertyId = 0x66221DC8;
        static const FeatStd::UInt32 EditingCellsNodePropertyId = 0x40EBB5D2;
        static const FeatStd::UInt32 ItemCellsPropertyId = 0x4C828D6C;
        //! [Property_IDs]

        PageEditWidget2DBase();
        virtual ~PageEditWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(PageEditWidget2DBase, ::Touchable2D);

        //! [DataBinding_AlbumIdPropertyGetterSetter]
        void SetAlbumId(const AlbumIdType& albumid);
        const AlbumIdType& GetAlbumId() const { return m_AlbumId; }
        //! [DataBinding_AlbumIdPropertyGetterSetter]

        //! [DataBinding_ColumnCountPropertyGetterSetter]
        void SetColumnCount(const ColumnCountType& columncount);
        const ColumnCountType& GetColumnCount() const { return m_ColumnCount; }
        //! [DataBinding_ColumnCountPropertyGetterSetter]

        //! [DataBinding_RowCountPropertyGetterSetter]
        void SetRowCount(const RowCountType& rowcount);
        const RowCountType& GetRowCount() const { return m_RowCount; }
        //! [DataBinding_RowCountPropertyGetterSetter]

        //! [DataBinding_CellSizePropertyGetterSetter]
        void SetCellSize(const CellSizeType& cellsize);
        const CellSizeType& GetCellSize() const { return m_CellSize; }
        //! [DataBinding_CellSizePropertyGetterSetter]

        void SetItemsNode(const ItemsNodeType& itemsnode);
        const ItemsNodeType& GetItemsNode() const { return m_ItemsNode; }

        //! [DataBinding_ArrangeItemsPropertyGetterSetter]
        void SetArrangeItems(const ArrangeItemsType& arrangeitems);
        const ArrangeItemsType& GetArrangeItems() const { return m_ArrangeItems; }
        //! [DataBinding_ArrangeItemsPropertyGetterSetter]

        //! [DataBinding_AutoArrangePropertyGetterSetter]
        void SetAutoArrange(const AutoArrangeType& autoarrange);
        const AutoArrangeType& GetAutoArrange() const { return m_AutoArrange; }
        //! [DataBinding_AutoArrangePropertyGetterSetter]

        void SetEditingCellsNode(const EditingCellsNodeType& editingcellsnode);
        const EditingCellsNodeType& GetEditingCellsNode() const { return m_EditingCellsNode; }

        //! [DataBinding_ItemCellsPropertyGetterSetter]
        void SetItemCells(const ItemCellsType& itemcells);
        const ItemCellsType& GetItemCells() const { return m_ItemCells; }
        //! [DataBinding_ItemCellsPropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(PageEditWidget2DBase, ::Touchable2D)
            CdaDescription("Provides support to arrange items inside a grid. See the widget user guide for details regarding how to configure it.")
            CdaReadableName("PageEditWidget2DBase")
            CdaCategory("Gesture")

            CdaProperties()
                CdaBindableProperty(AlbumId, AlbumIdType, GetAlbumId, SetAlbumId)
                    CdaDescription("Editing is possible only within the pages from the same album.")
                    CdaCategory("Page Edit")
                CdaBindablePropertyEnd()
                CdaBindableProperty(ColumnCount, ColumnCountType, GetColumnCount, SetColumnCount)
                    CdaDescription("Number of columns.")
                    CdaCategory("Page Edit")
                CdaBindablePropertyEnd()
                CdaBindableProperty(RowCount, RowCountType, GetRowCount, SetRowCount)
                    CdaDescription("Number of rows.")
                    CdaCategory("Page Edit")
                CdaBindablePropertyEnd()
                CdaBindableProperty(CellSize, CellSizeType, GetCellSize, SetCellSize)
                    CdaDescription("Size in pixels of a cell.")
                    CdaCategory("Page Edit")
                CdaBindablePropertyEnd()
                CdaProperty(ItemsNode, ItemsNodeType, GetItemsNode, SetItemsNode)
                    CdaDescription("If set then the items will be searched inside this node otherwise the widget node will be used. ItemsNode must be the same as Node or a descendent of Node.")
                    CdaCategory("Page Edit")
                CdaPropertyEnd()
                CdaBindableProperty(ArrangeItems, ArrangeItemsType, GetArrangeItems, SetArrangeItems)
                    CdaDescription("If enabled then the items will be arranged based on ItemCells value.")
                    CdaCategory("Page Edit")
                CdaBindablePropertyEnd()
                CdaBindableProperty(AutoArrange, AutoArrangeType, GetAutoArrange, SetAutoArrange)
                    CdaDescription("If enabled then the items will be auto arranged on item drag.")
                    CdaVisibilityTest(GetArrangeItems)
                    CdaCategory("Page Edit")
                CdaBindablePropertyEnd()
                CdaProperty(EditingCellsNode, EditingCellsNodeType, GetEditingCellsNode, SetEditingCellsNode)
                    CdaDescription("If set to a resizable node then the editing cells will be marked. This node is visible only during editing.")
                    CdaVisibilityTest(GetArrangeItems)
                    CdaCategory("Page Edit")
                CdaPropertyEnd()
                CdaBindableProperty(ItemCells, ItemCellsType, GetItemCells, SetItemCells)
                    CdaDescription("Specifies the top left cell and the cell span for each item. If span is 0 (width or height is 0) then the item will be hidden.")
                    CdaVisibilityTest(GetArrangeItems)
                    CdaCategory("Page Edit")
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        AlbumIdType m_AlbumId;
        ColumnCountType m_ColumnCount;
        RowCountType m_RowCount;
        CellSizeType m_CellSize;
        ItemsNodeType m_ItemsNode;
        ArrangeItemsType m_ArrangeItems;
        AutoArrangeType m_AutoArrange;
        EditingCellsNodeType m_EditingCellsNode;
        ItemCellsType m_ItemCells;
};
} // namespace pageedit
} // namespace widget
} // namespace hmibase

#endif // hmibase_widget_pageedit_PageEditWidget2DBase_h
