/************************************************************************
*FILE: OPSWidgetBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(OPSWidgetBase_h)
#define OPSWidgetBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/BaseWidget2D.h>
#include <CanderaWidget/String/String.h>

        #define ENUM_DATA_TYPE \
          ENUM_DATA_TYPE_BEGIN(enOPSDisplayMode) \
          ENUM_DATA_TYPE_ITEM_VALUE(enRearOnly, 1) \
          ENUM_DATA_TYPE_ITEM_VALUE(enFrontAndRear, 2) \
          ENUM_DATA_TYPE_ITEM_VALUE(enAround360, 3) \
          ENUM_DATA_TYPE_END(enOPSDisplayMode)
        #include <Candera/System/MetaInfo/EnumDataType.h>
        #define ENUM_DATA_TYPE \
          ENUM_DATA_TYPE_BEGIN(enOPSWidgetType) \
          ENUM_DATA_TYPE_ITEM_VALUE(enBySector, 0) \
          ENUM_DATA_TYPE_ITEM_VALUE(enBySegment, 1) \
          ENUM_DATA_TYPE_END(enOPSWidgetType)
        #include <Candera/System/MetaInfo/EnumDataType.h>
// ------------------------------------------------------------------------
//! [OPSWidgetBase_Declaration]
class OPSWidgetBase : public ::BaseWidget2D
{
    public:
        typedef  bool OPSMiniType;

        typedef Candera::enOPSWidgetType OPSWidgetTypeType;

        typedef Candera::UInt8 OPSDisplayModeType;

        typedef bool TrailerConnectedType;

        typedef Candera::UInt16 VehicleTypeType;

        typedef Courier::ListPropertyType<bool> SensorsAvailableType;

        typedef Courier::ListPropertyType<Courier::UInt16> SensorsSegmentValuesType;

        typedef Courier::ListPropertyType<Courier::UInt16> SegmentPreDefinedDistanceValuesType;

        typedef Courier::ListPropertyType<Courier::UInt16> StatusValuesType;

        typedef Courier::ListPropertyType<bool> SensorFieldBlinkingType;

        typedef Courier::ListPropertyType<Courier::UInt16> BlinkIntervalType;

        typedef Courier::ListPropertyType<bool> SensorFieldHatchedType;

        typedef Courier::ListPropertyType<bool> SensorFieldScannedType;

        typedef Candera::UInt8 LeftRTAStatuslevelType;

        typedef Candera::UInt8 RightRTAStatuslevelType;

        typedef Candera::UInt8 LeftRTADistanceValueType;

        typedef Candera::UInt8 RightRTADistanceValueType;

        //! [Property_IDs]
        static const FeatStd::UInt32 OPSWidgetTypePropertyId = 0x0D3A2DB4;
        static const FeatStd::UInt32 OPSDisplayModePropertyId = 0x7DBF6349;
        static const FeatStd::UInt32 TrailerConnectedPropertyId = 0x8B90F7E6;
        static const FeatStd::UInt32 VehicleTypePropertyId = 0x4858D8D5;
        static const FeatStd::UInt32 SensorsAvailablePropertyId = 0x122787B6;
        static const FeatStd::UInt32 SensorsSegmentValuesPropertyId = 0x3ADC09E4;
        static const FeatStd::UInt32 SegmentPreDefinedDistanceValuesPropertyId = 0x9630623E;
        static const FeatStd::UInt32 StatusValuesPropertyId = 0x9C9A0F31;
        static const FeatStd::UInt32 SensorFieldBlinkingPropertyId = 0x1986378C;
        static const FeatStd::UInt32 BlinkIntervalPropertyId = 0xCA0BEFC5;
        static const FeatStd::UInt32 SensorFieldHatchedPropertyId = 0x782751DB;
        static const FeatStd::UInt32 SensorFieldScannedPropertyId = 0xFDDC6341;
        static const FeatStd::UInt32 LeftRTAStatuslevelPropertyId = 0x945CDCE8;
        static const FeatStd::UInt32 RightRTAStatuslevelPropertyId = 0x6C4A7B73;
        static const FeatStd::UInt32 LeftRTADistanceValuePropertyId = 0x7B26D805;
        static const FeatStd::UInt32 RightRTADistanceValuePropertyId = 0x17EB0DA7;
        //! [Property_IDs]

        OPSWidgetBase();
        virtual ~OPSWidgetBase();

        CGI_WIDGET_RTTI_DECLARATION(OPSWidgetBase, ::BaseWidget2D);

        void SetOPSMini(const OPSMiniType& opsmini);
        const OPSMiniType& GetOPSMini() const { return m_OPSMini; }

        //! [DataBinding_OPSWidgetTypePropertyGetterSetter]
        void SetOPSWidgetType(const OPSWidgetTypeType& opswidgettype);
        const OPSWidgetTypeType& GetOPSWidgetType() const { return m_OPSWidgetType; }
        //! [DataBinding_OPSWidgetTypePropertyGetterSetter]

        //! [DataBinding_OPSDisplayModePropertyGetterSetter]
        void SetOPSDisplayMode(const OPSDisplayModeType& opsdisplaymode);
        const OPSDisplayModeType& GetOPSDisplayMode() const { return m_OPSDisplayMode; }
        //! [DataBinding_OPSDisplayModePropertyGetterSetter]

        //! [DataBinding_TrailerConnectedPropertyGetterSetter]
        void SetTrailerConnected(const TrailerConnectedType& trailerconnected);
        const TrailerConnectedType& GetTrailerConnected() const { return m_TrailerConnected; }
        //! [DataBinding_TrailerConnectedPropertyGetterSetter]

        //! [DataBinding_VehicleTypePropertyGetterSetter]
        void SetVehicleType(const VehicleTypeType& vehicletype);
        const VehicleTypeType& GetVehicleType() const { return m_VehicleType; }
        //! [DataBinding_VehicleTypePropertyGetterSetter]

        //! [DataBinding_SensorsAvailablePropertyGetterSetter]
        void SetSensorsAvailable(const SensorsAvailableType& sensorsavailable);
        const SensorsAvailableType& GetSensorsAvailable() const { return m_SensorsAvailable; }
        //! [DataBinding_SensorsAvailablePropertyGetterSetter]

        //! [DataBinding_SensorsSegmentValuesPropertyGetterSetter]
        void SetSensorsSegmentValues(const SensorsSegmentValuesType& sensorssegmentvalues);
        const SensorsSegmentValuesType& GetSensorsSegmentValues() const { return m_SensorsSegmentValues; }
        //! [DataBinding_SensorsSegmentValuesPropertyGetterSetter]

        //! [DataBinding_SegmentPreDefinedDistanceValuesPropertyGetterSetter]
        void SetSegmentPreDefinedDistanceValues(const SegmentPreDefinedDistanceValuesType& segmentpredefineddistancevalues);
        const SegmentPreDefinedDistanceValuesType& GetSegmentPreDefinedDistanceValues() const { return m_SegmentPreDefinedDistanceValues; }
        //! [DataBinding_SegmentPreDefinedDistanceValuesPropertyGetterSetter]

        //! [DataBinding_StatusValuesPropertyGetterSetter]
        void SetStatusValues(const StatusValuesType& statusvalues);
        const StatusValuesType& GetStatusValues() const { return m_StatusValues; }
        //! [DataBinding_StatusValuesPropertyGetterSetter]

        //! [DataBinding_SensorFieldBlinkingPropertyGetterSetter]
        void SetSensorFieldBlinking(const SensorFieldBlinkingType& sensorfieldblinking);
        const SensorFieldBlinkingType& GetSensorFieldBlinking() const { return m_SensorFieldBlinking; }
        //! [DataBinding_SensorFieldBlinkingPropertyGetterSetter]

        //! [DataBinding_BlinkIntervalPropertyGetterSetter]
        void SetBlinkInterval(const BlinkIntervalType& blinkinterval);
        const BlinkIntervalType& GetBlinkInterval() const { return m_BlinkInterval; }
        //! [DataBinding_BlinkIntervalPropertyGetterSetter]

        //! [DataBinding_SensorFieldHatchedPropertyGetterSetter]
        void SetSensorFieldHatched(const SensorFieldHatchedType& sensorfieldhatched);
        const SensorFieldHatchedType& GetSensorFieldHatched() const { return m_SensorFieldHatched; }
        //! [DataBinding_SensorFieldHatchedPropertyGetterSetter]

        //! [DataBinding_SensorFieldScannedPropertyGetterSetter]
        void SetSensorFieldScanned(const SensorFieldScannedType& sensorfieldscanned);
        const SensorFieldScannedType& GetSensorFieldScanned() const { return m_SensorFieldScanned; }
        //! [DataBinding_SensorFieldScannedPropertyGetterSetter]

        //! [DataBinding_LeftRTAStatuslevelPropertyGetterSetter]
        void SetLeftRTAStatuslevel(const LeftRTAStatuslevelType& leftrtastatuslevel);
        const LeftRTAStatuslevelType& GetLeftRTAStatuslevel() const { return m_LeftRTAStatuslevel; }
        //! [DataBinding_LeftRTAStatuslevelPropertyGetterSetter]

        //! [DataBinding_RightRTAStatuslevelPropertyGetterSetter]
        void SetRightRTAStatuslevel(const RightRTAStatuslevelType& rightrtastatuslevel);
        const RightRTAStatuslevelType& GetRightRTAStatuslevel() const { return m_RightRTAStatuslevel; }
        //! [DataBinding_RightRTAStatuslevelPropertyGetterSetter]

        //! [DataBinding_LeftRTADistanceValuePropertyGetterSetter]
        void SetLeftRTADistanceValue(const LeftRTADistanceValueType& leftrtadistancevalue);
        const LeftRTADistanceValueType& GetLeftRTADistanceValue() const { return m_LeftRTADistanceValue; }
        //! [DataBinding_LeftRTADistanceValuePropertyGetterSetter]

        //! [DataBinding_RightRTADistanceValuePropertyGetterSetter]
        void SetRightRTADistanceValue(const RightRTADistanceValueType& rightrtadistancevalue);
        const RightRTADistanceValueType& GetRightRTADistanceValue() const { return m_RightRTADistanceValue; }
        //! [DataBinding_RightRTADistanceValuePropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(OPSWidgetBase, ::BaseWidget2D)
            CdaDescription("OPS (Optical parking system) widget is used to display the vehicle graphics together with sensor field displays (SFD) around the car")
            CdaReadableName("OPSWidgetBase")
            CdaCategory("Extra")

            CdaProperties()
                CdaProperty(OPSMini, OPSMiniType, GetOPSMini, SetOPSMini)
                    CdaDescription("If TRUE, Mini mode will be used")
                CdaPropertyEnd()
                CdaBindableProperty(OPSWidgetType, OPSWidgetTypeType, GetOPSWidgetType, SetOPSWidgetType)
                    CdaDescription("OPSWidgetType: BySector or BySegment")
                CdaBindablePropertyEnd()
                CdaBindableProperty(OPSDisplayMode, OPSDisplayModeType, GetOPSDisplayMode, SetOPSDisplayMode)
                    CdaDescription("OPSDisplayMode: FrontAndRear or Around360 or RearOnly")
                CdaBindablePropertyEnd()
                CdaBindableProperty(TrailerConnected, TrailerConnectedType, GetTrailerConnected, SetTrailerConnected)
                    CdaDescription("Flag to identify Trailer is Connected or not")
                CdaBindablePropertyEnd()
                CdaBindableProperty(VehicleType, VehicleTypeType, GetVehicleType, SetVehicleType)
                    CdaDescription("Type of the vehicle")
                CdaBindablePropertyEnd()
                CdaBindableProperty(SensorsAvailable, SensorsAvailableType, GetSensorsAvailable, SetSensorsAvailable)
                    CdaDescription("Availability of the sensors around the car")
                CdaBindablePropertyEnd()
                CdaBindableProperty(SensorsSegmentValues, SensorsSegmentValuesType, GetSensorsSegmentValues, SetSensorsSegmentValues)
                    CdaDescription("Array of sensors which represent its availability: True or False")
                CdaBindablePropertyEnd()
                CdaBindableProperty(SegmentPreDefinedDistanceValues, SegmentPreDefinedDistanceValuesType, GetSegmentPreDefinedDistanceValues, SetSegmentPreDefinedDistanceValues)
                    CdaDescription("Pre defined segment values upon which the actual segment values to be compared")
                CdaBindablePropertyEnd()
                CdaBindableProperty(StatusValues, StatusValuesType, GetStatusValues, SetStatusValues)
                    CdaDescription("array of status values to find the segment color for all sectors")
                CdaBindablePropertyEnd()
                CdaBindableProperty(SensorFieldBlinking, SensorFieldBlinkingType, GetSensorFieldBlinking, SetSensorFieldBlinking)
                    CdaDescription("If true, the sensor field is blinking depending on the BlinkInterval")
                CdaBindablePropertyEnd()
                CdaBindableProperty(BlinkInterval, BlinkIntervalType, GetBlinkInterval, SetBlinkInterval)
                    CdaDescription("For each of the sensor fields: Blinking time interval in msec.")
                CdaBindablePropertyEnd()
                CdaBindableProperty(SensorFieldHatched, SensorFieldHatchedType, GetSensorFieldHatched, SetSensorFieldHatched)
                    CdaDescription("True if field is hatched, for each of the sensor fields.")
                CdaBindablePropertyEnd()
                CdaBindableProperty(SensorFieldScanned, SensorFieldScannedType, GetSensorFieldScanned, SetSensorFieldScanned)
                    CdaDescription("True if field is scanned, for flanks.")
                CdaBindablePropertyEnd()
                CdaBindableProperty(LeftRTAStatuslevel, LeftRTAStatuslevelType, GetLeftRTAStatuslevel, SetLeftRTAStatuslevel)
                    CdaDescription("Left RTA status: 0->No sensor, other values->Sensor available")
                CdaBindablePropertyEnd()
                CdaBindableProperty(RightRTAStatuslevel, RightRTAStatuslevelType, GetRightRTAStatuslevel, SetRightRTAStatuslevel)
                    CdaDescription("Right RTA status: 0->No sensor, other values->Sensor available")
                CdaBindablePropertyEnd()
                CdaBindableProperty(LeftRTADistanceValue, LeftRTADistanceValueType, GetLeftRTADistanceValue, SetLeftRTADistanceValue)
                    CdaDescription("Left RTA distance value: (0x1,0x02,0x03)")
                CdaBindablePropertyEnd()
                CdaBindableProperty(RightRTADistanceValue, RightRTADistanceValueType, GetRightRTADistanceValue, SetRightRTADistanceValue)
                    CdaDescription("Right RTA distance value: (0x1,0x02,0x03)")
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        OPSMiniType m_OPSMini;
        OPSWidgetTypeType m_OPSWidgetType;
        OPSDisplayModeType m_OPSDisplayMode;
        TrailerConnectedType m_TrailerConnected;
        VehicleTypeType m_VehicleType;
        SensorsAvailableType m_SensorsAvailable;
        SensorsSegmentValuesType m_SensorsSegmentValues;
        SegmentPreDefinedDistanceValuesType m_SegmentPreDefinedDistanceValues;
        StatusValuesType m_StatusValues;
        SensorFieldBlinkingType m_SensorFieldBlinking;
        BlinkIntervalType m_BlinkInterval;
        SensorFieldHatchedType m_SensorFieldHatched;
        SensorFieldScannedType m_SensorFieldScanned;
        LeftRTAStatuslevelType m_LeftRTAStatuslevel;
        RightRTAStatuslevelType m_RightRTAStatuslevel;
        LeftRTADistanceValueType m_LeftRTADistanceValue;
        RightRTADistanceValueType m_RightRTADistanceValue;
};

#endif // OPSWidgetBase_h
