/************************************************************************
*FILE: MeterWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(MeterWidget2DBase_h)
#define MeterWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/BaseWidget2D.h>
// Enum data types
#define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(RotationType)  \
    ENUM_DATA_TYPE_ITEM(ClockWise)   \
    ENUM_DATA_TYPE_ITEM(AntiClockWise)   \
    ENUM_DATA_TYPE_END(RotationType)
#include <Candera/System/MetaInfo/EnumDataType.h>
// ------------------------------------------------------------------------
//! [MeterWidget2DBase_Declaration]
class MeterWidget2DBase : public ::BaseWidget2D
{
    public:
        typedef Candera::Float CurrentValueType;

        typedef Candera::Float MinimumValueType;

        typedef Candera::Float MaximumValueType;

        typedef Candera::Float MinimumAngleType;

        typedef Candera::Float MaximumAngleType;

        typedef Candera::RotationType RotationTypeType;

        typedef Candera::Node2D* IndicatorNodeType;

        //! [Property_IDs]
        static const FeatStd::UInt32 CurrentValuePropertyId = 0x3F4BD799;
        //! [Property_IDs]

        MeterWidget2DBase();
        virtual ~MeterWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(MeterWidget2DBase, ::BaseWidget2D);

        //! [DataBinding_CurrentValuePropertyGetterSetter]
        void SetCurrentValue(const CurrentValueType& currentvalue);
        const CurrentValueType& GetCurrentValue() const { return m_CurrentValue; }
        //! [DataBinding_CurrentValuePropertyGetterSetter]

        void SetMinimumValue(const MinimumValueType& minimumvalue);
        const MinimumValueType& GetMinimumValue() const { return m_MinimumValue; }

        void SetMaximumValue(const MaximumValueType& maximumvalue);
        const MaximumValueType& GetMaximumValue() const { return m_MaximumValue; }

        void SetMinimumAngle(const MinimumAngleType& minimumangle);
        const MinimumAngleType& GetMinimumAngle() const { return m_MinimumAngle; }

        void SetMaximumAngle(const MaximumAngleType& maximumangle);
        const MaximumAngleType& GetMaximumAngle() const { return m_MaximumAngle; }

        void SetRotationType(const RotationTypeType& rotationtype);
        const RotationTypeType& GetRotationType() const { return m_RotationType; }

        void SetIndicatorNode(const IndicatorNodeType& indicatornode);
        const IndicatorNodeType& GetIndicatorNode() const { return m_IndicatorNode; }

        // @WidgetBaseClass
        CdaWidget2DDef(MeterWidget2DBase, ::BaseWidget2D)
            CdaDescription("Widget which shows the progess in a circular direction")
            CdaReadableName("MeterWidget2DBase")
            CdaCategory("Extra")

            CdaProperties()
                CdaBindableProperty(CurrentValue, CurrentValueType, GetCurrentValue, SetCurrentValue)
                    CdaDescription("Indicates the Ongoing operation received from external component ")
                CdaBindablePropertyEnd()
                CdaProperty(MinimumValue, MinimumValueType, GetMinimumValue, SetMinimumValue)
                    CdaDescription("Start Value of the ProgressBar. Progress starts from this value.")
                CdaPropertyEnd()
                CdaProperty(MaximumValue, MaximumValueType, GetMaximumValue, SetMaximumValue)
                    CdaDescription("End Value of the ProgressBar. Progress ends at this value.")
                CdaPropertyEnd()
                CdaProperty(MinimumAngle, MinimumAngleType, GetMinimumAngle, SetMinimumAngle)
                    CdaDescription("Angle of the Indicator to represent the minimum value")
                CdaPropertyEnd()
                CdaProperty(MaximumAngle, MaximumAngleType, GetMaximumAngle, SetMaximumAngle)
                    CdaDescription("Angle of the Indicator to represent the maximum value")
                CdaPropertyEnd()
                CdaProperty(RotationType, RotationTypeType, GetRotationType, SetRotationType)
                    CdaDescription("Decides the direction the progress should happen - clockwise or anticlockwise direction")
                CdaPropertyEnd()
                CdaProperty(IndicatorNode, IndicatorNodeType, GetIndicatorNode, SetIndicatorNode)
                    CdaDescription("Node used as a pointer to rotate to show progress")
                CdaPropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        CurrentValueType m_CurrentValue;
        MinimumValueType m_MinimumValue;
        MaximumValueType m_MaximumValue;
        MinimumAngleType m_MinimumAngle;
        MaximumAngleType m_MaximumAngle;
        RotationTypeType m_RotationType;
        IndicatorNodeType m_IndicatorNode;
};

#endif // MeterWidget2DBase_h
