/************************************************************************
*FILE: ListWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(ListWidget2DBase_h)
#define ListWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/List/generated/ListEnums.h>
#include <Widgets/2D/List/generated/ListMessages.h>
#include <CanderaAssetLoader/AssetLoaderBase/ArrayProperty.h>
#include <CanderaAssetLoader/AssetLoaderBase/ArrayDataType.h>
#include <Widgets/2D/Touchable2D.h>
#include <Widgets/2D/Common/FlexScrollable.h>
#include <Widgets/2D/Common/MetaInfoEnums.h>

namespace Candera {
    namespace MetaInfo {
        template<> struct DataType<Animation::AnimationPlayer::SharedPointer> {
#ifdef WIN32
            static inline const Char* GetEditor() {
                return Candera::MetaInfo::Internal::DataType<Animation::AnimationPlayer::SharedPointer>::GetEditor();
            }
            static inline bool ConvertToString(Animation::AnimationPlayer::SharedPointer object, Char* buf, UInt bufLen) {
                return Candera::MetaInfo::Internal::DataType<Animation::AnimationPlayer::SharedPointer>::ConvertToString(object, buf, bufLen);
            }
#endif
            static inline bool ConvertFromString(Animation::AnimationPlayer::SharedPointer object, const Char* buf) {
                return Candera::MetaInfo::Internal::DataType<Animation::AnimationPlayer::SharedPointer>::ConvertFromString(object, buf);
            }
        };
    }
}
// ------------------------------------------------------------------------
//! [ListWidget2DBase_Declaration]
class ListWidget2DBase : public ::Touchable2D
{
    public:
        typedef Candera::ArrayProperty<Candera::Animation::AnimationPlayer::SharedPointer> TemplateScrollAnimationType;
        typedef Candera::ArrayProperty<Candera::Animation::AnimationPlayer::SharedPointer> CustomListAnimationType;

        virtual bool IsNumberOfItemsVisible() const { return true; }
        virtual bool AreScrollbarPropertiesVisible() const { return true; }
        virtual bool AreListAlignmentPropertiesVisible() const { return true; }
        virtual bool AreCoverflowPropertiesVisible() const { return true; }
        virtual bool AreFixedPageScrollingPropertiesVisible() const { return true; }
        virtual bool IsFixedPageScrollingOffsetPropertiesVisible() const { return GetFixedPageScrolling(); }
        virtual bool AreAcceptImmediatePositioningPropertiesVisible() const { return true; }
        virtual bool ArePixelWiseScrollingPropertiesVisible() const { return true; }
        virtual bool AreDeprecatedSwipingPropertiesVisible() const { return false; }
        virtual bool AreLimitExceededAnimationPropertiesVisible() const { return true; }
        virtual bool IsScrollingTypeVisible() const { return true; }
        virtual bool IsScrollAnimationInputVisible() const { return true; }
        virtual bool IsLockOutFixMovementVisible() const { return true; }
        virtual bool IsLayoutCachingVisible() const { return true; }
        virtual bool IsItemCacheBufferSizeVisible() const { return true; }
        virtual bool IsSnappingVisible() const { return GetPixelWiseScrollingEnabled(); }
        virtual bool IsDynamicGridPropertyVisible() const { return false; }

        bool IsFixedPageScrollingEnabled() const { return AreFixedPageScrollingPropertiesVisible() && GetFixedPageScrolling(); }
        bool IsAcceptImmediatePositioningEnabled() const { return AreAcceptImmediatePositioningPropertiesVisible() && GetAcceptImmediatePositioning(); }
        bool IsPixelWiseScrollingEnabled() const { return ArePixelWiseScrollingPropertiesVisible() && GetPixelWiseScrollingEnabled(); }
        bool AreLimitExceededUpAnimationPropertiesVisible() const { return (AreLimitExceededAnimationPropertiesVisible() && Candera::NoAnimation != GetLimitExceededUpAnimationType()); }
        bool AreLimitExceededDownAnimationPropertiesVisible() const { return (AreLimitExceededAnimationPropertiesVisible() && Candera::NoAnimation != GetLimitExceededDownAnimationType()); }
        bool AreLimitReachedUpAnimationPropertiesVisible() const { return (AreLimitExceededAnimationPropertiesVisible() && Candera::NoAnimation != GetLimitReachedUpAnimationType()); }
        bool AreLimitReachedDownAnimationPropertiesVisible() const { return (AreLimitExceededAnimationPropertiesVisible() && Candera::NoAnimation != GetLimitReachedUpAnimationType()); }
        bool IsAnimationOffsetVisible() const { return (GetScrollAnimationInput() == Candera::ScrollAnimationInput::PixelPositionBased); }
        bool AreSnappingPropertiesVisible() const { return (IsSnappingVisible() && GetSnap() != Candera::ListSnapType::SnapDefault); }
        bool IsDragAndSwipeOnNeedPropertyVisible() const { return (composerPropVisibleFilterDrag() && GetDrag()) || (composerPropVisibleFilterSwipe() && GetSwipe()); }
        typedef ::Candera::Node2D* ItemsNodeType;

        typedef ::Candera::Node2D* FocusedNodeType;

        typedef ::Candera::Node2D* TemplateGroupType;

        typedef ::Candera::Node2D* InvalidItemTemplateType;

        typedef ::Candera::Node2D* CustomAnimationsGroupNodeType;

        typedef ::Courier::UInt32 ListIdType;

        typedef ::Courier::UInt32 BufferSizeType;

        typedef ::Courier::UInt32 UpdateTriggerOffsetType;

        typedef ::Courier::Int32 FocusedIndexType;

        typedef ::Courier::Int32 StartIndexType;

        typedef ::Courier::UInt32 NumberOfItemsType;

        typedef bool ScrollbarAlwaysVisibleType;

        typedef Candera::ListAlignment::Enum ListAlignmentType;

        typedef bool PostListChangedType;

        typedef bool ExpandAutoScrollType;

        typedef bool DynamicGridType;

        typedef DynamicGridEmptyCellsPolicyType::Enum DynamicGridEmptyCellsPolicyType;

        typedef bool CoverflowType;

        typedef bool CachedLayoutType;

        typedef FeatStd::UInt8 PreparedItemsBufferSizeType;

        typedef FeatStd::UInt8 PreparedItemsUpdateTriggerOffsetType;

        typedef bool FixedPageScrollingType;

        typedef ::Courier::Float FixedPageScrollingOffsetType;

        typedef bool AcceptImmediatePositioningType;

        typedef bool AcceptImmediatePositioningOnFirstApperanceType;

        typedef bool AcceptImmediatePositioningOnPositionSetType;

        typedef bool AcceptImmediatePositioningOnPageScrollType;

        typedef bool AcceptImmediatePositioningOnItemScrollType;

        typedef bool PixelWiseScrollingEnabledType;

        typedef ::Courier::UInt32 PixelWiseAnimationTimeType;

        typedef ::Courier::UInt32 ShortPixelWiseAnimationTimeType;

        typedef ::Candera::ListScrollingOrientation ScrollingOrientationType;

        typedef ::Candera::ListScrollingType ScrollingTypeType;

        typedef ::FeatStd::Float LockOutFixMovementOffsetType;

        typedef ::Courier::UInt32 SwipingDistanceThresholdType;

        typedef ::Courier::UInt32 SwipingTimerThresholdType;

        typedef ::Candera::Float SwipingVelocityThresholdType;

        typedef ::Candera::Float SwipingAccelerationType;

        typedef ::Candera::Float SwipingMaxDistanceType;

        typedef ::IgnoreListChangeMsgType::Enum IgnoreListChangeMsgType;

        typedef bool DragAndSwipeOnNeedType;

        typedef Candera::ListSnapType::Enum SnapType;

        typedef ::Courier::UInt32 SnapHoldTimeType;

        typedef ::Candera::UInt32 SnapOffsetThresholdType;

        typedef ::Candera::LimitAnimationType LimitExceededUpAnimationTypeType;

        typedef ::FeatStd::UInt32 LimitExceededUpAnimationTimeType;

        typedef Candera::MemoryManagement::SharedPointer<Candera::Animation::AnimationPlayer> LimitExceededUpAnimationType;

        typedef Candera::Vector2 LimitExceededUpBounceAmplitudeType;

        typedef ::Candera::LimitAnimationType LimitExceededDownAnimationTypeType;

        typedef ::FeatStd::UInt32 LimitExceededDownAnimationTimeType;

        typedef Candera::MemoryManagement::SharedPointer<Candera::Animation::AnimationPlayer> LimitExceededDownAnimationType;

        typedef Candera::Vector2 LimitExceededDownBounceAmplitudeType;

        typedef ::Candera::LimitAnimationType LimitReachedUpAnimationTypeType;

        typedef ::FeatStd::UInt32 LimitReachedUpAnimationTimeType;

        typedef Candera::MemoryManagement::SharedPointer<Candera::Animation::AnimationPlayer> LimitReachedUpAnimationType;

        typedef Candera::Vector2 LimitReachedUpBounceAmplitudeType;

        typedef ::Candera::LimitAnimationType LimitReachedDownAnimationTypeType;

        typedef ::FeatStd::UInt32 LimitReachedDownAnimationTimeType;

        typedef Candera::MemoryManagement::SharedPointer<Candera::Animation::AnimationPlayer> LimitReachedDownAnimationType;

        typedef Candera::Vector2 LimitReachedDownBounceAmplitudeType;

        typedef Candera::ScrollAnimationInput::Enum ScrollAnimationInputType;

        typedef Candera::Int16 AnimationOffsetType;

        typedef bool ShowItemsOnViewActivatedType;

        typedef Candera::Margin UsableViewportPaddingType;

        typedef bool AutoViewportSizeType;

        //! [Property_IDs]
        static const FeatStd::UInt32 ItemsNodePropertyId = 0x15D5CB63;
        static const FeatStd::UInt32 FocusedNodePropertyId = 0x4C5F4782;
        static const FeatStd::UInt32 TemplateGroupPropertyId = 0x34F192F9;
        static const FeatStd::UInt32 InvalidItemTemplatePropertyId = 0xAD3ABD17;
        static const FeatStd::UInt32 CustomAnimationsGroupNodePropertyId = 0x3407553E;
        static const FeatStd::UInt32 ListIdPropertyId = 0xC17768D3;
        static const FeatStd::UInt32 BufferSizePropertyId = 0x259D250C;
        static const FeatStd::UInt32 UpdateTriggerOffsetPropertyId = 0xE8F82DE8;
        static const FeatStd::UInt32 FocusedIndexPropertyId = 0xE2BC20C4;
        static const FeatStd::UInt32 StartIndexPropertyId = 0x966FD154;
        static const FeatStd::UInt32 NumberOfItemsPropertyId = 0x069A6241;
        static const FeatStd::UInt32 ScrollbarAlwaysVisiblePropertyId = 0xCEC9D5D0;
        static const FeatStd::UInt32 ListAlignmentPropertyId = 0x22FCAD99;
        static const FeatStd::UInt32 PostListChangedPropertyId = 0x068E3158;
        static const FeatStd::UInt32 ExpandAutoScrollPropertyId = 0x90F3799F;
        static const FeatStd::UInt32 DynamicGridPropertyId = 0x56DFA8AA;
        static const FeatStd::UInt32 DynamicGridEmptyCellsPolicyPropertyId = 0xE212CE80;
        static const FeatStd::UInt32 CoverflowPropertyId = 0xC2F1C9B5;
        static const FeatStd::UInt32 CachedLayoutPropertyId = 0x65A9A3CB;
        static const FeatStd::UInt32 PreparedItemsBufferSizePropertyId = 0xEF8AC459;
        static const FeatStd::UInt32 PreparedItemsUpdateTriggerOffsetPropertyId = 0x0DB738BA;
        static const FeatStd::UInt32 FixedPageScrollingPropertyId = 0x2FA41D3F;
        static const FeatStd::UInt32 FixedPageScrollingOffsetPropertyId = 0xEE72ABD6;
        static const FeatStd::UInt32 AcceptImmediatePositioningPropertyId = 0x67CE7E6E;
        static const FeatStd::UInt32 AcceptImmediatePositioningOnFirstApperancePropertyId = 0xD48D8A9D;
        static const FeatStd::UInt32 AcceptImmediatePositioningOnPositionSetPropertyId = 0x872CC440;
        static const FeatStd::UInt32 AcceptImmediatePositioningOnPageScrollPropertyId = 0xC33F9B6B;
        static const FeatStd::UInt32 AcceptImmediatePositioningOnItemScrollPropertyId = 0x2602592B;
        static const FeatStd::UInt32 PixelWiseScrollingEnabledPropertyId = 0x8A5BB13A;
        static const FeatStd::UInt32 PixelWiseAnimationTimePropertyId = 0xF4297B7F;
        static const FeatStd::UInt32 ShortPixelWiseAnimationTimePropertyId = 0xECB80DA0;
        static const FeatStd::UInt32 ScrollingOrientationPropertyId = 0x3C8B5CB5;
        static const FeatStd::UInt32 ScrollingTypePropertyId = 0x6118813E;
        static const FeatStd::UInt32 LockOutFixMovementOffsetPropertyId = 0x5A376B85;
        static const FeatStd::UInt32 SwipingDistanceThresholdPropertyId = 0x1C869C1B;
        static const FeatStd::UInt32 SwipingTimerThresholdPropertyId = 0x9B078AB3;
        static const FeatStd::UInt32 SwipingVelocityThresholdPropertyId = 0x150F5DAD;
        static const FeatStd::UInt32 SwipingAccelerationPropertyId = 0xEEFB6CC7;
        static const FeatStd::UInt32 SwipingMaxDistancePropertyId = 0x2B102784;
        static const FeatStd::UInt32 SnapPropertyId = 0x1404299B;
        static const FeatStd::UInt32 SnapHoldTimePropertyId = 0x30DB45D2;
        static const FeatStd::UInt32 SnapOffsetThresholdPropertyId = 0x2EDCF1A1;
        static const FeatStd::UInt32 LimitExceededUpAnimationTypePropertyId = 0x4AB8171F;
        static const FeatStd::UInt32 LimitExceededUpAnimationTimePropertyId = 0x87A4D638;
        static const FeatStd::UInt32 LimitExceededUpAnimationPropertyId = 0x5B987EE9;
        static const FeatStd::UInt32 LimitExceededUpBounceAmplitudePropertyId = 0x85D598AB;
        static const FeatStd::UInt32 LimitExceededDownAnimationTypePropertyId = 0xDD3E344B;
        static const FeatStd::UInt32 LimitExceededDownAnimationTimePropertyId = 0x6FF60620;
        static const FeatStd::UInt32 LimitExceededDownAnimationPropertyId = 0xAC1F4290;
        static const FeatStd::UInt32 LimitExceededDownBounceAmplitudePropertyId = 0x92277E92;
        static const FeatStd::UInt32 LimitReachedUpAnimationTypePropertyId = 0xA31835C3;
        static const FeatStd::UInt32 LimitReachedUpAnimationTimePropertyId = 0x1379DA16;
        static const FeatStd::UInt32 LimitReachedUpAnimationPropertyId = 0x22F2A1C7;
        static const FeatStd::UInt32 LimitReachedUpBounceAmplitudePropertyId = 0x94546C53;
        static const FeatStd::UInt32 LimitReachedDownAnimationTypePropertyId = 0x4E1537D8;
        static const FeatStd::UInt32 LimitReachedDownAnimationTimePropertyId = 0x4304BA43;
        static const FeatStd::UInt32 LimitReachedDownAnimationPropertyId = 0x183E3DD9;
        static const FeatStd::UInt32 LimitReachedDownBounceAmplitudePropertyId = 0xCBA2C9E7;
        static const FeatStd::UInt32 UsableViewportPaddingPropertyId = 0xE1ADDA5F;
        static const FeatStd::UInt32 AutoViewportSizePropertyId = 0x6D794C99;
        //! [Property_IDs]

        ListWidget2DBase();
        virtual ~ListWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(ListWidget2DBase, ::Touchable2D);

        void SetItemsNode(const ItemsNodeType& itemsnode);
        const ItemsNodeType& GetItemsNode() const { return m_ItemsNode; }

        void SetFocusedNode(const FocusedNodeType& focusednode);
        const FocusedNodeType& GetFocusedNode() const { return m_FocusedNode; }

        void SetTemplateGroup(const TemplateGroupType& templategroup);
        const TemplateGroupType& GetTemplateGroup() const { return m_TemplateGroup; }

        void SetInvalidItemTemplate(const InvalidItemTemplateType& invaliditemtemplate);
        const InvalidItemTemplateType& GetInvalidItemTemplate() const { return m_InvalidItemTemplate; }

        void SetCustomAnimationsGroupNode(const CustomAnimationsGroupNodeType& customanimationsgroupnode);
        const CustomAnimationsGroupNodeType& GetCustomAnimationsGroupNode() const { return m_CustomAnimationsGroupNode; }

        //! [DataBinding_ListIdPropertyGetterSetter]
        void SetListId(const ListIdType& listid);
        const ListIdType& GetListId() const { return m_ListId; }
        //! [DataBinding_ListIdPropertyGetterSetter]

        //! [DataBinding_BufferSizePropertyGetterSetter]
        void SetBufferSize(const BufferSizeType& buffersize);
        const BufferSizeType& GetBufferSize() const { return m_BufferSize; }
        //! [DataBinding_BufferSizePropertyGetterSetter]

        //! [DataBinding_UpdateTriggerOffsetPropertyGetterSetter]
        void SetUpdateTriggerOffset(const UpdateTriggerOffsetType& updatetriggeroffset);
        const UpdateTriggerOffsetType& GetUpdateTriggerOffset() const { return m_UpdateTriggerOffset; }
        //! [DataBinding_UpdateTriggerOffsetPropertyGetterSetter]

        //! [DataBinding_FocusedIndexPropertyGetterSetter]
        void SetFocusedIndex(const FocusedIndexType& focusedindex);
        const FocusedIndexType& GetFocusedIndex() const { return m_FocusedIndex; }
        //! [DataBinding_FocusedIndexPropertyGetterSetter]

        //! [DataBinding_StartIndexPropertyGetterSetter]
        void SetStartIndex(const StartIndexType& startindex);
        const StartIndexType& GetStartIndex() const { return m_StartIndex; }
        //! [DataBinding_StartIndexPropertyGetterSetter]

        //! [DataBinding_NumberOfItemsPropertyGetterSetter]
        void SetNumberOfItems(const NumberOfItemsType& numberofitems);
        const NumberOfItemsType& GetNumberOfItems() const { return m_NumberOfItems; }
        //! [DataBinding_NumberOfItemsPropertyGetterSetter]

        //! [DataBinding_ScrollbarAlwaysVisiblePropertyGetterSetter]
        void SetScrollbarAlwaysVisible(const ScrollbarAlwaysVisibleType& scrollbaralwaysvisible);
        const ScrollbarAlwaysVisibleType& GetScrollbarAlwaysVisible() const { return m_ScrollbarAlwaysVisible; }
        //! [DataBinding_ScrollbarAlwaysVisiblePropertyGetterSetter]

        void SetListAlignment(const ListAlignmentType& listalignment);
        const ListAlignmentType& GetListAlignment() const { return m_ListAlignment; }

        void SetPostListChanged(const PostListChangedType& postlistchanged);
        const PostListChangedType& GetPostListChanged() const { return m_PostListChanged; }

        //! [DataBinding_ExpandAutoScrollPropertyGetterSetter]
        void SetExpandAutoScroll(const ExpandAutoScrollType& expandautoscroll);
        const ExpandAutoScrollType& GetExpandAutoScroll() const { return m_ExpandAutoScroll; }
        //! [DataBinding_ExpandAutoScrollPropertyGetterSetter]

        void SetDynamicGrid(const DynamicGridType& dynamicgrid);
        const DynamicGridType& GetDynamicGrid() const { return m_DynamicGrid; }

        void SetDynamicGridEmptyCellsPolicy(const DynamicGridEmptyCellsPolicyType& dynamicgridemptycellspolicy);
        const DynamicGridEmptyCellsPolicyType& GetDynamicGridEmptyCellsPolicy() const { return m_DynamicGridEmptyCellsPolicy; }

        //! [DataBinding_CoverflowPropertyGetterSetter]
        void SetCoverflow(const CoverflowType& coverflow);
        const CoverflowType& GetCoverflow() const { return m_Coverflow; }
        //! [DataBinding_CoverflowPropertyGetterSetter]

        void SetCachedLayout(const CachedLayoutType& cachedlayout);
        const CachedLayoutType& GetCachedLayout() const { return m_CachedLayout; }

        void SetPreparedItemsBufferSize(const PreparedItemsBufferSizeType& prepareditemsbuffersize);
        const PreparedItemsBufferSizeType& GetPreparedItemsBufferSize() const { return m_PreparedItemsBufferSize; }

        void SetPreparedItemsUpdateTriggerOffset(const PreparedItemsUpdateTriggerOffsetType& prepareditemsupdatetriggeroffset);
        const PreparedItemsUpdateTriggerOffsetType& GetPreparedItemsUpdateTriggerOffset() const { return m_PreparedItemsUpdateTriggerOffset; }

        //! [DataBinding_FixedPageScrollingPropertyGetterSetter]
        void SetFixedPageScrolling(const FixedPageScrollingType& fixedpagescrolling);
        const FixedPageScrollingType& GetFixedPageScrolling() const { return m_FixedPageScrolling; }
        //! [DataBinding_FixedPageScrollingPropertyGetterSetter]

        //! [DataBinding_FixedPageScrollingOffsetPropertyGetterSetter]
        void SetFixedPageScrollingOffset(const FixedPageScrollingOffsetType& fixedpagescrollingoffset);
        const FixedPageScrollingOffsetType& GetFixedPageScrollingOffset() const { return m_FixedPageScrollingOffset; }
        //! [DataBinding_FixedPageScrollingOffsetPropertyGetterSetter]

        //! [DataBinding_AcceptImmediatePositioningPropertyGetterSetter]
        void SetAcceptImmediatePositioning(const AcceptImmediatePositioningType& acceptimmediatepositioning);
        const AcceptImmediatePositioningType& GetAcceptImmediatePositioning() const { return m_AcceptImmediatePositioning; }
        //! [DataBinding_AcceptImmediatePositioningPropertyGetterSetter]

        //! [DataBinding_AcceptImmediatePositioningOnFirstApperancePropertyGetterSetter]
        void SetAcceptImmediatePositioningOnFirstApperance(const AcceptImmediatePositioningOnFirstApperanceType& acceptimmediatepositioningonfirstapperance);
        const AcceptImmediatePositioningOnFirstApperanceType& GetAcceptImmediatePositioningOnFirstApperance() const { return m_AcceptImmediatePositioningOnFirstApperance; }
        //! [DataBinding_AcceptImmediatePositioningOnFirstApperancePropertyGetterSetter]

        //! [DataBinding_AcceptImmediatePositioningOnPositionSetPropertyGetterSetter]
        void SetAcceptImmediatePositioningOnPositionSet(const AcceptImmediatePositioningOnPositionSetType& acceptimmediatepositioningonpositionset);
        const AcceptImmediatePositioningOnPositionSetType& GetAcceptImmediatePositioningOnPositionSet() const { return m_AcceptImmediatePositioningOnPositionSet; }
        //! [DataBinding_AcceptImmediatePositioningOnPositionSetPropertyGetterSetter]

        //! [DataBinding_AcceptImmediatePositioningOnPageScrollPropertyGetterSetter]
        void SetAcceptImmediatePositioningOnPageScroll(const AcceptImmediatePositioningOnPageScrollType& acceptimmediatepositioningonpagescroll);
        const AcceptImmediatePositioningOnPageScrollType& GetAcceptImmediatePositioningOnPageScroll() const { return m_AcceptImmediatePositioningOnPageScroll; }
        //! [DataBinding_AcceptImmediatePositioningOnPageScrollPropertyGetterSetter]

        //! [DataBinding_AcceptImmediatePositioningOnItemScrollPropertyGetterSetter]
        void SetAcceptImmediatePositioningOnItemScroll(const AcceptImmediatePositioningOnItemScrollType& acceptimmediatepositioningonitemscroll);
        const AcceptImmediatePositioningOnItemScrollType& GetAcceptImmediatePositioningOnItemScroll() const { return m_AcceptImmediatePositioningOnItemScroll; }
        //! [DataBinding_AcceptImmediatePositioningOnItemScrollPropertyGetterSetter]

        //! [DataBinding_PixelWiseScrollingEnabledPropertyGetterSetter]
        void SetPixelWiseScrollingEnabled(const PixelWiseScrollingEnabledType& pixelwisescrollingenabled);
        const PixelWiseScrollingEnabledType& GetPixelWiseScrollingEnabled() const { return m_PixelWiseScrollingEnabled; }
        //! [DataBinding_PixelWiseScrollingEnabledPropertyGetterSetter]

        //! [DataBinding_PixelWiseAnimationTimePropertyGetterSetter]
        void SetPixelWiseAnimationTime(const PixelWiseAnimationTimeType& pixelwiseanimationtime);
        const PixelWiseAnimationTimeType& GetPixelWiseAnimationTime() const { return m_PixelWiseAnimationTime; }
        //! [DataBinding_PixelWiseAnimationTimePropertyGetterSetter]

        //! [DataBinding_ShortPixelWiseAnimationTimePropertyGetterSetter]
        void SetShortPixelWiseAnimationTime(const ShortPixelWiseAnimationTimeType& shortpixelwiseanimationtime);
        const ShortPixelWiseAnimationTimeType& GetShortPixelWiseAnimationTime() const { return m_ShortPixelWiseAnimationTime; }
        //! [DataBinding_ShortPixelWiseAnimationTimePropertyGetterSetter]

        //! [DataBinding_ScrollingOrientationPropertyGetterSetter]
        void SetScrollingOrientation(const ScrollingOrientationType& scrollingorientation);
        const ScrollingOrientationType& GetScrollingOrientation() const { return m_ScrollingOrientation; }
        //! [DataBinding_ScrollingOrientationPropertyGetterSetter]

        void SetScrollingType(const ScrollingTypeType& scrollingtype);
        const ScrollingTypeType& GetScrollingType() const { return m_ScrollingType; }

        void SetLockOutFixMovementOffset(const LockOutFixMovementOffsetType& lockoutfixmovementoffset);
        const LockOutFixMovementOffsetType& GetLockOutFixMovementOffset() const { return m_LockOutFixMovementOffset; }

        //! [DataBinding_SwipingDistanceThresholdPropertyGetterSetter]
        void SetSwipingDistanceThreshold(const SwipingDistanceThresholdType& swipingdistancethreshold);
        const SwipingDistanceThresholdType& GetSwipingDistanceThreshold() const { return m_SwipingDistanceThreshold; }
        //! [DataBinding_SwipingDistanceThresholdPropertyGetterSetter]

        //! [DataBinding_SwipingTimerThresholdPropertyGetterSetter]
        void SetSwipingTimerThreshold(const SwipingTimerThresholdType& swipingtimerthreshold);
        const SwipingTimerThresholdType& GetSwipingTimerThreshold() const { return m_SwipingTimerThreshold; }
        //! [DataBinding_SwipingTimerThresholdPropertyGetterSetter]

        //! [DataBinding_SwipingVelocityThresholdPropertyGetterSetter]
        void SetSwipingVelocityThreshold(const SwipingVelocityThresholdType& swipingvelocitythreshold);
        const SwipingVelocityThresholdType& GetSwipingVelocityThreshold() const { return m_SwipingVelocityThreshold; }
        //! [DataBinding_SwipingVelocityThresholdPropertyGetterSetter]

        //! [DataBinding_SwipingAccelerationPropertyGetterSetter]
        void SetSwipingAcceleration(const SwipingAccelerationType& swipingacceleration);
        const SwipingAccelerationType& GetSwipingAcceleration() const { return m_SwipingAcceleration; }
        //! [DataBinding_SwipingAccelerationPropertyGetterSetter]

        //! [DataBinding_SwipingMaxDistancePropertyGetterSetter]
        void SetSwipingMaxDistance(const SwipingMaxDistanceType& swipingmaxdistance);
        const SwipingMaxDistanceType& GetSwipingMaxDistance() const { return m_SwipingMaxDistance; }
        //! [DataBinding_SwipingMaxDistancePropertyGetterSetter]

        void SetIgnoreListChangeMsg(const IgnoreListChangeMsgType& ignorelistchangemsg);
        const IgnoreListChangeMsgType& GetIgnoreListChangeMsg() const { return m_IgnoreListChangeMsg; }
        IgnoreListChangeMsgType& GetIgnoreListChangeMsg() { return m_IgnoreListChangeMsg; }

        //! [DataBinding_DragAndSwipeOnNeedPropertyGetterSetter]
        void SetDragAndSwipeOnNeed(const DragAndSwipeOnNeedType& dragandswipeonneed);
        const DragAndSwipeOnNeedType& GetDragAndSwipeOnNeed() const { return m_DragAndSwipeOnNeed; }
        //! [DataBinding_DragAndSwipeOnNeedPropertyGetterSetter]

        void SetSnap(const SnapType& snap);
        const SnapType& GetSnap() const { return m_Snap; }

        void SetSnapHoldTime(const SnapHoldTimeType& snapholdtime);
        const SnapHoldTimeType& GetSnapHoldTime() const { return m_SnapHoldTime; }

        void SetSnapOffsetThreshold(const SnapOffsetThresholdType& snapoffsetthreshold);
        const SnapOffsetThresholdType& GetSnapOffsetThreshold() const { return m_SnapOffsetThreshold; }

        //! [DataBinding_LimitExceededUpAnimationTypePropertyGetterSetter]
        void SetLimitExceededUpAnimationType(const LimitExceededUpAnimationTypeType& limitexceededupanimationtype);
        const LimitExceededUpAnimationTypeType& GetLimitExceededUpAnimationType() const { return m_LimitExceededUpAnimationType; }
        //! [DataBinding_LimitExceededUpAnimationTypePropertyGetterSetter]

        //! [DataBinding_LimitExceededUpAnimationTimePropertyGetterSetter]
        void SetLimitExceededUpAnimationTime(const LimitExceededUpAnimationTimeType& limitexceededupanimationtime);
        const LimitExceededUpAnimationTimeType& GetLimitExceededUpAnimationTime() const { return m_LimitExceededUpAnimationTime; }
        LimitExceededUpAnimationTimeType& GetLimitExceededUpAnimationTime() { return m_LimitExceededUpAnimationTime; }
        //! [DataBinding_LimitExceededUpAnimationTimePropertyGetterSetter]

        void SetLimitExceededUpAnimation(const LimitExceededUpAnimationType& limitexceededupanimation);
        const LimitExceededUpAnimationType& GetLimitExceededUpAnimation() const { return m_LimitExceededUpAnimation; }
        LimitExceededUpAnimationType& GetLimitExceededUpAnimation() { return m_LimitExceededUpAnimation; }

        //! [DataBinding_LimitExceededUpBounceAmplitudePropertyGetterSetter]
        void SetLimitExceededUpBounceAmplitude(const LimitExceededUpBounceAmplitudeType& limitexceededupbounceamplitude);
        const LimitExceededUpBounceAmplitudeType& GetLimitExceededUpBounceAmplitude() const { return m_LimitExceededUpBounceAmplitude; }
        LimitExceededUpBounceAmplitudeType& GetLimitExceededUpBounceAmplitude() { return m_LimitExceededUpBounceAmplitude; }
        //! [DataBinding_LimitExceededUpBounceAmplitudePropertyGetterSetter]

        //! [DataBinding_LimitExceededDownAnimationTypePropertyGetterSetter]
        void SetLimitExceededDownAnimationType(const LimitExceededDownAnimationTypeType& limitexceededdownanimationtype);
        const LimitExceededDownAnimationTypeType& GetLimitExceededDownAnimationType() const { return m_LimitExceededDownAnimationType; }
        //! [DataBinding_LimitExceededDownAnimationTypePropertyGetterSetter]

        //! [DataBinding_LimitExceededDownAnimationTimePropertyGetterSetter]
        void SetLimitExceededDownAnimationTime(const LimitExceededDownAnimationTimeType& limitexceededdownanimationtime);
        const LimitExceededDownAnimationTimeType& GetLimitExceededDownAnimationTime() const { return m_LimitExceededDownAnimationTime; }
        LimitExceededDownAnimationTimeType& GetLimitExceededDownAnimationTime() { return m_LimitExceededDownAnimationTime; }
        //! [DataBinding_LimitExceededDownAnimationTimePropertyGetterSetter]

        void SetLimitExceededDownAnimation(const LimitExceededDownAnimationType& limitexceededdownanimation);
        const LimitExceededDownAnimationType& GetLimitExceededDownAnimation() const { return m_LimitExceededDownAnimation; }
        LimitExceededDownAnimationType& GetLimitExceededDownAnimation() { return m_LimitExceededDownAnimation; }

        //! [DataBinding_LimitExceededDownBounceAmplitudePropertyGetterSetter]
        void SetLimitExceededDownBounceAmplitude(const LimitExceededDownBounceAmplitudeType& limitexceededdownbounceamplitude);
        const LimitExceededDownBounceAmplitudeType& GetLimitExceededDownBounceAmplitude() const { return m_LimitExceededDownBounceAmplitude; }
        LimitExceededDownBounceAmplitudeType& GetLimitExceededDownBounceAmplitude() { return m_LimitExceededDownBounceAmplitude; }
        //! [DataBinding_LimitExceededDownBounceAmplitudePropertyGetterSetter]

        //! [DataBinding_LimitReachedUpAnimationTypePropertyGetterSetter]
        void SetLimitReachedUpAnimationType(const LimitReachedUpAnimationTypeType& limitreachedupanimationtype);
        const LimitReachedUpAnimationTypeType& GetLimitReachedUpAnimationType() const { return m_LimitReachedUpAnimationType; }
        //! [DataBinding_LimitReachedUpAnimationTypePropertyGetterSetter]

        //! [DataBinding_LimitReachedUpAnimationTimePropertyGetterSetter]
        void SetLimitReachedUpAnimationTime(const LimitReachedUpAnimationTimeType& limitreachedupanimationtime);
        const LimitReachedUpAnimationTimeType& GetLimitReachedUpAnimationTime() const { return m_LimitReachedUpAnimationTime; }
        LimitReachedUpAnimationTimeType& GetLimitReachedUpAnimationTime() { return m_LimitReachedUpAnimationTime; }
        //! [DataBinding_LimitReachedUpAnimationTimePropertyGetterSetter]

        void SetLimitReachedUpAnimation(const LimitReachedUpAnimationType& limitreachedupanimation);
        const LimitReachedUpAnimationType& GetLimitReachedUpAnimation() const { return m_LimitReachedUpAnimation; }
        LimitReachedUpAnimationType& GetLimitReachedUpAnimation() { return m_LimitReachedUpAnimation; }

        //! [DataBinding_LimitReachedUpBounceAmplitudePropertyGetterSetter]
        void SetLimitReachedUpBounceAmplitude(const LimitReachedUpBounceAmplitudeType& limitreachedupbounceamplitude);
        const LimitReachedUpBounceAmplitudeType& GetLimitReachedUpBounceAmplitude() const { return m_LimitReachedUpBounceAmplitude; }
        LimitReachedUpBounceAmplitudeType& GetLimitReachedUpBounceAmplitude() { return m_LimitReachedUpBounceAmplitude; }
        //! [DataBinding_LimitReachedUpBounceAmplitudePropertyGetterSetter]

        //! [DataBinding_LimitReachedDownAnimationTypePropertyGetterSetter]
        void SetLimitReachedDownAnimationType(const LimitReachedDownAnimationTypeType& limitreacheddownanimationtype);
        const LimitReachedDownAnimationTypeType& GetLimitReachedDownAnimationType() const { return m_LimitReachedDownAnimationType; }
        //! [DataBinding_LimitReachedDownAnimationTypePropertyGetterSetter]

        //! [DataBinding_LimitReachedDownAnimationTimePropertyGetterSetter]
        void SetLimitReachedDownAnimationTime(const LimitReachedDownAnimationTimeType& limitreacheddownanimationtime);
        const LimitReachedDownAnimationTimeType& GetLimitReachedDownAnimationTime() const { return m_LimitReachedDownAnimationTime; }
        LimitReachedDownAnimationTimeType& GetLimitReachedDownAnimationTime() { return m_LimitReachedDownAnimationTime; }
        //! [DataBinding_LimitReachedDownAnimationTimePropertyGetterSetter]

        void SetLimitReachedDownAnimation(const LimitReachedDownAnimationType& limitreacheddownanimation);
        const LimitReachedDownAnimationType& GetLimitReachedDownAnimation() const { return m_LimitReachedDownAnimation; }
        LimitReachedDownAnimationType& GetLimitReachedDownAnimation() { return m_LimitReachedDownAnimation; }

        //! [DataBinding_LimitReachedDownBounceAmplitudePropertyGetterSetter]
        void SetLimitReachedDownBounceAmplitude(const LimitReachedDownBounceAmplitudeType& limitreacheddownbounceamplitude);
        const LimitReachedDownBounceAmplitudeType& GetLimitReachedDownBounceAmplitude() const { return m_LimitReachedDownBounceAmplitude; }
        LimitReachedDownBounceAmplitudeType& GetLimitReachedDownBounceAmplitude() { return m_LimitReachedDownBounceAmplitude; }
        //! [DataBinding_LimitReachedDownBounceAmplitudePropertyGetterSetter]

        void SetScrollAnimationInput(const ScrollAnimationInputType& scrollanimationinput);
        const ScrollAnimationInputType& GetScrollAnimationInput() const { return m_ScrollAnimationInput; }
        ScrollAnimationInputType& GetScrollAnimationInput() { return m_ScrollAnimationInput; }

        void SetAnimationOffset(const AnimationOffsetType& animationoffset);
        const AnimationOffsetType& GetAnimationOffset() const { return m_AnimationOffset; }
        AnimationOffsetType& GetAnimationOffset() { return m_AnimationOffset; }

        void SetShowItemsOnViewActivated(const ShowItemsOnViewActivatedType& showitemsonviewactivated);
        const ShowItemsOnViewActivatedType& GetShowItemsOnViewActivated() const { return m_ShowItemsOnViewActivated; }
        ShowItemsOnViewActivatedType& GetShowItemsOnViewActivated() { return m_ShowItemsOnViewActivated; }

        void SetUsableViewportPadding(const UsableViewportPaddingType& usableviewportpadding);
        const UsableViewportPaddingType& GetUsableViewportPadding() const { return m_UsableViewportPadding; }
        UsableViewportPaddingType& GetUsableViewportPadding() { return m_UsableViewportPadding; }

        void SetAutoViewportSize(const AutoViewportSizeType& autoviewportsize);
        const AutoViewportSizeType& GetAutoViewportSize() const { return m_AutoViewportSize; }
        AutoViewportSizeType& GetAutoViewportSize() { return m_AutoViewportSize; }

        // @WidgetBaseClass
        CdaWidget2DDef(ListWidget2DBase, ::Touchable2D)
            CdaDescription("ListWidget2D widget")
            CdaReadableName("ListWidget2DBase")
            CdaCategory("List")

            CdaProperties()
                CdaProperty(ItemsNode, ItemsNodeType, GetItemsNode, SetItemsNode)
                    CdaDescription("The list items will be added as children of this node.")
                CdaPropertyEnd()
                CdaProperty(FocusedNode, FocusedNodeType, GetFocusedNode, SetFocusedNode)
                    CdaDescription("The node that will highlight the focused node.")
                CdaPropertyEnd()
                CdaProperty(TemplateGroup, TemplateGroupType, GetTemplateGroup, SetTemplateGroup)
                    CdaDescription("The parent of template nodes. Template nodes will be cloned based on the item needed to be displayed and the clone will be added to the ItemsNode.")
                CdaPropertyEnd()
                CdaProperty(InvalidItemTemplate, InvalidItemTemplateType, GetInvalidItemTemplate, SetInvalidItemTemplate)
                    CdaDescription("Template used for not yet available data or if no other template is found for some data.")
                CdaPropertyEnd()
                CdaProperty(CustomAnimationsGroupNode, CustomAnimationsGroupNodeType, GetCustomAnimationsGroupNode, SetCustomAnimationsGroupNode)
                    CdaDescription("Root node of animated nodes that are placeholders for the real items in the list. The animated properties will be aplied to the nodes that will be added by the list to the ItemsNode.")
                CdaPropertyEnd()
                CdaBindableProperty(ListId, ListIdType, GetListId, SetListId)
                    CdaDescription("A unique identifier of the list that will be used to request data to the model and react to data sent from the model.")
                CdaBindablePropertyEnd()
                CdaBindableProperty(BufferSize, BufferSizeType, GetBufferSize, SetBufferSize)
                    CdaDescription("Used for windowed data. The buffer size of the elements requested prior and after the visible ones.")
                CdaBindablePropertyEnd()
                CdaBindableProperty(UpdateTriggerOffset, UpdateTriggerOffsetType, GetUpdateTriggerOffset, SetUpdateTriggerOffset)
                    CdaDescription("Used for windowed data. The offset relative to the first or last visible item index, respectively used to request new data when reached.")
                CdaBindablePropertyEnd()
                CdaBindableProperty(FocusedIndex, FocusedIndexType, GetFocusedIndex, SetFocusedIndex)
                    CdaDescription("The index of the currently focused item.")
                CdaBindablePropertyEnd()
                CdaBindableProperty(StartIndex, StartIndexType, GetStartIndex, SetStartIndex)
                    CdaDescription("The index of the first visible item. Negative indices are accepted in case of circular scrolling.")
                CdaBindablePropertyEnd()
                CdaBindableProperty(NumberOfItems, NumberOfItemsType, GetNumberOfItems, SetNumberOfItems)
                    CdaDescription("The number of items is only available for itemwise lists(PixelWiseScrollingEnabled set to false). For stack layouted lists it has the meaning of the number of elements that would be visible. For grid layouted lists it has the meaning of the number of columns(for horizontal scrolling) or rows(for vertical scrolling) that will be seen. The number of rows(for horizontal scrolling) or columns(for vertical scrolling) will be taken from the GridLayouter.")
                    CdaVisibilityTest(IsNumberOfItemsVisible)
                CdaBindablePropertyEnd()
                CdaBindableProperty(ScrollbarAlwaysVisible, ScrollbarAlwaysVisibleType, GetScrollbarAlwaysVisible, SetScrollbarAlwaysVisible)
                    CdaDescription("If set to true, scrollbar is always visible, regardless if it's needed or not. If set to false, it's only visible if needed.")
                    CdaVisibilityTest(AreScrollbarPropertiesVisible)
                CdaBindablePropertyEnd()
                CdaProperty(ListAlignment, ListAlignmentType, GetListAlignment, SetListAlignment)
                    CdaDescription("Only applicable for lists with less then the maximum number of visible items. If set to 'End' the items will be aligned at the end of the list.")
                    CdaVisibilityTest(AreListAlignmentPropertiesVisible)
                CdaPropertyEnd()
                CdaProperty(PostListChanged, PostListChangedType, GetPostListChanged, SetPostListChanged)
                    CdaDescription("If true, the list will post a ListChangedUpdMsg message everytime the first visible index changes.")
                CdaPropertyEnd()
                CdaBindableProperty(ExpandAutoScroll, ExpandAutoScrollType, GetExpandAutoScroll, SetExpandAutoScroll)
                    CdaDescription("Wether or not expand animations scroll the list so that the expanded item fully fits inside the viewport.")
                CdaBindablePropertyEnd()
                CdaProperty(DynamicGrid, DynamicGridType, GetDynamicGrid, SetDynamicGrid)
                    CdaDescription("Whether or not the grid is automatically adapting to the text size.")
                    CdaVisibilityTest(IsDynamicGridPropertyVisible)
                    CdaCategory("Grid")
                CdaPropertyEnd()
                CdaProperty(DynamicGridEmptyCellsPolicy, DynamicGridEmptyCellsPolicyType, GetDynamicGridEmptyCellsPolicy, SetDynamicGridEmptyCellsPolicy)
                    CdaDescription("The policy to distribute the empty spaces in the last row of the list")
                    CdaVisibilityTest(GetDynamicGrid)
                    CdaCategory("Grid")
                CdaPropertyEnd()
                CdaBindableProperty(Coverflow, CoverflowType, GetCoverflow, SetCoverflow)
                    CdaDescription("True if the list is a coverflow.")
                    CdaVisibilityTest(AreCoverflowPropertiesVisible)
                    CdaCategory("Coverflow")
                CdaBindablePropertyEnd()
                CdaProperty(CachedLayout, CachedLayoutType, GetCachedLayout, SetCachedLayout)
                    CdaDescription("Caches the layout of the list entries, if set to true the layout calculation is done only once for each list item and than cached.")
                    CdaVisibilityTest(IsLayoutCachingVisible)
                    CdaCategory("Performance")
                CdaPropertyEnd()
                CdaProperty(PreparedItemsBufferSize, PreparedItemsBufferSizeType, GetPreparedItemsBufferSize, SetPreparedItemsBufferSize)
                    CdaDescription("Number of additional items being prepared when the list is idle")
                    CdaVisibilityTest(IsItemCacheBufferSizeVisible)
                    CdaCategory("Performance")
                CdaPropertyEnd()
                CdaProperty(PreparedItemsUpdateTriggerOffset, PreparedItemsUpdateTriggerOffsetType, GetPreparedItemsUpdateTriggerOffset, SetPreparedItemsUpdateTriggerOffset)
                    CdaDescription("Offset to the edge of the PreparedItemsBuffer - the prepared item buffer will be updated and old items discarded as soon as this offset is reached")
                    CdaVisibilityTest(IsItemCacheBufferSizeVisible)
                    CdaCategory("Performance")
                CdaPropertyEnd()
                CdaBindableProperty(FixedPageScrolling, FixedPageScrollingType, GetFixedPageScrolling, SetFixedPageScrolling)
                    CdaDescription("Works only of all the data is available(no windowed data). Should be used only with small lists. If set to true, the pages always start at a fix position, similar to a book. If set to false, the pages are always considered relative to the current start index.")
                    CdaVisibilityTest(AreFixedPageScrollingPropertiesVisible)
                    CdaCategory("Movement")
                CdaBindablePropertyEnd()
                CdaBindableProperty(FixedPageScrollingOffset, FixedPageScrollingOffsetType, GetFixedPageScrollingOffset, SetFixedPageScrollingOffset)
                    CdaDescription("Percentage of the viewport needed to be scrolled/swiped with the touch in order to go to the next/previous page.")
                    CdaVisibilityTest(IsFixedPageScrollingOffsetPropertiesVisible)
                    CdaCategory("Movement")
                CdaBindablePropertyEnd()
                CdaBindableProperty(AcceptImmediatePositioning, AcceptImmediatePositioningType, GetAcceptImmediatePositioning, SetAcceptImmediatePositioning)
                    CdaDescription("If set to true, immediate positioning is taken into consideration. Please check the other properties to enable immediate positioning for different events.")
                    CdaVisibilityTest(AreAcceptImmediatePositioningPropertiesVisible)
                    CdaCategory("Movement")
                CdaBindablePropertyEnd()
                CdaBindableProperty(AcceptImmediatePositioningOnFirstApperance, AcceptImmediatePositioningOnFirstApperanceType, GetAcceptImmediatePositioningOnFirstApperance, SetAcceptImmediatePositioningOnFirstApperance)
                    CdaDescription("If set to true, the first ListChangeMsg with ListChangeSet that is received after rendering is enabled for the view and if immediate positioning is activated, then the position is set to the received value without using an animation; further position setting uses an animation. If set to false, then the immediat positioning is ignored and the animation is always used to scroll to the given position.")
                    CdaVisibilityTest(IsAcceptImmediatePositioningEnabled)
                    CdaCategory("Movement")
                CdaBindablePropertyEnd()
                CdaBindableProperty(AcceptImmediatePositioningOnPositionSet, AcceptImmediatePositioningOnPositionSetType, GetAcceptImmediatePositioningOnPositionSet, SetAcceptImmediatePositioningOnPositionSet)
                    CdaDescription("If set to true, if a ListChangeMsg with ListChangeSet is received and immediate positioning is activated, then the position is set to the received value without using an animation. If set to false, then the immediat positioning is ignored and the animation is always used to scroll to the given position.")
                    CdaVisibilityTest(IsAcceptImmediatePositioningEnabled)
                    CdaCategory("Movement")
                CdaBindablePropertyEnd()
                CdaBindableProperty(AcceptImmediatePositioningOnPageScroll, AcceptImmediatePositioningOnPageScrollType, GetAcceptImmediatePositioningOnPageScroll, SetAcceptImmediatePositioningOnPageScroll)
                    CdaDescription("If set to true, if a ListChangeMsg with ListChangePageDown or ListChangePageUp is received and immediate positioning is activated, then the position is set to the received value without using an animation. If set to false, then the immediat positioning is ignored and the animation is always used to scroll to the given position.")
                    CdaVisibilityTest(IsAcceptImmediatePositioningEnabled)
                    CdaCategory("Movement")
                CdaBindablePropertyEnd()
                CdaBindableProperty(AcceptImmediatePositioningOnItemScroll, AcceptImmediatePositioningOnItemScrollType, GetAcceptImmediatePositioningOnItemScroll, SetAcceptImmediatePositioningOnItemScroll)
                    CdaDescription("If set to true, if a ListChangeMsg with ListChangeDown or ListChangeUp is received and immediate positioning is activated, then the position is set to the received value without using an animation. If set to false, then the immediate positioning is ignored and the animation is always used to scroll to the given position.")
                    CdaVisibilityTest(IsAcceptImmediatePositioningEnabled)
                    CdaCategory("Movement")
                CdaBindablePropertyEnd()
                CdaBindableProperty(PixelWiseScrollingEnabled, PixelWiseScrollingEnabledType, GetPixelWiseScrollingEnabled, SetPixelWiseScrollingEnabled)
                    CdaDescription("If set to true, scrolling is done pixel by pixel, meaning that an item can be partially visible. If set to false, scrolling is done item by item; items ar always completely visible.")
                    CdaVisibilityTest(ArePixelWiseScrollingPropertiesVisible)
                    CdaCategory("Movement")
                CdaBindablePropertyEnd()
                CdaBindableProperty(PixelWiseAnimationTime, PixelWiseAnimationTimeType, GetPixelWiseAnimationTime, SetPixelWiseAnimationTime)
                    CdaDescription("Time in ms to finish the pixel wise animation")
                    CdaVisibilityTest(IsPixelWiseScrollingEnabled)
                    CdaCategory("Movement")
                CdaBindablePropertyEnd()
                CdaBindableProperty(ShortPixelWiseAnimationTime, ShortPixelWiseAnimationTimeType, GetShortPixelWiseAnimationTime, SetShortPixelWiseAnimationTime)
                    CdaDescription("Short time in ms to finish the pixel wise animation; used when setting the position with a ListChangeSet request type")
                    CdaVisibilityTest(IsPixelWiseScrollingEnabled)
                    CdaCategory("Movement")
                CdaBindablePropertyEnd()
                CdaBindableProperty(ScrollingOrientation, ScrollingOrientationType, GetScrollingOrientation, SetScrollingOrientation)
                    CdaDescription("Scrolling orientation: vertical or horizontal")
                    CdaCategory("Movement")
                CdaBindablePropertyEnd()
                CdaProperty(ScrollingType, ScrollingTypeType, GetScrollingType, SetScrollingType)
                    CdaDescription("Sets the way this list scrolls: Default beginning to end, continous or last page not filled.")
                    CdaVisibilityTest(IsScrollingTypeVisible)
                    CdaCategory("Movement")
                CdaPropertyEnd()
                CdaProperty(LockOutFixMovementOffset, LockOutFixMovementOffsetType, GetLockOutFixMovementOffset, SetLockOutFixMovementOffset)
                    CdaDescription("Offset in percent of the viewport required for LockOutType LockOutFixMovement.")
                    CdaVisibilityTest(IsLockOutFixMovementVisible)
                    CdaCategory("Movement")
                CdaPropertyEnd()
                CdaBindableProperty(SwipingDistanceThreshold, SwipingDistanceThresholdType, GetSwipingDistanceThreshold, SetSwipingDistanceThreshold)
                    CdaDescription("Deprecated. Please do not use this, as it will be removed in a future version. Minimum distance in display units needed to drag in order to begin scrolling")
                    CdaVisibilityTest(AreDeprecatedSwipingPropertiesVisible)
                    CdaCategory("Touch")
                CdaBindablePropertyEnd()
                CdaBindableProperty(SwipingTimerThreshold, SwipingTimerThresholdType, GetSwipingTimerThreshold, SetSwipingTimerThreshold)
                    CdaDescription("Minimum time in ms needed to press in order to focus an item")
                    CdaVisibilityTest(IsTouchable)
                    CdaCategory("Touch")
                CdaBindablePropertyEnd()
                CdaBindableProperty(SwipingVelocityThreshold, SwipingVelocityThresholdType, GetSwipingVelocityThreshold, SetSwipingVelocityThreshold)
                    CdaDescription("Deprecated. Please do not use this, as it will be removed in a future version. Minimum velocity in display units/ms needed to move with in order to begin swiping")
                    CdaVisibilityTest(AreDeprecatedSwipingPropertiesVisible)
                    CdaCategory("Touch")
                CdaBindablePropertyEnd()
                CdaBindableProperty(SwipingAcceleration, SwipingAccelerationType, GetSwipingAcceleration, SetSwipingAcceleration)
                    CdaDescription("Acceleration used to slow down swiping")
                    CdaVisibilityTest(IsTouchable)
                    CdaCategory("Touch")
                CdaBindablePropertyEnd()
                CdaBindableProperty(SwipingMaxDistance, SwipingMaxDistanceType, GetSwipingMaxDistance, SetSwipingMaxDistance)
                    CdaDescription("Maximum distance that can be covered within one swipe")
                    CdaVisibilityTest(IsTouchable)
                    CdaCategory("Touch")
                CdaBindablePropertyEnd()
                CdaProperty(IgnoreListChangeMsg, IgnoreListChangeMsgType, GetIgnoreListChangeMsg, SetIgnoreListChangeMsg)
                    CdaDescription("Defines when the ListChangeMsg will be ignored douring the list scrolling or swiping")
                    CdaVisibilityTest(IsTouchable)
                    CdaCategory("Touch")
                CdaPropertyEnd()
                CdaBindableProperty(DragAndSwipeOnNeed, DragAndSwipeOnNeedType, GetDragAndSwipeOnNeed, SetDragAndSwipeOnNeed)
                    CdaDescription("If true then drag and swipe will be dynamically disabled when a new touch session starts if all items are visible.")
                    CdaVisibilityTest(IsDragAndSwipeOnNeedPropertyVisible)
                    CdaCategory("Gestures")
                CdaBindablePropertyEnd()
                CdaProperty(Snap, SnapType, GetSnap, SetSnap)
                    CdaDescription("Specifies how the list should behave after scrolling. SnapToEdge - List will snap to the nearest edge, SnapToCenter - List will snap to the center")
                    CdaVisibilityTest(IsSnappingVisible)
                    CdaCategory("Snapping")
                CdaPropertyEnd()
                CdaProperty(SnapHoldTime, SnapHoldTimeType, GetSnapHoldTime, SetSnapHoldTime)
                    CdaDescription("Timeout in milliseconds, if reached no snapping will be done")
                    CdaVisibilityTest(AreSnappingPropertiesVisible)
                    CdaCategory("Snapping")
                CdaPropertyEnd()
                CdaProperty(SnapOffsetThreshold, SnapOffsetThresholdType, GetSnapOffsetThreshold, SetSnapOffsetThreshold)
                    CdaDescription("Threshold of offsetDelta = Abs(offsetTop - offsetBottom) in pixels - if the offset delta is smaller than the threshold the snap will be done to the edge closer to the touch position")
                    CdaVisibilityTest(AreSnappingPropertiesVisible)
                    CdaCategory("Snapping")
                CdaPropertyEnd()
                CdaBindableProperty(LimitExceededUpAnimationType, LimitExceededUpAnimationTypeType, GetLimitExceededUpAnimationType, SetLimitExceededUpAnimationType)
                    CdaDescription("Sets the kind of animation that will be played if the lists limit is exceeded on top of the list.")
                    CdaVisibilityTest(AreLimitExceededAnimationPropertiesVisible)
                    CdaCategory("LimitAnimations")
                CdaBindablePropertyEnd()
                CdaBindableProperty(LimitExceededUpAnimationTime, LimitExceededUpAnimationTimeType, GetLimitExceededUpAnimationTime, SetLimitExceededUpAnimationTime)
                    CdaDescription("Defines the how much time (ms) the exceeded up animation takes.")
                    CdaVisibilityTest(AreLimitExceededUpAnimationPropertiesVisible)
                    CdaCategory("LimitAnimations")
                CdaBindablePropertyEnd()
                CdaProperty(LimitExceededUpAnimation, LimitExceededUpAnimationType, GetLimitExceededUpAnimation, SetLimitExceededUpAnimation)
                    CdaDescription("Animation that is played when the user wants to exceed the list on top.  It is only played if LimitExceededUpAnimationType is CustomAnimation or circular scrolling is not enabled.")
                    CdaVisibilityTest(AreLimitExceededUpAnimationPropertiesVisible)
                    CdaCategory("LimitAnimations")
                CdaPropertyEnd()
                CdaBindableProperty(LimitExceededUpBounceAmplitude, LimitExceededUpBounceAmplitudeType, GetLimitExceededUpBounceAmplitude, SetLimitExceededUpBounceAmplitude)
                    CdaDescription("Amplitude vector used for generating the margin bounce animation.")
                    CdaVisibilityTest(AreLimitExceededUpAnimationPropertiesVisible)
                    CdaCategory("LimitAnimations")
                CdaBindablePropertyEnd()
                CdaBindableProperty(LimitExceededDownAnimationType, LimitExceededDownAnimationTypeType, GetLimitExceededDownAnimationType, SetLimitExceededDownAnimationType)
                    CdaDescription("Sets the kind of animation that will be played if the lists limit is exceeded on bottom of the list.")
                    CdaVisibilityTest(AreLimitExceededAnimationPropertiesVisible)
                    CdaCategory("LimitAnimations")
                CdaBindablePropertyEnd()
                CdaBindableProperty(LimitExceededDownAnimationTime, LimitExceededDownAnimationTimeType, GetLimitExceededDownAnimationTime, SetLimitExceededDownAnimationTime)
                    CdaDescription("Defines the how much time (ms) the exceeded down animation takes.")
                    CdaVisibilityTest(AreLimitExceededDownAnimationPropertiesVisible)
                    CdaCategory("LimitAnimations")
                CdaBindablePropertyEnd()
                CdaProperty(LimitExceededDownAnimation, LimitExceededDownAnimationType, GetLimitExceededDownAnimation, SetLimitExceededDownAnimation)
                    CdaDescription("Animation that is played when the user wants to exceed the list on bottom.  It is only played if LimitExceededDownAnimationType is CustomAnimation or circular scrolling is not enabled.")
                    CdaVisibilityTest(AreLimitExceededDownAnimationPropertiesVisible)
                    CdaCategory("LimitAnimations")
                CdaPropertyEnd()
                CdaBindableProperty(LimitExceededDownBounceAmplitude, LimitExceededDownBounceAmplitudeType, GetLimitExceededDownBounceAmplitude, SetLimitExceededDownBounceAmplitude)
                    CdaDescription("Amplitude vector used for generating the margin bounce animation.")
                    CdaVisibilityTest(AreLimitExceededDownAnimationPropertiesVisible)
                    CdaCategory("LimitAnimations")
                CdaBindablePropertyEnd()
                CdaBindableProperty(LimitReachedUpAnimationType, LimitReachedUpAnimationTypeType, GetLimitReachedUpAnimationType, SetLimitReachedUpAnimationType)
                    CdaDescription("Sets the kind of animation that will be played if the lists limit is reached during swipe, scroll or set on top of the list.")
                    CdaVisibilityTest(AreLimitExceededAnimationPropertiesVisible)
                    CdaCategory("LimitAnimations")
                CdaBindablePropertyEnd()
                CdaBindableProperty(LimitReachedUpAnimationTime, LimitReachedUpAnimationTimeType, GetLimitReachedUpAnimationTime, SetLimitReachedUpAnimationTime)
                    CdaDescription("Defines the how much time (ms) the reached up animation takes.")
                    CdaVisibilityTest(AreLimitReachedUpAnimationPropertiesVisible)
                    CdaCategory("LimitAnimations")
                CdaBindablePropertyEnd()
                CdaProperty(LimitReachedUpAnimation, LimitReachedUpAnimationType, GetLimitReachedUpAnimation, SetLimitReachedUpAnimation)
                    CdaDescription("Animation that is played when the user reaches the list on top during swipe, scroll or set.  It is only played if LimitReachedUpAnimationType is CustomAnimation or circular scrolling is not enabled.")
                    CdaVisibilityTest(AreLimitReachedUpAnimationPropertiesVisible)
                    CdaCategory("LimitAnimations")
                CdaPropertyEnd()
                CdaBindableProperty(LimitReachedUpBounceAmplitude, LimitReachedUpBounceAmplitudeType, GetLimitReachedUpBounceAmplitude, SetLimitReachedUpBounceAmplitude)
                    CdaDescription("Amplitude vector used for generating the margin bounce animation.")
                    CdaVisibilityTest(AreLimitReachedUpAnimationPropertiesVisible)
                    CdaCategory("LimitAnimations")
                CdaBindablePropertyEnd()
                CdaBindableProperty(LimitReachedDownAnimationType, LimitReachedDownAnimationTypeType, GetLimitReachedDownAnimationType, SetLimitReachedDownAnimationType)
                    CdaDescription("Sets the kind of animation that will be played if the lists limit is reached during swipe, scroll or set on bottom of the list.")
                    CdaVisibilityTest(AreLimitExceededAnimationPropertiesVisible)
                    CdaCategory("LimitAnimations")
                CdaBindablePropertyEnd()
                CdaBindableProperty(LimitReachedDownAnimationTime, LimitReachedDownAnimationTimeType, GetLimitReachedDownAnimationTime, SetLimitReachedDownAnimationTime)
                    CdaDescription("Defines the how much time (ms) the reached down animation takes.")
                    CdaVisibilityTest(AreLimitReachedDownAnimationPropertiesVisible)
                    CdaCategory("LimitAnimations")
                CdaBindablePropertyEnd()
                CdaProperty(LimitReachedDownAnimation, LimitReachedDownAnimationType, GetLimitReachedDownAnimation, SetLimitReachedDownAnimation)
                    CdaDescription("Animation that is played when the user reaches the list on top during swipe, scroll or set.  It is only played if LimitReachedDownAnimationType is CustomAnimation or circular scrolling is not enabled.")
                    CdaVisibilityTest(AreLimitReachedDownAnimationPropertiesVisible)
                    CdaCategory("LimitAnimations")
                CdaPropertyEnd()
                CdaBindableProperty(LimitReachedDownBounceAmplitude, LimitReachedDownBounceAmplitudeType, GetLimitReachedDownBounceAmplitude, SetLimitReachedDownBounceAmplitude)
                    CdaDescription("Amplitude vector used for generating the margin bounce animation.")
                    CdaVisibilityTest(AreLimitReachedDownAnimationPropertiesVisible)
                    CdaCategory("LimitAnimations")
                CdaBindablePropertyEnd()
                CdaProperty(ScrollAnimationInput, ScrollAnimationInputType, GetScrollAnimationInput, SetScrollAnimationInput)
                    CdaDescription("Input of scroll animation - Either pixel position or index of list items")
                    CdaVisibilityTest(IsScrollAnimationInputVisible)
                    CdaCategory("Scroll Animations")
                CdaPropertyEnd()
                CdaProperty(AnimationOffset, AnimationOffsetType, GetAnimationOffset, SetAnimationOffset)
                    CdaDescription("Offset from first visible item to the position of the first animated item, give a negative value for the offset to the first invisible item of the list")
                    CdaVisibilityTest(IsAnimationOffsetVisible)
                    CdaCategory("Scroll Animations")
                CdaPropertyEnd()
                CdaProperty(ShowItemsOnViewActivated, ShowItemsOnViewActivatedType, GetShowItemsOnViewActivated, SetShowItemsOnViewActivated)
                    CdaDescription("Whether items are visible or not on view shown, before receiving a ListCustomAnimationReqMsg.")
                    CdaCategory("Custom Animations")
                CdaPropertyEnd()
                CdaProperty(UsableViewportPadding, UsableViewportPaddingType, GetUsableViewportPadding, SetUsableViewportPadding)
                    CdaDescription("Viewport offset for visible items in the list - useful in case the list is overlapped by some other content.")
                    CdaCategory("Viewport Padding")
                CdaPropertyEnd()
                CdaProperty(AutoViewportSize, AutoViewportSizeType, GetAutoViewportSize, SetAutoViewportSize)
                    CdaDescription("If enabled, the size of the viewport will be calculated as NumberOfItems multiplied with the size of the InvalidItemTemplate. This is done for the direction of scrolling; the other direction will remain unmodified.")
                    CdaCategory("Viewport")
                CdaPropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        ItemsNodeType m_ItemsNode;
        FocusedNodeType m_FocusedNode;
        TemplateGroupType m_TemplateGroup;
        InvalidItemTemplateType m_InvalidItemTemplate;
        CustomAnimationsGroupNodeType m_CustomAnimationsGroupNode;
        ListIdType m_ListId;
        BufferSizeType m_BufferSize;
        UpdateTriggerOffsetType m_UpdateTriggerOffset;
        FocusedIndexType m_FocusedIndex;
        StartIndexType m_StartIndex;
        NumberOfItemsType m_NumberOfItems;
        ScrollbarAlwaysVisibleType m_ScrollbarAlwaysVisible;
        ListAlignmentType m_ListAlignment;
        PostListChangedType m_PostListChanged;
        ExpandAutoScrollType m_ExpandAutoScroll;
        DynamicGridType m_DynamicGrid;
        DynamicGridEmptyCellsPolicyType m_DynamicGridEmptyCellsPolicy;
        CoverflowType m_Coverflow;
        CachedLayoutType m_CachedLayout;
        PreparedItemsBufferSizeType m_PreparedItemsBufferSize;
        PreparedItemsUpdateTriggerOffsetType m_PreparedItemsUpdateTriggerOffset;
        FixedPageScrollingType m_FixedPageScrolling;
        FixedPageScrollingOffsetType m_FixedPageScrollingOffset;
        AcceptImmediatePositioningType m_AcceptImmediatePositioning;
        AcceptImmediatePositioningOnFirstApperanceType m_AcceptImmediatePositioningOnFirstApperance;
        AcceptImmediatePositioningOnPositionSetType m_AcceptImmediatePositioningOnPositionSet;
        AcceptImmediatePositioningOnPageScrollType m_AcceptImmediatePositioningOnPageScroll;
        AcceptImmediatePositioningOnItemScrollType m_AcceptImmediatePositioningOnItemScroll;
        PixelWiseScrollingEnabledType m_PixelWiseScrollingEnabled;
        PixelWiseAnimationTimeType m_PixelWiseAnimationTime;
        ShortPixelWiseAnimationTimeType m_ShortPixelWiseAnimationTime;
        ScrollingOrientationType m_ScrollingOrientation;
        ScrollingTypeType m_ScrollingType;
        LockOutFixMovementOffsetType m_LockOutFixMovementOffset;
        SwipingDistanceThresholdType m_SwipingDistanceThreshold;
        SwipingTimerThresholdType m_SwipingTimerThreshold;
        SwipingVelocityThresholdType m_SwipingVelocityThreshold;
        SwipingAccelerationType m_SwipingAcceleration;
        SwipingMaxDistanceType m_SwipingMaxDistance;
        IgnoreListChangeMsgType m_IgnoreListChangeMsg;
        DragAndSwipeOnNeedType m_DragAndSwipeOnNeed;
        SnapType m_Snap;
        SnapHoldTimeType m_SnapHoldTime;
        SnapOffsetThresholdType m_SnapOffsetThreshold;
        LimitExceededUpAnimationTypeType m_LimitExceededUpAnimationType;
        LimitExceededUpAnimationTimeType m_LimitExceededUpAnimationTime;
        LimitExceededUpAnimationType m_LimitExceededUpAnimation;
        LimitExceededUpBounceAmplitudeType m_LimitExceededUpBounceAmplitude;
        LimitExceededDownAnimationTypeType m_LimitExceededDownAnimationType;
        LimitExceededDownAnimationTimeType m_LimitExceededDownAnimationTime;
        LimitExceededDownAnimationType m_LimitExceededDownAnimation;
        LimitExceededDownBounceAmplitudeType m_LimitExceededDownBounceAmplitude;
        LimitReachedUpAnimationTypeType m_LimitReachedUpAnimationType;
        LimitReachedUpAnimationTimeType m_LimitReachedUpAnimationTime;
        LimitReachedUpAnimationType m_LimitReachedUpAnimation;
        LimitReachedUpBounceAmplitudeType m_LimitReachedUpBounceAmplitude;
        LimitReachedDownAnimationTypeType m_LimitReachedDownAnimationType;
        LimitReachedDownAnimationTimeType m_LimitReachedDownAnimationTime;
        LimitReachedDownAnimationType m_LimitReachedDownAnimation;
        LimitReachedDownBounceAmplitudeType m_LimitReachedDownBounceAmplitude;
        ScrollAnimationInputType m_ScrollAnimationInput;
        AnimationOffsetType m_AnimationOffset;
        ShowItemsOnViewActivatedType m_ShowItemsOnViewActivated;
        UsableViewportPaddingType m_UsableViewportPadding;
        AutoViewportSizeType m_AutoViewportSize;
};

#endif // ListWidget2DBase_h
