/************************************************************************
*FILE: ListWidget2DBase.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ***************************************************************************************
 * FILE:          Generated intermediate file from HMIContract.exe
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  This file is part of HMI-Base Widget Library 
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "widget2D_std_if.h"

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "ListWidget2DBase.h"

// ------------------------------------------------------------------------
CGI_WIDGET_RTTI_DEFINITION(ListWidget2DBase)

ListWidget2DBase::ListWidget2DBase() :
    m_ItemsNode(ItemsNodeType()),
    m_FocusedNode(FocusedNodeType()),
    m_TemplateGroup(TemplateGroupType()),
    m_InvalidItemTemplate(InvalidItemTemplateType()),
    m_CustomAnimationsGroupNode(CustomAnimationsGroupNodeType()),
    m_ListId(ListIdType()),
    m_BufferSize(BufferSizeType()),
    m_UpdateTriggerOffset(UpdateTriggerOffsetType()),
    m_FocusedIndex(FocusedIndexType()),
    m_StartIndex(StartIndexType()),
    m_NumberOfItems(NumberOfItemsType()),
    m_ScrollbarAlwaysVisible(ScrollbarAlwaysVisibleType()),
    m_ListAlignment(Candera::ListAlignment::Begin),
    m_PostListChanged(PostListChangedType()),
    m_ExpandAutoScroll(true),
    m_DynamicGrid(false),
    m_DynamicGridEmptyCellsPolicy(DynamicGridEmptyCellsPolicyType::DistributeToAllItems),
    m_Coverflow(false),
    m_CachedLayout(true),
    m_PreparedItemsBufferSize(0),
    m_PreparedItemsUpdateTriggerOffset(0),
    m_FixedPageScrolling(false),
    m_FixedPageScrollingOffset(0.5),
    m_AcceptImmediatePositioning(true),
    m_AcceptImmediatePositioningOnFirstApperance(true),
    m_AcceptImmediatePositioningOnPositionSet(false),
    m_AcceptImmediatePositioningOnPageScroll(false),
    m_AcceptImmediatePositioningOnItemScroll(false),
    m_PixelWiseScrollingEnabled(PixelWiseScrollingEnabledType()),
    m_PixelWiseAnimationTime(250),
    m_ShortPixelWiseAnimationTime(0),
    m_ScrollingOrientation(::Candera::Vertical),
    m_ScrollingType(::Candera::DefaultScrolling),
    m_LockOutFixMovementOffset(0.5),
    m_SwipingDistanceThreshold(5),
    m_SwipingTimerThreshold(1000),
    m_SwipingVelocityThreshold(0.03f),
    m_SwipingAcceleration(0.003f),
    m_SwipingMaxDistance(5000.0f),
    m_IgnoreListChangeMsg(::IgnoreListChangeMsgType::WhileTouchingOrSwiping),
    m_DragAndSwipeOnNeed(true),
    m_Snap(Candera::ListSnapType::SnapDefault),
    m_SnapHoldTime(0),
    m_SnapOffsetThreshold(0),
    m_LimitExceededUpAnimationType(::Candera::NoAnimation),
    m_LimitExceededUpAnimationTime(0),
    m_LimitExceededUpAnimation(LimitExceededUpAnimationType()),
    m_LimitExceededUpBounceAmplitude(LimitExceededUpBounceAmplitudeType()),
    m_LimitExceededDownAnimationType(::Candera::NoAnimation),
    m_LimitExceededDownAnimationTime(0),
    m_LimitExceededDownAnimation(LimitExceededDownAnimationType()),
    m_LimitExceededDownBounceAmplitude(LimitExceededDownBounceAmplitudeType()),
    m_LimitReachedUpAnimationType(::Candera::NoAnimation),
    m_LimitReachedUpAnimationTime(0),
    m_LimitReachedUpAnimation(LimitReachedUpAnimationType()),
    m_LimitReachedUpBounceAmplitude(LimitReachedUpBounceAmplitudeType()),
    m_LimitReachedDownAnimationType(::Candera::NoAnimation),
    m_LimitReachedDownAnimationTime(0),
    m_LimitReachedDownAnimation(LimitReachedDownAnimationType()),
    m_LimitReachedDownBounceAmplitude(LimitReachedDownBounceAmplitudeType()),
    m_ScrollAnimationInput(Candera::ScrollAnimationInput::IndexBased),
    m_AnimationOffset(AnimationOffsetType()),
    m_ShowItemsOnViewActivated(true),
    m_UsableViewportPadding(UsableViewportPaddingType()),
    m_AutoViewportSize(false)
{
}

ListWidget2DBase::~ListWidget2DBase()
{
}

void ListWidget2DBase::SetItemsNode(const ItemsNodeType& itemsnode)
{
    m_ItemsNode = itemsnode;
    OnChanged(static_cast< ::FeatStd::UInt32>(ItemsNodePropertyId));
}

void ListWidget2DBase::SetFocusedNode(const FocusedNodeType& focusednode)
{
    m_FocusedNode = focusednode;
    OnChanged(static_cast< ::FeatStd::UInt32>(FocusedNodePropertyId));
}

void ListWidget2DBase::SetTemplateGroup(const TemplateGroupType& templategroup)
{
    m_TemplateGroup = templategroup;
    OnChanged(static_cast< ::FeatStd::UInt32>(TemplateGroupPropertyId));
}

void ListWidget2DBase::SetInvalidItemTemplate(const InvalidItemTemplateType& invaliditemtemplate)
{
    m_InvalidItemTemplate = invaliditemtemplate;
    OnChanged(static_cast< ::FeatStd::UInt32>(InvalidItemTemplatePropertyId));
}

void ListWidget2DBase::SetCustomAnimationsGroupNode(const CustomAnimationsGroupNodeType& customanimationsgroupnode)
{
    m_CustomAnimationsGroupNode = customanimationsgroupnode;
    OnChanged(static_cast< ::FeatStd::UInt32>(CustomAnimationsGroupNodePropertyId));
}

void ListWidget2DBase::SetListId(const ListIdType& listid)
{
    if (m_ListId != listid) {
        m_ListId = listid;
        OnChanged(static_cast< ::FeatStd::UInt32>(ListIdPropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("ListId");
        }
    }
}

void ListWidget2DBase::SetBufferSize(const BufferSizeType& buffersize)
{
    m_BufferSize = buffersize;
    OnChanged(static_cast< ::FeatStd::UInt32>(BufferSizePropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("BufferSize");
    }
}

void ListWidget2DBase::SetUpdateTriggerOffset(const UpdateTriggerOffsetType& updatetriggeroffset)
{
    m_UpdateTriggerOffset = updatetriggeroffset;
    OnChanged(static_cast< ::FeatStd::UInt32>(UpdateTriggerOffsetPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("UpdateTriggerOffset");
    }
}

void ListWidget2DBase::SetFocusedIndex(const FocusedIndexType& focusedindex)
{
    m_FocusedIndex = focusedindex;
    OnChanged(static_cast< ::FeatStd::UInt32>(FocusedIndexPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("FocusedIndex");
    }
}

void ListWidget2DBase::SetStartIndex(const StartIndexType& startindex)
{
    m_StartIndex = startindex;
    OnChanged(static_cast< ::FeatStd::UInt32>(StartIndexPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("StartIndex");
    }
}

void ListWidget2DBase::SetNumberOfItems(const NumberOfItemsType& numberofitems)
{
    m_NumberOfItems = numberofitems;
    OnChanged(static_cast< ::FeatStd::UInt32>(NumberOfItemsPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("NumberOfItems");
    }
}

void ListWidget2DBase::SetScrollbarAlwaysVisible(const ScrollbarAlwaysVisibleType& scrollbaralwaysvisible)
{
    m_ScrollbarAlwaysVisible = scrollbaralwaysvisible;
    OnChanged(static_cast< ::FeatStd::UInt32>(ScrollbarAlwaysVisiblePropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("ScrollbarAlwaysVisible");
    }
}

void ListWidget2DBase::SetListAlignment(const ListAlignmentType& listalignment)
{
    m_ListAlignment = listalignment;
    OnChanged(static_cast< ::FeatStd::UInt32>(ListAlignmentPropertyId));
}

void ListWidget2DBase::SetPostListChanged(const PostListChangedType& postlistchanged)
{
    m_PostListChanged = postlistchanged;
    OnChanged(static_cast< ::FeatStd::UInt32>(PostListChangedPropertyId));
}

void ListWidget2DBase::SetExpandAutoScroll(const ExpandAutoScrollType& expandautoscroll)
{
    m_ExpandAutoScroll = expandautoscroll;
    OnChanged(static_cast< ::FeatStd::UInt32>(ExpandAutoScrollPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("ExpandAutoScroll");
    }
}

void ListWidget2DBase::SetDynamicGrid(const DynamicGridType& dynamicgrid)
{
    m_DynamicGrid = dynamicgrid;
    OnChanged(static_cast< ::FeatStd::UInt32>(DynamicGridPropertyId));
}

void ListWidget2DBase::SetDynamicGridEmptyCellsPolicy(const DynamicGridEmptyCellsPolicyType& dynamicgridemptycellspolicy)
{
    m_DynamicGridEmptyCellsPolicy = dynamicgridemptycellspolicy;
    OnChanged(static_cast< ::FeatStd::UInt32>(DynamicGridEmptyCellsPolicyPropertyId));
}

void ListWidget2DBase::SetCoverflow(const CoverflowType& coverflow)
{
    m_Coverflow = coverflow;
    OnChanged(static_cast< ::FeatStd::UInt32>(CoverflowPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("Coverflow");
    }
}

void ListWidget2DBase::SetCachedLayout(const CachedLayoutType& cachedlayout)
{
    m_CachedLayout = cachedlayout;
    OnChanged(static_cast< ::FeatStd::UInt32>(CachedLayoutPropertyId));
}

void ListWidget2DBase::SetPreparedItemsBufferSize(const PreparedItemsBufferSizeType& prepareditemsbuffersize)
{
    m_PreparedItemsBufferSize = prepareditemsbuffersize;
    OnChanged(static_cast< ::FeatStd::UInt32>(PreparedItemsBufferSizePropertyId));
}

void ListWidget2DBase::SetPreparedItemsUpdateTriggerOffset(const PreparedItemsUpdateTriggerOffsetType& prepareditemsupdatetriggeroffset)
{
    m_PreparedItemsUpdateTriggerOffset = prepareditemsupdatetriggeroffset;
    OnChanged(static_cast< ::FeatStd::UInt32>(PreparedItemsUpdateTriggerOffsetPropertyId));
}

void ListWidget2DBase::SetFixedPageScrolling(const FixedPageScrollingType& fixedpagescrolling)
{
    m_FixedPageScrolling = fixedpagescrolling;
    OnChanged(static_cast< ::FeatStd::UInt32>(FixedPageScrollingPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("FixedPageScrolling");
    }
}

void ListWidget2DBase::SetFixedPageScrollingOffset(const FixedPageScrollingOffsetType& fixedpagescrollingoffset)
{
    m_FixedPageScrollingOffset = fixedpagescrollingoffset;
    OnChanged(static_cast< ::FeatStd::UInt32>(FixedPageScrollingOffsetPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("FixedPageScrollingOffset");
    }
}

void ListWidget2DBase::SetAcceptImmediatePositioning(const AcceptImmediatePositioningType& acceptimmediatepositioning)
{
    m_AcceptImmediatePositioning = acceptimmediatepositioning;
    OnChanged(static_cast< ::FeatStd::UInt32>(AcceptImmediatePositioningPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("AcceptImmediatePositioning");
    }
}

void ListWidget2DBase::SetAcceptImmediatePositioningOnFirstApperance(const AcceptImmediatePositioningOnFirstApperanceType& acceptimmediatepositioningonfirstapperance)
{
    m_AcceptImmediatePositioningOnFirstApperance = acceptimmediatepositioningonfirstapperance;
    OnChanged(static_cast< ::FeatStd::UInt32>(AcceptImmediatePositioningOnFirstApperancePropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("AcceptImmediatePositioningOnFirstApperance");
    }
}

void ListWidget2DBase::SetAcceptImmediatePositioningOnPositionSet(const AcceptImmediatePositioningOnPositionSetType& acceptimmediatepositioningonpositionset)
{
    m_AcceptImmediatePositioningOnPositionSet = acceptimmediatepositioningonpositionset;
    OnChanged(static_cast< ::FeatStd::UInt32>(AcceptImmediatePositioningOnPositionSetPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("AcceptImmediatePositioningOnPositionSet");
    }
}

void ListWidget2DBase::SetAcceptImmediatePositioningOnPageScroll(const AcceptImmediatePositioningOnPageScrollType& acceptimmediatepositioningonpagescroll)
{
    m_AcceptImmediatePositioningOnPageScroll = acceptimmediatepositioningonpagescroll;
    OnChanged(static_cast< ::FeatStd::UInt32>(AcceptImmediatePositioningOnPageScrollPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("AcceptImmediatePositioningOnPageScroll");
    }
}

void ListWidget2DBase::SetAcceptImmediatePositioningOnItemScroll(const AcceptImmediatePositioningOnItemScrollType& acceptimmediatepositioningonitemscroll)
{
    m_AcceptImmediatePositioningOnItemScroll = acceptimmediatepositioningonitemscroll;
    OnChanged(static_cast< ::FeatStd::UInt32>(AcceptImmediatePositioningOnItemScrollPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("AcceptImmediatePositioningOnItemScroll");
    }
}

void ListWidget2DBase::SetPixelWiseScrollingEnabled(const PixelWiseScrollingEnabledType& pixelwisescrollingenabled)
{
    m_PixelWiseScrollingEnabled = pixelwisescrollingenabled;
    OnChanged(static_cast< ::FeatStd::UInt32>(PixelWiseScrollingEnabledPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("PixelWiseScrollingEnabled");
    }
}

void ListWidget2DBase::SetPixelWiseAnimationTime(const PixelWiseAnimationTimeType& pixelwiseanimationtime)
{
    m_PixelWiseAnimationTime = pixelwiseanimationtime;
    OnChanged(static_cast< ::FeatStd::UInt32>(PixelWiseAnimationTimePropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("PixelWiseAnimationTime");
    }
}

void ListWidget2DBase::SetShortPixelWiseAnimationTime(const ShortPixelWiseAnimationTimeType& shortpixelwiseanimationtime)
{
    m_ShortPixelWiseAnimationTime = shortpixelwiseanimationtime;
    OnChanged(static_cast< ::FeatStd::UInt32>(ShortPixelWiseAnimationTimePropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("ShortPixelWiseAnimationTime");
    }
}

void ListWidget2DBase::SetScrollingOrientation(const ScrollingOrientationType& scrollingorientation)
{
    m_ScrollingOrientation = scrollingorientation;
    OnChanged(static_cast< ::FeatStd::UInt32>(ScrollingOrientationPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("ScrollingOrientation");
    }
}

void ListWidget2DBase::SetScrollingType(const ScrollingTypeType& scrollingtype)
{
    m_ScrollingType = scrollingtype;
    OnChanged(static_cast< ::FeatStd::UInt32>(ScrollingTypePropertyId));
}

void ListWidget2DBase::SetLockOutFixMovementOffset(const LockOutFixMovementOffsetType& lockoutfixmovementoffset)
{
    m_LockOutFixMovementOffset = lockoutfixmovementoffset;
    OnChanged(static_cast< ::FeatStd::UInt32>(LockOutFixMovementOffsetPropertyId));
}

void ListWidget2DBase::SetSwipingDistanceThreshold(const SwipingDistanceThresholdType& swipingdistancethreshold)
{
    m_SwipingDistanceThreshold = swipingdistancethreshold;
    OnChanged(static_cast< ::FeatStd::UInt32>(SwipingDistanceThresholdPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("SwipingDistanceThreshold");
    }
}

void ListWidget2DBase::SetSwipingTimerThreshold(const SwipingTimerThresholdType& swipingtimerthreshold)
{
    m_SwipingTimerThreshold = swipingtimerthreshold;
    OnChanged(static_cast< ::FeatStd::UInt32>(SwipingTimerThresholdPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("SwipingTimerThreshold");
    }
}

void ListWidget2DBase::SetSwipingVelocityThreshold(const SwipingVelocityThresholdType& swipingvelocitythreshold)
{
    m_SwipingVelocityThreshold = swipingvelocitythreshold;
    OnChanged(static_cast< ::FeatStd::UInt32>(SwipingVelocityThresholdPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("SwipingVelocityThreshold");
    }
}

void ListWidget2DBase::SetSwipingAcceleration(const SwipingAccelerationType& swipingacceleration)
{
    m_SwipingAcceleration = swipingacceleration;
    OnChanged(static_cast< ::FeatStd::UInt32>(SwipingAccelerationPropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("SwipingAcceleration");
    }
}

void ListWidget2DBase::SetSwipingMaxDistance(const SwipingMaxDistanceType& swipingmaxdistance)
{
    m_SwipingMaxDistance = swipingmaxdistance;
    OnChanged(static_cast< ::FeatStd::UInt32>(SwipingMaxDistancePropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("SwipingMaxDistance");
    }
}

void ListWidget2DBase::SetIgnoreListChangeMsg(const IgnoreListChangeMsgType& ignorelistchangemsg)
{
    m_IgnoreListChangeMsg = ignorelistchangemsg;
}

void ListWidget2DBase::SetDragAndSwipeOnNeed(const DragAndSwipeOnNeedType& dragandswipeonneed)
{
    if (m_DragAndSwipeOnNeed != dragandswipeonneed) {
        m_DragAndSwipeOnNeed = dragandswipeonneed;
    }
}

void ListWidget2DBase::SetSnap(const SnapType& snap)
{
    if (m_Snap != snap) {
        m_Snap = snap;
        OnChanged(static_cast< ::FeatStd::UInt32>(SnapPropertyId));
    }
}

void ListWidget2DBase::SetSnapHoldTime(const SnapHoldTimeType& snapholdtime)
{
    if (m_SnapHoldTime != snapholdtime) {
        m_SnapHoldTime = snapholdtime;
        OnChanged(static_cast< ::FeatStd::UInt32>(SnapHoldTimePropertyId));
    }
}

void ListWidget2DBase::SetSnapOffsetThreshold(const SnapOffsetThresholdType& snapoffsetthreshold)
{
    if (m_SnapOffsetThreshold != snapoffsetthreshold) {
        m_SnapOffsetThreshold = snapoffsetthreshold;
        OnChanged(static_cast< ::FeatStd::UInt32>(SnapOffsetThresholdPropertyId));
    }
}

void ListWidget2DBase::SetLimitExceededUpAnimationType(const LimitExceededUpAnimationTypeType& limitexceededupanimationtype)
{
    m_LimitExceededUpAnimationType = limitexceededupanimationtype;
    OnChanged(static_cast< ::FeatStd::UInt32>(LimitExceededUpAnimationTypePropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("LimitExceededUpAnimationType");
    }
}

void ListWidget2DBase::SetLimitExceededUpAnimationTime(const LimitExceededUpAnimationTimeType& limitexceededupanimationtime)
{
    m_LimitExceededUpAnimationTime = limitexceededupanimationtime;
    OnChanged(static_cast< ::FeatStd::UInt32>(LimitExceededUpAnimationTimePropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("LimitExceededUpAnimationTime");
    }
}

void ListWidget2DBase::SetLimitExceededUpAnimation(const LimitExceededUpAnimationType& limitexceededupanimation)
{
    m_LimitExceededUpAnimation = limitexceededupanimation;
    OnChanged(static_cast< ::FeatStd::UInt32>(LimitExceededUpAnimationPropertyId));
}

void ListWidget2DBase::SetLimitExceededUpBounceAmplitude(const LimitExceededUpBounceAmplitudeType& limitexceededupbounceamplitude)
{
    m_LimitExceededUpBounceAmplitude = limitexceededupbounceamplitude;
    OnChanged(static_cast< ::FeatStd::UInt32>(LimitExceededUpBounceAmplitudePropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("LimitExceededUpBounceAmplitude");
    }
}

void ListWidget2DBase::SetLimitExceededDownAnimationType(const LimitExceededDownAnimationTypeType& limitexceededdownanimationtype)
{
    m_LimitExceededDownAnimationType = limitexceededdownanimationtype;
    OnChanged(static_cast< ::FeatStd::UInt32>(LimitExceededDownAnimationTypePropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("LimitExceededDownAnimationType");
    }
}

void ListWidget2DBase::SetLimitExceededDownAnimationTime(const LimitExceededDownAnimationTimeType& limitexceededdownanimationtime)
{
    m_LimitExceededDownAnimationTime = limitexceededdownanimationtime;
    OnChanged(static_cast< ::FeatStd::UInt32>(LimitExceededDownAnimationTimePropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("LimitExceededDownAnimationTime");
    }
}

void ListWidget2DBase::SetLimitExceededDownAnimation(const LimitExceededDownAnimationType& limitexceededdownanimation)
{
    m_LimitExceededDownAnimation = limitexceededdownanimation;
    OnChanged(static_cast< ::FeatStd::UInt32>(LimitExceededDownAnimationPropertyId));
}

void ListWidget2DBase::SetLimitExceededDownBounceAmplitude(const LimitExceededDownBounceAmplitudeType& limitexceededdownbounceamplitude)
{
    m_LimitExceededDownBounceAmplitude = limitexceededdownbounceamplitude;
    OnChanged(static_cast< ::FeatStd::UInt32>(LimitExceededDownBounceAmplitudePropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("LimitExceededDownBounceAmplitude");
    }
}

void ListWidget2DBase::SetLimitReachedUpAnimationType(const LimitReachedUpAnimationTypeType& limitreachedupanimationtype)
{
    m_LimitReachedUpAnimationType = limitreachedupanimationtype;
    OnChanged(static_cast< ::FeatStd::UInt32>(LimitReachedUpAnimationTypePropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("LimitReachedUpAnimationType");
    }
}

void ListWidget2DBase::SetLimitReachedUpAnimationTime(const LimitReachedUpAnimationTimeType& limitreachedupanimationtime)
{
    m_LimitReachedUpAnimationTime = limitreachedupanimationtime;
    OnChanged(static_cast< ::FeatStd::UInt32>(LimitReachedUpAnimationTimePropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("LimitReachedUpAnimationTime");
    }
}

void ListWidget2DBase::SetLimitReachedUpAnimation(const LimitReachedUpAnimationType& limitreachedupanimation)
{
    m_LimitReachedUpAnimation = limitreachedupanimation;
    OnChanged(static_cast< ::FeatStd::UInt32>(LimitReachedUpAnimationPropertyId));
}

void ListWidget2DBase::SetLimitReachedUpBounceAmplitude(const LimitReachedUpBounceAmplitudeType& limitreachedupbounceamplitude)
{
    m_LimitReachedUpBounceAmplitude = limitreachedupbounceamplitude;
    OnChanged(static_cast< ::FeatStd::UInt32>(LimitReachedUpBounceAmplitudePropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("LimitReachedUpBounceAmplitude");
    }
}

void ListWidget2DBase::SetLimitReachedDownAnimationType(const LimitReachedDownAnimationTypeType& limitreacheddownanimationtype)
{
    m_LimitReachedDownAnimationType = limitreacheddownanimationtype;
    OnChanged(static_cast< ::FeatStd::UInt32>(LimitReachedDownAnimationTypePropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("LimitReachedDownAnimationType");
    }
}

void ListWidget2DBase::SetLimitReachedDownAnimationTime(const LimitReachedDownAnimationTimeType& limitreacheddownanimationtime)
{
    m_LimitReachedDownAnimationTime = limitreacheddownanimationtime;
    OnChanged(static_cast< ::FeatStd::UInt32>(LimitReachedDownAnimationTimePropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("LimitReachedDownAnimationTime");
    }
}

void ListWidget2DBase::SetLimitReachedDownAnimation(const LimitReachedDownAnimationType& limitreacheddownanimation)
{
    m_LimitReachedDownAnimation = limitreacheddownanimation;
    OnChanged(static_cast< ::FeatStd::UInt32>(LimitReachedDownAnimationPropertyId));
}

void ListWidget2DBase::SetLimitReachedDownBounceAmplitude(const LimitReachedDownBounceAmplitudeType& limitreacheddownbounceamplitude)
{
    m_LimitReachedDownBounceAmplitude = limitreacheddownbounceamplitude;
    OnChanged(static_cast< ::FeatStd::UInt32>(LimitReachedDownBounceAmplitudePropertyId));
#if !defined COURIER_DISABLED
    if (0 != GetParentView())
#endif 
    {
        PropertyModified("LimitReachedDownBounceAmplitude");
    }
}

void ListWidget2DBase::SetScrollAnimationInput(const ScrollAnimationInputType& scrollanimationinput)
{
    m_ScrollAnimationInput = scrollanimationinput;
}

void ListWidget2DBase::SetAnimationOffset(const AnimationOffsetType& animationoffset)
{
    m_AnimationOffset = animationoffset;
}

void ListWidget2DBase::SetShowItemsOnViewActivated(const ShowItemsOnViewActivatedType& showitemsonviewactivated)
{
    m_ShowItemsOnViewActivated = showitemsonviewactivated;
}

void ListWidget2DBase::SetUsableViewportPadding(const UsableViewportPaddingType& usableviewportpadding)
{
    m_UsableViewportPadding = usableviewportpadding;
    OnChanged(static_cast< ::FeatStd::UInt32>(UsableViewportPaddingPropertyId));
}

void ListWidget2DBase::SetAutoViewportSize(const AutoViewportSizeType& autoviewportsize)
{
    m_AutoViewportSize = autoviewportsize;
    OnChanged(static_cast< ::FeatStd::UInt32>(AutoViewportSizePropertyId));
}
