/************************************************************************
*FILE: ImageSwitchWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(ImageSwitchWidget2DBase_h)
#define ImageSwitchWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/BaseWidget2D.h>
// ------------------------------------------------------------------------
//! [ImageSwitchWidget2DBase_Declaration]
class ImageSwitchWidget2DBase : public ::BaseWidget2D
{
    public:
        typedef Candera::UInt32 IndexType;

        typedef Candera::UInt32 CountType;

        //! [Property_IDs]
        static const FeatStd::UInt32 IndexPropertyId = 0x3DBCF2F4;
        static const FeatStd::UInt32 CountPropertyId = 0x7342C67C;
        //! [Property_IDs]

        ImageSwitchWidget2DBase();
        virtual ~ImageSwitchWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(ImageSwitchWidget2DBase, ::BaseWidget2D);

        //! [DataBinding_IndexPropertyGetterSetter]
        void SetIndex(const IndexType& index);
        const IndexType& GetIndex() const { return m_Index; }
        //! [DataBinding_IndexPropertyGetterSetter]

        //! [DataBinding_CountPropertyGetterSetter]
        void SetCount(const CountType& count);
        const CountType& GetCount() const { return m_Count; }
        //! [DataBinding_CountPropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(ImageSwitchWidget2DBase, ::BaseWidget2D)
            CdaDescription("Controls the bitmap property of the existing bitmap brush of a render node based on an index.")
            CdaReadableName("ImageSwitchWidget2DBase")
            CdaCategory("Image")

            CdaProperties()
                CdaBindableProperty(Index, IndexType, GetIndex, SetIndex)
                    CdaDescription("Index of the selected bitmap.")
                    CdaRange(0, 99)
                CdaBindablePropertyEnd()
                CdaBindableProperty(Count, CountType, GetCount, SetCount)
                    CdaDescription("Number of bitmaps.")
                    CdaRange(0, 100)
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        IndexType m_Index;
        CountType m_Count;
};

#endif // ImageSwitchWidget2DBase_h
