/************************************************************************
*FILE: GizmoWidget2DBase.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ***************************************************************************************
 * FILE:          Generated intermediate file from HMIContract.exe
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  This file is part of HMI-Base Widget Library 
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "widget2D_std_if.h"

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "GizmoWidget2DBase.h"

namespace hmibase {
} // namespace hmibase

namespace hmibase {
namespace widget {
namespace gizmo {
// ------------------------------------------------------------------------
CGI_WIDGET_RTTI_DEFINITION(GizmoWidget2DBase)

GizmoWidget2DBase::GizmoWidget2DBase() :
    m_Position(Candera::Vector2(0.0f,0.0f)),
    m_LimitArea(Candera::Rectangle(0.0f,0.0f,-1.0f,-1.0f)),
    m_Size(Candera::Vector2(-1.0f,-1.0f)),
    m_MinimumSize(Candera::Vector2(0.0f,0.0f)),
    m_MaximumSize(Candera::Vector2(-1.0f,-1.0f)),
    m_Rotation(0.0f),
    m_ColorIndex(0),
    m_Colors(ColorsType()),
    m_Nodes(NodesType()),
    m_GizmoEditModes(GizmoEditModesType())
{
}

GizmoWidget2DBase::~GizmoWidget2DBase()
{
}

void GizmoWidget2DBase::SetPosition(const PositionType& position)
{
    if (m_Position != position) {
        m_Position = position;
        OnChanged(static_cast< ::FeatStd::UInt32>(PositionPropertyId));
    }
}

void GizmoWidget2DBase::SetLimitArea(const LimitAreaType& limitarea)
{
    if (m_LimitArea != limitarea) {
        m_LimitArea = limitarea;
        OnChanged(static_cast< ::FeatStd::UInt32>(LimitAreaPropertyId));
    }
}

void GizmoWidget2DBase::SetSize(const SizeType& size)
{
    if (m_Size != size) {
        m_Size = size;
        OnChanged(static_cast< ::FeatStd::UInt32>(SizePropertyId));
    }
}

void GizmoWidget2DBase::SetMinimumSize(const MinimumSizeType& minimumsize)
{
    if (m_MinimumSize != minimumsize) {
        m_MinimumSize = minimumsize;
        OnChanged(static_cast< ::FeatStd::UInt32>(MinimumSizePropertyId));
    }
}

void GizmoWidget2DBase::SetMaximumSize(const MaximumSizeType& maximumsize)
{
    if (m_MaximumSize != maximumsize) {
        m_MaximumSize = maximumsize;
        OnChanged(static_cast< ::FeatStd::UInt32>(MaximumSizePropertyId));
    }
}

void GizmoWidget2DBase::SetRotation(const RotationType& rotation)
{
    if (m_Rotation != rotation) {
        m_Rotation = rotation;
        OnChanged(static_cast< ::FeatStd::UInt32>(RotationPropertyId));
    }
}

void GizmoWidget2DBase::SetColorIndex(const ColorIndexType& colorindex)
{
    if (m_ColorIndex != colorindex) {
        m_ColorIndex = colorindex;
        OnChanged(static_cast< ::FeatStd::UInt32>(ColorIndexPropertyId));
    }
}

void GizmoWidget2DBase::SetColors(const ColorsType& colors)
{
    m_Colors = colors;
    OnChanged(static_cast< ::FeatStd::UInt32>(ColorsPropertyId));
}

void GizmoWidget2DBase::SetNodes(const NodesType& nodes)
{
    m_Nodes = nodes;
    OnChanged(static_cast< ::FeatStd::UInt32>(NodesPropertyId));
}

void GizmoWidget2DBase::SetGizmoEditModes(const GizmoEditModesType& gizmoeditmodes)
{
    m_GizmoEditModes = gizmoeditmodes;
    OnChanged(static_cast< ::FeatStd::UInt32>(GizmoEditModesPropertyId));
}
} // namespace gizmo
} // namespace widget
} // namespace hmibase
