/************************************************************************
*FILE: GestureWidget2DMessages.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ***************************************************************************************
 * FILE:          Generated intermediate file from HMIContract.exe
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  This file is part of HMI-Base Widget Library 
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "widget2D_std_if.h"

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "GestureWidget2DMessages.h"

namespace hmibase {
namespace widget {
namespace gesture {
// ========================================================================

const ::Courier::ComponentId GestureMsg::mGestureMsgSubscriberList[GestureMsg::SubscriberListSize] = {
    ::Courier::ComponentId(::Courier::ComponentType::Model),
    ::Courier::ComponentId(::Courier::ComponentType::View),
    ::Courier::ComponentId(::Courier::ComponentType::Controller)
};

// ------------------------------------------------------------------------
GestureMsg::GestureMsg() :
    Base(),
    mTimestamp(Courier::Int())
{
}

// ------------------------------------------------------------------------
GestureMsg::GestureMsg(::Courier::ViewId const & aView, ::Courier::Identifier const & aSender, ::FeatStd::UInt32 const & aUserData, Courier::Int const & aTimestamp) :
    SenderMessage(aView, aSender, aUserData), mTimestamp(aTimestamp)
{
}

// ------------------------------------------------------------------------
GestureMsg::~GestureMsg()
{
}

// ------------------------------------------------------------------------
const ::Courier::Message::Metadata GestureMsg::mGestureMsgMetaData = {
    {false, true, false, ::FeatStd::UInt8(::Courier::Priority::Normal), ::FeatStd::UInt8(::Courier::MessageTag::None), GestureMsg::SubscriberListSize},
    COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC09883F3, GestureMsg),
    0xFFFFFFFF,
    GestureMsg::mGestureMsgSubscriberList
};

// ------------------------------------------------------------------------
::Courier::Message::ModifiableMetadata GestureMsg::mGestureMsgModifiableMetadata;

// ------------------------------------------------------------------------
const ::Courier::Message::Metadata& GestureMsg::GetMetadata() const
{
    return mGestureMsgMetaData;
}

// ------------------------------------------------------------------------
::Courier::Message::ModifiableMetadata & GestureMsg::GetModifiableMetadata() 
{
    return mGestureMsgModifiableMetadata;
}

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
::FeatStd::UInt32 GestureMsg::AppendTo(::FeatStd::StringBuffer& stringBuffer) const
{
    ::FeatStd::UInt32 tcharCount = 0;
    tcharCount += stringBuffer.Append("::hmibase::widget::gesture::GestureMsg { ");
    tcharCount += stringBuffer.Append("Timestamp = ");
    tcharCount += stringBuffer.AppendObject(GetTimestamp());
    tcharCount += stringBuffer.Append(", ");
    tcharCount += ::hmibase::widget::SenderMessage::AppendTo(stringBuffer);
    tcharCount += stringBuffer.Append(" }");
    return tcharCount;
}
#endif
// ========================================================================

::Courier::ComponentId TapGestureMsg::mTapGestureMsgSubscriberList[TapGestureMsg::SubscriberListSize] = {
    ::Courier::ComponentId(::Courier::ComponentType::Controller),
    ::Courier::ComponentId(::Courier::ComponentType::Model),
    ::Courier::ComponentId(::Courier::ComponentType::Invalid)
};

// ------------------------------------------------------------------------
bool TapGestureMsg::Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before)
{
    return ::Courier::Message::Subscribe(TapGestureMsg::mTapGestureMsgSubscriberList, TapGestureMsg::SubscriberListSize, component, before);
}

// ------------------------------------------------------------------------
bool TapGestureMsg::Unsubscribe(::Courier::ComponentId component)
{
    return ::Courier::Message::Unsubscribe(TapGestureMsg::mTapGestureMsgSubscriberList, TapGestureMsg::SubscriberListSize, component);
}

// ------------------------------------------------------------------------
TapGestureMsg::TapGestureMsg() :
    Base(),
    mEvent(enTapEvent::Enum()),
    mCoordinate1X(Courier::Int()),
    mCoordinate1Y(Courier::Int())
{
    InitializeLocalSubscriberList(mSubscribers);
}

// ------------------------------------------------------------------------
TapGestureMsg::TapGestureMsg(::Courier::ViewId const & aView, ::Courier::Identifier const & aSender, ::FeatStd::UInt32 const & aUserData, Courier::Int const & aTimestamp, enTapEvent::Enum const & aEvent, Courier::Int const & aCoordinate1X, Courier::Int const & aCoordinate1Y) :
    GestureMsg(aView, aSender, aUserData, aTimestamp), mEvent(aEvent), mCoordinate1X(aCoordinate1X), mCoordinate1Y(aCoordinate1Y)
{
    InitializeLocalSubscriberList(mSubscribers);
}

// ------------------------------------------------------------------------
TapGestureMsg::~TapGestureMsg()
{
    ResetLocalSubscriberList();
}

// ------------------------------------------------------------------------
const ::Courier::Message::Metadata TapGestureMsg::mTapGestureMsgMetaData = {
    {true, true, false, ::FeatStd::UInt8(::Courier::Priority::Normal), ::FeatStd::UInt8(::Courier::MessageTag::None), TapGestureMsg::SubscriberListSize},
    COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDDD13008, TapGestureMsg),
    0xFFFFFFFF,
    TapGestureMsg::mTapGestureMsgSubscriberList
};

// ------------------------------------------------------------------------
::Courier::Message::ModifiableMetadata TapGestureMsg::mTapGestureMsgModifiableMetadata;

// ------------------------------------------------------------------------
const ::Courier::Message::Metadata& TapGestureMsg::GetMetadata() const
{
    return mTapGestureMsgMetaData;
}

// ------------------------------------------------------------------------
::Courier::Message::ModifiableMetadata & TapGestureMsg::GetModifiableMetadata() 
{
    return mTapGestureMsgModifiableMetadata;
}

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
::FeatStd::UInt32 TapGestureMsg::AppendTo(::FeatStd::StringBuffer& stringBuffer) const
{
    ::FeatStd::UInt32 tcharCount = 0;
    tcharCount += stringBuffer.Append("::hmibase::widget::gesture::TapGestureMsg { ");
    tcharCount += stringBuffer.Append("Event = ");
    tcharCount += stringBuffer.AppendObject(GetEvent());
    tcharCount += stringBuffer.Append(", ");
    tcharCount += stringBuffer.Append("Coordinate1X = ");
    tcharCount += stringBuffer.AppendObject(GetCoordinate1X());
    tcharCount += stringBuffer.Append(", ");
    tcharCount += stringBuffer.Append("Coordinate1Y = ");
    tcharCount += stringBuffer.AppendObject(GetCoordinate1Y());
    tcharCount += stringBuffer.Append(", ");
    tcharCount += ::hmibase::widget::gesture::GestureMsg::AppendTo(stringBuffer);
    tcharCount += stringBuffer.Append(" }");
    return tcharCount;
}
#endif
// ========================================================================

::Courier::ComponentId DragGestureMsg::mDragGestureMsgSubscriberList[DragGestureMsg::SubscriberListSize] = {
    ::Courier::ComponentId(::Courier::ComponentType::Controller),
    ::Courier::ComponentId(::Courier::ComponentType::Model),
    ::Courier::ComponentId(::Courier::ComponentType::Invalid)
};

// ------------------------------------------------------------------------
bool DragGestureMsg::Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before)
{
    return ::Courier::Message::Subscribe(DragGestureMsg::mDragGestureMsgSubscriberList, DragGestureMsg::SubscriberListSize, component, before);
}

// ------------------------------------------------------------------------
bool DragGestureMsg::Unsubscribe(::Courier::ComponentId component)
{
    return ::Courier::Message::Unsubscribe(DragGestureMsg::mDragGestureMsgSubscriberList, DragGestureMsg::SubscriberListSize, component);
}

// ------------------------------------------------------------------------
DragGestureMsg::DragGestureMsg() :
    Base(),
    mEvent(enGestureEvent::Enum()),
    mCoordinate1X(Courier::Int()),
    mCoordinate1Y(Courier::Int()),
    mVelocity1X(Courier::Int()),
    mVelocity1Y(Courier::Int())
{
    InitializeLocalSubscriberList(mSubscribers);
}

// ------------------------------------------------------------------------
DragGestureMsg::DragGestureMsg(::Courier::ViewId const & aView, ::Courier::Identifier const & aSender, ::FeatStd::UInt32 const & aUserData, Courier::Int const & aTimestamp, enGestureEvent::Enum const & aEvent, Courier::Int const & aCoordinate1X, Courier::Int const & aCoordinate1Y, Courier::Int const & aVelocity1X, Courier::Int const & aVelocity1Y) :
    GestureMsg(aView, aSender, aUserData, aTimestamp), mEvent(aEvent), mCoordinate1X(aCoordinate1X), mCoordinate1Y(aCoordinate1Y), mVelocity1X(aVelocity1X), mVelocity1Y(aVelocity1Y)
{
    InitializeLocalSubscriberList(mSubscribers);
}

// ------------------------------------------------------------------------
DragGestureMsg::~DragGestureMsg()
{
    ResetLocalSubscriberList();
}

// ------------------------------------------------------------------------
const ::Courier::Message::Metadata DragGestureMsg::mDragGestureMsgMetaData = {
    {true, true, false, ::FeatStd::UInt8(::Courier::Priority::Normal), ::FeatStd::UInt8(::Courier::MessageTag::None), DragGestureMsg::SubscriberListSize},
    COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCCF00704, DragGestureMsg),
    0xFFFFFFFF,
    DragGestureMsg::mDragGestureMsgSubscriberList
};

// ------------------------------------------------------------------------
::Courier::Message::ModifiableMetadata DragGestureMsg::mDragGestureMsgModifiableMetadata;

// ------------------------------------------------------------------------
const ::Courier::Message::Metadata& DragGestureMsg::GetMetadata() const
{
    return mDragGestureMsgMetaData;
}

// ------------------------------------------------------------------------
::Courier::Message::ModifiableMetadata & DragGestureMsg::GetModifiableMetadata() 
{
    return mDragGestureMsgModifiableMetadata;
}

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
::FeatStd::UInt32 DragGestureMsg::AppendTo(::FeatStd::StringBuffer& stringBuffer) const
{
    ::FeatStd::UInt32 tcharCount = 0;
    tcharCount += stringBuffer.Append("::hmibase::widget::gesture::DragGestureMsg { ");
    tcharCount += stringBuffer.Append("Event = ");
    tcharCount += stringBuffer.AppendObject(GetEvent());
    tcharCount += stringBuffer.Append(", ");
    tcharCount += stringBuffer.Append("Coordinate1X = ");
    tcharCount += stringBuffer.AppendObject(GetCoordinate1X());
    tcharCount += stringBuffer.Append(", ");
    tcharCount += stringBuffer.Append("Coordinate1Y = ");
    tcharCount += stringBuffer.AppendObject(GetCoordinate1Y());
    tcharCount += stringBuffer.Append(", ");
    tcharCount += stringBuffer.Append("Velocity1X = ");
    tcharCount += stringBuffer.AppendObject(GetVelocity1X());
    tcharCount += stringBuffer.Append(", ");
    tcharCount += stringBuffer.Append("Velocity1Y = ");
    tcharCount += stringBuffer.AppendObject(GetVelocity1Y());
    tcharCount += stringBuffer.Append(", ");
    tcharCount += ::hmibase::widget::gesture::GestureMsg::AppendTo(stringBuffer);
    tcharCount += stringBuffer.Append(" }");
    return tcharCount;
}
#endif
// ========================================================================

::Courier::ComponentId SwipeGestureMsg::mSwipeGestureMsgSubscriberList[SwipeGestureMsg::SubscriberListSize] = {
    ::Courier::ComponentId(::Courier::ComponentType::Controller),
    ::Courier::ComponentId(::Courier::ComponentType::Model),
    ::Courier::ComponentId(::Courier::ComponentType::Invalid)
};

// ------------------------------------------------------------------------
bool SwipeGestureMsg::Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before)
{
    return ::Courier::Message::Subscribe(SwipeGestureMsg::mSwipeGestureMsgSubscriberList, SwipeGestureMsg::SubscriberListSize, component, before);
}

// ------------------------------------------------------------------------
bool SwipeGestureMsg::Unsubscribe(::Courier::ComponentId component)
{
    return ::Courier::Message::Unsubscribe(SwipeGestureMsg::mSwipeGestureMsgSubscriberList, SwipeGestureMsg::SubscriberListSize, component);
}

// ------------------------------------------------------------------------
SwipeGestureMsg::SwipeGestureMsg() :
    Base(),
    mVelocity1X(Courier::Int()),
    mVelocity1Y(Courier::Int()),
    mVelocity2X(Courier::Int()),
    mVelocity2Y(Courier::Int()),
    mVelocity3X(Courier::Int()),
    mVelocity3Y(Courier::Int())
{
    InitializeLocalSubscriberList(mSubscribers);
}

// ------------------------------------------------------------------------
SwipeGestureMsg::SwipeGestureMsg(::Courier::ViewId const & aView, ::Courier::Identifier const & aSender, ::FeatStd::UInt32 const & aUserData, Courier::Int const & aTimestamp, Courier::Int const & aVelocity1X, Courier::Int const & aVelocity1Y, Courier::Int const & aVelocity2X, Courier::Int const & aVelocity2Y, Courier::Int const & aVelocity3X, Courier::Int const & aVelocity3Y) :
    GestureMsg(aView, aSender, aUserData, aTimestamp), mVelocity1X(aVelocity1X), mVelocity1Y(aVelocity1Y), mVelocity2X(aVelocity2X), mVelocity2Y(aVelocity2Y), mVelocity3X(aVelocity3X), mVelocity3Y(aVelocity3Y)
{
    InitializeLocalSubscriberList(mSubscribers);
}

// ------------------------------------------------------------------------
SwipeGestureMsg::~SwipeGestureMsg()
{
    ResetLocalSubscriberList();
}

// ------------------------------------------------------------------------
const ::Courier::Message::Metadata SwipeGestureMsg::mSwipeGestureMsgMetaData = {
    {true, true, false, ::FeatStd::UInt8(::Courier::Priority::Normal), ::FeatStd::UInt8(::Courier::MessageTag::None), SwipeGestureMsg::SubscriberListSize},
    COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA2B4B599, SwipeGestureMsg),
    0xFFFFFFFF,
    SwipeGestureMsg::mSwipeGestureMsgSubscriberList
};

// ------------------------------------------------------------------------
::Courier::Message::ModifiableMetadata SwipeGestureMsg::mSwipeGestureMsgModifiableMetadata;

// ------------------------------------------------------------------------
const ::Courier::Message::Metadata& SwipeGestureMsg::GetMetadata() const
{
    return mSwipeGestureMsgMetaData;
}

// ------------------------------------------------------------------------
::Courier::Message::ModifiableMetadata & SwipeGestureMsg::GetModifiableMetadata() 
{
    return mSwipeGestureMsgModifiableMetadata;
}

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
::FeatStd::UInt32 SwipeGestureMsg::AppendTo(::FeatStd::StringBuffer& stringBuffer) const
{
    ::FeatStd::UInt32 tcharCount = 0;
    tcharCount += stringBuffer.Append("::hmibase::widget::gesture::SwipeGestureMsg { ");
    tcharCount += stringBuffer.Append("Velocity1X = ");
    tcharCount += stringBuffer.AppendObject(GetVelocity1X());
    tcharCount += stringBuffer.Append(", ");
    tcharCount += stringBuffer.Append("Velocity1Y = ");
    tcharCount += stringBuffer.AppendObject(GetVelocity1Y());
    tcharCount += stringBuffer.Append(", ");
    tcharCount += stringBuffer.Append("Velocity2X = ");
    tcharCount += stringBuffer.AppendObject(GetVelocity2X());
    tcharCount += stringBuffer.Append(", ");
    tcharCount += stringBuffer.Append("Velocity2Y = ");
    tcharCount += stringBuffer.AppendObject(GetVelocity2Y());
    tcharCount += stringBuffer.Append(", ");
    tcharCount += stringBuffer.Append("Velocity3X = ");
    tcharCount += stringBuffer.AppendObject(GetVelocity3X());
    tcharCount += stringBuffer.Append(", ");
    tcharCount += stringBuffer.Append("Velocity3Y = ");
    tcharCount += stringBuffer.AppendObject(GetVelocity3Y());
    tcharCount += stringBuffer.Append(", ");
    tcharCount += ::hmibase::widget::gesture::GestureMsg::AppendTo(stringBuffer);
    tcharCount += stringBuffer.Append(" }");
    return tcharCount;
}
#endif
// ========================================================================

::Courier::ComponentId PinchSpreadGestureMsg::mPinchSpreadGestureMsgSubscriberList[PinchSpreadGestureMsg::SubscriberListSize] = {
    ::Courier::ComponentId(::Courier::ComponentType::Controller),
    ::Courier::ComponentId(::Courier::ComponentType::Model),
    ::Courier::ComponentId(::Courier::ComponentType::Invalid)
};

// ------------------------------------------------------------------------
bool PinchSpreadGestureMsg::Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before)
{
    return ::Courier::Message::Subscribe(PinchSpreadGestureMsg::mPinchSpreadGestureMsgSubscriberList, PinchSpreadGestureMsg::SubscriberListSize, component, before);
}

// ------------------------------------------------------------------------
bool PinchSpreadGestureMsg::Unsubscribe(::Courier::ComponentId component)
{
    return ::Courier::Message::Unsubscribe(PinchSpreadGestureMsg::mPinchSpreadGestureMsgSubscriberList, PinchSpreadGestureMsg::SubscriberListSize, component);
}

// ------------------------------------------------------------------------
PinchSpreadGestureMsg::PinchSpreadGestureMsg() :
    Base(),
    mEvent(enGestureEvent::Enum()),
    mCoordinate1X(Courier::Int()),
    mCoordinate1Y(Courier::Int()),
    mCoordinate2X(Courier::Int()),
    mCoordinate2Y(Courier::Int())
{
    InitializeLocalSubscriberList(mSubscribers);
}

// ------------------------------------------------------------------------
PinchSpreadGestureMsg::PinchSpreadGestureMsg(::Courier::ViewId const & aView, ::Courier::Identifier const & aSender, ::FeatStd::UInt32 const & aUserData, Courier::Int const & aTimestamp, enGestureEvent::Enum const & aEvent, Courier::Int const & aCoordinate1X, Courier::Int const & aCoordinate1Y, Courier::Int const & aCoordinate2X, Courier::Int const & aCoordinate2Y) :
    GestureMsg(aView, aSender, aUserData, aTimestamp), mEvent(aEvent), mCoordinate1X(aCoordinate1X), mCoordinate1Y(aCoordinate1Y), mCoordinate2X(aCoordinate2X), mCoordinate2Y(aCoordinate2Y)
{
    InitializeLocalSubscriberList(mSubscribers);
}

// ------------------------------------------------------------------------
PinchSpreadGestureMsg::~PinchSpreadGestureMsg()
{
    ResetLocalSubscriberList();
}

// ------------------------------------------------------------------------
const ::Courier::Message::Metadata PinchSpreadGestureMsg::mPinchSpreadGestureMsgMetaData = {
    {true, true, false, ::FeatStd::UInt8(::Courier::Priority::Normal), ::FeatStd::UInt8(::Courier::MessageTag::None), PinchSpreadGestureMsg::SubscriberListSize},
    COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x73A6BE7D, PinchSpreadGestureMsg),
    0xFFFFFFFF,
    PinchSpreadGestureMsg::mPinchSpreadGestureMsgSubscriberList
};

// ------------------------------------------------------------------------
::Courier::Message::ModifiableMetadata PinchSpreadGestureMsg::mPinchSpreadGestureMsgModifiableMetadata;

// ------------------------------------------------------------------------
const ::Courier::Message::Metadata& PinchSpreadGestureMsg::GetMetadata() const
{
    return mPinchSpreadGestureMsgMetaData;
}

// ------------------------------------------------------------------------
::Courier::Message::ModifiableMetadata & PinchSpreadGestureMsg::GetModifiableMetadata() 
{
    return mPinchSpreadGestureMsgModifiableMetadata;
}

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
::FeatStd::UInt32 PinchSpreadGestureMsg::AppendTo(::FeatStd::StringBuffer& stringBuffer) const
{
    ::FeatStd::UInt32 tcharCount = 0;
    tcharCount += stringBuffer.Append("::hmibase::widget::gesture::PinchSpreadGestureMsg { ");
    tcharCount += stringBuffer.Append("Event = ");
    tcharCount += stringBuffer.AppendObject(GetEvent());
    tcharCount += stringBuffer.Append(", ");
    tcharCount += stringBuffer.Append("Coordinate1X = ");
    tcharCount += stringBuffer.AppendObject(GetCoordinate1X());
    tcharCount += stringBuffer.Append(", ");
    tcharCount += stringBuffer.Append("Coordinate1Y = ");
    tcharCount += stringBuffer.AppendObject(GetCoordinate1Y());
    tcharCount += stringBuffer.Append(", ");
    tcharCount += stringBuffer.Append("Coordinate2X = ");
    tcharCount += stringBuffer.AppendObject(GetCoordinate2X());
    tcharCount += stringBuffer.Append(", ");
    tcharCount += stringBuffer.Append("Coordinate2Y = ");
    tcharCount += stringBuffer.AppendObject(GetCoordinate2Y());
    tcharCount += stringBuffer.Append(", ");
    tcharCount += ::hmibase::widget::gesture::GestureMsg::AppendTo(stringBuffer);
    tcharCount += stringBuffer.Append(" }");
    return tcharCount;
}
#endif
// ========================================================================

::Courier::ComponentId RotateGestureMsg::mRotateGestureMsgSubscriberList[RotateGestureMsg::SubscriberListSize] = {
    ::Courier::ComponentId(::Courier::ComponentType::Controller),
    ::Courier::ComponentId(::Courier::ComponentType::Model),
    ::Courier::ComponentId(::Courier::ComponentType::Invalid)
};

// ------------------------------------------------------------------------
bool RotateGestureMsg::Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before)
{
    return ::Courier::Message::Subscribe(RotateGestureMsg::mRotateGestureMsgSubscriberList, RotateGestureMsg::SubscriberListSize, component, before);
}

// ------------------------------------------------------------------------
bool RotateGestureMsg::Unsubscribe(::Courier::ComponentId component)
{
    return ::Courier::Message::Unsubscribe(RotateGestureMsg::mRotateGestureMsgSubscriberList, RotateGestureMsg::SubscriberListSize, component);
}

// ------------------------------------------------------------------------
RotateGestureMsg::RotateGestureMsg() :
    Base(),
    mEvent(enGestureEvent::Enum()),
    mAngle(Courier::Int16()),
    mCoordinate1X(Courier::Int()),
    mCoordinate1Y(Courier::Int()),
    mCoordinate2X(Courier::Int()),
    mCoordinate2Y(Courier::Int())
{
    InitializeLocalSubscriberList(mSubscribers);
}

// ------------------------------------------------------------------------
RotateGestureMsg::RotateGestureMsg(::Courier::ViewId const & aView, ::Courier::Identifier const & aSender, ::FeatStd::UInt32 const & aUserData, Courier::Int const & aTimestamp, enGestureEvent::Enum const & aEvent, Courier::Int16 const & aAngle, Courier::Int const & aCoordinate1X, Courier::Int const & aCoordinate1Y, Courier::Int const & aCoordinate2X, Courier::Int const & aCoordinate2Y) :
    GestureMsg(aView, aSender, aUserData, aTimestamp), mEvent(aEvent), mAngle(aAngle), mCoordinate1X(aCoordinate1X), mCoordinate1Y(aCoordinate1Y), mCoordinate2X(aCoordinate2X), mCoordinate2Y(aCoordinate2Y)
{
    InitializeLocalSubscriberList(mSubscribers);
}

// ------------------------------------------------------------------------
RotateGestureMsg::~RotateGestureMsg()
{
    ResetLocalSubscriberList();
}

// ------------------------------------------------------------------------
const ::Courier::Message::Metadata RotateGestureMsg::mRotateGestureMsgMetaData = {
    {true, true, false, ::FeatStd::UInt8(::Courier::Priority::Normal), ::FeatStd::UInt8(::Courier::MessageTag::None), RotateGestureMsg::SubscriberListSize},
    COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDAA80A6C, RotateGestureMsg),
    0xFFFFFFFF,
    RotateGestureMsg::mRotateGestureMsgSubscriberList
};

// ------------------------------------------------------------------------
::Courier::Message::ModifiableMetadata RotateGestureMsg::mRotateGestureMsgModifiableMetadata;

// ------------------------------------------------------------------------
const ::Courier::Message::Metadata& RotateGestureMsg::GetMetadata() const
{
    return mRotateGestureMsgMetaData;
}

// ------------------------------------------------------------------------
::Courier::Message::ModifiableMetadata & RotateGestureMsg::GetModifiableMetadata() 
{
    return mRotateGestureMsgModifiableMetadata;
}

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
::FeatStd::UInt32 RotateGestureMsg::AppendTo(::FeatStd::StringBuffer& stringBuffer) const
{
    ::FeatStd::UInt32 tcharCount = 0;
    tcharCount += stringBuffer.Append("::hmibase::widget::gesture::RotateGestureMsg { ");
    tcharCount += stringBuffer.Append("Event = ");
    tcharCount += stringBuffer.AppendObject(GetEvent());
    tcharCount += stringBuffer.Append(", ");
    tcharCount += stringBuffer.Append("Angle = ");
    tcharCount += stringBuffer.AppendObject(GetAngle());
    tcharCount += stringBuffer.Append(", ");
    tcharCount += stringBuffer.Append("Coordinate1X = ");
    tcharCount += stringBuffer.AppendObject(GetCoordinate1X());
    tcharCount += stringBuffer.Append(", ");
    tcharCount += stringBuffer.Append("Coordinate1Y = ");
    tcharCount += stringBuffer.AppendObject(GetCoordinate1Y());
    tcharCount += stringBuffer.Append(", ");
    tcharCount += stringBuffer.Append("Coordinate2X = ");
    tcharCount += stringBuffer.AppendObject(GetCoordinate2X());
    tcharCount += stringBuffer.Append(", ");
    tcharCount += stringBuffer.Append("Coordinate2Y = ");
    tcharCount += stringBuffer.AppendObject(GetCoordinate2Y());
    tcharCount += stringBuffer.Append(", ");
    tcharCount += ::hmibase::widget::gesture::GestureMsg::AppendTo(stringBuffer);
    tcharCount += stringBuffer.Append(" }");
    return tcharCount;
}
#endif
} // namespace gesture
} // namespace widget
} // namespace hmibase

namespace hmibase {
} // namespace hmibase
