/************************************************************************
*FILE: DirectTextureProvider2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(DirectTextureProvider2DBase_h)
#define DirectTextureProvider2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/BaseWidget2D.h>
#include <CanderaPlatform/Device/Common/Base/GraphicDeviceUnit.h>
// ------------------------------------------------------------------------
//! [DirectTextureProvider2DBase_Declaration]
class DirectTextureProvider2DBase : public ::BaseWidget2D
{
    public:
        typedef Candera::Camera2D* CameraType;

        typedef Candera::Camera2D* Camera2Type;

        typedef Candera::Camera2D* Camera3Type;

        typedef Candera::GraphicDeviceUnit* FrameBufferType;

        typedef Candera::GraphicDeviceUnit* FrameBuffer2Type;

        typedef Candera::GraphicDeviceUnit* FrameBuffer3Type;

        typedef Candera::UInt32 InstanceIdType;

        typedef bool ReleaseBufferOnHideType;

        //! [Property_IDs]
        static const FeatStd::UInt32 ReleaseBufferOnHidePropertyId = 0x54530F19;
        //! [Property_IDs]

        DirectTextureProvider2DBase();
        virtual ~DirectTextureProvider2DBase();

        CGI_WIDGET_RTTI_DECLARATION(DirectTextureProvider2DBase, ::BaseWidget2D);

        void SetCamera(const CameraType& camera);
        const CameraType& GetCamera() const { return m_Camera; }

        void SetCamera2(const Camera2Type& camera2);
        const Camera2Type& GetCamera2() const { return m_Camera2; }

        void SetCamera3(const Camera3Type& camera3);
        const Camera3Type& GetCamera3() const { return m_Camera3; }

        void SetFrameBuffer(const FrameBufferType& framebuffer);
        const FrameBufferType& GetFrameBuffer() const { return m_FrameBuffer; }

        void SetFrameBuffer2(const FrameBuffer2Type& framebuffer2);
        const FrameBuffer2Type& GetFrameBuffer2() const { return m_FrameBuffer2; }

        void SetFrameBuffer3(const FrameBuffer3Type& framebuffer3);
        const FrameBuffer3Type& GetFrameBuffer3() const { return m_FrameBuffer3; }

        //! [DataBinding_InstanceIdPropertyGetterSetter]
        void SetInstanceId(const InstanceIdType& instanceid);
        const InstanceIdType& GetInstanceId() const { return m_InstanceId; }
        //! [DataBinding_InstanceIdPropertyGetterSetter]

        //! [DataBinding_ReleaseBufferOnHidePropertyGetterSetter]
        void SetReleaseBufferOnHide(const ReleaseBufferOnHideType& releasebufferonhide);
        const ReleaseBufferOnHideType& GetReleaseBufferOnHide() const { return m_ReleaseBufferOnHide; }
        //! [DataBinding_ReleaseBufferOnHidePropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(DirectTextureProvider2DBase, ::BaseWidget2D)
            CdaDescription("DirectTextureProvider2D widget")
            CdaReadableName("DirectTextureProvider2DBase")

            CdaProperties()
                CdaProperty(Camera, CameraType, GetCamera, SetCamera)
                    CdaDescription("The camera which contains the screen content")
                    CdaCategory("DirectTexture")
                CdaPropertyEnd()
                CdaProperty(Camera2, Camera2Type, GetCamera2, SetCamera2)
                    CdaDescription("Another camera used for triple buffering only")
                    CdaCategory("TripleBuffered")
                CdaPropertyEnd()
                CdaProperty(Camera3, Camera3Type, GetCamera3, SetCamera3)
                    CdaDescription("Another camera used for triple buffering only")
                    CdaCategory("TripleBuffered")
                CdaPropertyEnd()
                CdaProperty(FrameBuffer, FrameBufferType, GetFrameBuffer, SetFrameBuffer)
                    CdaDescription("The off screen render target where to render the content to")
                    CdaCategory("DirectTexture")
                CdaPropertyEnd()
                CdaProperty(FrameBuffer2, FrameBuffer2Type, GetFrameBuffer2, SetFrameBuffer2)
                    CdaDescription("Another off screen render target used for triple buffering only")
                    CdaCategory("TripleBuffered")
                CdaPropertyEnd()
                CdaProperty(FrameBuffer3, FrameBuffer3Type, GetFrameBuffer3, SetFrameBuffer3)
                    CdaDescription("Another off screen render target used for triple buffering only")
                    CdaCategory("TripleBuffered")
                CdaPropertyEnd()
                CdaBindableProperty(InstanceId, InstanceIdType, GetInstanceId, SetInstanceId)
                    CdaDescription("System wide unique id to identify the offscreen content")
                    CdaCategory("DirectTexture")
                CdaBindablePropertyEnd()
                CdaBindableProperty(ReleaseBufferOnHide, ReleaseBufferOnHideType, GetReleaseBufferOnHide, SetReleaseBufferOnHide)
                    CdaDescription("set to true if buffer to be released when view is hidden")
                    CdaCategory("DirectTexture")
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        CameraType m_Camera;
        Camera2Type m_Camera2;
        Camera3Type m_Camera3;
        FrameBufferType m_FrameBuffer;
        FrameBuffer2Type m_FrameBuffer2;
        FrameBuffer3Type m_FrameBuffer3;
        InstanceIdType m_InstanceId;
        ReleaseBufferOnHideType m_ReleaseBufferOnHide;
};

#endif // DirectTextureProvider2DBase_h
