/************************************************************************
*FILE: DirectTextureConsumer2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(DirectTextureConsumer2DBase_h)
#define DirectTextureConsumer2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/Touchable2D.h>
// ------------------------------------------------------------------------
//! [DirectTextureConsumer2DBase_Declaration]
class DirectTextureConsumer2DBase : public ::Touchable2D
{
    public:
        typedef Candera::UInt32 InstanceIdType;

        typedef Candera::UInt32 SlaveSurfaceIdType;

        typedef bool AlignSlaveSurfacePositionType;

        typedef Candera::Camera2D* CameraType;

        //! [Property_IDs]
        static const FeatStd::UInt32 InstanceIdPropertyId = 0xC53943A1;
        static const FeatStd::UInt32 SlaveSurfaceIdPropertyId = 0xFA5E52B2;
        static const FeatStd::UInt32 AlignSlaveSurfacePositionPropertyId = 0xC19B2342;
        //! [Property_IDs]

        DirectTextureConsumer2DBase();
        virtual ~DirectTextureConsumer2DBase();

        CGI_WIDGET_RTTI_DECLARATION(DirectTextureConsumer2DBase, ::Touchable2D);

        //! [DataBinding_InstanceIdPropertyGetterSetter]
        void SetInstanceId(const InstanceIdType& instanceid);
        const InstanceIdType& GetInstanceId() const { return m_InstanceId; }
        //! [DataBinding_InstanceIdPropertyGetterSetter]

        //! [DataBinding_SlaveSurfaceIdPropertyGetterSetter]
        void SetSlaveSurfaceId(const SlaveSurfaceIdType& slavesurfaceid);
        const SlaveSurfaceIdType& GetSlaveSurfaceId() const { return m_SlaveSurfaceId; }
        //! [DataBinding_SlaveSurfaceIdPropertyGetterSetter]

        //! [DataBinding_AlignSlaveSurfacePositionPropertyGetterSetter]
        void SetAlignSlaveSurfacePosition(const AlignSlaveSurfacePositionType& alignslavesurfaceposition);
        const AlignSlaveSurfacePositionType& GetAlignSlaveSurfacePosition() const { return m_AlignSlaveSurfacePosition; }
        //! [DataBinding_AlignSlaveSurfacePositionPropertyGetterSetter]

        void SetCamera(const CameraType& camera);
        const CameraType& GetCamera() const { return m_Camera; }

        // @WidgetBaseClass
        CdaWidget2DDef(DirectTextureConsumer2DBase, ::Touchable2D)
            CdaDescription("DirectTextureConsumer2D widget")
            CdaReadableName("DirectTextureConsumer2DBase")

            CdaProperties()
                CdaBindableProperty(InstanceId, InstanceIdType, GetInstanceId, SetInstanceId)
                    CdaDescription("same unique identifier as the one used for the related provider instance")
                    CdaCategory("DirectTexture")
                CdaBindablePropertyEnd()
                CdaBindableProperty(SlaveSurfaceId, SlaveSurfaceIdType, GetSlaveSurfaceId, SetSlaveSurfaceId)
                    CdaDescription("reposition the surface with this id on every position change of the connected node")
                    CdaCategory("SlaveSurface")
                CdaBindablePropertyEnd()
                CdaBindableProperty(AlignSlaveSurfacePosition, AlignSlaveSurfacePositionType, GetAlignSlaveSurfacePosition, SetAlignSlaveSurfacePosition)
                    CdaDescription("set to true if position of slave surface should be aligned to widget position")
                    CdaCategory("SlaveSurface")
                CdaBindablePropertyEnd()
                CdaProperty(Camera, CameraType, GetCamera, SetCamera)
                    CdaDescription("the camera on which the slave surface should be synced")
                    CdaCategory("SlaveSurface")
                CdaPropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        InstanceIdType m_InstanceId;
        SlaveSurfaceIdType m_SlaveSurfaceId;
        AlignSlaveSurfacePositionType m_AlignSlaveSurfacePosition;
        CameraType m_Camera;
};

#endif // DirectTextureConsumer2DBase_h
