/************************************************************************
*FILE: ColorSwitchWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(hmibase_widget_color_ColorSwitchWidget2DBase_h)
#define hmibase_widget_color_ColorSwitchWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/BaseWidget2D.h>
#include <Widgets/2D/ColorSwitch/generated/ColorSwitchWidget2DTypes.h>

namespace hmibase {
} // namespace hmibase
namespace hmibase {
namespace widget {
namespace color {
// ------------------------------------------------------------------------
//! [ColorSwitchWidget2DBase_Declaration]
class ColorSwitchWidget2DBase : public ::BaseWidget2D
{
    public:
          bool IsPropertyVisible_Index() const { return GetIndexSource() == enIndexSource::IndexProperty; }
          bool IsPropertyVisible_StateFlags() const { return GetIndexSource() != enIndexSource::IndexProperty; }
        typedef enColorProperty::Enum TargetType;

        typedef enIndexSource::Enum IndexSourceType;

        typedef Candera::UInt IndexType;

        typedef enStateFlags::Enum StateFlagsType;

        typedef Candera::ArrayProperty<Candera::Color> ColorsType;

        //! [Property_IDs]
        static const FeatStd::UInt32 TargetPropertyId = 0xE6708F11;
        static const FeatStd::UInt32 IndexSourcePropertyId = 0x42B82F94;
        static const FeatStd::UInt32 IndexPropertyId = 0x3DBCF2F4;
        static const FeatStd::UInt32 StateFlagsPropertyId = 0x56DF0684;
        static const FeatStd::UInt32 ColorsPropertyId = 0x2B020DDD;
        //! [Property_IDs]

        ColorSwitchWidget2DBase();
        virtual ~ColorSwitchWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(ColorSwitchWidget2DBase, ::BaseWidget2D);

        void SetTarget(const TargetType& target);
        const TargetType& GetTarget() const { return m_Target; }

        void SetIndexSource(const IndexSourceType& indexsource);
        const IndexSourceType& GetIndexSource() const { return m_IndexSource; }

        //! [DataBinding_IndexPropertyGetterSetter]
        void SetIndex(const IndexType& index);
        const IndexType& GetIndex() const { return m_Index; }
        //! [DataBinding_IndexPropertyGetterSetter]

        void SetStateFlags(const StateFlagsType& stateflags);
        const StateFlagsType& GetStateFlags() const { return m_StateFlags; }

        //! [DataBinding_ColorsPropertyGetterSetter]
        void SetColors(const ColorsType& colors);
        const ColorsType& GetColors() const { return m_Colors; }
        //! [DataBinding_ColorsPropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(ColorSwitchWidget2DBase, ::BaseWidget2D)
            CdaDescription("Selects a color from an array based on an index or a source widget state and sets it on a target color property of an effect or another widget.")
            CdaReadableName("ColorSwitchWidget2DBase")
            CdaCategory("Common")

            CdaProperties()
                CdaProperty(Target, TargetType, GetTarget, SetTarget)
                    CdaDescription("Specifies how the target color property is determined. It can be a property of an effect contained in the node or it can be a property of a widget associated to the same node as this widget.")
                CdaPropertyEnd()
                CdaProperty(IndexSource, IndexSourceType, GetIndexSource, SetIndexSource)
                    CdaDescription("Specifies how the index is determined. It can be explicitely specified using the Index property or it can be obtained based on the state of another widget associated to the same node or an ancestor node.")
                CdaPropertyEnd()
                CdaBindableProperty(Index, IndexType, GetIndex, SetIndex)
                    CdaDescription("Index used to select the color.")
                    CdaVisibilityTest(IsPropertyVisible_Index)
                CdaBindablePropertyEnd()
                CdaProperty(StateFlags, StateFlagsType, GetStateFlags, SetStateFlags)
                    CdaDescription("Specifies which flags of the source widget state are used to determine the index.\nThe number of colors required for the Colors array property depends on the number of flags which are used:\n - 1 flag (Enabled, Pressed, Active, Focused)\n  => 2 colors [0, 1],\n - 2 flags (PressedEnabled, ActiveEnabled, ActivePressed, FocusedEnabled, FocusedPressed, FocusedActive)\n  => 4 colors [00, 01, 10, 11],\n - 3 flags (ActivePressedEnabled, FocusedPressedEnabled, FocusedActivePressed)\n  => 8 colors [000, 001, 010, 011, 100, 101, 110, 111],\n - 4 flags (FocusedActivePressedEnabled)\n  => 16 colors [0000, 0001, 0010, 0011, 0100, 0101, 0110, 0111, 1000, 1001, 1010, 1011, 1100, 1101, 1110, 1111].\nThe order or the flags should match the order of the colors.\nFor example, PressedEnabled requires 4 colors:\n - NotPressed_NotEnabled=Colors[0],\n - NotPressed_Enabled=Colors[1],\n - Pressed_NotEnabled=Colors[2],\n - Pressed_Enabled=Colors[3].")
                    CdaVisibilityTest(IsPropertyVisible_StateFlags)
                CdaPropertyEnd()
                CdaBindableProperty(Colors, ColorsType, GetColors, SetColors)
                    CdaDescription("Colors : Candera::ArrayProperty<Candera::Color>")
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        TargetType m_Target;
        IndexSourceType m_IndexSource;
        IndexType m_Index;
        StateFlagsType m_StateFlags;
        ColorsType m_Colors;
};
} // namespace color
} // namespace widget
} // namespace hmibase

#endif // hmibase_widget_color_ColorSwitchWidget2DBase_h
