/************************************************************************
*FILE: ClockWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(ClockWidget2DBase_h)
#define ClockWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/BaseWidget2D.h>
// ------------------------------------------------------------------------
//! [ClockWidget2DBase_Declaration]
class ClockWidget2DBase : public ::BaseWidget2D
{
    public:
        typedef Candera::UInt8 SkinIndexType;

        typedef Candera::UInt8 HourType;

        typedef Candera::UInt8 MinuteType;

        typedef Candera::UInt8 SecondType;

        typedef Candera::String ImagePathType;

        typedef Candera::String ClockFaceImageNameType;

        typedef Candera::String HourImageNameType;

        typedef Candera::String MinuteImageNameType;

        typedef Candera::String SecondImageNameType;

        //! [Property_IDs]
        static const FeatStd::UInt32 SkinIndexPropertyId = 0xC27079EF;
        static const FeatStd::UInt32 HourPropertyId = 0xE3768202;
        static const FeatStd::UInt32 MinutePropertyId = 0xA400950F;
        static const FeatStd::UInt32 SecondPropertyId = 0xDE1DAB1E;
        static const FeatStd::UInt32 ImagePathPropertyId = 0xE98237D3;
        static const FeatStd::UInt32 ClockFaceImageNamePropertyId = 0x6790DFEC;
        static const FeatStd::UInt32 HourImageNamePropertyId = 0x64C0A458;
        static const FeatStd::UInt32 MinuteImageNamePropertyId = 0x24741928;
        static const FeatStd::UInt32 SecondImageNamePropertyId = 0x5C25129E;
        //! [Property_IDs]

        ClockWidget2DBase();
        virtual ~ClockWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(ClockWidget2DBase, ::BaseWidget2D);

        //! [DataBinding_SkinIndexPropertyGetterSetter]
        void SetSkinIndex(const SkinIndexType& skinindex);
        const SkinIndexType& GetSkinIndex() const { return m_SkinIndex; }
        //! [DataBinding_SkinIndexPropertyGetterSetter]

        //! [DataBinding_HourPropertyGetterSetter]
        void SetHour(const HourType& hour);
        const HourType& GetHour() const { return m_Hour; }
        //! [DataBinding_HourPropertyGetterSetter]

        //! [DataBinding_MinutePropertyGetterSetter]
        void SetMinute(const MinuteType& minute);
        const MinuteType& GetMinute() const { return m_Minute; }
        //! [DataBinding_MinutePropertyGetterSetter]

        //! [DataBinding_SecondPropertyGetterSetter]
        void SetSecond(const SecondType& second);
        const SecondType& GetSecond() const { return m_Second; }
        //! [DataBinding_SecondPropertyGetterSetter]

        void SetImagePath(const ImagePathType& imagepath);
        const ImagePathType& GetImagePath() const { return m_ImagePath; }

        void SetClockFaceImageName(const ClockFaceImageNameType& clockfaceimagename);
        const ClockFaceImageNameType& GetClockFaceImageName() const { return m_ClockFaceImageName; }

        void SetHourImageName(const HourImageNameType& hourimagename);
        const HourImageNameType& GetHourImageName() const { return m_HourImageName; }

        void SetMinuteImageName(const MinuteImageNameType& minuteimagename);
        const MinuteImageNameType& GetMinuteImageName() const { return m_MinuteImageName; }

        void SetSecondImageName(const SecondImageNameType& secondimagename);
        const SecondImageNameType& GetSecondImageName() const { return m_SecondImageName; }

        // @WidgetBaseClass
        CdaWidget2DDef(ClockWidget2DBase, ::BaseWidget2D)
            CdaDescription("ClockWiget is used to display an analogue clock with a clock face as background image and two or three clock hand images for hours, minute and second. The clock is skinable, meaning the complete set of images(clock face and hands) can be changed during runtime.")
            CdaReadableName("ClockWidget2DBase")
            CdaCategory("Extra")

            CdaProperties()
                CdaBindableProperty(SkinIndex, SkinIndexType, GetSkinIndex, SetSkinIndex)
                    CdaDescription("The index of the skin (0,1,...).")
                CdaBindablePropertyEnd()
                CdaBindableProperty(Hour, HourType, GetHour, SetHour)
                    CdaDescription("The hour value (0..23).")
                CdaBindablePropertyEnd()
                CdaBindableProperty(Minute, MinuteType, GetMinute, SetMinute)
                    CdaDescription("The Minute value (0..59).")
                CdaBindablePropertyEnd()
                CdaBindableProperty(Second, SecondType, GetSecond, SetSecond)
                    CdaDescription("The Second value (0..59).")
                CdaBindablePropertyEnd()
                CdaProperty(ImagePath, ImagePathType, GetImagePath, SetImagePath)
                    CdaDescription("Path to the clock images which must include a placeholder [%d] for the skin index (e.g. 'Widgets#Scenes2D#Bitmaps#Clock#Skin%d') .")
                CdaPropertyEnd()
                CdaProperty(ClockFaceImageName, ClockFaceImageNameType, GetClockFaceImageName, SetClockFaceImageName)
                    CdaDescription("Name for the clock face image (e.g. 'ClockFaceBmp'.")
                CdaPropertyEnd()
                CdaProperty(HourImageName, HourImageNameType, GetHourImageName, SetHourImageName)
                    CdaDescription("Name for the hour image stored in the asset. The can be used with an image set of 60 images, in this case the name should contain a placeholder [%d] for the hours index. If the name has no placeholder, than only one single image will be uploaded and internal SetRotate() will update the hour (e.g. 'ClockHour_%02dBmp').")
                CdaPropertyEnd()
                CdaProperty(MinuteImageName, MinuteImageNameType, GetMinuteImageName, SetMinuteImageName)
                    CdaDescription("Name for the hour image stored in the asset. The can be used with an image set of 60 images, in this case the name should contain a placeholder [%d] for the minutes index. If the name has no placeholder, than only one single image will be uploaded and internal SetRotate() will update the minute (e.g. 'ClockMin_%02dBmp').")
                CdaPropertyEnd()
                CdaProperty(SecondImageName, SecondImageNameType, GetSecondImageName, SetSecondImageName)
                    CdaDescription("Name for the hour image stored in the asset. The can be used with an image set of 60 images, in this case the name should contain a placeholder [%d] for the seconds index. If the name has no placeholder, than only one single image will be uploaded and internal SetRotate() will update the seconds (e.g. 'ClockSec_%02dBmp').")
                CdaPropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        SkinIndexType m_SkinIndex;
        HourType m_Hour;
        MinuteType m_Minute;
        SecondType m_Second;
        ImagePathType m_ImagePath;
        ClockFaceImageNameType m_ClockFaceImageName;
        HourImageNameType m_HourImageName;
        MinuteImageNameType m_MinuteImageName;
        SecondImageNameType m_SecondImageName;
};

#endif // ClockWidget2DBase_h
