/************************************************************************
*FILE: ClockWidget2DBase.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ***************************************************************************************
 * FILE:          Generated intermediate file from HMIContract.exe
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  This file is part of HMI-Base Widget Library 
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "widget2D_std_if.h"

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "ClockWidget2DBase.h"

// ------------------------------------------------------------------------
CGI_WIDGET_RTTI_DEFINITION(ClockWidget2DBase)

ClockWidget2DBase::ClockWidget2DBase() :
    m_SkinIndex(SkinIndexType()),
    m_Hour(HourType()),
    m_Minute(MinuteType()),
    m_Second(SecondType()),
    m_ImagePath(ImagePathType()),
    m_ClockFaceImageName(ClockFaceImageNameType()),
    m_HourImageName(HourImageNameType()),
    m_MinuteImageName(MinuteImageNameType()),
    m_SecondImageName(SecondImageNameType())
{
}

ClockWidget2DBase::~ClockWidget2DBase()
{
}

void ClockWidget2DBase::SetSkinIndex(const SkinIndexType& skinindex)
{
    if (m_SkinIndex != skinindex) {
        m_SkinIndex = skinindex;
        OnChanged(static_cast< ::FeatStd::UInt32>(SkinIndexPropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("SkinIndex");
        }
    }
}

void ClockWidget2DBase::SetHour(const HourType& hour)
{
    if (m_Hour != hour) {
        m_Hour = hour;
        OnChanged(static_cast< ::FeatStd::UInt32>(HourPropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("Hour");
        }
    }
}

void ClockWidget2DBase::SetMinute(const MinuteType& minute)
{
    if (m_Minute != minute) {
        m_Minute = minute;
        OnChanged(static_cast< ::FeatStd::UInt32>(MinutePropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("Minute");
        }
    }
}

void ClockWidget2DBase::SetSecond(const SecondType& second)
{
    if (m_Second != second) {
        m_Second = second;
        OnChanged(static_cast< ::FeatStd::UInt32>(SecondPropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("Second");
        }
    }
}

void ClockWidget2DBase::SetImagePath(const ImagePathType& imagepath)
{
    if (m_ImagePath != imagepath) {
        m_ImagePath = imagepath;
        OnChanged(static_cast< ::FeatStd::UInt32>(ImagePathPropertyId));
    }
}

void ClockWidget2DBase::SetClockFaceImageName(const ClockFaceImageNameType& clockfaceimagename)
{
    if (m_ClockFaceImageName != clockfaceimagename) {
        m_ClockFaceImageName = clockfaceimagename;
        OnChanged(static_cast< ::FeatStd::UInt32>(ClockFaceImageNamePropertyId));
    }
}

void ClockWidget2DBase::SetHourImageName(const HourImageNameType& hourimagename)
{
    if (m_HourImageName != hourimagename) {
        m_HourImageName = hourimagename;
        OnChanged(static_cast< ::FeatStd::UInt32>(HourImageNamePropertyId));
    }
}

void ClockWidget2DBase::SetMinuteImageName(const MinuteImageNameType& minuteimagename)
{
    if (m_MinuteImageName != minuteimagename) {
        m_MinuteImageName = minuteimagename;
        OnChanged(static_cast< ::FeatStd::UInt32>(MinuteImageNamePropertyId));
    }
}

void ClockWidget2DBase::SetSecondImageName(const SecondImageNameType& secondimagename)
{
    if (m_SecondImageName != secondimagename) {
        m_SecondImageName = secondimagename;
        OnChanged(static_cast< ::FeatStd::UInt32>(SecondImageNamePropertyId));
    }
}
