/************************************************************************
*FILE: CameraControlWidget2DBase.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ***************************************************************************************
 * FILE:          Generated intermediate file from HMIContract.exe
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  This file is part of HMI-Base Widget Library 
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "widget2D_std_if.h"

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "CameraControlWidget2DBase.h"

// ------------------------------------------------------------------------
CGI_WIDGET_RTTI_DEFINITION(CameraControlWidget2DBase)

CameraControlWidget2DBase::CameraControlWidget2DBase() :
    m_ViewportEnabled(true),
    m_Viewport(0.0f, 0.0f, -1.0f, -1.0f),
    m_UseForTouchEnabled(false),
    m_UseForTouch(true)
{
}

CameraControlWidget2DBase::~CameraControlWidget2DBase()
{
}

void CameraControlWidget2DBase::SetViewportEnabled(const ViewportEnabledType& viewportenabled)
{
    if (m_ViewportEnabled != viewportenabled) {
        m_ViewportEnabled = viewportenabled;
    }
}

void CameraControlWidget2DBase::SetViewport(const ViewportType& viewport)
{
    if (m_Viewport != viewport) {
        m_Viewport = viewport;
        OnChanged(static_cast< ::FeatStd::UInt32>(ViewportPropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("Viewport");
        }
    }
}

void CameraControlWidget2DBase::SetUseForTouchEnabled(const UseForTouchEnabledType& usefortouchenabled)
{
    if (m_UseForTouchEnabled != usefortouchenabled) {
        m_UseForTouchEnabled = usefortouchenabled;
    }
}

void CameraControlWidget2DBase::SetUseForTouch(const UseForTouchType& usefortouch)
{
    if (m_UseForTouch != usefortouch) {
        m_UseForTouch = usefortouch;
        OnChanged(static_cast< ::FeatStd::UInt32>(UseForTouchPropertyId));
#if !defined COURIER_DISABLED
        if (0 != GetParentView())
#endif 
        {
            PropertyModified("UseForTouch");
        }
    }
}
