/************************************************************************
*FILE: ButtonTextWidgets2DBase.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ***************************************************************************************
 * FILE:          Generated intermediate file from HMIContract.exe
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  This file is part of HMI-Base Widget Library 
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "widget2D_std_if.h"

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "ButtonTextWidgets2DBase.h"

// ------------------------------------------------------------------------
CGI_WIDGET_RTTI_DEFINITION(ButtonTextColorWidget2DBase)

ButtonTextColorWidget2DBase::ButtonTextColorWidget2DBase() :
    m_OutlineColorConfiguration(OutlineColorConfigurationType()),
    m_NormalTextColor(Candera::Color(1.0f, 1.0f, 1.0f, 1.0f)),
    m_PressedTextColor(Candera::Color(1.0f, 0.2f, 0.2f, 1.0f)),
    m_DisabledTextColor(Candera::Color(0.5f, 0.5f, 0.5f, 1.0f)),
    m_PressedDisabledTextColor(Candera::Color(0.7f, 0.2f, 0.2f, 1.0f)),
    m_ActiveNormalTextColor(Candera::Color(1.0f, 0.5f, 0.2f, 1.0f)),
    m_ActivePressedTextColor(Candera::Color(1.0f, 0.2f, 0.2f, 1.0f)),
    m_ActiveDisabledTextColor(Candera::Color(0.7f, 0.7f, 0.7f, 1.0f)),
    m_ActivePressedDisabledTextColor(Candera::Color(0.7f, 0.2f, 0.2f, 1.0f)),
    m_FocusedNormalTextColor(Candera::Color(0.5f, 0.5f, 1.0f, 1.0f)),
    m_FocusedPressedTextColor(Candera::Color(1.0f, 0.2f, 0.2f, 1.0f)),
    m_FocusedDisabledTextColor(Candera::Color(0.5f, 0.5f, 0.5f, 1.0f)),
    m_FocusedPressedDisabledTextColor(Candera::Color(0.7f, 0.2f, 0.2f, 1.0f)),
    m_FocusedActiveNormalTextColor(Candera::Color(0.7f, 0.7f, 1.0f, 1.0f)),
    m_FocusedActivePressedTextColor(Candera::Color(1.0f, 0.2f, 0.2f, 1.0f)),
    m_FocusedActiveDisabledTextColor(Candera::Color(0.7f, 0.7f, 0.7f, 1.0f)),
    m_FocusedActivePressedDisabledTextColor(Candera::Color(0.7f, 0.2f, 0.2f, 1.0f))
{
}

ButtonTextColorWidget2DBase::~ButtonTextColorWidget2DBase()
{
}

void ButtonTextColorWidget2DBase::SetOutlineColorConfiguration(const OutlineColorConfigurationType& outlinecolorconfiguration)
{
    if (m_OutlineColorConfiguration != outlinecolorconfiguration) {
        m_OutlineColorConfiguration = outlinecolorconfiguration;
        OnChanged(static_cast< ::FeatStd::UInt32>(OutlineColorConfigurationPropertyId));
    }
}

void ButtonTextColorWidget2DBase::SetNormalTextColor(const NormalTextColorType& normaltextcolor)
{
    if (m_NormalTextColor != normaltextcolor) {
        m_NormalTextColor = normaltextcolor;
        OnChanged(static_cast< ::FeatStd::UInt32>(NormalTextColorPropertyId));
    }
}

void ButtonTextColorWidget2DBase::SetPressedTextColor(const PressedTextColorType& pressedtextcolor)
{
    if (m_PressedTextColor != pressedtextcolor) {
        m_PressedTextColor = pressedtextcolor;
        OnChanged(static_cast< ::FeatStd::UInt32>(PressedTextColorPropertyId));
    }
}

void ButtonTextColorWidget2DBase::SetDisabledTextColor(const DisabledTextColorType& disabledtextcolor)
{
    if (m_DisabledTextColor != disabledtextcolor) {
        m_DisabledTextColor = disabledtextcolor;
        OnChanged(static_cast< ::FeatStd::UInt32>(DisabledTextColorPropertyId));
    }
}

void ButtonTextColorWidget2DBase::SetPressedDisabledTextColor(const PressedDisabledTextColorType& presseddisabledtextcolor)
{
    if (m_PressedDisabledTextColor != presseddisabledtextcolor) {
        m_PressedDisabledTextColor = presseddisabledtextcolor;
        OnChanged(static_cast< ::FeatStd::UInt32>(PressedDisabledTextColorPropertyId));
    }
}

void ButtonTextColorWidget2DBase::SetActiveNormalTextColor(const ActiveNormalTextColorType& activenormaltextcolor)
{
    if (m_ActiveNormalTextColor != activenormaltextcolor) {
        m_ActiveNormalTextColor = activenormaltextcolor;
        OnChanged(static_cast< ::FeatStd::UInt32>(ActiveNormalTextColorPropertyId));
    }
}

void ButtonTextColorWidget2DBase::SetActivePressedTextColor(const ActivePressedTextColorType& activepressedtextcolor)
{
    if (m_ActivePressedTextColor != activepressedtextcolor) {
        m_ActivePressedTextColor = activepressedtextcolor;
        OnChanged(static_cast< ::FeatStd::UInt32>(ActivePressedTextColorPropertyId));
    }
}

void ButtonTextColorWidget2DBase::SetActiveDisabledTextColor(const ActiveDisabledTextColorType& activedisabledtextcolor)
{
    if (m_ActiveDisabledTextColor != activedisabledtextcolor) {
        m_ActiveDisabledTextColor = activedisabledtextcolor;
        OnChanged(static_cast< ::FeatStd::UInt32>(ActiveDisabledTextColorPropertyId));
    }
}

void ButtonTextColorWidget2DBase::SetActivePressedDisabledTextColor(const ActivePressedDisabledTextColorType& activepresseddisabledtextcolor)
{
    if (m_ActivePressedDisabledTextColor != activepresseddisabledtextcolor) {
        m_ActivePressedDisabledTextColor = activepresseddisabledtextcolor;
        OnChanged(static_cast< ::FeatStd::UInt32>(ActivePressedDisabledTextColorPropertyId));
    }
}

void ButtonTextColorWidget2DBase::SetFocusedNormalTextColor(const FocusedNormalTextColorType& focusednormaltextcolor)
{
    if (m_FocusedNormalTextColor != focusednormaltextcolor) {
        m_FocusedNormalTextColor = focusednormaltextcolor;
        OnChanged(static_cast< ::FeatStd::UInt32>(FocusedNormalTextColorPropertyId));
    }
}

void ButtonTextColorWidget2DBase::SetFocusedPressedTextColor(const FocusedPressedTextColorType& focusedpressedtextcolor)
{
    if (m_FocusedPressedTextColor != focusedpressedtextcolor) {
        m_FocusedPressedTextColor = focusedpressedtextcolor;
        OnChanged(static_cast< ::FeatStd::UInt32>(FocusedPressedTextColorPropertyId));
    }
}

void ButtonTextColorWidget2DBase::SetFocusedDisabledTextColor(const FocusedDisabledTextColorType& focuseddisabledtextcolor)
{
    if (m_FocusedDisabledTextColor != focuseddisabledtextcolor) {
        m_FocusedDisabledTextColor = focuseddisabledtextcolor;
        OnChanged(static_cast< ::FeatStd::UInt32>(FocusedDisabledTextColorPropertyId));
    }
}

void ButtonTextColorWidget2DBase::SetFocusedPressedDisabledTextColor(const FocusedPressedDisabledTextColorType& focusedpresseddisabledtextcolor)
{
    if (m_FocusedPressedDisabledTextColor != focusedpresseddisabledtextcolor) {
        m_FocusedPressedDisabledTextColor = focusedpresseddisabledtextcolor;
        OnChanged(static_cast< ::FeatStd::UInt32>(FocusedPressedDisabledTextColorPropertyId));
    }
}

void ButtonTextColorWidget2DBase::SetFocusedActiveNormalTextColor(const FocusedActiveNormalTextColorType& focusedactivenormaltextcolor)
{
    if (m_FocusedActiveNormalTextColor != focusedactivenormaltextcolor) {
        m_FocusedActiveNormalTextColor = focusedactivenormaltextcolor;
        OnChanged(static_cast< ::FeatStd::UInt32>(FocusedActiveNormalTextColorPropertyId));
    }
}

void ButtonTextColorWidget2DBase::SetFocusedActivePressedTextColor(const FocusedActivePressedTextColorType& focusedactivepressedtextcolor)
{
    if (m_FocusedActivePressedTextColor != focusedactivepressedtextcolor) {
        m_FocusedActivePressedTextColor = focusedactivepressedtextcolor;
        OnChanged(static_cast< ::FeatStd::UInt32>(FocusedActivePressedTextColorPropertyId));
    }
}

void ButtonTextColorWidget2DBase::SetFocusedActiveDisabledTextColor(const FocusedActiveDisabledTextColorType& focusedactivedisabledtextcolor)
{
    if (m_FocusedActiveDisabledTextColor != focusedactivedisabledtextcolor) {
        m_FocusedActiveDisabledTextColor = focusedactivedisabledtextcolor;
        OnChanged(static_cast< ::FeatStd::UInt32>(FocusedActiveDisabledTextColorPropertyId));
    }
}

void ButtonTextColorWidget2DBase::SetFocusedActivePressedDisabledTextColor(const FocusedActivePressedDisabledTextColorType& focusedactivepresseddisabledtextcolor)
{
    if (m_FocusedActivePressedDisabledTextColor != focusedactivepresseddisabledtextcolor) {
        m_FocusedActivePressedDisabledTextColor = focusedactivepresseddisabledtextcolor;
        OnChanged(static_cast< ::FeatStd::UInt32>(FocusedActivePressedDisabledTextColorPropertyId));
    }
}

// ------------------------------------------------------------------------
CGI_WIDGET_RTTI_DEFINITION(ButtonTextScrollWidget2DBase)

ButtonTextScrollWidget2DBase::ButtonTextScrollWidget2DBase() :
    m_ScrollOnFocusGain(false)
{
}

ButtonTextScrollWidget2DBase::~ButtonTextScrollWidget2DBase()
{
}

void ButtonTextScrollWidget2DBase::SetScrollOnFocusGain(const ScrollOnFocusGainType& scrollonfocusgain)
{
    if (m_ScrollOnFocusGain != scrollonfocusgain) {
        m_ScrollOnFocusGain = scrollonfocusgain;
        OnChanged(static_cast< ::FeatStd::UInt32>(ScrollOnFocusGainPropertyId));
    }
}
