/************************************************************************
*FILE: ButtonGroupWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(ButtonGroupWidget2DBase_h)
#define ButtonGroupWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/Touchable2D.h>
// ------------------------------------------------------------------------
//! [ButtonGroupWidget2DBase_Declaration]
class ButtonGroupWidget2DBase : public ::Touchable2D
{
    public:
        typedef ::Candera::Int32 ActiveIndexType;

        typedef Candera::Node2D* AdornerContainerNodeType;

        typedef bool AnimationEnabledType;

        typedef Candera::UInt32 AnimationDurationType;

        //! [Property_IDs]
        static const FeatStd::UInt32 ActiveIndexPropertyId = 0xC8168878;
        static const FeatStd::UInt32 AdornerContainerNodePropertyId = 0x491B2B4B;
        static const FeatStd::UInt32 AnimationEnabledPropertyId = 0x535202A8;
        static const FeatStd::UInt32 AnimationDurationPropertyId = 0xDC08D9B9;
        //! [Property_IDs]

        ButtonGroupWidget2DBase();
        virtual ~ButtonGroupWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(ButtonGroupWidget2DBase, ::Touchable2D);

        //! [DataBinding_ActiveIndexPropertyGetterSetter]
        void SetActiveIndex(const ActiveIndexType& activeindex);
        const ActiveIndexType& GetActiveIndex() const { return m_ActiveIndex; }
        //! [DataBinding_ActiveIndexPropertyGetterSetter]

        void SetAdornerContainerNode(const AdornerContainerNodeType& adornercontainernode);
        const AdornerContainerNodeType& GetAdornerContainerNode() const { return m_AdornerContainerNode; }

        //! [DataBinding_AnimationEnabledPropertyGetterSetter]
        void SetAnimationEnabled(const AnimationEnabledType& animationenabled);
        const AnimationEnabledType& GetAnimationEnabled() const { return m_AnimationEnabled; }
        //! [DataBinding_AnimationEnabledPropertyGetterSetter]

        //! [DataBinding_AnimationDurationPropertyGetterSetter]
        void SetAnimationDuration(const AnimationDurationType& animationduration);
        const AnimationDurationType& GetAnimationDuration() const { return m_AnimationDuration; }
        //! [DataBinding_AnimationDurationPropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(ButtonGroupWidget2DBase, ::Touchable2D)
            CdaDescription("Groups buttons together and provides support for option groups in which maximum one button is active.")
            CdaReadableName("ButtonGroupWidget2DBase")
            CdaCategory("Button")

            CdaProperties()
                CdaBindableProperty(ActiveIndex, ActiveIndexType, GetActiveIndex, SetActiveIndex)
                    CdaDescription("Index of the active button. If set to -1 no button will be active.")
                    CdaCategory("Button")
                CdaBindablePropertyEnd()
                CdaProperty(AdornerContainerNode, AdornerContainerNodeType, GetAdornerContainerNode, SetAdornerContainerNode)
                    CdaDescription("If the container node is specified, then the adorner will be added into this node, otherwise it will be added as direct child of the scene.")
                    CdaCategory("Button")
                CdaPropertyEnd()
                CdaBindableProperty(AnimationEnabled, AnimationEnabledType, GetAnimationEnabled, SetAnimationEnabled)
                    CdaDescription("Enables the button slide animation. The animation will be started only if both this property and the parameter ButtonGroupReqMsg.Animate are true.")
                    CdaCategory("Button")
                CdaBindablePropertyEnd()
                CdaBindableProperty(AnimationDuration, AnimationDurationType, GetAnimationDuration, SetAnimationDuration)
                    CdaDescription("Duration of the button slide animation. If set to 0 the duration configured in the adorner manager will be used.")
                    CdaVisibilityTest(GetAnimationEnabled)
                    CdaCategory("Button")
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        ActiveIndexType m_ActiveIndex;
        AdornerContainerNodeType m_AdornerContainerNode;
        AnimationEnabledType m_AnimationEnabled;
        AnimationDurationType m_AnimationDuration;
};

#endif // ButtonGroupWidget2DBase_h
