/************************************************************************
*FILE: BusyIndicatorWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(BusyIndicatorWidget2DBase_h)
#define BusyIndicatorWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#include <Widgets/2D/BaseWidget2D.h>
#include <Candera/EngineBase/Animation/AnimationPlayerListener.h>
#include <Candera/Engine2D/AnimationPropertySetters/AlphaNode2DPropertySetter.h>
#include <Widgets/2D/Text/TextWidget2D.h>
#include <Candera/EngineBase/Animation/AnimationPlayer.h>
                        #define ENUM_DATA_TYPE \
                        ENUM_DATA_TYPE_BEGIN(enBusyIndicatorType)     \
                        ENUM_DATA_TYPE_ITEM(CircularBusyIndicator)        \
                        ENUM_DATA_TYPE_ITEM(IncrementallyCircularBusyIndicator)        \
                        ENUM_DATA_TYPE_ITEM(IconAndText)        \
                        ENUM_DATA_TYPE_ITEM(HorizontalBusyIndicator)        \
                        ENUM_DATA_TYPE_END(enBusyIndicatorType)
                        #include <Candera/System/MetaInfo/EnumDataType.h>

                        #define ENUM_DATA_TYPE \
                      ENUM_DATA_TYPE_BEGIN(enAnimationDirection)     \
        ENUM_DATA_TYPE_ITEM_VALUE(Forward,Candera::Animation::AnimationPlayer::Forward)        \
        ENUM_DATA_TYPE_ITEM_VALUE(Reverse,Candera::Animation::AnimationPlayer::Reverse)        \
                      ENUM_DATA_TYPE_END(enAnimationDirection)
                        #include <Candera/System/MetaInfo/EnumDataType.h>
// ------------------------------------------------------------------------
//! [BusyIndicatorWidget2DBase_Declaration]
class BusyIndicatorWidget2DBase : public ::BaseWidget2D
{
    public:
        typedef Candera::enBusyIndicatorType BusyWaitIndicatorTypeType;

        typedef bool EnableScalingType;

        typedef FeatStd::Float SpeedFactorType;

        typedef Candera::enAnimationDirection PlayDirectionType;

        typedef FeatStd::UInt32 AnimationDurationType;

        typedef FeatStd::UInt32 MinimumAnimationDurationType;

        typedef Candera::WidgetBase* TextWidgetType;

        typedef FeatStd::String TextType;

        typedef FeatStd::String WidgetNameType;

        //! [Property_IDs]
        static const FeatStd::UInt32 SpeedFactorPropertyId = 0x99C20A3A;
        static const FeatStd::UInt32 PlayDirectionPropertyId = 0x26BFEF22;
        static const FeatStd::UInt32 AnimationDurationPropertyId = 0xDC08D9B9;
        static const FeatStd::UInt32 TextPropertyId = 0xB5A7CD47;
        static const FeatStd::UInt32 WidgetNamePropertyId = 0x4FB12612;
        //! [Property_IDs]

        BusyIndicatorWidget2DBase();
        virtual ~BusyIndicatorWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(BusyIndicatorWidget2DBase, ::BaseWidget2D);

        virtual void Update();

        void SetBusyWaitIndicatorType(const BusyWaitIndicatorTypeType& busywaitindicatortype);
        const BusyWaitIndicatorTypeType& GetBusyWaitIndicatorType() const { return m_BusyWaitIndicatorType; }

        void SetEnableScaling(const EnableScalingType& enablescaling);
        const EnableScalingType& GetEnableScaling() const { return m_EnableScaling; }

        void SetSpeedFactor(const SpeedFactorType& speedfactor);
        const SpeedFactorType& GetSpeedFactor() const { return m_SpeedFactor; }

        void SetPlayDirection(const PlayDirectionType& playdirection);
        const PlayDirectionType& GetPlayDirection() const { return m_PlayDirection; }

        void SetAnimationDuration(const AnimationDurationType& animationduration);
        const AnimationDurationType& GetAnimationDuration() const { return m_AnimationDuration; }

        void SetMinimumAnimationDuration(const MinimumAnimationDurationType& minimumanimationduration);
        const MinimumAnimationDurationType& GetMinimumAnimationDuration() const { return m_MinimumAnimationDuration; }

        void SetTextWidget(const TextWidgetType textwidget);
        const TextWidgetType& GetTextWidget() const { return m_TextWidget; }

        void SetText(const TextType& text);
        const TextType& GetText() const { return m_Text; }

        void SetWidgetName(const WidgetNameType& widgetname);
        const WidgetNameType& GetWidgetName() const { return m_WidgetName; }

        // @WidgetBaseClass
        CdaWidget2DDef(BusyIndicatorWidget2DBase, ::BaseWidget2D)
            CdaDescription("DEPRECATED! Don't use this widget! Use StepAnimationWidget2D instead.")
            CdaReadableName("BusyIndicatorWidget2DBase")
            CdaCategory("Deprecated")

            CdaProperties()
                CdaProperty(BusyWaitIndicatorType, BusyWaitIndicatorTypeType, GetBusyWaitIndicatorType, SetBusyWaitIndicatorType)
                    CdaDescription("Busy Indicator Type")
                    CdaCategory("Basic")
                CdaPropertyEnd()
                CdaProperty(EnableScaling, EnableScalingType, GetEnableScaling, SetEnableScaling)
                    CdaDescription("Enable or Disable scaling property for Circular Incremental Busy Indicator")
                    CdaVisibilityTest(IsIncrementallyCircularBusyIndicator)
                    CdaCategory("Animation Property")
                CdaPropertyEnd()
                CdaProperty(SpeedFactor, SpeedFactorType, GetSpeedFactor, SetSpeedFactor)
                    CdaDescription("Speed Factor")
                    CdaCategory("Animation Property")
                CdaPropertyEnd()
                CdaProperty(PlayDirection, PlayDirectionType, GetPlayDirection, SetPlayDirection)
                    CdaDescription("Play Direction")
                    CdaCategory("Animation Property")
                CdaPropertyEnd()
                CdaProperty(AnimationDuration, AnimationDurationType, GetAnimationDuration, SetAnimationDuration)
                    CdaDescription("Duration of the animation")
                CdaPropertyEnd()
                CdaProperty(MinimumAnimationDuration, MinimumAnimationDurationType, GetMinimumAnimationDuration, SetMinimumAnimationDuration)
                    CdaDescription("Minimum Animation Duration")
                    CdaCategory("Animation Property")
                CdaPropertyEnd()
                CdaProperty(TextWidget, TextWidgetType, GetTextWidget, SetTextWidget)
                    CdaDescription("Associate the TextWidget2D")
                    CdaCategory("Animation Property")
                CdaPropertyEnd()
                CdaProperty(Text, TextType, GetText, SetText)
                    CdaDescription("Text displayed")
                CdaPropertyEnd()
                CdaProperty(WidgetName, WidgetNameType, GetWidgetName, SetWidgetName)
                    CdaDescription("Name of the widget which will be used to start and stop the animation")
                CdaPropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        bool IsIncrementallyCircularBusyIndicator() const { return (GetBusyWaitIndicatorType() == Candera::IncrementallyCircularBusyIndicator); }
        BusyWaitIndicatorTypeType m_BusyWaitIndicatorType;
        EnableScalingType m_EnableScaling;
        SpeedFactorType m_SpeedFactor;
        PlayDirectionType m_PlayDirection;
        AnimationDurationType m_AnimationDuration;
        MinimumAnimationDurationType m_MinimumAnimationDuration;
        TextWidgetType m_TextWidget;
        TextType m_Text;
        WidgetNameType m_WidgetName;

        ::FeatStd::Internal::Vector< ::FeatStd::UInt32 > m_ChangeSetBusyIndicatorWidget2DBase;
};

#endif // BusyIndicatorWidget2DBase_h
