/************************************************************************
*FILE: BlurWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(hmibase_widget_blur_BlurWidget2DBase_h)
#define hmibase_widget_blur_BlurWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/BaseWidget2D.h>
#include <Widgets/2D/Blur/BlurConfig2D.h>
#include <Widgets/utils/Blur/BlurTypes.h>
#include <Widgets/utils/Blur/WindowRect.h>
#include <Widgets/utils/Blur/IBlurShader.h>
#include <Widgets/utils/Blur/BlurUtilsCommon.h>
#include <Widgets/utils/Blur/BlurViewSceneFactory.h>
#include <Courier/DataBinding/BindableProperty.h>

namespace hmibase {
} // namespace hmibase
namespace hmibase {
namespace widget {
namespace blur {
// ------------------------------------------------------------------------
//! [BlurWidget2DBase_Declaration]
class BlurWidget2DBase : public ::BaseWidget2D
{
    public:
        bool ShowRenderTargetMaskProperties() const { return (GetBlurMaskVariant() == enBlurMaskVariant::RenderTargetBlurMask);}
        bool ShowSubsamplingFactorProperties() const { return (GetBlurMaskVariant() == enBlurMaskVariant::NoBlurMask); }
        bool ShowBitmapMaskProperties() const { return (GetBlurMaskVariant() == enBlurMaskVariant::BitmapBlurMask); }
        bool ShowDirtyAreaInvalidationProperties() const { return (GetUseManualDirtyArea() == true); }
        typedef enShaderVariant::Enum BlurShaderVariantType;

        typedef enBlurMaskVariant::Enum BlurMaskVariantType;

        typedef bool MultipassType;

        typedef bool CombineMaskType;

        typedef bool UseManualDirtyAreaType;

        typedef FeatStd::Int BlurRadiusType;

        typedef FeatStd::Float DarkenType;

        typedef bool BlurEnabledType;

        typedef FeatStd::Float BlurRadiusToSigmaType;

        typedef bool BlendOutputType;

        typedef OriginalRenderTarget2D* RenderTargetMaskType;

        typedef FeatStd::Int SubsamplingFactorType;

        typedef Candera::Node2D* RenderNodeMaskType;

        typedef FeatStd::MemoryManagement::SharedPointer<Candera::Bitmap> BitmapMaskType;

        typedef bool KeepFrameBufferContentType;

        typedef Candera::Rectangle DirtyAreaRectangleType;

        //! [Property_IDs]
        static const FeatStd::UInt32 BlurShaderVariantPropertyId = 0xCB2A8873;
        static const FeatStd::UInt32 BlurMaskVariantPropertyId = 0x5DAFA336;
        static const FeatStd::UInt32 MultipassPropertyId = 0xAD0CA6DC;
        static const FeatStd::UInt32 CombineMaskPropertyId = 0x6F659E1B;
        static const FeatStd::UInt32 UseManualDirtyAreaPropertyId = 0xFC2D8FB3;
        static const FeatStd::UInt32 BlurRadiusPropertyId = 0x7C6EB88C;
        static const FeatStd::UInt32 DarkenPropertyId = 0x4997AC83;
        static const FeatStd::UInt32 BlurEnabledPropertyId = 0xE5D2A34A;
        static const FeatStd::UInt32 BlurRadiusToSigmaPropertyId = 0x26DB50CB;
        static const FeatStd::UInt32 BlendOutputPropertyId = 0xAA7C3D40;
        static const FeatStd::UInt32 RenderTargetMaskPropertyId = 0x3D15FB3A;
        static const FeatStd::UInt32 SubsamplingFactorPropertyId = 0x24157EEE;
        static const FeatStd::UInt32 RenderNodeMaskPropertyId = 0x09DF37E7;
        static const FeatStd::UInt32 BitmapMaskPropertyId = 0xEA45B97E;
        static const FeatStd::UInt32 KeepFrameBufferContentPropertyId = 0xE4762C70;
        static const FeatStd::UInt32 DirtyAreaRectanglePropertyId = 0xA5FFBBBC;
        //! [Property_IDs]

        BlurWidget2DBase();
        virtual ~BlurWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(BlurWidget2DBase, ::BaseWidget2D);

        void SetBlurShaderVariant(const BlurShaderVariantType& blurshadervariant);
        const BlurShaderVariantType& GetBlurShaderVariant() const { return m_BlurShaderVariant; }

        //! [DataBinding_BlurMaskVariantPropertyGetterSetter]
        void SetBlurMaskVariant(const BlurMaskVariantType& blurmaskvariant);
        const BlurMaskVariantType& GetBlurMaskVariant() const { return m_BlurMaskVariant; }
        //! [DataBinding_BlurMaskVariantPropertyGetterSetter]

        void SetMultipass(const MultipassType& multipass);
        const MultipassType& GetMultipass() const { return m_Multipass; }

        void SetCombineMask(const CombineMaskType& combinemask);
        const CombineMaskType& GetCombineMask() const { return m_CombineMask; }

        void SetUseManualDirtyArea(const UseManualDirtyAreaType& usemanualdirtyarea);
        const UseManualDirtyAreaType& GetUseManualDirtyArea() const { return m_UseManualDirtyArea; }

        //! [DataBinding_BlurRadiusPropertyGetterSetter]
        void SetBlurRadius(const BlurRadiusType& blurradius);
        const BlurRadiusType& GetBlurRadius() const { return m_BlurRadius; }
        //! [DataBinding_BlurRadiusPropertyGetterSetter]

        //! [DataBinding_DarkenPropertyGetterSetter]
        void SetDarken(const DarkenType& darken);
        const DarkenType& GetDarken() const { return m_Darken; }
        //! [DataBinding_DarkenPropertyGetterSetter]

        //! [DataBinding_BlurEnabledPropertyGetterSetter]
        void SetBlurEnabled(const BlurEnabledType& blurenabled);
        const BlurEnabledType& GetBlurEnabled() const { return m_BlurEnabled; }
        //! [DataBinding_BlurEnabledPropertyGetterSetter]

        //! [DataBinding_BlurRadiusToSigmaPropertyGetterSetter]
        void SetBlurRadiusToSigma(const BlurRadiusToSigmaType& blurradiustosigma);
        const BlurRadiusToSigmaType& GetBlurRadiusToSigma() const { return m_BlurRadiusToSigma; }
        //! [DataBinding_BlurRadiusToSigmaPropertyGetterSetter]

        //! [DataBinding_BlendOutputPropertyGetterSetter]
        void SetBlendOutput(const BlendOutputType& blendoutput);
        const BlendOutputType& GetBlendOutput() const { return m_BlendOutput; }
        //! [DataBinding_BlendOutputPropertyGetterSetter]

        void SetRenderTargetMask(const RenderTargetMaskType rendertargetmask);
        const RenderTargetMaskType& GetRenderTargetMask() const { return m_RenderTargetMask; }

        void SetSubsamplingFactor(const SubsamplingFactorType& subsamplingfactor);
        const SubsamplingFactorType& GetSubsamplingFactor() const { return m_SubsamplingFactor; }

        void SetRenderNodeMask(const RenderNodeMaskType rendernodemask);
        const RenderNodeMaskType& GetRenderNodeMask() const { return m_RenderNodeMask; }

        //! [DataBinding_BitmapMaskPropertyGetterSetter]
        void SetBitmapMask(const BitmapMaskType& bitmapmask);
        const BitmapMaskType& GetBitmapMask() const { return m_BitmapMask; }
        //! [DataBinding_BitmapMaskPropertyGetterSetter]

        void SetKeepFrameBufferContent(const KeepFrameBufferContentType& keepframebuffercontent);
        const KeepFrameBufferContentType& GetKeepFrameBufferContent() const { return m_KeepFrameBufferContent; }

        void SetDirtyAreaRectangle(const DirtyAreaRectangleType& dirtyarearectangle);
        const DirtyAreaRectangleType& GetDirtyAreaRectangle() const { return m_DirtyAreaRectangle; }

        // @WidgetBaseClass
        CdaWidget2DDef(BlurWidget2DBase, ::BaseWidget2D)
            CdaDescription("BlurWidget2D widget")
            CdaReadableName("Blur Widget 2D")
            CdaCategory("Image")

            CdaProperties()
                CdaProperty(BlurShaderVariant, BlurShaderVariantType, GetBlurShaderVariant, SetBlurShaderVariant)
                    CdaDescription("Sets the selected shader for blur")
                CdaPropertyEnd()
                CdaBindableProperty(BlurMaskVariant, BlurMaskVariantType, GetBlurMaskVariant, SetBlurMaskVariant)
                    CdaDescription("Sets the selected shader for blur")
                CdaBindablePropertyEnd()
                CdaProperty(Multipass, MultipassType, GetMultipass, SetMultipass)
                    CdaDescription("Sets single pass or multi pass blur shader.")
                CdaPropertyEnd()
                CdaProperty(CombineMask, CombineMaskType, GetCombineMask, SetCombineMask)
                    CdaDescription("Sets flag to determine if the mask render target is combined with the blurred scene.")
                CdaPropertyEnd()
                CdaProperty(UseManualDirtyArea, UseManualDirtyAreaType, GetUseManualDirtyArea, SetUseManualDirtyArea)
                    CdaDescription("Sets flag that determines, if a manually defined dirty area is to be used.")
                CdaPropertyEnd()
                CdaBindableProperty(BlurRadius, BlurRadiusType, GetBlurRadius, SetBlurRadius)
                    CdaDescription("Sets the radius of the blur.")
                    CdaRange(1, 999)
                CdaBindablePropertyEnd()
                CdaBindableProperty(Darken, DarkenType, GetDarken, SetDarken)
                    CdaDescription("Sets the darkening factor for the shader")
                CdaBindablePropertyEnd()
                CdaBindableProperty(BlurEnabled, BlurEnabledType, GetBlurEnabled, SetBlurEnabled)
                    CdaDescription("Whether or not blurring is enabled.")
                CdaBindablePropertyEnd()
                CdaBindableProperty(BlurRadiusToSigma, BlurRadiusToSigmaType, GetBlurRadiusToSigma, SetBlurRadiusToSigma)
                    CdaDescription("Sets the factor to calculate sigma from the blur radius. Typical values are between 0.5 and 0.33.")
                    CdaRange(0, 1)
                CdaBindablePropertyEnd()
                CdaBindableProperty(BlendOutput, BlendOutputType, GetBlendOutput, SetBlendOutput)
                    CdaDescription("Which Rendermode the Blur Output camera will be using")
                CdaBindablePropertyEnd()
                CdaProperty(RenderTargetMask, RenderTargetMaskType, GetRenderTargetMask, SetRenderTargetMask)
                    CdaDescription("Sets the render target that is used as mask for blur.")
                    CdaVisibilityTest(ShowRenderTargetMaskProperties)
                CdaPropertyEnd()
                CdaProperty(SubsamplingFactor, SubsamplingFactorType, GetSubsamplingFactor, SetSubsamplingFactor)
                    CdaDescription("Sets the subsampling factor for the blurred render target.")
                    CdaVisibilityTest(ShowSubsamplingFactorProperties)
                    CdaRange(1, 8)
                CdaPropertyEnd()
                CdaProperty(RenderNodeMask, RenderNodeMaskType, GetRenderNodeMask, SetRenderNodeMask)
                    CdaDescription("Sets the node, that defines the position of the bitmap used as mask for blur.")
                    CdaVisibilityTest(ShowBitmapMaskProperties)
                CdaPropertyEnd()
                CdaBindableProperty(BitmapMask, BitmapMaskType, GetBitmapMask, SetBitmapMask)
                    CdaDescription("Sets the bitmap, which is used as mask for blur.")
                    CdaVisibilityTest(ShowBitmapMaskProperties)
                CdaBindablePropertyEnd()
                CdaProperty(KeepFrameBufferContent, KeepFrameBufferContentType, GetKeepFrameBufferContent, SetKeepFrameBufferContent)
                    CdaDescription("Sets flag to determine if the content outside the blur mask is taken from the input framebuffer or discarded.")
                    CdaVisibilityTest(ShowBitmapMaskProperties)
                CdaPropertyEnd()
                CdaProperty(DirtyAreaRectangle, DirtyAreaRectangleType, GetDirtyAreaRectangle, SetDirtyAreaRectangle)
                    CdaDescription("Sets the rectangle which is set as dirty area for blurring.")
                    CdaVisibilityTest(ShowDirtyAreaInvalidationProperties)
                CdaPropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        BlurShaderVariantType m_BlurShaderVariant;
        BlurMaskVariantType m_BlurMaskVariant;
        MultipassType m_Multipass;
        CombineMaskType m_CombineMask;
        UseManualDirtyAreaType m_UseManualDirtyArea;
        BlurRadiusType m_BlurRadius;
        DarkenType m_Darken;
        BlurEnabledType m_BlurEnabled;
        BlurRadiusToSigmaType m_BlurRadiusToSigma;
        BlendOutputType m_BlendOutput;
        RenderTargetMaskType m_RenderTargetMask;
        SubsamplingFactorType m_SubsamplingFactor;
        RenderNodeMaskType m_RenderNodeMask;
        BitmapMaskType m_BitmapMask;
        KeepFrameBufferContentType m_KeepFrameBufferContent;
        DirtyAreaRectangleType m_DirtyAreaRectangle;
};
} // namespace blur
} // namespace widget
} // namespace hmibase

#endif // hmibase_widget_blur_BlurWidget2DBase_h
