/************************************************************************
*FILE: AnimationControlWidget2DBase.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(hmibase_widget_animation_AnimationControlWidget2DBase_h)
#define hmibase_widget_animation_AnimationControlWidget2DBase_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Widgets/2D/BaseWidget2D.h>
#include <Widgets/2D/AnimationControl/generated/AnimationControlWidget2DTypes.h>

namespace hmibase {
} // namespace hmibase
namespace hmibase {
namespace widget {
namespace animation {
// ------------------------------------------------------------------------
//! [AnimationControlWidget2DBase_Declaration]
class AnimationControlWidget2DBase : public ::BaseWidget2D
{
    public:
      bool isInternalAnimationPlayerUsed() const { return GetAnimationPlayerSource() == enAnimationPlayerSource::Internal; }
      bool isExternalAnimationPlayerUsed() const { return GetAnimationPlayerSource() == enAnimationPlayerSource::External; }

      bool isShouldRunPropertyVisible() const { return GetStartMode() == enStartMode::Property; }
      bool isRepeatCountEnabledPropertyVisible() const { return isExternalAnimationPlayerUsed() && (GetStartMode() == enStartMode::Message); }
      bool isRepeatCountPropertyVisible() const { return (isInternalAnimationPlayerUsed() || GetRepeatCountEnabled()) && (GetStartMode() == enStartMode::Message); }

      bool isRepeatModePropertyVisible() const { return isInternalAnimationPlayerUsed() || GetRepeatModeEnabled(); }
      bool isSpeedFactorPropertyVisible() const { return isInternalAnimationPlayerUsed() || GetSpeedFactorEnabled(); }
      bool isDirectionPropertyVisible() const { return isInternalAnimationPlayerUsed() || GetDirectionEnabled(); }

      bool isAnimatedPropertySectionVisible() const { return isInternalAnimationPlayerUsed() || GetAnimatedPropertyEnabled(); }

      bool isWidgetPropertyVisible() const { return isAnimatedPropertySectionVisible() && (GetProperty() == enProperty::WidgetProperty); }
      bool isEaseParamsPropertyVisible() const { return false /*isAnimatedPropertySectionVisible() && (GetInterpolationStrategy() == enInterpolationStrategy::Ease)*/; }
        typedef enAnimationPlayerSource::Enum AnimationPlayerSourceType;

        typedef Candera::Animation::AnimationPlayerBase::SharedPointer AnimationType;

        typedef enStartMode::Enum StartModeType;

        typedef bool ShouldRunType;

        typedef bool RepeatCountEnabledType;

        typedef FeatStd::UInt32 RepeatCountType;

        typedef bool RepeatModeEnabledType;

        typedef enRepeatMode::Enum RepeatModeType;

        typedef bool SpeedFactorEnabledType;

        typedef FeatStd::Float SpeedFactorType;

        typedef bool DirectionEnabledType;

        typedef enDirection::Enum DirectionType;

        typedef bool StartTimeEnabledType;

        typedef FeatStd::Int32 StartTimeType;

        typedef bool DurationEnabledType;

        typedef FeatStd::Int32 DurationType;

        typedef bool AnimatedPropertyEnabledType;

        typedef enProperty::Enum PropertyType;

        typedef Candera::WidgetBase* WidgetType;

        typedef Candera::String WidgetPropertyType;

        typedef enChannels::Enum ChannelsType;

        typedef enInterpolationStrategy::Enum InterpolationStrategyType;

        typedef Candera::String EaseParamsType;

        typedef FeatStd::UInt16 KeyframeCountType;

        typedef Candera::ArrayProperty<FeatStd::Int32> SequenceTimesType;

        typedef bool CurrentFirstKeyframeEnabledType;

        typedef Candera::ArrayProperty<FeatStd::Float> KeyframeValuesType;

        //! [Property_IDs]
        static const FeatStd::UInt32 ShouldRunPropertyId = 0xC90F056A;
        static const FeatStd::UInt32 RepeatCountPropertyId = 0xD0569518;
        static const FeatStd::UInt32 RepeatModePropertyId = 0xB3EA67DE;
        static const FeatStd::UInt32 SpeedFactorPropertyId = 0x99C20A3A;
        static const FeatStd::UInt32 DirectionPropertyId = 0xA0567985;
        static const FeatStd::UInt32 StartTimePropertyId = 0x90BDCFAD;
        static const FeatStd::UInt32 DurationPropertyId = 0x82C3352E;
        static const FeatStd::UInt32 AnimatedPropertyEnabledPropertyId = 0x52EDAB5D;
        static const FeatStd::UInt32 PropertyPropertyId = 0x89708C16;
        static const FeatStd::UInt32 WidgetPropertyPropertyId = 0x00AECE4C;
        static const FeatStd::UInt32 ChannelsPropertyId = 0xFAFB5BA8;
        static const FeatStd::UInt32 InterpolationStrategyPropertyId = 0x0696E001;
        static const FeatStd::UInt32 EaseParamsPropertyId = 0x1D42CC84;
        static const FeatStd::UInt32 KeyframeCountPropertyId = 0xB11AABFB;
        static const FeatStd::UInt32 SequenceTimesPropertyId = 0x14A0FD55;
        static const FeatStd::UInt32 CurrentFirstKeyframeEnabledPropertyId = 0x55BFE245;
        static const FeatStd::UInt32 KeyframeValuesPropertyId = 0xF7D8753A;
        //! [Property_IDs]

        AnimationControlWidget2DBase();
        virtual ~AnimationControlWidget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(AnimationControlWidget2DBase, ::BaseWidget2D);

        void SetAnimationPlayerSource(const AnimationPlayerSourceType& animationplayersource);
        const AnimationPlayerSourceType& GetAnimationPlayerSource() const { return m_AnimationPlayerSource; }

        void SetAnimation(const AnimationType& animation);
        const AnimationType& GetAnimation() const { return m_Animation; }
        AnimationType& GetAnimation() { return m_Animation; }

        void SetStartMode(const StartModeType& startmode);
        const StartModeType& GetStartMode() const { return m_StartMode; }

        //! [DataBinding_ShouldRunPropertyGetterSetter]
        void SetShouldRun(const ShouldRunType& shouldrun);
        const ShouldRunType& GetShouldRun() const { return m_ShouldRun; }
        //! [DataBinding_ShouldRunPropertyGetterSetter]

        void SetRepeatCountEnabled(const RepeatCountEnabledType& repeatcountenabled);
        const RepeatCountEnabledType& GetRepeatCountEnabled() const { return m_RepeatCountEnabled; }

        //! [DataBinding_RepeatCountPropertyGetterSetter]
        void SetRepeatCount(const RepeatCountType& repeatcount);
        const RepeatCountType& GetRepeatCount() const { return m_RepeatCount; }
        //! [DataBinding_RepeatCountPropertyGetterSetter]

        void SetRepeatModeEnabled(const RepeatModeEnabledType& repeatmodeenabled);
        const RepeatModeEnabledType& GetRepeatModeEnabled() const { return m_RepeatModeEnabled; }

        //! [DataBinding_RepeatModePropertyGetterSetter]
        void SetRepeatMode(const RepeatModeType& repeatmode);
        const RepeatModeType& GetRepeatMode() const { return m_RepeatMode; }
        //! [DataBinding_RepeatModePropertyGetterSetter]

        void SetSpeedFactorEnabled(const SpeedFactorEnabledType& speedfactorenabled);
        const SpeedFactorEnabledType& GetSpeedFactorEnabled() const { return m_SpeedFactorEnabled; }

        //! [DataBinding_SpeedFactorPropertyGetterSetter]
        void SetSpeedFactor(const SpeedFactorType& speedfactor);
        const SpeedFactorType& GetSpeedFactor() const { return m_SpeedFactor; }
        //! [DataBinding_SpeedFactorPropertyGetterSetter]

        void SetDirectionEnabled(const DirectionEnabledType& directionenabled);
        const DirectionEnabledType& GetDirectionEnabled() const { return m_DirectionEnabled; }

        //! [DataBinding_DirectionPropertyGetterSetter]
        void SetDirection(const DirectionType& direction);
        const DirectionType& GetDirection() const { return m_Direction; }
        //! [DataBinding_DirectionPropertyGetterSetter]

        void SetStartTimeEnabled(const StartTimeEnabledType& starttimeenabled);
        const StartTimeEnabledType& GetStartTimeEnabled() const { return m_StartTimeEnabled; }

        //! [DataBinding_StartTimePropertyGetterSetter]
        void SetStartTime(const StartTimeType& starttime);
        const StartTimeType& GetStartTime() const { return m_StartTime; }
        //! [DataBinding_StartTimePropertyGetterSetter]

        void SetDurationEnabled(const DurationEnabledType& durationenabled);
        const DurationEnabledType& GetDurationEnabled() const { return m_DurationEnabled; }

        //! [DataBinding_DurationPropertyGetterSetter]
        void SetDuration(const DurationType& duration);
        const DurationType& GetDuration() const { return m_Duration; }
        //! [DataBinding_DurationPropertyGetterSetter]

        //! [DataBinding_AnimatedPropertyEnabledPropertyGetterSetter]
        void SetAnimatedPropertyEnabled(const AnimatedPropertyEnabledType& animatedpropertyenabled);
        const AnimatedPropertyEnabledType& GetAnimatedPropertyEnabled() const { return m_AnimatedPropertyEnabled; }
        //! [DataBinding_AnimatedPropertyEnabledPropertyGetterSetter]

        //! [DataBinding_PropertyPropertyGetterSetter]
        void SetProperty(const PropertyType& property);
        const PropertyType& GetProperty() const { return m_Property; }
        //! [DataBinding_PropertyPropertyGetterSetter]

        void SetWidget(const WidgetType& widget);
        const WidgetType& GetWidget() const { return m_Widget; }
        WidgetType& GetWidget() { return m_Widget; }

        //! [DataBinding_WidgetPropertyPropertyGetterSetter]
        void SetWidgetProperty(const WidgetPropertyType& widgetproperty);
        const WidgetPropertyType& GetWidgetProperty() const { return m_WidgetProperty; }
        //! [DataBinding_WidgetPropertyPropertyGetterSetter]

        //! [DataBinding_ChannelsPropertyGetterSetter]
        void SetChannels(const ChannelsType& channels);
        const ChannelsType& GetChannels() const { return m_Channels; }
        //! [DataBinding_ChannelsPropertyGetterSetter]

        //! [DataBinding_InterpolationStrategyPropertyGetterSetter]
        void SetInterpolationStrategy(const InterpolationStrategyType& interpolationstrategy);
        const InterpolationStrategyType& GetInterpolationStrategy() const { return m_InterpolationStrategy; }
        //! [DataBinding_InterpolationStrategyPropertyGetterSetter]

        //! [DataBinding_EaseParamsPropertyGetterSetter]
        void SetEaseParams(const EaseParamsType& easeparams);
        const EaseParamsType& GetEaseParams() const { return m_EaseParams; }
        //! [DataBinding_EaseParamsPropertyGetterSetter]

        //! [DataBinding_KeyframeCountPropertyGetterSetter]
        void SetKeyframeCount(const KeyframeCountType& keyframecount);
        const KeyframeCountType& GetKeyframeCount() const { return m_KeyframeCount; }
        //! [DataBinding_KeyframeCountPropertyGetterSetter]

        //! [DataBinding_SequenceTimesPropertyGetterSetter]
        void SetSequenceTimes(const SequenceTimesType& sequencetimes);
        const SequenceTimesType& GetSequenceTimes() const { return m_SequenceTimes; }
        SequenceTimesType& GetSequenceTimes() { return m_SequenceTimes; }
        //! [DataBinding_SequenceTimesPropertyGetterSetter]

        //! [DataBinding_CurrentFirstKeyframeEnabledPropertyGetterSetter]
        void SetCurrentFirstKeyframeEnabled(const CurrentFirstKeyframeEnabledType& currentfirstkeyframeenabled);
        const CurrentFirstKeyframeEnabledType& GetCurrentFirstKeyframeEnabled() const { return m_CurrentFirstKeyframeEnabled; }
        //! [DataBinding_CurrentFirstKeyframeEnabledPropertyGetterSetter]

        //! [DataBinding_KeyframeValuesPropertyGetterSetter]
        void SetKeyframeValues(const KeyframeValuesType& keyframevalues);
        const KeyframeValuesType& GetKeyframeValues() const { return m_KeyframeValues; }
        KeyframeValuesType& GetKeyframeValues() { return m_KeyframeValues; }
        //! [DataBinding_KeyframeValuesPropertyGetterSetter]

        // @WidgetBaseClass
        CdaWidget2DDef(AnimationControlWidget2DBase, ::BaseWidget2D)
            CdaDescription("Provides support to control (configure, start, stop) an animation. The animation can be defined in SceneComposer or created internally by this widget. \nAlso provides support to add an animated property to the animation.")
            CdaReadableName("AnimationControlWidget2DBase")
            CdaCategory("Animation")

            CdaProperties()
                CdaProperty(AnimationPlayerSource, AnimationPlayerSourceType, GetAnimationPlayerSource, SetAnimationPlayerSource)
                    CdaDescription("If source is internal then the animation will be created and destroyed by this widget, otherwise an animation created in SceneComposer must be used.")
                    CdaCategory("Animation")
                CdaPropertyEnd()
                CdaProperty(Animation, AnimationType, GetAnimation, SetAnimation)
                    CdaDescription("Animation created in SceneComposer which is used as external source.")
                    CdaVisibilityTest(isExternalAnimationPlayerUsed)
                    CdaCategory("Animation")
                CdaPropertyEnd()
                CdaProperty(StartMode, StartModeType, GetStartMode, SetStartMode)
                    CdaDescription("Configures how the animation is started. \nStartMode as Message is only supported for external animations and they will be started by posting Courier::AnimationReqMsg messages from the application. \nIf StartMode is Property then the animation will be started based on ShouldRun property.")
                    CdaCategory("Animation")
                CdaPropertyEnd()
                CdaBindableProperty(ShouldRun, ShouldRunType, GetShouldRun, SetShouldRun)
                    CdaDescription("The animation will run when the value of this property is true. This property is available only if the value of StartMode property is Message.")
                    CdaVisibilityTest(isShouldRunPropertyVisible)
                    CdaCategory("Animation")
                CdaBindablePropertyEnd()
                CdaProperty(RepeatCountEnabled, RepeatCountEnabledType, GetRepeatCountEnabled, SetRepeatCountEnabled)
                    CdaDescription("Enables the configuration of RepeatCount parameter for external animations.")
                    CdaVisibilityTest(isRepeatCountEnabledPropertyVisible)
                    CdaCategory("Animation")
                CdaPropertyEnd()
                CdaBindableProperty(RepeatCount, RepeatCountType, GetRepeatCount, SetRepeatCount)
                    CdaDescription("Configures how many times the animation is executed when started using Courier messages. RepeatCount has no effect if the animation is started using ShouldRun property.")
                    CdaVisibilityTest(isRepeatCountPropertyVisible)
                    CdaCategory("Animation")
                CdaBindablePropertyEnd()
                CdaProperty(RepeatModeEnabled, RepeatModeEnabledType, GetRepeatModeEnabled, SetRepeatModeEnabled)
                    CdaDescription("Enables the configuration of RepeatMode parameter for external animations.")
                    CdaVisibilityTest(isExternalAnimationPlayerUsed)
                    CdaCategory("Animation")
                CdaPropertyEnd()
                CdaBindableProperty(RepeatMode, RepeatModeType, GetRepeatMode, SetRepeatMode)
                    CdaDescription("When the animation is played multiple times, it can be played from the beginning for each iteration or it can bounce forwards and backwards.")
                    CdaVisibilityTest(isRepeatModePropertyVisible)
                    CdaCategory("Animation")
                CdaBindablePropertyEnd()
                CdaProperty(SpeedFactorEnabled, SpeedFactorEnabledType, GetSpeedFactorEnabled, SetSpeedFactorEnabled)
                    CdaDescription("Enables the configuration of SpeedFactor parameter for external animations.")
                    CdaVisibilityTest(isExternalAnimationPlayerUsed)
                    CdaCategory("Animation")
                CdaPropertyEnd()
                CdaBindableProperty(SpeedFactor, SpeedFactorType, GetSpeedFactor, SetSpeedFactor)
                    CdaDescription("Increases or decreases the animation speed.")
                    CdaVisibilityTest(isSpeedFactorPropertyVisible)
                    CdaCategory("Animation")
                CdaBindablePropertyEnd()
                CdaProperty(DirectionEnabled, DirectionEnabledType, GetDirectionEnabled, SetDirectionEnabled)
                    CdaDescription("Enables the configuration of Direction parameter for external animations.")
                    CdaVisibilityTest(isExternalAnimationPlayerUsed)
                    CdaCategory("Animation")
                CdaPropertyEnd()
                CdaBindableProperty(Direction, DirectionType, GetDirection, SetDirection)
                    CdaDescription("Specifies if the animation is played forwards or backwards.")
                    CdaVisibilityTest(isDirectionPropertyVisible)
                    CdaCategory("Animation")
                CdaBindablePropertyEnd()
                CdaProperty(StartTimeEnabled, StartTimeEnabledType, GetStartTimeEnabled, SetStartTimeEnabled)
                    CdaDescription("Enables the configuration of StartTime parameter for external animations.")
                    CdaCategory("Animation")
                CdaPropertyEnd()
                CdaBindableProperty(StartTime, StartTimeType, GetStartTime, SetStartTime)
                    CdaDescription("The point in sequence time where the animation playback shall start.")
                    CdaVisibilityTest(GetStartTimeEnabled)
                    CdaCategory("Animation")
                CdaBindablePropertyEnd()
                CdaProperty(DurationEnabled, DurationEnabledType, GetDurationEnabled, SetDurationEnabled)
                    CdaDescription("Enables the configuration of Duration parameter for external animations.")
                    CdaCategory("Animation")
                CdaPropertyEnd()
                CdaBindableProperty(Duration, DurationType, GetDuration, SetDuration)
                    CdaDescription("When that duration has elapsed, playback will stop or act according to the repeat settings.")
                    CdaVisibilityTest(GetDurationEnabled)
                    CdaCategory("Animation")
                CdaBindablePropertyEnd()
                CdaBindableProperty(AnimatedPropertyEnabled, AnimatedPropertyEnabledType, GetAnimatedPropertyEnabled, SetAnimatedPropertyEnabled)
                    CdaDescription("Adds an animated property for the associated node to the animation.")
                    CdaVisibilityTest(isExternalAnimationPlayerUsed)
                    CdaCategory("AnimatedProperty")
                CdaBindablePropertyEnd()
                CdaBindableProperty(Property, PropertyType, GetProperty, SetProperty)
                    CdaDescription("Node property to be animated. Also allows to specify that a widget property should be animated. \nOnly properties of the following types can be animated: bool, int, float, Vector2, Vector3, Rectangle, Color and Margin.")
                    CdaVisibilityTest(isAnimatedPropertySectionVisible)
                    CdaCategory("AnimatedProperty")
                CdaBindablePropertyEnd()
                CdaProperty(Widget, WidgetType, GetWidget, SetWidget)
                    CdaDescription("Widget to be animated.")
                    CdaVisibilityTest(isWidgetPropertyVisible)
                    CdaCategory("AnimatedProperty")
                CdaPropertyEnd()
                CdaBindableProperty(WidgetProperty, WidgetPropertyType, GetWidgetProperty, SetWidgetProperty)
                    CdaDescription("Widget property to be animated. \nOnly properties of the following types can be animated: bool, int, float, Vector2, Vector3, Rectangle, Color and Margin.")
                    CdaVisibilityTest(isWidgetPropertyVisible)
                    CdaCategory("AnimatedProperty")
                CdaBindablePropertyEnd()
                CdaBindableProperty(Channels, ChannelsType, GetChannels, SetChannels)
                    CdaDescription("Configures the animation channels based on the animated property type. By default all the members of the property type will be animated but this allows to animate only the member X or Y from a Vector2. Or just the member Top from a Margin. \nCh_0 - X, Red, Left;\nCh_1 - Y, Green, Top;\nCh_2 - Z, Blue, Width, Right;\nCh_3 - W, Alpha, Height, Bottom;")
                    CdaVisibilityTest(isAnimatedPropertySectionVisible)
                    CdaCategory("AnimatedProperty")
                CdaBindablePropertyEnd()
                CdaBindableProperty(InterpolationStrategy, InterpolationStrategyType, GetInterpolationStrategy, SetInterpolationStrategy)
                    CdaDescription("Interpolation function which calculates the values between keyframes.")
                    CdaVisibilityTest(isAnimatedPropertySectionVisible)
                    CdaCategory("AnimatedProperty")
                CdaBindablePropertyEnd()
                CdaBindableProperty(EaseParams, EaseParamsType, GetEaseParams, SetEaseParams)
                    CdaDescription("Not supported yet! Additional parameters required for ease interpolation strategy.")
                    CdaVisibilityTest(isEaseParamsPropertyVisible)
                    CdaCategory("AnimatedProperty")
                CdaBindablePropertyEnd()
                CdaBindableProperty(KeyframeCount, KeyframeCountType, GetKeyframeCount, SetKeyframeCount)
                    CdaDescription("Number of keyframes (it needs to be at least 2).")
                    CdaVisibilityTest(isAnimatedPropertySectionVisible)
                    CdaCategory("AnimatedProperty")
                CdaBindablePropertyEnd()
                CdaBindableProperty(SequenceTimes, SequenceTimesType, GetSequenceTimes, SetSequenceTimes)
                    CdaDescription("Sequence time of the keyframes.")
                    CdaVisibilityTest(isAnimatedPropertySectionVisible)
                    CdaCategory("AnimatedProperty")
                CdaBindablePropertyEnd()
                CdaBindableProperty(CurrentFirstKeyframeEnabled, CurrentFirstKeyframeEnabledType, GetCurrentFirstKeyframeEnabled, SetCurrentFirstKeyframeEnabled)
                    CdaDescription("When enabled, the value(s) of the first keyframe are taken from the node when the animation is started.")
                    CdaVisibilityTest(isAnimatedPropertySectionVisible)
                    CdaCategory("AnimatedProperty")
                CdaBindablePropertyEnd()
                CdaBindableProperty(KeyframeValues, KeyframeValuesType, GetKeyframeValues, SetKeyframeValues)
                    CdaDescription("Values of the keyframes. Depending on the type and the channel configuration of the animated property the number of values for each keyframe is between 1 and 4. \n1 value is required for simple types (bool, int, float);  \n2 values are required for Vector2;  \n3 values are required for Vector3;  \n4 values are required for Color, Rectangle and Margin; \nFor example if it is required to animate a property of type Vector2 then 2 values will be required for each keyframe (values at positions 0 and 1 are for the first keyframe and so on).")
                    CdaVisibilityTest(isAnimatedPropertySectionVisible)
                    CdaCategory("AnimatedProperty")
                CdaBindablePropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        AnimationPlayerSourceType m_AnimationPlayerSource;
        AnimationType m_Animation;
        StartModeType m_StartMode;
        ShouldRunType m_ShouldRun;
        RepeatCountEnabledType m_RepeatCountEnabled;
        RepeatCountType m_RepeatCount;
        RepeatModeEnabledType m_RepeatModeEnabled;
        RepeatModeType m_RepeatMode;
        SpeedFactorEnabledType m_SpeedFactorEnabled;
        SpeedFactorType m_SpeedFactor;
        DirectionEnabledType m_DirectionEnabled;
        DirectionType m_Direction;
        StartTimeEnabledType m_StartTimeEnabled;
        StartTimeType m_StartTime;
        DurationEnabledType m_DurationEnabled;
        DurationType m_Duration;
        AnimatedPropertyEnabledType m_AnimatedPropertyEnabled;
        PropertyType m_Property;
        WidgetType m_Widget;
        WidgetPropertyType m_WidgetProperty;
        ChannelsType m_Channels;
        InterpolationStrategyType m_InterpolationStrategy;
        EaseParamsType m_EaseParams;
        KeyframeCountType m_KeyframeCount;
        SequenceTimesType m_SequenceTimes;
        CurrentFirstKeyframeEnabledType m_CurrentFirstKeyframeEnabled;
        KeyframeValuesType m_KeyframeValues;
};
} // namespace animation
} // namespace widget
} // namespace hmibase

#endif // hmibase_widget_animation_AnimationControlWidget2DBase_h
