/************************************************************************
*FILE: AnimationControlWidget2DBase.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ***************************************************************************************
 * FILE:          Generated intermediate file from HMIContract.exe
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  This file is part of HMI-Base Widget Library 
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "widget2D_std_if.h"

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "AnimationControlWidget2DBase.h"

namespace hmibase {
} // namespace hmibase

namespace hmibase {
namespace widget {
namespace animation {
// ------------------------------------------------------------------------
CGI_WIDGET_RTTI_DEFINITION(AnimationControlWidget2DBase)

AnimationControlWidget2DBase::AnimationControlWidget2DBase() :
    m_AnimationPlayerSource(AnimationPlayerSourceType()),
    m_Animation(AnimationType()),
    m_StartMode(StartModeType()),
    m_ShouldRun(ShouldRunType()),
    m_RepeatCountEnabled(RepeatCountEnabledType()),
    m_RepeatCount(RepeatCountType()),
    m_RepeatModeEnabled(RepeatModeEnabledType()),
    m_RepeatMode(RepeatModeType()),
    m_SpeedFactorEnabled(SpeedFactorEnabledType()),
    m_SpeedFactor(1.0f),
    m_DirectionEnabled(DirectionEnabledType()),
    m_Direction(DirectionType()),
    m_StartTimeEnabled(StartTimeEnabledType()),
    m_StartTime(StartTimeType()),
    m_DurationEnabled(DurationEnabledType()),
    m_Duration(DurationType()),
    m_AnimatedPropertyEnabled(AnimatedPropertyEnabledType()),
    m_Property(PropertyType()),
    m_Widget(WidgetType()),
    m_WidgetProperty(WidgetPropertyType()),
    m_Channels(ChannelsType()),
    m_InterpolationStrategy(InterpolationStrategyType()),
    m_EaseParams(EaseParamsType()),
    m_KeyframeCount(2),
    m_SequenceTimes(SequenceTimesType()),
    m_CurrentFirstKeyframeEnabled(CurrentFirstKeyframeEnabledType()),
    m_KeyframeValues(KeyframeValuesType())
{
}

AnimationControlWidget2DBase::~AnimationControlWidget2DBase()
{
}

void AnimationControlWidget2DBase::SetAnimationPlayerSource(const AnimationPlayerSourceType& animationplayersource)
{
    m_AnimationPlayerSource = animationplayersource;
}

void AnimationControlWidget2DBase::SetAnimation(const AnimationType& animation)
{
    m_Animation = animation;
}

void AnimationControlWidget2DBase::SetStartMode(const StartModeType& startmode)
{
    m_StartMode = startmode;
}

void AnimationControlWidget2DBase::SetShouldRun(const ShouldRunType& shouldrun)
{
    if (m_ShouldRun != shouldrun) {
        m_ShouldRun = shouldrun;
        OnChanged(static_cast< ::FeatStd::UInt32>(ShouldRunPropertyId));
    }
}

void AnimationControlWidget2DBase::SetRepeatCountEnabled(const RepeatCountEnabledType& repeatcountenabled)
{
    m_RepeatCountEnabled = repeatcountenabled;
}

void AnimationControlWidget2DBase::SetRepeatCount(const RepeatCountType& repeatcount)
{
    if (m_RepeatCount != repeatcount) {
        m_RepeatCount = repeatcount;
        OnChanged(static_cast< ::FeatStd::UInt32>(RepeatCountPropertyId));
    }
}

void AnimationControlWidget2DBase::SetRepeatModeEnabled(const RepeatModeEnabledType& repeatmodeenabled)
{
    m_RepeatModeEnabled = repeatmodeenabled;
}

void AnimationControlWidget2DBase::SetRepeatMode(const RepeatModeType& repeatmode)
{
    if (m_RepeatMode != repeatmode) {
        m_RepeatMode = repeatmode;
        OnChanged(static_cast< ::FeatStd::UInt32>(RepeatModePropertyId));
    }
}

void AnimationControlWidget2DBase::SetSpeedFactorEnabled(const SpeedFactorEnabledType& speedfactorenabled)
{
    m_SpeedFactorEnabled = speedfactorenabled;
}

void AnimationControlWidget2DBase::SetSpeedFactor(const SpeedFactorType& speedfactor)
{
    if (m_SpeedFactor != speedfactor) {
        m_SpeedFactor = speedfactor;
        OnChanged(static_cast< ::FeatStd::UInt32>(SpeedFactorPropertyId));
    }
}

void AnimationControlWidget2DBase::SetDirectionEnabled(const DirectionEnabledType& directionenabled)
{
    m_DirectionEnabled = directionenabled;
}

void AnimationControlWidget2DBase::SetDirection(const DirectionType& direction)
{
    if (m_Direction != direction) {
        m_Direction = direction;
        OnChanged(static_cast< ::FeatStd::UInt32>(DirectionPropertyId));
    }
}

void AnimationControlWidget2DBase::SetStartTimeEnabled(const StartTimeEnabledType& starttimeenabled)
{
    m_StartTimeEnabled = starttimeenabled;
}

void AnimationControlWidget2DBase::SetStartTime(const StartTimeType& starttime)
{
    if (m_StartTime != starttime) {
        m_StartTime = starttime;
        OnChanged(static_cast< ::FeatStd::UInt32>(StartTimePropertyId));
    }
}

void AnimationControlWidget2DBase::SetDurationEnabled(const DurationEnabledType& durationenabled)
{
    m_DurationEnabled = durationenabled;
}

void AnimationControlWidget2DBase::SetDuration(const DurationType& duration)
{
    if (m_Duration != duration) {
        m_Duration = duration;
        OnChanged(static_cast< ::FeatStd::UInt32>(DurationPropertyId));
    }
}

void AnimationControlWidget2DBase::SetAnimatedPropertyEnabled(const AnimatedPropertyEnabledType& animatedpropertyenabled)
{
    if (m_AnimatedPropertyEnabled != animatedpropertyenabled) {
        m_AnimatedPropertyEnabled = animatedpropertyenabled;
        OnChanged(static_cast< ::FeatStd::UInt32>(AnimatedPropertyEnabledPropertyId));
    }
}

void AnimationControlWidget2DBase::SetProperty(const PropertyType& property)
{
    if (m_Property != property) {
        m_Property = property;
        OnChanged(static_cast< ::FeatStd::UInt32>(PropertyPropertyId));
    }
}

void AnimationControlWidget2DBase::SetWidget(const WidgetType& widget)
{
    m_Widget = widget;
}

void AnimationControlWidget2DBase::SetWidgetProperty(const WidgetPropertyType& widgetproperty)
{
    if (m_WidgetProperty != widgetproperty) {
        m_WidgetProperty = widgetproperty;
        OnChanged(static_cast< ::FeatStd::UInt32>(WidgetPropertyPropertyId));
    }
}

void AnimationControlWidget2DBase::SetChannels(const ChannelsType& channels)
{
    if (m_Channels != channels) {
        m_Channels = channels;
        OnChanged(static_cast< ::FeatStd::UInt32>(ChannelsPropertyId));
    }
}

void AnimationControlWidget2DBase::SetInterpolationStrategy(const InterpolationStrategyType& interpolationstrategy)
{
    if (m_InterpolationStrategy != interpolationstrategy) {
        m_InterpolationStrategy = interpolationstrategy;
        OnChanged(static_cast< ::FeatStd::UInt32>(InterpolationStrategyPropertyId));
    }
}

void AnimationControlWidget2DBase::SetEaseParams(const EaseParamsType& easeparams)
{
    if (m_EaseParams != easeparams) {
        m_EaseParams = easeparams;
        OnChanged(static_cast< ::FeatStd::UInt32>(EaseParamsPropertyId));
    }
}

void AnimationControlWidget2DBase::SetKeyframeCount(const KeyframeCountType& keyframecount)
{
    if (m_KeyframeCount != keyframecount) {
        m_KeyframeCount = keyframecount;
        OnChanged(static_cast< ::FeatStd::UInt32>(KeyframeCountPropertyId));
    }
}

void AnimationControlWidget2DBase::SetSequenceTimes(const SequenceTimesType& sequencetimes)
{
    m_SequenceTimes = sequencetimes;
    OnChanged(static_cast< ::FeatStd::UInt32>(SequenceTimesPropertyId));
}

void AnimationControlWidget2DBase::SetCurrentFirstKeyframeEnabled(const CurrentFirstKeyframeEnabledType& currentfirstkeyframeenabled)
{
    if (m_CurrentFirstKeyframeEnabled != currentfirstkeyframeenabled) {
        m_CurrentFirstKeyframeEnabled = currentfirstkeyframeenabled;
        OnChanged(static_cast< ::FeatStd::UInt32>(CurrentFirstKeyframeEnabledPropertyId));
    }
}

void AnimationControlWidget2DBase::SetKeyframeValues(const KeyframeValuesType& keyframevalues)
{
    m_KeyframeValues = keyframevalues;
    OnChanged(static_cast< ::FeatStd::UInt32>(KeyframeValuesPropertyId));
}
} // namespace animation
} // namespace widget
} // namespace hmibase
