/************************************************************************
*FILE: HandWriting_Util_Widget2D_Base.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(HandWriting_Util_Widget2D_Base_h)
#define HandWriting_Util_Widget2D_Base_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Candera/System/Rtti/Rtti.h>
#include <Widgets/2D/Touchable2D.h>
#include <CanderaWidget/String/String.h>
#include <CanderaWidget/WidgetBase/StringDataTypes.h>

                        #define ENUM_DATA_TYPE \
	        	        ENUM_DATA_TYPE_BEGIN(enLanguage)     \
	                    ENUM_DATA_TYPE_ITEM(CHINESE)        \
	                    ENUM_DATA_TYPE_ITEM(ENGLISH)        \
	                    ENUM_DATA_TYPE_END(enLanguage)
            #include <Candera/System/MetaInfo/EnumDataType.h>

                        #define ENUM_DATA_TYPE \
	                    ENUM_DATA_TYPE_BEGIN(enPriorityMode)     \
        ENUM_DATA_TYPE_ITEM(NUMBERFIRST_MODE)        \
        ENUM_DATA_TYPE_ITEM(LETTERFIRST_MODE)        \
        ENUM_DATA_TYPE_ITEM(LETTER_NUM__MODE)        \
        ENUM_DATA_TYPE_ITEM(FREE_TEXT_MODE)        \
	                    ENUM_DATA_TYPE_END(enPriorityMode)
                        #include <Candera/System/MetaInfo/EnumDataType.h>

  #define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(enIntelligentPredictionMode)     \
      ENUM_DATA_TYPE_ITEM(NOINTELLIGENTPREDICTION_MODE)        \
      ENUM_DATA_TYPE_ITEM(CHARACTERINTELLIGENTPREDICTION_MODE)        \
      ENUM_DATA_TYPE_ITEM(WORDINTELLIGENTPREDICTION_MODE)        \
    ENUM_DATA_TYPE_END(enIntelligentPredictionMode)
  #include <Candera/System/MetaInfo/EnumDataType.h>
  #define ENUM_DATA_TYPE                                         \
    ENUM_DATA_TYPE_BEGIN(ACCESS_MODE)                           \
        ENUM_DATA_TYPE_ITEM_VALUE(READ,  0)   \
        ENUM_DATA_TYPE_ITEM_VALUE(WRITE, 1)   \
    ENUM_DATA_TYPE_END(ACCESS_MODE)
#include <Candera/System/MetaInfo/EnumDataType.h>  
// ------------------------------------------------------------------------
//! [HandWriting_Util_Widget2DBase_Declaration]
class HandWriting_Util_Widget2DBase : public Touchable2D
{
    public:
        typedef Candera::enLanguage LanguageType;

        typedef Candera::WidgetBase* AddLineListWidgetType;

        typedef Candera::enPriorityMode PriorityModeType;

        typedef Candera::enIntelligentPredictionMode IntelligentPredictionModeType;

        typedef Candera::UInt32 CharacterCompletionTimeType;

        typedef Candera::Color LineColorType;

        typedef Candera::Float LineWidthType;

        typedef bool IncludeSymbolsType;

        typedef bool IncludeNumbersType;

        typedef bool IncludeLatinLowerCaseLettersType;

        typedef bool IncludeLatinUpperCaseLettersType;

        typedef bool IncludeGestureRecognitionType;

        //! [Property_IDs]
        static const FeatStd::UInt32 LanguagePropertyId = 0xD7481873;
        static const FeatStd::UInt32 AddLineListWidgetPropertyId = 0x7743F4D2;
        static const FeatStd::UInt32 PriorityModePropertyId = 0xAB94C420;
        static const FeatStd::UInt32 IntelligentPredictionModePropertyId = 0xFA3B3539;
        static const FeatStd::UInt32 CharacterCompletionTimePropertyId = 0x7039F9BF;
        static const FeatStd::UInt32 LineColorPropertyId = 0xD5BC83CD;
        static const FeatStd::UInt32 LineWidthPropertyId = 0x90159631;
        static const FeatStd::UInt32 IncludeSymbolsPropertyId = 0xF7792104;
        static const FeatStd::UInt32 IncludeNumbersPropertyId = 0x11A132AF;
        static const FeatStd::UInt32 IncludeLatinLowerCaseLettersPropertyId = 0xEC9018CA;
        static const FeatStd::UInt32 IncludeLatinUpperCaseLettersPropertyId = 0x4EAB6D5F;
        static const FeatStd::UInt32 IncludeGestureRecognitionPropertyId = 0x4455E98F;
        //! [Property_IDs]

        HandWriting_Util_Widget2DBase();
        virtual ~HandWriting_Util_Widget2DBase();

        CGI_WIDGET_RTTI_DECLARATION(HandWriting_Util_Widget2DBase, Touchable2D);

        virtual void Update();

        void SetLanguage(const LanguageType& language);
        const LanguageType& GetLanguage() const { return m_Language; }

        void SetAddLineListWidget(const AddLineListWidgetType addlinelistwidget);
        const AddLineListWidgetType& GetAddLineListWidget() const { return m_AddLineListWidget; }

        void SetPriorityMode(const PriorityModeType& prioritymode);
        const PriorityModeType& GetPriorityMode() const { return m_PriorityMode; }

        void SetIntelligentPredictionMode(const IntelligentPredictionModeType& intelligentpredictionmode);
        const IntelligentPredictionModeType& GetIntelligentPredictionMode() const { return m_IntelligentPredictionMode; }

        void SetCharacterCompletionTime(const CharacterCompletionTimeType& charactercompletiontime);
        const CharacterCompletionTimeType& GetCharacterCompletionTime() const { return m_CharacterCompletionTime; }

        void SetLineColor(const LineColorType& linecolor);
        const LineColorType& GetLineColor() const { return m_LineColor; }

        void SetLineWidth(const LineWidthType& linewidth);
        const LineWidthType& GetLineWidth() const { return m_LineWidth; }

        void SetIncludeSymbols(const IncludeSymbolsType& includesymbols);
        const IncludeSymbolsType& GetIncludeSymbols() const { return m_IncludeSymbols; }

        void SetIncludeNumbers(const IncludeNumbersType& includenumbers);
        const IncludeNumbersType& GetIncludeNumbers() const { return m_IncludeNumbers; }

        void SetIncludeLatinLowerCaseLetters(const IncludeLatinLowerCaseLettersType& includelatinlowercaseletters);
        const IncludeLatinLowerCaseLettersType& GetIncludeLatinLowerCaseLetters() const { return m_IncludeLatinLowerCaseLetters; }

        void SetIncludeLatinUpperCaseLetters(const IncludeLatinUpperCaseLettersType& includelatinuppercaseletters);
        const IncludeLatinUpperCaseLettersType& GetIncludeLatinUpperCaseLetters() const { return m_IncludeLatinUpperCaseLetters; }

        void SetIncludeGestureRecognition(const IncludeGestureRecognitionType& includegesturerecognition);
        const IncludeGestureRecognitionType& GetIncludeGestureRecognition() const { return m_IncludeGestureRecognition; }

        // @WidgetBaseClass
        CdaWidget2DDef(HandWriting_Util_Widget2DBase, Touchable2D)
            CdaDescription("HandWriting Recognition widget base class")
            CdaReadableName("HandWriting_Util_Widget2D_Base")
            CdaCategory("Input")

            CdaProperties()
                CdaProperty(Language, LanguageType, GetLanguage, SetLanguage)
                    CdaDescription(" ")
                CdaPropertyEnd()
                CdaProperty(AddLineListWidget, AddLineListWidgetType, GetAddLineListWidget, SetAddLineListWidget)
                    CdaDescription("Input the LineList3D widget")
                CdaPropertyEnd()
                CdaProperty(PriorityMode, PriorityModeType, GetPriorityMode, SetPriorityMode)
                    CdaDescription("Set the Priority mode for recognizing the characters")
                CdaPropertyEnd()
                CdaProperty(IntelligentPredictionMode, IntelligentPredictionModeType, GetIntelligentPredictionMode, SetIntelligentPredictionMode)
                    CdaDescription("Set the IntelligentPrediction mode for recognizing the characters and words")
                CdaPropertyEnd()
                CdaProperty(CharacterCompletionTime, CharacterCompletionTimeType, GetCharacterCompletionTime, SetCharacterCompletionTime)
                    CdaDescription("CharacterCompletionTime : Candera::UInt32")
                CdaPropertyEnd()
                CdaProperty(LineColor, LineColorType, GetLineColor, SetLineColor)
                    CdaDescription("LineColor : Candera::Color")
                CdaPropertyEnd()
                CdaProperty(LineWidth, LineWidthType, GetLineWidth, SetLineWidth)
                    CdaDescription("LineWidth : Candera::Float")
                CdaPropertyEnd()
                CdaProperty(IncludeSymbols, IncludeSymbolsType, GetIncludeSymbols, SetIncludeSymbols)
                    CdaDescription("Recognize symbols also")
                CdaPropertyEnd()
                CdaProperty(IncludeNumbers, IncludeNumbersType, GetIncludeNumbers, SetIncludeNumbers)
                    CdaDescription("Recognize Numbers also")
                CdaPropertyEnd()
                CdaProperty(IncludeLatinLowerCaseLetters, IncludeLatinLowerCaseLettersType, GetIncludeLatinLowerCaseLetters, SetIncludeLatinLowerCaseLetters)
                    CdaDescription("Recognize Latin LowerCase Letters ")
                CdaPropertyEnd()
                CdaProperty(IncludeLatinUpperCaseLetters, IncludeLatinUpperCaseLettersType, GetIncludeLatinUpperCaseLetters, SetIncludeLatinUpperCaseLetters)
                    CdaDescription("Recognize Latin UpperCase Letters")
                CdaPropertyEnd()
                CdaProperty(IncludeGestureRecognition, IncludeGestureRecognitionType, GetIncludeGestureRecognition, SetIncludeGestureRecognition)
                    CdaDescription("Include Range to recognize gestures")
                CdaPropertyEnd()
            CdaPropertiesEnd()
        CdaWidgetDefEnd()

    protected:

    private:
        LanguageType m_Language;
        AddLineListWidgetType m_AddLineListWidget;
        PriorityModeType m_PriorityMode;
        IntelligentPredictionModeType m_IntelligentPredictionMode;
        CharacterCompletionTimeType m_CharacterCompletionTime;
        LineColorType m_LineColor;
        LineWidthType m_LineWidth;
        IncludeSymbolsType m_IncludeSymbols;
        IncludeNumbersType m_IncludeNumbers;
        IncludeLatinLowerCaseLettersType m_IncludeLatinLowerCaseLetters;
        IncludeLatinUpperCaseLettersType m_IncludeLatinUpperCaseLetters;
        IncludeGestureRecognitionType m_IncludeGestureRecognition;

        ::FeatStd::Internal::Vector< ::FeatStd::UInt32 > m_ChangeSetHandWriting_Util_Widget2DBase;
};

#endif // HandWriting_Util_Widget2D_Base_h
