/************************************************************************
*FILE: HandWriting_Util_Widget2D_Base.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ***************************************************************************************
 * FILE:          Generated intermediate file from HMIContract.exe
 * SW-COMPONENT:  HMI-BASE
 *  DESCRIPTION:  This file is part of HMI-Base Widget Library 
 *    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "widget2D_std_if.h"

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "HandWriting_Util_Widget2D_Base.h"

// ------------------------------------------------------------------------
CGI_WIDGET_RTTI_DEFINITION(HandWriting_Util_Widget2DBase)

HandWriting_Util_Widget2DBase::HandWriting_Util_Widget2DBase() :
    m_Language(LanguageType()),
    m_AddLineListWidget(AddLineListWidgetType()),
    m_PriorityMode(PriorityModeType()),
    m_IntelligentPredictionMode(IntelligentPredictionModeType()),
    m_CharacterCompletionTime(CharacterCompletionTimeType()),
    m_LineColor(LineColorType()),
    m_LineWidth(LineWidthType()),
    m_IncludeSymbols(IncludeSymbolsType()),
    m_IncludeNumbers(IncludeNumbersType()),
    m_IncludeLatinLowerCaseLetters(IncludeLatinLowerCaseLettersType()),
    m_IncludeLatinUpperCaseLetters(IncludeLatinUpperCaseLettersType()),
    m_IncludeGestureRecognition(IncludeGestureRecognitionType()),
    m_ChangeSetHandWriting_Util_Widget2DBase()
{
    if (!m_ChangeSetHandWriting_Util_Widget2DBase.Reserve(1)) {
        FEATSTD_DEBUG_FAIL();
    }
}

HandWriting_Util_Widget2DBase::~HandWriting_Util_Widget2DBase()
{
    m_AddLineListWidget = 0;
}

void HandWriting_Util_Widget2DBase::Update()
{
    Base::Update();
    while (!m_ChangeSetHandWriting_Util_Widget2DBase.Empty()) {
        ::FeatStd::UInt32 propertyId = m_ChangeSetHandWriting_Util_Widget2DBase[0];
        bool ok = m_ChangeSetHandWriting_Util_Widget2DBase.Remove(0);
        FEATSTD_DEBUG_ASSERT(ok);
        OnChanged(propertyId);
        FEATSTD_UNUSED(ok);
    }
}

void HandWriting_Util_Widget2DBase::SetLanguage(const LanguageType& language)
{
    m_Language = language;
    if (!m_ChangeSetHandWriting_Util_Widget2DBase.Contains(static_cast< ::FeatStd::UInt32>(LanguagePropertyId))) {
        if (!m_ChangeSetHandWriting_Util_Widget2DBase.Add(static_cast< ::FeatStd::UInt32>(LanguagePropertyId))) {
            FEATSTD_DEBUG_FAIL();
        }
    }
}

void HandWriting_Util_Widget2DBase::SetAddLineListWidget(const AddLineListWidgetType addlinelistwidget)
{
    m_AddLineListWidget = addlinelistwidget;
    if (!m_ChangeSetHandWriting_Util_Widget2DBase.Contains(static_cast< ::FeatStd::UInt32>(AddLineListWidgetPropertyId))) {
        if (!m_ChangeSetHandWriting_Util_Widget2DBase.Add(static_cast< ::FeatStd::UInt32>(AddLineListWidgetPropertyId))) {
            FEATSTD_DEBUG_FAIL();
        }
    }
}

void HandWriting_Util_Widget2DBase::SetPriorityMode(const PriorityModeType& prioritymode)
{
    m_PriorityMode = prioritymode;
    if (!m_ChangeSetHandWriting_Util_Widget2DBase.Contains(static_cast< ::FeatStd::UInt32>(PriorityModePropertyId))) {
        if (!m_ChangeSetHandWriting_Util_Widget2DBase.Add(static_cast< ::FeatStd::UInt32>(PriorityModePropertyId))) {
            FEATSTD_DEBUG_FAIL();
        }
    }
}

void HandWriting_Util_Widget2DBase::SetIntelligentPredictionMode(const IntelligentPredictionModeType& intelligentpredictionmode)
{
    m_IntelligentPredictionMode = intelligentpredictionmode;
    if (!m_ChangeSetHandWriting_Util_Widget2DBase.Contains(static_cast< ::FeatStd::UInt32>(IntelligentPredictionModePropertyId))) {
        if (!m_ChangeSetHandWriting_Util_Widget2DBase.Add(static_cast< ::FeatStd::UInt32>(IntelligentPredictionModePropertyId))) {
            FEATSTD_DEBUG_FAIL();
        }
    }
}

void HandWriting_Util_Widget2DBase::SetCharacterCompletionTime(const CharacterCompletionTimeType& charactercompletiontime)
{
    m_CharacterCompletionTime = charactercompletiontime;
    if (!m_ChangeSetHandWriting_Util_Widget2DBase.Contains(static_cast< ::FeatStd::UInt32>(CharacterCompletionTimePropertyId))) {
        if (!m_ChangeSetHandWriting_Util_Widget2DBase.Add(static_cast< ::FeatStd::UInt32>(CharacterCompletionTimePropertyId))) {
            FEATSTD_DEBUG_FAIL();
        }
    }
}

void HandWriting_Util_Widget2DBase::SetLineColor(const LineColorType& linecolor)
{
    m_LineColor = linecolor;
    if (!m_ChangeSetHandWriting_Util_Widget2DBase.Contains(static_cast< ::FeatStd::UInt32>(LineColorPropertyId))) {
        if (!m_ChangeSetHandWriting_Util_Widget2DBase.Add(static_cast< ::FeatStd::UInt32>(LineColorPropertyId))) {
            FEATSTD_DEBUG_FAIL();
        }
    }
}

void HandWriting_Util_Widget2DBase::SetLineWidth(const LineWidthType& linewidth)
{
    m_LineWidth = linewidth;
    if (!m_ChangeSetHandWriting_Util_Widget2DBase.Contains(static_cast< ::FeatStd::UInt32>(LineWidthPropertyId))) {
        if (!m_ChangeSetHandWriting_Util_Widget2DBase.Add(static_cast< ::FeatStd::UInt32>(LineWidthPropertyId))) {
            FEATSTD_DEBUG_FAIL();
        }
    }
}

void HandWriting_Util_Widget2DBase::SetIncludeSymbols(const IncludeSymbolsType& includesymbols)
{
    m_IncludeSymbols = includesymbols;
    if (!m_ChangeSetHandWriting_Util_Widget2DBase.Contains(static_cast< ::FeatStd::UInt32>(IncludeSymbolsPropertyId))) {
        if (!m_ChangeSetHandWriting_Util_Widget2DBase.Add(static_cast< ::FeatStd::UInt32>(IncludeSymbolsPropertyId))) {
            FEATSTD_DEBUG_FAIL();
        }
    }
}

void HandWriting_Util_Widget2DBase::SetIncludeNumbers(const IncludeNumbersType& includenumbers)
{
    m_IncludeNumbers = includenumbers;
    if (!m_ChangeSetHandWriting_Util_Widget2DBase.Contains(static_cast< ::FeatStd::UInt32>(IncludeNumbersPropertyId))) {
        if (!m_ChangeSetHandWriting_Util_Widget2DBase.Add(static_cast< ::FeatStd::UInt32>(IncludeNumbersPropertyId))) {
            FEATSTD_DEBUG_FAIL();
        }
    }
}

void HandWriting_Util_Widget2DBase::SetIncludeLatinLowerCaseLetters(const IncludeLatinLowerCaseLettersType& includelatinlowercaseletters)
{
    m_IncludeLatinLowerCaseLetters = includelatinlowercaseletters;
    if (!m_ChangeSetHandWriting_Util_Widget2DBase.Contains(static_cast< ::FeatStd::UInt32>(IncludeLatinLowerCaseLettersPropertyId))) {
        if (!m_ChangeSetHandWriting_Util_Widget2DBase.Add(static_cast< ::FeatStd::UInt32>(IncludeLatinLowerCaseLettersPropertyId))) {
            FEATSTD_DEBUG_FAIL();
        }
    }
}

void HandWriting_Util_Widget2DBase::SetIncludeLatinUpperCaseLetters(const IncludeLatinUpperCaseLettersType& includelatinuppercaseletters)
{
    m_IncludeLatinUpperCaseLetters = includelatinuppercaseletters;
    if (!m_ChangeSetHandWriting_Util_Widget2DBase.Contains(static_cast< ::FeatStd::UInt32>(IncludeLatinUpperCaseLettersPropertyId))) {
        if (!m_ChangeSetHandWriting_Util_Widget2DBase.Add(static_cast< ::FeatStd::UInt32>(IncludeLatinUpperCaseLettersPropertyId))) {
            FEATSTD_DEBUG_FAIL();
        }
    }
}

void HandWriting_Util_Widget2DBase::SetIncludeGestureRecognition(const IncludeGestureRecognitionType& includegesturerecognition)
{
    m_IncludeGestureRecognition = includegesturerecognition;
    if (!m_ChangeSetHandWriting_Util_Widget2DBase.Contains(static_cast< ::FeatStd::UInt32>(IncludeGestureRecognitionPropertyId))) {
        if (!m_ChangeSetHandWriting_Util_Widget2DBase.Add(static_cast< ::FeatStd::UInt32>(IncludeGestureRecognitionPropertyId))) {
            FEATSTD_DEBUG_FAIL();
        }
    }
}
