/************************************************************************
*FILE: ProjectBaseMsgs.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(ProjectBaseMsgs_h)
#define ProjectBaseMsgs_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
#include <Courier/Serialization/BaseSerializer.h>
#endif
#include <Courier/Messaging/Message.h>
#include <BaseContract/generated/BaseMsgs.h>
#include <ProjectBaseTypes.h>
#include <Widgets/generated/AllWidgetMessages.h>
// ------------------------------------------------------------------------
          /**
           * - Usage                     : This message is used to indicate the view's activaion change information of the current active surface
           * - Component                 : HMIInfo
           * - Sender                    : Controller
           * - Parameter                 : SurfaceID
           * --    Meaning               : Id of the respective surface
           * --   Range                  : enSurfaceId (Defined in ProjectBaseTypes.xhcdl)
           * - Parameter                 : ViewID
           * --    Meaning               : Id of the respective view
           * - Variant                   : All
           */
class ActiveSurfaceViewUpdateMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ActiveSurfaceViewUpdateMsg, ::Courier::Message, 0xB0AB330A);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(3);

        ActiveSurfaceViewUpdateMsg(Courier::Int32 const & aSurfaceID, Candera::String const & aViewID);
        virtual ~ActiveSurfaceViewUpdateMsg();

        Courier::Int32 const & GetSurfaceID() const { return mSurfaceID; }
        void SetSurfaceID(Courier::Int32 const & value) { mSurfaceID = value; }
        Candera::String const & GetViewID() const { return mViewID; }
        void SetViewID(Candera::String const & value) { mViewID = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ActiveSurfaceViewUpdateMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mActiveSurfaceViewUpdateMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mActiveSurfaceViewUpdateMsgModifiableMetadata;
        static const ::Courier::ComponentId mActiveSurfaceViewUpdateMsgSubscriberList[];

        Courier::Int32 mSurfaceID;
        Candera::String mViewID;
};

// ------------------------------------------------------------------------
class ChangeLanguageReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ChangeLanguageReqMsg, ::Courier::Message, 0x3DD5CBCE);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ChangeLanguageReqMsg(enLanguageId const & aLanguageId);
        virtual ~ChangeLanguageReqMsg();

        enLanguageId const & GetLanguageId() const { return mLanguageId; }
        void SetLanguageId(enLanguageId const & value) { mLanguageId = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ChangeLanguageReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mChangeLanguageReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mChangeLanguageReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mChangeLanguageReqMsgSubscriberList[];

        enLanguageId mLanguageId;
};

// ------------------------------------------------------------------------
class StartPopupTimerReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(StartPopupTimerReqMsg, ::Courier::Message, 0xF0A3E093);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        StartPopupTimerReqMsg(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout);
        virtual ~StartPopupTimerReqMsg();

        Courier::UInt32 const & GetViewId() const { return mViewId; }
        void SetViewId(Courier::UInt32 const & value) { mViewId = value; }
        Courier::UInt32 const & GetTimeout() const { return mTimeout; }
        void SetTimeout(Courier::UInt32 const & value) { mTimeout = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(StartPopupTimerReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mStartPopupTimerReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mStartPopupTimerReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mStartPopupTimerReqMsgSubscriberList[];

        Courier::UInt32 mViewId;
        Courier::UInt32 mTimeout;
};

// ------------------------------------------------------------------------
class StopPopupTimerReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(StopPopupTimerReqMsg, ::Courier::Message, 0x7C09FE31);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        StopPopupTimerReqMsg(Courier::UInt32 const & aViewId);
        virtual ~StopPopupTimerReqMsg();

        Courier::UInt32 const & GetViewId() const { return mViewId; }
        void SetViewId(Courier::UInt32 const & value) { mViewId = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(StopPopupTimerReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mStopPopupTimerReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mStopPopupTimerReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mStopPopupTimerReqMsgSubscriberList[];

        Courier::UInt32 mViewId;
};

// ------------------------------------------------------------------------
        /* This message is used to update the popup timer restart request.*/
class RestartPopupTimerReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(RestartPopupTimerReqMsg, ::Courier::Message, 0x4A6035EB);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        RestartPopupTimerReqMsg(Courier::UInt32 const & aViewId);
        virtual ~RestartPopupTimerReqMsg();

        Courier::UInt32 const & GetViewId() const { return mViewId; }
        void SetViewId(Courier::UInt32 const & value) { mViewId = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(RestartPopupTimerReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mRestartPopupTimerReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mRestartPopupTimerReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mRestartPopupTimerReqMsgSubscriberList[];

        Courier::UInt32 mViewId;
};

// ------------------------------------------------------------------------
class ExpiredPopupTimerResMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ExpiredPopupTimerResMsg, ::Courier::Message, 0xAE3CAAA7);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ExpiredPopupTimerResMsg(Courier::UInt32 const & aViewId);
        virtual ~ExpiredPopupTimerResMsg();

        Courier::UInt32 const & GetViewId() const { return mViewId; }
        void SetViewId(Courier::UInt32 const & value) { mViewId = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ExpiredPopupTimerResMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mExpiredPopupTimerResMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mExpiredPopupTimerResMsgModifiableMetadata;
        static const ::Courier::ComponentId mExpiredPopupTimerResMsgSubscriberList[];

        Courier::UInt32 mViewId;
};

// ------------------------------------------------------------------------
        /* Request sent to focus manager to change the current focus information (visibility, timer state and focused view/widget).
        * Show - updates the view and the widget and sets visibility to true. The timer must be explicitelly restarted is desired.
        * Set - updates the view and the widget. The timer must be explicitelly restarted is desired.
        * Hide - sets visibility to false. View and widget are ignored. The Timer must be explicitelly stopped if desired.
        */
class FocusReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(FocusReqMsg, ::Courier::Message, 0xD05E8420);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        FocusReqMsg();
        FocusReqMsg(FocusActionEnum const & aAction, FocusTimerActionEnum const & aTimerAction, ::Courier::ViewId const & aView, Candera::String const & aWidget);
        virtual ~FocusReqMsg();

        FocusActionEnum const & GetAction() const { return mAction; }
        void SetAction(FocusActionEnum const & value) { mAction = value; }
        FocusTimerActionEnum const & GetTimerAction() const { return mTimerAction; }
        void SetTimerAction(FocusTimerActionEnum const & value) { mTimerAction = value; }
        ::Courier::ViewId const & GetView() const { return mView; }
        void SetView(::Courier::ViewId const & value) { mView = value; }
        Candera::String const & GetWidget() const { return mWidget; }
        void SetWidget(Candera::String const & value) { mWidget = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mFocusReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mFocusReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mFocusReqMsgSubscriberList[];

        FocusActionEnum mAction;
        FocusTimerActionEnum mTimerAction;
        ::Courier::ViewId mView;
        Candera::String mWidget;
};

// ------------------------------------------------------------------------
class ListFocusResetReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ListFocusResetReqMsg, ::Courier::Message, 0x44B8EF9F);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ListFocusResetReqMsg(::Courier::UInt32 const & aListId, ListFocusResetActionEnum const & aAction);
        virtual ~ListFocusResetReqMsg();

        ::Courier::UInt32 const & GetListId() const { return mListId; }
        void SetListId(::Courier::UInt32 const & value) { mListId = value; }
        ListFocusResetActionEnum const & GetAction() const { return mAction; }
        void SetAction(ListFocusResetActionEnum const & value) { mAction = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ListFocusResetReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mListFocusResetReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mListFocusResetReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mListFocusResetReqMsgSubscriberList[];

        ::Courier::UInt32 mListId;
        ListFocusResetActionEnum mAction;
};

// ------------------------------------------------------------------------
class EnableCameraRenderingReq : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(EnableCameraRenderingReq, ::Courier::Message, 0x065A4398);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        EnableCameraRenderingReq(::Courier::UInt32 const & aCameraID);
        virtual ~EnableCameraRenderingReq();

        ::Courier::UInt32 const & GetCameraID() const { return mCameraID; }
        void SetCameraID(::Courier::UInt32 const & value) { mCameraID = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(EnableCameraRenderingReq);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mEnableCameraRenderingReqMetaData;
        static ::Courier::Message::ModifiableMetadata mEnableCameraRenderingReqModifiableMetadata;
        static const ::Courier::ComponentId mEnableCameraRenderingReqSubscriberList[];

        ::Courier::UInt32 mCameraID;
};

// ------------------------------------------------------------------------
class SwitchApplicationStateReq : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SwitchApplicationStateReq, ::Courier::Message, 0x2411F98A);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SwitchApplicationStateReq();
        SwitchApplicationStateReq(Candera::UInt16 const & aApplicationID, Candera::UInt16 const & aApplicationState, Candera::UInt8 const & aActivityID);
        virtual ~SwitchApplicationStateReq();

        Candera::UInt16 const & GetApplicationID() const { return mApplicationID; }
        void SetApplicationID(Candera::UInt16 const & value) { mApplicationID = value; }
        Candera::UInt16 const & GetApplicationState() const { return mApplicationState; }
        void SetApplicationState(Candera::UInt16 const & value) { mApplicationState = value; }
        Candera::UInt8 const & GetActivityID() const { return mActivityID; }
        void SetActivityID(Candera::UInt8 const & value) { mActivityID = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSwitchApplicationStateReqMetaData;
        static ::Courier::Message::ModifiableMetadata mSwitchApplicationStateReqModifiableMetadata;
        static const ::Courier::ComponentId mSwitchApplicationStateReqSubscriberList[];

        Candera::UInt16 mApplicationID;
        Candera::UInt16 mApplicationState;
        Candera::UInt8 mActivityID;
};

// ------------------------------------------------------------------------
class DisableCameraRenderingReq : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DisableCameraRenderingReq, ::Courier::Message, 0x8F99BA4F);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DisableCameraRenderingReq(::Courier::UInt32 const & aCameraID);
        virtual ~DisableCameraRenderingReq();

        ::Courier::UInt32 const & GetCameraID() const { return mCameraID; }
        void SetCameraID(::Courier::UInt32 const & value) { mCameraID = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DisableCameraRenderingReq);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDisableCameraRenderingReqMetaData;
        static ::Courier::Message::ModifiableMetadata mDisableCameraRenderingReqModifiableMetadata;
        static const ::Courier::ComponentId mDisableCameraRenderingReqSubscriberList[];

        ::Courier::UInt32 mCameraID;
};

// ------------------------------------------------------------------------
class DummyMess : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DummyMess, ::Courier::Message, 0x6F46D34F);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DummyMess(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
        virtual ~DummyMess();

        Candera::UInt8 const & GetFirstView() const { return mFirstView; }
        void SetFirstView(Candera::UInt8 const & value) { mFirstView = value; }
        Candera::UInt8 const & GetSecondView() const { return mSecondView; }
        void SetSecondView(Candera::UInt8 const & value) { mSecondView = value; }
        Candera::UInt8 const & GetPos() const { return mPos; }
        void SetPos(Candera::UInt8 const & value) { mPos = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DummyMess);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDummyMessMetaData;
        static ::Courier::Message::ModifiableMetadata mDummyMessModifiableMetadata;
        static const ::Courier::ComponentId mDummyMessSubscriberList[];

        Candera::UInt8 mFirstView;
        Candera::UInt8 mSecondView;
        Candera::UInt8 mPos;
};

// ------------------------------------------------------------------------
class ActivityMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ActivityMsg, ::Courier::Message, 0x93A5580A);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        ActivityMsg(Candera::UInt8 const & aActivityID);
        virtual ~ActivityMsg();

        Candera::UInt8 const & GetActivityID() const { return mActivityID; }
        void SetActivityID(Candera::UInt8 const & value) { mActivityID = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ActivityMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mActivityMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mActivityMsgModifiableMetadata;
        static const ::Courier::ComponentId mActivityMsgSubscriberList[];

        Candera::UInt8 mActivityID;
};

// ------------------------------------------------------------------------
class ActivateApplicationMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ActivateApplicationMsg, ::Courier::Message, 0xC277DA2B);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(3);

        ActivateApplicationMsg();
        virtual ~ActivateApplicationMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mActivateApplicationMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mActivateApplicationMsgModifiableMetadata;
        static const ::Courier::ComponentId mActivateApplicationMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class DeactivateApplicationMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DeactivateApplicationMsg, ::Courier::Message, 0xDAE968BA);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(3);

        DeactivateApplicationMsg();
        virtual ~DeactivateApplicationMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDeactivateApplicationMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mDeactivateApplicationMsgModifiableMetadata;
        static const ::Courier::ComponentId mDeactivateApplicationMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class HardKeyPressNotificationMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(HardKeyPressNotificationMsg, ::Courier::Message, 0x9EA6C859);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        HardKeyPressNotificationMsg(Courier::UInt8 const & aDummy, Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState);
        virtual ~HardKeyPressNotificationMsg();

        Courier::UInt8 const & GetDummy() const { return mdummy; }
        void SetDummy(Courier::UInt8 const & value) { mdummy = value; }
        Courier::UInt8 const & GetHKCode() const { return mHKCode; }
        void SetHKCode(Courier::UInt8 const & value) { mHKCode = value; }
        Courier::UInt8 const & GetHKState() const { return mHKState; }
        void SetHKState(Courier::UInt8 const & value) { mHKState = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(HardKeyPressNotificationMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mHardKeyPressNotificationMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mHardKeyPressNotificationMsgModifiableMetadata;
        static const ::Courier::ComponentId mHardKeyPressNotificationMsgSubscriberList[];

        Courier::UInt8 mdummy;
        Courier::UInt8 mHKCode;
        Courier::UInt8 mHKState;
};

// ------------------------------------------------------------------------
          /* This message is to check whether Right Encoder input will fall back to Master for Tune Scroll
           */
class FocusOnRightEncoderReqUpdMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(FocusOnRightEncoderReqUpdMsg, ::Courier::Message, 0x85E63592);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        FocusOnRightEncoderReqUpdMsg(bool const & aIsFocusUsed);
        virtual ~FocusOnRightEncoderReqUpdMsg();

        bool const & GetIsFocusUsed() const { return mIsFocusUsed; }
        void SetIsFocusUsed(bool const & value) { mIsFocusUsed = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(FocusOnRightEncoderReqUpdMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mFocusOnRightEncoderReqUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mFocusOnRightEncoderReqUpdMsgModifiableMetadata;
        static const ::Courier::ComponentId mFocusOnRightEncoderReqUpdMsgSubscriberList[];

        bool mIsFocusUsed;
};

// ------------------------------------------------------------------------
          /* This message is to set gadget screen
           */
class StoreActiveGadgetReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(StoreActiveGadgetReqMsg, ::Courier::Message, 0x2F7F3BFB);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        StoreActiveGadgetReqMsg(bool const & aIsGadgetAtive);
        virtual ~StoreActiveGadgetReqMsg();

        bool const & GetIsGadgetAtive() const { return mIsGadgetAtive; }
        void SetIsGadgetAtive(bool const & value) { mIsGadgetAtive = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(StoreActiveGadgetReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mStoreActiveGadgetReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mStoreActiveGadgetReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mStoreActiveGadgetReqMsgSubscriberList[];

        bool mIsGadgetAtive;
};

// ------------------------------------------------------------------------
          /* 
           * Used to handle Closure of popup from States Region.
           */
class CheckToClosePopupMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CheckToClosePopupMsg, ::Courier::Message, 0x56789987);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        CheckToClosePopupMsg(Courier::UInt32 const & aPopupId);
        virtual ~CheckToClosePopupMsg();

        Courier::UInt32 const & GetPopupId() const { return mPopupId; }
        void SetPopupId(Courier::UInt32 const & value) { mPopupId = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(CheckToClosePopupMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCheckToClosePopupMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCheckToClosePopupMsgModifiableMetadata;
        static const ::Courier::ComponentId mCheckToClosePopupMsgSubscriberList[];

        Courier::UInt32 mPopupId;
};

// ------------------------------------------------------------------------
class ContextSwitchOutReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ContextSwitchOutReqMsg, ::Courier::Message, 0x873ACAEA);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ContextSwitchOutReqMsg(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId);
        virtual ~ContextSwitchOutReqMsg();

        Courier::UInt32 const & GetTargetContextId() const { return mTargetContextId; }
        void SetTargetContextId(Courier::UInt32 const & value) { mTargetContextId = value; }
        Courier::UInt32 const & GetSourceContextId() const { return mSourceContextId; }
        void SetSourceContextId(Courier::UInt32 const & value) { mSourceContextId = value; }
        Courier::UInt32 const & GetTargetAppId() const { return mTargetAppId; }
        void SetTargetAppId(Courier::UInt32 const & value) { mTargetAppId = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ContextSwitchOutReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mContextSwitchOutReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mContextSwitchOutReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mContextSwitchOutReqMsgSubscriberList[];

        Courier::UInt32 mTargetContextId;
        Courier::UInt32 mSourceContextId;
        Courier::UInt32 mTargetAppId;
};

// ------------------------------------------------------------------------
class ContextSwitchInResMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ContextSwitchInResMsg, ::Courier::Message, 0x3F599C43);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ContextSwitchInResMsg(Courier::UInt32 const & aSwitchId, Courier::UInt32 const & aResponseType);
        virtual ~ContextSwitchInResMsg();

        Courier::UInt32 const & GetSwitchId() const { return mSwitchId; }
        void SetSwitchId(Courier::UInt32 const & value) { mSwitchId = value; }
        Courier::UInt32 const & GetResponseType() const { return mResponseType; }
        void SetResponseType(Courier::UInt32 const & value) { mResponseType = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ContextSwitchInResMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mContextSwitchInResMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mContextSwitchInResMsgModifiableMetadata;
        static const ::Courier::ComponentId mContextSwitchInResMsgSubscriberList[];

        Courier::UInt32 mSwitchId;
        Courier::UInt32 mResponseType;
};

// ------------------------------------------------------------------------
class CurrentScreenDisplayReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CurrentScreenDisplayReqMsg, ::Courier::Message, 0x8E7B6DE9);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        CurrentScreenDisplayReqMsg();
        virtual ~CurrentScreenDisplayReqMsg();

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCurrentScreenDisplayReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCurrentScreenDisplayReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mCurrentScreenDisplayReqMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class LaunchBarDisplayReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(LaunchBarDisplayReqMsg, ::Courier::Message, 0x9AFD09E2);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        LaunchBarDisplayReqMsg();
        LaunchBarDisplayReqMsg(bool const & aVisibility);
        virtual ~LaunchBarDisplayReqMsg();

        bool const & GetVisibility() const { return mVisibility; }
        void SetVisibility(bool const & value) { mVisibility = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mLaunchBarDisplayReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mLaunchBarDisplayReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mLaunchBarDisplayReqMsgSubscriberList[];

        bool mVisibility;
};

// ------------------------------------------------------------------------
          /* 
           * Used to meter / voice announcement from SXM/Tuner/Media on swipe of TBT icon.
           */
class NavTBTSwipeReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(NavTBTSwipeReqMsg, ::Courier::Message, 0x2B43F2CC);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        NavTBTSwipeReqMsg();
        virtual ~NavTBTSwipeReqMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mNavTBTSwipeReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mNavTBTSwipeReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mNavTBTSwipeReqMsgSubscriberList[];
};

// ------------------------------------------------------------------------
			 /* This message is sent by the Controller(to Model) to update the Right Encoder information for list button 
			  *(Mainly for Focus group: 12(Progress/Slider))
			  */
class ListItemRightEncoderChangeUpdMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ListItemRightEncoderChangeUpdMsg, ::Courier::Message, 0x60A382BB);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ListItemRightEncoderChangeUpdMsg(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId);
        virtual ~ListItemRightEncoderChangeUpdMsg();

        Courier::Int8 const & GetSteps() const { return mSteps; }
        void SetSteps(Courier::Int8 const & value) { mSteps = value; }
        Courier::UInt32 const & GetListId() const { return mListId; }
        void SetListId(Courier::UInt32 const & value) { mListId = value; }
        Courier::UInt32 const & GetRowId() const { return mRowId; }
        void SetRowId(Courier::UInt32 const & value) { mRowId = value; }
        Courier::UInt32 const & GetColumnId() const { return mColumnId; }
        void SetColumnId(Courier::UInt32 const & value) { mColumnId = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ListItemRightEncoderChangeUpdMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mListItemRightEncoderChangeUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mListItemRightEncoderChangeUpdMsgModifiableMetadata;
        static const ::Courier::ComponentId mListItemRightEncoderChangeUpdMsgSubscriberList[];

        Courier::Int8 mSteps;
        Courier::UInt32 mListId;
        Courier::UInt32 mRowId;
        Courier::UInt32 mColumnId;
};

// ------------------------------------------------------------------------
          /* Request to reset the Last List Focus Lock information which can come from controller/model.
           */
class ListFocusLockDataResetReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ListFocusLockDataResetReqMsg, ::Courier::Message, 0x5B9ECE08);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ListFocusLockDataResetReqMsg();
        virtual ~ListFocusLockDataResetReqMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mListFocusLockDataResetReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mListFocusLockDataResetReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mListFocusLockDataResetReqMsgSubscriberList[];
};

// ------------------------------------------------------------------------
          /* 
           * Used to control the focus when line up down is pressed.
           */
class ListFocusScrollReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ListFocusScrollReqMsg, ::Courier::Message, 0x8F7E5876);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ListFocusScrollReqMsg(Courier::UInt32 const & aListId, Courier::Int32 const & aSteps);
        virtual ~ListFocusScrollReqMsg();

        Courier::UInt32 const & GetListId() const { return mListId; }
        void SetListId(Courier::UInt32 const & value) { mListId = value; }
        Courier::Int32 const & GetSteps() const { return mSteps; }
        void SetSteps(Courier::Int32 const & value) { mSteps = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ListFocusScrollReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mListFocusScrollReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mListFocusScrollReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mListFocusScrollReqMsgSubscriberList[];

        Courier::UInt32 mListId;
        Courier::Int32 mSteps;
};

// ------------------------------------------------------------------------
class SetApplicationModeReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SetApplicationModeReqMsg, ::Courier::Message, 0xC7F75170);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SetApplicationModeReqMsg(Courier::UInt32 const & aModeId);
        virtual ~SetApplicationModeReqMsg();

        Courier::UInt32 const & GetModeId() const { return mModeId; }
        void SetModeId(Courier::UInt32 const & value) { mModeId = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(SetApplicationModeReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSetApplicationModeReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSetApplicationModeReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mSetApplicationModeReqMsgSubscriberList[];

        Courier::UInt32 mModeId;
};

// ------------------------------------------------------------------------
class SpellerBbehaviorReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SpellerBbehaviorReqMsg, ::Courier::Message, 0xD1158C47);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SpellerBbehaviorReqMsg(bool const & aEnable);
        virtual ~SpellerBbehaviorReqMsg();

        bool const & GetEnable() const { return mEnable; }
        void SetEnable(bool const & value) { mEnable = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(SpellerBbehaviorReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSpellerBbehaviorReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSpellerBbehaviorReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mSpellerBbehaviorReqMsgSubscriberList[];

        bool mEnable;
};

// ------------------------------------------------------------------------
class StatusBarDisplayReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(StatusBarDisplayReqMsg, ::Courier::Message, 0x01780FBE);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        StatusBarDisplayReqMsg();
        StatusBarDisplayReqMsg(bool const & aVisibility, Courier::Int32 const & aHeaderType);
        virtual ~StatusBarDisplayReqMsg();

        bool const & GetVisibility() const { return mVisibility; }
        void SetVisibility(bool const & value) { mVisibility = value; }
        Courier::Int32 const & GetHeaderType() const { return mHeaderType; }
        void SetHeaderType(Courier::Int32 const & value) { mHeaderType = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mStatusBarDisplayReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mStatusBarDisplayReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mStatusBarDisplayReqMsgSubscriberList[];

        bool mVisibility;
        Courier::Int32 mHeaderType;
};

// ------------------------------------------------------------------------
          /* 
           * Used to trigger voice announcement request from SXM/Tuner/Media on press of TBT icon.
           */
class TBTRetriggerAcousticMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(TBTRetriggerAcousticMsg, ::Courier::Message, 0x1C4FBBFD);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        TBTRetriggerAcousticMsg();
        virtual ~TBTRetriggerAcousticMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTBTRetriggerAcousticMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mTBTRetriggerAcousticMsgModifiableMetadata;
        static const ::Courier::ComponentId mTBTRetriggerAcousticMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class StartGadgetAnimationReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(StartGadgetAnimationReqMsg, ::Courier::Message, 0xF3282CF5);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        StartGadgetAnimationReqMsg(Courier::UInt32 const & aInstanceId);
        virtual ~StartGadgetAnimationReqMsg();

        Courier::UInt32 const & GetInstanceId() const { return mInstanceId; }
        void SetInstanceId(Courier::UInt32 const & value) { mInstanceId = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(StartGadgetAnimationReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mStartGadgetAnimationReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mStartGadgetAnimationReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mStartGadgetAnimationReqMsgSubscriberList[];

        Courier::UInt32 mInstanceId;
};

// ------------------------------------------------------------------------
class ControlPanelButtonPressInfo : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ControlPanelButtonPressInfo, ::Courier::Message, 0x9963C979);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        ControlPanelButtonPressInfo(Courier::UInt8 const & aControlPanelButton, Courier::UInt8 const & aButtonstate);
        virtual ~ControlPanelButtonPressInfo();

        Courier::UInt8 const & GetControlPanelButton() const { return mControlPanelButton; }
        void SetControlPanelButton(Courier::UInt8 const & value) { mControlPanelButton = value; }
        Courier::UInt8 const & GetButtonstate() const { return mButtonstate; }
        void SetButtonstate(Courier::UInt8 const & value) { mButtonstate = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ControlPanelButtonPressInfo);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mControlPanelButtonPressInfoMetaData;
        static ::Courier::Message::ModifiableMetadata mControlPanelButtonPressInfoModifiableMetadata;
        static const ::Courier::ComponentId mControlPanelButtonPressInfoSubscriberList[];

        Courier::UInt8 mControlPanelButton;
        Courier::UInt8 mButtonstate;
};

// ------------------------------------------------------------------------
class NavigationCarModeInfo : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(NavigationCarModeInfo, ::Courier::Message, 0x3E6C6597);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        NavigationCarModeInfo(bool const & aCarMode, bool const & aCoachMode);
        virtual ~NavigationCarModeInfo();

        bool const & GetCarMode() const { return mCarMode; }
        void SetCarMode(bool const & value) { mCarMode = value; }
        bool const & GetCoachMode() const { return mCoachMode; }
        void SetCoachMode(bool const & value) { mCoachMode = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(NavigationCarModeInfo);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mNavigationCarModeInfoMetaData;
        static ::Courier::Message::ModifiableMetadata mNavigationCarModeInfoModifiableMetadata;
        static const ::Courier::ComponentId mNavigationCarModeInfoSubscriberList[];

        bool mCarMode;
        bool mCoachMode;
};

#endif // ProjectBaseMsgs_h
