/************************************************************************
*FILE: AppHmi_TunerStateMachine.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(AppHmi_TunerStateMachine_h)
#define AppHmi_TunerStateMachine_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Courier/Messaging/Message.h>
#include <AppHmi_TunerStateMachineSEMLibB.h>
#include <AppHmi_TunerStateMachineData.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Cit/VisualStateGlueLayer/DeductResult.h>
#ifdef CIT_SIMULATION
#include <json/value.h>
#endif
#include <AppHmi_TunerTypes.h>
#include <AppHmi_TunerConstants.h>
#include <AppHmi_TunerMessages.h>
#include <AppHmi_TunerDatabinding.h>
#include <AppHmi_TunerViews.h>
#include <AppHmi_TunerController.h>
// ------------------------------------------------------------------------
class AppHmi_TunerStateMachineImpl : public AppHmi_TunerStateMachine
{
public:
    typedef AppHmi_TunerStateMachine Base;

#ifdef VISUALSTATE_7_TRACE
    // Mapping of data types of API to get rid of include dependencies
    //typedef SEM_ACTION_EXPRESSION_TYPE VS_Type_ActionExpression;
	using Base::VS_Type_ActionExpression;
    //typedef SEM_EVENT_TYPE VS_Type_Event;
	//typedef SEM_STATE_TYPE VS_Type_State;
	//typedef SEM_EXPLANATION_TYPE VS_Type_Explanation;
	//typedef SEM_STATE_MACHINE_TYPE VS_Type_Statemachine;
	using Base::VS_Type_Event;
	using Base::VS_Type_State;
	using Base::VS_Type_Explanation;
	using Base::VS_Type_Statemachine;

    // Mapping of enums and defines of API to get rid of include dependencies
    //enum { VS_Ret_Ok = SES_OKAY };
    //enum { VS_Ret_Found = SES_FOUND };
	enum { VS_Ret_Ok = Base::VS_Ret_Ok };
	enum { VS_Ret_Found = Base::VS_Ret_Found };
    enum { VS_Evt_Reset = SE_RESET };
    enum { VS_Ret_Error = SES_RANGE_ERR };
#else
#ifndef VISUALSTATE_HCODER
    typedef SEM_ACTION_EXPRESSION_TYPE VS_Type_ActionExpression;
    typedef SEM_EVENT_TYPE VS_Type_Event;
    typedef SEM_STATE_TYPE VS_Type_State;
    typedef SEM_EXPLANATION_TYPE VS_Type_Explanation;
    typedef SEM_STATE_MACHINE_TYPE VS_Type_Statemachine;
    enum { VS_Ret_Ok = SES_OKAY };
    enum { VS_Ret_Found = SES_FOUND };
    enum { VS_Evt_Reset = SE_RESET };
    enum { VS_Ret_Error = SES_RANGE_ERR };
#else
    enum { VS_Ret_Ok = 0U };
    enum { VS_Ret_Found = 1U };
    enum { VS_Evt_Reset = 0U };
    enum { VS_Ret_Error = 4U };
#endif
#endif
// ------------------------------------------------------------------------

    // Mapping of args passed as hashId to corresponding identifier
    static const ::FeatStd::Char *GetNameFromId(::FeatStd::UInt32 id);

// ------------------------------------------------------------------------
    virtual void acHdOnOffUpdate(::FeatStd::Int8 aBand);
    virtual void acHdParameterUpdate(::FeatStd::Int8 aUpdate);
    virtual void acHdListAccess(::FeatStd::Int8 aScreenStatus);
    virtual void acDtmSplitAudio();
    virtual void acDtmResetTransitions();
    virtual void acHdParameterTuningUpdate(::FeatStd::Int8 aTuneType);
    virtual void acHdAudioProgSelect(::FeatStd::UInt32 aProgVal);
    virtual void Perform_TunerSelect_1();
    virtual void Perform_TunerSelect_2();
    virtual void Perform_TunerSelect_3();
    virtual void Perform_TunerSelect_4();
    virtual void Perform_BandSelect_Tuner1();
    virtual void Perform_BandSelect_Tuner2();
    virtual void Perform_BandSelect_Tuner3();
    virtual void Perform_BandSelect_Tuner4();
    virtual void Perform_SXM_Context();
    virtual void Perform_TestmodeBlock_Context();
    virtual void Perform_SXMMonitor_Context();
    virtual void Perform_SXMSettings_Context();
    virtual void Perform_SettingsBackBtn_Context();
    virtual void Perform_Service_Linking_Inc();
    virtual void Perform_Service_Linking_Dec();
    virtual void Perform_Service_Link_Inc();
    virtual void Perform_Service_Link_Dec();
    virtual void Perform_CLevel_Inc();
    virtual void Perform_CLevel_Dec();
    virtual void Activate_DAB_TestMode();
    virtual void Deactivate_DAB_TestMode();
    virtual void Perform_Preset_Select_1();
    virtual void Perform_Preset_Select_2();
    virtual void Perform_Preset_Select_3();
    virtual void Perform_Preset_Select_4();
    virtual void Perform_Preset_Select_5();
    virtual void Perform_Preset_Select_6();
    virtual void Perform_Preset_Select_7();
    virtual void Perform_Preset_Select_8();
    virtual void Perform_Preset_Select_9();
    virtual void Perform_Preset_Select_10();
    virtual void Perform_Preset_Select_11();
    virtual void Perform_Preset_Select_12();
    virtual void Perform_Preset_Popup_1();
    virtual void Perform_Preset_Popup_2();
    virtual void Perform_Preset_Popup_3();
    virtual void Perform_Preset_Popup_4();
    virtual void Perform_Preset_Popup_5();
    virtual void Perform_Preset_Popup_6();
    virtual void Perform_Preset_Popup_7();
    virtual void Perform_Preset_Popup_8();
    virtual void Perform_Preset_Popup_9();
    virtual void Perform_Preset_Popup_10();
    virtual void Perform_Preset_Popup_11();
    virtual void Perform_Preset_Popup_12();
    virtual void Perform_CannotStore_Popup();
    virtual void Perform_Preset_Store_1();
    virtual void Perform_Preset_Store_2();
    virtual void Perform_Preset_Store_3();
    virtual void Perform_Preset_Store_4();
    virtual void Perform_Preset_Store_5();
    virtual void Perform_Preset_Store_6();
    virtual void Perform_Preset_Store_7();
    virtual void Perform_Preset_Store_8();
    virtual void Perform_Preset_Store_9();
    virtual void Perform_Preset_Store_10();
    virtual void Perform_Preset_Store_11();
    virtual void Perform_Preset_Store_12();
    virtual void Perform_Seek_Stop();
    virtual void Perform_Seek_Next();
    virtual void Perform_Seek_Previous();
    virtual void Perform_Seek_Next_Repeat();
    virtual void Perform_Seek_Previous_Repeat();
    virtual void Perform_Seek_Previous_Jump();
    virtual void Perform_Seek_Next_Jump();
    virtual void Perform_RefTunerModule_Scene_Tuner_FM();
    virtual void Perform_RefTunerModule_Scene_Tuner_AM();
    virtual void Perform_Freq_Tuning_StepUp();
    virtual void Perform_Freq_Tuning_StepDown();
    virtual void Perform_Freq_Scan_Start();
    virtual void Perform_Freq_Scan_Stop();
    virtual void Perform_MediaChange();
    virtual void Perform_HomeScreenChange();
    virtual void Perform_BTPhoneMsgChange();
    virtual void Perform_NaviChange();
    virtual void Perform_MirrorLinkChange();
    virtual void PreformTunerAppActReqMsg();
    virtual void Preform_AFListExit();
    virtual void Perform_DAB_TM_Freq_Seek_Next();
    virtual void Perform_DAB_TM_Freq_Seek_Previous();
    virtual void Perform_DAB_TM_Ensemble_Seek_Next();
    virtual void Perform_DAB_TM_Ensemble_Seek_Previous();
    virtual void TunerViewReq_SourceSelection();
    virtual void TunerViewReq_FM1();
    virtual void TunerViewReq_FM2();
    virtual void TunerViewReq_FM_AST();
    virtual void TunerViewReq_AM();
    virtual void TunerViewReq_AM_AST();
    virtual void TunerViewReq_DAB();
    virtual void TunerViewReq_DAB_Monitor();
    virtual void TunerViewReq_DAB_AST();
    virtual void TunerViewReq_WEATHERBAND();
    virtual void TunerViewReq_WEATHERBAND_MONITOR();
    virtual void TunerViewReq_DRM();
    virtual void TunerViewReq_DRM_AST();
    virtual void TunerViewReq_DRM_SL();
    virtual void TunerViewReq_OPT_DRMPTY();
    virtual void TunerViewReq_OPT_FMAM();
    virtual void TunerViewReq_OPT_DABPTY();
    virtual void TunerViewReq_FM_TESTMODE();
    virtual void TunerViewReq_FM_MONITORTESTMODE();
    virtual void TunerViewReq_AM_TESTMODE();
    virtual void TunerViewReq_AM_MONITORTESTMODE();
    virtual void TunerViewReq_Previous();
    virtual void TunerViewReq_PlayView();
    virtual void TunerViewReq_FM_SL();
    virtual void TunerViewReq_DAB_SL();
    virtual void TunerViewReq_TT_MONITOR1();
    virtual void TunerViewReq_TT_MONITOR2();
    virtual void TunerViewReq_TT_MONITOR3();
    virtual void TunerViewReq_DAB_SETUP_MONITOR();
    virtual void TunerViewReq_DAB_Quality_TestMode();
    virtual void TunerViewReq_DAB_Service_Info_TestMod();
    virtual void TunerViewReq_DAB_Expert_API_TestMode();
    virtual void TunerViewReq_DRMSetup_Monitor();
    virtual void TunerViewReq_AF_L();
    virtual void TunerViewReq_TMC();
    virtual void TunerViewReq_TMC_L();
    virtual void TunerViewReq_TMC_INFO();
    virtual void TunerViewReq_TMC_STN_INFO();
    virtual void TunerViewReq_TestModeScreens();
    virtual void TunerTestModeViewReqMsg_Start();
    virtual void TunerTestModeViewReqMsg_Stop();
    virtual void TunerViewReq_MASTER_GADGET_TUNER();
    virtual void TunerViewReq_MASTER_GADGET_TUNER_CABIN_ONLY();
    virtual void TunerViewReq_FM_INFO();
    virtual void TunerViewReq_AM_INFO();
    virtual void TunerViewReq_HDDTM_TESTMODE();
    virtual void TunerViewReq_HDPARAMTUNING_TESTMODE();
    virtual void Perform_Activate_Home_Source();
    virtual void Perform_AutoStore_AM();
    virtual void Perform_AutoStore_FM();
    virtual void Perform_AutoStore_DAB();
    virtual void RequestBrowseList(::FeatStd::UInt8 aG_SM_ListType);
    virtual void RequestBrowseListExit(::FeatStd::UInt8 aG_SM_ListType);
    virtual void StationBrowseList();
    virtual void DABStationBrowseList();
    virtual void FMMonitorMessageSharxHiCut(::FeatStd::UInt8 aFirstArg, ::FeatStd::UInt8 aSecondArg);
    virtual void Perform_Tuner_fn(::FeatStd::UInt8 aEventId, ::FeatStd::UInt32 aFirstArg, ::FeatStd::UInt32 aSecondArg);
    virtual void Perform_Next_fn_FM();
    virtual void Perform_Previous_fn_FM();
    virtual void Perform_Next_fn_AM();
    virtual void Perform_Previous_fn_AM();
    virtual void Perform_Next_fn_DAB();
    virtual void Perform_Previous_fn_DAB();
    virtual void Perform_Next_fn();
    virtual void Perform_Previous_fn();
    virtual void Perform_Abort_Next_Previous_Icon_fn();
    virtual void Notify_Init_Finished();
    virtual void Perform_Main_Src_Select();
    virtual void Perform_Tuner_Src_Select();
    virtual void Perform_Home_Src_Toggle();
    virtual void Perform_Send_Context(::FeatStd::UInt8 aContextScene);
    virtual void Perform_Tuner_Wx_fn(::FeatStd::UInt32 aEventId);
    virtual void Perform_Stop_Next_Previous();
    virtual void Update_Preset_Focused();
    virtual void Update_FMPreset_Focused();
    virtual void Update_AMPreset_Focused();
    virtual void Update_Previous_View();
    virtual void gacChangeLanguageReq(::FeatStd::Int32 aLanguageId);
    virtual void gacHideFocusInViewReq(::FeatStd::UInt32 aView);
    virtual void NextLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PreviousLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void DualViewLeftTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void DualViewRightTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PageFlipBackTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PageFlipFrontTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void ZoomInTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos);
    virtual void ZoomOutTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos);
    virtual void FadeTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void gacWaitAnimationStartReq();
    virtual void acFocusOnRightEncoderReqUpd(bool aIsFocusUsed);
    virtual void acSetGadgetSceenActiveStatus(bool aIsGadgetAtive);
    virtual void acHKNotificationMsg(::FeatStd::Int8 aHKCode, ::FeatStd::Int8 aHKState);
    virtual void acPerform_CloseAllDropdowns();
    virtual void acPerform_CloseDropdown(::FeatStd::UInt32 aListId);
    virtual void acPerform_OpenDropdown(::FeatStd::UInt32 aListId);
    virtual void acPerform_ToggleDropdown(::FeatStd::UInt32 aListId);
    virtual void acStartAppPopupTimer(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aTimeout);
    virtual void acStopAppPopupTimer(::FeatStd::UInt32 aViewId);
    virtual void acPostBeep(::FeatStd::Int8 aBeepType);
    virtual void gacCheckToClosePopup(::FeatStd::UInt32 aPopupId);
    virtual void acRestartAppPopupTimer(::FeatStd::UInt32 aViewId);
    virtual void gacContextSwitchBackRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchCompleteRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchFailedRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchDoneRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchOutReq(::FeatStd::UInt32 aTargetContextId, ::FeatStd::UInt32 aSourceContextId, ::FeatStd::UInt32 aTargetAppId);
    virtual void gacCurrentScreenDisplayReq();
    virtual void gacLaunchBarDisplayReq(bool aVisibility);
    virtual void gacNavTBTSwipe();
    virtual void gacPerformListBtnRightEncoderChangeUpd(::FeatStd::Int8 aSteps, ::FeatStd::UInt32 aListId, ::FeatStd::UInt32 aRowId, ::FeatStd::UInt32 aColumnId);
    virtual void gacScrollListUp();
    virtual void gacScrollListDown();
    virtual void gacScrollPageUp();
    virtual void gacScrollPageDown();
    virtual void gacScrollListFocusUp(::FeatStd::UInt32 aListId);
    virtual void gacScrollListFocusDown(::FeatStd::UInt32 aListId);
    virtual void gacPerformListFocusLockDataResetUpd();
    virtual void gacSetApplicationMode(::FeatStd::UInt32 aModeId);
    virtual void gacSpellerBbehaviorReq(bool aEnable);
    virtual void gacStatusBarDisplayReq(bool aVisibility, ::FeatStd::Int32 aHeaderType);
    virtual void gacTBTRetriggerAcousticOutput();
    virtual void gacWaitAnimationStopReq();
    virtual void gacViewCreateReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateAllReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewDestroyReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewClearReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewHideReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateWithoutLoadReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewAsyncLoadReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewActivateWithoutRenderingReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupCreateAndSBShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupCreateAndSBShowReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacPopupSBCloseReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupSBCloseReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacPopupRestartTimerReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupRestartTimerReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateAndShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewHideAndDestroyReq(::FeatStd::UInt32 aViewId);
    virtual void gacSceneTransitionEnter(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint);
    virtual void gacSceneTransitionLeave(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint);
    virtual void gacDisplayStatusLineReq(::FeatStd::Int32 aDisplayRegionType);
    virtual void gacHideStatusLineReq(::FeatStd::Int32 aDisplayRegionType);
    virtual void gacDisplayFooterLineReq();
    virtual void gacHideFooterLineReq();
    virtual void gacDisplayStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacHideStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacDisplayFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacHideFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacRegisterForCloseOnTouchSession(::FeatStd::UInt32 aViewId);
    virtual void gacDeregisterForCloseOnTouchSessionReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupFilterPrioEnableReq(::FeatStd::UInt32 aPrio);
    virtual void gacPopupFilterAllEnableReq();
    virtual void gacPopupFilterDisableReq();
    virtual void gacProfileChange(::FeatStd::Int8 aProfile);
    virtual void gacPopupFilterPrioEnableReqForDisplay(::FeatStd::UInt32 aPrio, ::FeatStd::UInt32 aDisplayID);
    virtual void gacPopupFilterAllEnableReqForDisplay(::FeatStd::UInt32 aDisplayID);
    virtual void gacPopupFilterDisableReqForDisplay(::FeatStd::UInt32 aDisplayID);
    virtual void gacStartSceneTransitionAnimation(::FeatStd::UInt32 aSourceView, ::FeatStd::UInt32 aDestinationView, ::FeatStd::UInt32 aUserData1, ::FeatStd::Int8 aUserData2);
    virtual void gacDecrementActiveAnimationCount();

// ------------------------------------------------------------------------
    virtual ::FeatStd::UInt16 fnGetVariantType();

#ifdef CIT_SIMULATION
    bool CallAction(const ::FeatStd::Char* actionName, const ::Json::Value& parameters, ::Json::Value &response);
    const ::FeatStd::Char* GetEventName(::FeatStd::UInt32 eventId, ::Courier::Message const & message, Json::Value& eventArgument);
#endif
    // Added function for deduction of one event to simplify the event loop
    bool HandleDataBindingEventMapping(::Courier::AbstractDataItemMsg const & message, ::FeatStd::UInt32& eventId) const;
    bool HandleEventMapping(::Courier::Message const & message, ::FeatStd::UInt32& eventId) const;

    ::Cit::DeductResult::Enum DeductEvent(::Courier::Message const & message, ::FeatStd::UInt32 eventId);

    //====  member function with TTFis output - added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====

	virtual unsigned short GetTraceClass();
	int GetNumberOfStatemachines();
    //====  member function with TTFis output - end                        key: SM_TTFis_SBHFMSRF ====
};

// ------------------------------------------------------------------------
bool SendHdOnOffReqMsg(Courier::Int8 const & aBand);
bool SendHdParameterListUpdate(Courier::Int8 const & aUpdate);
bool SendHdListAccessUpdateMsg(Courier::Int8 const & aScreenStatus);
bool SendDtmSplitAudioReqMsg();
bool SendDtmResetTransitionsReqMsg();
bool SendHdParameterTuningMsg(Courier::Int8 const & aTuneType);
bool SendHdAudioProgSelectMsg(Courier::UInt32 const & aProgVal);
bool SendTunerReqMsg(Courier::Int8 const & aTunerData);
bool SendSXMContextMsg();
bool SendTestmodeBlockContextMsg();
bool SendSXMMonitorContextMsg();
bool SendSXMSettingsTestmodeContextMsg();
bool SendFMAMBackContextMsg();
bool SendDABServiceReqMsg(Courier::UInt8 const & aService_Value);
bool SendDABServiceLinkReqMsg(Courier::UInt8 const & aService_Value);
bool SendDABCLevelReqMsg(Courier::UInt8 const & aCLevel_Value);
bool SendTestModeDABQuality(Courier::UInt8 const & aDABTestModeActiveStatus);
bool SendPresetSelectMsg(Courier::Int8 const & aPresetNumber);
bool SendPresetPopupMsg(Courier::Int8 const & aPresetNumber);
bool SendCannotStorePopupMsg();
bool SendLPReleaseMsg(Courier::Int8 const & aPresetNumber);
bool SendSeekReqMsg(Courier::Int8 const & aSeekMode);
bool SendSetWaveBandMsg(Courier::Int32 const & aBand);
bool SendTuneFrequencyReqMsg(Courier::Int8 const & aDirection, Courier::Int8 const & aTicks);
bool SendScanReqMsg(Courier::Int8 const & aScanMode);
bool SendMediaChangeMsg();
bool SendHomeScreenMsg();
bool SendBTPhoneMsg();
bool SendNaviMsg();
bool SendMirrorLinkMsg();
bool SendTunerAppActReqMsg();
bool SendAFListExitMsg();
bool SendDABTMSeekReqMsg(Courier::Int8 const & aDABTMSeekMode);
bool SendTunerViewReqMsg(Courier::UInt8 const & aView);
bool SendTuner_TestmodeViewReqMsg(Courier::UInt8 const & aTestmode_Value);
bool SendSwitchApplicationReq(enApplicationId const & aApplicationID, enSurfaceId const & aSurfaceID);
bool SendAutoStoreReqMsg();
bool SendBrowseListReqMsg(Courier::UInt8 const & aG_SM_ListType);
bool SendBrowseListExitMsg(Courier::UInt8 const & aG_SM_ListType);
bool SendStationListReqMsg();
bool SendDABStationListReqMsg();
bool SendFMMonitorMessage(Candera::UInt8 const & aFirstArg, Candera::UInt8 const & aSecondArg);
bool SendTunerBLMsg(Courier::Int8 const & aEventId, Courier::Int32 const & aFirstArg, Courier::Int32 const & aSecondArg);
bool SendNextSelectMsg_FM();
bool SendPreviousSelectMsg_FM();
bool SendNextSelectMsg_AM();
bool SendPreviousSelectMsg_AM();
bool SendNextSelectMsg_DAB();
bool SendPreviousSelectMsg_DAB();
bool SendNextIconSelectMsg();
bool SendPreviousIconSelectMsg();
bool SendAbortNextPreviousIcon();
bool SendGuiStartupFinishedUpdMsg();
bool SendButtonMainSrcActivate(Courier::Int8 const & aSrcmode);
bool SendContextToMaster(Courier::UInt8 const & aContextScene);
bool SendTuner_WxBLMsg(Courier::Int32 const & aEventId);
bool SendCloseNextPrev();
bool SendUpdatePresetFocused();
bool SendUpdateFMPresetFocused();
bool SendUpdateAMPresetFocused();
bool SendViewPreviousMsg();
bool SendChangeLanguageReqMsg(enLanguageId const & aLanguageId);
bool SendFocusReqMsg(FocusActionEnum const & aAction, FocusTimerActionEnum const & aTimerAction, ::Courier::ViewId const & aView, Candera::String const & aWidget);
bool SendDummyMess(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
bool SendAnimationReqMsg(Courier::AnimationAction::Enum const & aAnimationAction, ::Courier::ViewId const & aViewId, Courier::CompositePath const & aCompositePath, ::Courier::ItemId const & aAnimationId, Courier::AnimationProperties const & aAnimationProperties);
bool SendFocusOnRightEncoderReqUpdMsg(bool const & aIsFocusUsed);
bool SendStoreActiveGadgetReqMsg(bool const & aIsGadgetAtive);
bool SendHardKeyPressNotificationMsg(Courier::UInt8 const & aDummy, Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState);
bool SendDropdownChangeMsg(::Candera::DropdownChangeType const & aDropdownChangeType, ::Courier::UInt32 const & aListId);
bool SendStartPopupTimerReqMsg(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout);
bool SendStopPopupTimerReqMsg(Courier::UInt32 const & aViewId);
bool SendPlayBeepReqMsg(Courier::Int32 const & aBeepType);
bool SendCheckToClosePopupMsg(Courier::UInt32 const & aPopupId);
bool SendRestartPopupTimerReqMsg(Courier::UInt32 const & aViewId);
bool SendContextSwitchInResMsg(Courier::UInt32 const & aSwitchId, Courier::UInt32 const & aResponseType);
bool SendContextSwitchOutReqMsg(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId);
bool SendCurrentScreenDisplayReqMsg();
bool SendLaunchBarDisplayReqMsg(bool const & aVisibility);
bool SendNavTBTSwipeReqMsg();
bool SendListItemRightEncoderChangeUpdMsg(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId);
bool SendListChangeMsg(::Courier::UInt32 const & aListId, ListChangeType const & aListChangeType, ::Courier::Int32 const & aValue, ListChangeMsgSourceType const & aListChangeMsgSource, bool const & aImmediatePositioning);
bool SendListFocusScrollReqMsg(Courier::UInt32 const & aListId, Courier::Int32 const & aSteps);
bool SendListFocusLockDataResetReqMsg();
bool SendSetApplicationModeReqMsg(Courier::UInt32 const & aModeId);
bool SendSpellerBbehaviorReqMsg(bool const & aEnable);
bool SendStatusBarDisplayReqMsg(bool const & aVisibility, Courier::Int32 const & aHeaderType);
bool SendTBTRetriggerAcousticMsg();
bool SendViewReqMsg(Courier::ViewAction::Enum const & aViewAction, ::Courier::ViewId const & aViewId, bool const & aShallInitScene, bool const & aShallLoadScene);
bool SendActivationReqMsg(::Courier::ViewId const & aViewId, bool const & aActivation, bool const & aEnableRendering);
bool SendAsyncLoadReqMsg(::Courier::ViewId const & aViewId, bool const & aLoad);
bool SendPopupReqMsg(hmibase::popups::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aPopupDisplayID);
bool SendExtendedViewReqMsg(hmibase::views::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
bool SendShowHMISubSurfaceReqMsg(hmibase::displayRegion const & aDisplayRegion, Courier::Int32 const & aDisplayRegionType, bool const & aShowSubSurface, Courier::UInt32 const & aDisplayID, bool const & aLockSubSurface);
bool SendRegisterForCloseOnTouchSessionReqMsg(bool const & aRegister, ::Courier::ViewId const & aViewId);
bool SendPopupFilterPrioEnableReqMsg(Courier::UInt32 const & aPrio);
bool SendPopupFilterAllEnableReqMsg();
bool SendPopupFilterDisableReqMsg();
bool SendProfileSwitchMsg(Courier::UInt32 const & aProfile);
bool SendMultiDisplayPopupFilterReqMsg(hmibase::PopupFilterType const & aPopupFilterType, Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID);
bool SendCreateNewDestroyOld(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2);
bool SendNotifierMessage();

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acHdOnOffUpdate(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acHdOnOffUpdate(Courier::Int8 const & aBand);
#ifdef CIT_SIMULATION
bool CallAction_acHdParameterUpdate(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acHdParameterUpdate(Courier::Int8 const & aUpdate);
#ifdef CIT_SIMULATION
bool CallAction_acHdListAccess(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acHdListAccess(Courier::Int8 const & aScreenStatus);
#ifdef CIT_SIMULATION
bool CallAction_acDtmSplitAudio(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acDtmSplitAudio();
#ifdef CIT_SIMULATION
bool CallAction_acDtmResetTransitions(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acDtmResetTransitions();
#ifdef CIT_SIMULATION
bool CallAction_acHdParameterTuningUpdate(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acHdParameterTuningUpdate(Courier::Int8 const & aTuneType);
#ifdef CIT_SIMULATION
bool CallAction_acHdAudioProgSelect(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acHdAudioProgSelect(Courier::UInt32 const & aProgVal);
#ifdef CIT_SIMULATION
bool CallAction_Perform_TunerSelect_1(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_TunerSelect_1();
#ifdef CIT_SIMULATION
bool CallAction_Perform_TunerSelect_2(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_TunerSelect_2();
#ifdef CIT_SIMULATION
bool CallAction_Perform_TunerSelect_3(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_TunerSelect_3();
#ifdef CIT_SIMULATION
bool CallAction_Perform_TunerSelect_4(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_TunerSelect_4();
#ifdef CIT_SIMULATION
bool CallAction_Perform_BandSelect_Tuner1(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_BandSelect_Tuner1();
#ifdef CIT_SIMULATION
bool CallAction_Perform_BandSelect_Tuner2(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_BandSelect_Tuner2();
#ifdef CIT_SIMULATION
bool CallAction_Perform_BandSelect_Tuner3(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_BandSelect_Tuner3();
#ifdef CIT_SIMULATION
bool CallAction_Perform_BandSelect_Tuner4(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_BandSelect_Tuner4();
#ifdef CIT_SIMULATION
bool CallAction_Perform_SXM_Context(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_SXM_Context();
#ifdef CIT_SIMULATION
bool CallAction_Perform_TestmodeBlock_Context(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_TestmodeBlock_Context();
#ifdef CIT_SIMULATION
bool CallAction_Perform_SXMMonitor_Context(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_SXMMonitor_Context();
#ifdef CIT_SIMULATION
bool CallAction_Perform_SXMSettings_Context(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_SXMSettings_Context();
#ifdef CIT_SIMULATION
bool CallAction_Perform_SettingsBackBtn_Context(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_SettingsBackBtn_Context();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Service_Linking_Inc(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Service_Linking_Inc();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Service_Linking_Dec(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Service_Linking_Dec();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Service_Link_Inc(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Service_Link_Inc();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Service_Link_Dec(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Service_Link_Dec();
#ifdef CIT_SIMULATION
bool CallAction_Perform_CLevel_Inc(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_CLevel_Inc();
#ifdef CIT_SIMULATION
bool CallAction_Perform_CLevel_Dec(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_CLevel_Dec();
#ifdef CIT_SIMULATION
bool CallAction_Activate_DAB_TestMode(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Activate_DAB_TestMode();
#ifdef CIT_SIMULATION
bool CallAction_Deactivate_DAB_TestMode(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Deactivate_DAB_TestMode();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_1(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Select_1();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_2(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Select_2();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_3(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Select_3();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_4(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Select_4();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_5(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Select_5();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_6(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Select_6();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_7(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Select_7();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_8(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Select_8();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_9(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Select_9();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_10(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Select_10();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_11(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Select_11();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Select_12(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Select_12();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_1(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Popup_1();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_2(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Popup_2();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_3(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Popup_3();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_4(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Popup_4();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_5(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Popup_5();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_6(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Popup_6();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_7(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Popup_7();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_8(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Popup_8();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_9(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Popup_9();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_10(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Popup_10();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_11(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Popup_11();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Popup_12(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Popup_12();
#ifdef CIT_SIMULATION
bool CallAction_Perform_CannotStore_Popup(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_CannotStore_Popup();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_1(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Store_1();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_2(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Store_2();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_3(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Store_3();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_4(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Store_4();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_5(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Store_5();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_6(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Store_6();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_7(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Store_7();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_8(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Store_8();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_9(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Store_9();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_10(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Store_10();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_11(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Store_11();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Preset_Store_12(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Preset_Store_12();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Seek_Stop(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Seek_Stop();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Seek_Next(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Seek_Next();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Seek_Previous(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Seek_Previous();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Seek_Next_Repeat(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Seek_Next_Repeat();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Seek_Previous_Repeat(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Seek_Previous_Repeat();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Seek_Previous_Jump(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Seek_Previous_Jump();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Seek_Next_Jump(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Seek_Next_Jump();
#ifdef CIT_SIMULATION
bool CallAction_Perform_RefTunerModule_Scene_Tuner_FM(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_RefTunerModule_Scene_Tuner_FM();
#ifdef CIT_SIMULATION
bool CallAction_Perform_RefTunerModule_Scene_Tuner_AM(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_RefTunerModule_Scene_Tuner_AM();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Freq_Tuning_StepUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Freq_Tuning_StepUp();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Freq_Tuning_StepDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Freq_Tuning_StepDown();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Freq_Scan_Start(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Freq_Scan_Start();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Freq_Scan_Stop(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Freq_Scan_Stop();
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaChange(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_MediaChange();
#ifdef CIT_SIMULATION
bool CallAction_Perform_HomeScreenChange(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_HomeScreenChange();
#ifdef CIT_SIMULATION
bool CallAction_Perform_BTPhoneMsgChange(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_BTPhoneMsgChange();
#ifdef CIT_SIMULATION
bool CallAction_Perform_NaviChange(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_NaviChange();
#ifdef CIT_SIMULATION
bool CallAction_Perform_MirrorLinkChange(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_MirrorLinkChange();
#ifdef CIT_SIMULATION
bool CallAction_PreformTunerAppActReqMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PreformTunerAppActReqMsg();
#ifdef CIT_SIMULATION
bool CallAction_Preform_AFListExit(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Preform_AFListExit();
#ifdef CIT_SIMULATION
bool CallAction_Perform_DAB_TM_Freq_Seek_Next(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_DAB_TM_Freq_Seek_Next();
#ifdef CIT_SIMULATION
bool CallAction_Perform_DAB_TM_Freq_Seek_Previous(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_DAB_TM_Freq_Seek_Previous();
#ifdef CIT_SIMULATION
bool CallAction_Perform_DAB_TM_Ensemble_Seek_Next(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_DAB_TM_Ensemble_Seek_Next();
#ifdef CIT_SIMULATION
bool CallAction_Perform_DAB_TM_Ensemble_Seek_Previous(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_DAB_TM_Ensemble_Seek_Previous();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_SourceSelection(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_SourceSelection();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_FM1(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_FM1();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_FM2(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_FM2();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_FM_AST(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_FM_AST();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_AM(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_AM();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_AM_AST(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_AM_AST();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DAB(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_DAB();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DAB_Monitor(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_DAB_Monitor();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DAB_AST(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_DAB_AST();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_WEATHERBAND(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_WEATHERBAND();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_WEATHERBAND_MONITOR(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_WEATHERBAND_MONITOR();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DRM(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_DRM();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DRM_AST(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_DRM_AST();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DRM_SL(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_DRM_SL();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_OPT_DRMPTY(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_OPT_DRMPTY();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_OPT_FMAM(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_OPT_FMAM();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_OPT_DABPTY(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_OPT_DABPTY();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_FM_TESTMODE(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_FM_TESTMODE();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_FM_MONITORTESTMODE(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_FM_MONITORTESTMODE();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_AM_TESTMODE(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_AM_TESTMODE();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_AM_MONITORTESTMODE(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_AM_MONITORTESTMODE();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_Previous(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_Previous();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_PlayView(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_PlayView();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_FM_SL(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_FM_SL();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DAB_SL(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_DAB_SL();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_TT_MONITOR1(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_TT_MONITOR1();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_TT_MONITOR2(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_TT_MONITOR2();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_TT_MONITOR3(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_TT_MONITOR3();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DAB_SETUP_MONITOR(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_DAB_SETUP_MONITOR();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DAB_Quality_TestMode(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_DAB_Quality_TestMode();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DAB_Service_Info_TestMod(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_DAB_Service_Info_TestMod();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DAB_Expert_API_TestMode(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_DAB_Expert_API_TestMode();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_DRMSetup_Monitor(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_DRMSetup_Monitor();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_AF_L(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_AF_L();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_TMC(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_TMC();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_TMC_L(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_TMC_L();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_TMC_INFO(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_TMC_INFO();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_TMC_STN_INFO(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_TMC_STN_INFO();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_TestModeScreens(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_TestModeScreens();
#ifdef CIT_SIMULATION
bool CallAction_TunerTestModeViewReqMsg_Start(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerTestModeViewReqMsg_Start();
#ifdef CIT_SIMULATION
bool CallAction_TunerTestModeViewReqMsg_Stop(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerTestModeViewReqMsg_Stop();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_MASTER_GADGET_TUNER(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_MASTER_GADGET_TUNER();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_MASTER_GADGET_TUNER_CABIN_ONLY(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_MASTER_GADGET_TUNER_CABIN_ONLY();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_FM_INFO(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_FM_INFO();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_AM_INFO(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_AM_INFO();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_HDDTM_TESTMODE(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_HDDTM_TESTMODE();
#ifdef CIT_SIMULATION
bool CallAction_TunerViewReq_HDPARAMTUNING_TESTMODE(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TunerViewReq_HDPARAMTUNING_TESTMODE();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_Home_Source(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Activate_Home_Source();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AutoStore_AM(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AutoStore_AM();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AutoStore_FM(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AutoStore_FM();
#ifdef CIT_SIMULATION
bool CallAction_Perform_AutoStore_DAB(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_AutoStore_DAB();
#ifdef CIT_SIMULATION
bool CallAction_RequestBrowseList(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_RequestBrowseList(Courier::UInt8 const & aG_SM_ListType);
#ifdef CIT_SIMULATION
bool CallAction_RequestBrowseListExit(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_RequestBrowseListExit(Courier::UInt8 const & aG_SM_ListType);
#ifdef CIT_SIMULATION
bool CallAction_StationBrowseList(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_StationBrowseList();
#ifdef CIT_SIMULATION
bool CallAction_DABStationBrowseList(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DABStationBrowseList();
#ifdef CIT_SIMULATION
bool CallAction_FMMonitorMessageSharxHiCut(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_FMMonitorMessageSharxHiCut(Candera::UInt8 const & aFirstArg, Candera::UInt8 const & aSecondArg);
#ifdef CIT_SIMULATION
bool CallAction_Perform_Tuner_fn(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Tuner_fn(Courier::Int8 const & aEventId, Courier::Int32 const & aFirstArg, Courier::Int32 const & aSecondArg);
#ifdef CIT_SIMULATION
bool CallAction_Perform_Next_fn_FM(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Next_fn_FM();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Previous_fn_FM(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Previous_fn_FM();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Next_fn_AM(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Next_fn_AM();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Previous_fn_AM(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Previous_fn_AM();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Next_fn_DAB(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Next_fn_DAB();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Previous_fn_DAB(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Previous_fn_DAB();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Next_fn(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Next_fn();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Previous_fn(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Previous_fn();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Abort_Next_Previous_Icon_fn(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Abort_Next_Previous_Icon_fn();
#ifdef CIT_SIMULATION
bool CallAction_Notify_Init_Finished(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Notify_Init_Finished();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Main_Src_Select(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Main_Src_Select();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Tuner_Src_Select(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Tuner_Src_Select();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Home_Src_Toggle(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Home_Src_Toggle();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Send_Context(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Send_Context(Courier::UInt8 const & aContextScene);
#ifdef CIT_SIMULATION
bool CallAction_Perform_Tuner_Wx_fn(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Tuner_Wx_fn(Courier::Int32 const & aEventId);
#ifdef CIT_SIMULATION
bool CallAction_Perform_Stop_Next_Previous(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Stop_Next_Previous();
#ifdef CIT_SIMULATION
bool CallAction_Update_Preset_Focused(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Update_Preset_Focused();
#ifdef CIT_SIMULATION
bool CallAction_Update_FMPreset_Focused(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Update_FMPreset_Focused();
#ifdef CIT_SIMULATION
bool CallAction_Update_AMPreset_Focused(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Update_AMPreset_Focused();
#ifdef CIT_SIMULATION
bool CallAction_Update_Previous_View(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Update_Previous_View();
#ifdef CIT_SIMULATION
bool CallAction_gacChangeLanguageReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacChangeLanguageReq(enLanguageId const & aLanguageId);
#ifdef CIT_SIMULATION
bool CallAction_gacHideFocusInViewReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFocusInViewReq(::Courier::ViewId const & aView);
#ifdef CIT_SIMULATION
bool CallAction_NextLevelTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_NextLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PreviousLevelTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PreviousLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_DualViewLeftTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DualViewLeftTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_DualViewRightTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DualViewRightTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PageFlipBackTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PageFlipBackTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PageFlipFrontTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PageFlipFrontTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_ZoomInTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ZoomInTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
#ifdef CIT_SIMULATION
bool CallAction_ZoomOutTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ZoomOutTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
#ifdef CIT_SIMULATION
bool CallAction_FadeTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_FadeTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStartReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacWaitAnimationStartReq();
#ifdef CIT_SIMULATION
bool CallAction_acFocusOnRightEncoderReqUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acFocusOnRightEncoderReqUpd(bool const & aIsFocusUsed);
#ifdef CIT_SIMULATION
bool CallAction_acSetGadgetSceenActiveStatus(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetGadgetSceenActiveStatus(bool const & aIsGadgetAtive);
#ifdef CIT_SIMULATION
bool CallAction_acHKNotificationMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acHKNotificationMsg(Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseAllDropdowns(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_CloseAllDropdowns();
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_CloseDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_OpenDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_OpenDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_ToggleDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_ToggleDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acStartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStartAppPopupTimer(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout);
#ifdef CIT_SIMULATION
bool CallAction_acStopAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStopAppPopupTimer(Courier::UInt32 const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_acPostBeep(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPostBeep(Courier::Int32 const & aBeepType);
#ifdef CIT_SIMULATION
bool CallAction_gacCheckToClosePopup(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacCheckToClosePopup(Courier::UInt32 const & aPopupId);
#ifdef CIT_SIMULATION
bool CallAction_acRestartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acRestartAppPopupTimer(Courier::UInt32 const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchBackRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchBackRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchCompleteRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchCompleteRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchFailedRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchFailedRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchDoneRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchDoneRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchOutReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchOutReq(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId);
#ifdef CIT_SIMULATION
bool CallAction_gacCurrentScreenDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacCurrentScreenDisplayReq();
#ifdef CIT_SIMULATION
bool CallAction_gacLaunchBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacLaunchBarDisplayReq(bool const & aVisibility);
#ifdef CIT_SIMULATION
bool CallAction_gacNavTBTSwipe(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacNavTBTSwipe();
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListBtnRightEncoderChangeUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPerformListBtnRightEncoderChangeUpd(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId);
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListUp();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListDown();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollPageUp();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollPageDown();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListFocusUp(Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListFocusDown(Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListFocusLockDataResetUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPerformListFocusLockDataResetUpd();
#ifdef CIT_SIMULATION
bool CallAction_gacSetApplicationMode(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSetApplicationMode(Courier::UInt32 const & aModeId);
#ifdef CIT_SIMULATION
bool CallAction_gacSpellerBbehaviorReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSpellerBbehaviorReq(bool const & aEnable);
#ifdef CIT_SIMULATION
bool CallAction_gacStatusBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacStatusBarDisplayReq(bool const & aVisibility, Courier::Int32 const & aHeaderType);
#ifdef CIT_SIMULATION
bool CallAction_gacTBTRetriggerAcousticOutput(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacTBTRetriggerAcousticOutput();
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStopReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacWaitAnimationStopReq();
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAllReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateAllReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewDestroyReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewDestroyReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewClearReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewClearReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewHideReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateWithoutLoadReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateWithoutLoadReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewAsyncLoadReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewAsyncLoadReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewActivateWithoutRenderingReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupCreateAndSBShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupCreateAndSBShowReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupSBCloseReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupSBCloseReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupRestartTimerReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupRestartTimerReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAndShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateAndShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideAndDestroyReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewHideAndDestroyReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionEnter(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSceneTransitionEnter(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionLeave(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSceneTransitionLeave(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayStatusLineReq(Courier::Int32 const & aDisplayRegionType);
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideStatusLineReq(Courier::Int32 const & aDisplayRegionType);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayFooterLineReq();
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFooterLineReq();
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacRegisterForCloseOnTouchSession(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacDeregisterForCloseOnTouchSessionReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterPrioEnableReq(Courier::UInt32 const & aPrio);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterAllEnableReq();
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterDisableReq();
#ifdef CIT_SIMULATION
bool CallAction_gacProfileChange(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacProfileChange(Courier::UInt32 const & aProfile);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterPrioEnableReqForDisplay(Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterAllEnableReqForDisplay(Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterDisableReqForDisplay(Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacStartSceneTransitionAnimation(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacStartSceneTransitionAnimation(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2);
#ifdef CIT_SIMULATION
bool CallAction_gacDecrementActiveAnimationCount(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDecrementActiveAnimationCount();

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_fnGetVariantType(const ::Json::Value& parameters, ::Json::Value &response);
#endif
::FeatStd::UInt16 fnGetVariantType();

// overall number of HierarchyNodes
static const ::FeatStd::UInt32 cGlobalDataItemHierarchyNodeCount = 706;
// overall number of DataItemDescriptor nodes
static const ::FeatStd::UInt32 cDataItemDescriptorCount = 706;
// overall number of BindingSources
static const ::FeatStd::UInt32 cBindingSourceCount = 115;
// maximum number of HierarchyNodes in a BindingSource
static const ::FeatStd::UInt32 cBindingSourceItemCountMax = 27;

// =========================================================================

class CheckBoxListItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 1;
    static const ::Courier::DataItemKey cDataItemKey = 590;

    typedef ::CheckBoxListItemData Data;

    CheckBoxListItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< CheckBoxListItemDataBindingSource > CheckBoxListItemDataItemMsg;

// =========================================================================

class StationInfoSourceDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 27;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 2;
    static const ::Courier::DataItemKey cDataItemKey = 488;

    typedef ::StationInfoSourceData Data;

    StationInfoSourceDataBindingSource();
};

typedef ::Courier::DataItemMsg< StationInfoSourceDataBindingSource > StationInfoSourceDataItemMsg;

// =========================================================================

class HomeScreenInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 14;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 3;
    static const ::Courier::DataItemKey cDataItemKey = 602;

    typedef ::HomeScreenInfoData Data;

    HomeScreenInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< HomeScreenInfoDataBindingSource > HomeScreenInfoDataItemMsg;

// =========================================================================

class RadioBandInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 8;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 4;
    static const ::Courier::DataItemKey cDataItemKey = 190;

    typedef ::RadioBandInfoData Data;

    RadioBandInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< RadioBandInfoDataBindingSource > RadioBandInfoDataItemMsg;

// =========================================================================

class FMStationListDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 5;
    static const ::Courier::DataItemKey cDataItemKey = 42;

    typedef ::FMStationListData Data;

    FMStationListDataBindingSource();
};

typedef ::Courier::DataItemMsg< FMStationListDataBindingSource > FMStationListDataItemMsg;

// =========================================================================

class RDSOptionsDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 8;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 6;
    static const ::Courier::DataItemKey cDataItemKey = 476;

    typedef ::RDSOptionsData Data;

    RDSOptionsDataBindingSource();
};

typedef ::Courier::DataItemMsg< RDSOptionsDataBindingSource > RDSOptionsDataItemMsg;

// =========================================================================

class PresetInfoWBDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 13;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 7;
    static const ::Courier::DataItemKey cDataItemKey = 61;

    typedef ::PresetInfoWBData Data;

    PresetInfoWBDataBindingSource();
};

typedef ::Courier::DataItemMsg< PresetInfoWBDataBindingSource > PresetInfoWBDataItemMsg;

// =========================================================================

class WBPresetInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 11;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 8;
    static const ::Courier::DataItemKey cDataItemKey = 362;

    typedef ::WBPresetInfoData Data;

    WBPresetInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< WBPresetInfoDataBindingSource > WBPresetInfoDataItemMsg;

// =========================================================================

class PresetInfoFM1DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 9;
    static const ::Courier::DataItemKey cDataItemKey = 567;

    typedef ::PresetInfoFM1Data Data;

    PresetInfoFM1DataBindingSource();
};

typedef ::Courier::DataItemMsg< PresetInfoFM1DataBindingSource > PresetInfoFM1DataItemMsg;

// =========================================================================

class PresetInfoFM2DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 10;
    static const ::Courier::DataItemKey cDataItemKey = 606;

    typedef ::PresetInfoFM2Data Data;

    PresetInfoFM2DataBindingSource();
};

typedef ::Courier::DataItemMsg< PresetInfoFM2DataBindingSource > PresetInfoFM2DataItemMsg;

// =========================================================================

class PresetInfoFMASTDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 11;
    static const ::Courier::DataItemKey cDataItemKey = 555;

    typedef ::PresetInfoFMASTData Data;

    PresetInfoFMASTDataBindingSource();
};

typedef ::Courier::DataItemMsg< PresetInfoFMASTDataBindingSource > PresetInfoFMASTDataItemMsg;

// =========================================================================

class PresetInfoAMDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 13;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 12;
    static const ::Courier::DataItemKey cDataItemKey = 451;

    typedef ::PresetInfoAMData Data;

    PresetInfoAMDataBindingSource();
};

typedef ::Courier::DataItemMsg< PresetInfoAMDataBindingSource > PresetInfoAMDataItemMsg;

// =========================================================================

class PresetInfoAMASTDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 13;
    static const ::Courier::DataItemKey cDataItemKey = 664;

    typedef ::PresetInfoAMASTData Data;

    PresetInfoAMASTDataBindingSource();
};

typedef ::Courier::DataItemMsg< PresetInfoAMASTDataBindingSource > PresetInfoAMASTDataItemMsg;

// =========================================================================

class PresetInfoDABDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 13;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 14;
    static const ::Courier::DataItemKey cDataItemKey = 458;

    typedef ::PresetInfoDABData Data;

    PresetInfoDABDataBindingSource();
};

typedef ::Courier::DataItemMsg< PresetInfoDABDataBindingSource > PresetInfoDABDataItemMsg;

// =========================================================================

class PresetInfoDABASTDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 15;
    static const ::Courier::DataItemKey cDataItemKey = 44;

    typedef ::PresetInfoDABASTData Data;

    PresetInfoDABASTDataBindingSource();
};

typedef ::Courier::DataItemMsg< PresetInfoDABASTDataBindingSource > PresetInfoDABASTDataItemMsg;

// =========================================================================

class PresetInfoDRMDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 16;
    static const ::Courier::DataItemKey cDataItemKey = 111;

    typedef ::PresetInfoDRMData Data;

    PresetInfoDRMDataBindingSource();
};

typedef ::Courier::DataItemMsg< PresetInfoDRMDataBindingSource > PresetInfoDRMDataItemMsg;

// =========================================================================

class PresetInfoDRMASTDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 17;
    static const ::Courier::DataItemKey cDataItemKey = 398;

    typedef ::PresetInfoDRMASTData Data;

    PresetInfoDRMASTDataBindingSource();
};

typedef ::Courier::DataItemMsg< PresetInfoDRMASTDataBindingSource > PresetInfoDRMASTDataItemMsg;

// =========================================================================

class EngineeringInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 10;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 18;
    static const ::Courier::DataItemKey cDataItemKey = 537;

    typedef ::EngineeringInfoData Data;

    EngineeringInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< EngineeringInfoDataBindingSource > EngineeringInfoDataItemMsg;

// =========================================================================

class LayerNextPresets_FMDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 19;
    static const ::Courier::DataItemKey cDataItemKey = 643;

    typedef ::LayerNextPresets_FMData Data;

    LayerNextPresets_FMDataBindingSource();
};

typedef ::Courier::DataItemMsg< LayerNextPresets_FMDataBindingSource > LayerNextPresets_FMDataItemMsg;

// =========================================================================

class LayerNextPresets_AMDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 20;
    static const ::Courier::DataItemKey cDataItemKey = 331;

    typedef ::LayerNextPresets_AMData Data;

    LayerNextPresets_AMDataBindingSource();
};

typedef ::Courier::DataItemMsg< LayerNextPresets_AMDataBindingSource > LayerNextPresets_AMDataItemMsg;

// =========================================================================

class LayerNextPresets_DABDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 21;
    static const ::Courier::DataItemKey cDataItemKey = 639;

    typedef ::LayerNextPresets_DABData Data;

    LayerNextPresets_DABDataBindingSource();
};

typedef ::Courier::DataItemMsg< LayerNextPresets_DABDataBindingSource > LayerNextPresets_DABDataItemMsg;

// =========================================================================

class EngineeringInfo1DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 9;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 22;
    static const ::Courier::DataItemKey cDataItemKey = 280;

    typedef ::EngineeringInfo1Data Data;

    EngineeringInfo1DataBindingSource();
};

typedef ::Courier::DataItemMsg< EngineeringInfo1DataBindingSource > EngineeringInfo1DataItemMsg;

// =========================================================================

class EngineeringInfo2DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 16;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 23;
    static const ::Courier::DataItemKey cDataItemKey = 428;

    typedef ::EngineeringInfo2Data Data;

    EngineeringInfo2DataBindingSource();
};

typedef ::Courier::DataItemMsg< EngineeringInfo2DataBindingSource > EngineeringInfo2DataItemMsg;

// =========================================================================

class EngineeringInfoDRMDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 25;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 24;
    static const ::Courier::DataItemKey cDataItemKey = 184;

    typedef ::EngineeringInfoDRMData Data;

    EngineeringInfoDRMDataBindingSource();
};

typedef ::Courier::DataItemMsg< EngineeringInfoDRMDataBindingSource > EngineeringInfoDRMDataItemMsg;

// =========================================================================

class Scan_ASTDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 6;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 25;
    static const ::Courier::DataItemKey cDataItemKey = 129;

    typedef ::Scan_ASTData Data;

    Scan_ASTDataBindingSource();
};

typedef ::Courier::DataItemMsg< Scan_ASTDataBindingSource > Scan_ASTDataItemMsg;

// =========================================================================

class Scan_StatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 26;
    static const ::Courier::DataItemKey cDataItemKey = 698;

    typedef ::Scan_StatusData Data;

    Scan_StatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< Scan_StatusDataBindingSource > Scan_StatusDataItemMsg;

// =========================================================================

class Source_SlectionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 10;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 27;
    static const ::Courier::DataItemKey cDataItemKey = 115;

    typedef ::Source_SlectionData Data;

    Source_SlectionDataBindingSource();
};

typedef ::Courier::DataItemMsg< Source_SlectionDataBindingSource > Source_SlectionDataItemMsg;

// =========================================================================

class Preset_PopupDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 8;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 28;
    static const ::Courier::DataItemKey cDataItemKey = 150;

    typedef ::Preset_PopupData Data;

    Preset_PopupDataBindingSource();
};

typedef ::Courier::DataItemMsg< Preset_PopupDataBindingSource > Preset_PopupDataItemMsg;

// =========================================================================

class PgBar_timerDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 29;
    static const ::Courier::DataItemKey cDataItemKey = 4;

    typedef ::PgBar_timerData Data;

    PgBar_timerDataBindingSource();
};

typedef ::Courier::DataItemMsg< PgBar_timerDataBindingSource > PgBar_timerDataItemMsg;

// =========================================================================

class tuningScale_SliderMarkerPositionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 30;
    static const ::Courier::DataItemKey cDataItemKey = 505;

    typedef ::tuningScale_SliderMarkerPositionData Data;

    tuningScale_SliderMarkerPositionDataBindingSource();
};

typedef ::Courier::DataItemMsg< tuningScale_SliderMarkerPositionDataBindingSource > tuningScale_SliderMarkerPositionDataItemMsg;

// =========================================================================

class tuningSliderDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 12;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 31;
    static const ::Courier::DataItemKey cDataItemKey = 438;

    typedef ::tuningSliderData Data;

    tuningSliderDataBindingSource();
};

typedef ::Courier::DataItemMsg< tuningSliderDataBindingSource > tuningSliderDataItemMsg;

// =========================================================================

class TunerOptionsDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 11;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 32;
    static const ::Courier::DataItemKey cDataItemKey = 15;

    typedef ::TunerOptionsData Data;

    TunerOptionsDataBindingSource();
};

typedef ::Courier::DataItemMsg< TunerOptionsDataBindingSource > TunerOptionsDataItemMsg;

// =========================================================================

class DABOptionsDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 33;
    static const ::Courier::DataItemKey cDataItemKey = 336;

    typedef ::DABOptionsData Data;

    DABOptionsDataBindingSource();
};

typedef ::Courier::DataItemMsg< DABOptionsDataBindingSource > DABOptionsDataItemMsg;

// =========================================================================

class DRMOptionsDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 34;
    static const ::Courier::DataItemKey cDataItemKey = 375;

    typedef ::DRMOptionsData Data;

    DRMOptionsDataBindingSource();
};

typedef ::Courier::DataItemMsg< DRMOptionsDataBindingSource > DRMOptionsDataItemMsg;

// =========================================================================

class MenuSelectionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 35;
    static const ::Courier::DataItemKey cDataItemKey = 54;

    typedef ::MenuSelectionData Data;

    MenuSelectionDataBindingSource();
};

typedef ::Courier::DataItemMsg< MenuSelectionDataBindingSource > MenuSelectionDataItemMsg;

// =========================================================================

class Menu_NumOptionsDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 36;
    static const ::Courier::DataItemKey cDataItemKey = 447;

    typedef ::Menu_NumOptionsData Data;

    Menu_NumOptionsDataBindingSource();
};

typedef ::Courier::DataItemMsg< Menu_NumOptionsDataBindingSource > Menu_NumOptionsDataItemMsg;

// =========================================================================

class AppFlyInDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 14;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 37;
    static const ::Courier::DataItemKey cDataItemKey = 261;

    typedef ::AppFlyInData Data;

    AppFlyInDataBindingSource();
};

typedef ::Courier::DataItemMsg< AppFlyInDataBindingSource > AppFlyInDataItemMsg;

// =========================================================================

class BrowseListPointerDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 1;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 38;
    static const ::Courier::DataItemKey cDataItemKey = 101;

    typedef ::BrowseListPointerData Data;

    BrowseListPointerDataBindingSource();
};

typedef ::Courier::DataItemMsg< BrowseListPointerDataBindingSource > BrowseListPointerDataItemMsg;

// =========================================================================

class BrowseListSizeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 11;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 39;
    static const ::Courier::DataItemKey cDataItemKey = 392;

    typedef ::BrowseListSizeData Data;

    BrowseListSizeDataBindingSource();
};

typedef ::Courier::DataItemMsg< BrowseListSizeDataBindingSource > BrowseListSizeDataItemMsg;

// =========================================================================

class BrowseListSelectedLineDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 6;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 40;
    static const ::Courier::DataItemKey cDataItemKey = 204;

    typedef ::BrowseListSelectedLineData Data;

    BrowseListSelectedLineDataBindingSource();
};

typedef ::Courier::DataItemMsg< BrowseListSelectedLineDataBindingSource > BrowseListSelectedLineDataItemMsg;

// =========================================================================

class DABChannelInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 41;
    static const ::Courier::DataItemKey cDataItemKey = 301;

    typedef ::DABChannelInfoData Data;

    DABChannelInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< DABChannelInfoDataBindingSource > DABChannelInfoDataItemMsg;

// =========================================================================

class ActiveBankInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 10;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 42;
    static const ::Courier::DataItemKey cDataItemKey = 238;

    typedef ::ActiveBankInfoData Data;

    ActiveBankInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< ActiveBankInfoDataBindingSource > ActiveBankInfoDataItemMsg;

// =========================================================================

class ActiveSourceInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 43;
    static const ::Courier::DataItemKey cDataItemKey = 197;

    typedef ::ActiveSourceInfoData Data;

    ActiveSourceInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< ActiveSourceInfoDataBindingSource > ActiveSourceInfoDataItemMsg;

// =========================================================================

class VariantInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 9;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 44;
    static const ::Courier::DataItemKey cDataItemKey = 49;

    typedef ::VariantInfoData Data;

    VariantInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< VariantInfoDataBindingSource > VariantInfoDataItemMsg;

// =========================================================================

class TAInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 45;
    static const ::Courier::DataItemKey cDataItemKey = 324;

    typedef ::TAInfoData Data;

    TAInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< TAInfoDataBindingSource > TAInfoDataItemMsg;

// =========================================================================

class DABPresetInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 13;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 46;
    static const ::Courier::DataItemKey cDataItemKey = 487;

    typedef ::DABPresetInfoData Data;

    DABPresetInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< DABPresetInfoDataBindingSource > DABPresetInfoDataItemMsg;

// =========================================================================

class FMAMPresetInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 13;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 47;
    static const ::Courier::DataItemKey cDataItemKey = 692;

    typedef ::FMAMPresetInfoData Data;

    FMAMPresetInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< FMAMPresetInfoDataBindingSource > FMAMPresetInfoDataItemMsg;

// =========================================================================

class AMPresetInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 13;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 48;
    static const ::Courier::DataItemKey cDataItemKey = 374;

    typedef ::AMPresetInfoData Data;

    AMPresetInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< AMPresetInfoDataBindingSource > AMPresetInfoDataItemMsg;

// =========================================================================

class Tuner1DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 15;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 49;
    static const ::Courier::DataItemKey cDataItemKey = 397;

    typedef ::Tuner1Data Data;

    Tuner1DataBindingSource();
};

typedef ::Courier::DataItemMsg< Tuner1DataBindingSource > Tuner1DataItemMsg;

// =========================================================================

class Tuner2DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 15;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 50;
    static const ::Courier::DataItemKey cDataItemKey = 295;

    typedef ::Tuner2Data Data;

    Tuner2DataBindingSource();
};

typedef ::Courier::DataItemMsg< Tuner2DataBindingSource > Tuner2DataItemMsg;

// =========================================================================

class Tuner3DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 15;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 51;
    static const ::Courier::DataItemKey cDataItemKey = 344;

    typedef ::Tuner3Data Data;

    Tuner3DataBindingSource();
};

typedef ::Courier::DataItemMsg< Tuner3DataBindingSource > Tuner3DataItemMsg;

// =========================================================================

class Tuner4DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 15;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 52;
    static const ::Courier::DataItemKey cDataItemKey = 672;

    typedef ::Tuner4Data Data;

    Tuner4DataBindingSource();
};

typedef ::Courier::DataItemMsg< Tuner4DataBindingSource > Tuner4DataItemMsg;

// =========================================================================

class TunerSource_BandDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 13;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 53;
    static const ::Courier::DataItemKey cDataItemKey = 199;

    typedef ::TunerSource_BandData Data;

    TunerSource_BandDataBindingSource();
};

typedef ::Courier::DataItemMsg< TunerSource_BandDataBindingSource > TunerSource_BandDataItemMsg;

// =========================================================================

class DAB_Setup_ScreenDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 54;
    static const ::Courier::DataItemKey cDataItemKey = 479;

    typedef ::DAB_Setup_ScreenData Data;

    DAB_Setup_ScreenDataBindingSource();
};

typedef ::Courier::DataItemMsg< DAB_Setup_ScreenDataBindingSource > DAB_Setup_ScreenDataItemMsg;

// =========================================================================

class DAB_Test_ModeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 25;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 55;
    static const ::Courier::DataItemKey cDataItemKey = 227;

    typedef ::DAB_Test_ModeData Data;

    DAB_Test_ModeDataBindingSource();
};

typedef ::Courier::DataItemMsg< DAB_Test_ModeDataBindingSource > DAB_Test_ModeDataItemMsg;

// =========================================================================

class DAB_Setup_Screen_ActiveTuner_InfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 6;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 56;
    static const ::Courier::DataItemKey cDataItemKey = 243;

    typedef ::DAB_Setup_Screen_ActiveTuner_InfoData Data;

    DAB_Setup_Screen_ActiveTuner_InfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< DAB_Setup_Screen_ActiveTuner_InfoDataBindingSource > DAB_Setup_Screen_ActiveTuner_InfoDataItemMsg;

// =========================================================================

class DABTestModeEnsembleInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 57;
    static const ::Courier::DataItemKey cDataItemKey = 541;

    typedef ::DABTestModeEnsembleInfoData Data;

    DABTestModeEnsembleInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< DABTestModeEnsembleInfoDataBindingSource > DABTestModeEnsembleInfoDataItemMsg;

// =========================================================================

class DABGTestModeInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 5;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 58;
    static const ::Courier::DataItemKey cDataItemKey = 558;

    typedef ::DABGTestModeInfoData Data;

    DABGTestModeInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< DABGTestModeInfoDataBindingSource > DABGTestModeInfoDataItemMsg;

// =========================================================================

class DABGTestModeAnnoStatusInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 59;
    static const ::Courier::DataItemKey cDataItemKey = 642;

    typedef ::DABGTestModeAnnoStatusInfoData Data;

    DABGTestModeAnnoStatusInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< DABGTestModeAnnoStatusInfoDataBindingSource > DABGTestModeAnnoStatusInfoDataItemMsg;

// =========================================================================

class DABGTestModeActiveCompDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 60;
    static const ::Courier::DataItemKey cDataItemKey = 562;

    typedef ::DABGTestModeActiveCompData Data;

    DABGTestModeActiveCompDataBindingSource();
};

typedef ::Courier::DataItemMsg< DABGTestModeActiveCompDataBindingSource > DABGTestModeActiveCompDataItemMsg;

// =========================================================================

class DABTestModeGAvailabiltyInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 61;
    static const ::Courier::DataItemKey cDataItemKey = 557;

    typedef ::DABTestModeGAvailabiltyInfoData Data;

    DABTestModeGAvailabiltyInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< DABTestModeGAvailabiltyInfoDataBindingSource > DABTestModeGAvailabiltyInfoDataItemMsg;

// =========================================================================

class DABTestModeServiceFollowingInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 62;
    static const ::Courier::DataItemKey cDataItemKey = 460;

    typedef ::DABTestModeServiceFollowingInfoData Data;

    DABTestModeServiceFollowingInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< DABTestModeServiceFollowingInfoDataBindingSource > DABTestModeServiceFollowingInfoDataItemMsg;

// =========================================================================

class TmcInformationDataDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 63;
    static const ::Courier::DataItemKey cDataItemKey = 381;

    typedef ::TmcInformationDataData Data;

    TmcInformationDataDataBindingSource();
};

typedef ::Courier::DataItemMsg< TmcInformationDataDataBindingSource > TmcInformationDataDataItemMsg;

// =========================================================================

class TmcStationInfoDataDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 64;
    static const ::Courier::DataItemKey cDataItemKey = 377;

    typedef ::TmcStationInfoDataData Data;

    TmcStationInfoDataDataBindingSource();
};

typedef ::Courier::DataItemMsg< TmcStationInfoDataDataBindingSource > TmcStationInfoDataDataItemMsg;

// =========================================================================

class TestModeAvailabilityInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 65;
    static const ::Courier::DataItemKey cDataItemKey = 563;

    typedef ::TestModeAvailabilityInfoData Data;

    TestModeAvailabilityInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< TestModeAvailabilityInfoDataBindingSource > TestModeAvailabilityInfoDataItemMsg;

// =========================================================================

class FMSetupMenuInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 6;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 66;
    static const ::Courier::DataItemKey cDataItemKey = 221;

    typedef ::FMSetupMenuInfoData Data;

    FMSetupMenuInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< FMSetupMenuInfoDataBindingSource > FMSetupMenuInfoDataItemMsg;

// =========================================================================

class NextPrevious_Status_FMDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 67;
    static const ::Courier::DataItemKey cDataItemKey = 411;

    typedef ::NextPrevious_Status_FMData Data;

    NextPrevious_Status_FMDataBindingSource();
};

typedef ::Courier::DataItemMsg< NextPrevious_Status_FMDataBindingSource > NextPrevious_Status_FMDataItemMsg;

// =========================================================================

class NextPrevious_Status_AMDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 68;
    static const ::Courier::DataItemKey cDataItemKey = 456;

    typedef ::NextPrevious_Status_AMData Data;

    NextPrevious_Status_AMDataBindingSource();
};

typedef ::Courier::DataItemMsg< NextPrevious_Status_AMDataBindingSource > NextPrevious_Status_AMDataItemMsg;

// =========================================================================

class NextPrevious_Status_DABDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 69;
    static const ::Courier::DataItemKey cDataItemKey = 113;

    typedef ::NextPrevious_Status_DABData Data;

    NextPrevious_Status_DABDataBindingSource();
};

typedef ::Courier::DataItemMsg< NextPrevious_Status_DABDataBindingSource > NextPrevious_Status_DABDataItemMsg;

// =========================================================================

class SearchNextPrevious_IconActiveDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 70;
    static const ::Courier::DataItemKey cDataItemKey = 414;

    typedef ::SearchNextPrevious_IconActiveData Data;

    SearchNextPrevious_IconActiveDataBindingSource();
};

typedef ::Courier::DataItemMsg< SearchNextPrevious_IconActiveDataBindingSource > SearchNextPrevious_IconActiveDataItemMsg;

// =========================================================================

class AMFMLogoImageDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 71;
    static const ::Courier::DataItemKey cDataItemKey = 544;

    typedef ::AMFMLogoImageData Data;

    AMFMLogoImageDataBindingSource();
};

typedef ::Courier::DataItemMsg< AMFMLogoImageDataBindingSource > AMFMLogoImageDataItemMsg;

// =========================================================================

class ChannelInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 8;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 72;
    static const ::Courier::DataItemKey cDataItemKey = 31;

    typedef ::ChannelInfoData Data;

    ChannelInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< ChannelInfoDataBindingSource > ChannelInfoDataItemMsg;

// =========================================================================

class FmHdLogoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 73;
    static const ::Courier::DataItemKey cDataItemKey = 694;

    typedef ::FmHdLogoData Data;

    FmHdLogoDataBindingSource();
};

typedef ::Courier::DataItemMsg< FmHdLogoDataBindingSource > FmHdLogoDataItemMsg;

// =========================================================================

class AmHdLogoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 74;
    static const ::Courier::DataItemKey cDataItemKey = 237;

    typedef ::AmHdLogoData Data;

    AmHdLogoDataBindingSource();
};

typedef ::Courier::DataItemMsg< AmHdLogoDataBindingSource > AmHdLogoDataItemMsg;

// =========================================================================

class HDButtonVisibilityDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 75;
    static const ::Courier::DataItemKey cDataItemKey = 345;

    typedef ::HDButtonVisibilityData Data;

    HDButtonVisibilityDataBindingSource();
};

typedef ::Courier::DataItemMsg< HDButtonVisibilityDataBindingSource > HDButtonVisibilityDataItemMsg;

// =========================================================================

class AmHdOnOffDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 76;
    static const ::Courier::DataItemKey cDataItemKey = 38;

    typedef ::AmHdOnOffData Data;

    AmHdOnOffDataBindingSource();
};

typedef ::Courier::DataItemMsg< AmHdOnOffDataBindingSource > AmHdOnOffDataItemMsg;

// =========================================================================

class FmHdOnOffDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 77;
    static const ::Courier::DataItemKey cDataItemKey = 427;

    typedef ::FmHdOnOffData Data;

    FmHdOnOffDataBindingSource();
};

typedef ::Courier::DataItemMsg< FmHdOnOffDataBindingSource > FmHdOnOffDataItemMsg;

// =========================================================================

class HDProgramListVisibilityDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 78;
    static const ::Courier::DataItemKey cDataItemKey = 587;

    typedef ::HDProgramListVisibilityData Data;

    HDProgramListVisibilityDataBindingSource();
};

typedef ::Courier::DataItemMsg< HDProgramListVisibilityDataBindingSource > HDProgramListVisibilityDataItemMsg;

// =========================================================================

class HDAudioMPSDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 79;
    static const ::Courier::DataItemKey cDataItemKey = 47;

    typedef ::HDAudioMPSData Data;

    HDAudioMPSDataBindingSource();
};

typedef ::Courier::DataItemMsg< HDAudioMPSDataBindingSource > HDAudioMPSDataItemMsg;

// =========================================================================

class HDAudioSPS1DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 80;
    static const ::Courier::DataItemKey cDataItemKey = 165;

    typedef ::HDAudioSPS1Data Data;

    HDAudioSPS1DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDAudioSPS1DataBindingSource > HDAudioSPS1DataItemMsg;

// =========================================================================

class HDAudioSPS2DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 81;
    static const ::Courier::DataItemKey cDataItemKey = 201;

    typedef ::HDAudioSPS2Data Data;

    HDAudioSPS2DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDAudioSPS2DataBindingSource > HDAudioSPS2DataItemMsg;

// =========================================================================

class HDAudioSPS3DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 82;
    static const ::Courier::DataItemKey cDataItemKey = 249;

    typedef ::HDAudioSPS3Data Data;

    HDAudioSPS3DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDAudioSPS3DataBindingSource > HDAudioSPS3DataItemMsg;

// =========================================================================

class HDAudioSPS4DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 83;
    static const ::Courier::DataItemKey cDataItemKey = 306;

    typedef ::HDAudioSPS4Data Data;

    HDAudioSPS4DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDAudioSPS4DataBindingSource > HDAudioSPS4DataItemMsg;

// =========================================================================

class HDAudioSPS5DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 84;
    static const ::Courier::DataItemKey cDataItemKey = 357;

    typedef ::HDAudioSPS5Data Data;

    HDAudioSPS5DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDAudioSPS5DataBindingSource > HDAudioSPS5DataItemMsg;

// =========================================================================

class HDAudioSPS6DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 85;
    static const ::Courier::DataItemKey cDataItemKey = 378;

    typedef ::HDAudioSPS6Data Data;

    HDAudioSPS6DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDAudioSPS6DataBindingSource > HDAudioSPS6DataItemMsg;

// =========================================================================

class HDAudioSPS7DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 86;
    static const ::Courier::DataItemKey cDataItemKey = 435;

    typedef ::HDAudioSPS7Data Data;

    HDAudioSPS7DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDAudioSPS7DataBindingSource > HDAudioSPS7DataItemMsg;

// =========================================================================

class HDIconPreset1DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 87;
    static const ::Courier::DataItemKey cDataItemKey = 503;

    typedef ::HDIconPreset1Data Data;

    HDIconPreset1DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDIconPreset1DataBindingSource > HDIconPreset1DataItemMsg;

// =========================================================================

class HDIconPreset2DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 88;
    static const ::Courier::DataItemKey cDataItemKey = 582;

    typedef ::HDIconPreset2Data Data;

    HDIconPreset2DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDIconPreset2DataBindingSource > HDIconPreset2DataItemMsg;

// =========================================================================

class HDIconPreset3DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 89;
    static const ::Courier::DataItemKey cDataItemKey = 614;

    typedef ::HDIconPreset3Data Data;

    HDIconPreset3DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDIconPreset3DataBindingSource > HDIconPreset3DataItemMsg;

// =========================================================================

class HDIconPreset4DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 90;
    static const ::Courier::DataItemKey cDataItemKey = 649;

    typedef ::HDIconPreset4Data Data;

    HDIconPreset4DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDIconPreset4DataBindingSource > HDIconPreset4DataItemMsg;

// =========================================================================

class HDIconPreset5DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 91;
    static const ::Courier::DataItemKey cDataItemKey = 652;

    typedef ::HDIconPreset5Data Data;

    HDIconPreset5DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDIconPreset5DataBindingSource > HDIconPreset5DataItemMsg;

// =========================================================================

class HDIconPreset6DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 92;
    static const ::Courier::DataItemKey cDataItemKey = 611;

    typedef ::HDIconPreset6Data Data;

    HDIconPreset6DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDIconPreset6DataBindingSource > HDIconPreset6DataItemMsg;

// =========================================================================

class HDIconPreset7DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 93;
    static const ::Courier::DataItemKey cDataItemKey = 103;

    typedef ::HDIconPreset7Data Data;

    HDIconPreset7DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDIconPreset7DataBindingSource > HDIconPreset7DataItemMsg;

// =========================================================================

class HDIconPreset8DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 94;
    static const ::Courier::DataItemKey cDataItemKey = 704;

    typedef ::HDIconPreset8Data Data;

    HDIconPreset8DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDIconPreset8DataBindingSource > HDIconPreset8DataItemMsg;

// =========================================================================

class HDIconPreset9DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 95;
    static const ::Courier::DataItemKey cDataItemKey = 514;

    typedef ::HDIconPreset9Data Data;

    HDIconPreset9DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDIconPreset9DataBindingSource > HDIconPreset9DataItemMsg;

// =========================================================================

class HDIconPreset10DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 96;
    static const ::Courier::DataItemKey cDataItemKey = 222;

    typedef ::HDIconPreset10Data Data;

    HDIconPreset10DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDIconPreset10DataBindingSource > HDIconPreset10DataItemMsg;

// =========================================================================

class HDIconPreset11DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 97;
    static const ::Courier::DataItemKey cDataItemKey = 550;

    typedef ::HDIconPreset11Data Data;

    HDIconPreset11DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDIconPreset11DataBindingSource > HDIconPreset11DataItemMsg;

// =========================================================================

class HDIconPreset12DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 98;
    static const ::Courier::DataItemKey cDataItemKey = 677;

    typedef ::HDIconPreset12Data Data;

    HDIconPreset12DataBindingSource();
};

typedef ::Courier::DataItemMsg< HDIconPreset12DataBindingSource > HDIconPreset12DataItemMsg;

// =========================================================================

class DtmHDDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 14;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 99;
    static const ::Courier::DataItemKey cDataItemKey = 662;

    typedef ::DtmHDData Data;

    DtmHDDataBindingSource();
};

typedef ::Courier::DataItemMsg< DtmHDDataBindingSource > DtmHDDataItemMsg;

// =========================================================================

class HDParamTuningIconDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 100;
    static const ::Courier::DataItemKey cDataItemKey = 298;

    typedef ::HDParamTuningIconData Data;

    HDParamTuningIconDataBindingSource();
};

typedef ::Courier::DataItemMsg< HDParamTuningIconDataBindingSource > HDParamTuningIconDataItemMsg;

// =========================================================================

class TMHDAudioMPSDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 101;
    static const ::Courier::DataItemKey cDataItemKey = 192;

    typedef ::TMHDAudioMPSData Data;

    TMHDAudioMPSDataBindingSource();
};

typedef ::Courier::DataItemMsg< TMHDAudioMPSDataBindingSource > TMHDAudioMPSDataItemMsg;

// =========================================================================

class TMHDAudioSPS1DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 102;
    static const ::Courier::DataItemKey cDataItemKey = 186;

    typedef ::TMHDAudioSPS1Data Data;

    TMHDAudioSPS1DataBindingSource();
};

typedef ::Courier::DataItemMsg< TMHDAudioSPS1DataBindingSource > TMHDAudioSPS1DataItemMsg;

// =========================================================================

class TMHDAudioSPS2DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 103;
    static const ::Courier::DataItemKey cDataItemKey = 621;

    typedef ::TMHDAudioSPS2Data Data;

    TMHDAudioSPS2DataBindingSource();
};

typedef ::Courier::DataItemMsg< TMHDAudioSPS2DataBindingSource > TMHDAudioSPS2DataItemMsg;

// =========================================================================

class TMHDAudioSPS3DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 104;
    static const ::Courier::DataItemKey cDataItemKey = 575;

    typedef ::TMHDAudioSPS3Data Data;

    TMHDAudioSPS3DataBindingSource();
};

typedef ::Courier::DataItemMsg< TMHDAudioSPS3DataBindingSource > TMHDAudioSPS3DataItemMsg;

// =========================================================================

class TMHDAudioSPS4DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 105;
    static const ::Courier::DataItemKey cDataItemKey = 682;

    typedef ::TMHDAudioSPS4Data Data;

    TMHDAudioSPS4DataBindingSource();
};

typedef ::Courier::DataItemMsg< TMHDAudioSPS4DataBindingSource > TMHDAudioSPS4DataItemMsg;

// =========================================================================

class TMHDAudioSPS5DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 106;
    static const ::Courier::DataItemKey cDataItemKey = 634;

    typedef ::TMHDAudioSPS5Data Data;

    TMHDAudioSPS5DataBindingSource();
};

typedef ::Courier::DataItemMsg< TMHDAudioSPS5DataBindingSource > TMHDAudioSPS5DataItemMsg;

// =========================================================================

class TMHDAudioSPS6DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 107;
    static const ::Courier::DataItemKey cDataItemKey = 440;

    typedef ::TMHDAudioSPS6Data Data;

    TMHDAudioSPS6DataBindingSource();
};

typedef ::Courier::DataItemMsg< TMHDAudioSPS6DataBindingSource > TMHDAudioSPS6DataItemMsg;

// =========================================================================

class TMHDAudioSPS7DataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 108;
    static const ::Courier::DataItemKey cDataItemKey = 27;

    typedef ::TMHDAudioSPS7Data Data;

    TMHDAudioSPS7DataBindingSource();
};

typedef ::Courier::DataItemMsg< TMHDAudioSPS7DataBindingSource > TMHDAudioSPS7DataItemMsg;

// =========================================================================

class RdsRadioTextDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 109;
    static const ::Courier::DataItemKey cDataItemKey = 291;

    typedef ::RdsRadioTextData Data;

    RdsRadioTextDataBindingSource();
};

typedef ::Courier::DataItemMsg< RdsRadioTextDataBindingSource > RdsRadioTextDataItemMsg;

// =========================================================================

class HomeScreenFmHdLogoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 110;
    static const ::Courier::DataItemKey cDataItemKey = 607;

    typedef ::HomeScreenFmHdLogoData Data;

    HomeScreenFmHdLogoDataBindingSource();
};

typedef ::Courier::DataItemMsg< HomeScreenFmHdLogoDataBindingSource > HomeScreenFmHdLogoDataItemMsg;

// =========================================================================

class HomeScreenAmHdLogoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 111;
    static const ::Courier::DataItemKey cDataItemKey = 601;

    typedef ::HomeScreenAmHdLogoData Data;

    HomeScreenAmHdLogoDataBindingSource();
};

typedef ::Courier::DataItemMsg< HomeScreenAmHdLogoDataBindingSource > HomeScreenAmHdLogoDataItemMsg;

// =========================================================================

class SPIVisibilityTunerDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 112;
    static const ::Courier::DataItemKey cDataItemKey = 276;

    typedef ::SPIVisibilityTunerData Data;

    SPIVisibilityTunerDataBindingSource();
};

typedef ::Courier::DataItemMsg< SPIVisibilityTunerDataBindingSource > SPIVisibilityTunerDataItemMsg;

// =========================================================================

class ListScrollBarInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 113;
    static const ::Courier::DataItemKey cDataItemKey = 212;

    typedef ::ListScrollBarInfoData Data;

    ListScrollBarInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< ListScrollBarInfoDataBindingSource > ListScrollBarInfoDataItemMsg;

// =========================================================================

class CarModeVisibilityDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 114;
    static const ::Courier::DataItemKey cDataItemKey = 21;

    typedef ::CarModeVisibilityData Data;

    CarModeVisibilityDataBindingSource();
};

typedef ::Courier::DataItemMsg< CarModeVisibilityDataBindingSource > CarModeVisibilityDataItemMsg;

namespace ItemKey {
        static const ::Courier::DataItemKey InvalidItem = 0;
        static const ::Courier::DataItemKey PgBar_timerItem = 4;
        static const ::Courier::DataItemKey TunerOptionsItem = 15;
        static const ::Courier::DataItemKey CarModeVisibilityItem = 21;
        static const ::Courier::DataItemKey TMHDAudioSPS7Item = 27;
        static const ::Courier::DataItemKey ChannelInfoItem = 31;
        static const ::Courier::DataItemKey AmHdOnOffItem = 38;
        static const ::Courier::DataItemKey FMStationListItem = 42;
        static const ::Courier::DataItemKey PresetInfoDABASTItem = 44;
        static const ::Courier::DataItemKey HDAudioMPSItem = 47;
        static const ::Courier::DataItemKey VariantInfoItem = 49;
        static const ::Courier::DataItemKey MenuSelectionItem = 54;
        static const ::Courier::DataItemKey PresetInfoWBItem = 61;
        static const ::Courier::DataItemKey BrowseListPointerItem = 101;
        static const ::Courier::DataItemKey HDIconPreset7Item = 103;
        static const ::Courier::DataItemKey PresetInfoDRMItem = 111;
        static const ::Courier::DataItemKey NextPrevious_Status_DABItem = 113;
        static const ::Courier::DataItemKey Source_SlectionItem = 115;
        static const ::Courier::DataItemKey Scan_ASTItem = 129;
        static const ::Courier::DataItemKey Preset_PopupItem = 150;
        static const ::Courier::DataItemKey HDAudioSPS1Item = 165;
        static const ::Courier::DataItemKey EngineeringInfoDRMItem = 184;
        static const ::Courier::DataItemKey TMHDAudioSPS1Item = 186;
        static const ::Courier::DataItemKey RadioBandInfoItem = 190;
        static const ::Courier::DataItemKey TMHDAudioMPSItem = 192;
        static const ::Courier::DataItemKey ActiveSourceInfoItem = 197;
        static const ::Courier::DataItemKey TunerSource_BandItem = 199;
        static const ::Courier::DataItemKey HDAudioSPS2Item = 201;
        static const ::Courier::DataItemKey BrowseListSelectedLineItem = 204;
        static const ::Courier::DataItemKey ListScrollBarInfoItem = 212;
        static const ::Courier::DataItemKey FMSetupMenuInfoItem = 221;
        static const ::Courier::DataItemKey HDIconPreset10Item = 222;
        static const ::Courier::DataItemKey DAB_Test_ModeItem = 227;
        static const ::Courier::DataItemKey AmHdLogoItem = 237;
        static const ::Courier::DataItemKey ActiveBankInfoItem = 238;
        static const ::Courier::DataItemKey DAB_Setup_Screen_ActiveTuner_InfoItem = 243;
        static const ::Courier::DataItemKey HDAudioSPS3Item = 249;
        static const ::Courier::DataItemKey AppFlyInItem = 261;
        static const ::Courier::DataItemKey SPIVisibilityTunerItem = 276;
        static const ::Courier::DataItemKey EngineeringInfo1Item = 280;
        static const ::Courier::DataItemKey RdsRadioTextItem = 291;
        static const ::Courier::DataItemKey Tuner2Item = 295;
        static const ::Courier::DataItemKey HDParamTuningIconItem = 298;
        static const ::Courier::DataItemKey DABChannelInfoItem = 301;
        static const ::Courier::DataItemKey HDAudioSPS4Item = 306;
        static const ::Courier::DataItemKey TAInfoItem = 324;
        static const ::Courier::DataItemKey LayerNextPresets_AMItem = 331;
        static const ::Courier::DataItemKey DABOptionsItem = 336;
        static const ::Courier::DataItemKey Tuner3Item = 344;
        static const ::Courier::DataItemKey HDButtonVisibilityItem = 345;
        static const ::Courier::DataItemKey HDAudioSPS5Item = 357;
        static const ::Courier::DataItemKey WBPresetInfoItem = 362;
        static const ::Courier::DataItemKey AMPresetInfoItem = 374;
        static const ::Courier::DataItemKey DRMOptionsItem = 375;
        static const ::Courier::DataItemKey TmcStationInfoDataItem = 377;
        static const ::Courier::DataItemKey HDAudioSPS6Item = 378;
        static const ::Courier::DataItemKey TmcInformationDataItem = 381;
        static const ::Courier::DataItemKey BrowseListSizeItem = 392;
        static const ::Courier::DataItemKey Tuner1Item = 397;
        static const ::Courier::DataItemKey PresetInfoDRMASTItem = 398;
        static const ::Courier::DataItemKey NextPrevious_Status_FMItem = 411;
        static const ::Courier::DataItemKey SearchNextPrevious_IconActiveItem = 414;
        static const ::Courier::DataItemKey FmHdOnOffItem = 427;
        static const ::Courier::DataItemKey EngineeringInfo2Item = 428;
        static const ::Courier::DataItemKey HDAudioSPS7Item = 435;
        static const ::Courier::DataItemKey tuningSliderItem = 438;
        static const ::Courier::DataItemKey TMHDAudioSPS6Item = 440;
        static const ::Courier::DataItemKey Menu_NumOptionsItem = 447;
        static const ::Courier::DataItemKey PresetInfoAMItem = 451;
        static const ::Courier::DataItemKey NextPrevious_Status_AMItem = 456;
        static const ::Courier::DataItemKey PresetInfoDABItem = 458;
        static const ::Courier::DataItemKey DABTestModeServiceFollowingInfoItem = 460;
        static const ::Courier::DataItemKey RDSOptionsItem = 476;
        static const ::Courier::DataItemKey DAB_Setup_ScreenItem = 479;
        static const ::Courier::DataItemKey DABPresetInfoItem = 487;
        static const ::Courier::DataItemKey StationInfoSourceItem = 488;
        static const ::Courier::DataItemKey HDIconPreset1Item = 503;
        static const ::Courier::DataItemKey tuningScale_SliderMarkerPositionItem = 505;
        static const ::Courier::DataItemKey HDIconPreset9Item = 514;
        static const ::Courier::DataItemKey EngineeringInfoItem = 537;
        static const ::Courier::DataItemKey DABTestModeEnsembleInfoItem = 541;
        static const ::Courier::DataItemKey AMFMLogoImageItem = 544;
        static const ::Courier::DataItemKey HDIconPreset11Item = 550;
        static const ::Courier::DataItemKey PresetInfoFMASTItem = 555;
        static const ::Courier::DataItemKey DABTestModeGAvailabiltyInfoItem = 557;
        static const ::Courier::DataItemKey DABGTestModeInfoItem = 558;
        static const ::Courier::DataItemKey DABGTestModeActiveCompItem = 562;
        static const ::Courier::DataItemKey TestModeAvailabilityInfoItem = 563;
        static const ::Courier::DataItemKey PresetInfoFM1Item = 567;
        static const ::Courier::DataItemKey TMHDAudioSPS3Item = 575;
        static const ::Courier::DataItemKey HDIconPreset2Item = 582;
        static const ::Courier::DataItemKey HDProgramListVisibilityItem = 587;
        static const ::Courier::DataItemKey CheckBoxListItemItem = 590;
        static const ::Courier::DataItemKey HomeScreenAmHdLogoItem = 601;
        static const ::Courier::DataItemKey HomeScreenInfoItem = 602;
        static const ::Courier::DataItemKey PresetInfoFM2Item = 606;
        static const ::Courier::DataItemKey HomeScreenFmHdLogoItem = 607;
        static const ::Courier::DataItemKey HDIconPreset6Item = 611;
        static const ::Courier::DataItemKey HDIconPreset3Item = 614;
        static const ::Courier::DataItemKey TMHDAudioSPS2Item = 621;
        static const ::Courier::DataItemKey TMHDAudioSPS5Item = 634;
        static const ::Courier::DataItemKey LayerNextPresets_DABItem = 639;
        static const ::Courier::DataItemKey DABGTestModeAnnoStatusInfoItem = 642;
        static const ::Courier::DataItemKey LayerNextPresets_FMItem = 643;
        static const ::Courier::DataItemKey HDIconPreset4Item = 649;
        static const ::Courier::DataItemKey HDIconPreset5Item = 652;
        static const ::Courier::DataItemKey DtmHDItem = 662;
        static const ::Courier::DataItemKey PresetInfoAMASTItem = 664;
        static const ::Courier::DataItemKey Tuner4Item = 672;
        static const ::Courier::DataItemKey HDIconPreset12Item = 677;
        static const ::Courier::DataItemKey TMHDAudioSPS4Item = 682;
        static const ::Courier::DataItemKey FMAMPresetInfoItem = 692;
        static const ::Courier::DataItemKey FmHdLogoItem = 694;
        static const ::Courier::DataItemKey Scan_StatusItem = 698;
        static const ::Courier::DataItemKey HDIconPreset8Item = 704;

    namespace PgBar_timer {
            static const ::Courier::DataItemKey TimerValueItem = 568;
            static const ::Courier::DataItemKey NoOfStepsItem = 369;
            static const ::Courier::DataItemKey TimerStartItem = 117;
    } // namespace PgBar_timer

    namespace TunerOptions {
            static const ::Courier::DataItemKey isChecked_TAItem = 146;
            static const ::Courier::DataItemKey isChecked_RadioTxtItem = 136;
            static const ::Courier::DataItemKey isChecked_RDSRegPgmItem = 659;
            static const ::Courier::DataItemKey isChecked_AltFreqItem = 673;
            static const ::Courier::DataItemKey isChecked_DAB_DynamicContentItem = 25;
            static const ::Courier::DataItemKey isChecked_DAB_FM_FollowingItem = 410;
            static const ::Courier::DataItemKey isChecked_DAB_DAB_LinkingItem = 528;
            static const ::Courier::DataItemKey isChecked_DRM_DynamicContentItem = 385;
            static const ::Courier::DataItemKey isChecked_DRMFrequencyItem = 168;
            static const ::Courier::DataItemKey isChecked_DRMAFSEARCHItem = 585;
    } // namespace TunerOptions

    namespace CarModeVisibility {
            static const ::Courier::DataItemKey VisibleStatusItem = 85;
    } // namespace CarModeVisibility

    namespace TMHDAudioSPS7 {
            static const ::Courier::DataItemKey TMHD_Prog_SPS7_switchItem = 361;
            static const ::Courier::DataItemKey TMHD_Prog_SPS7_availableItem = 255;
    } // namespace TMHDAudioSPS7

    namespace ChannelInfo {
            static const ::Courier::DataItemKey AdvisoryTextItem = 193;
            static const ::Courier::DataItemKey ArtistItem = 467;
            static const ::Courier::DataItemKey AlbumItem = 289;
            static const ::Courier::DataItemKey TrackItem = 599;
            static const ::Courier::DataItemKey ArtistAlbumSwitchItem = 175;
            static const ::Courier::DataItemKey IsBallGameModeVisibleItem = 88;
            static const ::Courier::DataItemKey CategoryItem = 430;
    } // namespace ChannelInfo

    namespace AmHdOnOff {
            static const ::Courier::DataItemKey IsActiveItem = 424;
    } // namespace AmHdOnOff

    namespace FMStationList {
            static const ::Courier::DataItemKey presetnumberItem = 364;
            static const ::Courier::DataItemKey station_nameItem = 188;
            static const ::Courier::DataItemKey Traffic_programItem = 69;
    } // namespace FMStationList

    namespace PresetInfoDABAST {
            static const ::Courier::DataItemKey PSName1Item = 348;
            static const ::Courier::DataItemKey PSName2Item = 308;
            static const ::Courier::DataItemKey PSName3Item = 274;
            static const ::Courier::DataItemKey PSName4Item = 618;
            static const ::Courier::DataItemKey PSName5Item = 571;
            static const ::Courier::DataItemKey PSName6Item = 512;
    } // namespace PresetInfoDABAST

    namespace HDAudioMPS {
            static const ::Courier::DataItemKey HD_Prog_MPS_switchItem = 247;
            static const ::Courier::DataItemKey HD_Prog_MPS_sizeItem = 264;
    } // namespace HDAudioMPS

    namespace VariantInfo {
            static const ::Courier::DataItemKey DAB_AvailableItem = 162;
            static const ::Courier::DataItemKey WX_AvailableItem = 288;
            static const ::Courier::DataItemKey Dest_Reg_DRMItem = 457;
            static const ::Courier::DataItemKey DAB_MountedItem = 506;
            static const ::Courier::DataItemKey HD_AvailableItem = 87;
            static const ::Courier::DataItemKey AM_ActivationItem = 482;
            static const ::Courier::DataItemKey FM_ActivationItem = 589;
            static const ::Courier::DataItemKey SXM_MountedItem = 12;
    } // namespace VariantInfo

    namespace MenuSelection {
            static const ::Courier::DataItemKey MainMenu_SelectionItem = 36;
            static const ::Courier::DataItemKey DABPTYOption_SelectionItem = 635;
            static const ::Courier::DataItemKey DRMPTYOption_SelectionItem = 219;
    } // namespace MenuSelection

    namespace PresetInfoWB {
            static const ::Courier::DataItemKey WBName1Item = 444;
            static const ::Courier::DataItemKey WBName2Item = 495;
            static const ::Courier::DataItemKey WBName3Item = 358;
            static const ::Courier::DataItemKey WBName4Item = 413;
            static const ::Courier::DataItemKey WBName5Item = 269;
            static const ::Courier::DataItemKey WBName6Item = 312;
            static const ::Courier::DataItemKey WBName7Item = 114;
            static const ::Courier::DataItemKey WBName8Item = 163;
            static const ::Courier::DataItemKey WBName9Item = 45;
            static const ::Courier::DataItemKey WBName10Item = 356;
            static const ::Courier::DataItemKey WBmodeItem = 645;
            static const ::Courier::DataItemKey WBFrequencyItem = 399;
    } // namespace PresetInfoWB

    namespace HDIconPreset7 {
            static const ::Courier::DataItemKey HD_Preset_7Item = 211;
            static const ::Courier::DataItemKey HD_Preset_7_valueItem = 423;
    } // namespace HDIconPreset7

    namespace PresetInfoDRM {
            static const ::Courier::DataItemKey PSName1Item = 77;
            static const ::Courier::DataItemKey PSName2Item = 579;
            static const ::Courier::DataItemKey PSName3Item = 532;
            static const ::Courier::DataItemKey PSName4Item = 581;
            static const ::Courier::DataItemKey PSName5Item = 622;
            static const ::Courier::DataItemKey PSName6Item = 332;
    } // namespace PresetInfoDRM

    namespace NextPrevious_Status_DAB {
            static const ::Courier::DataItemKey IsNextActive_DABItem = 296;
            static const ::Courier::DataItemKey IsPreviousActive_DABItem = 588;
    } // namespace NextPrevious_Status_DAB

    namespace Source_Slection {
            static const ::Courier::DataItemKey FM1ActiveItem = 685;
            static const ::Courier::DataItemKey FM2ActiveItem = 2;
            static const ::Courier::DataItemKey FMASTActiveItem = 638;
            static const ::Courier::DataItemKey AMActiveItem = 183;
            static const ::Courier::DataItemKey AMASTActiveItem = 641;
            static const ::Courier::DataItemKey WXActiveItem = 510;
            static const ::Courier::DataItemKey DABActiveItem = 546;
            static const ::Courier::DataItemKey DABASTActiveItem = 142;
            static const ::Courier::DataItemKey SXMActiveItem = 1;
    } // namespace Source_Slection

    namespace Scan_AST {
            static const ::Courier::DataItemKey IsActiveItem = 384;
            static const ::Courier::DataItemKey IsDAB_AST_ActiveItem = 303;
            static const ::Courier::DataItemKey IsAM_AST_ActiveItem = 405;
            static const ::Courier::DataItemKey IsFM_AST_ActiveItem = 545;
            static const ::Courier::DataItemKey IsDRM_AST_ActiveItem = 89;
    } // namespace Scan_AST

    namespace Preset_Popup {
            static const ::Courier::DataItemKey Popup_text_1Item = 363;
            static const ::Courier::DataItemKey Popup_text_2Item = 431;
            static const ::Courier::DataItemKey AST_CannotStoreItem = 502;
            static const ::Courier::DataItemKey CurrentValueItem = 310;
            static const ::Courier::DataItemKey TotalValueItem = 210;
            static const ::Courier::DataItemKey Visible_Txt_Wgt_1Item = 328;
            static const ::Courier::DataItemKey Visible_Txt_Wgt_2Item = 548;
    } // namespace Preset_Popup

    namespace HDAudioSPS1 {
            static const ::Courier::DataItemKey HD_Prog_SPS1_switchItem = 455;
            static const ::Courier::DataItemKey HD_Prog_SPS1_sizeItem = 152;
    } // namespace HDAudioSPS1

    namespace EngineeringInfoDRM {
            static const ::Courier::DataItemKey FrequencyItem = 93;
            static const ::Courier::DataItemKey FieldStrengthItem = 656;
            static const ::Courier::DataItemKey SyncStatusItem = 408;
            static const ::Courier::DataItemKey RobustnessModeItem = 305;
            static const ::Courier::DataItemKey BandwidthItem = 489;
            static const ::Courier::DataItemKey Inter_DepthItem = 400;
            static const ::Courier::DataItemKey Recnfg_idxItem = 286;
            static const ::Courier::DataItemKey Service_IDItem = 149;
            static const ::Courier::DataItemKey Service_LabelItem = 518;
            static const ::Courier::DataItemKey PTYItem = 300;
            static const ::Courier::DataItemKey LanguageItem = 292;
            static const ::Courier::DataItemKey FACItem = 241;
            static const ::Courier::DataItemKey SDCItem = 128;
            static const ::Courier::DataItemKey AudioCRCItem = 63;
            static const ::Courier::DataItemKey AudioMuteItem = 474;
            static const ::Courier::DataItemKey ServiceQualityItem = 216;
            static const ::Courier::DataItemKey AudioCodingItem = 314;
            static const ::Courier::DataItemKey SBRItem = 327;
            static const ::Courier::DataItemKey AudioModeItem = 445;
            static const ::Courier::DataItemKey SamplingRateItem = 338;
            static const ::Courier::DataItemKey TextFlagItem = 360;
            static const ::Courier::DataItemKey IBERItem = 40;
            static const ::Courier::DataItemKey PrLevel_PartAItem = 14;
            static const ::Courier::DataItemKey PrLevel_PartbItem = 330;
    } // namespace EngineeringInfoDRM

    namespace TMHDAudioSPS1 {
            static const ::Courier::DataItemKey TMHD_Prog_SPS1_switchItem = 23;
            static const ::Courier::DataItemKey TMHD_Prog_SPS1_availableItem = 493;
    } // namespace TMHDAudioSPS1

    namespace RadioBandInfo {
            static const ::Courier::DataItemKey Visible_Txt_Wgt_BandItem = 547;
            static const ::Courier::DataItemKey Visible_Txt_Wgt_MuteItem = 156;
            static const ::Courier::DataItemKey Visible_Txt_Wgt_TAItem = 610;
            static const ::Courier::DataItemKey Visible_Txt_Wgt_TA_In_AMItem = 123;
            static const ::Courier::DataItemKey Image_TAItem = 164;
            static const ::Courier::DataItemKey Visible_Txt_Wgt_TA_FMItem = 265;
            static const ::Courier::DataItemKey Visible_Txt_Wgt_TA_DABItem = 133;
    } // namespace RadioBandInfo

    namespace TMHDAudioMPS {
            static const ::Courier::DataItemKey TMHD_Prog_MPS_switchItem = 683;
            static const ::Courier::DataItemKey TMHD_Prog_MPS_availableItem = 401;
    } // namespace TMHDAudioMPS

    namespace ActiveSourceInfo {
            static const ::Courier::DataItemKey BitmapforSourceItem = 676;
            static const ::Courier::DataItemKey ActiveSourceItem = 554;
    } // namespace ActiveSourceInfo

    namespace TunerSource_Band {
            static const ::Courier::DataItemKey TunerSource1Item = 620;
            static const ::Courier::DataItemKey TunerSource2Item = 573;
            static const ::Courier::DataItemKey TunerSource3Item = 217;
            static const ::Courier::DataItemKey TunerSource4Item = 172;
            static const ::Courier::DataItemKey BandEnable1Item = 79;
            static const ::Courier::DataItemKey BandEnable2Item = 120;
            static const ::Courier::DataItemKey BandEnable3Item = 370;
            static const ::Courier::DataItemKey BandEnable4Item = 283;
            static const ::Courier::DataItemKey Band1Item = 351;
            static const ::Courier::DataItemKey Band2Item = 234;
            static const ::Courier::DataItemKey Band3Item = 250;
            static const ::Courier::DataItemKey Band4Item = 112;
    } // namespace TunerSource_Band

    namespace HDAudioSPS2 {
            static const ::Courier::DataItemKey HD_Prog_SPS2_switchItem = 73;
            static const ::Courier::DataItemKey HD_Prog_SPS2_sizeItem = 531;
    } // namespace HDAudioSPS2

    namespace BrowseListSelectedLine {
            static const ::Courier::DataItemKey Tun_StationSelectedItem = 22;
            static const ::Courier::DataItemKey DAB_ServiceSelectedItem = 104;
            static const ::Courier::DataItemKey AF_ServiceSelectedItem = 285;
            static const ::Courier::DataItemKey TMC_ServiceSelectedItem = 235;
            static const ::Courier::DataItemKey DRM_StationSelectedItem = 598;
    } // namespace BrowseListSelectedLine

    namespace ListScrollBarInfo {
            static const ::Courier::DataItemKey EnabledItem = 628;
    } // namespace ListScrollBarInfo

    namespace FMSetupMenuInfo {
            static const ::Courier::DataItemKey ToggleAFItem = 570;
            static const ::Courier::DataItemKey ToggleMMItem = 20;
            static const ::Courier::DataItemKey ToggleTA_statusItem = 37;
            static const ::Courier::DataItemKey ToggleRDSItem = 593;
            static const ::Courier::DataItemKey TogglePhaseDiversityItem = 75;
    } // namespace FMSetupMenuInfo

    namespace HDIconPreset10 {
            static const ::Courier::DataItemKey HD_Preset_10Item = 233;
            static const ::Courier::DataItemKey HD_Preset_10_valueItem = 565;
    } // namespace HDIconPreset10

    namespace DAB_Test_Mode {
            static const ::Courier::DataItemKey channel_NumItem = 671;
            static const ::Courier::DataItemKey Ensemble_LblItem = 325;
            static const ::Courier::DataItemKey Ensemble_IDItem = 342;
            static const ::Courier::DataItemKey Service_IDItem = 566;
            static const ::Courier::DataItemKey Ensemble_freqItem = 74;
            static const ::Courier::DataItemKey Service_LblItem = 13;
            static const ::Courier::DataItemKey Aud_Data_Bit_RateItem = 329;
            static const ::Courier::DataItemKey MSCItem = 304;
            static const ::Courier::DataItemKey FICItem = 84;
            static const ::Courier::DataItemKey NETItem = 629;
            static const ::Courier::DataItemKey RS_FECItem = 309;
            static const ::Courier::DataItemKey Sync_flagItem = 6;
            static const ::Courier::DataItemKey QAItem = 92;
            static const ::Courier::DataItemKey QSItem = 491;
            static const ::Courier::DataItemKey Field_StrengthItem = 337;
            static const ::Courier::DataItemKey Mute_flagItem = 561;
            static const ::Courier::DataItemKey Bg_tuner_ens_freqItem = 624;
            static const ::Courier::DataItemKey Bg_Ensemble_IDItem = 650;
            static const ::Courier::DataItemKey Bg_FICItem = 207;
            static const ::Courier::DataItemKey Audio_ModeItem = 302;
            static const ::Courier::DataItemKey Freq_TableItem = 425;
            static const ::Courier::DataItemKey BGModeItem = 658;
            static const ::Courier::DataItemKey BGSync_flagItem = 294;
            static const ::Courier::DataItemKey TASrcItem = 239;
    } // namespace DAB_Test_Mode

    namespace AmHdLogo {
            static const ::Courier::DataItemKey AmHdLogoIndexItem = 448;
    } // namespace AmHdLogo

    namespace ActiveBankInfo {
            static const ::Courier::DataItemKey FM1_ActiveItem = 511;
            static const ::Courier::DataItemKey FM2_ActiveItem = 244;
            static const ::Courier::DataItemKey FMAST_ActiveItem = 705;
            static const ::Courier::DataItemKey AM_ActiveItem = 523;
            static const ::Courier::DataItemKey AMAST_ActiveItem = 29;
            static const ::Courier::DataItemKey DAB_ActiveItem = 97;
            static const ::Courier::DataItemKey DAB_AST_ActiveItem = 696;
            static const ::Courier::DataItemKey DRM_ActiveItem = 317;
            static const ::Courier::DataItemKey DRM_AST_ActiveItem = 453;
    } // namespace ActiveBankInfo

    namespace DAB_Setup_Screen_ActiveTuner_Info {
            static const ::Courier::DataItemKey DRCItem = 525;
            static const ::Courier::DataItemKey PSItem = 316;
            static const ::Courier::DataItemKey SM_ACCItem = 422;
            static const ::Courier::DataItemKey SRItem = 90;
            static const ::Courier::DataItemKey TPItem = 95;
    } // namespace DAB_Setup_Screen_ActiveTuner_Info

    namespace HDAudioSPS3 {
            static const ::Courier::DataItemKey HD_Prog_SPS3_switchItem = 700;
            static const ::Courier::DataItemKey HD_Prog_SPS3_sizeItem = 281;
    } // namespace HDAudioSPS3

    namespace AppFlyIn {
            static const ::Courier::DataItemKey BTDeviceStateItem = 279;
            static const ::Courier::DataItemKey PhoneCallDurationItem = 434;
            static const ::Courier::DataItemKey TextPhoneCallDurationItem = 572;
            static const ::Courier::DataItemKey PhoneRoamingItem = 564;
            static const ::Courier::DataItemKey PhoneChargeItem = 492;
            static const ::Courier::DataItemKey PhoneSPILinkItem = 625;
            static const ::Courier::DataItemKey NaviRGStausItem = 667;
            static const ::Courier::DataItemKey NaviETADTDItem = 102;
            static const ::Courier::DataItemKey NaviDirectionItem = 65;
            static const ::Courier::DataItemKey NaviDurationItem = 655;
            static const ::Courier::DataItemKey NaviTimeToDestinationItem = 386;
            static const ::Courier::DataItemKey Visible_NaviItem = 70;
            static const ::Courier::DataItemKey Visible_MediaItem = 187;
    } // namespace AppFlyIn

    namespace SPIVisibilityTuner {
            static const ::Courier::DataItemKey SPIIsvisibleTunerItem = 116;
            static const ::Courier::DataItemKey SPIIsvisibleTunerFMTunerItem = 266;
    } // namespace SPIVisibilityTuner

    namespace EngineeringInfo1 {
            static const ::Courier::DataItemKey MultipathQualityItem = 100;
            static const ::Courier::DataItemKey nChannelItem = 415;
            static const ::Courier::DataItemKey RDSItem = 67;
            static const ::Courier::DataItemKey AntennaStatusItem = 366;
            static const ::Courier::DataItemKey ReceptionQualityItem = 256;
            static const ::Courier::DataItemKey SzSharxItem = 171;
            static const ::Courier::DataItemKey SzHicutItem = 151;
            static const ::Courier::DataItemKey TPFlagItem = 429;
    } // namespace EngineeringInfo1

    namespace RdsRadioText {
            static const ::Courier::DataItemKey TextItem = 62;
    } // namespace RdsRadioText

    namespace Tuner2 {
            static const ::Courier::DataItemKey FreqItem = 534;
            static const ::Courier::DataItemKey PIItem = 177;
            static const ::Courier::DataItemKey PSItem = 333;
            static const ::Courier::DataItemKey FSQItem = 326;
            static const ::Courier::DataItemKey HicutItem = 284;
            static const ::Courier::DataItemKey SharxItem = 668;
            static const ::Courier::DataItemKey TPItem = 139;
            static const ::Courier::DataItemKey TAItem = 138;
            static const ::Courier::DataItemKey RDSItem = 416;
            static const ::Courier::DataItemKey AFItem = 353;
            static const ::Courier::DataItemKey DevItem = 443;
            static const ::Courier::DataItemKey CSItem = 527;
            static const ::Courier::DataItemKey MPNCItem = 616;
            static const ::Courier::DataItemKey BandItem = 153;
    } // namespace Tuner2

    namespace HDParamTuningIcon {
            static const ::Courier::DataItemKey HD_IconItem = 368;
    } // namespace HDParamTuningIcon

    namespace DABChannelInfo {
            static const ::Courier::DataItemKey TpStatusItem = 640;
            static const ::Courier::DataItemKey DabStatusItem = 299;
            static const ::Courier::DataItemKey EnsembleLabelItem = 680;
            static const ::Courier::DataItemKey ServiceLabelItem = 253;
            static const ::Courier::DataItemKey RadioTextItem = 609;
            static const ::Courier::DataItemKey RadioTextVisibleItem = 421;
    } // namespace DABChannelInfo

    namespace HDAudioSPS4 {
            static const ::Courier::DataItemKey HD_Prog_SPS4_switchItem = 179;
            static const ::Courier::DataItemKey HD_Prog_SPS4_sizeItem = 297;
    } // namespace HDAudioSPS4

    namespace TAInfo {
            static const ::Courier::DataItemKey TAPSNameItem = 631;
            static const ::Courier::DataItemKey PTY31PSNameItem = 637;
    } // namespace TAInfo

    namespace LayerNextPresets_AM {
            static const ::Courier::DataItemKey NextPreviousIndex_AMItem = 9;
    } // namespace LayerNextPresets_AM

    namespace DABOptions {
            static const ::Courier::DataItemKey isChecked_EnablePTYFilterItem = 41;
            static const ::Courier::DataItemKey isChecked_NewsItem = 240;
            static const ::Courier::DataItemKey isChecked_CultureItem = 695;
            static const ::Courier::DataItemKey isChecked_SportsItem = 173;
            static const ::Courier::DataItemKey isChecked_MusicItem = 39;
            static const ::Courier::DataItemKey isChecked_SpecialItem = 524;
    } // namespace DABOptions

    namespace Tuner3 {
            static const ::Courier::DataItemKey FreqItem = 681;
            static const ::Courier::DataItemKey PIItem = 556;
            static const ::Courier::DataItemKey PSItem = 52;
            static const ::Courier::DataItemKey FSQItem = 472;
            static const ::Courier::DataItemKey HicutItem = 688;
            static const ::Courier::DataItemKey SharxItem = 481;
            static const ::Courier::DataItemKey TPItem = 454;
            static const ::Courier::DataItemKey TAItem = 592;
            static const ::Courier::DataItemKey RDSItem = 16;
            static const ::Courier::DataItemKey AFItem = 371;
            static const ::Courier::DataItemKey DevItem = 553;
            static const ::Courier::DataItemKey CSItem = 34;
            static const ::Courier::DataItemKey MPNCItem = 107;
            static const ::Courier::DataItemKey BandItem = 180;
    } // namespace Tuner3

    namespace HDButtonVisibility {
            static const ::Courier::DataItemKey isHdVisibleItem = 287;
    } // namespace HDButtonVisibility

    namespace HDAudioSPS5 {
            static const ::Courier::DataItemKey HD_Prog_SPS5_switchItem = 134;
            static const ::Courier::DataItemKey HD_Prog_SPS5_sizeItem = 208;
    } // namespace HDAudioSPS5

    namespace WBPresetInfo {
            static const ::Courier::DataItemKey Preset_1_ActiveItem = 57;
            static const ::Courier::DataItemKey Preset_2_ActiveItem = 3;
            static const ::Courier::DataItemKey Preset_3_ActiveItem = 469;
            static const ::Courier::DataItemKey Preset_4_ActiveItem = 657;
            static const ::Courier::DataItemKey Preset_5_ActiveItem = 577;
            static const ::Courier::DataItemKey Preset_6_ActiveItem = 464;
            static const ::Courier::DataItemKey Preset_7_ActiveItem = 245;
            static const ::Courier::DataItemKey Preset_8_ActiveItem = 654;
            static const ::Courier::DataItemKey Preset_9_ActiveItem = 404;
            static const ::Courier::DataItemKey Preset_10_ActiveItem = 501;
    } // namespace WBPresetInfo

    namespace AMPresetInfo {
            static const ::Courier::DataItemKey Preset_1_ActiveItem = 632;
            static const ::Courier::DataItemKey Preset_2_ActiveItem = 520;
            static const ::Courier::DataItemKey Preset_3_ActiveItem = 126;
            static const ::Courier::DataItemKey Preset_4_ActiveItem = 636;
            static const ::Courier::DataItemKey Preset_5_ActiveItem = 319;
            static const ::Courier::DataItemKey Preset_6_ActiveItem = 346;
            static const ::Courier::DataItemKey Preset_7_ActiveItem = 365;
            static const ::Courier::DataItemKey Preset_8_ActiveItem = 335;
            static const ::Courier::DataItemKey Preset_9_ActiveItem = 323;
            static const ::Courier::DataItemKey Preset_10_ActiveItem = 121;
            static const ::Courier::DataItemKey Preset_11_ActiveItem = 118;
            static const ::Courier::DataItemKey Preset_12_ActiveItem = 559;
    } // namespace AMPresetInfo

    namespace DRMOptions {
            static const ::Courier::DataItemKey isChecked_EnablePTYFilterItem = 395;
            static const ::Courier::DataItemKey isChecked_NewsItem = 665;
            static const ::Courier::DataItemKey isChecked_CultureItem = 159;
            static const ::Courier::DataItemKey isChecked_SportsItem = 615;
            static const ::Courier::DataItemKey isChecked_MusicItem = 251;
            static const ::Courier::DataItemKey isChecked_SpecialItem = 379;
    } // namespace DRMOptions

    namespace TmcStationInfoData {
            static const ::Courier::DataItemKey PSItem = 218;
            static const ::Courier::DataItemKey PIItem = 605;
            static const ::Courier::DataItemKey CCItem = 604;
            static const ::Courier::DataItemKey SIDItem = 59;
            static const ::Courier::DataItemKey LTNItem = 591;
            static const ::Courier::DataItemKey QualityItem = 275;
    } // namespace TmcStationInfoData

    namespace HDAudioSPS6 {
            static const ::Courier::DataItemKey HD_Prog_SPS6_switchItem = 402;
            static const ::Courier::DataItemKey HD_Prog_SPS6_sizeItem = 678;
    } // namespace HDAudioSPS6

    namespace TmcInformationData {
            static const ::Courier::DataItemKey NumberOfMsgItem = 230;
            static const ::Courier::DataItemKey SelectedMsgItem = 390;
            static const ::Courier::DataItemKey LastMsgRecdItem = 508;
    } // namespace TmcInformationData

    namespace BrowseListSize {
            static const ::Courier::DataItemKey Tun_StationListSizeItem = 7;
            static const ::Courier::DataItemKey DAB_ServiceListSizeItem = 33;
            static const ::Courier::DataItemKey AF_ServiceListSizeItem = 584;
            static const ::Courier::DataItemKey TMC_ServiceListSizeItem = 462;
            static const ::Courier::DataItemKey DRM_ServiceListSizeItem = 693;
            static const ::Courier::DataItemKey Tun_StationWindowListSizeItem = 646;
            static const ::Courier::DataItemKey DAB_ServiceWindowListSizeItem = 127;
            static const ::Courier::DataItemKey AF_ServiceWindowListSizeItem = 141;
            static const ::Courier::DataItemKey TMC_ServiceWindowListSizeItem = 158;
            static const ::Courier::DataItemKey DRM_ServiceWindowListSizeItem = 181;
    } // namespace BrowseListSize

    namespace Tuner1 {
            static const ::Courier::DataItemKey FreqItem = 137;
            static const ::Courier::DataItemKey PIItem = 263;
            static const ::Courier::DataItemKey PSItem = 80;
            static const ::Courier::DataItemKey FSQItem = 270;
            static const ::Courier::DataItemKey HicutItem = 185;
            static const ::Courier::DataItemKey SharxItem = 315;
            static const ::Courier::DataItemKey TPItem = 617;
            static const ::Courier::DataItemKey TAItem = 226;
            static const ::Courier::DataItemKey RDSItem = 26;
            static const ::Courier::DataItemKey AFItem = 367;
            static const ::Courier::DataItemKey DevItem = 450;
            static const ::Courier::DataItemKey CSItem = 359;
            static const ::Courier::DataItemKey MPNCItem = 660;
            static const ::Courier::DataItemKey BandItem = 687;
    } // namespace Tuner1

    namespace PresetInfoDRMAST {
            static const ::Courier::DataItemKey PSName1Item = 311;
            static const ::Courier::DataItemKey PSName2Item = 282;
            static const ::Courier::DataItemKey PSName3Item = 318;
            static const ::Courier::DataItemKey PSName4Item = 157;
            static const ::Courier::DataItemKey PSName5Item = 417;
            static const ::Courier::DataItemKey PSName6Item = 259;
    } // namespace PresetInfoDRMAST

    namespace NextPrevious_Status_FM {
            static const ::Courier::DataItemKey IsNextActive_FMItem = 277;
            static const ::Courier::DataItemKey IsPreviousActive_FMItem = 420;
    } // namespace NextPrevious_Status_FM

    namespace SearchNextPrevious_IconActive {
            static const ::Courier::DataItemKey IsNextIconActiveItem = 627;
            static const ::Courier::DataItemKey IsPreviousIconActiveItem = 669;
    } // namespace SearchNextPrevious_IconActive

    namespace FmHdOnOff {
            static const ::Courier::DataItemKey IsActiveItem = 576;
    } // namespace FmHdOnOff

    namespace EngineeringInfo2 {
            static const ::Courier::DataItemKey TAFlagItem = 290;
            static const ::Courier::DataItemKey AltFrequencyItem = 18;
            static const ::Courier::DataItemKey AFonOffItem = 608;
            static const ::Courier::DataItemKey BandscanOnOffItem = 418;
            static const ::Courier::DataItemKey MeasureOnOffItem = 549;
            static const ::Courier::DataItemKey FreqStepFMItem = 515;
            static const ::Courier::DataItemKey FreqStepAMItem = 155;
            static const ::Courier::DataItemKey RFLevelAMItem = 347;
            static const ::Courier::DataItemKey LinearAudioItem = 542;
            static const ::Courier::DataItemKey AMTunerItem = 412;
            static const ::Courier::DataItemKey FMTuner1Item = 334;
            static const ::Courier::DataItemKey FMTuner2Item = 35;
            static const ::Courier::DataItemKey FMTuner3Item = 86;
            static const ::Courier::DataItemKey FMTuner4Item = 99;
            static const ::Courier::DataItemKey DABTunerItem = 224;
    } // namespace EngineeringInfo2

    namespace HDAudioSPS7 {
            static const ::Courier::DataItemKey HD_Prog_SPS7_switchItem = 552;
            static const ::Courier::DataItemKey HD_Prog_SPS7_sizeItem = 30;
    } // namespace HDAudioSPS7

    namespace tuningSlider {
            static const ::Courier::DataItemKey StepSizeAMItem = 50;
            static const ::Courier::DataItemKey MaxValueAMItem = 466;
            static const ::Courier::DataItemKey MinValueAMItem = 596;
            static const ::Courier::DataItemKey NoOfStepsAMItem = 340;
            static const ::Courier::DataItemKey Image_SliderAMItem = 388;
            static const ::Courier::DataItemKey Image_Slider_BGItem = 630;
            static const ::Courier::DataItemKey StepSizeFMItem = 647;
            static const ::Courier::DataItemKey MaxValueFMItem = 560;
            static const ::Courier::DataItemKey TotalTimeFMItem = 426;
            static const ::Courier::DataItemKey NoOfStepsFMItem = 130;
            static const ::Courier::DataItemKey Image_SliderFMItem = 419;
    } // namespace tuningSlider

    namespace TMHDAudioSPS6 {
            static const ::Courier::DataItemKey TMHD_Prog_SPS6_switchItem = 461;
            static const ::Courier::DataItemKey TMHD_Prog_SPS6_availableItem = 452;
    } // namespace TMHDAudioSPS6

    namespace Menu_NumOptions {
            static const ::Courier::DataItemKey MainMenu_NumOptionsItem = 703;
    } // namespace Menu_NumOptions

    namespace PresetInfoAM {
            static const ::Courier::DataItemKey PSName1Item = 94;
            static const ::Courier::DataItemKey PSName2Item = 32;
            static const ::Courier::DataItemKey PSName3Item = 91;
            static const ::Courier::DataItemKey PSName4Item = 666;
            static const ::Courier::DataItemKey PSName5Item = 5;
            static const ::Courier::DataItemKey PSName6Item = 597;
            static const ::Courier::DataItemKey PSName7Item = 475;
            static const ::Courier::DataItemKey PSName8Item = 516;
            static const ::Courier::DataItemKey PSName9Item = 396;
            static const ::Courier::DataItemKey PSName10Item = 623;
            static const ::Courier::DataItemKey PSName11Item = 407;
            static const ::Courier::DataItemKey PSName12Item = 496;
    } // namespace PresetInfoAM

    namespace NextPrevious_Status_AM {
            static const ::Courier::DataItemKey IsNextActive_AMItem = 53;
            static const ::Courier::DataItemKey IsPreviousActive_AMItem = 686;
    } // namespace NextPrevious_Status_AM

    namespace PresetInfoDAB {
            static const ::Courier::DataItemKey PSName1Item = 125;
            static const ::Courier::DataItemKey PSName2Item = 433;
            static const ::Courier::DataItemKey PSName3Item = 376;
            static const ::Courier::DataItemKey PSName4Item = 663;
            static const ::Courier::DataItemKey PSName5Item = 273;
            static const ::Courier::DataItemKey PSName6Item = 228;
            static const ::Courier::DataItemKey PSName7Item = 132;
            static const ::Courier::DataItemKey PSName8Item = 468;
            static const ::Courier::DataItemKey PSName9Item = 60;
            static const ::Courier::DataItemKey PSName10Item = 702;
            static const ::Courier::DataItemKey PSName11Item = 242;
            static const ::Courier::DataItemKey PSName12Item = 533;
    } // namespace PresetInfoDAB

    namespace DABTestModeServiceFollowingInfo {
            static const ::Courier::DataItemKey TSUItem = 320;
    } // namespace DABTestModeServiceFollowingInfo

    namespace RDSOptions {
            static const ::Courier::DataItemKey Visible_TA_IconItem = 43;
            static const ::Courier::DataItemKey Visible_TA_Icon_CrossItem = 463;
            static const ::Courier::DataItemKey Visible_TAItem = 526;
            static const ::Courier::DataItemKey Visible_RadioTextItem = 539;
            static const ::Courier::DataItemKey Visible_AFItem = 490;
            static const ::Courier::DataItemKey Visible_RegItem = 82;
            static const ::Courier::DataItemKey Visible_DRMAFSItem = 46;
    } // namespace RDSOptions

    namespace DAB_Setup_Screen {
            static const ::Courier::DataItemKey ServiceLinkingItem = 701;
            static const ::Courier::DataItemKey ConcealmentLevelItem = 697;
    } // namespace DAB_Setup_Screen

    namespace DABPresetInfo {
            static const ::Courier::DataItemKey Preset_1_ActiveItem = 225;
            static const ::Courier::DataItemKey Preset_2_ActiveItem = 56;
            static const ::Courier::DataItemKey Preset_3_ActiveItem = 372;
            static const ::Courier::DataItemKey Preset_4_ActiveItem = 166;
            static const ::Courier::DataItemKey Preset_5_ActiveItem = 176;
            static const ::Courier::DataItemKey Preset_6_ActiveItem = 470;
            static const ::Courier::DataItemKey Preset_7_ActiveItem = 517;
            static const ::Courier::DataItemKey Preset_8_ActiveItem = 170;
            static const ::Courier::DataItemKey Preset_9_ActiveItem = 48;
            static const ::Courier::DataItemKey Preset_10_ActiveItem = 178;
            static const ::Courier::DataItemKey Preset_11_ActiveItem = 387;
            static const ::Courier::DataItemKey Preset_12_ActiveItem = 670;
    } // namespace DABPresetInfo

    namespace StationInfoSource {
            static const ::Courier::DataItemKey PSNameItem = 191;
            static const ::Courier::DataItemKey AMPSNameItem = 135;
            static const ::Courier::DataItemKey AMFrequencyItem = 480;
            static const ::Courier::DataItemKey FMFrequencyItem = 108;
            static const ::Courier::DataItemKey DRMFrequencyItem = 522;
            static const ::Courier::DataItemKey RadioTextItem = 278;
            static const ::Courier::DataItemKey UnitItem = 271;
            static const ::Courier::DataItemKey ViewNameItem = 690;
            static const ::Courier::DataItemKey TPInfoItem = 161;
            static const ::Courier::DataItemKey DabTPInfoItem = 260;
            static const ::Courier::DataItemKey CurrentStationTPInfoItem = 406;
            static const ::Courier::DataItemKey Visible_Txt_Wgt_RDSItem = 674;
            static const ::Courier::DataItemKey Visible_Txt_Wgt_NoRDSItem = 143;
            static const ::Courier::DataItemKey Visible_Txt_Wgt_NaviItem = 446;
            static const ::Courier::DataItemKey Visible_Txt_Wgt_EUItem = 535;
            static const ::Courier::DataItemKey Variant_TypeItem = 66;
            static const ::Courier::DataItemKey Variant_Type_NonEUItem = 258;
            static const ::Courier::DataItemKey TA_SourcePSNameItem = 409;
            static const ::Courier::DataItemKey DRM_ServiceLabelItem = 96;
            static const ::Courier::DataItemKey DRMStatusItem = 254;
            static const ::Courier::DataItemKey Visible_DRMServiceItem = 594;
            static const ::Courier::DataItemKey Visible_DRMRadioTextItem = 209;
            static const ::Courier::DataItemKey Visible_DRMFrequencyItem = 78;
            static const ::Courier::DataItemKey DRMPTYItem = 595;
            static const ::Courier::DataItemKey Icon_stationItem = 98;
            static const ::Courier::DataItemKey DAB_Icon_stationItem = 189;
    } // namespace StationInfoSource

    namespace HDIconPreset1 {
            static const ::Courier::DataItemKey HD_Preset_1Item = 373;
            static const ::Courier::DataItemKey HD_Preset_1_valueItem = 684;
    } // namespace HDIconPreset1

    namespace tuningScale_SliderMarkerPosition {
            static const ::Courier::DataItemKey CurrentValueItem = 679;
            static const ::Courier::DataItemKey DragCurrentValueItem = 389;
    } // namespace tuningScale_SliderMarkerPosition

    namespace HDIconPreset9 {
            static const ::Courier::DataItemKey HD_Preset_9Item = 449;
            static const ::Courier::DataItemKey HD_Preset_9_valueItem = 439;
    } // namespace HDIconPreset9

    namespace EngineeringInfo {
            static const ::Courier::DataItemKey _szFrequencyItem = 200;
            static const ::Courier::DataItemKey _szPSNameItem = 119;
            static const ::Courier::DataItemKey _szPIItem = 110;
            static const ::Courier::DataItemKey _szFieldstrengthItem = 105;
            static const ::Courier::DataItemKey _szQualityItem = 194;
            static const ::Courier::DataItemKey _szSharxItem = 442;
            static const ::Courier::DataItemKey _szHicutItem = 232;
            static const ::Courier::DataItemKey _szFMDeviationItem = 580;
            static const ::Courier::DataItemKey _szChannelSeparationItem = 257;
    } // namespace EngineeringInfo

    namespace DABTestModeEnsembleInfo {
            static const ::Courier::DataItemKey NoOfAud_DataServiceCompItem = 403;
            static const ::Courier::DataItemKey NoOfAud_DataServiceItem = 483;
            static const ::Courier::DataItemKey NoOfEnsemblesItem = 293;
    } // namespace DABTestModeEnsembleInfo

    namespace AMFMLogoImage {
            static const ::Courier::DataItemKey AMFMLogoItem = 252;
            static const ::Courier::DataItemKey AMFMDefalutLogoItem = 339;
            static const ::Courier::DataItemKey AMFMLogoVisibilityItem = 393;
    } // namespace AMFMLogoImage

    namespace HDIconPreset11 {
            static const ::Courier::DataItemKey HD_Preset_11Item = 214;
            static const ::Courier::DataItemKey HD_Preset_11_valueItem = 229;
    } // namespace HDIconPreset11

    namespace PresetInfoFMAST {
            static const ::Courier::DataItemKey PSName1Item = 583;
            static const ::Courier::DataItemKey PSName2Item = 441;
            static const ::Courier::DataItemKey PSName3Item = 633;
            static const ::Courier::DataItemKey PSName4Item = 538;
            static const ::Courier::DataItemKey PSName5Item = 17;
            static const ::Courier::DataItemKey PSName6Item = 603;
    } // namespace PresetInfoFMAST

    namespace DABTestModeGAvailabiltyInfo {
            static const ::Courier::DataItemKey TAItem = 509;
            static const ::Courier::DataItemKey IndicatorItem = 473;
            static const ::Courier::DataItemKey DABDABItem = 569;
    } // namespace DABTestModeGAvailabiltyInfo

    namespace DABGTestModeInfo {
            static const ::Courier::DataItemKey FMItem = 198;
            static const ::Courier::DataItemKey PIItem = 203;
            static const ::Courier::DataItemKey QFMItem = 106;
            static const ::Courier::DataItemKey PLItem = 494;
    } // namespace DABGTestModeInfo

    namespace DABGTestModeActiveComp {
            static const ::Courier::DataItemKey SCItem = 600;
            static const ::Courier::DataItemKey SCTypeItem = 383;
    } // namespace DABGTestModeActiveComp

    namespace TestModeAvailabilityInfo {
            static const ::Courier::DataItemKey FMTestModeAvailItem = 169;
            static const ::Courier::DataItemKey DABTestModeAvailItem = 477;
    } // namespace TestModeAvailabilityInfo

    namespace PresetInfoFM1 {
            static const ::Courier::DataItemKey PSName1Item = 355;
            static const ::Courier::DataItemKey PSName2Item = 321;
            static const ::Courier::DataItemKey PSName3Item = 437;
            static const ::Courier::DataItemKey PSName4Item = 394;
            static const ::Courier::DataItemKey PSName5Item = 354;
            static const ::Courier::DataItemKey PSName6Item = 322;
    } // namespace PresetInfoFM1

    namespace TMHDAudioSPS3 {
            static const ::Courier::DataItemKey TMHD_Prog_SPS3_switchItem = 8;
            static const ::Courier::DataItemKey TMHD_Prog_SPS3_availableItem = 174;
    } // namespace TMHDAudioSPS3

    namespace HDIconPreset2 {
            static const ::Courier::DataItemKey HD_Preset_2Item = 131;
            static const ::Courier::DataItemKey HD_Preset_2_valueItem = 71;
    } // namespace HDIconPreset2

    namespace HDProgramListVisibility {
            static const ::Courier::DataItemKey isHdProgramListVisibleItem = 248;
    } // namespace HDProgramListVisibility

    namespace CheckBoxListItem {
            static const ::Courier::DataItemKey ListItemNameItem = 626;
            static const ::Courier::DataItemKey ToggleIconSwitchIndexItem = 498;
    } // namespace CheckBoxListItem

    namespace HomeScreenAmHdLogo {
            static const ::Courier::DataItemKey HomeScreen_AmHdLogoItem = 382;
    } // namespace HomeScreenAmHdLogo

    namespace HomeScreenInfo {
            static const ::Courier::DataItemKey HomeScreen_ActiveIconIndexItem = 644;
            static const ::Courier::DataItemKey HomeScreen_ActiveSourceTextItem = 81;
            static const ::Courier::DataItemKey HomeScreen_DABServiceNameItem = 313;
            static const ::Courier::DataItemKey HomeScreen_ScanInvisibleItem = 380;
            static const ::Courier::DataItemKey HomeScreen_DABServicevisiblityItem = 391;
            static const ::Courier::DataItemKey HomeScreen_MuteIconStatusItem = 195;
            static const ::Courier::DataItemKey HomeFrequencyItem = 499;
            static const ::Courier::DataItemKey HomeScreen_PACStatusItem = 223;
            static const ::Courier::DataItemKey HomeWeatherbandTextItem = 612;
            static const ::Courier::DataItemKey FrequencyUnitItem = 72;
            static const ::Courier::DataItemKey HomeScreen_NextPreviousIconStatusItem = 540;
            static const ::Courier::DataItemKey HomeFrequencyStationNameItem = 436;
            static const ::Courier::DataItemKey HomeFrequencyStationNameVisibilityItem = 507;
    } // namespace HomeScreenInfo

    namespace PresetInfoFM2 {
            static const ::Courier::DataItemKey PSName1Item = 160;
            static const ::Courier::DataItemKey PSName2Item = 651;
            static const ::Courier::DataItemKey PSName3Item = 24;
            static const ::Courier::DataItemKey PSName4Item = 231;
            static const ::Courier::DataItemKey PSName5Item = 699;
            static const ::Courier::DataItemKey PSName6Item = 513;
    } // namespace PresetInfoFM2

    namespace HomeScreenFmHdLogo {
            static const ::Courier::DataItemKey HomeScreen_FmHdLogoItem = 148;
    } // namespace HomeScreenFmHdLogo

    namespace HDIconPreset6 {
            static const ::Courier::DataItemKey HD_Preset_6Item = 236;
            static const ::Courier::DataItemKey HD_Preset_6_valueItem = 350;
    } // namespace HDIconPreset6

    namespace HDIconPreset3 {
            static const ::Courier::DataItemKey HD_Preset_3Item = 486;
            static const ::Courier::DataItemKey HD_Preset_3_valueItem = 55;
    } // namespace HDIconPreset3

    namespace TMHDAudioSPS2 {
            static const ::Courier::DataItemKey TMHD_Prog_SPS2_switchItem = 485;
            static const ::Courier::DataItemKey TMHD_Prog_SPS2_availableItem = 206;
    } // namespace TMHDAudioSPS2

    namespace TMHDAudioSPS5 {
            static const ::Courier::DataItemKey TMHD_Prog_SPS5_switchItem = 10;
            static const ::Courier::DataItemKey TMHD_Prog_SPS5_availableItem = 530;
    } // namespace TMHDAudioSPS5

    namespace LayerNextPresets_DAB {
            static const ::Courier::DataItemKey NextPreviousIndex_DABItem = 661;
    } // namespace LayerNextPresets_DAB

    namespace DABGTestModeAnnoStatusInfo {
            static const ::Courier::DataItemKey ASWItem = 145;
            static const ::Courier::DataItemKey ASUItem = 215;
    } // namespace DABGTestModeAnnoStatusInfo

    namespace LayerNextPresets_FM {
            static const ::Courier::DataItemKey NextPreviousIndex_FMItem = 586;
    } // namespace LayerNextPresets_FM

    namespace HDIconPreset4 {
            static const ::Courier::DataItemKey HD_Preset_4Item = 68;
            static const ::Courier::DataItemKey HD_Preset_4_valueItem = 619;
    } // namespace HDIconPreset4

    namespace HDIconPreset5 {
            static const ::Courier::DataItemKey HD_Preset_5Item = 341;
            static const ::Courier::DataItemKey HD_Preset_5_valueItem = 343;
    } // namespace HDIconPreset5

    namespace DtmHD {
            static const ::Courier::DataItemKey HDStatusItem = 167;
            static const ::Courier::DataItemKey SISStatusItem = 613;
            static const ::Courier::DataItemKey AUDStatusItem = 140;
            static const ::Courier::DataItemKey BlendStatusItem = 11;
            static const ::Courier::DataItemKey HDCallSignItem = 307;
            static const ::Courier::DataItemKey HD10FreqItem = 543;
            static const ::Courier::DataItemKey HD10FSTItem = 578;
            static const ::Courier::DataItemKey HD10CdNoItem = 529;
            static const ::Courier::DataItemKey HD10AudQualItem = 689;
            static const ::Courier::DataItemKey HD05FreqItem = 478;
            static const ::Courier::DataItemKey HD05FSTItem = 272;
            static const ::Courier::DataItemKey HD05CdNoItem = 124;
            static const ::Courier::DataItemKey TransitionsItem = 497;
    } // namespace DtmHD

    namespace PresetInfoAMAST {
            static const ::Courier::DataItemKey PSName1Item = 83;
            static const ::Courier::DataItemKey PSName2Item = 122;
            static const ::Courier::DataItemKey PSName3Item = 521;
            static const ::Courier::DataItemKey PSName4Item = 465;
            static const ::Courier::DataItemKey PSName5Item = 154;
            static const ::Courier::DataItemKey PSName6Item = 202;
    } // namespace PresetInfoAMAST

    namespace Tuner4 {
            static const ::Courier::DataItemKey FreqItem = 352;
            static const ::Courier::DataItemKey PIItem = 432;
            static const ::Courier::DataItemKey PSItem = 205;
            static const ::Courier::DataItemKey FSQItem = 262;
            static const ::Courier::DataItemKey HicutItem = 220;
            static const ::Courier::DataItemKey SharxItem = 471;
            static const ::Courier::DataItemKey TPItem = 267;
            static const ::Courier::DataItemKey TAItem = 213;
            static const ::Courier::DataItemKey RDSItem = 58;
            static const ::Courier::DataItemKey AFItem = 675;
            static const ::Courier::DataItemKey DevItem = 246;
            static const ::Courier::DataItemKey CSItem = 691;
            static const ::Courier::DataItemKey MPNCItem = 182;
            static const ::Courier::DataItemKey BandItem = 349;
    } // namespace Tuner4

    namespace HDIconPreset12 {
            static const ::Courier::DataItemKey HD_Preset_12Item = 51;
            static const ::Courier::DataItemKey HD_Preset_12_valueItem = 484;
    } // namespace HDIconPreset12

    namespace TMHDAudioSPS4 {
            static const ::Courier::DataItemKey TMHD_Prog_SPS4_switchItem = 500;
            static const ::Courier::DataItemKey TMHD_Prog_SPS4_availableItem = 536;
    } // namespace TMHDAudioSPS4

    namespace FMAMPresetInfo {
            static const ::Courier::DataItemKey Preset_1_ActiveItem = 268;
            static const ::Courier::DataItemKey Preset_2_ActiveItem = 504;
            static const ::Courier::DataItemKey Preset_3_ActiveItem = 648;
            static const ::Courier::DataItemKey Preset_4_ActiveItem = 459;
            static const ::Courier::DataItemKey Preset_5_ActiveItem = 519;
            static const ::Courier::DataItemKey Preset_6_ActiveItem = 653;
            static const ::Courier::DataItemKey Preset_7_ActiveItem = 76;
            static const ::Courier::DataItemKey Preset_8_ActiveItem = 196;
            static const ::Courier::DataItemKey Preset_9_ActiveItem = 28;
            static const ::Courier::DataItemKey Preset_10_ActiveItem = 19;
            static const ::Courier::DataItemKey Preset_11_ActiveItem = 551;
            static const ::Courier::DataItemKey Preset_12_ActiveItem = 109;
    } // namespace FMAMPresetInfo

    namespace FmHdLogo {
            static const ::Courier::DataItemKey FmHdLogoIndexItem = 64;
    } // namespace FmHdLogo

    namespace Scan_Status {
            static const ::Courier::DataItemKey IsActiveScanItem = 574;
    } // namespace Scan_Status

    namespace HDIconPreset8 {
            static const ::Courier::DataItemKey HD_Preset_8Item = 147;
            static const ::Courier::DataItemKey HD_Preset_8_valueItem = 144;
    } // namespace HDIconPreset8
} // namespace ItemKey

bool InitDataBinding();

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::CheckBoxListItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::CheckBoxListItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::StationInfoSourceDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::StationInfoSourceDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HomeScreenInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HomeScreenInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::RadioBandInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::RadioBandInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::FMStationListDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::FMStationListDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::RDSOptionsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::RDSOptionsDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PresetInfoWBDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PresetInfoWBDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::WBPresetInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::WBPresetInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PresetInfoFM1DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PresetInfoFM1DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PresetInfoFM2DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PresetInfoFM2DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PresetInfoFMASTDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PresetInfoFMASTDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PresetInfoAMDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PresetInfoAMDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PresetInfoAMASTDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PresetInfoAMASTDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PresetInfoDABDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PresetInfoDABDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PresetInfoDABASTDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PresetInfoDABASTDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PresetInfoDRMDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PresetInfoDRMDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PresetInfoDRMASTDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PresetInfoDRMASTDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::EngineeringInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::EngineeringInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::LayerNextPresets_FMDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::LayerNextPresets_FMDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::LayerNextPresets_AMDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::LayerNextPresets_AMDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::LayerNextPresets_DABDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::LayerNextPresets_DABDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::EngineeringInfo1DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::EngineeringInfo1DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::EngineeringInfo2DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::EngineeringInfo2DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::EngineeringInfoDRMDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::EngineeringInfoDRMDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Scan_ASTDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Scan_ASTDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Scan_StatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Scan_StatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Source_SlectionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Source_SlectionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Preset_PopupDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Preset_PopupDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PgBar_timerDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PgBar_timerDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::tuningScale_SliderMarkerPositionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::tuningScale_SliderMarkerPositionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::tuningSliderDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::tuningSliderDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TunerOptionsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TunerOptionsDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DABOptionsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DABOptionsDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DRMOptionsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DRMOptionsDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MenuSelectionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MenuSelectionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Menu_NumOptionsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Menu_NumOptionsDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AppFlyInDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AppFlyInDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BrowseListPointerDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BrowseListPointerDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BrowseListSizeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BrowseListSizeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BrowseListSelectedLineDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BrowseListSelectedLineDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DABChannelInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DABChannelInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ActiveBankInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ActiveBankInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ActiveSourceInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ActiveSourceInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::VariantInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::VariantInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TAInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TAInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DABPresetInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DABPresetInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::FMAMPresetInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::FMAMPresetInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AMPresetInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AMPresetInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Tuner1DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Tuner1DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Tuner2DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Tuner2DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Tuner3DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Tuner3DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Tuner4DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Tuner4DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TunerSource_BandDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TunerSource_BandDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DAB_Setup_ScreenDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DAB_Setup_ScreenDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DAB_Test_ModeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DAB_Test_ModeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DAB_Setup_Screen_ActiveTuner_InfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DAB_Setup_Screen_ActiveTuner_InfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DABTestModeEnsembleInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DABTestModeEnsembleInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DABGTestModeInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DABGTestModeInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DABGTestModeAnnoStatusInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DABGTestModeAnnoStatusInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DABGTestModeActiveCompDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DABGTestModeActiveCompDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DABTestModeGAvailabiltyInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DABTestModeGAvailabiltyInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DABTestModeServiceFollowingInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DABTestModeServiceFollowingInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TmcInformationDataDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TmcInformationDataDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TmcStationInfoDataDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TmcStationInfoDataDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TestModeAvailabilityInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TestModeAvailabilityInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::FMSetupMenuInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::FMSetupMenuInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::NextPrevious_Status_FMDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::NextPrevious_Status_FMDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::NextPrevious_Status_AMDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::NextPrevious_Status_AMDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::NextPrevious_Status_DABDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::NextPrevious_Status_DABDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SearchNextPrevious_IconActiveDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SearchNextPrevious_IconActiveDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AMFMLogoImageDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AMFMLogoImageDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ChannelInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ChannelInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::FmHdLogoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::FmHdLogoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AmHdLogoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AmHdLogoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDButtonVisibilityDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDButtonVisibilityDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AmHdOnOffDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AmHdOnOffDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::FmHdOnOffDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::FmHdOnOffDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDProgramListVisibilityDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDProgramListVisibilityDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDAudioMPSDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDAudioMPSDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDAudioSPS1DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDAudioSPS1DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDAudioSPS2DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDAudioSPS2DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDAudioSPS3DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDAudioSPS3DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDAudioSPS4DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDAudioSPS4DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDAudioSPS5DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDAudioSPS5DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDAudioSPS6DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDAudioSPS6DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDAudioSPS7DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDAudioSPS7DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDIconPreset1DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDIconPreset1DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDIconPreset2DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDIconPreset2DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDIconPreset3DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDIconPreset3DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDIconPreset4DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDIconPreset4DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDIconPreset5DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDIconPreset5DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDIconPreset6DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDIconPreset6DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDIconPreset7DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDIconPreset7DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDIconPreset8DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDIconPreset8DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDIconPreset9DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDIconPreset9DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDIconPreset10DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDIconPreset10DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDIconPreset11DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDIconPreset11DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDIconPreset12DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDIconPreset12DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DtmHDDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DtmHDDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HDParamTuningIconDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HDParamTuningIconDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TMHDAudioMPSDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TMHDAudioMPSDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TMHDAudioSPS1DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TMHDAudioSPS1DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TMHDAudioSPS2DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TMHDAudioSPS2DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TMHDAudioSPS3DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TMHDAudioSPS3DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TMHDAudioSPS4DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TMHDAudioSPS4DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TMHDAudioSPS5DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TMHDAudioSPS5DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TMHDAudioSPS6DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TMHDAudioSPS6DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TMHDAudioSPS7DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TMHDAudioSPS7DataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::RdsRadioTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::RdsRadioTextDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HomeScreenFmHdLogoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HomeScreenFmHdLogoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HomeScreenAmHdLogoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HomeScreenAmHdLogoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SPIVisibilityTunerDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SPIVisibilityTunerDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::CarModeVisibilityDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::CarModeVisibilityDataBindingSource > const& dataItemContainer);
} // namespace FeatStd
#endif // FEATSTD_STRINGBUFFER_APPENDER_ENABLED
#endif // AppHmi_TunerStateMachine_h
