/************************************************************************
*FILE: AppHmi_TunerMessages.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(AppHmi_TunerMessages_h)
#define AppHmi_TunerMessages_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Courier/Messaging/Message.h>
#include <Courier/Platform/MessageFactory.h>
#include <ProjectBaseMsgs.h>
#include <AppHmi_TunerTypes.h>
#include <CanderaWidget/String/String.h>
// ------------------------------------------------------------------------
class AppStatusUpdateMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(AppStatusUpdateMsg, ::NotifierMessage, 0x6E0311B4);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        AppStatusUpdateMsg(Courier::Int8 const & aAppStatus);
        virtual ~AppStatusUpdateMsg();

        Courier::Int8 const & GetAppStatus() const { return mAppStatus; }
        void SetAppStatus(Courier::Int8 const & value) { mAppStatus = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(AppStatusUpdateMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mAppStatusUpdateMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mAppStatusUpdateMsgModifiableMetadata;
        static const ::Courier::ComponentId mAppStatusUpdateMsgSubscriberList[];

        Courier::Int8 mAppStatus;
};

// ------------------------------------------------------------------------
class PresetPopupMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(PresetPopupMsg, ::NotifierMessage, 0xA862724E);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        PresetPopupMsg(Courier::Int8 const & aPresetNumber);
        virtual ~PresetPopupMsg();

        Courier::Int8 const & GetPresetNumber() const { return mPresetNumber; }
        void SetPresetNumber(Courier::Int8 const & value) { mPresetNumber = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(PresetPopupMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mPresetPopupMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mPresetPopupMsgModifiableMetadata;
        static const ::Courier::ComponentId mPresetPopupMsgSubscriberList[];

        Courier::Int8 mPresetNumber;
};

// ------------------------------------------------------------------------
class CannotStorePopupMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CannotStorePopupMsg, ::NotifierMessage, 0x36608361);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        CannotStorePopupMsg();
        virtual ~CannotStorePopupMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCannotStorePopupMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCannotStorePopupMsgModifiableMetadata;
        static const ::Courier::ComponentId mCannotStorePopupMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class LPReleaseMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(LPReleaseMsg, ::NotifierMessage, 0x5DBE0483);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        LPReleaseMsg(Courier::Int8 const & aPresetNumber);
        virtual ~LPReleaseMsg();

        Courier::Int8 const & GetPresetNumber() const { return mPresetNumber; }
        void SetPresetNumber(Courier::Int8 const & value) { mPresetNumber = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(LPReleaseMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mLPReleaseMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mLPReleaseMsgModifiableMetadata;
        static const ::Courier::ComponentId mLPReleaseMsgSubscriberList[];

        Courier::Int8 mPresetNumber;
};

// ------------------------------------------------------------------------
class Popup_PFO_TA : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(Popup_PFO_TA, ::NotifierMessage, 0x815A24B6);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        Popup_PFO_TA();
        virtual ~Popup_PFO_TA();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mPopup_PFO_TAMetaData;
        static ::Courier::Message::ModifiableMetadata mPopup_PFO_TAModifiableMetadata;
        static const ::Courier::ComponentId mPopup_PFO_TASubscriberList[];
};

// ------------------------------------------------------------------------
class Popup_PFO_PTY31 : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(Popup_PFO_PTY31, ::NotifierMessage, 0xC469BFCB);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        Popup_PFO_PTY31();
        virtual ~Popup_PFO_PTY31();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mPopup_PFO_PTY31MetaData;
        static ::Courier::Message::ModifiableMetadata mPopup_PFO_PTY31ModifiableMetadata;
        static const ::Courier::ComponentId mPopup_PFO_PTY31SubscriberList[];
};

// ------------------------------------------------------------------------
class Popup_PFO_TAclose : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(Popup_PFO_TAclose, ::NotifierMessage, 0xB06A0D7F);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        Popup_PFO_TAclose();
        virtual ~Popup_PFO_TAclose();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mPopup_PFO_TAcloseMetaData;
        static ::Courier::Message::ModifiableMetadata mPopup_PFO_TAcloseModifiableMetadata;
        static const ::Courier::ComponentId mPopup_PFO_TAcloseSubscriberList[];
};

// ------------------------------------------------------------------------
class Popup_PFO_PTY31close : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(Popup_PFO_PTY31close, ::NotifierMessage, 0xE15D254D);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        Popup_PFO_PTY31close();
        virtual ~Popup_PFO_PTY31close();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mPopup_PFO_PTY31closeMetaData;
        static ::Courier::Message::ModifiableMetadata mPopup_PFO_PTY31closeModifiableMetadata;
        static const ::Courier::ComponentId mPopup_PFO_PTY31closeSubscriberList[];
};

// ------------------------------------------------------------------------
class Popup_PFO_AST : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(Popup_PFO_AST, ::NotifierMessage, 0x2717107B);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        Popup_PFO_AST();
        virtual ~Popup_PFO_AST();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mPopup_PFO_ASTMetaData;
        static ::Courier::Message::ModifiableMetadata mPopup_PFO_ASTModifiableMetadata;
        static const ::Courier::ComponentId mPopup_PFO_ASTSubscriberList[];
};

// ------------------------------------------------------------------------
class Popup_PFO_ASTClose : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(Popup_PFO_ASTClose, ::NotifierMessage, 0xEFCC8AD1);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        Popup_PFO_ASTClose();
        virtual ~Popup_PFO_ASTClose();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mPopup_PFO_ASTCloseMetaData;
        static ::Courier::Message::ModifiableMetadata mPopup_PFO_ASTCloseModifiableMetadata;
        static const ::Courier::ComponentId mPopup_PFO_ASTCloseSubscriberList[];
};

// ------------------------------------------------------------------------
class Popup_PFO_WB : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(Popup_PFO_WB, ::NotifierMessage, 0x0A5C35C8);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        Popup_PFO_WB();
        virtual ~Popup_PFO_WB();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mPopup_PFO_WBMetaData;
        static ::Courier::Message::ModifiableMetadata mPopup_PFO_WBModifiableMetadata;
        static const ::Courier::ComponentId mPopup_PFO_WBSubscriberList[];
};

// ------------------------------------------------------------------------
class Popup_PFO_WBclose : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(Popup_PFO_WBclose, ::NotifierMessage, 0x7DE09752);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        Popup_PFO_WBclose();
        virtual ~Popup_PFO_WBclose();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mPopup_PFO_WBcloseMetaData;
        static ::Courier::Message::ModifiableMetadata mPopup_PFO_WBcloseModifiableMetadata;
        static const ::Courier::ComponentId mPopup_PFO_WBcloseSubscriberList[];
};

// ------------------------------------------------------------------------
class PresetSelectMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(PresetSelectMsg, ::NotifierMessage, 0xD82AE891);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        PresetSelectMsg(Courier::Int8 const & aPresetNumber);
        virtual ~PresetSelectMsg();

        Courier::Int8 const & GetPresetNumber() const { return mPresetNumber; }
        void SetPresetNumber(Courier::Int8 const & value) { mPresetNumber = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(PresetSelectMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mPresetSelectMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mPresetSelectMsgModifiableMetadata;
        static const ::Courier::ComponentId mPresetSelectMsgSubscriberList[];

        Courier::Int8 mPresetNumber;
};

// ------------------------------------------------------------------------
class PresetStoreMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(PresetStoreMsg, ::NotifierMessage, 0xCEF5DE87);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        PresetStoreMsg(Courier::Int8 const & aPresetNumber);
        virtual ~PresetStoreMsg();

        Courier::Int8 const & GetPresetNumber() const { return mPresetNumber; }
        void SetPresetNumber(Courier::Int8 const & value) { mPresetNumber = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(PresetStoreMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mPresetStoreMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mPresetStoreMsgModifiableMetadata;
        static const ::Courier::ComponentId mPresetStoreMsgSubscriberList[];

        Courier::Int8 mPresetNumber;
};

// ------------------------------------------------------------------------
class TuneFrequencyReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(TuneFrequencyReqMsg, ::NotifierMessage, 0x64267112);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        TuneFrequencyReqMsg(Courier::Int8 const & aDirection, Courier::Int8 const & aTicks);
        virtual ~TuneFrequencyReqMsg();

        Courier::Int8 const & GetDirection() const { return mDirection; }
        void SetDirection(Courier::Int8 const & value) { mDirection = value; }
        Courier::Int8 const & GetTicks() const { return mTicks; }
        void SetTicks(Courier::Int8 const & value) { mTicks = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(TuneFrequencyReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTuneFrequencyReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mTuneFrequencyReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mTuneFrequencyReqMsgSubscriberList[];

        Courier::Int8 mDirection;
        Courier::Int8 mTicks;
};

// ------------------------------------------------------------------------
class SeekReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SeekReqMsg, ::NotifierMessage, 0x8ECD7B8A);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SeekReqMsg(Courier::Int8 const & aSeekMode);
        virtual ~SeekReqMsg();

        Courier::Int8 const & GetSeekMode() const { return mSeekMode; }
        void SetSeekMode(Courier::Int8 const & value) { mSeekMode = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(SeekReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSeekReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSeekReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mSeekReqMsgSubscriberList[];

        Courier::Int8 mSeekMode;
};

// ------------------------------------------------------------------------
class ScanReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ScanReqMsg, ::NotifierMessage, 0x4859892E);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ScanReqMsg(Courier::Int8 const & aScanMode);
        virtual ~ScanReqMsg();

        Courier::Int8 const & GetScanMode() const { return mScanMode; }
        void SetScanMode(Courier::Int8 const & value) { mScanMode = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ScanReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mScanReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mScanReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mScanReqMsgSubscriberList[];

        Courier::Int8 mScanMode;
};

// ------------------------------------------------------------------------
class AutoStoreReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(AutoStoreReqMsg, ::NotifierMessage, 0x5EFCE13C);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        AutoStoreReqMsg();
        virtual ~AutoStoreReqMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mAutoStoreReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mAutoStoreReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mAutoStoreReqMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class SourceSelReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SourceSelReqMsg, ::NotifierMessage, 0xF7036B75);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SourceSelReqMsg(Courier::Int8 const & aSource);
        virtual ~SourceSelReqMsg();

        Courier::Int8 const & GetSource() const { return mSource; }
        void SetSource(Courier::Int8 const & value) { mSource = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(SourceSelReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSourceSelReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSourceSelReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mSourceSelReqMsgSubscriberList[];

        Courier::Int8 mSource;
};

// ------------------------------------------------------------------------
class TunerViewReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(TunerViewReqMsg, ::NotifierMessage, 0xEEF4E619);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        TunerViewReqMsg(Courier::UInt8 const & aView);
        virtual ~TunerViewReqMsg();

        Courier::UInt8 const & GetView() const { return mView; }
        void SetView(Courier::UInt8 const & value) { mView = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(TunerViewReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTunerViewReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mTunerViewReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mTunerViewReqMsgSubscriberList[];

        Courier::UInt8 mView;
};

// ------------------------------------------------------------------------
class Tuner_TestmodeViewReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(Tuner_TestmodeViewReqMsg, ::NotifierMessage, 0x36283C6F);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        Tuner_TestmodeViewReqMsg(Courier::UInt8 const & aTestmode_Value);
        virtual ~Tuner_TestmodeViewReqMsg();

        Courier::UInt8 const & GetTestmode_Value() const { return mTestmode_Value; }
        void SetTestmode_Value(Courier::UInt8 const & value) { mTestmode_Value = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(Tuner_TestmodeViewReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTuner_TestmodeViewReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mTuner_TestmodeViewReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mTuner_TestmodeViewReqMsgSubscriberList[];

        Courier::UInt8 mTestmode_Value;
};

// ------------------------------------------------------------------------
class DABServiceReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DABServiceReqMsg, ::NotifierMessage, 0xB5A9C463);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DABServiceReqMsg(Courier::UInt8 const & aService_Value);
        virtual ~DABServiceReqMsg();

        Courier::UInt8 const & GetService_Value() const { return mService_Value; }
        void SetService_Value(Courier::UInt8 const & value) { mService_Value = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DABServiceReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDABServiceReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mDABServiceReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mDABServiceReqMsgSubscriberList[];

        Courier::UInt8 mService_Value;
};

// ------------------------------------------------------------------------
class DABServiceLinkReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DABServiceLinkReqMsg, ::NotifierMessage, 0x27E54F2A);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DABServiceLinkReqMsg(Courier::UInt8 const & aService_Value);
        virtual ~DABServiceLinkReqMsg();

        Courier::UInt8 const & GetService_Value() const { return mService_Value; }
        void SetService_Value(Courier::UInt8 const & value) { mService_Value = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DABServiceLinkReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDABServiceLinkReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mDABServiceLinkReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mDABServiceLinkReqMsgSubscriberList[];

        Courier::UInt8 mService_Value;
};

// ------------------------------------------------------------------------
class DABCLevelReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DABCLevelReqMsg, ::NotifierMessage, 0x06081C05);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DABCLevelReqMsg(Courier::UInt8 const & aCLevel_Value);
        virtual ~DABCLevelReqMsg();

        Courier::UInt8 const & GetCLevel_Value() const { return mCLevel_Value; }
        void SetCLevel_Value(Courier::UInt8 const & value) { mCLevel_Value = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DABCLevelReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDABCLevelReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mDABCLevelReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mDABCLevelReqMsgSubscriberList[];

        Courier::UInt8 mCLevel_Value;
};

// ------------------------------------------------------------------------
class TestModeDABQuality : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(TestModeDABQuality, ::NotifierMessage, 0x924223E5);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        TestModeDABQuality(Courier::UInt8 const & aDABTestModeActiveStatus);
        virtual ~TestModeDABQuality();

        Courier::UInt8 const & GetDABTestModeActiveStatus() const { return mDABTestModeActiveStatus; }
        void SetDABTestModeActiveStatus(Courier::UInt8 const & value) { mDABTestModeActiveStatus = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(TestModeDABQuality);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTestModeDABQualityMetaData;
        static ::Courier::Message::ModifiableMetadata mTestModeDABQualityModifiableMetadata;
        static const ::Courier::ComponentId mTestModeDABQualitySubscriberList[];

        Courier::UInt8 mDABTestModeActiveStatus;
};

// ------------------------------------------------------------------------
class Slider_TunerFrequencyMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(Slider_TunerFrequencyMsg, ::NotifierMessage, 0x585AA0BB);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        Slider_TunerFrequencyMsg(Courier::Int32 const & aCurrent_Frequency_Value);
        virtual ~Slider_TunerFrequencyMsg();

        Courier::Int32 const & GetCurrent_Frequency_Value() const { return mCurrent_Frequency_Value; }
        void SetCurrent_Frequency_Value(Courier::Int32 const & value) { mCurrent_Frequency_Value = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(Slider_TunerFrequencyMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSlider_TunerFrequencyMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSlider_TunerFrequencyMsgModifiableMetadata;
        static const ::Courier::ComponentId mSlider_TunerFrequencyMsgSubscriberList[];

        Courier::Int32 mCurrent_Frequency_Value;
};

// ------------------------------------------------------------------------
class MediaChangeMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(MediaChangeMsg, ::NotifierMessage, 0xB1DFD16D);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        MediaChangeMsg();
        virtual ~MediaChangeMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mMediaChangeMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mMediaChangeMsgModifiableMetadata;
        static const ::Courier::ComponentId mMediaChangeMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class HomeScreenMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(HomeScreenMsg, ::NotifierMessage, 0xC55914E3);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        HomeScreenMsg();
        virtual ~HomeScreenMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mHomeScreenMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mHomeScreenMsgModifiableMetadata;
        static const ::Courier::ComponentId mHomeScreenMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class BTPhoneMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(BTPhoneMsg, ::NotifierMessage, 0x282066B2);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        BTPhoneMsg();
        virtual ~BTPhoneMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mBTPhoneMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mBTPhoneMsgModifiableMetadata;
        static const ::Courier::ComponentId mBTPhoneMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class NaviMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(NaviMsg, ::NotifierMessage, 0xBEAE600D);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        NaviMsg();
        virtual ~NaviMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mNaviMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mNaviMsgModifiableMetadata;
        static const ::Courier::ComponentId mNaviMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class MirrorLinkMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(MirrorLinkMsg, ::NotifierMessage, 0x646E99B7);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        MirrorLinkMsg();
        virtual ~MirrorLinkMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mMirrorLinkMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mMirrorLinkMsgModifiableMetadata;
        static const ::Courier::ComponentId mMirrorLinkMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class TunerViewMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(TunerViewMsg, ::NotifierMessage, 0xB88C5200);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        TunerViewMsg();
        virtual ~TunerViewMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTunerViewMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mTunerViewMsgModifiableMetadata;
        static const ::Courier::ComponentId mTunerViewMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class EnableView : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(EnableView, ::NotifierMessage, 0x8BBD0734);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        EnableView(::Courier::ViewId const & aViewName);
        virtual ~EnableView();

        ::Courier::ViewId const & GetViewName() const { return mViewName; }
        void SetViewName(::Courier::ViewId const & value) { mViewName = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(EnableView);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mEnableViewMetaData;
        static ::Courier::Message::ModifiableMetadata mEnableViewModifiableMetadata;
        static const ::Courier::ComponentId mEnableViewSubscriberList[];

        ::Courier::ViewId mViewName;
};

// ------------------------------------------------------------------------
class DisableView : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DisableView, ::NotifierMessage, 0x8D4DB5D8);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        DisableView(::Courier::ViewId const & aViewName);
        virtual ~DisableView();

        ::Courier::ViewId const & GetViewName() const { return mViewName; }
        void SetViewName(::Courier::ViewId const & value) { mViewName = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DisableView);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDisableViewMetaData;
        static ::Courier::Message::ModifiableMetadata mDisableViewModifiableMetadata;
        static const ::Courier::ComponentId mDisableViewSubscriberList[];

        ::Courier::ViewId mViewName;
};

// ------------------------------------------------------------------------
class TunerAppActReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(TunerAppActReqMsg, ::NotifierMessage, 0xA7016528);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        TunerAppActReqMsg();
        virtual ~TunerAppActReqMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTunerAppActReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mTunerAppActReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mTunerAppActReqMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class RDSSupport : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(RDSSupport, ::NotifierMessage, 0xD64AFB3B);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        RDSSupport(bool const & aRDSStatus);
        virtual ~RDSSupport();

        bool const & GetRDSStatus() const { return mRDSStatus; }
        void SetRDSStatus(bool const & value) { mRDSStatus = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(RDSSupport);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mRDSSupportMetaData;
        static ::Courier::Message::ModifiableMetadata mRDSSupportModifiableMetadata;
        static const ::Courier::ComponentId mRDSSupportSubscriberList[];

        bool mRDSStatus;
};

// ------------------------------------------------------------------------
class TunerBLMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(TunerBLMsg, ::NotifierMessage, 0xD24B9024);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        TunerBLMsg(Courier::Int8 const & aEventId, Courier::Int32 const & aFirstArg, Courier::Int32 const & aSecondArg);
        virtual ~TunerBLMsg();

        Courier::Int8 const & GetEventId() const { return mEventId; }
        void SetEventId(Courier::Int8 const & value) { mEventId = value; }
        Courier::Int32 const & GetFirstArg() const { return mFirstArg; }
        void SetFirstArg(Courier::Int32 const & value) { mFirstArg = value; }
        Courier::Int32 const & GetSecondArg() const { return mSecondArg; }
        void SetSecondArg(Courier::Int32 const & value) { mSecondArg = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(TunerBLMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTunerBLMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mTunerBLMsgModifiableMetadata;
        static const ::Courier::ComponentId mTunerBLMsgSubscriberList[];

        Courier::Int8 mEventId;
        Courier::Int32 mFirstArg;
        Courier::Int32 mSecondArg;
};

// ------------------------------------------------------------------------
class TunerPLMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(TunerPLMsg, ::NotifierMessage, 0xB490953C);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        TunerPLMsg(Courier::Int8 const & aEventId, Courier::Int32 const & aFirstArg, Candera::String const & aSecondArg);
        virtual ~TunerPLMsg();

        Courier::Int8 const & GetEventId() const { return mEventId; }
        void SetEventId(Courier::Int8 const & value) { mEventId = value; }
        Courier::Int32 const & GetFirstArg() const { return mFirstArg; }
        void SetFirstArg(Courier::Int32 const & value) { mFirstArg = value; }
        Candera::String const & GetSecondArg() const { return mSecondArg; }
        void SetSecondArg(Candera::String const & value) { mSecondArg = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(TunerPLMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTunerPLMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mTunerPLMsgModifiableMetadata;
        static const ::Courier::ComponentId mTunerPLMsgSubscriberList[];

        Courier::Int8 mEventId;
        Courier::Int32 mFirstArg;
        Candera::String mSecondArg;
};

// ------------------------------------------------------------------------
class EnableTESTModeView : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(EnableTESTModeView, ::NotifierMessage, 0xEBD18759);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        EnableTESTModeView(Candera::UInt8 const & aViewName);
        virtual ~EnableTESTModeView();

        Candera::UInt8 const & GetViewName() const { return mViewName; }
        void SetViewName(Candera::UInt8 const & value) { mViewName = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(EnableTESTModeView);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mEnableTESTModeViewMetaData;
        static ::Courier::Message::ModifiableMetadata mEnableTESTModeViewModifiableMetadata;
        static const ::Courier::ComponentId mEnableTESTModeViewSubscriberList[];

        Candera::UInt8 mViewName;
};

// ------------------------------------------------------------------------
class DABTMSeekReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DABTMSeekReqMsg, ::NotifierMessage, 0xACA524C3);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DABTMSeekReqMsg(Courier::Int8 const & aDABTMSeekMode);
        virtual ~DABTMSeekReqMsg();

        Courier::Int8 const & GetDABTMSeekMode() const { return mDABTMSeekMode; }
        void SetDABTMSeekMode(Courier::Int8 const & value) { mDABTMSeekMode = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DABTMSeekReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDABTMSeekReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mDABTMSeekReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mDABTMSeekReqMsgSubscriberList[];

        Courier::Int8 mDABTMSeekMode;
};

// ------------------------------------------------------------------------
class UpdateWaveBandStatusMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(UpdateWaveBandStatusMsg, ::NotifierMessage, 0x9880939A);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        UpdateWaveBandStatusMsg(Courier::Int32 const & aBand);
        virtual ~UpdateWaveBandStatusMsg();

        Courier::Int32 const & GetBand() const { return mBand; }
        void SetBand(Courier::Int32 const & value) { mBand = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(UpdateWaveBandStatusMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mUpdateWaveBandStatusMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mUpdateWaveBandStatusMsgModifiableMetadata;
        static const ::Courier::ComponentId mUpdateWaveBandStatusMsgSubscriberList[];

        Courier::Int32 mBand;
};

// ------------------------------------------------------------------------
class UpdateTunerStatusMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(UpdateTunerStatusMsg, ::NotifierMessage, 0xB4E1B382);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        UpdateTunerStatusMsg(Courier::UInt32 const & aActivateStatus);
        virtual ~UpdateTunerStatusMsg();

        Courier::UInt32 const & GetActivateStatus() const { return mActivateStatus; }
        void SetActivateStatus(Courier::UInt32 const & value) { mActivateStatus = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(UpdateTunerStatusMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mUpdateTunerStatusMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mUpdateTunerStatusMsgModifiableMetadata;
        static const ::Courier::ComponentId mUpdateTunerStatusMsgSubscriberList[];

        Courier::UInt32 mActivateStatus;
};

// ------------------------------------------------------------------------
class UpdateFrequencyMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(UpdateFrequencyMsg, ::NotifierMessage, 0x9F1803CB);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        UpdateFrequencyMsg(Candera::String const & aFrequency, Courier::UInt32 const & aBand);
        virtual ~UpdateFrequencyMsg();

        Candera::String const & GetFrequency() const { return mFrequency; }
        void SetFrequency(Candera::String const & value) { mFrequency = value; }
        Courier::UInt32 const & GetBand() const { return mBand; }
        void SetBand(Courier::UInt32 const & value) { mBand = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(UpdateFrequencyMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mUpdateFrequencyMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mUpdateFrequencyMsgModifiableMetadata;
        static const ::Courier::ComponentId mUpdateFrequencyMsgSubscriberList[];

        Candera::String mFrequency;
        Courier::UInt32 mBand;
};

// ------------------------------------------------------------------------
class UpdatePSNameTPMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(UpdatePSNameTPMsg, ::NotifierMessage, 0xAC223EE0);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        UpdatePSNameTPMsg(Candera::String const & aPSName);
        virtual ~UpdatePSNameTPMsg();

        Candera::String const & GetPSName() const { return mPSName; }
        void SetPSName(Candera::String const & value) { mPSName = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(UpdatePSNameTPMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mUpdatePSNameTPMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mUpdatePSNameTPMsgModifiableMetadata;
        static const ::Courier::ComponentId mUpdatePSNameTPMsgSubscriberList[];

        Candera::String mPSName;
};

// ------------------------------------------------------------------------
class ActivateTunerMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ActivateTunerMsg, ::NotifierMessage, 0xA5FF6E2E);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ActivateTunerMsg();
        virtual ~ActivateTunerMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mActivateTunerMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mActivateTunerMsgModifiableMetadata;
        static const ::Courier::ComponentId mActivateTunerMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class SetWaveBandMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SetWaveBandMsg, ::NotifierMessage, 0xBA129B4E);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SetWaveBandMsg(Courier::Int32 const & aBand);
        virtual ~SetWaveBandMsg();

        Courier::Int32 const & GetBand() const { return mBand; }
        void SetBand(Courier::Int32 const & value) { mBand = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(SetWaveBandMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSetWaveBandMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSetWaveBandMsgModifiableMetadata;
        static const ::Courier::ComponentId mSetWaveBandMsgSubscriberList[];

        Courier::Int32 mBand;
};

// ------------------------------------------------------------------------
class UpdateCheckBoxMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(UpdateCheckBoxMsg, ::NotifierMessage, 0x4F3D27B3);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        UpdateCheckBoxMsg(Courier::Int8 const & aMenuType, Courier::Int8 const & aCB_value);
        virtual ~UpdateCheckBoxMsg();

        Courier::Int8 const & GetMenuType() const { return mMenuType; }
        void SetMenuType(Courier::Int8 const & value) { mMenuType = value; }
        Courier::Int8 const & GetCB_value() const { return mCB_value; }
        void SetCB_value(Courier::Int8 const & value) { mCB_value = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(UpdateCheckBoxMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mUpdateCheckBoxMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mUpdateCheckBoxMsgModifiableMetadata;
        static const ::Courier::ComponentId mUpdateCheckBoxMsgSubscriberList[];

        Courier::Int8 mMenuType;
        Courier::Int8 mCB_value;
};

// ------------------------------------------------------------------------
class UpdatePresetMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(UpdatePresetMsg, ::NotifierMessage, 0xC202E37E);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        UpdatePresetMsg(Courier::Int8 const & aBankID, Candera::String const & aPSName_or_Frequency, Courier::Int8 const & aPresetNumber);
        virtual ~UpdatePresetMsg();

        Courier::Int8 const & GetBankID() const { return mBankID; }
        void SetBankID(Courier::Int8 const & value) { mBankID = value; }
        Candera::String const & GetPSName_or_Frequency() const { return mPSName_or_Frequency; }
        void SetPSName_or_Frequency(Candera::String const & value) { mPSName_or_Frequency = value; }
        Courier::Int8 const & GetPresetNumber() const { return mPresetNumber; }
        void SetPresetNumber(Courier::Int8 const & value) { mPresetNumber = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(UpdatePresetMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mUpdatePresetMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mUpdatePresetMsgModifiableMetadata;
        static const ::Courier::ComponentId mUpdatePresetMsgSubscriberList[];

        Courier::Int8 mBankID;
        Candera::String mPSName_or_Frequency;
        Courier::Int8 mPresetNumber;
};

// ------------------------------------------------------------------------
class UpdatePresetFocused : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(UpdatePresetFocused, ::NotifierMessage, 0x44F366E9);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        UpdatePresetFocused();
        virtual ~UpdatePresetFocused();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mUpdatePresetFocusedMetaData;
        static ::Courier::Message::ModifiableMetadata mUpdatePresetFocusedModifiableMetadata;
        static const ::Courier::ComponentId mUpdatePresetFocusedSubscriberList[];
};

// ------------------------------------------------------------------------
class UpdateFMPresetFocused : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(UpdateFMPresetFocused, ::NotifierMessage, 0x794BB640);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        UpdateFMPresetFocused();
        virtual ~UpdateFMPresetFocused();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mUpdateFMPresetFocusedMetaData;
        static ::Courier::Message::ModifiableMetadata mUpdateFMPresetFocusedModifiableMetadata;
        static const ::Courier::ComponentId mUpdateFMPresetFocusedSubscriberList[];
};

// ------------------------------------------------------------------------
class UpdateAMPresetFocused : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(UpdateAMPresetFocused, ::NotifierMessage, 0xDE129B36);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        UpdateAMPresetFocused();
        virtual ~UpdateAMPresetFocused();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mUpdateAMPresetFocusedMetaData;
        static ::Courier::Message::ModifiableMetadata mUpdateAMPresetFocusedModifiableMetadata;
        static const ::Courier::ComponentId mUpdateAMPresetFocusedSubscriberList[];
};

// ------------------------------------------------------------------------
class Update_Slider_TunerFrequencyMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(Update_Slider_TunerFrequencyMsg, ::NotifierMessage, 0x9B4A8943);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        Update_Slider_TunerFrequencyMsg(Courier::Int32 const & aCurrent_Frequency_Value);
        virtual ~Update_Slider_TunerFrequencyMsg();

        Courier::Int32 const & GetCurrent_Frequency_Value() const { return mCurrent_Frequency_Value; }
        void SetCurrent_Frequency_Value(Courier::Int32 const & value) { mCurrent_Frequency_Value = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(Update_Slider_TunerFrequencyMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mUpdate_Slider_TunerFrequencyMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mUpdate_Slider_TunerFrequencyMsgModifiableMetadata;
        static const ::Courier::ComponentId mUpdate_Slider_TunerFrequencyMsgSubscriberList[];

        Courier::Int32 mCurrent_Frequency_Value;
};

// ------------------------------------------------------------------------
class Update_ProgressBarMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(Update_ProgressBarMsg, ::NotifierMessage, 0xF7A27FED);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        Update_ProgressBarMsg(Courier::Int32 const & aCurrent_ProgressBar_Value);
        virtual ~Update_ProgressBarMsg();

        Courier::Int32 const & GetCurrent_ProgressBar_Value() const { return mCurrent_ProgressBar_Value; }
        void SetCurrent_ProgressBar_Value(Courier::Int32 const & value) { mCurrent_ProgressBar_Value = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(Update_ProgressBarMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mUpdate_ProgressBarMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mUpdate_ProgressBarMsgModifiableMetadata;
        static const ::Courier::ComponentId mUpdate_ProgressBarMsgSubscriberList[];

        Courier::Int32 mCurrent_ProgressBar_Value;
};

// ------------------------------------------------------------------------
class TripleTunerMonitorDataSet1 : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(TripleTunerMonitorDataSet1, ::NotifierMessage, 0xB0525943);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        TripleTunerMonitorDataSet1(Candera::String const & aFrequency, Courier::UInt16 const & aPI, Candera::String const & aPSName, Courier::Int8 const & aU8Fieldstrength, Courier::UInt8 const & aU8Quality, Courier::UInt8 const & aU8HiCut, Courier::UInt8 const & aU8Sharx, Courier::UInt8 const & aU8FMDeviation, Courier::UInt8 const & aU8ChannelSeparation, Courier::UInt8 const & aTunerType);
        virtual ~TripleTunerMonitorDataSet1();

        Candera::String const & GetFrequency() const { return mFrequency; }
        void SetFrequency(Candera::String const & value) { mFrequency = value; }
        Courier::UInt16 const & GetPI() const { return mPI; }
        void SetPI(Courier::UInt16 const & value) { mPI = value; }
        Candera::String const & GetPSName() const { return mPSName; }
        void SetPSName(Candera::String const & value) { mPSName = value; }
        Courier::Int8 const & GetU8Fieldstrength() const { return mu8Fieldstrength; }
        void SetU8Fieldstrength(Courier::Int8 const & value) { mu8Fieldstrength = value; }
        Courier::UInt8 const & GetU8Quality() const { return mu8Quality; }
        void SetU8Quality(Courier::UInt8 const & value) { mu8Quality = value; }
        Courier::UInt8 const & GetU8HiCut() const { return mu8HiCut; }
        void SetU8HiCut(Courier::UInt8 const & value) { mu8HiCut = value; }
        Courier::UInt8 const & GetU8Sharx() const { return mu8Sharx; }
        void SetU8Sharx(Courier::UInt8 const & value) { mu8Sharx = value; }
        Courier::UInt8 const & GetU8FMDeviation() const { return mu8FMDeviation; }
        void SetU8FMDeviation(Courier::UInt8 const & value) { mu8FMDeviation = value; }
        Courier::UInt8 const & GetU8ChannelSeparation() const { return mu8ChannelSeparation; }
        void SetU8ChannelSeparation(Courier::UInt8 const & value) { mu8ChannelSeparation = value; }
        Courier::UInt8 const & GetTunerType() const { return mTunerType; }
        void SetTunerType(Courier::UInt8 const & value) { mTunerType = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(TripleTunerMonitorDataSet1);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTripleTunerMonitorDataSet1MetaData;
        static ::Courier::Message::ModifiableMetadata mTripleTunerMonitorDataSet1ModifiableMetadata;
        static const ::Courier::ComponentId mTripleTunerMonitorDataSet1SubscriberList[];

        Candera::String mFrequency;
        Courier::UInt16 mPI;
        Candera::String mPSName;
        Courier::Int8 mu8Fieldstrength;
        Courier::UInt8 mu8Quality;
        Courier::UInt8 mu8HiCut;
        Courier::UInt8 mu8Sharx;
        Courier::UInt8 mu8FMDeviation;
        Courier::UInt8 mu8ChannelSeparation;
        Courier::UInt8 mTunerType;
};

// ------------------------------------------------------------------------
class TripleTunerMonitorDataSet2 : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(TripleTunerMonitorDataSet2, ::NotifierMessage, 0xC3AAFFF0);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        TripleTunerMonitorDataSet2(Courier::UInt8 const & aFMMultipath, Courier::UInt8 const & aFMNeighbour, Courier::UInt8 const & aFMRds, Courier::UInt8 const & aFMAlterFreq, bool const & aFMTPFlag, bool const & aFMTAFlag, Courier::UInt8 const & aTunerType);
        virtual ~TripleTunerMonitorDataSet2();

        Courier::UInt8 const & GetFMMultipath() const { return mFMMultipath; }
        void SetFMMultipath(Courier::UInt8 const & value) { mFMMultipath = value; }
        Courier::UInt8 const & GetFMNeighbour() const { return mFMNeighbour; }
        void SetFMNeighbour(Courier::UInt8 const & value) { mFMNeighbour = value; }
        Courier::UInt8 const & GetFMRds() const { return mFMRds; }
        void SetFMRds(Courier::UInt8 const & value) { mFMRds = value; }
        Courier::UInt8 const & GetFMAlterFreq() const { return mFMAlterFreq; }
        void SetFMAlterFreq(Courier::UInt8 const & value) { mFMAlterFreq = value; }
        bool const & GetFMTPFlag() const { return mFMTPFlag; }
        void SetFMTPFlag(bool const & value) { mFMTPFlag = value; }
        bool const & GetFMTAFlag() const { return mFMTAFlag; }
        void SetFMTAFlag(bool const & value) { mFMTAFlag = value; }
        Courier::UInt8 const & GetTunerType() const { return mTunerType; }
        void SetTunerType(Courier::UInt8 const & value) { mTunerType = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(TripleTunerMonitorDataSet2);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTripleTunerMonitorDataSet2MetaData;
        static ::Courier::Message::ModifiableMetadata mTripleTunerMonitorDataSet2ModifiableMetadata;
        static const ::Courier::ComponentId mTripleTunerMonitorDataSet2SubscriberList[];

        Courier::UInt8 mFMMultipath;
        Courier::UInt8 mFMNeighbour;
        Courier::UInt8 mFMRds;
        Courier::UInt8 mFMAlterFreq;
        bool mFMTPFlag;
        bool mFMTAFlag;
        Courier::UInt8 mTunerType;
};

// ------------------------------------------------------------------------
class TripleTunerMonitorDataSet3 : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(TripleTunerMonitorDataSet3, ::NotifierMessage, 0xB1615B5D);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        TripleTunerMonitorDataSet3(Courier::UInt8 const & aActiveTuner, Courier::Int8 const & aActiveBand, Courier::UInt8 const & aTunerType);
        virtual ~TripleTunerMonitorDataSet3();

        Courier::UInt8 const & GetActiveTuner() const { return mActiveTuner; }
        void SetActiveTuner(Courier::UInt8 const & value) { mActiveTuner = value; }
        Courier::Int8 const & GetActiveBand() const { return mActiveBand; }
        void SetActiveBand(Courier::Int8 const & value) { mActiveBand = value; }
        Courier::UInt8 const & GetTunerType() const { return mTunerType; }
        void SetTunerType(Courier::UInt8 const & value) { mTunerType = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(TripleTunerMonitorDataSet3);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTripleTunerMonitorDataSet3MetaData;
        static ::Courier::Message::ModifiableMetadata mTripleTunerMonitorDataSet3ModifiableMetadata;
        static const ::Courier::ComponentId mTripleTunerMonitorDataSet3SubscriberList[];

        Courier::UInt8 mActiveTuner;
        Courier::Int8 mActiveBand;
        Courier::UInt8 mTunerType;
};

// ------------------------------------------------------------------------
class TunerReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(TunerReqMsg, ::NotifierMessage, 0xB753D246);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        TunerReqMsg(Courier::Int8 const & aTunerData);
        virtual ~TunerReqMsg();

        Courier::Int8 const & GetTunerData() const { return mTunerData; }
        void SetTunerData(Courier::Int8 const & value) { mTunerData = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(TunerReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTunerReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mTunerReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mTunerReqMsgSubscriberList[];

        Courier::Int8 mTunerData;
};

// ------------------------------------------------------------------------
class DABTestModeActiveServiceInfo : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DABTestModeActiveServiceInfo, ::NotifierMessage, 0x2254FC02);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DABTestModeActiveServiceInfo(Candera::String const & aSAudioCodec, Candera::UInt16 const & aU16BitRate, Candera::UInt8 const & aU8DRC, Candera::UInt8 const & aU8PS, Candera::UInt32 const & aU32ServId, Candera::String const & aSAudioMode, Candera::String const & aSAdvancedAudioCodec, Candera::UInt8 const & aU8SampleRate, Candera::UInt16 const & aB16AvailableAnnoTypesMask, Candera::String const & aServiceLabel);
        virtual ~DABTestModeActiveServiceInfo();

        Candera::String const & GetSAudioCodec() const { return msAudioCodec; }
        void SetSAudioCodec(Candera::String const & value) { msAudioCodec = value; }
        Candera::UInt16 const & GetU16BitRate() const { return mu16BitRate; }
        void SetU16BitRate(Candera::UInt16 const & value) { mu16BitRate = value; }
        Candera::UInt8 const & GetU8DRC() const { return mu8DRC; }
        void SetU8DRC(Candera::UInt8 const & value) { mu8DRC = value; }
        Candera::UInt8 const & GetU8PS() const { return mu8PS; }
        void SetU8PS(Candera::UInt8 const & value) { mu8PS = value; }
        Candera::UInt32 const & GetU32ServId() const { return mu32ServId; }
        void SetU32ServId(Candera::UInt32 const & value) { mu32ServId = value; }
        Candera::String const & GetSAudioMode() const { return msAudioMode; }
        void SetSAudioMode(Candera::String const & value) { msAudioMode = value; }
        Candera::String const & GetSAdvancedAudioCodec() const { return msAdvancedAudioCodec; }
        void SetSAdvancedAudioCodec(Candera::String const & value) { msAdvancedAudioCodec = value; }
        Candera::UInt8 const & GetU8SampleRate() const { return mu8SampleRate; }
        void SetU8SampleRate(Candera::UInt8 const & value) { mu8SampleRate = value; }
        Candera::UInt16 const & GetB16AvailableAnnoTypesMask() const { return mb16AvailableAnnoTypesMask; }
        void SetB16AvailableAnnoTypesMask(Candera::UInt16 const & value) { mb16AvailableAnnoTypesMask = value; }
        Candera::String const & GetServiceLabel() const { return mServiceLabel; }
        void SetServiceLabel(Candera::String const & value) { mServiceLabel = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DABTestModeActiveServiceInfo);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDABTestModeActiveServiceInfoMetaData;
        static ::Courier::Message::ModifiableMetadata mDABTestModeActiveServiceInfoModifiableMetadata;
        static const ::Courier::ComponentId mDABTestModeActiveServiceInfoSubscriberList[];

        Candera::String msAudioCodec;
        Candera::UInt16 mu16BitRate;
        Candera::UInt8 mu8DRC;
        Candera::UInt8 mu8PS;
        Candera::UInt32 mu32ServId;
        Candera::String msAudioMode;
        Candera::String msAdvancedAudioCodec;
        Candera::UInt8 mu8SampleRate;
        Candera::UInt16 mb16AvailableAnnoTypesMask;
        Candera::String mServiceLabel;
};

// ------------------------------------------------------------------------
class DABTestModeActiveEnsembleInfo : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DABTestModeActiveEnsembleInfo, ::NotifierMessage, 0x03CAF4B7);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DABTestModeActiveEnsembleInfo(Candera::UInt8 const & aU8NoOfAudServiceComp, Candera::UInt8 const & aU8NoOfDataServiceComp, Candera::UInt8 const & aU8NoOfAudService, Candera::UInt8 const & aU8NoOfDataService, Candera::UInt8 const & aU8NoOfEnsembles, Candera::UInt32 const & aEnsembleID, Candera::String const & aEnsembleLabel);
        virtual ~DABTestModeActiveEnsembleInfo();

        Candera::UInt8 const & GetU8NoOfAudServiceComp() const { return mu8NoOfAudServiceComp; }
        void SetU8NoOfAudServiceComp(Candera::UInt8 const & value) { mu8NoOfAudServiceComp = value; }
        Candera::UInt8 const & GetU8NoOfDataServiceComp() const { return mu8NoOfDataServiceComp; }
        void SetU8NoOfDataServiceComp(Candera::UInt8 const & value) { mu8NoOfDataServiceComp = value; }
        Candera::UInt8 const & GetU8NoOfAudService() const { return mu8NoOfAudService; }
        void SetU8NoOfAudService(Candera::UInt8 const & value) { mu8NoOfAudService = value; }
        Candera::UInt8 const & GetU8NoOfDataService() const { return mu8NoOfDataService; }
        void SetU8NoOfDataService(Candera::UInt8 const & value) { mu8NoOfDataService = value; }
        Candera::UInt8 const & GetU8NoOfEnsembles() const { return mu8NoOfEnsembles; }
        void SetU8NoOfEnsembles(Candera::UInt8 const & value) { mu8NoOfEnsembles = value; }
        Candera::UInt32 const & GetEnsembleID() const { return mEnsembleID; }
        void SetEnsembleID(Candera::UInt32 const & value) { mEnsembleID = value; }
        Candera::String const & GetEnsembleLabel() const { return mEnsembleLabel; }
        void SetEnsembleLabel(Candera::String const & value) { mEnsembleLabel = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DABTestModeActiveEnsembleInfo);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDABTestModeActiveEnsembleInfoMetaData;
        static ::Courier::Message::ModifiableMetadata mDABTestModeActiveEnsembleInfoModifiableMetadata;
        static const ::Courier::ComponentId mDABTestModeActiveEnsembleInfoSubscriberList[];

        Candera::UInt8 mu8NoOfAudServiceComp;
        Candera::UInt8 mu8NoOfDataServiceComp;
        Candera::UInt8 mu8NoOfAudService;
        Candera::UInt8 mu8NoOfDataService;
        Candera::UInt8 mu8NoOfEnsembles;
        Candera::UInt32 mEnsembleID;
        Candera::String mEnsembleLabel;
};

// ------------------------------------------------------------------------
class DABTestModeTunerStatusInfo : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DABTestModeTunerStatusInfo, ::NotifierMessage, 0x47860EC3);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DABTestModeTunerStatusInfo(Candera::String const & aChannel_Num, Candera::UInt8 const & aMute, Candera::UInt8 const & aAudio_Quality, Candera::UInt8 const & aSignal_Quality, Candera::UInt8 const & aSync, Candera::String const & aFrequency_Table, Candera::UInt32 const & aEnsemble_Frequency);
        virtual ~DABTestModeTunerStatusInfo();

        Candera::String const & GetChannel_Num() const { return mChannel_Num; }
        void SetChannel_Num(Candera::String const & value) { mChannel_Num = value; }
        Candera::UInt8 const & GetMute() const { return mMute; }
        void SetMute(Candera::UInt8 const & value) { mMute = value; }
        Candera::UInt8 const & GetAudio_Quality() const { return mAudio_Quality; }
        void SetAudio_Quality(Candera::UInt8 const & value) { mAudio_Quality = value; }
        Candera::UInt8 const & GetSignal_Quality() const { return mSignal_Quality; }
        void SetSignal_Quality(Candera::UInt8 const & value) { mSignal_Quality = value; }
        Candera::UInt8 const & GetSync() const { return mSync; }
        void SetSync(Candera::UInt8 const & value) { mSync = value; }
        Candera::String const & GetFrequency_Table() const { return mFrequency_Table; }
        void SetFrequency_Table(Candera::String const & value) { mFrequency_Table = value; }
        Candera::UInt32 const & GetEnsemble_Frequency() const { return mEnsemble_Frequency; }
        void SetEnsemble_Frequency(Candera::UInt32 const & value) { mEnsemble_Frequency = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DABTestModeTunerStatusInfo);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDABTestModeTunerStatusInfoMetaData;
        static ::Courier::Message::ModifiableMetadata mDABTestModeTunerStatusInfoModifiableMetadata;
        static const ::Courier::ComponentId mDABTestModeTunerStatusInfoSubscriberList[];

        Candera::String mChannel_Num;
        Candera::UInt8 mMute;
        Candera::UInt8 mAudio_Quality;
        Candera::UInt8 mSignal_Quality;
        Candera::UInt8 mSync;
        Candera::String mFrequency_Table;
        Candera::UInt32 mEnsemble_Frequency;
};

// ------------------------------------------------------------------------
class DABTestModeBGTestmodeInfo : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DABTestModeBGTestmodeInfo, ::NotifierMessage, 0x436C41EA);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DABTestModeBGTestmodeInfo(Candera::UInt32 const & aBGEensembleFreg, Candera::UInt32 const & aBGEensembleID, Candera::UInt32 const & aBGFIC, Candera::UInt8 const & aBGSyncFlag, Candera::String const & aBGMode);
        virtual ~DABTestModeBGTestmodeInfo();

        Candera::UInt32 const & GetBGEensembleFreg() const { return mBGEensembleFreg; }
        void SetBGEensembleFreg(Candera::UInt32 const & value) { mBGEensembleFreg = value; }
        Candera::UInt32 const & GetBGEensembleID() const { return mBGEensembleID; }
        void SetBGEensembleID(Candera::UInt32 const & value) { mBGEensembleID = value; }
        Candera::UInt32 const & GetBGFIC() const { return mBGFIC; }
        void SetBGFIC(Candera::UInt32 const & value) { mBGFIC = value; }
        Candera::UInt8 const & GetBGSyncFlag() const { return mBGSyncFlag; }
        void SetBGSyncFlag(Candera::UInt8 const & value) { mBGSyncFlag = value; }
        Candera::String const & GetBGMode() const { return mBGMode; }
        void SetBGMode(Candera::String const & value) { mBGMode = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DABTestModeBGTestmodeInfo);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDABTestModeBGTestmodeInfoMetaData;
        static ::Courier::Message::ModifiableMetadata mDABTestModeBGTestmodeInfoModifiableMetadata;
        static const ::Courier::ComponentId mDABTestModeBGTestmodeInfoSubscriberList[];

        Candera::UInt32 mBGEensembleFreg;
        Candera::UInt32 mBGEensembleID;
        Candera::UInt32 mBGFIC;
        Candera::UInt8 mBGSyncFlag;
        Candera::String mBGMode;
};

// ------------------------------------------------------------------------
class DABTestModeGTestmodeInfo : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DABTestModeGTestmodeInfo, ::NotifierMessage, 0xCA20D783);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DABTestModeGTestmodeInfo(Candera::UInt32 const & aGFIC, Candera::UInt16 const & aGFM, Candera::Int8 const & aGField_Strength, Candera::UInt32 const & aGMSC, Candera::UInt16 const & aGPI, Candera::UInt8 const & aGPL, Candera::UInt16 const & aGQFM, Candera::UInt8 const & aGRSFEC, Candera::UInt32 const & aGNET);
        virtual ~DABTestModeGTestmodeInfo();

        Candera::UInt32 const & GetGFIC() const { return mGFIC; }
        void SetGFIC(Candera::UInt32 const & value) { mGFIC = value; }
        Candera::UInt16 const & GetGFM() const { return mGFM; }
        void SetGFM(Candera::UInt16 const & value) { mGFM = value; }
        Candera::Int8 const & GetGField_Strength() const { return mGField_Strength; }
        void SetGField_Strength(Candera::Int8 const & value) { mGField_Strength = value; }
        Candera::UInt32 const & GetGMSC() const { return mGMSC; }
        void SetGMSC(Candera::UInt32 const & value) { mGMSC = value; }
        Candera::UInt16 const & GetGPI() const { return mGPI; }
        void SetGPI(Candera::UInt16 const & value) { mGPI = value; }
        Candera::UInt8 const & GetGPL() const { return mGPL; }
        void SetGPL(Candera::UInt8 const & value) { mGPL = value; }
        Candera::UInt16 const & GetGQFM() const { return mGQFM; }
        void SetGQFM(Candera::UInt16 const & value) { mGQFM = value; }
        Candera::UInt8 const & GetGRSFEC() const { return mGRSFEC; }
        void SetGRSFEC(Candera::UInt8 const & value) { mGRSFEC = value; }
        Candera::UInt32 const & GetGNET() const { return mGNET; }
        void SetGNET(Candera::UInt32 const & value) { mGNET = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DABTestModeGTestmodeInfo);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDABTestModeGTestmodeInfoMetaData;
        static ::Courier::Message::ModifiableMetadata mDABTestModeGTestmodeInfoModifiableMetadata;
        static const ::Courier::ComponentId mDABTestModeGTestmodeInfoSubscriberList[];

        Candera::UInt32 mGFIC;
        Candera::UInt16 mGFM;
        Candera::Int8 mGField_Strength;
        Candera::UInt32 mGMSC;
        Candera::UInt16 mGPI;
        Candera::UInt8 mGPL;
        Candera::UInt16 mGQFM;
        Candera::UInt8 mGRSFEC;
        Candera::UInt32 mGNET;
};

// ------------------------------------------------------------------------
class DABTestModeActiveServiceInfo1 : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DABTestModeActiveServiceInfo1, ::NotifierMessage, 0x5A8E8CBE);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DABTestModeActiveServiceInfo1(Candera::String const & aServiceLabel1);
        virtual ~DABTestModeActiveServiceInfo1();

        Candera::String const & GetServiceLabel1() const { return mServiceLabel1; }
        void SetServiceLabel1(Candera::String const & value) { mServiceLabel1 = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DABTestModeActiveServiceInfo1);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDABTestModeActiveServiceInfo1MetaData;
        static ::Courier::Message::ModifiableMetadata mDABTestModeActiveServiceInfo1ModifiableMetadata;
        static const ::Courier::ComponentId mDABTestModeActiveServiceInfo1SubscriberList[];

        Candera::String mServiceLabel1;
};

// ------------------------------------------------------------------------
class DABTestModeAnnoStatus : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DABTestModeAnnoStatus, ::NotifierMessage, 0x055CA7DF);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DABTestModeAnnoStatus(Candera::UInt16 const & aASU, Candera::UInt16 const & aASW, Candera::String const & aAnnoServiceLabel);
        virtual ~DABTestModeAnnoStatus();

        Candera::UInt16 const & GetASU() const { return mASU; }
        void SetASU(Candera::UInt16 const & value) { mASU = value; }
        Candera::UInt16 const & GetASW() const { return mASW; }
        void SetASW(Candera::UInt16 const & value) { mASW = value; }
        Candera::String const & GetAnnoServiceLabel() const { return mAnnoServiceLabel; }
        void SetAnnoServiceLabel(Candera::String const & value) { mAnnoServiceLabel = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DABTestModeAnnoStatus);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDABTestModeAnnoStatusMetaData;
        static ::Courier::Message::ModifiableMetadata mDABTestModeAnnoStatusModifiableMetadata;
        static const ::Courier::ComponentId mDABTestModeAnnoStatusSubscriberList[];

        Candera::UInt16 mASU;
        Candera::UInt16 mASW;
        Candera::String mAnnoServiceLabel;
};

// ------------------------------------------------------------------------
class DABTestModeActiveCompInfo : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DABTestModeActiveCompInfo, ::NotifierMessage, 0xDBD1409D);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DABTestModeActiveCompInfo(Candera::UInt16 const & aSC, Candera::UInt8 const & aSCType);
        virtual ~DABTestModeActiveCompInfo();

        Candera::UInt16 const & GetSC() const { return mSC; }
        void SetSC(Candera::UInt16 const & value) { mSC = value; }
        Candera::UInt8 const & GetSCType() const { return mSCType; }
        void SetSCType(Candera::UInt8 const & value) { mSCType = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DABTestModeActiveCompInfo);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDABTestModeActiveCompInfoMetaData;
        static ::Courier::Message::ModifiableMetadata mDABTestModeActiveCompInfoModifiableMetadata;
        static const ::Courier::ComponentId mDABTestModeActiveCompInfoSubscriberList[];

        Candera::UInt16 mSC;
        Candera::UInt8 mSCType;
};

// ------------------------------------------------------------------------
class DABTestModeGAvailabilty : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DABTestModeGAvailabilty, ::NotifierMessage, 0x3624BCF5);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DABTestModeGAvailabilty(Candera::UInt8 const & aTA, Candera::UInt8 const & aIndicator);
        virtual ~DABTestModeGAvailabilty();

        Candera::UInt8 const & GetTA() const { return mTA; }
        void SetTA(Candera::UInt8 const & value) { mTA = value; }
        Candera::UInt8 const & GetIndicator() const { return mIndicator; }
        void SetIndicator(Candera::UInt8 const & value) { mIndicator = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DABTestModeGAvailabilty);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDABTestModeGAvailabiltyMetaData;
        static ::Courier::Message::ModifiableMetadata mDABTestModeGAvailabiltyModifiableMetadata;
        static const ::Courier::ComponentId mDABTestModeGAvailabiltySubscriberList[];

        Candera::UInt8 mTA;
        Candera::UInt8 mIndicator;
};

// ------------------------------------------------------------------------
class DABTestModeServiceFollowingStatus : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DABTestModeServiceFollowingStatus, ::NotifierMessage, 0x5955EFD4);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DABTestModeServiceFollowingStatus(Candera::UInt8 const & aTSU);
        virtual ~DABTestModeServiceFollowingStatus();

        Candera::UInt8 const & GetTSU() const { return mTSU; }
        void SetTSU(Candera::UInt8 const & value) { mTSU = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DABTestModeServiceFollowingStatus);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDABTestModeServiceFollowingStatusMetaData;
        static ::Courier::Message::ModifiableMetadata mDABTestModeServiceFollowingStatusModifiableMetadata;
        static const ::Courier::ComponentId mDABTestModeServiceFollowingStatusSubscriberList[];

        Candera::UInt8 mTSU;
};

// ------------------------------------------------------------------------
class DABTestModeTASource : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DABTestModeTASource, ::NotifierMessage, 0x8CB836C4);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DABTestModeTASource(Candera::UInt8 const & aTASource, Candera::UInt8 const & aDAB_DAB);
        virtual ~DABTestModeTASource();

        Candera::UInt8 const & GetTASource() const { return mTASource; }
        void SetTASource(Candera::UInt8 const & value) { mTASource = value; }
        Candera::UInt8 const & GetDAB_DAB() const { return mDAB_DAB; }
        void SetDAB_DAB(Candera::UInt8 const & value) { mDAB_DAB = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DABTestModeTASource);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDABTestModeTASourceMetaData;
        static ::Courier::Message::ModifiableMetadata mDABTestModeTASourceModifiableMetadata;
        static const ::Courier::ComponentId mDABTestModeTASourceSubscriberList[];

        Candera::UInt8 mTASource;
        Candera::UInt8 mDAB_DAB;
};

// ------------------------------------------------------------------------
class TunerEngineeringModeMsg2 : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(TunerEngineeringModeMsg2, ::NotifierMessage, 0xE9B649AB);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        TunerEngineeringModeMsg2(Candera::String const & aFMReception, Courier::UInt16 const & aAMRFLevel, Courier::UInt32 const & aFMFreqStep, Candera::UInt32 const & aAMFreqStep, Candera::UInt32 const & aAMTuner, Candera::UInt32 const & aFMTuner1, Candera::UInt32 const & aFMTuner2, Candera::UInt32 const & aDABTuner);
        virtual ~TunerEngineeringModeMsg2();

        Candera::String const & GetFMReception() const { return mFMReception; }
        void SetFMReception(Candera::String const & value) { mFMReception = value; }
        Courier::UInt16 const & GetAMRFLevel() const { return mAMRFLevel; }
        void SetAMRFLevel(Courier::UInt16 const & value) { mAMRFLevel = value; }
        Courier::UInt32 const & GetFMFreqStep() const { return mFMFreqStep; }
        void SetFMFreqStep(Courier::UInt32 const & value) { mFMFreqStep = value; }
        Candera::UInt32 const & GetAMFreqStep() const { return mAMFreqStep; }
        void SetAMFreqStep(Candera::UInt32 const & value) { mAMFreqStep = value; }
        Candera::UInt32 const & GetAMTuner() const { return mAMTuner; }
        void SetAMTuner(Candera::UInt32 const & value) { mAMTuner = value; }
        Candera::UInt32 const & GetFMTuner1() const { return mFMTuner1; }
        void SetFMTuner1(Candera::UInt32 const & value) { mFMTuner1 = value; }
        Candera::UInt32 const & GetFMTuner2() const { return mFMTuner2; }
        void SetFMTuner2(Candera::UInt32 const & value) { mFMTuner2 = value; }
        Candera::UInt32 const & GetDABTuner() const { return mDABTuner; }
        void SetDABTuner(Candera::UInt32 const & value) { mDABTuner = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(TunerEngineeringModeMsg2);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTunerEngineeringModeMsg2MetaData;
        static ::Courier::Message::ModifiableMetadata mTunerEngineeringModeMsg2ModifiableMetadata;
        static const ::Courier::ComponentId mTunerEngineeringModeMsg2SubscriberList[];

        Candera::String mFMReception;
        Courier::UInt16 mAMRFLevel;
        Courier::UInt32 mFMFreqStep;
        Candera::UInt32 mAMFreqStep;
        Candera::UInt32 mAMTuner;
        Candera::UInt32 mFMTuner1;
        Candera::UInt32 mFMTuner2;
        Candera::UInt32 mDABTuner;
};

// ------------------------------------------------------------------------
class DRMEngineeringModeMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DRMEngineeringModeMsg, ::NotifierMessage, 0x8E5FC96B);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DRMEngineeringModeMsg(Candera::String const & aFrequency, Candera::UInt8 const & aFieldStrength, Candera::String const & aSyncStatus, Candera::UInt8 const & aRobustnessMode, Candera::String const & aBandwidth, Candera::UInt8 const & aInter_Depth, Candera::UInt8 const & aRecnfg_idx, Candera::String const & aService_ID);
        virtual ~DRMEngineeringModeMsg();

        Candera::String const & GetFrequency() const { return mFrequency; }
        void SetFrequency(Candera::String const & value) { mFrequency = value; }
        Candera::UInt8 const & GetFieldStrength() const { return mFieldStrength; }
        void SetFieldStrength(Candera::UInt8 const & value) { mFieldStrength = value; }
        Candera::String const & GetSyncStatus() const { return mSyncStatus; }
        void SetSyncStatus(Candera::String const & value) { mSyncStatus = value; }
        Candera::UInt8 const & GetRobustnessMode() const { return mRobustnessMode; }
        void SetRobustnessMode(Candera::UInt8 const & value) { mRobustnessMode = value; }
        Candera::String const & GetBandwidth() const { return mBandwidth; }
        void SetBandwidth(Candera::String const & value) { mBandwidth = value; }
        Candera::UInt8 const & GetInter_Depth() const { return mInter_Depth; }
        void SetInter_Depth(Candera::UInt8 const & value) { mInter_Depth = value; }
        Candera::UInt8 const & GetRecnfg_idx() const { return mRecnfg_idx; }
        void SetRecnfg_idx(Candera::UInt8 const & value) { mRecnfg_idx = value; }
        Candera::String const & GetService_ID() const { return mService_ID; }
        void SetService_ID(Candera::String const & value) { mService_ID = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DRMEngineeringModeMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDRMEngineeringModeMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mDRMEngineeringModeMsgModifiableMetadata;
        static const ::Courier::ComponentId mDRMEngineeringModeMsgSubscriberList[];

        Candera::String mFrequency;
        Candera::UInt8 mFieldStrength;
        Candera::String mSyncStatus;
        Candera::UInt8 mRobustnessMode;
        Candera::String mBandwidth;
        Candera::UInt8 mInter_Depth;
        Candera::UInt8 mRecnfg_idx;
        Candera::String mService_ID;
};

// ------------------------------------------------------------------------
class DRMEngineeringModeMsg_1 : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DRMEngineeringModeMsg_1, ::NotifierMessage, 0xD7A5BE15);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DRMEngineeringModeMsg_1(Candera::String const & aService_Label, Candera::UInt8 const & aPTY, Candera::UInt8 const & aLanguage, Candera::UInt8 const & aFAC, Candera::UInt8 const & aSDC, Candera::UInt8 const & aAudioCRC, Candera::UInt8 const & aAudioMute, Candera::UInt8 const & aServiceQuality);
        virtual ~DRMEngineeringModeMsg_1();

        Candera::String const & GetService_Label() const { return mService_Label; }
        void SetService_Label(Candera::String const & value) { mService_Label = value; }
        Candera::UInt8 const & GetPTY() const { return mPTY; }
        void SetPTY(Candera::UInt8 const & value) { mPTY = value; }
        Candera::UInt8 const & GetLanguage() const { return mLanguage; }
        void SetLanguage(Candera::UInt8 const & value) { mLanguage = value; }
        Candera::UInt8 const & GetFAC() const { return mFAC; }
        void SetFAC(Candera::UInt8 const & value) { mFAC = value; }
        Candera::UInt8 const & GetSDC() const { return mSDC; }
        void SetSDC(Candera::UInt8 const & value) { mSDC = value; }
        Candera::UInt8 const & GetAudioCRC() const { return mAudioCRC; }
        void SetAudioCRC(Candera::UInt8 const & value) { mAudioCRC = value; }
        Candera::UInt8 const & GetAudioMute() const { return mAudioMute; }
        void SetAudioMute(Candera::UInt8 const & value) { mAudioMute = value; }
        Candera::UInt8 const & GetServiceQuality() const { return mServiceQuality; }
        void SetServiceQuality(Candera::UInt8 const & value) { mServiceQuality = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DRMEngineeringModeMsg_1);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDRMEngineeringModeMsg_1MetaData;
        static ::Courier::Message::ModifiableMetadata mDRMEngineeringModeMsg_1ModifiableMetadata;
        static const ::Courier::ComponentId mDRMEngineeringModeMsg_1SubscriberList[];

        Candera::String mService_Label;
        Candera::UInt8 mPTY;
        Candera::UInt8 mLanguage;
        Candera::UInt8 mFAC;
        Candera::UInt8 mSDC;
        Candera::UInt8 mAudioCRC;
        Candera::UInt8 mAudioMute;
        Candera::UInt8 mServiceQuality;
};

// ------------------------------------------------------------------------
class DRMEngineeringModeMsg_2 : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DRMEngineeringModeMsg_2, ::NotifierMessage, 0xD973C1B1);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DRMEngineeringModeMsg_2(Candera::UInt8 const & aAudioCoding, Candera::UInt8 const & aSBR, Candera::UInt8 const & aAudioMode, Candera::String const & aSamplingRate, Candera::UInt8 const & aTextFlag, Candera::Int32 const & aIBER, Candera::UInt8 const & aPrLevel_PartA, Candera::UInt8 const & aPrLevel_PartB);
        virtual ~DRMEngineeringModeMsg_2();

        Candera::UInt8 const & GetAudioCoding() const { return mAudioCoding; }
        void SetAudioCoding(Candera::UInt8 const & value) { mAudioCoding = value; }
        Candera::UInt8 const & GetSBR() const { return mSBR; }
        void SetSBR(Candera::UInt8 const & value) { mSBR = value; }
        Candera::UInt8 const & GetAudioMode() const { return mAudioMode; }
        void SetAudioMode(Candera::UInt8 const & value) { mAudioMode = value; }
        Candera::String const & GetSamplingRate() const { return mSamplingRate; }
        void SetSamplingRate(Candera::String const & value) { mSamplingRate = value; }
        Candera::UInt8 const & GetTextFlag() const { return mTextFlag; }
        void SetTextFlag(Candera::UInt8 const & value) { mTextFlag = value; }
        Candera::Int32 const & GetIBER() const { return mIBER; }
        void SetIBER(Candera::Int32 const & value) { mIBER = value; }
        Candera::UInt8 const & GetPrLevel_PartA() const { return mPrLevel_PartA; }
        void SetPrLevel_PartA(Candera::UInt8 const & value) { mPrLevel_PartA = value; }
        Candera::UInt8 const & GetPrLevel_PartB() const { return mPrLevel_PartB; }
        void SetPrLevel_PartB(Candera::UInt8 const & value) { mPrLevel_PartB = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DRMEngineeringModeMsg_2);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDRMEngineeringModeMsg_2MetaData;
        static ::Courier::Message::ModifiableMetadata mDRMEngineeringModeMsg_2ModifiableMetadata;
        static const ::Courier::ComponentId mDRMEngineeringModeMsg_2SubscriberList[];

        Candera::UInt8 mAudioCoding;
        Candera::UInt8 mSBR;
        Candera::UInt8 mAudioMode;
        Candera::String mSamplingRate;
        Candera::UInt8 mTextFlag;
        Candera::Int32 mIBER;
        Candera::UInt8 mPrLevel_PartA;
        Candera::UInt8 mPrLevel_PartB;
};

// ------------------------------------------------------------------------
class AFListExitMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(AFListExitMsg, ::NotifierMessage, 0x06C09401);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        AFListExitMsg();
        virtual ~AFListExitMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mAFListExitMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mAFListExitMsgModifiableMetadata;
        static const ::Courier::ComponentId mAFListExitMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class DABServiceLinkingMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DABServiceLinkingMsg, ::NotifierMessage, 0x1915E0AE);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DABServiceLinkingMsg(Courier::UInt16 const & aServiceLinkingValue);
        virtual ~DABServiceLinkingMsg();

        Courier::UInt16 const & GetServiceLinkingValue() const { return mServiceLinkingValue; }
        void SetServiceLinkingValue(Courier::UInt16 const & value) { mServiceLinkingValue = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DABServiceLinkingMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDABServiceLinkingMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mDABServiceLinkingMsgModifiableMetadata;
        static const ::Courier::ComponentId mDABServiceLinkingMsgSubscriberList[];

        Courier::UInt16 mServiceLinkingValue;
};

// ------------------------------------------------------------------------
class DABConcealmentLevelMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DABConcealmentLevelMsg, ::NotifierMessage, 0x40362676);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DABConcealmentLevelMsg(Courier::UInt16 const & aCLevel);
        virtual ~DABConcealmentLevelMsg();

        Courier::UInt16 const & GetCLevel() const { return mCLevel; }
        void SetCLevel(Courier::UInt16 const & value) { mCLevel = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DABConcealmentLevelMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDABConcealmentLevelMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mDABConcealmentLevelMsgModifiableMetadata;
        static const ::Courier::ComponentId mDABConcealmentLevelMsgSubscriberList[];

        Courier::UInt16 mCLevel;
};

// ------------------------------------------------------------------------
class AntennaStatus : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(AntennaStatus, ::NotifierMessage, 0xC0B1ABB0);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        AntennaStatus(Courier::UInt8 const & aBAntennaStatus);
        virtual ~AntennaStatus();

        Courier::UInt8 const & GetBAntennaStatus() const { return mbAntennaStatus; }
        void SetBAntennaStatus(Courier::UInt8 const & value) { mbAntennaStatus = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(AntennaStatus);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mAntennaStatusMetaData;
        static ::Courier::Message::ModifiableMetadata mAntennaStatusModifiableMetadata;
        static const ::Courier::ComponentId mAntennaStatusSubscriberList[];

        Courier::UInt8 mbAntennaStatus;
};

// ------------------------------------------------------------------------
class BandscanStatus : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(BandscanStatus, ::NotifierMessage, 0x0E5BDF3D);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        BandscanStatus(bool const & aBBandscan);
        virtual ~BandscanStatus();

        bool const & GetBBandscan() const { return mbBandscan; }
        void SetBBandscan(bool const & value) { mbBandscan = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(BandscanStatus);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mBandscanStatusMetaData;
        static ::Courier::Message::ModifiableMetadata mBandscanStatusModifiableMetadata;
        static const ::Courier::ComponentId mBandscanStatusSubscriberList[];

        bool mbBandscan;
};

// ------------------------------------------------------------------------
class UpdateCurrentBank : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(UpdateCurrentBank, ::NotifierMessage, 0x012B2333);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        UpdateCurrentBank(Courier::Int8 const & aCurentBank);
        virtual ~UpdateCurrentBank();

        Courier::Int8 const & GetCurentBank() const { return mCurentBank; }
        void SetCurentBank(Courier::Int8 const & value) { mCurentBank = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(UpdateCurrentBank);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mUpdateCurrentBankMetaData;
        static ::Courier::Message::ModifiableMetadata mUpdateCurrentBankModifiableMetadata;
        static const ::Courier::ComponentId mUpdateCurrentBankSubscriberList[];

        Courier::Int8 mCurentBank;
};

// ------------------------------------------------------------------------
class UpdateScanMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(UpdateScanMsg, ::NotifierMessage, 0x2DDC8C9F);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(3);

        UpdateScanMsg(bool const & aIsScanActive, bool const & aIsSeekInactive);
        virtual ~UpdateScanMsg();

        bool const & GetIsScanActive() const { return misScanActive; }
        void SetIsScanActive(bool const & value) { misScanActive = value; }
        bool const & GetIsSeekInactive() const { return misSeekInactive; }
        void SetIsSeekInactive(bool const & value) { misSeekInactive = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(UpdateScanMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mUpdateScanMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mUpdateScanMsgModifiableMetadata;
        static const ::Courier::ComponentId mUpdateScanMsgSubscriberList[];

        bool misScanActive;
        bool misSeekInactive;
};

// ------------------------------------------------------------------------
class UpdateAutoStoreMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(UpdateAutoStoreMsg, ::NotifierMessage, 0xD4BEF7E8);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(3);

        UpdateAutoStoreMsg(bool const & aIsAutostoreRunning);
        virtual ~UpdateAutoStoreMsg();

        bool const & GetIsAutostoreRunning() const { return misAutostoreRunning; }
        void SetIsAutostoreRunning(bool const & value) { misAutostoreRunning = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(UpdateAutoStoreMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mUpdateAutoStoreMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mUpdateAutoStoreMsgModifiableMetadata;
        static const ::Courier::ComponentId mUpdateAutoStoreMsgSubscriberList[];

        bool misAutostoreRunning;
};

// ------------------------------------------------------------------------
class BrowseListReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(BrowseListReqMsg, ::NotifierMessage, 0xAEEB5822);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        BrowseListReqMsg(Courier::UInt8 const & aG_SM_ListType);
        virtual ~BrowseListReqMsg();

        Courier::UInt8 const & GetG_SM_ListType() const { return mG_SM_ListType; }
        void SetG_SM_ListType(Courier::UInt8 const & value) { mG_SM_ListType = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(BrowseListReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mBrowseListReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mBrowseListReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mBrowseListReqMsgSubscriberList[];

        Courier::UInt8 mG_SM_ListType;
};

// ------------------------------------------------------------------------
class StationListReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(StationListReqMsg, ::NotifierMessage, 0x96BA621F);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        StationListReqMsg();
        virtual ~StationListReqMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mStationListReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mStationListReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mStationListReqMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class DABStationListReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DABStationListReqMsg, ::NotifierMessage, 0xF3BA1E81);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        DABStationListReqMsg();
        virtual ~DABStationListReqMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDABStationListReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mDABStationListReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mDABStationListReqMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class BrowseListRespMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(BrowseListRespMsg, ::NotifierMessage, 0xF6217210);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        BrowseListRespMsg(Courier::UInt8 const & aG_SM_ListType, Candera::UInt16 const & aListSize, Candera::UInt16 const & aWindowListSize);
        virtual ~BrowseListRespMsg();

        Courier::UInt8 const & GetG_SM_ListType() const { return mG_SM_ListType; }
        void SetG_SM_ListType(Courier::UInt8 const & value) { mG_SM_ListType = value; }
        Candera::UInt16 const & GetListSize() const { return mListSize; }
        void SetListSize(Candera::UInt16 const & value) { mListSize = value; }
        Candera::UInt16 const & GetWindowListSize() const { return mWindowListSize; }
        void SetWindowListSize(Candera::UInt16 const & value) { mWindowListSize = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(BrowseListRespMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mBrowseListRespMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mBrowseListRespMsgModifiableMetadata;
        static const ::Courier::ComponentId mBrowseListRespMsgSubscriberList[];

        Courier::UInt8 mG_SM_ListType;
        Candera::UInt16 mListSize;
        Candera::UInt16 mWindowListSize;
};

// ------------------------------------------------------------------------
class BrowseListItemSelReq : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(BrowseListItemSelReq, ::NotifierMessage, 0x7C2490DE);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        BrowseListItemSelReq(Courier::UInt8 const & aG_SM_ListType, Candera::UInt16 const & aSelectedItem);
        virtual ~BrowseListItemSelReq();

        Courier::UInt8 const & GetG_SM_ListType() const { return mG_SM_ListType; }
        void SetG_SM_ListType(Courier::UInt8 const & value) { mG_SM_ListType = value; }
        Candera::UInt16 const & GetSelectedItem() const { return mSelectedItem; }
        void SetSelectedItem(Candera::UInt16 const & value) { mSelectedItem = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(BrowseListItemSelReq);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mBrowseListItemSelReqMetaData;
        static ::Courier::Message::ModifiableMetadata mBrowseListItemSelReqModifiableMetadata;
        static const ::Courier::ComponentId mBrowseListItemSelReqSubscriberList[];

        Courier::UInt8 mG_SM_ListType;
        Candera::UInt16 mSelectedItem;
};

// ------------------------------------------------------------------------
class PopulateScrollListWindowRequest : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(PopulateScrollListWindowRequest, ::NotifierMessage, 0x16C237BF);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        PopulateScrollListWindowRequest(Candera::UInt8 const & aListID, Candera::UInt16 const & aWindowDistance);
        virtual ~PopulateScrollListWindowRequest();

        Candera::UInt8 const & GetListID() const { return mListID; }
        void SetListID(Candera::UInt8 const & value) { mListID = value; }
        Candera::UInt16 const & GetWindowDistance() const { return mWindowDistance; }
        void SetWindowDistance(Candera::UInt16 const & value) { mWindowDistance = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(PopulateScrollListWindowRequest);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mPopulateScrollListWindowRequestMetaData;
        static ::Courier::Message::ModifiableMetadata mPopulateScrollListWindowRequestModifiableMetadata;
        static const ::Courier::ComponentId mPopulateScrollListWindowRequestSubscriberList[];

        Candera::UInt8 mListID;
        Candera::UInt16 mWindowDistance;
};

// ------------------------------------------------------------------------
class BrowseListExitMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(BrowseListExitMsg, ::NotifierMessage, 0xF319326C);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        BrowseListExitMsg(Courier::UInt8 const & aG_SM_ListType);
        virtual ~BrowseListExitMsg();

        Courier::UInt8 const & GetG_SM_ListType() const { return mG_SM_ListType; }
        void SetG_SM_ListType(Courier::UInt8 const & value) { mG_SM_ListType = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(BrowseListExitMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mBrowseListExitMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mBrowseListExitMsgModifiableMetadata;
        static const ::Courier::ComponentId mBrowseListExitMsgSubscriberList[];

        Courier::UInt8 mG_SM_ListType;
};

// ------------------------------------------------------------------------
class ActiveLineIndexInfoMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ActiveLineIndexInfoMsg, ::NotifierMessage, 0xFBEDFE2B);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ActiveLineIndexInfoMsg(Candera::UInt32 const & aListType, Candera::UInt8 const & aActiveLineIndex, Candera::UInt8 const & aActiveLineIconIndex, Candera::UInt8 const & aLastLineIndex, Candera::UInt8 const & aLastLineIconIndex);
        virtual ~ActiveLineIndexInfoMsg();

        Candera::UInt32 const & GetListType() const { return mListType; }
        void SetListType(Candera::UInt32 const & value) { mListType = value; }
        Candera::UInt8 const & GetActiveLineIndex() const { return mActiveLineIndex; }
        void SetActiveLineIndex(Candera::UInt8 const & value) { mActiveLineIndex = value; }
        Candera::UInt8 const & GetActiveLineIconIndex() const { return mActiveLineIconIndex; }
        void SetActiveLineIconIndex(Candera::UInt8 const & value) { mActiveLineIconIndex = value; }
        Candera::UInt8 const & GetLastLineIndex() const { return mLastLineIndex; }
        void SetLastLineIndex(Candera::UInt8 const & value) { mLastLineIndex = value; }
        Candera::UInt8 const & GetLastLineIconIndex() const { return mLastLineIconIndex; }
        void SetLastLineIconIndex(Candera::UInt8 const & value) { mLastLineIconIndex = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ActiveLineIndexInfoMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mActiveLineIndexInfoMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mActiveLineIndexInfoMsgModifiableMetadata;
        static const ::Courier::ComponentId mActiveLineIndexInfoMsgSubscriberList[];

        Candera::UInt32 mListType;
        Candera::UInt8 mActiveLineIndex;
        Candera::UInt8 mActiveLineIconIndex;
        Candera::UInt8 mLastLineIndex;
        Candera::UInt8 mLastLineIconIndex;
};

// ------------------------------------------------------------------------
class DABChannelInfoMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DABChannelInfoMsg, ::NotifierMessage, 0x86AAB474);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DABChannelInfoMsg(bool const & aTpAvailability, Candera::UInt8 const & aDabStatus, Candera::String const & aEnsembleLabel, Candera::String const & aServiceLabel, Candera::String const & aRadioText);
        virtual ~DABChannelInfoMsg();

        bool const & GetTpAvailability() const { return mTpAvailability; }
        void SetTpAvailability(bool const & value) { mTpAvailability = value; }
        Candera::UInt8 const & GetDabStatus() const { return mDabStatus; }
        void SetDabStatus(Candera::UInt8 const & value) { mDabStatus = value; }
        Candera::String const & GetEnsembleLabel() const { return mEnsembleLabel; }
        void SetEnsembleLabel(Candera::String const & value) { mEnsembleLabel = value; }
        Candera::String const & GetServiceLabel() const { return mServiceLabel; }
        void SetServiceLabel(Candera::String const & value) { mServiceLabel = value; }
        Candera::String const & GetRadioText() const { return mRadioText; }
        void SetRadioText(Candera::String const & value) { mRadioText = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DABChannelInfoMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDABChannelInfoMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mDABChannelInfoMsgModifiableMetadata;
        static const ::Courier::ComponentId mDABChannelInfoMsgSubscriberList[];

        bool mTpAvailability;
        Candera::UInt8 mDabStatus;
        Candera::String mEnsembleLabel;
        Candera::String mServiceLabel;
        Candera::String mRadioText;
};

// ------------------------------------------------------------------------
class TmcInfoData : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(TmcInfoData, ::NotifierMessage, 0x75D0FAA9);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        TmcInfoData(Candera::String const & aNumberOfMessages, Candera::String const & aSelectedMessage, Candera::String const & aLastMsgReceived);
        virtual ~TmcInfoData();

        Candera::String const & GetNumberOfMessages() const { return mNumberOfMessages; }
        void SetNumberOfMessages(Candera::String const & value) { mNumberOfMessages = value; }
        Candera::String const & GetSelectedMessage() const { return mSelectedMessage; }
        void SetSelectedMessage(Candera::String const & value) { mSelectedMessage = value; }
        Candera::String const & GetLastMsgReceived() const { return mLastMsgReceived; }
        void SetLastMsgReceived(Candera::String const & value) { mLastMsgReceived = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(TmcInfoData);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTmcInfoDataMetaData;
        static ::Courier::Message::ModifiableMetadata mTmcInfoDataModifiableMetadata;
        static const ::Courier::ComponentId mTmcInfoDataSubscriberList[];

        Candera::String mNumberOfMessages;
        Candera::String mSelectedMessage;
        Candera::String mLastMsgReceived;
};

// ------------------------------------------------------------------------
class TmcStnInfoData : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(TmcStnInfoData, ::NotifierMessage, 0x80D4C332);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        TmcStnInfoData(Candera::String const & aPSData, Candera::UInt32 const & aPIData, Candera::UInt8 const & aCCData, Candera::UInt8 const & aSIDData, Candera::UInt8 const & aLTNData, Candera::UInt8 const & aQData);
        virtual ~TmcStnInfoData();

        Candera::String const & GetPSData() const { return mPSData; }
        void SetPSData(Candera::String const & value) { mPSData = value; }
        Candera::UInt32 const & GetPIData() const { return mPIData; }
        void SetPIData(Candera::UInt32 const & value) { mPIData = value; }
        Candera::UInt8 const & GetCCData() const { return mCCData; }
        void SetCCData(Candera::UInt8 const & value) { mCCData = value; }
        Candera::UInt8 const & GetSIDData() const { return mSIDData; }
        void SetSIDData(Candera::UInt8 const & value) { mSIDData = value; }
        Candera::UInt8 const & GetLTNData() const { return mLTNData; }
        void SetLTNData(Candera::UInt8 const & value) { mLTNData = value; }
        Candera::UInt8 const & GetQData() const { return mQData; }
        void SetQData(Candera::UInt8 const & value) { mQData = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(TmcStnInfoData);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTmcStnInfoDataMetaData;
        static ::Courier::Message::ModifiableMetadata mTmcStnInfoDataModifiableMetadata;
        static const ::Courier::ComponentId mTmcStnInfoDataSubscriberList[];

        Candera::String mPSData;
        Candera::UInt32 mPIData;
        Candera::UInt8 mCCData;
        Candera::UInt8 mSIDData;
        Candera::UInt8 mLTNData;
        Candera::UInt8 mQData;
};

// ------------------------------------------------------------------------
class SwitchApplicationReq : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SwitchApplicationReq, ::NotifierMessage, 0x8943A2E6);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SwitchApplicationReq(enApplicationId const & aApplicationID, enSurfaceId const & aSurfaceID);
        virtual ~SwitchApplicationReq();

        enApplicationId const & GetApplicationID() const { return mApplicationID; }
        void SetApplicationID(enApplicationId const & value) { mApplicationID = value; }
        enSurfaceId const & GetSurfaceID() const { return mSurfaceID; }
        void SetSurfaceID(enSurfaceId const & value) { mSurfaceID = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(SwitchApplicationReq);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSwitchApplicationReqMetaData;
        static ::Courier::Message::ModifiableMetadata mSwitchApplicationReqModifiableMetadata;
        static const ::Courier::ComponentId mSwitchApplicationReqSubscriberList[];

        enApplicationId mApplicationID;
        enSurfaceId mSurfaceID;
};

// ------------------------------------------------------------------------
class FMMonitorMessage : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(FMMonitorMessage, ::NotifierMessage, 0x60E1B0C4);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        FMMonitorMessage(Candera::UInt8 const & aFirstArg, Candera::UInt8 const & aSecondArg);
        virtual ~FMMonitorMessage();

        Candera::UInt8 const & GetFirstArg() const { return mFirstArg; }
        void SetFirstArg(Candera::UInt8 const & value) { mFirstArg = value; }
        Candera::UInt8 const & GetSecondArg() const { return mSecondArg; }
        void SetSecondArg(Candera::UInt8 const & value) { mSecondArg = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(FMMonitorMessage);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mFMMonitorMessageMetaData;
        static ::Courier::Message::ModifiableMetadata mFMMonitorMessageModifiableMetadata;
        static const ::Courier::ComponentId mFMMonitorMessageSubscriberList[];

        Candera::UInt8 mFirstArg;
        Candera::UInt8 mSecondArg;
};

// ------------------------------------------------------------------------
class NextSelectMsg_AM : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(NextSelectMsg_AM, ::NotifierMessage, 0x27AF3608);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        NextSelectMsg_AM();
        virtual ~NextSelectMsg_AM();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mNextSelectMsg_AMMetaData;
        static ::Courier::Message::ModifiableMetadata mNextSelectMsg_AMModifiableMetadata;
        static const ::Courier::ComponentId mNextSelectMsg_AMSubscriberList[];
};

// ------------------------------------------------------------------------
class PreviousSelectMsg_AM : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(PreviousSelectMsg_AM, ::NotifierMessage, 0x8C2AC175);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        PreviousSelectMsg_AM();
        virtual ~PreviousSelectMsg_AM();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mPreviousSelectMsg_AMMetaData;
        static ::Courier::Message::ModifiableMetadata mPreviousSelectMsg_AMModifiableMetadata;
        static const ::Courier::ComponentId mPreviousSelectMsg_AMSubscriberList[];
};

// ------------------------------------------------------------------------
class NextSelectMsg_DAB : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(NextSelectMsg_DAB, ::NotifierMessage, 0xAAB8BA5E);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        NextSelectMsg_DAB();
        virtual ~NextSelectMsg_DAB();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mNextSelectMsg_DABMetaData;
        static ::Courier::Message::ModifiableMetadata mNextSelectMsg_DABModifiableMetadata;
        static const ::Courier::ComponentId mNextSelectMsg_DABSubscriberList[];
};

// ------------------------------------------------------------------------
class PreviousSelectMsg_DAB : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(PreviousSelectMsg_DAB, ::NotifierMessage, 0x96644B79);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        PreviousSelectMsg_DAB();
        virtual ~PreviousSelectMsg_DAB();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mPreviousSelectMsg_DABMetaData;
        static ::Courier::Message::ModifiableMetadata mPreviousSelectMsg_DABModifiableMetadata;
        static const ::Courier::ComponentId mPreviousSelectMsg_DABSubscriberList[];
};

// ------------------------------------------------------------------------
class NextSelectMsg_FM : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(NextSelectMsg_FM, ::NotifierMessage, 0xDF930A61);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        NextSelectMsg_FM();
        virtual ~NextSelectMsg_FM();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mNextSelectMsg_FMMetaData;
        static ::Courier::Message::ModifiableMetadata mNextSelectMsg_FMModifiableMetadata;
        static const ::Courier::ComponentId mNextSelectMsg_FMSubscriberList[];
};

// ------------------------------------------------------------------------
class Tuner_WxBLMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(Tuner_WxBLMsg, ::NotifierMessage, 0x6BEE976C);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        Tuner_WxBLMsg(Courier::Int32 const & aEventId);
        virtual ~Tuner_WxBLMsg();

        Courier::Int32 const & GetEventId() const { return mEventId; }
        void SetEventId(Courier::Int32 const & value) { mEventId = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(Tuner_WxBLMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTuner_WxBLMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mTuner_WxBLMsgModifiableMetadata;
        static const ::Courier::ComponentId mTuner_WxBLMsgSubscriberList[];

        Courier::Int32 mEventId;
};

// ------------------------------------------------------------------------
class PreviousSelectMsg_FM : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(PreviousSelectMsg_FM, ::NotifierMessage, 0xDD4EE024);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        PreviousSelectMsg_FM();
        virtual ~PreviousSelectMsg_FM();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mPreviousSelectMsg_FMMetaData;
        static ::Courier::Message::ModifiableMetadata mPreviousSelectMsg_FMModifiableMetadata;
        static const ::Courier::ComponentId mPreviousSelectMsg_FMSubscriberList[];
};

// ------------------------------------------------------------------------
class NextIconSelectMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(NextIconSelectMsg, ::NotifierMessage, 0xB933A1C6);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        NextIconSelectMsg();
        virtual ~NextIconSelectMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mNextIconSelectMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mNextIconSelectMsgModifiableMetadata;
        static const ::Courier::ComponentId mNextIconSelectMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class PreviousIconSelectMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(PreviousIconSelectMsg, ::NotifierMessage, 0xF588E43C);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        PreviousIconSelectMsg();
        virtual ~PreviousIconSelectMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mPreviousIconSelectMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mPreviousIconSelectMsgModifiableMetadata;
        static const ::Courier::ComponentId mPreviousIconSelectMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class AbortNextPreviousIcon : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(AbortNextPreviousIcon, ::NotifierMessage, 0xBC575CA6);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        AbortNextPreviousIcon();
        virtual ~AbortNextPreviousIcon();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mAbortNextPreviousIconMetaData;
        static ::Courier::Message::ModifiableMetadata mAbortNextPreviousIconModifiableMetadata;
        static const ::Courier::ComponentId mAbortNextPreviousIconSubscriberList[];
};

// ------------------------------------------------------------------------
class ButtonMainSrcActivate : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ButtonMainSrcActivate, ::NotifierMessage, 0x995B94C5);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ButtonMainSrcActivate(Courier::Int8 const & aSrcmode);
        virtual ~ButtonMainSrcActivate();

        Courier::Int8 const & GetSrcmode() const { return mSrcmode; }
        void SetSrcmode(Courier::Int8 const & value) { mSrcmode = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ButtonMainSrcActivate);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mButtonMainSrcActivateMetaData;
        static ::Courier::Message::ModifiableMetadata mButtonMainSrcActivateModifiableMetadata;
        static const ::Courier::ComponentId mButtonMainSrcActivateSubscriberList[];

        Courier::Int8 mSrcmode;
};

// ------------------------------------------------------------------------
class HdOnOffReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(HdOnOffReqMsg, ::NotifierMessage, 0xA29E8190);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        HdOnOffReqMsg(Courier::Int8 const & aBand);
        virtual ~HdOnOffReqMsg();

        Courier::Int8 const & GetBand() const { return mBand; }
        void SetBand(Courier::Int8 const & value) { mBand = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(HdOnOffReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mHdOnOffReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mHdOnOffReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mHdOnOffReqMsgSubscriberList[];

        Courier::Int8 mBand;
};

// ------------------------------------------------------------------------
class ChannelInfoMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ChannelInfoMsg, ::NotifierMessage, 0x9E9C9ADB);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        ChannelInfoMsg(Candera::UInt8 const & aAdvisoryText);
        virtual ~ChannelInfoMsg();

        Candera::UInt8 const & GetAdvisoryText() const { return mAdvisoryText; }
        void SetAdvisoryText(Candera::UInt8 const & value) { mAdvisoryText = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ChannelInfoMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mChannelInfoMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mChannelInfoMsgModifiableMetadata;
        static const ::Courier::ComponentId mChannelInfoMsgSubscriberList[];

        Candera::UInt8 mAdvisoryText;
};

// ------------------------------------------------------------------------
class DtmSplitAudioReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DtmSplitAudioReqMsg, ::NotifierMessage, 0x9125B52B);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        DtmSplitAudioReqMsg();
        virtual ~DtmSplitAudioReqMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDtmSplitAudioReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mDtmSplitAudioReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mDtmSplitAudioReqMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class DtmResetTransitionsReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DtmResetTransitionsReqMsg, ::NotifierMessage, 0xD1452C5D);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        DtmResetTransitionsReqMsg();
        virtual ~DtmResetTransitionsReqMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDtmResetTransitionsReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mDtmResetTransitionsReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mDtmResetTransitionsReqMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class HdParameterTuningMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(HdParameterTuningMsg, ::NotifierMessage, 0x38F1DF32);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        HdParameterTuningMsg(Courier::Int8 const & aTuneType);
        virtual ~HdParameterTuningMsg();

        Courier::Int8 const & GetTuneType() const { return mTuneType; }
        void SetTuneType(Courier::Int8 const & value) { mTuneType = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(HdParameterTuningMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mHdParameterTuningMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mHdParameterTuningMsgModifiableMetadata;
        static const ::Courier::ComponentId mHdParameterTuningMsgSubscriberList[];

        Courier::Int8 mTuneType;
};

// ------------------------------------------------------------------------
class HdParameterListUpdate : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(HdParameterListUpdate, ::NotifierMessage, 0x661C08BC);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        HdParameterListUpdate(Courier::Int8 const & aUpdate);
        virtual ~HdParameterListUpdate();

        Courier::Int8 const & GetUpdate() const { return mUpdate; }
        void SetUpdate(Courier::Int8 const & value) { mUpdate = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(HdParameterListUpdate);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mHdParameterListUpdateMetaData;
        static ::Courier::Message::ModifiableMetadata mHdParameterListUpdateModifiableMetadata;
        static const ::Courier::ComponentId mHdParameterListUpdateSubscriberList[];

        Courier::Int8 mUpdate;
};

// ------------------------------------------------------------------------
class HdAudioProgSelectMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(HdAudioProgSelectMsg, ::NotifierMessage, 0xC4AB8CF5);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        HdAudioProgSelectMsg(Courier::UInt32 const & aProgVal);
        virtual ~HdAudioProgSelectMsg();

        Courier::UInt32 const & GetProgVal() const { return mProgVal; }
        void SetProgVal(Courier::UInt32 const & value) { mProgVal = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(HdAudioProgSelectMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mHdAudioProgSelectMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mHdAudioProgSelectMsgModifiableMetadata;
        static const ::Courier::ComponentId mHdAudioProgSelectMsgSubscriberList[];

        Courier::UInt32 mProgVal;
};

// ------------------------------------------------------------------------
class HdListAccessUpdateMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(HdListAccessUpdateMsg, ::NotifierMessage, 0xC16DE478);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        HdListAccessUpdateMsg(Courier::Int8 const & aScreenStatus);
        virtual ~HdListAccessUpdateMsg();

        Courier::Int8 const & GetScreenStatus() const { return mScreenStatus; }
        void SetScreenStatus(Courier::Int8 const & value) { mScreenStatus = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(HdListAccessUpdateMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mHdListAccessUpdateMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mHdListAccessUpdateMsgModifiableMetadata;
        static const ::Courier::ComponentId mHdListAccessUpdateMsgSubscriberList[];

        Courier::Int8 mScreenStatus;
};

// ------------------------------------------------------------------------
class ContextToMaster : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ContextToMaster, ::NotifierMessage, 0x308C6F56);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        ContextToMaster(Courier::UInt8 const & aContextScene);
        virtual ~ContextToMaster();

        Courier::UInt8 const & GetContextScene() const { return mContextScene; }
        void SetContextScene(Courier::UInt8 const & value) { mContextScene = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ContextToMaster);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mContextToMasterMetaData;
        static ::Courier::Message::ModifiableMetadata mContextToMasterModifiableMetadata;
        static const ::Courier::ComponentId mContextToMasterSubscriberList[];

        Courier::UInt8 mContextScene;
};

// ------------------------------------------------------------------------
class CloseNextPrev : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CloseNextPrev, ::NotifierMessage, 0xB0D56C12);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        CloseNextPrev();
        virtual ~CloseNextPrev();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCloseNextPrevMetaData;
        static ::Courier::Message::ModifiableMetadata mCloseNextPrevModifiableMetadata;
        static const ::Courier::ComponentId mCloseNextPrevSubscriberList[];
};

// ------------------------------------------------------------------------
class SXMContextMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SXMContextMsg, ::NotifierMessage, 0xEF625EB7);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        SXMContextMsg();
        virtual ~SXMContextMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSXMContextMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSXMContextMsgModifiableMetadata;
        static const ::Courier::ComponentId mSXMContextMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class TestmodeBlockContextMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(TestmodeBlockContextMsg, ::NotifierMessage, 0xBDBD19DD);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        TestmodeBlockContextMsg();
        virtual ~TestmodeBlockContextMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTestmodeBlockContextMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mTestmodeBlockContextMsgModifiableMetadata;
        static const ::Courier::ComponentId mTestmodeBlockContextMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class SXMSettingsTestmodeContextMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SXMSettingsTestmodeContextMsg, ::NotifierMessage, 0x08B3F6BC);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        SXMSettingsTestmodeContextMsg();
        virtual ~SXMSettingsTestmodeContextMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSXMSettingsTestmodeContextMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSXMSettingsTestmodeContextMsgModifiableMetadata;
        static const ::Courier::ComponentId mSXMSettingsTestmodeContextMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class SXMMonitorContextMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SXMMonitorContextMsg, ::NotifierMessage, 0x5F124B34);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        SXMMonitorContextMsg();
        virtual ~SXMMonitorContextMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSXMMonitorContextMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSXMMonitorContextMsgModifiableMetadata;
        static const ::Courier::ComponentId mSXMMonitorContextMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class FMAMBackContextMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(FMAMBackContextMsg, ::NotifierMessage, 0xF311DF21);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        FMAMBackContextMsg();
        virtual ~FMAMBackContextMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mFMAMBackContextMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mFMAMBackContextMsgModifiableMetadata;
        static const ::Courier::ComponentId mFMAMBackContextMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class ViewPreviousMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ViewPreviousMsg, ::NotifierMessage, 0x8A5CE4BA);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        ViewPreviousMsg();
        virtual ~ViewPreviousMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mViewPreviousMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mViewPreviousMsgModifiableMetadata;
        static const ::Courier::ComponentId mViewPreviousMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class ActiveRenderedView : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ActiveRenderedView, ::NotifierMessage, 0xA2BF1EE3);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        ActiveRenderedView(Courier::UInt32 const & aSurfaceId, Candera::String const & aViewName);
        virtual ~ActiveRenderedView();

        Courier::UInt32 const & GetSurfaceId() const { return mSurfaceId; }
        void SetSurfaceId(Courier::UInt32 const & value) { mSurfaceId = value; }
        Candera::String const & GetViewName() const { return mViewName; }
        void SetViewName(Candera::String const & value) { mViewName = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ActiveRenderedView);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mActiveRenderedViewMetaData;
        static ::Courier::Message::ModifiableMetadata mActiveRenderedViewModifiableMetadata;
        static const ::Courier::ComponentId mActiveRenderedViewSubscriberList[];

        Courier::UInt32 mSurfaceId;
        Candera::String mViewName;
};

// ------------------------------------------------------------------------
class onHardKeyPress : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(onHardKeyPress, ::NotifierMessage, 0xE34D3E88);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        onHardKeyPress(Courier::UInt32 const & aHKCode, hmibase::HardKeyStateEnum const & aHKState);
        virtual ~onHardKeyPress();

        Courier::UInt32 const & GetHKCode() const { return mHKCode; }
        void SetHKCode(Courier::UInt32 const & value) { mHKCode = value; }
        hmibase::HardKeyStateEnum const & GetHKState() const { return mHKState; }
        void SetHKState(hmibase::HardKeyStateEnum const & value) { mHKState = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(onHardKeyPress);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata monHardKeyPressMetaData;
        static ::Courier::Message::ModifiableMetadata monHardKeyPressModifiableMetadata;
        static const ::Courier::ComponentId monHardKeyPressSubscriberList[];

        Courier::UInt32 mHKCode;
        hmibase::HardKeyStateEnum mHKState;
};

#endif // AppHmi_TunerMessages_h
