/************************************************************************
*FILE: AppHmi_TestmodeStateMachine.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "AppHmi_TestmodeStateMachine.h"
#include <FeatStd/Util/StaticObject.h>
#include <Cit/VisualStateGlueLayer/VisualStateGlueLayer.h>
#include <Courier/Util/Util.h>
using namespace ::hmibase;
using namespace ::hmi;

//====  defines and includes TTFis output - added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
#include "hmi_trace_if.h"
#include "View/CGI/CourierMsgTracing/CourierMessageMapTrace.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_SM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/AppHmi_TestmodeStateMachine.cpp.trc.h"
#endif                            
//====  defines and includes TTFis output - end                        key: SM_TTFis_SBHFMSRF ====

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
bool SendLinearAudioReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::LinearAudioReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendHealthCareMntrDTCMsg(enHealthCareMntrDTCType const & aHealthCareMntrDTCack)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::HealthCareMntrDTCMsg)(aHealthCareMntrDTCack);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFMEnhancerReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FMEnhancerReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDABIconVisibility()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DABIconVisibility)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSwitchApplicationReq(enApplicationId const & aApplicationID, enSurfaceId const & aSurfaceID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SwitchApplicationReq)(aApplicationID, aSurfaceID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFMMonitorMessage(Candera::UInt8 const & aFirstArg, Candera::UInt8 const & aSecondArg)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FMMonitorMessage)(aFirstArg, aSecondArg);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendTunerBLMsg(Courier::Int8 const & aEventId, Courier::Int32 const & aFirstArg, Courier::Int32 const & aSecondArg)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::TunerBLMsg)(aEventId, aFirstArg, aSecondArg);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmDTMTestModeMonitorSelReqMsg(bool const & aStartMonitor)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmDTMTestModeMonitorSelReqMsg)(aStartMonitor);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMAudioCustomizeListReqMsg(bool const & aStartMonitor)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMAudioCustomizeListReqMsg)(aStartMonitor);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMAudioRecallorStoreReqMsg(Courier::UInt8 const & aPresetRowIndex, Courier::UInt8 const & aPresetColIndex, Courier::UInt8 const & aPresetAction)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMAudioRecallorStoreReqMsg)(aPresetRowIndex, aPresetColIndex, aPresetAction);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMAudioAllocateReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMAudioAllocateReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendGuiStartupFinishedUpdMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::GuiStartupFinishedUpdMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendWXAudioAllocateReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::WXAudioAllocateReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendTuner_WxBLMsg(Courier::Int32 const & aEventId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Tuner_WxBLMsg)(aEventId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendContextToMaster()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ContextToMaster)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeLanguageReqMsg(enLanguageId const & aLanguageId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeLanguageReqMsg)(aLanguageId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFocusReqMsg(FocusActionEnum const & aAction, FocusTimerActionEnum const & aTimerAction, ::Courier::ViewId const & aView, Candera::String const & aWidget)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FocusReqMsg)(aAction, aTimerAction, aView, aWidget);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDummyMess(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DummyMess)(aFirstView, aSecondView, aPos);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAnimationReqMsg(Courier::AnimationAction::Enum const & aAnimationAction, ::Courier::ViewId const & aViewId, Courier::CompositePath const & aCompositePath, ::Courier::ItemId const & aAnimationId, Courier::AnimationProperties const & aAnimationProperties)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::AnimationReqMsg)(aAnimationAction, aViewId, aCompositePath, aAnimationId, aAnimationProperties);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFocusOnRightEncoderReqUpdMsg(bool const & aIsFocusUsed)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FocusOnRightEncoderReqUpdMsg)(aIsFocusUsed);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStoreActiveGadgetReqMsg(bool const & aIsGadgetAtive)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StoreActiveGadgetReqMsg)(aIsGadgetAtive);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendHardKeyPressNotificationMsg(Courier::UInt8 const & aDummy, Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::HardKeyPressNotificationMsg)(aDummy, aHKCode, aHKState);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDropdownChangeMsg(::Candera::DropdownChangeType const & aDropdownChangeType, ::Courier::UInt32 const & aListId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DropdownChangeMsg)(aDropdownChangeType, aListId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStartPopupTimerReqMsg(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StartPopupTimerReqMsg)(aViewId, aTimeout);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStopPopupTimerReqMsg(Courier::UInt32 const & aViewId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StopPopupTimerReqMsg)(aViewId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPlayBeepReqMsg(Courier::Int32 const & aBeepType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PlayBeepReqMsg)(aBeepType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCheckToClosePopupMsg(Courier::UInt32 const & aPopupId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CheckToClosePopupMsg)(aPopupId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendRestartPopupTimerReqMsg(Courier::UInt32 const & aViewId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::RestartPopupTimerReqMsg)(aViewId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendContextSwitchInResMsg(Courier::UInt32 const & aSwitchId, Courier::UInt32 const & aResponseType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ContextSwitchInResMsg)(aSwitchId, aResponseType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendContextSwitchOutReqMsg(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ContextSwitchOutReqMsg)(aTargetContextId, aSourceContextId, aTargetAppId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCurrentScreenDisplayReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CurrentScreenDisplayReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendLaunchBarDisplayReqMsg(bool const & aVisibility)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::LaunchBarDisplayReqMsg)(aVisibility);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendNavTBTSwipeReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::NavTBTSwipeReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListItemRightEncoderChangeUpdMsg(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListItemRightEncoderChangeUpdMsg)(aSteps, aListId, aRowId, aColumnId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListChangeMsg(::Courier::UInt32 const & aListId, ListChangeType const & aListChangeType, ::Courier::Int32 const & aValue, ListChangeMsgSourceType const & aListChangeMsgSource, bool const & aImmediatePositioning)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListChangeMsg)(aListId, aListChangeType, aValue, aListChangeMsgSource, aImmediatePositioning);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListFocusScrollReqMsg(Courier::UInt32 const & aListId, Courier::Int32 const & aSteps)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListFocusScrollReqMsg)(aListId, aSteps);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListFocusLockDataResetReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListFocusLockDataResetReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSetApplicationModeReqMsg(Courier::UInt32 const & aModeId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SetApplicationModeReqMsg)(aModeId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSpellerBbehaviorReqMsg(bool const & aEnable)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SpellerBbehaviorReqMsg)(aEnable);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStatusBarDisplayReqMsg(bool const & aVisibility, Courier::Int32 const & aHeaderType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StatusBarDisplayReqMsg)(aVisibility, aHeaderType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendTBTRetriggerAcousticMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::TBTRetriggerAcousticMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendViewReqMsg(Courier::ViewAction::Enum const & aViewAction, ::Courier::ViewId const & aViewId, bool const & aShallInitScene, bool const & aShallLoadScene)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::ViewReqMsg)(aViewAction, aViewId, aShallInitScene, aShallLoadScene);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendActivationReqMsg(::Courier::ViewId const & aViewId, bool const & aActivation, bool const & aEnableRendering)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::ActivationReqMsg)(aViewId, aActivation, aEnableRendering);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAsyncLoadReqMsg(::Courier::ViewId const & aViewId, bool const & aLoad)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::AsyncLoadReqMsg)(aViewId, aLoad);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupReqMsg(hmibase::popups::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aPopupDisplayID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupReqMsg)(aCommand, aViewId, aPopupDisplayID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendExtendedViewReqMsg(hmibase::views::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ExtendedViewReqMsg)(aCommand, aViewId, aHint);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendShowHMISubSurfaceReqMsg(hmibase::displayRegion const & aDisplayRegion, Courier::Int32 const & aDisplayRegionType, bool const & aShowSubSurface, Courier::UInt32 const & aDisplayID, bool const & aLockSubSurface)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ShowHMISubSurfaceReqMsg)(aDisplayRegion, aDisplayRegionType, aShowSubSurface, aDisplayID, aLockSubSurface);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendRegisterForCloseOnTouchSessionReqMsg(bool const & aRegister, ::Courier::ViewId const & aViewId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::RegisterForCloseOnTouchSessionReqMsg)(aRegister, aViewId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupFilterPrioEnableReqMsg(Courier::UInt32 const & aPrio)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupFilterPrioEnableReqMsg)(aPrio);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupFilterAllEnableReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupFilterAllEnableReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupFilterDisableReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupFilterDisableReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendProfileSwitchMsg(Courier::UInt32 const & aProfile)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ProfileSwitchMsg)(aProfile);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendMultiDisplayPopupFilterReqMsg(hmibase::PopupFilterType const & aPopupFilterType, Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::MultiDisplayPopupFilterReqMsg)(aPopupFilterType, aPrio, aDisplayID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCreateNewDestroyOld(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CreateNewDestroyOld)(aSourceView, aDestinationView, aUserData1, aUserData2);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendNotifierMessage()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::NotifierMessage)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PerformLinearAudio(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_PerformLinearAudio();
    return true;
}
#endif
void Action_PerformLinearAudio()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action PerformLinearAudio()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendLinearAudioReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PerformHealthCareMntrDTCMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_PerformHealthCareMntrDTCMsg(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_PerformHealthCareMntrDTCMsg(enHealthCareMntrDTCType const & aHealthCareMntrDTCack)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action PerformHealthCareMntrDTCMsg(aHealthCareMntrDTCack = ?enHealthCareMntrDTCType?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendHealthCareMntrDTCMsg(aHealthCareMntrDTCack);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PerformFMEnhancer(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_PerformFMEnhancer();
    return true;
}
#endif
void Action_PerformFMEnhancer()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action PerformFMEnhancer()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFMEnhancerReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_DABIconVisibilityMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_DABIconVisibilityMsg();
    return true;
}
#endif
void Action_DABIconVisibilityMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action DABIconVisibilityMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDABIconVisibility();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_Home_Source(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Activate_Home_Source();
    return true;
}
#endif
void Action_Perform_Activate_Home_Source()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action Perform_Activate_Home_Source()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchApplicationReq(APPID_APPHMI_MASTER, SURFACEID_MAIN_SURFACE_MASTER);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_FMMonitorMessageSharxHiCut(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_FMMonitorMessageSharxHiCut(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_FMMonitorMessageSharxHiCut(Candera::UInt8 const & aFirstArg, Candera::UInt8 const & aSecondArg)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action FMMonitorMessageSharxHiCut(aFirstArg = ?Candera::UInt8?, aSecondArg = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFMMonitorMessage(aFirstArg, aSecondArg);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Tuner_fn(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt())) { return false; }
    Action_Perform_Tuner_fn(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt(), parameters[(::Json::Value::UInt)2].asUInt());
    return true;
}
#endif
void Action_Perform_Tuner_fn(Courier::Int8 const & aEventId, Courier::Int32 const & aFirstArg, Courier::Int32 const & aSecondArg)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action Perform_Tuner_fn(aEventId = %d, aFirstArg = %d, aSecondArg = %d)", aEventId,aFirstArg,aSecondArg));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTunerBLMsg(aEventId, aFirstArg, aSecondArg);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_TestMode_Active_Screen(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_Perform_TestMode_Active_Screen(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_Perform_TestMode_Active_Screen(bool const & aStartMonitor)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action Perform_TestMode_Active_Screen(aStartMonitor = %d)", aStartMonitor));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmDTMTestModeMonitorSelReqMsg(aStartMonitor);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_ChannelList_Screen_Active(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_Perform_ChannelList_Screen_Active(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_Perform_ChannelList_Screen_Active(bool const & aStartMonitor)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action Perform_ChannelList_Screen_Active(aStartMonitor = %d)", aStartMonitor));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMAudioCustomizeListReqMsg(aStartMonitor);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_SXMAudioRecallorStore(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt())) { return false; }
    Action_SXMAudioRecallorStore(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt(), parameters[(::Json::Value::UInt)2].asUInt());
    return true;
}
#endif
void Action_SXMAudioRecallorStore(Courier::UInt8 const & aPresetRowIndex, Courier::UInt8 const & aPresetColIndex, Courier::UInt8 const & aPresetAction)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action SXMAudioRecallorStore(aPresetRowIndex = %d, aPresetColIndex = %d, aPresetAction = %d)", aPresetRowIndex,aPresetColIndex,aPresetAction));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMAudioRecallorStoreReqMsg(aPresetRowIndex, aPresetColIndex, aPresetAction);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_SXM_Audio_Allocation(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_SXM_Audio_Allocation();
    return true;
}
#endif
void Action_Perform_SXM_Audio_Allocation()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action Perform_SXM_Audio_Allocation()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMAudioAllocateReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Notify_Init_Finished(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Notify_Init_Finished();
    return true;
}
#endif
void Action_Notify_Init_Finished()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action Notify_Init_Finished()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendGuiStartupFinishedUpdMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_WX_Audio_Allocation(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_WX_Audio_Allocation();
    return true;
}
#endif
void Action_Perform_WX_Audio_Allocation()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action Perform_WX_Audio_Allocation()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendWXAudioAllocateReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Tuner_Wx_fn(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_Perform_Tuner_Wx_fn(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_Perform_Tuner_Wx_fn(Courier::Int32 const & aEventId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action Perform_Tuner_Wx_fn(aEventId = %d)", aEventId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTuner_WxBLMsg(aEventId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Perform_Testmode_Context(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Perform_Testmode_Context();
    return true;
}
#endif
void Action_Perform_Testmode_Context()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action Perform_Testmode_Context()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextToMaster();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacChangeLanguageReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacChangeLanguageReq(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacChangeLanguageReq(enLanguageId const & aLanguageId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacChangeLanguageReq(aLanguageId = ?enLanguageId?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeLanguageReqMsg(aLanguageId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideFocusInViewReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacHideFocusInViewReq(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacHideFocusInViewReq(::Courier::ViewId const & aView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacHideFocusInViewReq(aView = %50s)", aView.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFocusReqMsg(FOCUS_HIDE, FOCUS_TIMER_NO_ACTION, aView, Candera::String());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_NextLevelTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_NextLevelTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_NextLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action NextLevelTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PreviousLevelTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_PreviousLevelTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_PreviousLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action PreviousLevelTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_DualViewLeftTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_DualViewLeftTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_DualViewLeftTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action DualViewLeftTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_DualViewRightTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_DualViewRightTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_DualViewRightTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action DualViewRightTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PageFlipBackTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_PageFlipBackTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_PageFlipBackTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action PageFlipBackTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PageFlipFrontTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_PageFlipFrontTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_PageFlipFrontTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action PageFlipFrontTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ZoomInTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt() && parameters[(::Json::Value::UInt)2].isInt())) { return false; }
    Action_ZoomInTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt(), parameters[(::Json::Value::UInt)2].asInt());
    return true;
}
#endif
void Action_ZoomInTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action ZoomInTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?, aPos = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, aPos);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ZoomOutTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt() && parameters[(::Json::Value::UInt)2].isInt())) { return false; }
    Action_ZoomOutTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt(), parameters[(::Json::Value::UInt)2].asInt());
    return true;
}
#endif
void Action_ZoomOutTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action ZoomOutTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?, aPos = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, aPos);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_FadeTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_FadeTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_FadeTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action FadeTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStartReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacWaitAnimationStartReq();
    return true;
}
#endif
void Action_gacWaitAnimationStartReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacWaitAnimationStartReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAnimationReqMsg(Courier::AnimationAction::Start, ::Courier::ViewId(), Courier::CompositePath(), ::Courier::ItemId("Global#Animations#WAIT_ANIMATION"), Courier::AnimationProperties());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acFocusOnRightEncoderReqUpd(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acFocusOnRightEncoderReqUpd(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acFocusOnRightEncoderReqUpd(bool const & aIsFocusUsed)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action acFocusOnRightEncoderReqUpd(aIsFocusUsed = %d)", aIsFocusUsed));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFocusOnRightEncoderReqUpdMsg(aIsFocusUsed);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetGadgetSceenActiveStatus(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acSetGadgetSceenActiveStatus(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acSetGadgetSceenActiveStatus(bool const & aIsGadgetAtive)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action acSetGadgetSceenActiveStatus(aIsGadgetAtive = %d)", aIsGadgetAtive));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStoreActiveGadgetReqMsg(aIsGadgetAtive);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acHKNotificationMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_acHKNotificationMsg(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_acHKNotificationMsg(Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action acHKNotificationMsg(aHKCode = %d, aHKState = %d)", aHKCode,aHKState));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendHardKeyPressNotificationMsg(1, aHKCode, aHKState);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseAllDropdowns(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acPerform_CloseAllDropdowns();
    return true;
}
#endif
void Action_acPerform_CloseAllDropdowns()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action acPerform_CloseAllDropdowns()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeClose, 0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseDropdown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acPerform_CloseDropdown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acPerform_CloseDropdown(::Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action acPerform_CloseDropdown(aListId = ?::Courier::UInt32?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeClose, aListId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_OpenDropdown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acPerform_OpenDropdown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acPerform_OpenDropdown(::Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action acPerform_OpenDropdown(aListId = ?::Courier::UInt32?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeOpen, aListId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_ToggleDropdown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acPerform_ToggleDropdown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acPerform_ToggleDropdown(::Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action acPerform_ToggleDropdown(aListId = ?::Courier::UInt32?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeToggle, aListId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acStartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_acStartAppPopupTimer(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_acStartAppPopupTimer(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action acStartAppPopupTimer(aViewId = %d, aTimeout = %d)", aViewId,aTimeout));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStartPopupTimerReqMsg(aViewId, aTimeout);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acStopAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acStopAppPopupTimer(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acStopAppPopupTimer(Courier::UInt32 const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action acStopAppPopupTimer(aViewId = %d)", aViewId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStopPopupTimerReqMsg(aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPostBeep(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_acPostBeep(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_acPostBeep(Courier::Int32 const & aBeepType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action acPostBeep(aBeepType = %d)", aBeepType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPlayBeepReqMsg(aBeepType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacCheckToClosePopup(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacCheckToClosePopup(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacCheckToClosePopup(Courier::UInt32 const & aPopupId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacCheckToClosePopup(aPopupId = %d)", aPopupId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCheckToClosePopupMsg(aPopupId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acRestartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acRestartAppPopupTimer(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acRestartAppPopupTimer(Courier::UInt32 const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action acRestartAppPopupTimer(aViewId = %d)", aViewId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRestartPopupTimerReqMsg(aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchBackRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchBackRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchBackRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacContextSwitchBackRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_BACK);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchCompleteRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchCompleteRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchCompleteRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacContextSwitchCompleteRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_COMPLETE);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchFailedRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchFailedRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchFailedRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacContextSwitchFailedRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_FAILED);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchDoneRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchDoneRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchDoneRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacContextSwitchDoneRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_DONE);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchOutReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt())) { return false; }
    Action_gacContextSwitchOutReq(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt(), parameters[(::Json::Value::UInt)2].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchOutReq(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacContextSwitchOutReq(aTargetContextId = %d, aSourceContextId = %d, aTargetAppId = %d)", aTargetContextId,aSourceContextId,aTargetAppId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchOutReqMsg(aTargetContextId, aSourceContextId, aTargetAppId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacCurrentScreenDisplayReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacCurrentScreenDisplayReq();
    return true;
}
#endif
void Action_gacCurrentScreenDisplayReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacCurrentScreenDisplayReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCurrentScreenDisplayReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacLaunchBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_gacLaunchBarDisplayReq(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_gacLaunchBarDisplayReq(bool const & aVisibility)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacLaunchBarDisplayReq(aVisibility = %d)", aVisibility));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendLaunchBarDisplayReqMsg(aVisibility);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacNavTBTSwipe(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacNavTBTSwipe();
    return true;
}
#endif
void Action_gacNavTBTSwipe()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacNavTBTSwipe()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendNavTBTSwipeReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListBtnRightEncoderChangeUpd(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 4) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt() && parameters[(::Json::Value::UInt)3].isUInt())) { return false; }
    Action_gacPerformListBtnRightEncoderChangeUpd(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt(), parameters[(::Json::Value::UInt)2].asUInt(), parameters[(::Json::Value::UInt)3].asUInt());
    return true;
}
#endif
void Action_gacPerformListBtnRightEncoderChangeUpd(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacPerformListBtnRightEncoderChangeUpd(aSteps = %d, aListId = %d, aRowId = %d, aColumnId = %d)", aSteps,aListId,aRowId,aColumnId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListItemRightEncoderChangeUpdMsg(aSteps, aListId, aRowId, aColumnId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListUp(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollListUp();
    return true;
}
#endif
void Action_gacScrollListUp()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacScrollListUp()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangeUp, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListDown(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollListDown();
    return true;
}
#endif
void Action_gacScrollListDown()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacScrollListDown()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangeDown, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageUp(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollPageUp();
    return true;
}
#endif
void Action_gacScrollPageUp()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacScrollPageUp()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangePageUp, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageDown(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollPageDown();
    return true;
}
#endif
void Action_gacScrollPageDown()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacScrollPageDown()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangePageDown, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusUp(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacScrollListFocusUp(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacScrollListFocusUp(Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacScrollListFocusUp(aListId = %d)", aListId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListFocusScrollReqMsg(aListId, -1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusDown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacScrollListFocusDown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacScrollListFocusDown(Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacScrollListFocusDown(aListId = %d)", aListId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListFocusScrollReqMsg(aListId, 1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListFocusLockDataResetUpd(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacPerformListFocusLockDataResetUpd();
    return true;
}
#endif
void Action_gacPerformListFocusLockDataResetUpd()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacPerformListFocusLockDataResetUpd()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListFocusLockDataResetReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSetApplicationMode(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacSetApplicationMode(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacSetApplicationMode(Courier::UInt32 const & aModeId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacSetApplicationMode(aModeId = %d)", aModeId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSetApplicationModeReqMsg(aModeId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSpellerBbehaviorReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_gacSpellerBbehaviorReq(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_gacSpellerBbehaviorReq(bool const & aEnable)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacSpellerBbehaviorReq(aEnable = %d)", aEnable));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSpellerBbehaviorReqMsg(aEnable);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacStatusBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_gacStatusBarDisplayReq(parameters[(::Json::Value::UInt)0].asBool(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_gacStatusBarDisplayReq(bool const & aVisibility, Courier::Int32 const & aHeaderType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacStatusBarDisplayReq(aVisibility = %d, aHeaderType = %d)", aVisibility,aHeaderType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStatusBarDisplayReqMsg(aVisibility, aHeaderType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacTBTRetriggerAcousticOutput(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacTBTRetriggerAcousticOutput();
    return true;
}
#endif
void Action_gacTBTRetriggerAcousticOutput()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacTBTRetriggerAcousticOutput()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTBTRetriggerAcousticMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStopReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacWaitAnimationStopReq();
    return true;
}
#endif
void Action_gacWaitAnimationStopReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacWaitAnimationStopReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAnimationReqMsg(Courier::AnimationAction::Stop, ::Courier::ViewId(), Courier::CompositePath(), ::Courier::ItemId("Global#Animations#WAIT_ANIMATION"), Courier::AnimationProperties());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateReq(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacViewCreateReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Create, aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAllReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateAllReq(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateAllReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacViewCreateAllReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::CreateAll, aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewDestroyReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewDestroyReq(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewDestroyReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacViewDestroyReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Destroy, aViewId, false, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewClearReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewClearReq(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewClearReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacViewClearReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Clear, aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewShowReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewShowReq(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewShowReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacViewShowReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivationReqMsg(aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewHideReq(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewHideReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacViewHideReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivationReqMsg(aViewId, false, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateWithoutLoadReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateWithoutLoadReq(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateWithoutLoadReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacViewCreateWithoutLoadReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Create, aViewId, false, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewAsyncLoadReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewAsyncLoadReq(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewAsyncLoadReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacViewAsyncLoadReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAsyncLoadReqMsg(aViewId, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewActivateWithoutRenderingReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacViewActivateWithoutRenderingReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivationReqMsg(aViewId, true, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupCreateAndSBShowReq(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacPopupCreateAndSBShowReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacPopupCreateAndSBShowReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Show, aViewId, hmibase::DEFAULT_UNKNOWN_DISPLAY);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupCreateAndSBShowReqForMultiDisplay(parameters[(::Json::Value::UInt)0].asUInt(), ::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt())));
    return true;
}
#endif
void Action_gacPopupCreateAndSBShowReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacPopupCreateAndSBShowReqForMultiDisplay(aPopupDisplayID = %d, aViewId = %50s)", aPopupDisplayID,aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Show, aViewId, aPopupDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupSBCloseReq(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacPopupSBCloseReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacPopupSBCloseReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Hide, aViewId, hmibase::DEFAULT_UNKNOWN_DISPLAY);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupSBCloseReqForMultiDisplay(parameters[(::Json::Value::UInt)0].asUInt(), ::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt())));
    return true;
}
#endif
void Action_gacPopupSBCloseReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacPopupSBCloseReqForMultiDisplay(aPopupDisplayID = %d, aViewId = %50s)", aPopupDisplayID,aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Hide, aViewId, aPopupDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupRestartTimerReq(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacPopupRestartTimerReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacPopupRestartTimerReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::RestartTimer, aViewId, hmibase::DEFAULT_UNKNOWN_DISPLAY);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupRestartTimerReqForMultiDisplay(parameters[(::Json::Value::UInt)0].asUInt(), ::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt())));
    return true;
}
#endif
void Action_gacPopupRestartTimerReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacPopupRestartTimerReqForMultiDisplay(aPopupDisplayID = %d, aViewId = %50s)", aPopupDisplayID,aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::RestartTimer, aViewId, aPopupDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAndShowReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateAndShowReq(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateAndShowReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacViewCreateAndShowReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::CreateAndShow, aViewId, 0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideAndDestroyReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewHideAndDestroyReq(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewHideAndDestroyReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacViewHideAndDestroyReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::HideAndDestroy, aViewId, 0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionEnter(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacSceneTransitionEnter(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt(), ))parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacSceneTransitionEnter(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacSceneTransitionEnter(aViewId = %50s, aHint = %d)", aViewId.CStr(),aHint));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::TransitionEnter, aViewId, aHint);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionLeave(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacSceneTransitionLeave(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt(), ))parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacSceneTransitionLeave(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacSceneTransitionLeave(aViewId = %50s, aHint = %d)", aViewId.CStr(),aHint));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::TransitionLeave, aViewId, aHint);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacDisplayStatusLineReq(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacDisplayStatusLineReq(Courier::Int32 const & aDisplayRegionType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacDisplayStatusLineReq(aDisplayRegionType = %d)", aDisplayRegionType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, true, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacHideStatusLineReq(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacHideStatusLineReq(Courier::Int32 const & aDisplayRegionType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacHideStatusLineReq(aDisplayRegionType = %d)", aDisplayRegionType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, false, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacDisplayFooterLineReq();
    return true;
}
#endif
void Action_gacDisplayFooterLineReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacDisplayFooterLineReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, Courier::Int32(), true, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacHideFooterLineReq();
    return true;
}
#endif
void Action_gacHideFooterLineReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacHideFooterLineReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, Courier::Int32(), false, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacDisplayStatusLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacDisplayStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacDisplayStatusLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, true, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacHideStatusLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacHideStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacHideStatusLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, false, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacDisplayFooterLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacDisplayFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacDisplayFooterLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, aDisplayRegionType, true, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacHideFooterLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacHideFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacHideFooterLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, aDisplayRegionType, false, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacRegisterForCloseOnTouchSession(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacRegisterForCloseOnTouchSession(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRegisterForCloseOnTouchSessionReqMsg(true, aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDeregisterForCloseOnTouchSessionReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacDeregisterForCloseOnTouchSessionReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRegisterForCloseOnTouchSessionReqMsg(false, aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupFilterPrioEnableReq(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterPrioEnableReq(Courier::UInt32 const & aPrio)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacPopupFilterPrioEnableReq(aPrio = %d)", aPrio));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupFilterPrioEnableReqMsg(aPrio);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacPopupFilterAllEnableReq();
    return true;
}
#endif
void Action_gacPopupFilterAllEnableReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacPopupFilterAllEnableReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupFilterAllEnableReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacPopupFilterDisableReq();
    return true;
}
#endif
void Action_gacPopupFilterDisableReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacPopupFilterDisableReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupFilterDisableReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacProfileChange(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacProfileChange(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacProfileChange(Courier::UInt32 const & aProfile)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacProfileChange(aProfile = %d)", aProfile));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendProfileSwitchMsg(aProfile);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupFilterPrioEnableReqForDisplay(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterPrioEnableReqForDisplay(Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacPopupFilterPrioEnableReqForDisplay(aPrio = %d, aDisplayID = %d)", aPrio,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMultiDisplayPopupFilterReqMsg(hmibase::ENABLE_PRIO, aPrio, aDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupFilterAllEnableReqForDisplay(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterAllEnableReqForDisplay(Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacPopupFilterAllEnableReqForDisplay(aDisplayID = %d)", aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMultiDisplayPopupFilterReqMsg(hmibase::ENABLE_ALL, 0, aDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupFilterDisableReqForDisplay(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterDisableReqForDisplay(Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacPopupFilterDisableReqForDisplay(aDisplayID = %d)", aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMultiDisplayPopupFilterReqMsg(hmibase::DISABLE_ALL, 0, aDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacStartSceneTransitionAnimation(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 4) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt() && parameters[(::Json::Value::UInt)3].isInt())) { return false; }
    Action_gacStartSceneTransitionAnimation(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt(), ))::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt(), ))parameters[(::Json::Value::UInt)2].asUInt(), parameters[(::Json::Value::UInt)3].asInt());
    return true;
}
#endif
void Action_gacStartSceneTransitionAnimation(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacStartSceneTransitionAnimation(aSourceView = %50s, aDestinationView = %50s, aUserData1 = %d, aUserData2 = %d)", aSourceView.CStr(),aDestinationView.CStr(),aUserData1,aUserData2));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCreateNewDestroyOld(aSourceView, aDestinationView, aUserData1, aUserData2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDecrementActiveAnimationCount(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacDecrementActiveAnimationCount();
    return true;
}
#endif
void Action_gacDecrementActiveAnimationCount()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_TESTMODE_SM, "SM_ACTIONS:    Trigger action gacDecrementActiveAnimationCount()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendNotifierMessage();
    COURIER_UNUSED(ok);
}
//====  defines and includes TTFis output - added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====    

unsigned short AppHmi_TestmodeStateMachineImpl::GetTraceClass (){  
   return TR_CLASS_APPHMI_TESTMODE_SM; 
}

//====  member function with TTFis output - end                        key: SM_TTFis_SBHFMSRF ==== 

#include "hmibase/util/Macros.h"

#ifdef CIT_SIMULATION
#define CIT_EVENT_ID(eventId, hashId) hashId
#else
#define CIT_EVENT_ID(eventId, hashId) eventId
#endif
// ------------------------------------------------------------------------
static bool HandleEventMappingForButtonReactionMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::ButtonReactionMsg const & message = static_cast< ::ButtonReactionMsg const &>(aMessage);

#ifdef OnButtonReactionMsg_Testmode_Scenes_R_TestMode_SXM_Monitor_List_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_TestMode_SXM_Monitor_List")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_TestMode_SXM_Monitor_List_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x24BCE485); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_1_BLACK_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#DEV__SYSTEM_DISPLAY_TEST_1_BLACK")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_1_BLACK_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x1F8D9CB1); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner3_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor3")) && (message.GetSender() == ::Courier::Identifier(0x3d3df8b4 /* Textbox_Tuner3/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner3_ButtonWidget_enRelease, 0x94B6D640); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner2_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor3")) && (message.GetSender() == ::Courier::Identifier(0xb39448a5 /* Textbox_Tuner2/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner2_ButtonWidget_enRelease, 0x58AA4076); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner1_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor3")) && (message.GetSender() == ::Courier::Identifier(0xf2170da7 /* Textbox_Tuner1/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner1_ButtonWidget_enRelease, 0x6EAFBFE7); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner3_Band_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor3")) && (message.GetSender() == ::Courier::Identifier(0xc5610203 /* Textbox_Tuner3_Band/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner3_Band_ButtonWidget_enRelease, 0x1A93A999); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner2_Band_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor3")) && (message.GetSender() == ::Courier::Identifier(0x016a8f1d /* Textbox_Tuner2_Band/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner2_Band_ButtonWidget_enRelease, 0x3D8A42CD); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner1_Band_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor3")) && (message.GetSender() == ::Courier::Identifier(0xe83731d1 /* Textbox_Tuner1_Band/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner1_Band_ButtonWidget_enRelease, 0x98C286E5); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Seekup_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor3")) && (message.GetSender() == ::Courier::Identifier(0xc732cea4 /* Layer_TouchArea_Seekup/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Seekup_ButtonWidget_enRelease, 0xD2C72055); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Seekdn_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor3")) && (message.GetSender() == ::Courier::Identifier(0x3ca8043c /* Layer_TouchArea_Seekdn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Seekdn_ButtonWidget_enRelease, 0x4DE01420); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Stepdown_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor3")) && (message.GetSender() == ::Courier::Identifier(0x704386f1 /* Layer_TouchArea_Stepdown/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Stepdown_ButtonWidget_enRelease, 0x1576B11C); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Stepup_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor3")) && (message.GetSender() == ::Courier::Identifier(0x4817fece /* Layer_TouchArea_Stepup/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Stepup_ButtonWidget_enRelease, 0x102976C8); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor3")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Next_ButtonWidget_enRelease, 0x628A6B9F); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor3")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Back_ButtonWidget_enRelease, 0xF3C405C4); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner_AF_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor2")) && (message.GetSender() == ::Courier::Identifier(0x2fa8a518 /* Textbox_Tuner_AF/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner_AF_ButtonWidget_enRelease, 0x16756DF3); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner3_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor2")) && (message.GetSender() == ::Courier::Identifier(0x3d3df8b4 /* Textbox_Tuner3/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner3_ButtonWidget_enRelease, 0x5D088F21); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner2_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor2")) && (message.GetSender() == ::Courier::Identifier(0xb39448a5 /* Textbox_Tuner2/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner2_ButtonWidget_enRelease, 0x7ECA4D84); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner1_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor2")) && (message.GetSender() == ::Courier::Identifier(0xf2170da7 /* Textbox_Tuner1/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner1_ButtonWidget_enRelease, 0x96053BF1); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner3_Band_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor2")) && (message.GetSender() == ::Courier::Identifier(0xc5610203 /* Textbox_Tuner3_Band/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner3_Band_ButtonWidget_enRelease, 0x98DA1856); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner2_Band_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor2")) && (message.GetSender() == ::Courier::Identifier(0x016a8f1d /* Textbox_Tuner2_Band/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner2_Band_ButtonWidget_enRelease, 0x9F8A870B); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner1_Band_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor2")) && (message.GetSender() == ::Courier::Identifier(0xe83731d1 /* Textbox_Tuner1_Band/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner1_Band_ButtonWidget_enRelease, 0x8DA1A379); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Seekup_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor2")) && (message.GetSender() == ::Courier::Identifier(0xc732cea4 /* Layer_TouchArea_Seekup/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Seekup_ButtonWidget_enRelease, 0xD1950BF2); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Seekdn_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor2")) && (message.GetSender() == ::Courier::Identifier(0x3ca8043c /* Layer_TouchArea_Seekdn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Seekdn_ButtonWidget_enRelease, 0x7EAFC2A9); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Stepdown_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor2")) && (message.GetSender() == ::Courier::Identifier(0x704386f1 /* Layer_TouchArea_Stepdown/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Stepdown_ButtonWidget_enRelease, 0x5228DC79); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Stepup_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor2")) && (message.GetSender() == ::Courier::Identifier(0x4817fece /* Layer_TouchArea_Stepup/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Stepup_ButtonWidget_enRelease, 0x7EA740C0); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor2")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Next_ButtonWidget_enRelease, 0xDDD10F14); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor2")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x2E3D8055); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner3_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor")) && (message.GetSender() == ::Courier::Identifier(0x3d3df8b4 /* Textbox_Tuner3/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner3_ButtonWidget_enRelease, 0xE7356244); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_2_WHITE_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#DEV__SYSTEM_DISPLAY_TEST_2_WHITE")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_2_WHITE_Layer_TouchArea_Back_ButtonWidget_enRelease, 0xA5B2C4B6); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_3_RED_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#DEV__SYSTEM_DISPLAY_TEST_3_RED")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_3_RED_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x79ACFD50); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_4_GREEN_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#DEV__SYSTEM_DISPLAY_TEST_4_GREEN")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_4_GREEN_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x326442F5); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_5_BLUE_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#DEV__SYSTEM_DISPLAY_TEST_5_BLUE")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_5_BLUE_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x21AED219); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Monitor_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_WeatherBand_Monitor")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Monitor_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x6D4135C0); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Source_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_WeatherBand")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Source_ButtonWidget_enRelease, 0xD414ECB5); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Preset_10_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_WeatherBand")) && (message.GetSender() == ::Courier::Identifier(0xb9da2cf8 /* Layer_TouchArea_Preset_10/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Preset_10_ButtonWidget_enRelease, 0xEEBD3407); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Preset_9_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_WeatherBand")) && (message.GetSender() == ::Courier::Identifier(0xc48d7eaa /* Layer_TouchArea_Preset_9/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Preset_9_ButtonWidget_enRelease, 0x785F9373); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Preset_8_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_WeatherBand")) && (message.GetSender() == ::Courier::Identifier(0x84fb073a /* Layer_TouchArea_Preset_8/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Preset_8_ButtonWidget_enRelease, 0xFC4B1295); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Preset_7_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_WeatherBand")) && (message.GetSender() == ::Courier::Identifier(0xf4b7f014 /* Layer_TouchArea_Preset_7/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Preset_7_ButtonWidget_enRelease, 0x6692D656); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Preset_6_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_WeatherBand")) && (message.GetSender() == ::Courier::Identifier(0xad746719 /* Layer_TouchArea_Preset_6/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Preset_6_ButtonWidget_enRelease, 0x328EC81A); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Preset_5_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_WeatherBand")) && (message.GetSender() == ::Courier::Identifier(0xd80bf0d5 /* Layer_TouchArea_Preset_5/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Preset_5_ButtonWidget_enRelease, 0xCB89B67C); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Preset_4_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_WeatherBand")) && (message.GetSender() == ::Courier::Identifier(0x378f839d /* Layer_TouchArea_Preset_4/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Preset_4_ButtonWidget_enRelease, 0x6D56F93A); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Preset_3_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_WeatherBand")) && (message.GetSender() == ::Courier::Identifier(0xaaaa6541 /* Layer_TouchArea_Preset_3/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Preset_3_ButtonWidget_enRelease, 0x9F09DD1C); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Preset_2_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_WeatherBand")) && (message.GetSender() == ::Courier::Identifier(0x966c3b3e /* Layer_TouchArea_Preset_2/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Preset_2_ButtonWidget_enRelease, 0xE1815C72); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Preset_1_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_WeatherBand")) && (message.GetSender() == ::Courier::Identifier(0x5e7e68f4 /* Layer_TouchArea_Preset_1/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Preset_1_ButtonWidget_enRelease, 0x34306220); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_RVC_TESTMODE_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#RVC_TESTMODE")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_RVC_TESTMODE_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x9C9BB731); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner2_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor")) && (message.GetSender() == ::Courier::Identifier(0xb39448a5 /* Textbox_Tuner2/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner2_ButtonWidget_enRelease, 0x4AC3AB80); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_DAB_Monitor_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_DAB_Monitor")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_DAB_Monitor_Layer_TouchArea_Back_ButtonWidget_enRelease, 0xF725E179); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_8_MURA1_Layer_TouchArea_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#DEV__SYSTEM_DISPLAY_TEST_8_MURA1")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_8_MURA1_Layer_TouchArea_Next_ButtonWidget_enRelease, 0xF7E3DACF); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_7_FLICKER_2_Layer_TouchArea_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#DEV__SYSTEM_DISPLAY_TEST_7_FLICKER_2")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_7_FLICKER_2_Layer_TouchArea_Next_ButtonWidget_enRelease, 0xC76C6549); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_6_FLICKER_1_Layer_TouchArea_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#DEV__SYSTEM_DISPLAY_TEST_6_FLICKER_1")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_6_FLICKER_1_Layer_TouchArea_Next_ButtonWidget_enRelease, 0x0087BE7C); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_5_BLUE_Layer_TouchArea_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#DEV__SYSTEM_DISPLAY_TEST_5_BLUE")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_5_BLUE_Layer_TouchArea_Next_ButtonWidget_enRelease, 0xD315E3F3); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_4_GREEN_Layer_TouchArea_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#DEV__SYSTEM_DISPLAY_TEST_4_GREEN")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_4_GREEN_Layer_TouchArea_Next_ButtonWidget_enRelease, 0x1CA16FA6); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_3_RED_Layer_TouchArea_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#DEV__SYSTEM_DISPLAY_TEST_3_RED")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_3_RED_Layer_TouchArea_Next_ButtonWidget_enRelease, 0x1DC691D4); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_2_WHITE_Layer_TouchArea_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#DEV__SYSTEM_DISPLAY_TEST_2_WHITE")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_2_WHITE_Layer_TouchArea_Next_ButtonWidget_enRelease, 0x964057A3); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_1_BLACK_Layer_TouchArea_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#DEV__SYSTEM_DISPLAY_TEST_1_BLACK")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_1_BLACK_Layer_TouchArea_Next_ButtonWidget_enRelease, 0x39D316DA); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_10_GAMMA_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#DEV__SYSTEM_DISPLAY_TEST_10_GAMMA")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_10_GAMMA_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x687E51CB); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_9_MURA2_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#DEV__SYSTEM_DISPLAY_TEST_9_MURA2")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_9_MURA2_Layer_TouchArea_Back_ButtonWidget_enRelease, 0xDE8552E7); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_8_MURA1_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#DEV__SYSTEM_DISPLAY_TEST_8_MURA1")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_8_MURA1_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x89A72C95); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_7_FLICKER_2_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#DEV__SYSTEM_DISPLAY_TEST_7_FLICKER_2")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_7_FLICKER_2_Layer_TouchArea_Back_ButtonWidget_enRelease, 0xFB16D794); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_6_FLICKER_1_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#DEV__SYSTEM_DISPLAY_TEST_6_FLICKER_1")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_6_FLICKER_1_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x8963A13C); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_9_MURA2_Layer_TouchArea_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#DEV__SYSTEM_DISPLAY_TEST_9_MURA2")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_9_MURA2_Layer_TouchArea_Next_ButtonWidget_enRelease, 0x5D356D5D); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_WeatherBand")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Next_ButtonWidget_enRelease, 0x2F4EAFD3); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner1_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor")) && (message.GetSender() == ::Courier::Identifier(0xf2170da7 /* Textbox_Tuner1/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner1_ButtonWidget_enRelease, 0x115FC29E); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner2_Band_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor")) && (message.GetSender() == ::Courier::Identifier(0x016a8f1d /* Textbox_Tuner2_Band/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner2_Band_ButtonWidget_enRelease, 0x56626160); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_TestModeScreens_Layer_TouchArea_DAB_Btn_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_TestModeScreens")) && (message.GetSender() == ::Courier::Identifier(0xf5dd8688 /* Layer_TouchArea_DAB_Btn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_TestModeScreens_Layer_TouchArea_DAB_Btn_ButtonWidget_enRelease, 0x1471F98C); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_TestModeScreens_Layer_TouchArea_FM_Btn_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_TestModeScreens")) && (message.GetSender() == ::Courier::Identifier(0x390925ef /* Layer_TouchArea_FM_Btn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_TestModeScreens_Layer_TouchArea_FM_Btn_ButtonWidget_enRelease, 0xB3EB5A6D); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_TestModeScreens_Button_Back_BG_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_TestModeScreens")) && (message.GetSender() == ::Courier::Identifier(0x408b82c4 /* Button_Back_BG/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_TestModeScreens_Button_Back_BG_ButtonWidget_enRelease, 0x6B71A1A3); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_SXM_Channel_List_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_SXM_Channel_List")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_SXM_Channel_List_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x03350E6E); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_18_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_SXM")) && (message.GetSender() == ::Courier::Identifier(0xa54b691f /* Layer_TouchArea_Preset_18/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_18_ButtonWidget_enRelease, 0xD2A28045); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_17_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_SXM")) && (message.GetSender() == ::Courier::Identifier(0x31f4a241 /* Layer_TouchArea_Preset_17/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_17_ButtonWidget_enRelease, 0x7D7C8C99); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_16_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_SXM")) && (message.GetSender() == ::Courier::Identifier(0xcaa987b5 /* Layer_TouchArea_Preset_16/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_16_ButtonWidget_enRelease, 0x56B5AAFF); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_15_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_SXM")) && (message.GetSender() == ::Courier::Identifier(0xf85ad481 /* Layer_TouchArea_Preset_15/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_15_ButtonWidget_enRelease, 0xB7BD8F6E); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_14_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_SXM")) && (message.GetSender() == ::Courier::Identifier(0x81eeddb1 /* Layer_TouchArea_Preset_14/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_14_ButtonWidget_enRelease, 0xF3619AD0); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_13_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_SXM")) && (message.GetSender() == ::Courier::Identifier(0x987ecd26 /* Layer_TouchArea_Preset_13/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_13_ButtonWidget_enRelease, 0x6AFC2DE4); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_12_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_SXM")) && (message.GetSender() == ::Courier::Identifier(0xf3c138d5 /* Layer_TouchArea_Preset_12/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_12_ButtonWidget_enRelease, 0x045E9E09); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_11_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_SXM")) && (message.GetSender() == ::Courier::Identifier(0x582a8787 /* Layer_TouchArea_Preset_11/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_11_ButtonWidget_enRelease, 0x617A315F); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_10_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_SXM")) && (message.GetSender() == ::Courier::Identifier(0xb9da2cf8 /* Layer_TouchArea_Preset_10/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_10_ButtonWidget_enRelease, 0x89FEA5FB); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_9_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_SXM")) && (message.GetSender() == ::Courier::Identifier(0xc48d7eaa /* Layer_TouchArea_Preset_9/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_9_ButtonWidget_enRelease, 0xCD8C9774); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_8_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_SXM")) && (message.GetSender() == ::Courier::Identifier(0x84fb073a /* Layer_TouchArea_Preset_8/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_8_ButtonWidget_enRelease, 0x7A08A610); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_7_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_SXM")) && (message.GetSender() == ::Courier::Identifier(0xf4b7f014 /* Layer_TouchArea_Preset_7/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_7_ButtonWidget_enRelease, 0x69FDE15A); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_6_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_SXM")) && (message.GetSender() == ::Courier::Identifier(0xad746719 /* Layer_TouchArea_Preset_6/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_6_ButtonWidget_enRelease, 0x5463E1B3); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_5_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_SXM")) && (message.GetSender() == ::Courier::Identifier(0xd80bf0d5 /* Layer_TouchArea_Preset_5/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_5_ButtonWidget_enRelease, 0x2576DED4); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_4_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_SXM")) && (message.GetSender() == ::Courier::Identifier(0x378f839d /* Layer_TouchArea_Preset_4/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_4_ButtonWidget_enRelease, 0xB9FBFF04); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_3_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_SXM")) && (message.GetSender() == ::Courier::Identifier(0xaaaa6541 /* Layer_TouchArea_Preset_3/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_3_ButtonWidget_enRelease, 0x349510D4); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_2_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_SXM")) && (message.GetSender() == ::Courier::Identifier(0x966c3b3e /* Layer_TouchArea_Preset_2/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_2_ButtonWidget_enRelease, 0x4DCA9566); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_1_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_SXM")) && (message.GetSender() == ::Courier::Identifier(0x5e7e68f4 /* Layer_TouchArea_Preset_1/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_1_ButtonWidget_enRelease, 0x4859EF4C); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Monitor_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_SXM")) && (message.GetSender() == ::Courier::Identifier(0x11a0a8b0 /* Layer_TouchArea_Monitor/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Monitor_ButtonWidget_enRelease, 0x8C83F112); return true; }
#endif
#ifdef ev_HealthCareMntrDCT_YesTouch
    if ((message.GetView() == ::Courier::ViewId("Testmode#Popup#Pfo_HealthCareMntr_DiagCtnrlTrouble")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_HealthCareMntrDCT_YesTouch, 0xDA0C89D0); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_SXM_Icon_SxmList_Button_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_SXM")) && (message.GetSender() == ::Courier::Identifier(0x935913fe /* Icon_SxmList/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_SXM_Icon_SxmList_Button_enRelease, 0x903F6A9F); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Source_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_SXM")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Source_ButtonWidget_enRelease, 0x62EB9429); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_TestModeScreens_Layer_TouchArea_SXM_Btn_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_TestModeScreens")) && (message.GetSender() == ::Courier::Identifier(0xf99d48fd /* Layer_TouchArea_SXM_Btn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_TestModeScreens_Layer_TouchArea_SXM_Btn_ButtonWidget_enRelease, 0xBBF71A4E); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_TestModeScreens_Layer_TouchArea_WeatherBand_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_TestModeScreens")) && (message.GetSender() == ::Courier::Identifier(0xe9dcabfb /* Layer_TouchArea_WeatherBand/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_TestModeScreens_Layer_TouchArea_WeatherBand_ButtonWidget_enRelease, 0xABFA03E9); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_TestModeScreens_Layer_TouchArea_TMC_Btn_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_TestModeScreens")) && (message.GetSender() == ::Courier::Identifier(0xb4415f2b /* Layer_TouchArea_TMC_Btn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_TestModeScreens_Layer_TouchArea_TMC_Btn_ButtonWidget_enRelease, 0x9FD3B3E5); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_TestmodeSourceSelection_Layer_TouchArea_Phone_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_TestmodeSourceSelection")) && (message.GetSender() == ::Courier::Identifier(0x2a89b8ac /* Layer_TouchArea_Phone/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_TestmodeSourceSelection_Layer_TouchArea_Phone_ButtonWidget_enRelease, 0x862E5E66); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_TestmodeSourceSelection_Layer_TouchArea_Tuner_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_TestmodeSourceSelection")) && (message.GetSender() == ::Courier::Identifier(0xabf3682e /* Layer_TouchArea_Tuner/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_TestmodeSourceSelection_Layer_TouchArea_Tuner_ButtonWidget_enRelease, 0x65BE3F65); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner1_Band_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor")) && (message.GetSender() == ::Courier::Identifier(0xe83731d1 /* Textbox_Tuner1_Band/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner1_Band_ButtonWidget_enRelease, 0x12DFEE8E); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Seekup_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor")) && (message.GetSender() == ::Courier::Identifier(0xc732cea4 /* Layer_TouchArea_Seekup/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Seekup_ButtonWidget_enRelease, 0x74D209F7); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Seekdn_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor")) && (message.GetSender() == ::Courier::Identifier(0x3ca8043c /* Layer_TouchArea_Seekdn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Seekdn_ButtonWidget_enRelease, 0xA768E5F8); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Stepdown_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor")) && (message.GetSender() == ::Courier::Identifier(0x704386f1 /* Layer_TouchArea_Stepdown/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Stepdown_ButtonWidget_enRelease, 0xF72B0BBB); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Stepup_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor")) && (message.GetSender() == ::Courier::Identifier(0x4817fece /* Layer_TouchArea_Stepup/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Stepup_ButtonWidget_enRelease, 0xAC681D7B); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Next_ButtonWidget_enRelease, 0xF639E057); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Back_ButtonWidget_enRelease, 0xA5A4C403); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_TestMode_Button_Back_BG_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_TestMode")) && (message.GetSender() == ::Courier::Identifier(0x408b82c4 /* Button_Back_BG/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_TestMode_Button_Back_BG_ButtonWidget_enRelease, 0x5E5E8D24); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_ButtonToggle_PhaseDiversity_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_MonitorTestMode")) && (message.GetSender() == ::Courier::Identifier(0x20afa82d /* ButtonToggle_PhaseDiversity/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_ButtonToggle_PhaseDiversity_ButtonWidget2D_enRelease, 0x96CC66CF); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_Btn_Highcut_Dec_Button_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_MonitorTestMode")) && (message.GetSender() == ::Courier::Identifier(0x34dec3af /* Btn_Highcut_Dec/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_Btn_Highcut_Dec_Button_enRelease, 0x95074CB0); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_Btn_Highcut_Inc_Button_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_MonitorTestMode")) && (message.GetSender() == ::Courier::Identifier(0x52c2d123 /* Btn_Highcut_Inc/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_Btn_Highcut_Inc_Button_enRelease, 0x9F2E6283); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_Btn_Sharx_Dec_Button_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_MonitorTestMode")) && (message.GetSender() == ::Courier::Identifier(0x4726bc2f /* Btn_Sharx_Dec/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_Btn_Sharx_Dec_Button_enRelease, 0x4F375943); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_Btn_Sharx_Inc_Button_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_MonitorTestMode")) && (message.GetSender() == ::Courier::Identifier(0xff2f1012 /* Btn_Sharx_Inc/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_Btn_Sharx_Inc_Button_enRelease, 0xE17DC750); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner3_Band_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_Triple_Tuner_Monitor")) && (message.GetSender() == ::Courier::Identifier(0xc5610203 /* Textbox_Tuner3_Band/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner3_Band_ButtonWidget_enRelease, 0xDC71517D); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_ButtonToggle_RDS_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_MonitorTestMode")) && (message.GetSender() == ::Courier::Identifier(0x9536f980 /* ButtonToggle_RDS/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_ButtonToggle_RDS_ButtonWidget2D_enRelease, 0xFCBB13CC); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_ButtonToggle_TAStatus_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_MonitorTestMode")) && (message.GetSender() == ::Courier::Identifier(0x8c94ae00 /* ButtonToggle_TAStatus/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_ButtonToggle_TAStatus_ButtonWidget2D_enRelease, 0xACAB7512); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_ButtonToggle_AF_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_MonitorTestMode")) && (message.GetSender() == ::Courier::Identifier(0xf0689a7e /* ButtonToggle_AF/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_ButtonToggle_AF_ButtonWidget2D_enRelease, 0xEB87FE85); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_Layer_TouchArea_Next_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_MonitorTestMode")) && (message.GetSender() == ::Courier::Identifier(0x4e7f0732 /* Layer_TouchArea_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_Layer_TouchArea_Next_ButtonWidget_enRelease, 0xAD459C05); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_MonitorTestMode")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x0811EDBC); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_DEV__TESTMODE_AUDIO_ButtonToggle_LinearAudio_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#DEV__TESTMODE_AUDIO")) && (message.GetSender() == ::Courier::Identifier(0x62e9de14 /* ButtonToggle_LinearAudio/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_DEV__TESTMODE_AUDIO_ButtonToggle_LinearAudio_ButtonWidget2D_enRelease, 0xCD7C642F); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_DEV__TESTMODE_AUDIO_ButtonToggle_FMEnhancer_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#DEV__TESTMODE_AUDIO")) && (message.GetSender() == ::Courier::Identifier(0x3442b483 /* ButtonToggle_FMEnhancer/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_DEV__TESTMODE_AUDIO_ButtonToggle_FMEnhancer_ButtonWidget2D_enRelease, 0x70120E94); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_DEV__TESTMODE_PHONE_Layer_TouchArea_back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#DEV__TESTMODE_PHONE")) && (message.GetSender() == ::Courier::Identifier(0x0d1b3aec /* Layer_TouchArea_back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_DEV__TESTMODE_PHONE_Layer_TouchArea_back_ButtonWidget_enRelease, 0xA6F431E6); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_DEV__TESTMODE_AUDIO_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#DEV__TESTMODE_AUDIO")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_DEV__TESTMODE_AUDIO_Layer_TouchArea_Back_ButtonWidget_enRelease, 0xDBA16C63); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_TestmodeSourceSelection_Layer_TouchArea_SystemSettings_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_TestmodeSourceSelection")) && (message.GetSender() == ::Courier::Identifier(0x763cb20e /* Layer_TouchArea_SystemSettings/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_TestmodeSourceSelection_Layer_TouchArea_SystemSettings_ButtonWidget_enRelease, 0xCEE62BFA); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_TestmodeSourceSelection_Layer_TouchArea_Source_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_TestmodeSourceSelection")) && (message.GetSender() == ::Courier::Identifier(0xccdf81cf /* Layer_TouchArea_Source/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_TestmodeSourceSelection_Layer_TouchArea_Source_ButtonWidget_enRelease, 0x2AD940C1); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_TestmodeSourceSelection_Layer_TouchArea_AudioSettings_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_TestmodeSourceSelection")) && (message.GetSender() == ::Courier::Identifier(0x2cfa2a8d /* Layer_TouchArea_AudioSettings/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_TestmodeSourceSelection_Layer_TouchArea_AudioSettings_ButtonWidget_enRelease, 0x0C954F31); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_TestmodeSourceSelection_Layer_TouchArea_DisplaySettings_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_TestmodeSourceSelection")) && (message.GetSender() == ::Courier::Identifier(0xbb58b3bf /* Layer_TouchArea_DisplaySettings/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_TestmodeSourceSelection_Layer_TouchArea_DisplaySettings_ButtonWidget_enRelease, 0x862B9C1B); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_TestmodeSourceSelection_Layer_TouchArea_RVC_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_TestmodeSourceSelection")) && (message.GetSender() == ::Courier::Identifier(0x1a7349e6 /* Layer_TouchArea_RVC/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_TestmodeSourceSelection_Layer_TouchArea_RVC_ButtonWidget_enRelease, 0x4A52E14E); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_ButtonToggle_Measure_Mode_ButtonWidget2D_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#R_FM_MonitorTestMode")) && (message.GetSender() == ::Courier::Identifier(0xe5a0b179 /* ButtonToggle_Measure_Mode/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_ButtonToggle_Measure_Mode_ButtonWidget2D_enRelease, 0xBB11A23D); return true; }
#endif
#ifdef OnButtonReactionMsg_Testmode_Scenes_SystemSettingTestMode_Layer_TouchArea_Back_ButtonWidget_enRelease
    if ((message.GetView() == ::Courier::ViewId("Testmode#Scenes#SystemSettingTestMode")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(OnButtonReactionMsg_Testmode_Scenes_SystemSettingTestMode_Layer_TouchArea_Back_ButtonWidget_enRelease, 0x1C5EE1A6); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForButtonReactionMsg(AppHmi_TestmodeStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ButtonReactionMsg const & message = static_cast< ::ButtonReactionMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_TestmodeStateMachineImpl::VS_Ret_Ok, AppHmi_TestmodeStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForShutdownMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnShutdownMsg, 0x756C0DF3);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForShutdownMsg(AppHmi_TestmodeStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_TestmodeStateMachineImpl::VS_Ret_Ok, AppHmi_TestmodeStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onCenterPopupSurfaceInvisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onCenterPopupSurfaceInvisible 0xffff
#pragma _REMINDER("Using dummy value symbol onCenterPopupSurfaceInvisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onCenterPopupSurfaceInvisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onCenterPopupSurfaceVisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onCenterPopupSurfaceVisible 0xffff
#pragma _REMINDER("Using dummy value symbol onCenterPopupSurfaceVisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onCenterPopupSurfaceVisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onCenterPopupSurfaceUnqueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onCenterPopupSurfaceUnqueued 0xffff
#pragma _REMINDER("Using dummy value symbol onCenterPopupSurfaceUnqueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onCenterPopupSurfaceUnqueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onCenterPopupSurfaceQueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onCenterPopupSurfaceQueued 0xffff
#pragma _REMINDER("Using dummy value symbol onCenterPopupSurfaceQueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onCenterPopupSurfaceQueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onPopupVisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupVisible 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupVisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupVisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onPopupUnqueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupUnqueued 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupUnqueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupUnqueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onPopupQueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupQueued 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupQueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupQueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForSurfaceStateChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);

#ifdef onCenterPopupSurfaceInvisible
    if ((message.GetSurfaceId() == SURFACEID_CENTER_POPUP_SURFACE_TESTMODE) && (message.GetState() == SURFACESTATE_INVISIBLE)) { eventId = CIT_EVENT_ID(onCenterPopupSurfaceInvisible, 0x9BDB722F); return true; }
#endif
#ifdef onCenterPopupSurfaceVisible
    if ((message.GetSurfaceId() == SURFACEID_CENTER_POPUP_SURFACE_TESTMODE) && (message.GetState() == SURFACESTATE_VISIBLE)) { eventId = CIT_EVENT_ID(onCenterPopupSurfaceVisible, 0x23B97E51); return true; }
#endif
#ifdef onCenterPopupSurfaceUnqueued
    if ((message.GetSurfaceId() == SURFACEID_CENTER_POPUP_SURFACE_TESTMODE) && (message.GetState() == SURFACESTATE_UNQUEUED)) { eventId = CIT_EVENT_ID(onCenterPopupSurfaceUnqueued, 0xAA79C7DD); return true; }
#endif
#ifdef onCenterPopupSurfaceQueued
    if ((message.GetSurfaceId() == SURFACEID_CENTER_POPUP_SURFACE_TESTMODE) && (message.GetState() == SURFACESTATE_QUEUED)) { eventId = CIT_EVENT_ID(onCenterPopupSurfaceQueued, 0xFC0D2293); return true; }
#endif
#ifdef onPopupVisible
    if ((message.GetState() == SURFACESTATE_VISIBLE)) { eventId = CIT_EVENT_ID(onPopupVisible, 0xB78D7AE0); return true; }
#endif
#ifdef onPopupUnqueued
    if ((message.GetState() == SURFACESTATE_UNQUEUED)) { eventId = CIT_EVENT_ID(onPopupUnqueued, 0xDB0D29F4); return true; }
#endif
#ifdef onPopupQueued
    if ((message.GetState() == SURFACESTATE_QUEUED)) { eventId = CIT_EVENT_ID(onPopupQueued, 0xBBE6896C); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSurfaceStateChangedUpdMsg(AppHmi_TestmodeStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
#ifdef onCenterPopupSurfaceInvisible
    if (eventId == onCenterPopupSurfaceInvisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_TestmodeStateMachineImpl::VS_Ret_Ok, AppHmi_TestmodeStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onCenterPopupSurfaceInvisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onCenterPopupSurfaceVisible
    if (eventId == onCenterPopupSurfaceVisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_TestmodeStateMachineImpl::VS_Ret_Ok, AppHmi_TestmodeStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onCenterPopupSurfaceVisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onCenterPopupSurfaceUnqueued
    if (eventId == onCenterPopupSurfaceUnqueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_TestmodeStateMachineImpl::VS_Ret_Ok, AppHmi_TestmodeStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onCenterPopupSurfaceUnqueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onCenterPopupSurfaceQueued
    if (eventId == onCenterPopupSurfaceQueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_TestmodeStateMachineImpl::VS_Ret_Ok, AppHmi_TestmodeStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onCenterPopupSurfaceQueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onPopupVisible
    if (eventId == onPopupVisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_TestmodeStateMachineImpl::VS_Ret_Ok, AppHmi_TestmodeStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupVisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onPopupUnqueued
    if (eventId == onPopupUnqueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_TestmodeStateMachineImpl::VS_Ret_Ok, AppHmi_TestmodeStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupUnqueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onPopupQueued
    if (eventId == onPopupQueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_TestmodeStateMachineImpl::VS_Ret_Ok, AppHmi_TestmodeStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupQueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_TestmodeStateMachineImpl::VS_Ret_Ok, AppHmi_TestmodeStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForOpen_Settings_Screen(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnOpen_Settings_Screen, 0xDA21E229);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForOpen_Settings_Screen(AppHmi_TestmodeStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_TestmodeStateMachineImpl::VS_Ret_Ok, AppHmi_TestmodeStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForPopup_PFO_TriggerSystemSetting(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(OnPopup_PFO_TriggerSystemSetting, 0x87A36B26);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForPopup_PFO_TriggerSystemSetting(AppHmi_TestmodeStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_TestmodeStateMachineImpl::VS_Ret_Ok, AppHmi_TestmodeStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onEncoderStatusChanged_RIGHT_ENC
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onEncoderStatusChanged_RIGHT_ENC 0xffff
#pragma _REMINDER("Using dummy value symbol onEncoderStatusChanged_RIGHT_ENC ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onEncoderStatusChanged_RIGHT_ENC -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForEncoderStatusChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::EncoderStatusChangedUpdMsg const & message = static_cast< ::EncoderStatusChangedUpdMsg const &>(aMessage);

#ifdef onEncoderStatusChanged_RIGHT_ENC
    if ((message.GetEncCode() == ENCCODE_RIGHT_ENCODER)) { eventId = CIT_EVENT_ID(onEncoderStatusChanged_RIGHT_ENC, 0x67E5D82B); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForEncoderStatusChangedUpdMsg(AppHmi_TestmodeStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::EncoderStatusChangedUpdMsg const & message = static_cast< ::EncoderStatusChangedUpdMsg const &>(aMessage);
#ifdef onEncoderStatusChanged_RIGHT_ENC
    if (eventId == onEncoderStatusChanged_RIGHT_ENC) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_TestmodeStateMachineImpl::VS_Ret_Ok, AppHmi_TestmodeStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetEncSteps()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onEncoderStatusChanged_RIGHT_ENC.EncSteps = message.GetEncSteps();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_TestmodeStateMachineImpl::VS_Ret_Ok, AppHmi_TestmodeStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForHKStatusChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::HKStatusChangedUpdMsg const & message = static_cast< ::HKStatusChangedUpdMsg const &>(aMessage);

#ifdef onHKStatusChanged_HK_SELECT_UP
    if ((message.GetHKCode() == HARDKEYCODE_HK_SELECT) && (message.GetHKState() == HARDKEYSTATE_UP)) { eventId = CIT_EVENT_ID(onHKStatusChanged_HK_SELECT_UP, 0x263EAF7F); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForHKStatusChangedUpdMsg(AppHmi_TestmodeStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::HKStatusChangedUpdMsg const & message = static_cast< ::HKStatusChangedUpdMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_TestmodeStateMachineImpl::VS_Ret_Ok, AppHmi_TestmodeStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onPopupTimerExpiry
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupTimerExpiry 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupTimerExpiry ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupTimerExpiry -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForExpiredPopupTimerResMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onPopupTimerExpiry, 0xF3C96D17);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForExpiredPopupTimerResMsg(AppHmi_TestmodeStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ExpiredPopupTimerResMsg const & message = static_cast< ::ExpiredPopupTimerResMsg const &>(aMessage);
#ifdef onPopupTimerExpiry
    if (eventId == onPopupTimerExpiry) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_TestmodeStateMachineImpl::VS_Ret_Ok, AppHmi_TestmodeStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetViewId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupTimerExpiry.ViewId = message.GetViewId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_TestmodeStateMachineImpl::VS_Ret_Ok, AppHmi_TestmodeStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onActivateImageProviderRequest
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onActivateImageProviderRequest 0xffff
#pragma _REMINDER("Using dummy value symbol onActivateImageProviderRequest ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onActivateImageProviderRequest -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onDeactivateImageProviderRequest
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onDeactivateImageProviderRequest 0xffff
#pragma _REMINDER("Using dummy value symbol onDeactivateImageProviderRequest ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onDeactivateImageProviderRequest -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForActivateImageProviderReqMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);

#ifdef onActivateImageProviderRequest
    if ((message.GetActivate() == 1)) { eventId = CIT_EVENT_ID(onActivateImageProviderRequest, 0xDD62EA5B); return true; }
#endif
#ifdef onDeactivateImageProviderRequest
    if ((message.GetActivate() == 0)) { eventId = CIT_EVENT_ID(onDeactivateImageProviderRequest, 0x9FE98C1E); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateImageProviderReqMsg(AppHmi_TestmodeStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);
#ifdef onActivateImageProviderRequest
    if (eventId == onActivateImageProviderRequest) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_TestmodeStateMachineImpl::VS_Ret_Ok, AppHmi_TestmodeStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetInstanceId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onActivateImageProviderRequest.InstanceId = message.GetInstanceId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onDeactivateImageProviderRequest
    if (eventId == onDeactivateImageProviderRequest) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_TestmodeStateMachineImpl::VS_Ret_Ok, AppHmi_TestmodeStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetInstanceId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onDeactivateImageProviderRequest.InstanceId = message.GetInstanceId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_TestmodeStateMachineImpl::VS_Ret_Ok, AppHmi_TestmodeStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForHMISubStateChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::HMISubStateChangedUpdMsg const & message = static_cast< ::HMISubStateChangedUpdMsg const &>(aMessage);

#ifdef onHMISubStateChanged_ON
    if ((message.GetSubState() == HMISTATE_SHOW_HMI)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_ON, 0x76CF2B88); return true; }
#endif
#ifdef onHMISubStateChanged_CLOCK
    if ((message.GetSubState() == HMISTATE_SHOW_CLOCK)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_CLOCK, 0xF96478DC); return true; }
#endif
#ifdef onHMISubStateChanged_OFF
    if ((message.GetSubState() == HMISTATE_SHOW_OFF)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_OFF, 0x776D7D8A); return true; }
#endif
#ifdef onHMISubStateChanged_STANDBY_RESTRICTED
    if ((message.GetSubState() == HMISTATE_STANDBY_RESTRICTED)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_STANDBY_RESTRICTED, 0xA15C3CEE); return true; }
#endif
#ifdef onHMISubStateChanged_STANDBY
    if ((message.GetSubState() == HMISTATE_STANDBY)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_STANDBY, 0x0D0F5602); return true; }
#endif
#ifdef onHMISubStateChanged_PHONE
    if ((message.GetSubState() == HMISTATE_PHONE)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_PHONE, 0xC8D83B8B); return true; }
#endif
#ifdef onHMISubStateChanged_NO_DISPLAY
    if ((message.GetSubState() == HMISTATE_SHOW_NO_DISPLAY)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_NO_DISPLAY, 0xE4658CFD); return true; }
#endif
#ifdef onHMISubStateChanged_SECURE
    if ((message.GetSubState() == HMISTATE_SECURE)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_SECURE, 0xAB89D7A8); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForHMISubStateChangedUpdMsg(AppHmi_TestmodeStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::HMISubStateChangedUpdMsg const & message = static_cast< ::HMISubStateChangedUpdMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_TestmodeStateMachineImpl::VS_Ret_Ok, AppHmi_TestmodeStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForApplicationStateUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::ApplicationStateUpdMsg const & message = static_cast< ::ApplicationStateUpdMsg const &>(aMessage);

#ifdef onAppStatusChanged_FOREGROUND
    if ((message.GetState() == hmibase::IN_FOREGROUND)) { eventId = CIT_EVENT_ID(onAppStatusChanged_FOREGROUND, 0xDE9448E3); return true; }
#endif
#ifdef onAppStatusChanged_BACKGROUND
    if ((message.GetState() == hmibase::IN_BACKGROUND)) { eventId = CIT_EVENT_ID(onAppStatusChanged_BACKGROUND, 0x6D1B3A68); return true; }
#endif
#ifdef onAppStatusPrepare_BACKGROUND
    if ((message.GetState() == hmibase::TO_BACKGROUND)) { eventId = CIT_EVENT_ID(onAppStatusPrepare_BACKGROUND, 0x4C8518AE); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForApplicationStateUpdMsg(AppHmi_TestmodeStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ApplicationStateUpdMsg const & message = static_cast< ::ApplicationStateUpdMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_TestmodeStateMachineImpl::VS_Ret_Ok, AppHmi_TestmodeStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onSubSurfaceUpdMsgChanged_FOREGROUND
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSubSurfaceUpdMsgChanged_FOREGROUND 0xffff
#pragma _REMINDER("Using dummy value symbol onSubSurfaceUpdMsgChanged_FOREGROUND ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSubSurfaceUpdMsgChanged_FOREGROUND -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onSubSurfaceUpdMsgChanged_BACKGROUND
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSubSurfaceUpdMsgChanged_BACKGROUND 0xffff
#pragma _REMINDER("Using dummy value symbol onSubSurfaceUpdMsgChanged_BACKGROUND ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSubSurfaceUpdMsgChanged_BACKGROUND -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForSubSurfaceUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);

#ifdef onSubSurfaceUpdMsgChanged_FOREGROUND
    if ((message.GetState() == hmibase::IN_FOREGROUND)) { eventId = CIT_EVENT_ID(onSubSurfaceUpdMsgChanged_FOREGROUND, 0x9D4DF4FC); return true; }
#endif
#ifdef onSubSurfaceUpdMsgChanged_BACKGROUND
    if ((message.GetState() == hmibase::IN_BACKGROUND)) { eventId = CIT_EVENT_ID(onSubSurfaceUpdMsgChanged_BACKGROUND, 0x5790D8C1); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSubSurfaceUpdMsg(AppHmi_TestmodeStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);
#ifdef onSubSurfaceUpdMsgChanged_FOREGROUND
    if (eventId == onSubSurfaceUpdMsgChanged_FOREGROUND) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_TestmodeStateMachineImpl::VS_Ret_Ok, AppHmi_TestmodeStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetDisplayRegion(), message.GetDisplayID()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_FOREGROUND.DisplayRegion = message.GetDisplayRegion();
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_FOREGROUND.DisplayID = message.GetDisplayID();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onSubSurfaceUpdMsgChanged_BACKGROUND
    if (eventId == onSubSurfaceUpdMsgChanged_BACKGROUND) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_TestmodeStateMachineImpl::VS_Ret_Ok, AppHmi_TestmodeStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetDisplayRegion(), message.GetDisplayID()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_BACKGROUND.DisplayRegion = message.GetDisplayRegion();
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_BACKGROUND.DisplayID = message.GetDisplayID();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_TestmodeStateMachineImpl::VS_Ret_Ok, AppHmi_TestmodeStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForTransitionIndMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::Courier::TransitionIndMsg const & message = static_cast< ::Courier::TransitionIndMsg const &>(aMessage);

#ifdef OnNextLevelTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("NextLevelTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnNextLevelTransitionFinished, 0xE7DCE080); return true; }
#endif
#ifdef OnPreviousLevelTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("PreviousLevelTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPreviousLevelTransitionFinished, 0x26C30D04); return true; }
#endif
#ifdef OnPageFlipBackFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipBackTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipBackFinished, 0x74F534EE); return true; }
#endif
#ifdef OnPageFlipFrontFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipFrontTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipFrontFinished, 0x437D9EFE); return true; }
#endif
#ifdef OnZoomInFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("ZoomInTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnZoomInFinished, 0xFBEEA58F); return true; }
#endif
#ifdef OnZoomOutFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("ZoomOutTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnZoomOutFinished, 0xF84B3BD1); return true; }
#endif
#ifdef OnFadeAnimationFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("FadeTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnFadeAnimationFinished, 0xE9A6D56C); return true; }
#endif
#ifdef OnDualViewLeftTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("DualViewLeftTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnDualViewLeftTransitionFinished, 0x403A65A4); return true; }
#endif
#ifdef OnDualViewRightTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("DualViewRightTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnDualViewRightTransitionFinished, 0x50B4DCCA); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForTransitionIndMsg(AppHmi_TestmodeStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::Courier::TransitionIndMsg const & message = static_cast< ::Courier::TransitionIndMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_TestmodeStateMachineImpl::VS_Ret_Ok, AppHmi_TestmodeStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
struct EventMapping
{
    ::FeatStd::UInt32 mHashId;
    bool (*mEventCallHandler)(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId);
};

struct EventDeductionMapping
{
    ::FeatStd::UInt32 mHashId;
    ::Cit::DeductResult::Enum (*mEventCallHandler)(AppHmi_TestmodeStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId);
};

static ::FeatStd::Int EventMappingCmp(::FeatStd::UInt32 hash, const EventMapping& em)
{
    return (hash == em.mHashId) ? 0 : ((hash < em.mHashId) ? -1 : 1);
}

static ::FeatStd::Int EventDeductionMappingCmp(::FeatStd::UInt32 hash, const EventDeductionMapping& em)
{
    return (hash == em.mHashId) ? 0 : ((hash < em.mHashId) ? -1 : 1);
}

bool AppHmi_TestmodeStateMachineImpl::HandleEventMapping(::Courier::Message const & message, ::FeatStd::UInt32& eventId) const
{
    static EventMapping events[13] = {
        { 0x04B8AFB9, HandleEventMappingForHKStatusChangedUpdMsg },
        { 0x3824FE1D, HandleEventMappingForApplicationStateUpdMsg },
        { 0x3D97BCE1, HandleEventMappingForOpen_Settings_Screen },
        { 0x4A69141E, HandleEventMappingForHMISubStateChangedUpdMsg },
        { 0x4FF79763, HandleEventMappingForEncoderStatusChangedUpdMsg },
        { 0x69FAC6F1, HandleEventMappingForSubSurfaceUpdMsg },
        { 0x6AE0FD3C, HandleEventMappingForButtonReactionMsg },
        { 0x91BA6F30, HandleEventMappingForPopup_PFO_TriggerSystemSetting },
        { 0xA60CB9F4, HandleEventMappingForShutdownMsg },
        { 0xAE3CAAA7, HandleEventMappingForExpiredPopupTimerResMsg },
        { 0xC613E40C, HandleEventMappingForActivateImageProviderReqMsg },
        { 0xC7B455FB, HandleEventMappingForTransitionIndMsg },
        { 0xE2F61D55, HandleEventMappingForSurfaceStateChangedUpdMsg },
    };
    ::FeatStd::UInt32 hashId = message.GetId();
    const EventMapping* eventEntry = ::Courier::BinarySearch(hashId, events, 13, &EventMappingCmp);
    if (eventEntry && (hashId == eventEntry->mHashId)) {
        return eventEntry->mEventCallHandler(message, eventId);
    }
    return false;
}

// ------------------------------------------------------------------------
::Cit::DeductResult::Enum AppHmi_TestmodeStateMachineImpl::DeductEvent(::Courier::Message const & aMessage, ::FeatStd::UInt32 eventId)
{
    ::Cit::DeductResult::Enum deductResult = Cit::DeductResult::DeductOk;
    static EventDeductionMapping events[13] = {
        { 0x04B8AFB9, HandleEventDeductionForHKStatusChangedUpdMsg },
        { 0x3824FE1D, HandleEventDeductionForApplicationStateUpdMsg },
        { 0x3D97BCE1, HandleEventDeductionForOpen_Settings_Screen },
        { 0x4A69141E, HandleEventDeductionForHMISubStateChangedUpdMsg },
        { 0x4FF79763, HandleEventDeductionForEncoderStatusChangedUpdMsg },
        { 0x69FAC6F1, HandleEventDeductionForSubSurfaceUpdMsg },
        { 0x6AE0FD3C, HandleEventDeductionForButtonReactionMsg },
        { 0x91BA6F30, HandleEventDeductionForPopup_PFO_TriggerSystemSetting },
        { 0xA60CB9F4, HandleEventDeductionForShutdownMsg },
        { 0xAE3CAAA7, HandleEventDeductionForExpiredPopupTimerResMsg },
        { 0xC613E40C, HandleEventDeductionForActivateImageProviderReqMsg },
        { 0xC7B455FB, HandleEventDeductionForTransitionIndMsg },
        { 0xE2F61D55, HandleEventDeductionForSurfaceStateChangedUpdMsg },
    };
    ::FeatStd::UInt32 hashId = aMessage.GetId();
    const EventDeductionMapping* eventEntry = ::Courier::BinarySearch(hashId, events, 13, &EventDeductionMappingCmp);
    if (eventEntry && (hashId == eventEntry->mHashId)) {
        deductResult = eventEntry->mEventCallHandler(this, aMessage, eventId);
    }
    else {
        typedef Cit::Internal::VSDeductHelper<VS_Ret_Ok, AppHmi_TestmodeStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
        return VSDeductHelper::ProcessOutput(*this, (*this.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
        return VSDeductHelper::ProcessOutput(*this, (*this.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
    }
    return deductResult;
}

// ------------------------------------------------------------------------
bool AppHmi_TestmodeStateMachineImpl::HandleDataBindingEventMapping(::Courier::AbstractDataItemMsg const & /* message */, ::FeatStd::UInt32 & /* eventId */) const
{
    return false;
}

#ifdef CIT_SIMULATION
struct EventNameMapping
{
    ::FeatStd::UInt32 mEventId;
    const ::FeatStd::Char* mEventName;
    void (*mGetEventArguments)(::Courier::Message const & message, Json::Value& eventArguments);
};

static ::FeatStd::Int EventNameMappingCmp(::FeatStd::UInt32 eventId, const EventNameMapping& em)
{
    return (eventId == em.mEventId) ? 0 : ((eventId < em.mEventId) ? -1 : 1);
}

static void GetEventArgumentsForonCenterPopupSurfaceVisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonSubSurfaceUpdMsgChanged_BACKGROUND(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetDisplayRegion();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetDisplayID();
}

static void GetEventArgumentsForonEncoderStatusChanged_RIGHT_ENC(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::EncoderStatusChangedUpdMsg const & message = static_cast< ::EncoderStatusChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetEncSteps();
}

static void GetEventArgumentsForonCenterPopupSurfaceInvisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonSubSurfaceUpdMsgChanged_FOREGROUND(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetDisplayRegion();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetDisplayID();
}

static void GetEventArgumentsForonDeactivateImageProviderRequest(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetInstanceId();
}

static void GetEventArgumentsForonCenterPopupSurfaceUnqueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonPopupVisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonPopupQueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonPopupUnqueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonActivateImageProviderRequest(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetInstanceId();
}

static void GetEventArgumentsForonPopupTimerExpiry(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ExpiredPopupTimerResMsg const & message = static_cast< ::ExpiredPopupTimerResMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId();
}

static void GetEventArgumentsForonCenterPopupSurfaceQueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

const ::FeatStd::Char* AppHmi_TestmodeStateMachineImpl::GetEventName(::FeatStd::UInt32 eventId, ::Courier::Message const & message, Json::Value& eventArguments)
{
    static EventNameMapping events[162] = {
        { 0x0087BE7C, "OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_6_FLICKER_1_Layer_TouchArea_Next_ButtonWidget_enRelease", 0 },
        { 0x03350E6E, "OnButtonReactionMsg_Testmode_Scenes_R_SXM_Channel_List_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x045E9E09, "OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_12_ButtonWidget_enRelease", 0 },
        { 0x0811EDBC, "OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x0C954F31, "OnButtonReactionMsg_Testmode_Scenes_R_TestmodeSourceSelection_Layer_TouchArea_AudioSettings_ButtonWidget_enRelease", 0 },
        { 0x0D0F5602, "onHMISubStateChanged_STANDBY", 0 },
        { 0x102976C8, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Stepup_ButtonWidget_enRelease", 0 },
        { 0x115FC29E, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner1_ButtonWidget_enRelease", 0 },
        { 0x12DFEE8E, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner1_Band_ButtonWidget_enRelease", 0 },
        { 0x1471F98C, "OnButtonReactionMsg_Testmode_Scenes_R_TestModeScreens_Layer_TouchArea_DAB_Btn_ButtonWidget_enRelease", 0 },
        { 0x1576B11C, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Stepdown_ButtonWidget_enRelease", 0 },
        { 0x16756DF3, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner_AF_ButtonWidget_enRelease", 0 },
        { 0x1A93A999, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner3_Band_ButtonWidget_enRelease", 0 },
        { 0x1C5EE1A6, "OnButtonReactionMsg_Testmode_Scenes_SystemSettingTestMode_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x1CA16FA6, "OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_4_GREEN_Layer_TouchArea_Next_ButtonWidget_enRelease", 0 },
        { 0x1DC691D4, "OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_3_RED_Layer_TouchArea_Next_ButtonWidget_enRelease", 0 },
        { 0x1F8D9CB1, "OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_1_BLACK_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x21AED219, "OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_5_BLUE_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x23B97E51, "onCenterPopupSurfaceVisible", GetEventArgumentsForonCenterPopupSurfaceVisible },
        { 0x24BCE485, "OnButtonReactionMsg_Testmode_Scenes_R_TestMode_SXM_Monitor_List_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x2576DED4, "OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_5_ButtonWidget_enRelease", 0 },
        { 0x263EAF7F, "onHKStatusChanged_HK_SELECT_UP", 0 },
        { 0x26C30D04, "OnPreviousLevelTransitionFinished", 0 },
        { 0x2AD940C1, "OnButtonReactionMsg_Testmode_Scenes_R_TestmodeSourceSelection_Layer_TouchArea_Source_ButtonWidget_enRelease", 0 },
        { 0x2E3D8055, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x2F4EAFD3, "OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Next_ButtonWidget_enRelease", 0 },
        { 0x326442F5, "OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_4_GREEN_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x328EC81A, "OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Preset_6_ButtonWidget_enRelease", 0 },
        { 0x34306220, "OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Preset_1_ButtonWidget_enRelease", 0 },
        { 0x349510D4, "OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_3_ButtonWidget_enRelease", 0 },
        { 0x39D316DA, "OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_1_BLACK_Layer_TouchArea_Next_ButtonWidget_enRelease", 0 },
        { 0x3D8A42CD, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner2_Band_ButtonWidget_enRelease", 0 },
        { 0x403A65A4, "OnDualViewLeftTransitionFinished", 0 },
        { 0x437D9EFE, "OnPageFlipFrontFinished", 0 },
        { 0x4859EF4C, "OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_1_ButtonWidget_enRelease", 0 },
        { 0x4A52E14E, "OnButtonReactionMsg_Testmode_Scenes_R_TestmodeSourceSelection_Layer_TouchArea_RVC_ButtonWidget_enRelease", 0 },
        { 0x4AC3AB80, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner2_ButtonWidget_enRelease", 0 },
        { 0x4C8518AE, "onAppStatusPrepare_BACKGROUND", 0 },
        { 0x4DCA9566, "OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_2_ButtonWidget_enRelease", 0 },
        { 0x4DE01420, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Seekdn_ButtonWidget_enRelease", 0 },
        { 0x4F375943, "OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_Btn_Sharx_Dec_Button_enRelease", 0 },
        { 0x50B4DCCA, "OnDualViewRightTransitionFinished", 0 },
        { 0x5228DC79, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Stepdown_ButtonWidget_enRelease", 0 },
        { 0x5463E1B3, "OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_6_ButtonWidget_enRelease", 0 },
        { 0x56626160, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner2_Band_ButtonWidget_enRelease", 0 },
        { 0x56B5AAFF, "OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_16_ButtonWidget_enRelease", 0 },
        { 0x5790D8C1, "onSubSurfaceUpdMsgChanged_BACKGROUND", GetEventArgumentsForonSubSurfaceUpdMsgChanged_BACKGROUND },
        { 0x58AA4076, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner2_ButtonWidget_enRelease", 0 },
        { 0x5D088F21, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner3_ButtonWidget_enRelease", 0 },
        { 0x5D356D5D, "OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_9_MURA2_Layer_TouchArea_Next_ButtonWidget_enRelease", 0 },
        { 0x5E5E8D24, "OnButtonReactionMsg_Testmode_Scenes_R_FM_TestMode_Button_Back_BG_ButtonWidget_enRelease", 0 },
        { 0x617A315F, "OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_11_ButtonWidget_enRelease", 0 },
        { 0x628A6B9F, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Next_ButtonWidget_enRelease", 0 },
        { 0x62EB9429, "OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Source_ButtonWidget_enRelease", 0 },
        { 0x65BE3F65, "OnButtonReactionMsg_Testmode_Scenes_R_TestmodeSourceSelection_Layer_TouchArea_Tuner_ButtonWidget_enRelease", 0 },
        { 0x6692D656, "OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Preset_7_ButtonWidget_enRelease", 0 },
        { 0x67E5D82B, "onEncoderStatusChanged_RIGHT_ENC", GetEventArgumentsForonEncoderStatusChanged_RIGHT_ENC },
        { 0x687E51CB, "OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_10_GAMMA_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x69FDE15A, "OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_7_ButtonWidget_enRelease", 0 },
        { 0x6AFC2DE4, "OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_13_ButtonWidget_enRelease", 0 },
        { 0x6B71A1A3, "OnButtonReactionMsg_Testmode_Scenes_R_TestModeScreens_Button_Back_BG_ButtonWidget_enRelease", 0 },
        { 0x6D1B3A68, "onAppStatusChanged_BACKGROUND", 0 },
        { 0x6D4135C0, "OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Monitor_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x6D56F93A, "OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Preset_4_ButtonWidget_enRelease", 0 },
        { 0x6EAFBFE7, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner1_ButtonWidget_enRelease", 0 },
        { 0x70120E94, "OnButtonReactionMsg_Testmode_Scenes_DEV__TESTMODE_AUDIO_ButtonToggle_FMEnhancer_ButtonWidget2D_enRelease", 0 },
        { 0x74D209F7, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Seekup_ButtonWidget_enRelease", 0 },
        { 0x74F534EE, "OnPageFlipBackFinished", 0 },
        { 0x756C0DF3, "OnShutdownMsg", 0 },
        { 0x76CF2B88, "onHMISubStateChanged_ON", 0 },
        { 0x776D7D8A, "onHMISubStateChanged_OFF", 0 },
        { 0x785F9373, "OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Preset_9_ButtonWidget_enRelease", 0 },
        { 0x79ACFD50, "OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_3_RED_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x7A08A610, "OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_8_ButtonWidget_enRelease", 0 },
        { 0x7D7C8C99, "OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_17_ButtonWidget_enRelease", 0 },
        { 0x7EA740C0, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Stepup_ButtonWidget_enRelease", 0 },
        { 0x7EAFC2A9, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Seekdn_ButtonWidget_enRelease", 0 },
        { 0x7ECA4D84, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner2_ButtonWidget_enRelease", 0 },
        { 0x862B9C1B, "OnButtonReactionMsg_Testmode_Scenes_R_TestmodeSourceSelection_Layer_TouchArea_DisplaySettings_ButtonWidget_enRelease", 0 },
        { 0x862E5E66, "OnButtonReactionMsg_Testmode_Scenes_R_TestmodeSourceSelection_Layer_TouchArea_Phone_ButtonWidget_enRelease", 0 },
        { 0x87A36B26, "OnPopup_PFO_TriggerSystemSetting", 0 },
        { 0x8963A13C, "OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_6_FLICKER_1_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x89A72C95, "OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_8_MURA1_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x89FEA5FB, "OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_10_ButtonWidget_enRelease", 0 },
        { 0x8C83F112, "OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Monitor_ButtonWidget_enRelease", 0 },
        { 0x8DA1A379, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner1_Band_ButtonWidget_enRelease", 0 },
        { 0x903F6A9F, "OnButtonReactionMsg_Testmode_Scenes_R_SXM_Icon_SxmList_Button_enRelease", 0 },
        { 0x94B6D640, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner3_ButtonWidget_enRelease", 0 },
        { 0x95074CB0, "OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_Btn_Highcut_Dec_Button_enRelease", 0 },
        { 0x96053BF1, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner1_ButtonWidget_enRelease", 0 },
        { 0x964057A3, "OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_2_WHITE_Layer_TouchArea_Next_ButtonWidget_enRelease", 0 },
        { 0x96CC66CF, "OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_ButtonToggle_PhaseDiversity_ButtonWidget2D_enRelease", 0 },
        { 0x98C286E5, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Textbox_Tuner1_Band_ButtonWidget_enRelease", 0 },
        { 0x98DA1856, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner3_Band_ButtonWidget_enRelease", 0 },
        { 0x9BDB722F, "onCenterPopupSurfaceInvisible", GetEventArgumentsForonCenterPopupSurfaceInvisible },
        { 0x9C9BB731, "OnButtonReactionMsg_Testmode_Scenes_RVC_TESTMODE_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0x9D4DF4FC, "onSubSurfaceUpdMsgChanged_FOREGROUND", GetEventArgumentsForonSubSurfaceUpdMsgChanged_FOREGROUND },
        { 0x9F09DD1C, "OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Preset_3_ButtonWidget_enRelease", 0 },
        { 0x9F2E6283, "OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_Btn_Highcut_Inc_Button_enRelease", 0 },
        { 0x9F8A870B, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Textbox_Tuner2_Band_ButtonWidget_enRelease", 0 },
        { 0x9FD3B3E5, "OnButtonReactionMsg_Testmode_Scenes_R_TestModeScreens_Layer_TouchArea_TMC_Btn_ButtonWidget_enRelease", 0 },
        { 0x9FE98C1E, "onDeactivateImageProviderRequest", GetEventArgumentsForonDeactivateImageProviderRequest },
        { 0xA15C3CEE, "onHMISubStateChanged_STANDBY_RESTRICTED", 0 },
        { 0xA5A4C403, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0xA5B2C4B6, "OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_2_WHITE_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0xA6F431E6, "OnButtonReactionMsg_Testmode_Scenes_DEV__TESTMODE_PHONE_Layer_TouchArea_back_ButtonWidget_enRelease", 0 },
        { 0xA768E5F8, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Seekdn_ButtonWidget_enRelease", 0 },
        { 0xAA79C7DD, "onCenterPopupSurfaceUnqueued", GetEventArgumentsForonCenterPopupSurfaceUnqueued },
        { 0xAB89D7A8, "onHMISubStateChanged_SECURE", 0 },
        { 0xABFA03E9, "OnButtonReactionMsg_Testmode_Scenes_R_TestModeScreens_Layer_TouchArea_WeatherBand_ButtonWidget_enRelease", 0 },
        { 0xAC681D7B, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Stepup_ButtonWidget_enRelease", 0 },
        { 0xACAB7512, "OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_ButtonToggle_TAStatus_ButtonWidget2D_enRelease", 0 },
        { 0xAD459C05, "OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_Layer_TouchArea_Next_ButtonWidget_enRelease", 0 },
        { 0xB3EB5A6D, "OnButtonReactionMsg_Testmode_Scenes_R_TestModeScreens_Layer_TouchArea_FM_Btn_ButtonWidget_enRelease", 0 },
        { 0xB78D7AE0, "onPopupVisible", GetEventArgumentsForonPopupVisible },
        { 0xB7BD8F6E, "OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_15_ButtonWidget_enRelease", 0 },
        { 0xB9FBFF04, "OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_4_ButtonWidget_enRelease", 0 },
        { 0xBB11A23D, "OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_ButtonToggle_Measure_Mode_ButtonWidget2D_enRelease", 0 },
        { 0xBBE6896C, "onPopupQueued", GetEventArgumentsForonPopupQueued },
        { 0xBBF71A4E, "OnButtonReactionMsg_Testmode_Scenes_R_TestModeScreens_Layer_TouchArea_SXM_Btn_ButtonWidget_enRelease", 0 },
        { 0xC76C6549, "OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_7_FLICKER_2_Layer_TouchArea_Next_ButtonWidget_enRelease", 0 },
        { 0xC8D83B8B, "onHMISubStateChanged_PHONE", 0 },
        { 0xCB89B67C, "OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Preset_5_ButtonWidget_enRelease", 0 },
        { 0xCD7C642F, "OnButtonReactionMsg_Testmode_Scenes_DEV__TESTMODE_AUDIO_ButtonToggle_LinearAudio_ButtonWidget2D_enRelease", 0 },
        { 0xCD8C9774, "OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_9_ButtonWidget_enRelease", 0 },
        { 0xCEE62BFA, "OnButtonReactionMsg_Testmode_Scenes_R_TestmodeSourceSelection_Layer_TouchArea_SystemSettings_ButtonWidget_enRelease", 0 },
        { 0xD1950BF2, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Seekup_ButtonWidget_enRelease", 0 },
        { 0xD2A28045, "OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_18_ButtonWidget_enRelease", 0 },
        { 0xD2C72055, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Seekup_ButtonWidget_enRelease", 0 },
        { 0xD315E3F3, "OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_5_BLUE_Layer_TouchArea_Next_ButtonWidget_enRelease", 0 },
        { 0xD414ECB5, "OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Source_ButtonWidget_enRelease", 0 },
        { 0xDA0C89D0, "ev_HealthCareMntrDCT_YesTouch", 0 },
        { 0xDA21E229, "OnOpen_Settings_Screen", 0 },
        { 0xDB0D29F4, "onPopupUnqueued", GetEventArgumentsForonPopupUnqueued },
        { 0xDBA16C63, "OnButtonReactionMsg_Testmode_Scenes_DEV__TESTMODE_AUDIO_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0xDC71517D, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner3_Band_ButtonWidget_enRelease", 0 },
        { 0xDD62EA5B, "onActivateImageProviderRequest", GetEventArgumentsForonActivateImageProviderRequest },
        { 0xDDD10F14, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor2_Layer_TouchArea_Next_ButtonWidget_enRelease", 0 },
        { 0xDE8552E7, "OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_9_MURA2_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0xDE9448E3, "onAppStatusChanged_FOREGROUND", 0 },
        { 0xE17DC750, "OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_Btn_Sharx_Inc_Button_enRelease", 0 },
        { 0xE1815C72, "OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Preset_2_ButtonWidget_enRelease", 0 },
        { 0xE4658CFD, "onHMISubStateChanged_NO_DISPLAY", 0 },
        { 0xE7356244, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Textbox_Tuner3_ButtonWidget_enRelease", 0 },
        { 0xE7DCE080, "OnNextLevelTransitionFinished", 0 },
        { 0xE9A6D56C, "OnFadeAnimationFinished", 0 },
        { 0xEB87FE85, "OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_ButtonToggle_AF_ButtonWidget2D_enRelease", 0 },
        { 0xEEBD3407, "OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Preset_10_ButtonWidget_enRelease", 0 },
        { 0xF3619AD0, "OnButtonReactionMsg_Testmode_Scenes_R_SXM_Layer_TouchArea_Preset_14_ButtonWidget_enRelease", 0 },
        { 0xF3C405C4, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor3_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0xF3C96D17, "onPopupTimerExpiry", GetEventArgumentsForonPopupTimerExpiry },
        { 0xF639E057, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Next_ButtonWidget_enRelease", 0 },
        { 0xF725E179, "OnButtonReactionMsg_Testmode_Scenes_R_DAB_Monitor_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0xF72B0BBB, "OnButtonReactionMsg_Testmode_Scenes_R_FM_Triple_Tuner_Monitor_Layer_TouchArea_Stepdown_ButtonWidget_enRelease", 0 },
        { 0xF7E3DACF, "OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_8_MURA1_Layer_TouchArea_Next_ButtonWidget_enRelease", 0 },
        { 0xF84B3BD1, "OnZoomOutFinished", 0 },
        { 0xF96478DC, "onHMISubStateChanged_CLOCK", 0 },
        { 0xFB16D794, "OnButtonReactionMsg_Testmode_Scenes_DEV__SYSTEM_DISPLAY_TEST_7_FLICKER_2_Layer_TouchArea_Back_ButtonWidget_enRelease", 0 },
        { 0xFBEEA58F, "OnZoomInFinished", 0 },
        { 0xFC0D2293, "onCenterPopupSurfaceQueued", GetEventArgumentsForonCenterPopupSurfaceQueued },
        { 0xFC4B1295, "OnButtonReactionMsg_Testmode_Scenes_R_WeatherBand_Layer_TouchArea_Preset_8_ButtonWidget_enRelease", 0 },
        { 0xFCBB13CC, "OnButtonReactionMsg_Testmode_Scenes_R_FM_MonitorTestMode_ButtonToggle_RDS_ButtonWidget2D_enRelease", 0 },
    };
    const EventNameMapping* eventEntry = ::Courier::BinarySearch(eventId, events, 162, &EventNameMappingCmp);
    if (eventEntry && (eventId == eventEntry->mEventId)) {
        if (0 != eventEntry->mGetEventArguments) {
            eventEntry->mGetEventArguments(message, eventArguments);
        }
        return eventEntry->mEventName;
    }
    return 0;
}
#endif
// ------------------------------------------------------------------------
struct IdToNameMapping
{
    ::FeatStd::UInt32 mId;
    const ::FeatStd::Char* mName;
};

static ::FeatStd::Int IdToNameMappingCmp(::FeatStd::UInt32 id, const IdToNameMapping& nm)
{
    return (id == nm.mId) ? 0 : ((id < nm.mId) ? -1 : 1);
}

const ::FeatStd::Char * AppHmi_TestmodeStateMachineImpl::GetNameFromId(::FeatStd::UInt32 id)
{
    static IdToNameMapping names[30] = {
        { 0x064B9D4D, "Testmode#Scenes#R_FM_Triple_Tuner_Monitor" },
        { 0x18B579AF, "Testmode#Scenes#DEV__SYSTEM_DISPLAY_TEST_10_GAMMA" },
        { 0x202ECA59, "Testmode#Scenes#SystemSettingTestMode" },
        { 0x23776CBD, "Testmode#Scenes#R_TestmodeSourceSelection" },
        { 0x249A55B9, "Testmode#Scenes#DEV__SYSTEM_DISPLAY_TEST_3_RED" },
        { 0x29D302F7, "Testmode#Scenes#DEV__SYSTEM_DISPLAY_TEST_9_MURA2" },
        { 0x33DD518E, "Testmode#Scenes#DEV__SYSTEM_DISPLAY_TEST_8_MURA1" },
        { 0x428F64EA, "Testmode#Scenes#R_DAB_Monitor" },
        { 0x48896E6C, "Testmode#Scenes#DEV__TESTMODE_PHONE" },
        { 0x4DAC275D, "Testmode" },
        { 0x52B87E55, "Testmode#Scenes#DEV__SYSTEM_DISPLAY_TEST_7_FLICKER_2" },
        { 0x5A42F05C, "Testmode#Scenes#R_WeatherBand" },
        { 0x5B853C53, "Testmode#Scenes#R_SXM_Channel_List" },
        { 0x5DA75CCC, "Testmode#Popup" },
        { 0x64879655, "Testmode#Popup#Pfo_HealthCareMntr_DiagCtnrlTrouble" },
        { 0x71950DE4, "Testmode#Scenes#DEV__SYSTEM_DISPLAY_TEST_4_GREEN" },
        { 0x757AC009, "Testmode#Scenes#R_SXM" },
        { 0x7A34CD14, "Testmode#Scenes#R_WeatherBand_Monitor" },
        { 0x7BC8A358, "Testmode#Scenes#RVC_TESTMODE" },
        { 0x8482D10D, "Testmode#Scenes#DEV__SYSTEM_DISPLAY_TEST_6_FLICKER_1" },
        { 0x8BEA9DCC, "Testmode#Scenes#R_FM_MonitorTestMode" },
        { 0x93DD9F85, "Testmode#Scenes#R_TestMode_SXM_Monitor_List" },
        { 0x953BC826, "Testmode#Scenes#DEV__SYSTEM_DISPLAY_TEST_5_BLUE" },
        { 0xB98F7A9F, "Testmode#Scenes#R_TestModeScreens" },
        { 0xBDFC32D6, "Testmode#Scenes#DEV__SYSTEM_DISPLAY_TEST_2_WHITE" },
        { 0xC2D5AF6C, "Testmode#Scenes#DEV__SYSTEM_DISPLAY_TEST_1_BLACK" },
        { 0xE2133407, "Testmode#Scenes#R_FM_Triple_Tuner_Monitor2" },
        { 0xF5D15B83, "Testmode#Scenes#R_FM_Triple_Tuner_Monitor3" },
        { 0xF82FA360, "Testmode#Scenes#R_FM_TestMode" },
        { 0xF9121139, "Testmode#Scenes#DEV__TESTMODE_AUDIO" },
    };
    const IdToNameMapping *nameEntry = ::Courier::BinarySearch(id, names, 30, &IdToNameMappingCmp);
    if(nameEntry != 0 && id == nameEntry->mId) {
        return nameEntry->mName;
    }
    return "";
}

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::PerformLinearAudio()
{
    Action_PerformLinearAudio();
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::PerformHealthCareMntrDTCMsg(::FeatStd::UInt8 aHealthCareMntrDTCack)
{
    Action_PerformHealthCareMntrDTCMsg(enHealthCareMntrDTCType(aHealthCareMntrDTCack));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::PerformFMEnhancer()
{
    Action_PerformFMEnhancer();
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::DABIconVisibilityMsg()
{
    Action_DABIconVisibilityMsg();
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::Perform_Activate_Home_Source()
{
    Action_Perform_Activate_Home_Source();
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::FMMonitorMessageSharxHiCut(::FeatStd::UInt8 aFirstArg, ::FeatStd::UInt8 aSecondArg)
{
    Action_FMMonitorMessageSharxHiCut(Candera::UInt8(aFirstArg), Candera::UInt8(aSecondArg));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::Perform_Tuner_fn(::FeatStd::UInt8 aEventId, ::FeatStd::UInt32 aFirstArg, ::FeatStd::UInt32 aSecondArg)
{
    Action_Perform_Tuner_fn(Courier::Int8(aEventId), Courier::Int32(aFirstArg), Courier::Int32(aSecondArg));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::Perform_TestMode_Active_Screen(bool aStartMonitor)
{
    Action_Perform_TestMode_Active_Screen(bool(aStartMonitor));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::Perform_ChannelList_Screen_Active(bool aStartMonitor)
{
    Action_Perform_ChannelList_Screen_Active(bool(aStartMonitor));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::SXMAudioRecallorStore(::FeatStd::UInt8 aPresetRowIndex, ::FeatStd::UInt8 aPresetColIndex, ::FeatStd::UInt8 aPresetAction)
{
    Action_SXMAudioRecallorStore(Courier::UInt8(aPresetRowIndex), Courier::UInt8(aPresetColIndex), Courier::UInt8(aPresetAction));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::Perform_SXM_Audio_Allocation()
{
    Action_Perform_SXM_Audio_Allocation();
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::Notify_Init_Finished()
{
    Action_Notify_Init_Finished();
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::Perform_WX_Audio_Allocation()
{
    Action_Perform_WX_Audio_Allocation();
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::Perform_Tuner_Wx_fn(::FeatStd::UInt32 aEventId)
{
    Action_Perform_Tuner_Wx_fn(Courier::Int32(aEventId));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::Perform_Testmode_Context()
{
    Action_Perform_Testmode_Context();
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacChangeLanguageReq(::FeatStd::Int32 aLanguageId)
{
    Action_gacChangeLanguageReq(enLanguageId(aLanguageId));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacHideFocusInViewReq(::FeatStd::UInt32 aView)
{
    Action_gacHideFocusInViewReq(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(aView)));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::NextLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_NextLevelTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::PreviousLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_PreviousLevelTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::DualViewLeftTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_DualViewLeftTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::DualViewRightTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_DualViewRightTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::PageFlipBackTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_PageFlipBackTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::PageFlipFrontTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_PageFlipFrontTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::ZoomInTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos)
{
    Action_ZoomInTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView), Candera::UInt8(aPos));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::ZoomOutTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos)
{
    Action_ZoomOutTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView), Candera::UInt8(aPos));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::FadeTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_FadeTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacWaitAnimationStartReq()
{
    Action_gacWaitAnimationStartReq();
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::acFocusOnRightEncoderReqUpd(bool aIsFocusUsed)
{
    Action_acFocusOnRightEncoderReqUpd(bool(aIsFocusUsed));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::acSetGadgetSceenActiveStatus(bool aIsGadgetAtive)
{
    Action_acSetGadgetSceenActiveStatus(bool(aIsGadgetAtive));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::acHKNotificationMsg(::FeatStd::Int8 aHKCode, ::FeatStd::Int8 aHKState)
{
    Action_acHKNotificationMsg(Courier::UInt8(aHKCode), Courier::UInt8(aHKState));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::acPerform_CloseAllDropdowns()
{
    Action_acPerform_CloseAllDropdowns();
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::acPerform_CloseDropdown(::FeatStd::UInt32 aListId)
{
    Action_acPerform_CloseDropdown(::Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::acPerform_OpenDropdown(::FeatStd::UInt32 aListId)
{
    Action_acPerform_OpenDropdown(::Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::acPerform_ToggleDropdown(::FeatStd::UInt32 aListId)
{
    Action_acPerform_ToggleDropdown(::Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::acStartAppPopupTimer(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aTimeout)
{
    Action_acStartAppPopupTimer(Courier::UInt32(aViewId), Courier::UInt32(aTimeout));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::acStopAppPopupTimer(::FeatStd::UInt32 aViewId)
{
    Action_acStopAppPopupTimer(Courier::UInt32(aViewId));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::acPostBeep(::FeatStd::Int8 aBeepType)
{
    Action_acPostBeep(Courier::Int32(aBeepType));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacCheckToClosePopup(::FeatStd::UInt32 aPopupId)
{
    Action_gacCheckToClosePopup(Courier::UInt32(aPopupId));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::acRestartAppPopupTimer(::FeatStd::UInt32 aViewId)
{
    Action_acRestartAppPopupTimer(Courier::UInt32(aViewId));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacContextSwitchBackRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchBackRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacContextSwitchCompleteRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchCompleteRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacContextSwitchFailedRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchFailedRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacContextSwitchDoneRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchDoneRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacContextSwitchOutReq(::FeatStd::UInt32 aTargetContextId, ::FeatStd::UInt32 aSourceContextId, ::FeatStd::UInt32 aTargetAppId)
{
    Action_gacContextSwitchOutReq(Courier::UInt32(aTargetContextId), Courier::UInt32(aSourceContextId), Courier::UInt32(aTargetAppId));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacCurrentScreenDisplayReq()
{
    Action_gacCurrentScreenDisplayReq();
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacLaunchBarDisplayReq(bool aVisibility)
{
    Action_gacLaunchBarDisplayReq(bool(aVisibility));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacNavTBTSwipe()
{
    Action_gacNavTBTSwipe();
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacPerformListBtnRightEncoderChangeUpd(::FeatStd::Int8 aSteps, ::FeatStd::UInt32 aListId, ::FeatStd::UInt32 aRowId, ::FeatStd::UInt32 aColumnId)
{
    Action_gacPerformListBtnRightEncoderChangeUpd(Courier::Int8(aSteps), Courier::UInt32(aListId), Courier::UInt32(aRowId), Courier::UInt32(aColumnId));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacScrollListUp()
{
    Action_gacScrollListUp();
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacScrollListDown()
{
    Action_gacScrollListDown();
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacScrollPageUp()
{
    Action_gacScrollPageUp();
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacScrollPageDown()
{
    Action_gacScrollPageDown();
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacScrollListFocusUp(::FeatStd::UInt32 aListId)
{
    Action_gacScrollListFocusUp(Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacScrollListFocusDown(::FeatStd::UInt32 aListId)
{
    Action_gacScrollListFocusDown(Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacPerformListFocusLockDataResetUpd()
{
    Action_gacPerformListFocusLockDataResetUpd();
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacSetApplicationMode(::FeatStd::UInt32 aModeId)
{
    Action_gacSetApplicationMode(Courier::UInt32(aModeId));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacSpellerBbehaviorReq(bool aEnable)
{
    Action_gacSpellerBbehaviorReq(bool(aEnable));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacStatusBarDisplayReq(bool aVisibility, ::FeatStd::Int32 aHeaderType)
{
    Action_gacStatusBarDisplayReq(bool(aVisibility), Courier::Int32(aHeaderType));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacTBTRetriggerAcousticOutput()
{
    Action_gacTBTRetriggerAcousticOutput();
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacWaitAnimationStopReq()
{
    Action_gacWaitAnimationStopReq();
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacViewCreateReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateReq(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacViewCreateAllReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateAllReq(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacViewDestroyReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewDestroyReq(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacViewClearReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewClearReq(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacViewShowReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewShowReq(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacViewHideReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewHideReq(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacViewCreateWithoutLoadReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateWithoutLoadReq(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacViewAsyncLoadReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewAsyncLoadReq(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacViewActivateWithoutRenderingReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacPopupCreateAndSBShowReq(::FeatStd::UInt32 aViewId)
{
    Action_gacPopupCreateAndSBShowReq(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacPopupCreateAndSBShowReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId)
{
    Action_gacPopupCreateAndSBShowReqForMultiDisplay(Courier::UInt32(aPopupDisplayID), ::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacPopupSBCloseReq(::FeatStd::UInt32 aViewId)
{
    Action_gacPopupSBCloseReq(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacPopupSBCloseReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId)
{
    Action_gacPopupSBCloseReqForMultiDisplay(Courier::UInt32(aPopupDisplayID), ::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacPopupRestartTimerReq(::FeatStd::UInt32 aViewId)
{
    Action_gacPopupRestartTimerReq(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacPopupRestartTimerReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId)
{
    Action_gacPopupRestartTimerReqForMultiDisplay(Courier::UInt32(aPopupDisplayID), ::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacViewCreateAndShowReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateAndShowReq(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacViewHideAndDestroyReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewHideAndDestroyReq(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacSceneTransitionEnter(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint)
{
    Action_gacSceneTransitionEnter(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(aViewId)), Courier::UInt32(aHint));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacSceneTransitionLeave(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint)
{
    Action_gacSceneTransitionLeave(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(aViewId)), Courier::UInt32(aHint));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacDisplayStatusLineReq(::FeatStd::Int32 aDisplayRegionType)
{
    Action_gacDisplayStatusLineReq(Courier::Int32(aDisplayRegionType));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacHideStatusLineReq(::FeatStd::Int32 aDisplayRegionType)
{
    Action_gacHideStatusLineReq(Courier::Int32(aDisplayRegionType));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacDisplayFooterLineReq()
{
    Action_gacDisplayFooterLineReq();
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacHideFooterLineReq()
{
    Action_gacHideFooterLineReq();
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacDisplayStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacDisplayStatusLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacHideStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacHideStatusLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacDisplayFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacDisplayFooterLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacHideFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacHideFooterLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacRegisterForCloseOnTouchSession(::FeatStd::UInt32 aViewId)
{
    Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacDeregisterForCloseOnTouchSessionReq(::FeatStd::UInt32 aViewId)
{
    Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacPopupFilterPrioEnableReq(::FeatStd::UInt32 aPrio)
{
    Action_gacPopupFilterPrioEnableReq(Courier::UInt32(aPrio));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacPopupFilterAllEnableReq()
{
    Action_gacPopupFilterAllEnableReq();
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacPopupFilterDisableReq()
{
    Action_gacPopupFilterDisableReq();
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacProfileChange(::FeatStd::Int8 aProfile)
{
    Action_gacProfileChange(Courier::UInt32(aProfile));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacPopupFilterPrioEnableReqForDisplay(::FeatStd::UInt32 aPrio, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacPopupFilterPrioEnableReqForDisplay(Courier::UInt32(aPrio), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacPopupFilterAllEnableReqForDisplay(::FeatStd::UInt32 aDisplayID)
{
    Action_gacPopupFilterAllEnableReqForDisplay(Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacPopupFilterDisableReqForDisplay(::FeatStd::UInt32 aDisplayID)
{
    Action_gacPopupFilterDisableReqForDisplay(Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacStartSceneTransitionAnimation(::FeatStd::UInt32 aSourceView, ::FeatStd::UInt32 aDestinationView, ::FeatStd::UInt32 aUserData1, ::FeatStd::Int8 aUserData2)
{
    Action_gacStartSceneTransitionAnimation(::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(aSourceView)), ::Courier::ViewId(AppHmi_TestmodeStateMachineImpl::GetNameFromId(aDestinationView)), Courier::UInt32(aUserData1), Courier::Int8(aUserData2));
}

// ------------------------------------------------------------------------
void AppHmi_TestmodeStateMachineImpl::gacDecrementActiveAnimationCount()
{
    Action_gacDecrementActiveAnimationCount();
}
#ifdef CIT_SIMULATION
struct ActionMapping
{
    ::FeatStd::UInt32 mHashId;
    bool (*mActionCallHandler)(const ::Json::Value& parameters, ::Json::Value &response);
};

static ::FeatStd::Int ActionMappingCmp(::FeatStd::UInt32 hash, const ActionMapping& am)
{
    return (hash == am.mHashId) ? 0 : ((hash < am.mHashId) ? -1 : 1);
}

bool AppHmi_TestmodeStateMachineImpl::CallAction(const ::FeatStd::Char* actionName, const ::Json::Value& parameters, ::Json::Value &response)
{
    static ActionMapping actions[98] = {
        { 0x036A7B40, CallAction_Perform_Tuner_Wx_fn },
        { 0x04C09BE6, CallAction_DABIconVisibilityMsg },
        { 0x05A5300F, CallAction_Perform_Testmode_Context },
        { 0x0884F877, CallAction_gacScrollListUp },
        { 0x090A895B, CallAction_gacScrollListFocusDown },
        { 0x0A4C5DC9, CallAction_gacDisplayStatusLineMultiDisplayReq },
        { 0x0C279721, CallAction_gacDecrementActiveAnimationCount },
        { 0x11915CFE, CallAction_acStopAppPopupTimer },
        { 0x121A4038, CallAction_Perform_WX_Audio_Allocation },
        { 0x15061065, CallAction_gacViewShowReq },
        { 0x186A69F1, CallAction_gacWaitAnimationStopReq },
        { 0x187DA604, CallAction_acPerform_OpenDropdown },
        { 0x1BC6E0A9, CallAction_ZoomInTransition },
        { 0x20432FC4, CallAction_PerformHealthCareMntrDTCMsg },
        { 0x21E3828E, CallAction_gacDisplayStatusLineReq },
        { 0x251DE22F, CallAction_gacContextSwitchCompleteRes },
        { 0x254E0D94, CallAction_gacViewHideReq },
        { 0x258104C2, CallAction_DualViewLeftTransition },
        { 0x264B8E81, CallAction_gacPopupRestartTimerReqForMultiDisplay },
        { 0x27CE647F, CallAction_gacScrollListFocusUp },
        { 0x29D14586, CallAction_gacDisplayFooterLineMultiDisplayReq },
        { 0x2A1E6CB2, CallAction_gacDeregisterForCloseOnTouchSessionReq },
        { 0x2AE288D8, CallAction_gacViewDestroyReq },
        { 0x30C8D840, CallAction_gacStartSceneTransitionAnimation },
        { 0x325BE13A, CallAction_gacViewCreateReq },
        { 0x334571BF, CallAction_acHKNotificationMsg },
        { 0x3BB18A69, CallAction_gacPopupFilterAllEnableReq },
        { 0x3E2192A0, CallAction_PerformLinearAudio },
        { 0x3E4CE5A1, CallAction_gacContextSwitchDoneRes },
        { 0x3E7F9726, CallAction_gacSceneTransitionEnter },
        { 0x41201119, CallAction_acStartAppPopupTimer },
        { 0x49989AB7, CallAction_FMMonitorMessageSharxHiCut },
        { 0x573EB339, CallAction_gacContextSwitchFailedRes },
        { 0x57AA275B, CallAction_gacViewCreateWithoutLoadReq },
        { 0x59148CB0, CallAction_FadeTransition },
        { 0x59C82D8E, CallAction_NextLevelTransition },
        { 0x59F03621, CallAction_gacChangeLanguageReq },
        { 0x60E513C0, CallAction_gacTBTRetriggerAcousticOutput },
        { 0x629132A7, CallAction_gacPopupFilterDisableReq },
        { 0x67B7653B, CallAction_gacDisplayFooterLineReq },
        { 0x7531D066, CallAction_Notify_Init_Finished },
        { 0x75E49D1D, CallAction_gacPerformListFocusLockDataResetUpd },
        { 0x76EE4CA4, CallAction_gacHideStatusLineMultiDisplayReq },
        { 0x791DF896, CallAction_acPerform_CloseAllDropdowns },
        { 0x7D7B49B4, CallAction_acFocusOnRightEncoderReqUpd },
        { 0x7EE4AB88, CallAction_gacPopupRestartTimerReq },
        { 0x82D15005, CallAction_PageFlipBackTransition },
        { 0x881D2454, CallAction_gacPopupFilterAllEnableReqForDisplay },
        { 0x91BB105A, CallAction_gacLaunchBarDisplayReq },
        { 0x93218F8C, CallAction_gacContextSwitchOutReq },
        { 0x948F96CC, CallAction_gacScrollListDown },
        { 0x96350312, CallAction_acSetGadgetSceenActiveStatus },
        { 0x96D3C730, CallAction_gacPopupSBCloseReqForMultiDisplay },
        { 0x99258E0B, CallAction_gacStatusBarDisplayReq },
        { 0x9E84DEAA, CallAction_PerformFMEnhancer },
        { 0x9F87F08B, CallAction_acPostBeep },
        { 0x9FA26D73, CallAction_gacPopupFilterDisableReqForDisplay },
        { 0xA0A6F9FA, CallAction_gacViewHideAndDestroyReq },
        { 0xA172CF4E, CallAction_Perform_Activate_Home_Source },
        { 0xA7B62A65, CallAction_gacPopupFilterPrioEnableReqForDisplay },
        { 0xA84DC23C, CallAction_gacHideFocusInViewReq },
        { 0xA9C7F42F, CallAction_gacHideStatusLineReq },
        { 0xAB436919, CallAction_Perform_ChannelList_Screen_Active },
        { 0xAB49461E, CallAction_gacViewCreateAndShowReq },
        { 0xAD947FF9, CallAction_gacCurrentScreenDisplayReq },
        { 0xADA8B9DD, CallAction_Perform_SXM_Audio_Allocation },
        { 0xAE48BF55, CallAction_DualViewRightTransition },
        { 0xAFB14254, CallAction_gacWaitAnimationStartReq },
        { 0xBB441DAC, CallAction_gacRegisterForCloseOnTouchSession },
        { 0xBDECE418, CallAction_gacSetApplicationMode },
        { 0xBEF6021E, CallAction_acPerform_ToggleDropdown },
        { 0xC00C3ABC, CallAction_SXMAudioRecallorStore },
        { 0xC37EE8E9, CallAction_gacPopupFilterPrioEnableReq },
        { 0xC51CE603, CallAction_gacViewCreateAllReq },
        { 0xC5DD5738, CallAction_gacProfileChange },
        { 0xC65CAED0, CallAction_gacSpellerBbehaviorReq },
        { 0xC8539D8B, CallAction_gacSceneTransitionLeave },
        { 0xC8EA8B79, CallAction_acRestartAppPopupTimer },
        { 0xC9EB88D6, CallAction_gacViewClearReq },
        { 0xCB8DBDEF, CallAction_gacHideFooterLineReq },
        { 0xCCF1A98B, CallAction_PreviousLevelTransition },
        { 0xD1AA4F4D, CallAction_ZoomOutTransition },
        { 0xD5F685D5, CallAction_PageFlipFrontTransition },
        { 0xD63C2357, CallAction_gacViewAsyncLoadReq },
        { 0xD98C6419, CallAction_gacViewActivateWithoutRenderingReq },
        { 0xDB665FD5, CallAction_acPerform_CloseDropdown },
        { 0xDD4D179D, CallAction_gacHideFooterLineMultiDisplayReq },
        { 0xDD71F921, CallAction_gacPerformListBtnRightEncoderChangeUpd },
        { 0xE0EF3086, CallAction_gacPopupCreateAndSBShowReqForMultiDisplay },
        { 0xE500B03C, CallAction_gacContextSwitchBackRes },
        { 0xEB51CB7E, CallAction_gacPopupSBCloseReq },
        { 0xEC64DB0F, CallAction_gacScrollPageDown },
        { 0xEE11F57F, CallAction_gacScrollPageUp },
        { 0xEE131A83, CallAction_gacNavTBTSwipe },
        { 0xEFA6640D, CallAction_Perform_TestMode_Active_Screen },
        { 0xF0A1D4B5, CallAction_gacCheckToClosePopup },
        { 0xF17E085D, CallAction_gacPopupCreateAndSBShowReq },
        { 0xFACF47DC, CallAction_Perform_Tuner_fn },
    };
    ::FeatStd::UInt32 hashId = ::Courier::Identifier::CalcHash(actionName);
    const ActionMapping* action = ::Courier::BinarySearch(hashId, actions, 98, &ActionMappingCmp);
    if (action && (hashId == action->mHashId)) {
        return action->mActionCallHandler(parameters, response);
    }
    return false;
}
#endif
namespace Courier {
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ActivationReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ActivationResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewRenderingReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewRenderingResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewMessagingReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewMessagingResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupActivationReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupActivationResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TryLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DelayedUnloadMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LoadResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TryAsyncLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AsyncLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AsyncLoadResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AsyncLoadIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupLoadResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ThemeReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ThemeResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AnimationReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AnimationResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AnimationIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetPropertyReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetPropertyResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetFocusReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetFocusResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LostFocusIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::InvalidateReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::RenderReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::RenderResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LayerReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LayerResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewActivateEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewRenderingEnabledEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewInitContentEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewLoadEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::FocusEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LostFocusEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionStartedEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionFinishedEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetCultureReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetCultureResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CultureChangeIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewPlaceholderReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewPlaceholderResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::WidgetMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::DataBindingMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::BindingSourceBaseMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::ReleaseDataItemMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::DataItemMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::ListEventMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::input::TouchAbort, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::input::TouchSessionStartEvent, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::input::TouchSessionStopEvent, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::IdUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ConsumerMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ProviderUpdateIndicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::TouchForwardReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::TouchAbortReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ActivateImageProviderReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ExternalImageProviderReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ExternalImageProviderGroupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DrmAllocationStatusMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DrmGarbageCollectorReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DrmGCTimeoutMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::PositionBaseMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::SlaveSurfaceRepositionBaseMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DirectTextureConsumerContentIndicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::PositionInfoReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::PositionInfoResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::SlaveSurfaceRepositionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::SlaveSurfaceRepositionResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::WidgetCheckReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NotifierMessage, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TimerExpiredMsg, 15);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::GuiStartupFinishedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CreateNewDestroyOld, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EnterKeyStatusChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusControlReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusGroupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateFocusSessionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RefreshFocusSessionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusSessionFinishedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RegisterFocusableWidgetsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::JoystickStatusChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusChangedReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SurfaceStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LayerStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SBPopupTimerExpiryUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HMISubStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::QueryTraceInfoReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FollowUpActionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::WidgetPropertySetterReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SimTouchReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CloseOnTouchReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RegisterForCloseOnTouchSessionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetClosePopupExternalTouchMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ClosePopupOnExternalTouchReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PlayBeepReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeHmiSubStateReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EvalSubSurfaceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExecuteSubSurfaceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExecuteSubSurfaceResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExtendedViewReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LocalizationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DecrementActiveAnimationCountMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetApplicationAsMandatoryReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplicationStateUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SubSurfaceUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplicationRenderedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplicationSwitchCompleteUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SubSurfaceSwitchCompleteUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SbAnimationStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SbCurrentStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupDisplayStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowHMISubSurfaceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartLayerAnimationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupFilterPrioEnableReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupFilterAllEnableReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupFilterDisableReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MultiDisplayPopupFilterReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RestartMenuTimeoutTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RenderingCompleteMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CreateTextMetaDataCollectionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DumpScreenReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TraverseViewsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckSourceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckSourceResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckDestinationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckDestinationResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCompleteReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCompleteResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropAbortReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ProfileSwitchMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TransitionMediatorOnDataCompleteMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ManualSceneActionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EglWaitNativeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EglWaitNativeResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ResetGadgetCacheReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AttachedAnimationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::SenderMessage, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::TouchUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AnimationWidgetReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AnimationWidgetIndMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonListItemUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonReactionMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonSlideMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonGroupReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ColorBarDataUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::combobox::ComboBoxUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::combobox::ComboBoxReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DropdownCurrentValueChangedMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DropdownChangeMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::editfield::EditFieldUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::editfield::EditFieldHightlightReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::GestureMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::TapGestureMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::DragGestureMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::SwipeGestureMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::PinchSpreadGestureMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::RotateGestureMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gizmo::GizmoUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListDateProviderReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListDateProviderResMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListDataProviderUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListChangeMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListAnimatedChangeReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListChangedUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListMovementFinishedUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListStatusUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListVisibiltyUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusChangeReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SliderCurrentValueChangedMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LockOutMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListItemExpandReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListItemExpandEndUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCustomAnimationReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCustomAnimationResMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCustomAnimationIndMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListMorphReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListContentUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListVisualContentUpdateMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCacheReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::pageedit::PageEditUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PanelSlideReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PanelStateMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerKeyPressed, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerCtrlKeyPressed, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerStatusChangedUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SubSpellerStatusUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TimerWidgetExpiryMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HWR_CandidateUpdate, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HWR_TextWidgetUpdate, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ScrollableTextUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActiveSurfaceViewUpdateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeLanguageReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartPopupTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StopPopupTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RestartPopupTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExpiredPopupTimerResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusResetReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EnableCameraRenderingReq, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchApplicationStateReq, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DisableCameraRenderingReq, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DummyMess, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivityMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateApplicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DeactivateApplicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HardKeyPressNotificationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusOnRightEncoderReqUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StoreActiveGadgetReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CheckToClosePopupMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ContextSwitchOutReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ContextSwitchInResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CurrentScreenDisplayReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LaunchBarDisplayReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NavTBTSwipeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListItemRightEncoderChangeUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusLockDataResetReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusScrollReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetApplicationModeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerBbehaviorReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StatusBarDisplayReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TBTRetriggerAcousticMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartGadgetAnimationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ControlPanelButtonPressInfo, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NavigationCarModeInfo, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DummyChangedUpdMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchApplicationReq, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Popup_PFO_TriggerSystemSetting, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Open_Settings_Screen, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FMMonitorMessage, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LinearAudioReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmDTMTestModeMonitorSelReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioAllocateReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::WXAudioAllocateReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FMEnhancerReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DABIconVisibility, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioCustomizeListReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HealthCareMntrDTCMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioRecallorStoreReqMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TunerBLMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NACTimerExpiryMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Tuner_WxBLMsg, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ContextToMaster, 20);
} // namespace Courier

// ------------------------------------------------------------------------
DAB_Test_ModeDataBindingSource::DAB_Test_ModeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DAB_Test_ModeItem)
{
}

// ------------------------------------------------------------------------
DAB_Setup_Screen_ActiveTuner_InfoDataBindingSource::DAB_Setup_Screen_ActiveTuner_InfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DAB_Setup_Screen_ActiveTuner_InfoItem)
{
}

// ------------------------------------------------------------------------
Smart_InfoDataBindingSource::Smart_InfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Smart_InfoItem)
{
}

// ------------------------------------------------------------------------
DABTestModeEnsembleInfoDataBindingSource::DABTestModeEnsembleInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DABTestModeEnsembleInfoItem)
{
}

// ------------------------------------------------------------------------
HealthCareMonitorDTCinfoDataBindingSource::HealthCareMonitorDTCinfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HealthCareMonitorDTCinfoItem)
{
}

// ------------------------------------------------------------------------
Tuner1DataBindingSource::Tuner1DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Tuner1Item)
{
}

// ------------------------------------------------------------------------
Tuner2DataBindingSource::Tuner2DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Tuner2Item)
{
}

// ------------------------------------------------------------------------
Tuner3DataBindingSource::Tuner3DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Tuner3Item)
{
}

// ------------------------------------------------------------------------
Tuner4DataBindingSource::Tuner4DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::Tuner4Item)
{
}

// ------------------------------------------------------------------------
DABGTestModeInfoDataBindingSource::DABGTestModeInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DABGTestModeInfoItem)
{
}

// ------------------------------------------------------------------------
DAB_Setup_ScreenDataBindingSource::DAB_Setup_ScreenDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DAB_Setup_ScreenItem)
{
}

// ------------------------------------------------------------------------
DABGTestModeAnnoStatusInfoDataBindingSource::DABGTestModeAnnoStatusInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DABGTestModeAnnoStatusInfoItem)
{
}

// ------------------------------------------------------------------------
DABGTestModeActiveCompDataBindingSource::DABGTestModeActiveCompDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DABGTestModeActiveCompItem)
{
}

// ------------------------------------------------------------------------
DABTestModeGAvailabiltyInfoDataBindingSource::DABTestModeGAvailabiltyInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DABTestModeGAvailabiltyInfoItem)
{
}

// ------------------------------------------------------------------------
DABTestModeServiceFollowingInfoDataBindingSource::DABTestModeServiceFollowingInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DABTestModeServiceFollowingInfoItem)
{
}

// ------------------------------------------------------------------------
EngineeringInfoDataBindingSource::EngineeringInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::EngineeringInfoItem)
{
}

// ------------------------------------------------------------------------
EngineeringInfo1DataBindingSource::EngineeringInfo1DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::EngineeringInfo1Item)
{
}

// ------------------------------------------------------------------------
EngineeringInfo2DataBindingSource::EngineeringInfo2DataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::EngineeringInfo2Item)
{
}

// ------------------------------------------------------------------------
TunerSource_BandDataBindingSource::TunerSource_BandDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::TunerSource_BandItem)
{
}

// ------------------------------------------------------------------------
PresetInfoWBDataBindingSource::PresetInfoWBDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PresetInfoWBItem)
{
}

// ------------------------------------------------------------------------
WBPresetInfoDataBindingSource::WBPresetInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::WBPresetInfoItem)
{
}

// ------------------------------------------------------------------------
FMSetupMenuInfoDataBindingSource::FMSetupMenuInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::FMSetupMenuInfoItem)
{
}

// ------------------------------------------------------------------------
AudioTestModeDataBindingSource::AudioTestModeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::AudioTestModeItem)
{
}

// ------------------------------------------------------------------------
PhoneTestMode_ListItemDataBindingSource::PhoneTestMode_ListItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PhoneTestMode_ListItemItem)
{
}

// ------------------------------------------------------------------------
ListId_FlexDataBindingSource::ListId_FlexDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ListId_FlexItem)
{
}

// ------------------------------------------------------------------------
ListDataSizeDataBindingSource::ListDataSizeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ListDataSizeItem)
{
}

// ------------------------------------------------------------------------
SystemSettingTestModeDataBindingSource::SystemSettingTestModeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SystemSettingTestModeItem)
{
}

// ------------------------------------------------------------------------
RVCTestModeDataBindingSource::RVCTestModeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::RVCTestModeItem)
{
}

// ------------------------------------------------------------------------
SxmChannelInfoDataBindingSource::SxmChannelInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmChannelInfoItem)
{
}

// ------------------------------------------------------------------------
SxmTpopChannelInfoDataBindingSource::SxmTpopChannelInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmTpopChannelInfoItem)
{
}

// ------------------------------------------------------------------------
PresetInfoSXMDataBindingSource::PresetInfoSXMDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PresetInfoSXMItem)
{
}

// ------------------------------------------------------------------------
SXMAntennaInfoDataBindingSource::SXMAntennaInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SXMAntennaInfoItem)
{
}

// ------------------------------------------------------------------------
ListScrollBarInfoDataBindingSource::ListScrollBarInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ListScrollBarInfoItem)
{
}

// ------------------------------------------------------------------------
CarModeVisibilityDataBindingSource::CarModeVisibilityDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::CarModeVisibilityItem)
{
}

typedef void InvalidData;
struct InvalidDataBindingSource {
    static const ::FeatStd::UInt32 cHierarchyNodeCount = 1;
};

// table of shared DataItemDescriptor
static const ::Courier::Internal::DataBinding::DataItemDescriptor gItemDesc[cDataItemDescriptorCount] = {
    {   // 0 - ::InvalidData
        COURIER_DATA_ITEM_TYPE_ID(::InvalidData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 1 - ::DAB_Test_ModeData
        COURIER_DATA_ITEM_TYPE_ID(::DAB_Test_ModeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 2 - ::DAB_Test_ModeData::mchannel_Num
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mchannel_Num)
    },
    {   // 3 - ::DAB_Test_ModeData::mEnsemble_Lbl
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mEnsemble_Lbl)
    },
    {   // 4 - ::DAB_Test_ModeData::mEnsemble_ID
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mEnsemble_ID)
    },
    {   // 5 - ::DAB_Test_ModeData::mService_ID
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mService_ID)
    },
    {   // 6 - ::DAB_Test_ModeData::mEnsemble_freq
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mEnsemble_freq)
    },
    {   // 7 - ::DAB_Test_ModeData::mService_Lbl
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mService_Lbl)
    },
    {   // 8 - ::DAB_Test_ModeData::mAud_Data_Bit_Rate
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mAud_Data_Bit_Rate)
    },
    {   // 9 - ::DAB_Test_ModeData::mMSC
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mMSC)
    },
    {   // 10 - ::DAB_Test_ModeData::mFIC
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mFIC)
    },
    {   // 11 - ::DAB_Test_ModeData::mNetbitErrorrate
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mNetbitErrorrate)
    },
    {   // 12 - ::DAB_Test_ModeData::mNET
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mNET)
    },
    {   // 13 - ::DAB_Test_ModeData::mRS_FEC
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mRS_FEC)
    },
    {   // 14 - ::DAB_Test_ModeData::mSync_flag
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mSync_flag)
    },
    {   // 15 - ::DAB_Test_ModeData::mQA
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mQA)
    },
    {   // 16 - ::DAB_Test_ModeData::mQS
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mQS)
    },
    {   // 17 - ::DAB_Test_ModeData::mField_Strength
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mField_Strength)
    },
    {   // 18 - ::DAB_Test_ModeData::mMute_flag
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mMute_flag)
    },
    {   // 19 - ::DAB_Test_ModeData::mBg_tuner_ens_freq
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mBg_tuner_ens_freq)
    },
    {   // 20 - ::DAB_Test_ModeData::mBg_Ensemble_ID
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mBg_Ensemble_ID)
    },
    {   // 21 - ::DAB_Test_ModeData::mBg_FIC
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mBg_FIC)
    },
    {   // 22 - ::DAB_Test_ModeData::mAudio_Mode
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mAudio_Mode)
    },
    {   // 23 - ::DAB_Test_ModeData::mFreq_Table
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mFreq_Table)
    },
    {   // 24 - ::DAB_Test_ModeData::mBGMode
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mBGMode)
    },
    {   // 25 - ::DAB_Test_ModeData::mBGSync_flag
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mBGSync_flag)
    },
    {   // 26 - ::DAB_Test_ModeData::mTASrc
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mTASrc)
    },
    {   // 27 - ::DAB_Test_ModeData::mDABIconVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mDABIconVisibility)
    },
    {   // 28 - ::DAB_Test_ModeData::mSXMIconVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DAB_Test_ModeData, mSXMIconVisibility)
    },
    {   // 29 - ::DAB_Setup_Screen_ActiveTuner_InfoData
        COURIER_DATA_ITEM_TYPE_ID(::DAB_Setup_Screen_ActiveTuner_InfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 30 - ::DAB_Setup_Screen_ActiveTuner_InfoData::mDRC
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Setup_Screen_ActiveTuner_InfoData, mDRC)
    },
    {   // 31 - ::DAB_Setup_Screen_ActiveTuner_InfoData::mPS
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Setup_Screen_ActiveTuner_InfoData, mPS)
    },
    {   // 32 - ::DAB_Setup_Screen_ActiveTuner_InfoData::mSM_ACC
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Setup_Screen_ActiveTuner_InfoData, mSM_ACC)
    },
    {   // 33 - ::DAB_Setup_Screen_ActiveTuner_InfoData::mSR
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Setup_Screen_ActiveTuner_InfoData, mSR)
    },
    {   // 34 - ::DAB_Setup_Screen_ActiveTuner_InfoData::mTP
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Setup_Screen_ActiveTuner_InfoData, mTP)
    },
    {   // 35 - ::Smart_InfoData
        COURIER_DATA_ITEM_TYPE_ID(::Smart_InfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 36 - ::Smart_InfoData::mNaviIconVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::Smart_InfoData, mNaviIconVisibility)
    },
    {   // 37 - ::Smart_InfoData::mCameraIconVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::Smart_InfoData, mCameraIconVisibility)
    },
    {   // 38 - ::Smart_InfoData::mNaviIconVisibility_CC
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::Smart_InfoData, mNaviIconVisibility_CC)
    },
    {   // 39 - ::DABTestModeEnsembleInfoData
        COURIER_DATA_ITEM_TYPE_ID(::DABTestModeEnsembleInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 40 - ::DABTestModeEnsembleInfoData::mNoOfAud_DataServiceComp
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABTestModeEnsembleInfoData, mNoOfAud_DataServiceComp)
    },
    {   // 41 - ::DABTestModeEnsembleInfoData::mNoOfAud_DataService
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABTestModeEnsembleInfoData, mNoOfAud_DataService)
    },
    {   // 42 - ::DABTestModeEnsembleInfoData::mNoOfEnsembles
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABTestModeEnsembleInfoData, mNoOfEnsembles)
    },
    {   // 43 - ::HealthCareMonitorDTCinfoData
        COURIER_DATA_ITEM_TYPE_ID(::HealthCareMonitorDTCinfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 44 - ::HealthCareMonitorDTCinfoData::mHCMDTCline1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::HealthCareMonitorDTCinfoData, mHCMDTCline1)
    },
    {   // 45 - ::HealthCareMonitorDTCinfoData::mHCMDTCline2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::HealthCareMonitorDTCinfoData, mHCMDTCline2)
    },
    {   // 46 - ::HealthCareMonitorDTCinfoData::mHCMDTCline3
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::HealthCareMonitorDTCinfoData, mHCMDTCline3)
    },
    {   // 47 - ::Tuner1Data
        COURIER_DATA_ITEM_TYPE_ID(::Tuner1Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 48 - ::Tuner1Data::mFreq
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner1Data, mFreq)
    },
    {   // 49 - ::Tuner1Data::mPI
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner1Data, mPI)
    },
    {   // 50 - ::Tuner1Data::mPS
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner1Data, mPS)
    },
    {   // 51 - ::Tuner1Data::mFSQ
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner1Data, mFSQ)
    },
    {   // 52 - ::Tuner1Data::mHicut
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner1Data, mHicut)
    },
    {   // 53 - ::Tuner1Data::mSharx
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner1Data, mSharx)
    },
    {   // 54 - ::Tuner1Data::mTP
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner1Data, mTP)
    },
    {   // 55 - ::Tuner1Data::mTA
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner1Data, mTA)
    },
    {   // 56 - ::Tuner1Data::mRDS
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner1Data, mRDS)
    },
    {   // 57 - ::Tuner1Data::mAF
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner1Data, mAF)
    },
    {   // 58 - ::Tuner1Data::mDev
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner1Data, mDev)
    },
    {   // 59 - ::Tuner1Data::mCS
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner1Data, mCS)
    },
    {   // 60 - ::Tuner1Data::mMPNC
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner1Data, mMPNC)
    },
    {   // 61 - ::Tuner2Data
        COURIER_DATA_ITEM_TYPE_ID(::Tuner2Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 62 - ::Tuner2Data::mFreq
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner2Data, mFreq)
    },
    {   // 63 - ::Tuner2Data::mPI
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner2Data, mPI)
    },
    {   // 64 - ::Tuner2Data::mPS
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner2Data, mPS)
    },
    {   // 65 - ::Tuner2Data::mFSQ
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner2Data, mFSQ)
    },
    {   // 66 - ::Tuner2Data::mHicut
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner2Data, mHicut)
    },
    {   // 67 - ::Tuner2Data::mSharx
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner2Data, mSharx)
    },
    {   // 68 - ::Tuner2Data::mTP
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner2Data, mTP)
    },
    {   // 69 - ::Tuner2Data::mTA
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner2Data, mTA)
    },
    {   // 70 - ::Tuner2Data::mRDS
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner2Data, mRDS)
    },
    {   // 71 - ::Tuner2Data::mAF
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner2Data, mAF)
    },
    {   // 72 - ::Tuner2Data::mDev
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner2Data, mDev)
    },
    {   // 73 - ::Tuner2Data::mCS
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner2Data, mCS)
    },
    {   // 74 - ::Tuner2Data::mMPNC
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner2Data, mMPNC)
    },
    {   // 75 - ::Tuner3Data
        COURIER_DATA_ITEM_TYPE_ID(::Tuner3Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 76 - ::Tuner3Data::mFreq
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner3Data, mFreq)
    },
    {   // 77 - ::Tuner3Data::mPI
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner3Data, mPI)
    },
    {   // 78 - ::Tuner3Data::mPS
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner3Data, mPS)
    },
    {   // 79 - ::Tuner3Data::mFSQ
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner3Data, mFSQ)
    },
    {   // 80 - ::Tuner3Data::mHicut
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner3Data, mHicut)
    },
    {   // 81 - ::Tuner3Data::mSharx
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner3Data, mSharx)
    },
    {   // 82 - ::Tuner3Data::mTP
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner3Data, mTP)
    },
    {   // 83 - ::Tuner3Data::mTA
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner3Data, mTA)
    },
    {   // 84 - ::Tuner3Data::mRDS
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner3Data, mRDS)
    },
    {   // 85 - ::Tuner3Data::mAF
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner3Data, mAF)
    },
    {   // 86 - ::Tuner3Data::mDev
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner3Data, mDev)
    },
    {   // 87 - ::Tuner3Data::mCS
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner3Data, mCS)
    },
    {   // 88 - ::Tuner3Data::mMPNC
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner3Data, mMPNC)
    },
    {   // 89 - ::Tuner4Data
        COURIER_DATA_ITEM_TYPE_ID(::Tuner4Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 90 - ::Tuner4Data::mFreq
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner4Data, mFreq)
    },
    {   // 91 - ::Tuner4Data::mPI
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner4Data, mPI)
    },
    {   // 92 - ::Tuner4Data::mPS
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner4Data, mPS)
    },
    {   // 93 - ::Tuner4Data::mFSQ
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner4Data, mFSQ)
    },
    {   // 94 - ::Tuner4Data::mHicut
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner4Data, mHicut)
    },
    {   // 95 - ::Tuner4Data::mSharx
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner4Data, mSharx)
    },
    {   // 96 - ::Tuner4Data::mTP
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner4Data, mTP)
    },
    {   // 97 - ::Tuner4Data::mTA
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner4Data, mTA)
    },
    {   // 98 - ::Tuner4Data::mRDS
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner4Data, mRDS)
    },
    {   // 99 - ::Tuner4Data::mAF
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner4Data, mAF)
    },
    {   // 100 - ::Tuner4Data::mDev
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner4Data, mDev)
    },
    {   // 101 - ::Tuner4Data::mCS
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner4Data, mCS)
    },
    {   // 102 - ::Tuner4Data::mMPNC
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::Tuner4Data, mMPNC)
    },
    {   // 103 - ::DABGTestModeInfoData
        COURIER_DATA_ITEM_TYPE_ID(::DABGTestModeInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 104 - ::DABGTestModeInfoData::mFM
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABGTestModeInfoData, mFM)
    },
    {   // 105 - ::DABGTestModeInfoData::mPI
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABGTestModeInfoData, mPI)
    },
    {   // 106 - ::DABGTestModeInfoData::mQFM
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABGTestModeInfoData, mQFM)
    },
    {   // 107 - ::DABGTestModeInfoData::mPL
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABGTestModeInfoData, mPL)
    },
    {   // 108 - ::DAB_Setup_ScreenData
        COURIER_DATA_ITEM_TYPE_ID(::DAB_Setup_ScreenData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 109 - ::DAB_Setup_ScreenData::mServiceLinking
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Setup_ScreenData, mServiceLinking)
    },
    {   // 110 - ::DAB_Setup_ScreenData::mConcealmentLevel
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DAB_Setup_ScreenData, mConcealmentLevel)
    },
    {   // 111 - ::DABGTestModeAnnoStatusInfoData
        COURIER_DATA_ITEM_TYPE_ID(::DABGTestModeAnnoStatusInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 112 - ::DABGTestModeAnnoStatusInfoData::mASW
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABGTestModeAnnoStatusInfoData, mASW)
    },
    {   // 113 - ::DABGTestModeAnnoStatusInfoData::mASU
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABGTestModeAnnoStatusInfoData, mASU)
    },
    {   // 114 - ::DABGTestModeActiveCompData
        COURIER_DATA_ITEM_TYPE_ID(::DABGTestModeActiveCompData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 115 - ::DABGTestModeActiveCompData::mSC
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABGTestModeActiveCompData, mSC)
    },
    {   // 116 - ::DABGTestModeActiveCompData::mSCType
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABGTestModeActiveCompData, mSCType)
    },
    {   // 117 - ::DABTestModeGAvailabiltyInfoData
        COURIER_DATA_ITEM_TYPE_ID(::DABTestModeGAvailabiltyInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 118 - ::DABTestModeGAvailabiltyInfoData::mTA
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABTestModeGAvailabiltyInfoData, mTA)
    },
    {   // 119 - ::DABTestModeGAvailabiltyInfoData::mIndicator
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABTestModeGAvailabiltyInfoData, mIndicator)
    },
    {   // 120 - ::DABTestModeGAvailabiltyInfoData::mDABDAB
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABTestModeGAvailabiltyInfoData, mDABDAB)
    },
    {   // 121 - ::DABTestModeServiceFollowingInfoData
        COURIER_DATA_ITEM_TYPE_ID(::DABTestModeServiceFollowingInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 122 - ::DABTestModeServiceFollowingInfoData::mTSU
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::DABTestModeServiceFollowingInfoData, mTSU)
    },
    {   // 123 - ::EngineeringInfoData
        COURIER_DATA_ITEM_TYPE_ID(::EngineeringInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 124 - ::EngineeringInfoData::m_szFrequency
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoData, m_szFrequency)
    },
    {   // 125 - ::EngineeringInfoData::m_szPSName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoData, m_szPSName)
    },
    {   // 126 - ::EngineeringInfoData::m_szPI
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoData, m_szPI)
    },
    {   // 127 - ::EngineeringInfoData::m_szFieldstrength
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoData, m_szFieldstrength)
    },
    {   // 128 - ::EngineeringInfoData::m_szQuality
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoData, m_szQuality)
    },
    {   // 129 - ::EngineeringInfoData::m_szSharx
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoData, m_szSharx)
    },
    {   // 130 - ::EngineeringInfoData::m_szHicut
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoData, m_szHicut)
    },
    {   // 131 - ::EngineeringInfoData::m_szFMDeviation
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoData, m_szFMDeviation)
    },
    {   // 132 - ::EngineeringInfoData::m_szChannelSeparation
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfoData, m_szChannelSeparation)
    },
    {   // 133 - ::EngineeringInfo1Data
        COURIER_DATA_ITEM_TYPE_ID(::EngineeringInfo1Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 134 - ::EngineeringInfo1Data::mMultipathQuality
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo1Data, mMultipathQuality)
    },
    {   // 135 - ::EngineeringInfo1Data::mnChannel
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo1Data, mnChannel)
    },
    {   // 136 - ::EngineeringInfo1Data::mRDS
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo1Data, mRDS)
    },
    {   // 137 - ::EngineeringInfo1Data::mAntennaStatus
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo1Data, mAntennaStatus)
    },
    {   // 138 - ::EngineeringInfo1Data::mReceptionQuality
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo1Data, mReceptionQuality)
    },
    {   // 139 - ::EngineeringInfo1Data::mSzSharx
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo1Data, mSzSharx)
    },
    {   // 140 - ::EngineeringInfo1Data::mSzHicut
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo1Data, mSzHicut)
    },
    {   // 141 - ::EngineeringInfo1Data::mTPFlag
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo1Data, mTPFlag)
    },
    {   // 142 - ::EngineeringInfo2Data
        COURIER_DATA_ITEM_TYPE_ID(::EngineeringInfo2Data),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 143 - ::EngineeringInfo2Data::mTAFlag
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo2Data, mTAFlag)
    },
    {   // 144 - ::EngineeringInfo2Data::mAltFrequency
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo2Data, mAltFrequency)
    },
    {   // 145 - ::EngineeringInfo2Data::mAFonOff
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::EngineeringInfo2Data, mAFonOff)
    },
    {   // 146 - ::EngineeringInfo2Data::mBandscanOnOff
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::EngineeringInfo2Data, mBandscanOnOff)
    },
    {   // 147 - ::EngineeringInfo2Data::mMeasureOnOff
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::EngineeringInfo2Data, mMeasureOnOff)
    },
    {   // 148 - ::EngineeringInfo2Data::mFreqStepFM
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo2Data, mFreqStepFM)
    },
    {   // 149 - ::EngineeringInfo2Data::mFreqStepAM
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo2Data, mFreqStepAM)
    },
    {   // 150 - ::EngineeringInfo2Data::mRFLevelAM
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo2Data, mRFLevelAM)
    },
    {   // 151 - ::EngineeringInfo2Data::mLinearAudio
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::EngineeringInfo2Data, mLinearAudio)
    },
    {   // 152 - ::EngineeringInfo2Data::mAMTuner
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo2Data, mAMTuner)
    },
    {   // 153 - ::EngineeringInfo2Data::mFMTuner1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo2Data, mFMTuner1)
    },
    {   // 154 - ::EngineeringInfo2Data::mFMTuner2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo2Data, mFMTuner2)
    },
    {   // 155 - ::EngineeringInfo2Data::mFMTuner3
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo2Data, mFMTuner3)
    },
    {   // 156 - ::EngineeringInfo2Data::mFMTuner4
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo2Data, mFMTuner4)
    },
    {   // 157 - ::EngineeringInfo2Data::mDABTuner
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringInfo2Data, mDABTuner)
    },
    {   // 158 - ::TunerSource_BandData
        COURIER_DATA_ITEM_TYPE_ID(::TunerSource_BandData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 159 - ::TunerSource_BandData::mTunerSource1
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::TunerSource_BandData, mTunerSource1)
    },
    {   // 160 - ::TunerSource_BandData::mTunerSource2
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::TunerSource_BandData, mTunerSource2)
    },
    {   // 161 - ::TunerSource_BandData::mTunerSource3
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::TunerSource_BandData, mTunerSource3)
    },
    {   // 162 - ::TunerSource_BandData::mTunerSource4
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::TunerSource_BandData, mTunerSource4)
    },
    {   // 163 - ::TunerSource_BandData::mBandEnable1
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::TunerSource_BandData, mBandEnable1)
    },
    {   // 164 - ::TunerSource_BandData::mBandEnable2
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::TunerSource_BandData, mBandEnable2)
    },
    {   // 165 - ::TunerSource_BandData::mBandEnable3
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::TunerSource_BandData, mBandEnable3)
    },
    {   // 166 - ::TunerSource_BandData::mBandEnable4
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::TunerSource_BandData, mBandEnable4)
    },
    {   // 167 - ::TunerSource_BandData::mBand1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TunerSource_BandData, mBand1)
    },
    {   // 168 - ::TunerSource_BandData::mBand2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TunerSource_BandData, mBand2)
    },
    {   // 169 - ::TunerSource_BandData::mBand3
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TunerSource_BandData, mBand3)
    },
    {   // 170 - ::TunerSource_BandData::mBand4
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TunerSource_BandData, mBand4)
    },
    {   // 171 - ::PresetInfoWBData
        COURIER_DATA_ITEM_TYPE_ID(::PresetInfoWBData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 172 - ::PresetInfoWBData::mWBName1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoWBData, mWBName1)
    },
    {   // 173 - ::PresetInfoWBData::mWBName2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoWBData, mWBName2)
    },
    {   // 174 - ::PresetInfoWBData::mWBName3
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoWBData, mWBName3)
    },
    {   // 175 - ::PresetInfoWBData::mWBName4
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoWBData, mWBName4)
    },
    {   // 176 - ::PresetInfoWBData::mWBName5
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoWBData, mWBName5)
    },
    {   // 177 - ::PresetInfoWBData::mWBName6
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoWBData, mWBName6)
    },
    {   // 178 - ::PresetInfoWBData::mWBName7
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoWBData, mWBName7)
    },
    {   // 179 - ::PresetInfoWBData::mWBName8
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoWBData, mWBName8)
    },
    {   // 180 - ::PresetInfoWBData::mWBName9
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoWBData, mWBName9)
    },
    {   // 181 - ::PresetInfoWBData::mWBName10
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoWBData, mWBName10)
    },
    {   // 182 - ::PresetInfoWBData::mWBmode
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoWBData, mWBmode)
    },
    {   // 183 - ::PresetInfoWBData::mWBFrequency
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoWBData, mWBFrequency)
    },
    {   // 184 - ::WBPresetInfoData
        COURIER_DATA_ITEM_TYPE_ID(::WBPresetInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 185 - ::WBPresetInfoData::mPreset_1_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::WBPresetInfoData, mPreset_1_Active)
    },
    {   // 186 - ::WBPresetInfoData::mPreset_2_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::WBPresetInfoData, mPreset_2_Active)
    },
    {   // 187 - ::WBPresetInfoData::mPreset_3_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::WBPresetInfoData, mPreset_3_Active)
    },
    {   // 188 - ::WBPresetInfoData::mPreset_4_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::WBPresetInfoData, mPreset_4_Active)
    },
    {   // 189 - ::WBPresetInfoData::mPreset_5_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::WBPresetInfoData, mPreset_5_Active)
    },
    {   // 190 - ::WBPresetInfoData::mPreset_6_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::WBPresetInfoData, mPreset_6_Active)
    },
    {   // 191 - ::WBPresetInfoData::mPreset_7_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::WBPresetInfoData, mPreset_7_Active)
    },
    {   // 192 - ::WBPresetInfoData::mPreset_8_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::WBPresetInfoData, mPreset_8_Active)
    },
    {   // 193 - ::WBPresetInfoData::mPreset_9_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::WBPresetInfoData, mPreset_9_Active)
    },
    {   // 194 - ::WBPresetInfoData::mPreset_10_Active
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::WBPresetInfoData, mPreset_10_Active)
    },
    {   // 195 - ::FMSetupMenuInfoData
        COURIER_DATA_ITEM_TYPE_ID(::FMSetupMenuInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 196 - ::FMSetupMenuInfoData::mToggleAF
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::FMSetupMenuInfoData, mToggleAF)
    },
    {   // 197 - ::FMSetupMenuInfoData::mToggleMM
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::FMSetupMenuInfoData, mToggleMM)
    },
    {   // 198 - ::FMSetupMenuInfoData::mToggleTA_status
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::FMSetupMenuInfoData, mToggleTA_status)
    },
    {   // 199 - ::FMSetupMenuInfoData::mToggleRDS
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::FMSetupMenuInfoData, mToggleRDS)
    },
    {   // 200 - ::FMSetupMenuInfoData::mTogglePhaseDiversity
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::FMSetupMenuInfoData, mTogglePhaseDiversity)
    },
    {   // 201 - ::AudioTestModeData
        COURIER_DATA_ITEM_TYPE_ID(::AudioTestModeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 202 - ::AudioTestModeData::mLinearAudio
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AudioTestModeData, mLinearAudio)
    },
    {   // 203 - ::AudioTestModeData::mFMEnhancer
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AudioTestModeData, mFMEnhancer)
    },
    {   // 204 - ::PhoneTestMode_ListItemData
        COURIER_DATA_ITEM_TYPE_ID(::PhoneTestMode_ListItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 205 - ::PhoneTestMode_ListItemData::mTestmodeListItemValue
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PhoneTestMode_ListItemData, mTestmodeListItemValue)
    },
    {   // 206 - ::PhoneTestMode_ListItemData::mTestmodeListItemName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PhoneTestMode_ListItemData, mTestmodeListItemName)
    },
    {   // 207 - ::ListId_FlexData
        COURIER_DATA_ITEM_TYPE_ID(::ListId_FlexData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 208 - ::ListId_FlexData::mTestmodeListId
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ListId_FlexData, mTestmodeListId)
    },
    {   // 209 - ::ListDataSizeData
        COURIER_DATA_ITEM_TYPE_ID(::ListDataSizeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 210 - ::ListDataSizeData::mTestmodeBTListSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt16),
        COURIER_ITEM_MEMBER(::ListDataSizeData, mTestmodeBTListSize)
    },
    {   // 211 - ::SystemSettingTestModeData
        COURIER_DATA_ITEM_TYPE_ID(::SystemSettingTestModeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 212 - ::SystemSettingTestModeData::mSettingScreenTest
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::SystemSettingTestModeData, mSettingScreenTest)
    },
    {   // 213 - ::RVCTestModeData
        COURIER_DATA_ITEM_TYPE_ID(::RVCTestModeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 214 - ::RVCTestModeData::mToggleVisible
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::RVCTestModeData, mToggleVisible)
    },
    {   // 215 - ::SxmChannelInfoData
        COURIER_DATA_ITEM_TYPE_ID(::SxmChannelInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 216 - ::SxmChannelInfoData::mChannelID
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmChannelInfoData, mChannelID)
    },
    {   // 217 - ::SxmChannelInfoData::mCategoryName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmChannelInfoData, mCategoryName)
    },
    {   // 218 - ::SxmChannelInfoData::mArtistName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmChannelInfoData, mArtistName)
    },
    {   // 219 - ::SxmChannelInfoData::mSongTitle
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmChannelInfoData, mSongTitle)
    },
    {   // 220 - ::SxmChannelInfoData::mPresetNumber
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmChannelInfoData, mPresetNumber)
    },
    {   // 221 - ::SxmChannelInfoData::mChannelName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmChannelInfoData, mChannelName)
    },
    {   // 222 - ::SxmChannelInfoData::mSxmCGVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmChannelInfoData, mSxmCGVisibility)
    },
    {   // 223 - ::SxmChannelInfoData::mSxmAlbumartVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmChannelInfoData, mSxmAlbumartVisibility)
    },
    {   // 224 - ::SxmChannelInfoData::mPresetNumberVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmChannelInfoData, mPresetNumberVisibility)
    },
    {   // 225 - ::SxmChannelInfoData::mAdvisoryMessage
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmChannelInfoData, mAdvisoryMessage)
    },
    {   // 226 - ::SxmChannelInfoData::mAdvisoryMessageVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmChannelInfoData, mAdvisoryMessageVisibility)
    },
    {   // 227 - ::SxmChannelInfoData::mStatusLineTextorIcon
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmChannelInfoData, mStatusLineTextorIcon)
    },
    {   // 228 - ::SxmChannelInfoData::mPresetNumberForGadget
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmChannelInfoData, mPresetNumberForGadget)
    },
    {   // 229 - ::SxmChannelInfoData::mSxmInitialized
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmChannelInfoData, mSxmInitialized)
    },
    {   // 230 - ::SxmChannelInfoData::mSongTitleAndArtistName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmChannelInfoData, mSongTitleAndArtistName)
    },
    {   // 231 - ::SxmTpopChannelInfoData
        COURIER_DATA_ITEM_TYPE_ID(::SxmTpopChannelInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 232 - ::SxmTpopChannelInfoData::mChannelID
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmTpopChannelInfoData, mChannelID)
    },
    {   // 233 - ::SxmTpopChannelInfoData::mChannelName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmTpopChannelInfoData, mChannelName)
    },
    {   // 234 - ::PresetInfoSXMData
        COURIER_DATA_ITEM_TYPE_ID(::PresetInfoSXMData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 235 - ::PresetInfoSXMData::mPSName1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoSXMData, mPSName1)
    },
    {   // 236 - ::PresetInfoSXMData::mPSName2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoSXMData, mPSName2)
    },
    {   // 237 - ::PresetInfoSXMData::mPSName3
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoSXMData, mPSName3)
    },
    {   // 238 - ::PresetInfoSXMData::mPSName4
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoSXMData, mPSName4)
    },
    {   // 239 - ::PresetInfoSXMData::mPSName5
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoSXMData, mPSName5)
    },
    {   // 240 - ::PresetInfoSXMData::mPSName6
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoSXMData, mPSName6)
    },
    {   // 241 - ::PresetInfoSXMData::mPSName7
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoSXMData, mPSName7)
    },
    {   // 242 - ::PresetInfoSXMData::mPSName8
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoSXMData, mPSName8)
    },
    {   // 243 - ::PresetInfoSXMData::mPSName9
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoSXMData, mPSName9)
    },
    {   // 244 - ::PresetInfoSXMData::mPSName10
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoSXMData, mPSName10)
    },
    {   // 245 - ::PresetInfoSXMData::mPSName11
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoSXMData, mPSName11)
    },
    {   // 246 - ::PresetInfoSXMData::mPSName12
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoSXMData, mPSName12)
    },
    {   // 247 - ::PresetInfoSXMData::mPSName13
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoSXMData, mPSName13)
    },
    {   // 248 - ::PresetInfoSXMData::mPSName14
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoSXMData, mPSName14)
    },
    {   // 249 - ::PresetInfoSXMData::mPSName15
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoSXMData, mPSName15)
    },
    {   // 250 - ::PresetInfoSXMData::mPSName16
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoSXMData, mPSName16)
    },
    {   // 251 - ::PresetInfoSXMData::mPSName17
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoSXMData, mPSName17)
    },
    {   // 252 - ::PresetInfoSXMData::mPSName18
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PresetInfoSXMData, mPSName18)
    },
    {   // 253 - ::SXMAntennaInfoData
        COURIER_DATA_ITEM_TYPE_ID(::SXMAntennaInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 254 - ::SXMAntennaInfoData::mAntennaStatus
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SXMAntennaInfoData, mAntennaStatus)
    },
    {   // 255 - ::ListScrollBarInfoData
        COURIER_DATA_ITEM_TYPE_ID(::ListScrollBarInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 256 - ::ListScrollBarInfoData::mEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ListScrollBarInfoData, mEnabled)
    },
    {   // 257 - ::CarModeVisibilityData
        COURIER_DATA_ITEM_TYPE_ID(::CarModeVisibilityData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 258 - ::CarModeVisibilityData::mVisibleStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::CarModeVisibilityData, mVisibleStatus)
    },
};

// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gInvalidHierarchyNodes[InvalidDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x00000000, /Invalid),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 0,
        /* mParentIndex        */ 0,    // ItemKey::InvalidItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 0,    // ::InvalidData
        /* mItemKey            */ 0
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gDAB_Test_ModeHierarchyNodes[DAB_Test_ModeDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4B5D0164, /DAB_Test_Mode),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Test_ModeItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 1,    // ::DAB_Test_ModeData
        /* mItemKey            */ 84
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF2A381AD, /DAB_Test_Mode/channel_Num),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Test_ModeItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 2,    // ::DAB_Test_ModeData::mchannel_Num
        /* mItemKey            */ 249
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x70ADC25B, /DAB_Test_Mode/Ensemble_Lbl),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Test_ModeItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 3,    // ::DAB_Test_ModeData::mEnsemble_Lbl
        /* mItemKey            */ 121
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7790764E, /DAB_Test_Mode/Ensemble_ID),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Test_ModeItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 4,    // ::DAB_Test_ModeData::mEnsemble_ID
        /* mItemKey            */ 128
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCB09681F, /DAB_Test_Mode/Service_ID),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Test_ModeItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 5,    // ::DAB_Test_ModeData::mService_ID
        /* mItemKey            */ 213
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x16C78162, /DAB_Test_Mode/Ensemble_freq),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Test_ModeItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 6,    // ::DAB_Test_ModeData::mEnsemble_freq
        /* mItemKey            */ 27
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x050DCB98, /DAB_Test_Mode/Service_Lbl),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Test_ModeItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 7,    // ::DAB_Test_ModeData::mService_Lbl
        /* mItemKey            */ 4
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x71C3511D, /DAB_Test_Mode/Aud_Data_Bit_Rate),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Test_ModeItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 8,    // ::DAB_Test_ModeData::mAud_Data_Bit_Rate
        /* mItemKey            */ 123
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6A4ABCF4, /DAB_Test_Mode/MSC),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Test_ModeItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 9,    // ::DAB_Test_ModeData::mMSC
        /* mItemKey            */ 113
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x19A4B90D, /DAB_Test_Mode/FIC),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Test_ModeItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 10,    // ::DAB_Test_ModeData::mFIC
        /* mItemKey            */ 31
    },
    { // 10
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB95BF064, /DAB_Test_Mode/NetbitErrorrate),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Test_ModeItem
        /* mLocalIndex         */ 10,
        /* mDescriptorIndex    */ 11,    // ::DAB_Test_ModeData::mNetbitErrorrate
        /* mItemKey            */ 191
    },
    { // 11
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE2C47B1C, /DAB_Test_Mode/NET),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Test_ModeItem
        /* mLocalIndex         */ 11,
        /* mDescriptorIndex    */ 12,    // ::DAB_Test_ModeData::mNET
        /* mItemKey            */ 237
    },
    { // 12
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6BEBFD5D, /DAB_Test_Mode/RS_FEC),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Test_ModeItem
        /* mLocalIndex         */ 12,
        /* mDescriptorIndex    */ 13,    // ::DAB_Test_ModeData::mRS_FEC
        /* mItemKey            */ 115
    },
    { // 13
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0268635F, /DAB_Test_Mode/Sync_flag),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Test_ModeItem
        /* mLocalIndex         */ 13,
        /* mDescriptorIndex    */ 14,    // ::DAB_Test_ModeData::mSync_flag
        /* mItemKey            */ 3
    },
    { // 14
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1CE79AB2, /DAB_Test_Mode/QA),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Test_ModeItem
        /* mLocalIndex         */ 14,
        /* mDescriptorIndex    */ 15,    // ::DAB_Test_ModeData::mQA
        /* mItemKey            */ 35
    },
    { // 15
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xAE05BCF0, /DAB_Test_Mode/QS),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Test_ModeItem
        /* mLocalIndex         */ 15,
        /* mDescriptorIndex    */ 16,    // ::DAB_Test_ModeData::mQS
        /* mItemKey            */ 181
    },
    { // 16
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7517B9CC, /DAB_Test_Mode/Field_Strength),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Test_ModeItem
        /* mLocalIndex         */ 16,
        /* mDescriptorIndex    */ 17,    // ::DAB_Test_ModeData::mField_Strength
        /* mItemKey            */ 127
    },
    { // 17
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC9D16EE4, /DAB_Test_Mode/Mute_flag),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Test_ModeItem
        /* mLocalIndex         */ 17,
        /* mDescriptorIndex    */ 18,    // ::DAB_Test_ModeData::mMute_flag
        /* mItemKey            */ 210
    },
    { // 18
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE08094E4, /DAB_Test_Mode/Bg_tuner_ens_freq),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Test_ModeItem
        /* mLocalIndex         */ 18,
        /* mDescriptorIndex    */ 19,    // ::DAB_Test_ModeData::mBg_tuner_ens_freq
        /* mItemKey            */ 235
    },
    { // 19
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xECBB1F9D, /DAB_Test_Mode/Bg_Ensemble_ID),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Test_ModeItem
        /* mLocalIndex         */ 19,
        /* mDescriptorIndex    */ 20,    // ::DAB_Test_ModeData::mBg_Ensemble_ID
        /* mItemKey            */ 243
    },
    { // 20
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x41E67852, /DAB_Test_Mode/Bg_FIC),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Test_ModeItem
        /* mLocalIndex         */ 20,
        /* mDescriptorIndex    */ 21,    // ::DAB_Test_ModeData::mBg_FIC
        /* mItemKey            */ 73
    },
    { // 21
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6A278968, /DAB_Test_Mode/Audio_Mode),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Test_ModeItem
        /* mLocalIndex         */ 21,
        /* mDescriptorIndex    */ 22,    // ::DAB_Test_ModeData::mAudio_Mode
        /* mItemKey            */ 112
    },
    { // 22
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x941AB441, /DAB_Test_Mode/Freq_Table),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Test_ModeItem
        /* mLocalIndex         */ 22,
        /* mDescriptorIndex    */ 23,    // ::DAB_Test_ModeData::mFreq_Table
        /* mItemKey            */ 156
    },
    { // 23
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEEE95F6A, /DAB_Test_Mode/BGMode),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Test_ModeItem
        /* mLocalIndex         */ 23,
        /* mDescriptorIndex    */ 24,    // ::DAB_Test_ModeData::mBGMode
        /* mItemKey            */ 246
    },
    { // 24
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x65FE8BC5, /DAB_Test_Mode/BGSync_flag),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Test_ModeItem
        /* mLocalIndex         */ 24,
        /* mDescriptorIndex    */ 25,    // ::DAB_Test_ModeData::mBGSync_flag
        /* mItemKey            */ 108
    },
    { // 25
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4E7517AA, /DAB_Test_Mode/TASrc),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Test_ModeItem
        /* mLocalIndex         */ 25,
        /* mDescriptorIndex    */ 26,    // ::DAB_Test_ModeData::mTASrc
        /* mItemKey            */ 87
    },
    { // 26
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8C558E2D, /DAB_Test_Mode/DABIconVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Test_ModeItem
        /* mLocalIndex         */ 26,
        /* mDescriptorIndex    */ 27,    // ::DAB_Test_ModeData::mDABIconVisibility
        /* mItemKey            */ 146
    },
    { // 27
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA1A0A523, /DAB_Test_Mode/SXMIconVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Test_ModeItem
        /* mLocalIndex         */ 27,
        /* mDescriptorIndex    */ 28,    // ::DAB_Test_ModeData::mSXMIconVisibility
        /* mItemKey            */ 166
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gDAB_Setup_Screen_ActiveTuner_InfoHierarchyNodes[DAB_Setup_Screen_ActiveTuner_InfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4FD1732A, /DAB_Setup_Screen_ActiveTuner_Info),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Setup_Screen_ActiveTuner_InfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 29,    // ::DAB_Setup_Screen_ActiveTuner_InfoData
        /* mItemKey            */ 88
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBAB5C095, /DAB_Setup_Screen_ActiveTuner_Info/DRC),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Setup_Screen_ActiveTuner_InfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 30,    // ::DAB_Setup_Screen_ActiveTuner_InfoData::mDRC
        /* mItemKey            */ 194
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6DD7D7FF, /DAB_Setup_Screen_ActiveTuner_Info/PS),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Setup_Screen_ActiveTuner_InfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 31,    // ::DAB_Setup_Screen_ActiveTuner_InfoData::mPS
        /* mItemKey            */ 118
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x93B6FA01, /DAB_Setup_Screen_ActiveTuner_Info/SM_ACC),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Setup_Screen_ActiveTuner_InfoItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 32,    // ::DAB_Setup_Screen_ActiveTuner_InfoData::mSM_ACC
        /* mItemKey            */ 155
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1BC6372D, /DAB_Setup_Screen_ActiveTuner_Info/SR),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Setup_Screen_ActiveTuner_InfoItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 33,    // ::DAB_Setup_Screen_ActiveTuner_InfoData::mSR
        /* mItemKey            */ 34
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1DE1D774, /DAB_Setup_Screen_ActiveTuner_Info/TP),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Setup_Screen_ActiveTuner_InfoItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 34,    // ::DAB_Setup_Screen_ActiveTuner_InfoData::mTP
        /* mItemKey            */ 36
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSmart_InfoHierarchyNodes[Smart_InfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBFF41DE3, /Smart_Info),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::Smart_InfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 35,    // ::Smart_InfoData
        /* mItemKey            */ 201
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x424B258D, /Smart_Info/NaviIconVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::Smart_InfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 36,    // ::Smart_InfoData::mNaviIconVisibility
        /* mItemKey            */ 74
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA9305843, /Smart_Info/CameraIconVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::Smart_InfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 37,    // ::Smart_InfoData::mCameraIconVisibility
        /* mItemKey            */ 177
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBC07A56D, /Smart_Info/NaviIconVisibility_CC),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::Smart_InfoItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 38,    // ::Smart_InfoData::mNaviIconVisibility_CC
        /* mItemKey            */ 196
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gDABTestModeEnsembleInfoHierarchyNodes[DABTestModeEnsembleInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBF697CEB, /DABTestModeEnsembleInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::DABTestModeEnsembleInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 39,    // ::DABTestModeEnsembleInfoData
        /* mItemKey            */ 199
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8D873E33, /DABTestModeEnsembleInfo/NoOfAud_DataServiceComp),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::DABTestModeEnsembleInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 40,    // ::DABTestModeEnsembleInfoData::mNoOfAud_DataServiceComp
        /* mItemKey            */ 148
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xAAC84243, /DABTestModeEnsembleInfo/NoOfAud_DataService),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::DABTestModeEnsembleInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 41,    // ::DABTestModeEnsembleInfoData::mNoOfAud_DataService
        /* mItemKey            */ 179
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x65EF246F, /DABTestModeEnsembleInfo/NoOfEnsembles),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::DABTestModeEnsembleInfoItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 42,    // ::DABTestModeEnsembleInfoData::mNoOfEnsembles
        /* mItemKey            */ 107
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gHealthCareMonitorDTCinfoHierarchyNodes[HealthCareMonitorDTCinfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8480E638, /HealthCareMonitorDTCinfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::HealthCareMonitorDTCinfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 43,    // ::HealthCareMonitorDTCinfoData
        /* mItemKey            */ 142
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCA9112C5, /HealthCareMonitorDTCinfo/HCMDTCline1),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::HealthCareMonitorDTCinfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 44,    // ::HealthCareMonitorDTCinfoData::mHCMDTCline1
        /* mItemKey            */ 212
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD58D28BD, /HealthCareMonitorDTCinfo/HCMDTCline2),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::HealthCareMonitorDTCinfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 45,    // ::HealthCareMonitorDTCinfoData::mHCMDTCline2
        /* mItemKey            */ 225
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA7124BC8, /HealthCareMonitorDTCinfo/HCMDTCline3),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::HealthCareMonitorDTCinfoItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 46,    // ::HealthCareMonitorDTCinfoData::mHCMDTCline3
        /* mItemKey            */ 174
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gTuner1HierarchyNodes[Tuner1DataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8BF7149B, /Tuner1),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::Tuner1Item
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 47,    // ::Tuner1Data
        /* mItemKey            */ 145
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2C8CD162, /Tuner1/Freq),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::Tuner1Item
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 48,    // ::Tuner1Data::mFreq
        /* mItemKey            */ 53
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x57651843, /Tuner1/PI),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::Tuner1Item
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 49,    // ::Tuner1Data::mPI
        /* mItemKey            */ 96
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x18CD1B7C, /Tuner1/PS),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::Tuner1Item
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 50,    // ::Tuner1Data::mPS
        /* mItemKey            */ 30
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5B580F71, /Tuner1/FSQ),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::Tuner1Item
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 51,    // ::Tuner1Data::mFSQ
        /* mItemKey            */ 100
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3BEBF977, /Tuner1/Hicut),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::Tuner1Item
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 52,    // ::Tuner1Data::mHicut
        /* mItemKey            */ 66
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6D3B940E, /Tuner1/Sharx),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::Tuner1Item
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 53,    // ::Tuner1Data::mSharx
        /* mItemKey            */ 117
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDD912001, /Tuner1/TP),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::Tuner1Item
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 54,    // ::Tuner1Data::mTP
        /* mItemKey            */ 233
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4B49FB71, /Tuner1/TA),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::Tuner1Item
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 55,    // ::Tuner1Data::mTA
        /* mItemKey            */ 83
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0866127A, /Tuner1/RDS),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::Tuner1Item
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 56,    // ::Tuner1Data::mRDS
        /* mItemKey            */ 11
    },
    { // 10
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x81C6DB4E, /Tuner1/AF),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::Tuner1Item
        /* mLocalIndex         */ 10,
        /* mDescriptorIndex    */ 57,    // ::Tuner1Data::mAF
        /* mItemKey            */ 139
    },
    { // 11
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA0290507, /Tuner1/Dev),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::Tuner1Item
        /* mLocalIndex         */ 11,
        /* mDescriptorIndex    */ 58,    // ::Tuner1Data::mDev
        /* mItemKey            */ 164
    },
    { // 12
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7E84CE76, /Tuner1/CS),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::Tuner1Item
        /* mLocalIndex         */ 12,
        /* mDescriptorIndex    */ 59,    // ::Tuner1Data::mCS
        /* mItemKey            */ 136
    },
    { // 13
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEF99CD95, /Tuner1/MPNC),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::Tuner1Item
        /* mLocalIndex         */ 13,
        /* mDescriptorIndex    */ 60,    // ::Tuner1Data::mMPNC
        /* mItemKey            */ 247
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gTuner2HierarchyNodes[Tuner2DataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6715CAD9, /Tuner2),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 7,
        /* mParentIndex        */ 0,    // ItemKey::Tuner2Item
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 61,    // ::Tuner2Data
        /* mItemKey            */ 109
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBD5A70CF, /Tuner2/Freq),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 7,
        /* mParentIndex        */ 0,    // ItemKey::Tuner2Item
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 62,    // ::Tuner2Data::mFreq
        /* mItemKey            */ 197
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3A441E1D, /Tuner2/PI),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 7,
        /* mParentIndex        */ 0,    // ItemKey::Tuner2Item
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 63,    // ::Tuner2Data::mPI
        /* mItemKey            */ 64
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x744B122A, /Tuner2/PS),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 7,
        /* mParentIndex        */ 0,    // ItemKey::Tuner2Item
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 64,    // ::Tuner2Data::mPS
        /* mItemKey            */ 124
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x70FBC764, /Tuner2/FSQ),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 7,
        /* mParentIndex        */ 0,    // ItemKey::Tuner2Item
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 65,    // ::Tuner2Data::mFSQ
        /* mItemKey            */ 122
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x611A5515, /Tuner2/Hicut),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 7,
        /* mParentIndex        */ 0,    // ItemKey::Tuner2Item
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 66,    // ::Tuner2Data::mHicut
        /* mItemKey            */ 104
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF23A652D, /Tuner2/Sharx),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 7,
        /* mParentIndex        */ 0,    // ItemKey::Tuner2Item
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 67,    // ::Tuner2Data::mSharx
        /* mItemKey            */ 248
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2DEB09C7, /Tuner2/TP),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 7,
        /* mParentIndex        */ 0,    // ItemKey::Tuner2Item
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 68,    // ::Tuner2Data::mTP
        /* mItemKey            */ 55
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2DE389BC, /Tuner2/TA),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 7,
        /* mParentIndex        */ 0,    // ItemKey::Tuner2Item
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 69,    // ::Tuner2Data::mTA
        /* mItemKey            */ 54
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9196D9C0, /Tuner2/RDS),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 7,
        /* mParentIndex        */ 0,    // ItemKey::Tuner2Item
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 70,    // ::Tuner2Data::mRDS
        /* mItemKey            */ 153
    },
    { // 10
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7CDEFFF9, /Tuner2/AF),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 7,
        /* mParentIndex        */ 0,    // ItemKey::Tuner2Item
        /* mLocalIndex         */ 10,
        /* mDescriptorIndex    */ 71,    // ::Tuner2Data::mAF
        /* mItemKey            */ 133
    },
    { // 11
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9BC613B8, /Tuner2/Dev),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 7,
        /* mParentIndex        */ 0,    // ItemKey::Tuner2Item
        /* mLocalIndex         */ 11,
        /* mDescriptorIndex    */ 72,    // ::Tuner2Data::mDev
        /* mItemKey            */ 162
    },
    { // 12
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBB1BFEAA, /Tuner2/CS),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 7,
        /* mParentIndex        */ 0,    // ItemKey::Tuner2Item
        /* mLocalIndex         */ 12,
        /* mDescriptorIndex    */ 73,    // ::Tuner2Data::mCS
        /* mItemKey            */ 195
    },
    { // 13
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDD00E99B, /Tuner2/MPNC),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 7,
        /* mParentIndex        */ 0,    // ItemKey::Tuner2Item
        /* mLocalIndex         */ 13,
        /* mDescriptorIndex    */ 74,    // ::Tuner2Data::mMPNC
        /* mItemKey            */ 231
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gTuner3HierarchyNodes[Tuner3DataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x79546F56, /Tuner3),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 8,
        /* mParentIndex        */ 0,    // ItemKey::Tuner3Item
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 75,    // ::Tuner3Data
        /* mItemKey            */ 129
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF70CD3AD, /Tuner3/Freq),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 8,
        /* mParentIndex        */ 0,    // ItemKey::Tuner3Item
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 76,    // ::Tuner3Data::mFreq
        /* mItemKey            */ 252
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC5920875, /Tuner3/PI),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 8,
        /* mParentIndex        */ 0,    // ItemKey::Tuner3Item
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 77,    // ::Tuner3Data::mPI
        /* mItemKey            */ 206
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x10D29EF9, /Tuner3/PS),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 8,
        /* mParentIndex        */ 0,    // ItemKey::Tuner3Item
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 78,    // ::Tuner3Data::mPS
        /* mItemKey            */ 20
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA6A4950B, /Tuner3/FSQ),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 8,
        /* mParentIndex        */ 0,    // ItemKey::Tuner3Item
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 79,    // ::Tuner3Data::mFSQ
        /* mItemKey            */ 172
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFA31C2B1, /Tuner3/Hicut),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 8,
        /* mParentIndex        */ 0,    // ItemKey::Tuner3Item
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 80,    // ::Tuner3Data::mHicut
        /* mItemKey            */ 254
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA93649A0, /Tuner3/Sharx),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 8,
        /* mParentIndex        */ 0,    // ItemKey::Tuner3Item
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 81,    // ::Tuner3Data::mSharx
        /* mItemKey            */ 178
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA0762FBE, /Tuner3/TP),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 8,
        /* mParentIndex        */ 0,    // ItemKey::Tuner3Item
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 82,    // ::Tuner3Data::mTP
        /* mItemKey            */ 165
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD3D796A0, /Tuner3/TA),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 8,
        /* mParentIndex        */ 0,    // ItemKey::Tuner3Item
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 83,    // ::Tuner3Data::mTA
        /* mItemKey            */ 222
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x052BA9FE, /Tuner3/RDS),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 8,
        /* mParentIndex        */ 0,    // ItemKey::Tuner3Item
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 84,    // ::Tuner3Data::mRDS
        /* mItemKey            */ 5
    },
    { // 10
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x82A25FEB, /Tuner3/AF),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 8,
        /* mParentIndex        */ 0,    // ItemKey::Tuner3Item
        /* mLocalIndex         */ 10,
        /* mDescriptorIndex    */ 85,    // ::Tuner3Data::mAF
        /* mItemKey            */ 141
    },
    { // 11
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC5354700, /Tuner3/Dev),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 8,
        /* mParentIndex        */ 0,    // ItemKey::Tuner3Item
        /* mLocalIndex         */ 11,
        /* mDescriptorIndex    */ 86,    // ::Tuner3Data::mDev
        /* mItemKey            */ 205
    },
    { // 12
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0ADB7287, /Tuner3/CS),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 8,
        /* mParentIndex        */ 0,    // ItemKey::Tuner3Item
        /* mLocalIndex         */ 12,
        /* mDescriptorIndex    */ 87,    // ::Tuner3Data::mCS
        /* mItemKey            */ 13
    },
    { // 13
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x22A7C860, /Tuner3/MPNC),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 8,
        /* mParentIndex        */ 0,    // ItemKey::Tuner3Item
        /* mLocalIndex         */ 13,
        /* mDescriptorIndex    */ 88,    // ::Tuner3Data::mMPNC
        /* mItemKey            */ 43
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gTuner4HierarchyNodes[Tuner4DataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF471658E, /Tuner4),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::Tuner4Item
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 89,    // ::Tuner4Data
        /* mItemKey            */ 250
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7BABD688, /Tuner4/Freq),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::Tuner4Item
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 90,    // ::Tuner4Data::mFreq
        /* mItemKey            */ 132
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x96699A5F, /Tuner4/PI),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::Tuner4Item
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 91,    // ::Tuner4Data::mPI
        /* mItemKey            */ 160
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x40F4EF6B, /Tuner4/PS),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::Tuner4Item
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 92,    // ::Tuner4Data::mPS
        /* mItemKey            */ 72
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x561399C2, /Tuner4/FSQ),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::Tuner4Item
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 93,    // ::Tuner4Data::mFSQ
        /* mItemKey            */ 95
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x488408D7, /Tuner4/Hicut),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::Tuner4Item
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 94,    // ::Tuner4Data::mHicut
        /* mItemKey            */ 79
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA69BD13E, /Tuner4/Sharx),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::Tuner4Item
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 95,    // ::Tuner4Data::mSharx
        /* mItemKey            */ 171
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x593124CB, /Tuner4/TP),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::Tuner4Item
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 96,    // ::Tuner4Data::mTP
        /* mItemKey            */ 98
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x469CFFA7, /Tuner4/TA),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::Tuner4Item
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 97,    // ::Tuner4Data::mTA
        /* mItemKey            */ 76
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x137B2F5B, /Tuner4/RDS),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::Tuner4Item
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 98,    // ::Tuner4Data::mRDS
        /* mItemKey            */ 24
    },
    { // 10
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF534B2AF, /Tuner4/AF),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::Tuner4Item
        /* mLocalIndex         */ 10,
        /* mDescriptorIndex    */ 99,    // ::Tuner4Data::mAF
        /* mItemKey            */ 251
    },
    { // 11
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x507D2430, /Tuner4/Dev),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::Tuner4Item
        /* mLocalIndex         */ 11,
        /* mDescriptorIndex    */ 100,    // ::Tuner4Data::mDev
        /* mItemKey            */ 90
    },
    { // 12
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFAA3A3E5, /Tuner4/CS),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::Tuner4Item
        /* mLocalIndex         */ 12,
        /* mDescriptorIndex    */ 101,    // ::Tuner4Data::mCS
        /* mItemKey            */ 255
    },
    { // 13
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3AF99FA5, /Tuner4/MPNC),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::Tuner4Item
        /* mLocalIndex         */ 13,
        /* mDescriptorIndex    */ 102,    // ::Tuner4Data::mMPNC
        /* mItemKey            */ 65
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gDABGTestModeInfoHierarchyNodes[DABGTestModeInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC71A3EDA, /DABGTestModeInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 10,
        /* mParentIndex        */ 0,    // ItemKey::DABGTestModeInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 103,    // ::DABGTestModeInfoData
        /* mItemKey            */ 209
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3EE04484, /DABGTestModeInfo/FM),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 10,
        /* mParentIndex        */ 0,    // ItemKey::DABGTestModeInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 104,    // ::DABGTestModeInfoData::mFM
        /* mItemKey            */ 68
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x40851806, /DABGTestModeInfo/PI),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 10,
        /* mParentIndex        */ 0,    // ItemKey::DABGTestModeInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 105,    // ::DABGTestModeInfoData::mPI
        /* mItemKey            */ 71
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x22A754F4, /DABGTestModeInfo/QFM),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 10,
        /* mParentIndex        */ 0,    // ItemKey::DABGTestModeInfoItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 106,    // ::DABGTestModeInfoData::mQFM
        /* mItemKey            */ 42
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xAEBDF476, /DABGTestModeInfo/PL),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 10,
        /* mParentIndex        */ 0,    // ItemKey::DABGTestModeInfoItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 107,    // ::DABGTestModeInfoData::mPL
        /* mItemKey            */ 183
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gDAB_Setup_ScreenHierarchyNodes[DAB_Setup_ScreenDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA832CE7E, /DAB_Setup_Screen),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 11,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Setup_ScreenItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 108,    // ::DAB_Setup_ScreenData
        /* mItemKey            */ 175
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFEF6CE2F, /DAB_Setup_Screen/ServiceLinking),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 11,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Setup_ScreenItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 109,    // ::DAB_Setup_ScreenData::mServiceLinking
        /* mItemKey            */ 258
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFDE17023, /DAB_Setup_Screen/ConcealmentLevel),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 11,
        /* mParentIndex        */ 0,    // ItemKey::DAB_Setup_ScreenItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 110,    // ::DAB_Setup_ScreenData::mConcealmentLevel
        /* mItemKey            */ 257
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gDABGTestModeAnnoStatusInfoHierarchyNodes[DABGTestModeAnnoStatusInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE8F55314, /DABGTestModeAnnoStatusInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 12,
        /* mParentIndex        */ 0,    // ItemKey::DABGTestModeAnnoStatusInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 111,    // ::DABGTestModeAnnoStatusInfoData
        /* mItemKey            */ 240
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2F159CA0, /DABGTestModeAnnoStatusInfo/ASW),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 12,
        /* mParentIndex        */ 0,    // ItemKey::DABGTestModeAnnoStatusInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 112,    // ::DABGTestModeAnnoStatusInfoData::mASW
        /* mItemKey            */ 56
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4721CCB8, /DABGTestModeAnnoStatusInfo/ASU),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 12,
        /* mParentIndex        */ 0,    // ItemKey::DABGTestModeAnnoStatusInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 113,    // ::DABGTestModeAnnoStatusInfoData::mASU
        /* mItemKey            */ 77
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gDABGTestModeActiveCompHierarchyNodes[DABGTestModeActiveCompDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC9ED5787, /DABGTestModeActiveComp),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 13,
        /* mParentIndex        */ 0,    // ItemKey::DABGTestModeActiveCompItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 114,    // ::DABGTestModeActiveCompData
        /* mItemKey            */ 211
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD71E2C53, /DABGTestModeActiveComp/SC),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 13,
        /* mParentIndex        */ 0,    // ItemKey::DABGTestModeActiveCompItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 115,    // ::DABGTestModeActiveCompData::mSC
        /* mItemKey            */ 227
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x87E6568A, /DABGTestModeActiveComp/SCType),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 13,
        /* mParentIndex        */ 0,    // ItemKey::DABGTestModeActiveCompItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 116,    // ::DABGTestModeActiveCompData::mSCType
        /* mItemKey            */ 144
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gDABTestModeGAvailabiltyInfoHierarchyNodes[DABTestModeGAvailabiltyInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC604FA3B, /DABTestModeGAvailabiltyInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 14,
        /* mParentIndex        */ 0,    // ItemKey::DABTestModeGAvailabiltyInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 117,    // ::DABTestModeGAvailabiltyInfoData
        /* mItemKey            */ 207
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB34CADA0, /DABTestModeGAvailabiltyInfo/TA),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 14,
        /* mParentIndex        */ 0,    // ItemKey::DABTestModeGAvailabiltyInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 118,    // ::DABTestModeGAvailabiltyInfoData::mTA
        /* mItemKey            */ 187
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA6D5A234, /DABTestModeGAvailabiltyInfo/Indicator),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 14,
        /* mParentIndex        */ 0,    // ItemKey::DABTestModeGAvailabiltyInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 119,    // ::DABTestModeGAvailabiltyInfoData::mIndicator
        /* mItemKey            */ 173
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCB7FF9E0, /DABTestModeGAvailabiltyInfo/DABDAB),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 14,
        /* mParentIndex        */ 0,    // ItemKey::DABTestModeGAvailabiltyInfoItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 120,    // ::DABTestModeGAvailabiltyInfoData::mDABDAB
        /* mItemKey            */ 215
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gDABTestModeServiceFollowingInfoHierarchyNodes[DABTestModeServiceFollowingInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA3640F6E, /DABTestModeServiceFollowingInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::DABTestModeServiceFollowingInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 121,    // ::DABTestModeServiceFollowingInfoData
        /* mItemKey            */ 167
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6EAD3390, /DABTestModeServiceFollowingInfo/TSU),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::DABTestModeServiceFollowingInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 122,    // ::DABTestModeServiceFollowingInfoData::mTSU
        /* mItemKey            */ 119
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gEngineeringInfoHierarchyNodes[EngineeringInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBE92991A, /EngineeringInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 16,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 123,    // ::EngineeringInfoData
        /* mItemKey            */ 198
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3FE60C5C, /EngineeringInfo/_szFrequency),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 16,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 124,    // ::EngineeringInfoData::m_szFrequency
        /* mItemKey            */ 70
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x25DB5399, /EngineeringInfo/_szPSName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 16,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 125,    // ::EngineeringInfoData::m_szPSName
        /* mItemKey            */ 47
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x23A32A1B, /EngineeringInfo/_szPI),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 16,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfoItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 126,    // ::EngineeringInfoData::m_szPI
        /* mItemKey            */ 44
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x228B531E, /EngineeringInfo/_szFieldstrength),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 16,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfoItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 127,    // ::EngineeringInfoData::m_szFieldstrength
        /* mItemKey            */ 41
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3DA88752, /EngineeringInfo/_szQuality),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 16,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfoItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 128,    // ::EngineeringInfoData::m_szQuality
        /* mItemKey            */ 67
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9B9AE131, /EngineeringInfo/_szSharx),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 16,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfoItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 129,    // ::EngineeringInfoData::m_szSharx
        /* mItemKey            */ 161
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4CB778D1, /EngineeringInfo/_szHicut),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 16,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfoItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 130,    // ::EngineeringInfoData::m_szHicut
        /* mItemKey            */ 85
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCF6DBF18, /EngineeringInfo/_szFMDeviation),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 16,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfoItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 131,    // ::EngineeringInfoData::m_szFMDeviation
        /* mItemKey            */ 219
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x54729748, /EngineeringInfo/_szChannelSeparation),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 16,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfoItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 132,    // ::EngineeringInfoData::m_szChannelSeparation
        /* mItemKey            */ 94
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gEngineeringInfo1HierarchyNodes[EngineeringInfo1DataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5F99D1A4, /EngineeringInfo1),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 17,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfo1Item
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 133,    // ::EngineeringInfo1Data
        /* mItemKey            */ 102
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x20BFEE0D, /EngineeringInfo1/MultipathQuality),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 17,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfo1Item
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 134,    // ::EngineeringInfo1Data::mMultipathQuality
        /* mItemKey            */ 40
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x91701657, /EngineeringInfo1/nChannel),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 17,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfo1Item
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 135,    // ::EngineeringInfo1Data::mnChannel
        /* mItemKey            */ 152
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x15003432, /EngineeringInfo1/RDS),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 17,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfo1Item
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 136,    // ::EngineeringInfo1Data::mRDS
        /* mItemKey            */ 26
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x812B4B39, /EngineeringInfo1/AntennaStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 17,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfo1Item
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 137,    // ::EngineeringInfo1Data::mAntennaStatus
        /* mItemKey            */ 138
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5315339C, /EngineeringInfo1/ReceptionQuality),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 17,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfo1Item
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 138,    // ::EngineeringInfo1Data::mReceptionQuality
        /* mItemKey            */ 93
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x38C84FC4, /EngineeringInfo1/SzSharx),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 17,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfo1Item
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 139,    // ::EngineeringInfo1Data::mSzSharx
        /* mItemKey            */ 62
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x319598F7, /EngineeringInfo1/SzHicut),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 17,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfo1Item
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 140,    // ::EngineeringInfo1Data::mSzHicut
        /* mItemKey            */ 57
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x94ED4101, /EngineeringInfo1/TPFlag),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 17,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfo1Item
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 141,    // ::EngineeringInfo1Data::mTPFlag
        /* mItemKey            */ 159
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gEngineeringInfo2HierarchyNodes[EngineeringInfo2DataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x94CE3C10, /EngineeringInfo2),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfo2Item
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 142,    // ::EngineeringInfo2Data
        /* mItemKey            */ 157
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x63808B3D, /EngineeringInfo2/TAFlag),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfo2Item
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 143,    // ::EngineeringInfo2Data::mTAFlag
        /* mItemKey            */ 105
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x060F2C02, /EngineeringInfo2/AltFrequency),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfo2Item
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 144,    // ::EngineeringInfo2Data::mAltFrequency
        /* mItemKey            */ 6
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDA08CC2D, /EngineeringInfo2/AFonOff),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfo2Item
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 145,    // ::EngineeringInfo2Data::mAFonOff
        /* mItemKey            */ 228
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x924AC3A3, /EngineeringInfo2/BandscanOnOff),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfo2Item
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 146,    // ::EngineeringInfo2Data::mBandscanOnOff
        /* mItemKey            */ 154
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC3BD9194, /EngineeringInfo2/MeasureOnOff),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfo2Item
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 147,    // ::EngineeringInfo2Data::mMeasureOnOff
        /* mItemKey            */ 203
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB6C0068A, /EngineeringInfo2/FreqStepFM),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfo2Item
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 148,    // ::EngineeringInfo2Data::mFreqStepFM
        /* mItemKey            */ 189
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x32B1019A, /EngineeringInfo2/FreqStepAM),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfo2Item
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 149,    // ::EngineeringInfo2Data::mFreqStepAM
        /* mItemKey            */ 58
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7A30D234, /EngineeringInfo2/RFLevelAM),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfo2Item
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 150,    // ::EngineeringInfo2Data::mRFLevelAM
        /* mItemKey            */ 130
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBFB7C435, /EngineeringInfo2/LinearAudio),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfo2Item
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 151,    // ::EngineeringInfo2Data::mLinearAudio
        /* mItemKey            */ 200
    },
    { // 10
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8F39B1AC, /EngineeringInfo2/AMTuner),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfo2Item
        /* mLocalIndex         */ 10,
        /* mDescriptorIndex    */ 152,    // ::EngineeringInfo2Data::mAMTuner
        /* mItemKey            */ 150
    },
    { // 11
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x74BEF020, /EngineeringInfo2/FMTuner1),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfo2Item
        /* mLocalIndex         */ 11,
        /* mDescriptorIndex    */ 153,    // ::EngineeringInfo2Data::mFMTuner1
        /* mItemKey            */ 125
    },
    { // 12
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0AF81C94, /EngineeringInfo2/FMTuner2),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfo2Item
        /* mLocalIndex         */ 12,
        /* mDescriptorIndex    */ 154,    // ::EngineeringInfo2Data::mFMTuner2
        /* mItemKey            */ 14
    },
    { // 13
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1A25BAEF, /EngineeringInfo2/FMTuner3),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfo2Item
        /* mLocalIndex         */ 13,
        /* mDescriptorIndex    */ 155,    // ::EngineeringInfo2Data::mFMTuner3
        /* mItemKey            */ 33
    },
    { // 14
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2052C749, /EngineeringInfo2/FMTuner4),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfo2Item
        /* mLocalIndex         */ 14,
        /* mDescriptorIndex    */ 156,    // ::EngineeringInfo2Data::mFMTuner4
        /* mItemKey            */ 39
    },
    { // 15
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x49F0E5BB, /EngineeringInfo2/DABTuner),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::EngineeringInfo2Item
        /* mLocalIndex         */ 15,
        /* mDescriptorIndex    */ 157,    // ::EngineeringInfo2Data::mDABTuner
        /* mItemKey            */ 82
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gTunerSource_BandHierarchyNodes[TunerSource_BandDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3F585003, /TunerSource_Band),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 19,
        /* mParentIndex        */ 0,    // ItemKey::TunerSource_BandItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 158,    // ::TunerSource_BandData
        /* mItemKey            */ 69
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDEDD26DA, /TunerSource_Band/TunerSource1),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 19,
        /* mParentIndex        */ 0,    // ItemKey::TunerSource_BandItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 159,    // ::TunerSource_BandData::mTunerSource1
        /* mItemKey            */ 234
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCCA28265, /TunerSource_Band/TunerSource2),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 19,
        /* mParentIndex        */ 0,    // ItemKey::TunerSource_BandItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 160,    // ::TunerSource_BandData::mTunerSource2
        /* mItemKey            */ 217
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x478A7833, /TunerSource_Band/TunerSource3),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 19,
        /* mParentIndex        */ 0,    // ItemKey::TunerSource_BandItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 161,    // ::TunerSource_BandData::mTunerSource3
        /* mItemKey            */ 78
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x38E8DAF0, /TunerSource_Band/TunerSource4),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 19,
        /* mParentIndex        */ 0,    // ItemKey::TunerSource_BandItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 162,    // ::TunerSource_BandData::mTunerSource4
        /* mItemKey            */ 63
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x17BD4C3F, /TunerSource_Band/BandEnable1),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 19,
        /* mParentIndex        */ 0,    // ItemKey::TunerSource_BandItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 163,    // ::TunerSource_BandData::mBandEnable1
        /* mItemKey            */ 29
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x25EEE8A2, /TunerSource_Band/BandEnable2),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 19,
        /* mParentIndex        */ 0,    // ItemKey::TunerSource_BandItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 164,    // ::TunerSource_BandData::mBandEnable2
        /* mItemKey            */ 48
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x829AA1FC, /TunerSource_Band/BandEnable3),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 19,
        /* mParentIndex        */ 0,    // ItemKey::TunerSource_BandItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 165,    // ::TunerSource_BandData::mBandEnable3
        /* mItemKey            */ 140
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x60515D6A, /TunerSource_Band/BandEnable4),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 19,
        /* mParentIndex        */ 0,    // ItemKey::TunerSource_BandItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 166,    // ::TunerSource_BandData::mBandEnable4
        /* mItemKey            */ 103
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7B437978, /TunerSource_Band/Band1),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 19,
        /* mParentIndex        */ 0,    // ItemKey::TunerSource_BandItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 167,    // ::TunerSource_BandData::mBand1
        /* mItemKey            */ 131
    },
    { // 10
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4D7D9DED, /TunerSource_Band/Band2),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 19,
        /* mParentIndex        */ 0,    // ItemKey::TunerSource_BandItem
        /* mLocalIndex         */ 10,
        /* mDescriptorIndex    */ 168,    // ::TunerSource_BandData::mBand2
        /* mItemKey            */ 86
    },
    { // 11
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x51B9A665, /TunerSource_Band/Band3),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 19,
        /* mParentIndex        */ 0,    // ItemKey::TunerSource_BandItem
        /* mLocalIndex         */ 11,
        /* mDescriptorIndex    */ 169,    // ::TunerSource_BandData::mBand3
        /* mItemKey            */ 92
    },
    { // 12
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x24174B21, /TunerSource_Band/Band4),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 19,
        /* mParentIndex        */ 0,    // ItemKey::TunerSource_BandItem
        /* mLocalIndex         */ 12,
        /* mDescriptorIndex    */ 170,    // ::TunerSource_BandData::mBand4
        /* mItemKey            */ 45
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gPresetInfoWBHierarchyNodes[PresetInfoWBDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x14132170, /PresetInfoWB),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 20,
        /* mParentIndex        */ 0,    // ItemKey::PresetInfoWBItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 171,    // ::PresetInfoWBData
        /* mItemKey            */ 25
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9D0B78F8, /PresetInfoWB/WBName1),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 20,
        /* mParentIndex        */ 0,    // ItemKey::PresetInfoWBItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 172,    // ::PresetInfoWBData::mWBName1
        /* mItemKey            */ 163
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xAF461D6D, /PresetInfoWB/WBName2),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 20,
        /* mParentIndex        */ 0,    // ItemKey::PresetInfoWBItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 173,    // ::PresetInfoWBData::mWBName2
        /* mItemKey            */ 184
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7DA03A22, /PresetInfoWB/WBName3),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 20,
        /* mParentIndex        */ 0,    // ItemKey::PresetInfoWBItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 174,    // ::PresetInfoWBData::mWBName3
        /* mItemKey            */ 135
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8FE2DEA7, /PresetInfoWB/WBName4),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 20,
        /* mParentIndex        */ 0,    // ItemKey::PresetInfoWBItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 175,    // ::PresetInfoWBData::mWBName4
        /* mItemKey            */ 151
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5A45736D, /PresetInfoWB/WBName5),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 20,
        /* mParentIndex        */ 0,    // ItemKey::PresetInfoWBItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 176,    // ::PresetInfoWBData::mWBName5
        /* mItemKey            */ 99
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6C7B17D8, /PresetInfoWB/WBName6),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 20,
        /* mParentIndex        */ 0,    // ItemKey::PresetInfoWBItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 177,    // ::PresetInfoWBData::mWBName6
        /* mItemKey            */ 116
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x246707B1, /PresetInfoWB/WBName7),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 20,
        /* mParentIndex        */ 0,    // ItemKey::PresetInfoWBItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 178,    // ::PresetInfoWBData::mWBName7
        /* mItemKey            */ 46
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x34AD283D, /PresetInfoWB/WBName8),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 20,
        /* mParentIndex        */ 0,    // ItemKey::PresetInfoWBItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 179,    // ::PresetInfoWBData::mWBName8
        /* mItemKey            */ 60
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0F185D14, /PresetInfoWB/WBName9),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 20,
        /* mParentIndex        */ 0,    // ItemKey::PresetInfoWBItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 180,    // ::PresetInfoWBData::mWBName9
        /* mItemKey            */ 16
    },
    { // 10
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7D87A7BA, /PresetInfoWB/WBName10),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 20,
        /* mParentIndex        */ 0,    // ItemKey::PresetInfoWBItem
        /* mLocalIndex         */ 10,
        /* mDescriptorIndex    */ 181,    // ::PresetInfoWBData::mWBName10
        /* mItemKey            */ 134
    },
    { // 11
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE9A1E435, /PresetInfoWB/WBmode),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 20,
        /* mParentIndex        */ 0,    // ItemKey::PresetInfoWBItem
        /* mLocalIndex         */ 11,
        /* mDescriptorIndex    */ 182,    // ::PresetInfoWBData::mWBmode
        /* mItemKey            */ 241
    },
    { // 12
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8CAE7733, /PresetInfoWB/WBFrequency),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 20,
        /* mParentIndex        */ 0,    // ItemKey::PresetInfoWBItem
        /* mLocalIndex         */ 12,
        /* mDescriptorIndex    */ 183,    // ::PresetInfoWBData::mWBFrequency
        /* mItemKey            */ 147
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gWBPresetInfoHierarchyNodes[WBPresetInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x806C6629, /WBPresetInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::WBPresetInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 184,    // ::WBPresetInfoData
        /* mItemKey            */ 137
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x134A1AA9, /WBPresetInfo/Preset_1_Active),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::WBPresetInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 185,    // ::WBPresetInfoData::mPreset_1_Active
        /* mItemKey            */ 23
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x00B666A7, /WBPresetInfo/Preset_2_Active),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::WBPresetInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 186,    // ::WBPresetInfoData::mPreset_2_Active
        /* mItemKey            */ 1
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA5D4B3E3, /WBPresetInfo/Preset_3_Active),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::WBPresetInfoItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 187,    // ::WBPresetInfoData::mPreset_3_Active
        /* mItemKey            */ 170
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEE70A894, /WBPresetInfo/Preset_4_Active),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::WBPresetInfoItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 188,    // ::WBPresetInfoData::mPreset_4_Active
        /* mItemKey            */ 245
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCDFA089D, /WBPresetInfo/Preset_5_Active),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::WBPresetInfoItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 189,    // ::WBPresetInfoData::mPreset_5_Active
        /* mItemKey            */ 218
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA4ADB32C, /WBPresetInfo/Preset_6_Active),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::WBPresetInfoItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 190,    // ::WBPresetInfoData::mPreset_6_Active
        /* mItemKey            */ 168
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x50257320, /WBPresetInfo/Preset_7_Active),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::WBPresetInfoItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 191,    // ::WBPresetInfoData::mPreset_7_Active
        /* mItemKey            */ 89
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEDDC9C59, /WBPresetInfo/Preset_8_Active),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::WBPresetInfoItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 192,    // ::WBPresetInfoData::mPreset_8_Active
        /* mItemKey            */ 244
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8D94F2C3, /WBPresetInfo/Preset_9_Active),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::WBPresetInfoItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 193,    // ::WBPresetInfoData::mPreset_9_Active
        /* mItemKey            */ 149
    },
    { // 10
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB0640B48, /WBPresetInfo/Preset_10_Active),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::WBPresetInfoItem
        /* mLocalIndex         */ 10,
        /* mDescriptorIndex    */ 194,    // ::WBPresetInfoData::mPreset_10_Active
        /* mItemKey            */ 185
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gFMSetupMenuInfoHierarchyNodes[FMSetupMenuInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x48BDAED2, /FMSetupMenuInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 22,
        /* mParentIndex        */ 0,    // ItemKey::FMSetupMenuInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 195,    // ::FMSetupMenuInfoData
        /* mItemKey            */ 81
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCC5A2A34, /FMSetupMenuInfo/ToggleAF),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 22,
        /* mParentIndex        */ 0,    // ItemKey::FMSetupMenuInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 196,    // ::FMSetupMenuInfoData::mToggleAF
        /* mItemKey            */ 216
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x066476DF, /FMSetupMenuInfo/ToggleMM),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 22,
        /* mParentIndex        */ 0,    // ItemKey::FMSetupMenuInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 197,    // ::FMSetupMenuInfoData::mToggleMM
        /* mItemKey            */ 8
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0C361DA2, /FMSetupMenuInfo/ToggleTA_status),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 22,
        /* mParentIndex        */ 0,    // ItemKey::FMSetupMenuInfoItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 198,    // ::FMSetupMenuInfoData::mToggleTA_status
        /* mItemKey            */ 15
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD3E58839, /FMSetupMenuInfo/ToggleRDS),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 22,
        /* mParentIndex        */ 0,    // ItemKey::FMSetupMenuInfoItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 199,    // ::FMSetupMenuInfoData::mToggleRDS
        /* mItemKey            */ 223
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x16D0A750, /FMSetupMenuInfo/TogglePhaseDiversity),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 22,
        /* mParentIndex        */ 0,    // ItemKey::FMSetupMenuInfoItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 200,    // ::FMSetupMenuInfoData::mTogglePhaseDiversity
        /* mItemKey            */ 28
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gAudioTestModeHierarchyNodes[AudioTestModeDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5D5BCD11, /AudioTestMode),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 23,
        /* mParentIndex        */ 0,    // ItemKey::AudioTestModeItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 201,    // ::AudioTestModeData
        /* mItemKey            */ 101
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4885FB79, /AudioTestMode/LinearAudio),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 23,
        /* mParentIndex        */ 0,    // ItemKey::AudioTestModeItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 202,    // ::AudioTestModeData::mLinearAudio
        /* mItemKey            */ 80
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6AB692F2, /AudioTestMode/FMEnhancer),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 23,
        /* mParentIndex        */ 0,    // ItemKey::AudioTestModeItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 203,    // ::AudioTestModeData::mFMEnhancer
        /* mItemKey            */ 114
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gPhoneTestMode_ListItemHierarchyNodes[PhoneTestMode_ListItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x700F4AE8, /PhoneTestMode_ListItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 24,
        /* mParentIndex        */ 0,    // ItemKey::PhoneTestMode_ListItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 204,    // ::PhoneTestMode_ListItemData
        /* mItemKey            */ 120
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCB2E8E08, /PhoneTestMode_ListItem/TestmodeListItemValue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 24,
        /* mParentIndex        */ 0,    // ItemKey::PhoneTestMode_ListItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 205,    // ::PhoneTestMode_ListItemData::mTestmodeListItemValue
        /* mItemKey            */ 214
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB57E45C0, /PhoneTestMode_ListItem/TestmodeListItemName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 24,
        /* mParentIndex        */ 0,    // ItemKey::PhoneTestMode_ListItemItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 206,    // ::PhoneTestMode_ListItemData::mTestmodeListItemName
        /* mItemKey            */ 188
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gListId_FlexHierarchyNodes[ListId_FlexDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2C21DEEA, /ListId_Flex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 25,
        /* mParentIndex        */ 0,    // ItemKey::ListId_FlexItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 207,    // ::ListId_FlexData
        /* mItemKey            */ 51
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x12875144, /ListId_Flex/TestmodeListId),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 25,
        /* mParentIndex        */ 0,    // ItemKey::ListId_FlexItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 208,    // ::ListId_FlexData::mTestmodeListId
        /* mItemKey            */ 22
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gListDataSizeHierarchyNodes[ListDataSizeDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1F89D3F0, /ListDataSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 26,
        /* mParentIndex        */ 0,    // ItemKey::ListDataSizeItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 209,    // ::ListDataSizeData
        /* mItemKey            */ 38
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCFC6F8AE, /ListDataSize/TestmodeBTListSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 26,
        /* mParentIndex        */ 0,    // ItemKey::ListDataSizeItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 210,    // ::ListDataSizeData::mTestmodeBTListSize
        /* mItemKey            */ 220
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSystemSettingTestModeHierarchyNodes[SystemSettingTestModeDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDAAA6DAC, /SystemSettingTestMode),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::SystemSettingTestModeItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 211,    // ::SystemSettingTestModeData
        /* mItemKey            */ 229
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x101FD1DE, /SystemSettingTestMode/SettingScreenTest),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::SystemSettingTestModeItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 212,    // ::SystemSettingTestModeData::mSettingScreenTest
        /* mItemKey            */ 19
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gRVCTestModeHierarchyNodes[RVCTestModeDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD55B1F5F, /RVCTestMode),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 28,
        /* mParentIndex        */ 0,    // ItemKey::RVCTestModeItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 213,    // ::RVCTestModeData
        /* mItemKey            */ 224
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD5E3C330, /RVCTestMode/ToggleVisible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 28,
        /* mParentIndex        */ 0,    // ItemKey::RVCTestModeItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 214,    // ::RVCTestModeData::mToggleVisible
        /* mItemKey            */ 226
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmChannelInfoHierarchyNodes[SxmChannelInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0A2E7FE3, /SxmChannelInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 29,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 215,    // ::SxmChannelInfoData
        /* mItemKey            */ 12
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xAEA1A668, /SxmChannelInfo/ChannelID),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 29,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 216,    // ::SxmChannelInfoData::mChannelID
        /* mItemKey            */ 182
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC0693249, /SxmChannelInfo/CategoryName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 29,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 217,    // ::SxmChannelInfoData::mCategoryName
        /* mItemKey            */ 202
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1166AD4B, /SxmChannelInfo/ArtistName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 29,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 218,    // ::SxmChannelInfoData::mArtistName
        /* mItemKey            */ 21
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA57ABDA7, /SxmChannelInfo/SongTitle),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 29,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 219,    // ::SxmChannelInfoData::mSongTitle
        /* mItemKey            */ 169
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF9CFAC0A, /SxmChannelInfo/PresetNumber),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 29,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 220,    // ::SxmChannelInfoData::mPresetNumber
        /* mItemKey            */ 253
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x06EA7CCA, /SxmChannelInfo/ChannelName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 29,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 221,    // ::SxmChannelInfoData::mChannelName
        /* mItemKey            */ 10
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE63D4ABA, /SxmChannelInfo/SxmCGVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 29,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 222,    // ::SxmChannelInfoData::mSxmCGVisibility
        /* mItemKey            */ 239
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBA3432D1, /SxmChannelInfo/SxmAlbumartVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 29,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 223,    // ::SxmChannelInfoData::mSxmAlbumartVisibility
        /* mItemKey            */ 193
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x26162EE8, /SxmChannelInfo/PresetNumberVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 29,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 224,    // ::SxmChannelInfoData::mPresetNumberVisibility
        /* mItemKey            */ 50
    },
    { // 10
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDBE22E07, /SxmChannelInfo/AdvisoryMessage),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 29,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 10,
        /* mDescriptorIndex    */ 225,    // ::SxmChannelInfoData::mAdvisoryMessage
        /* mItemKey            */ 230
    },
    { // 11
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xAAFB7CA7, /SxmChannelInfo/AdvisoryMessageVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 29,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 11,
        /* mDescriptorIndex    */ 226,    // ::SxmChannelInfoData::mAdvisoryMessageVisibility
        /* mItemKey            */ 180
    },
    { // 12
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x018FCC6C, /SxmChannelInfo/StatusLineTextorIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 29,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 12,
        /* mDescriptorIndex    */ 227,    // ::SxmChannelInfoData::mStatusLineTextorIcon
        /* mItemKey            */ 2
    },
    { // 13
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7508FBE6, /SxmChannelInfo/PresetNumberForGadget),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 29,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 13,
        /* mDescriptorIndex    */ 228,    // ::SxmChannelInfoData::mPresetNumberForGadget
        /* mItemKey            */ 126
    },
    { // 14
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFBEC37F1, /SxmChannelInfo/SxmInitialized),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 29,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 14,
        /* mDescriptorIndex    */ 229,    // ::SxmChannelInfoData::mSxmInitialized
        /* mItemKey            */ 256
    },
    { // 15
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC6922618, /SxmChannelInfo/SongTitleAndArtistName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 29,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 15,
        /* mDescriptorIndex    */ 230,    // ::SxmChannelInfoData::mSongTitleAndArtistName
        /* mItemKey            */ 208
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmTpopChannelInfoHierarchyNodes[SxmTpopChannelInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x37A7310A, /SxmTpopChannelInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 30,
        /* mParentIndex        */ 0,    // ItemKey::SxmTpopChannelInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 231,    // ::SxmTpopChannelInfoData
        /* mItemKey            */ 61
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x06574A17, /SxmTpopChannelInfo/ChannelID),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 30,
        /* mParentIndex        */ 0,    // ItemKey::SxmTpopChannelInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 232,    // ::SxmTpopChannelInfoData::mChannelID
        /* mItemKey            */ 7
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x671F63A6, /SxmTpopChannelInfo/ChannelName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 30,
        /* mParentIndex        */ 0,    // ItemKey::SxmTpopChannelInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 233,    // ::SxmTpopChannelInfoData::mChannelName
        /* mItemKey            */ 110
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gPresetInfoSXMHierarchyNodes[PresetInfoSXMDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x651039A0, /PresetInfoSXM),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 31,
        /* mParentIndex        */ 0,    // ItemKey::PresetInfoSXMItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 234,    // ::PresetInfoSXMData
        /* mItemKey            */ 106
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x347C36F8, /PresetInfoSXM/PSName1),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 31,
        /* mParentIndex        */ 0,    // ItemKey::PresetInfoSXMItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 235,    // ::PresetInfoSXMData::mPSName1
        /* mItemKey            */ 59
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x26051A0A, /PresetInfoSXM/PSName2),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 31,
        /* mParentIndex        */ 0,    // ItemKey::PresetInfoSXMItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 236,    // ::PresetInfoSXMData::mPSName2
        /* mItemKey            */ 49
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x584FFE9F, /PresetInfoSXM/PSName3),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 31,
        /* mParentIndex        */ 0,    // ItemKey::PresetInfoSXMItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 237,    // ::PresetInfoSXMData::mPSName3
        /* mItemKey            */ 97
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB98AC113, /PresetInfoSXM/PSName4),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 31,
        /* mParentIndex        */ 0,    // ItemKey::PresetInfoSXMItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 238,    // ::PresetInfoSXMData::mPSName4
        /* mItemKey            */ 192
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEBDCA5B6, /PresetInfoSXM/PSName5),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 31,
        /* mParentIndex        */ 0,    // ItemKey::PresetInfoSXMItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 239,    // ::PresetInfoSXMData::mPSName5
        /* mItemKey            */ 242
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDD2F885C, /PresetInfoSXM/PSName6),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 31,
        /* mParentIndex        */ 0,    // ItemKey::PresetInfoSXMItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 240,    // ::PresetInfoSXMData::mPSName6
        /* mItemKey            */ 232
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0F666CC9, /PresetInfoSXM/PSName7),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 31,
        /* mParentIndex        */ 0,    // ItemKey::PresetInfoSXMItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 241,    // ::PresetInfoSXMData::mPSName7
        /* mItemKey            */ 17
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x94E377C1, /PresetInfoSXM/PSName8),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 31,
        /* mParentIndex        */ 0,    // ItemKey::PresetInfoSXMItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 242,    // ::PresetInfoSXMData::mPSName8
        /* mItemKey            */ 158
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x87615CBD, /PresetInfoSXM/PSName9),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 31,
        /* mParentIndex        */ 0,    // ItemKey::PresetInfoSXMItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 243,    // ::PresetInfoSXMData::mPSName9
        /* mItemKey            */ 143
    },
    { // 10
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB0D29FC3, /PresetInfoSXM/PSName10),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 31,
        /* mParentIndex        */ 0,    // ItemKey::PresetInfoSXMItem
        /* mLocalIndex         */ 10,
        /* mDescriptorIndex    */ 244,    // ::PresetInfoSXMData::mPSName10
        /* mItemKey            */ 186
    },
    { // 11
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB6CD2BAC, /PresetInfoSXM/PSName11),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 31,
        /* mParentIndex        */ 0,    // ItemKey::PresetInfoSXMItem
        /* mLocalIndex         */ 11,
        /* mDescriptorIndex    */ 245,    // ::PresetInfoSXMData::mPSName11
        /* mItemKey            */ 190
    },
    { // 12
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA8928F37, /PresetInfoSXM/PSName12),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 31,
        /* mParentIndex        */ 0,    // ItemKey::PresetInfoSXMItem
        /* mLocalIndex         */ 12,
        /* mDescriptorIndex    */ 246,    // ::PresetInfoSXMData::mPSName12
        /* mItemKey            */ 176
    },
    { // 13
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD260E2D3, /PresetInfoSXM/PSName13),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 31,
        /* mParentIndex        */ 0,    // ItemKey::PresetInfoSXMItem
        /* mLocalIndex         */ 13,
        /* mDescriptorIndex    */ 247,    // ::PresetInfoSXMData::mPSName13
        /* mItemKey            */ 221
    },
    { // 14
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC40D462C, /PresetInfoSXM/PSName14),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 31,
        /* mParentIndex        */ 0,    // ItemKey::PresetInfoSXMItem
        /* mLocalIndex         */ 14,
        /* mDescriptorIndex    */ 248,    // ::PresetInfoSXMData::mPSName14
        /* mItemKey            */ 204
    },
    { // 15
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0FE2DDD6, /PresetInfoSXM/PSName15),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 31,
        /* mParentIndex        */ 0,    // ItemKey::PresetInfoSXMItem
        /* mLocalIndex         */ 15,
        /* mDescriptorIndex    */ 249,    // ::PresetInfoSXMData::mPSName15
        /* mItemKey            */ 18
    },
    { // 16
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE3C00591, /PresetInfoSXM/PSName16),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 31,
        /* mParentIndex        */ 0,    // ItemKey::PresetInfoSXMItem
        /* mLocalIndex         */ 16,
        /* mDescriptorIndex    */ 250,    // ::PresetInfoSXMData::mPSName16
        /* mItemKey            */ 238
    },
    { // 17
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2C6D16FA, /PresetInfoSXM/PSName17),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 31,
        /* mParentIndex        */ 0,    // ItemKey::PresetInfoSXMItem
        /* mLocalIndex         */ 17,
        /* mDescriptorIndex    */ 251,    // ::PresetInfoSXMData::mPSName17
        /* mItemKey            */ 52
    },
    { // 18
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1E3DFA8C, /PresetInfoSXM/PSName18),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 31,
        /* mParentIndex        */ 0,    // ItemKey::PresetInfoSXMItem
        /* mLocalIndex         */ 18,
        /* mDescriptorIndex    */ 252,    // ::PresetInfoSXMData::mPSName18
        /* mItemKey            */ 37
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSXMAntennaInfoHierarchyNodes[SXMAntennaInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x51B0892C, /SXMAntennaInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 32,
        /* mParentIndex        */ 0,    // ItemKey::SXMAntennaInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 253,    // ::SXMAntennaInfoData
        /* mItemKey            */ 91
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x68025CA9, /SXMAntennaInfo/AntennaStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 32,
        /* mParentIndex        */ 0,    // ItemKey::SXMAntennaInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 254,    // ::SXMAntennaInfoData::mAntennaStatus
        /* mItemKey            */ 111
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gListScrollBarInfoHierarchyNodes[ListScrollBarInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x44E9662C, /ListScrollBarInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 33,
        /* mParentIndex        */ 0,    // ItemKey::ListScrollBarInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 255,    // ::ListScrollBarInfoData
        /* mItemKey            */ 75
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE2697E96, /ListScrollBarInfo/Enabled),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 33,
        /* mParentIndex        */ 0,    // ItemKey::ListScrollBarInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 256,    // ::ListScrollBarInfoData::mEnabled
        /* mItemKey            */ 236
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gCarModeVisibilityHierarchyNodes[CarModeVisibilityDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x06815284, /CarModeVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 34,
        /* mParentIndex        */ 0,    // ItemKey::CarModeVisibilityItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 257,    // ::CarModeVisibilityData
        /* mItemKey            */ 9
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x19B4C071, /CarModeVisibility/VisibleStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 34,
        /* mParentIndex        */ 0,    // ItemKey::CarModeVisibilityItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 258,    // ::CarModeVisibilityData::mVisibleStatus
        /* mItemKey            */ 32
    },
};

// array of pointers to all hierarchy nodes - sorted by HashId
const ::Courier::Internal::DataBinding::DataItemHierarchyNode * const gGlobalHierachyNodeTable[cGlobalDataItemHierarchyNodeCount] = {
    &gInvalidHierarchyNodes[0],
    &gWBPresetInfoHierarchyNodes[2],
    &gSxmChannelInfoHierarchyNodes[12],
    &gDAB_Test_ModeHierarchyNodes[13],
    &gDAB_Test_ModeHierarchyNodes[6],
    &gTuner3HierarchyNodes[9],
    &gEngineeringInfo2HierarchyNodes[2],
    &gSxmTpopChannelInfoHierarchyNodes[1],
    &gFMSetupMenuInfoHierarchyNodes[2],
    &gCarModeVisibilityHierarchyNodes[0],
    &gSxmChannelInfoHierarchyNodes[6],
    &gTuner1HierarchyNodes[9],
    &gSxmChannelInfoHierarchyNodes[0],
    &gTuner3HierarchyNodes[12],
    &gEngineeringInfo2HierarchyNodes[12],
    &gFMSetupMenuInfoHierarchyNodes[3],
    &gPresetInfoWBHierarchyNodes[9],
    &gPresetInfoSXMHierarchyNodes[7],
    &gPresetInfoSXMHierarchyNodes[15],
    &gSystemSettingTestModeHierarchyNodes[1],
    &gTuner3HierarchyNodes[3],
    &gSxmChannelInfoHierarchyNodes[3],
    &gListId_FlexHierarchyNodes[1],
    &gWBPresetInfoHierarchyNodes[1],
    &gTuner4HierarchyNodes[9],
    &gPresetInfoWBHierarchyNodes[0],
    &gEngineeringInfo1HierarchyNodes[3],
    &gDAB_Test_ModeHierarchyNodes[5],
    &gFMSetupMenuInfoHierarchyNodes[5],
    &gTunerSource_BandHierarchyNodes[5],
    &gTuner1HierarchyNodes[3],
    &gDAB_Test_ModeHierarchyNodes[9],
    &gCarModeVisibilityHierarchyNodes[1],
    &gEngineeringInfo2HierarchyNodes[13],
    &gDAB_Setup_Screen_ActiveTuner_InfoHierarchyNodes[4],
    &gDAB_Test_ModeHierarchyNodes[14],
    &gDAB_Setup_Screen_ActiveTuner_InfoHierarchyNodes[5],
    &gPresetInfoSXMHierarchyNodes[18],
    &gListDataSizeHierarchyNodes[0],
    &gEngineeringInfo2HierarchyNodes[14],
    &gEngineeringInfo1HierarchyNodes[1],
    &gEngineeringInfoHierarchyNodes[4],
    &gDABGTestModeInfoHierarchyNodes[3],
    &gTuner3HierarchyNodes[13],
    &gEngineeringInfoHierarchyNodes[3],
    &gTunerSource_BandHierarchyNodes[12],
    &gPresetInfoWBHierarchyNodes[7],
    &gEngineeringInfoHierarchyNodes[2],
    &gTunerSource_BandHierarchyNodes[6],
    &gPresetInfoSXMHierarchyNodes[2],
    &gSxmChannelInfoHierarchyNodes[9],
    &gListId_FlexHierarchyNodes[0],
    &gPresetInfoSXMHierarchyNodes[17],
    &gTuner1HierarchyNodes[1],
    &gTuner2HierarchyNodes[8],
    &gTuner2HierarchyNodes[7],
    &gDABGTestModeAnnoStatusInfoHierarchyNodes[1],
    &gEngineeringInfo1HierarchyNodes[7],
    &gEngineeringInfo2HierarchyNodes[7],
    &gPresetInfoSXMHierarchyNodes[1],
    &gPresetInfoWBHierarchyNodes[8],
    &gSxmTpopChannelInfoHierarchyNodes[0],
    &gEngineeringInfo1HierarchyNodes[6],
    &gTunerSource_BandHierarchyNodes[4],
    &gTuner2HierarchyNodes[2],
    &gTuner4HierarchyNodes[13],
    &gTuner1HierarchyNodes[5],
    &gEngineeringInfoHierarchyNodes[5],
    &gDABGTestModeInfoHierarchyNodes[1],
    &gTunerSource_BandHierarchyNodes[0],
    &gEngineeringInfoHierarchyNodes[1],
    &gDABGTestModeInfoHierarchyNodes[2],
    &gTuner4HierarchyNodes[3],
    &gDAB_Test_ModeHierarchyNodes[20],
    &gSmart_InfoHierarchyNodes[1],
    &gListScrollBarInfoHierarchyNodes[0],
    &gTuner4HierarchyNodes[8],
    &gDABGTestModeAnnoStatusInfoHierarchyNodes[2],
    &gTunerSource_BandHierarchyNodes[3],
    &gTuner4HierarchyNodes[5],
    &gAudioTestModeHierarchyNodes[1],
    &gFMSetupMenuInfoHierarchyNodes[0],
    &gEngineeringInfo2HierarchyNodes[15],
    &gTuner1HierarchyNodes[8],
    &gDAB_Test_ModeHierarchyNodes[0],
    &gEngineeringInfoHierarchyNodes[7],
    &gTunerSource_BandHierarchyNodes[10],
    &gDAB_Test_ModeHierarchyNodes[25],
    &gDAB_Setup_Screen_ActiveTuner_InfoHierarchyNodes[0],
    &gWBPresetInfoHierarchyNodes[7],
    &gTuner4HierarchyNodes[11],
    &gSXMAntennaInfoHierarchyNodes[0],
    &gTunerSource_BandHierarchyNodes[11],
    &gEngineeringInfo1HierarchyNodes[5],
    &gEngineeringInfoHierarchyNodes[9],
    &gTuner4HierarchyNodes[4],
    &gTuner1HierarchyNodes[2],
    &gPresetInfoSXMHierarchyNodes[3],
    &gTuner4HierarchyNodes[7],
    &gPresetInfoWBHierarchyNodes[5],
    &gTuner1HierarchyNodes[4],
    &gAudioTestModeHierarchyNodes[0],
    &gEngineeringInfo1HierarchyNodes[0],
    &gTunerSource_BandHierarchyNodes[8],
    &gTuner2HierarchyNodes[5],
    &gEngineeringInfo2HierarchyNodes[1],
    &gPresetInfoSXMHierarchyNodes[0],
    &gDABTestModeEnsembleInfoHierarchyNodes[3],
    &gDAB_Test_ModeHierarchyNodes[24],
    &gTuner2HierarchyNodes[0],
    &gSxmTpopChannelInfoHierarchyNodes[2],
    &gSXMAntennaInfoHierarchyNodes[1],
    &gDAB_Test_ModeHierarchyNodes[21],
    &gDAB_Test_ModeHierarchyNodes[8],
    &gAudioTestModeHierarchyNodes[2],
    &gDAB_Test_ModeHierarchyNodes[12],
    &gPresetInfoWBHierarchyNodes[6],
    &gTuner1HierarchyNodes[6],
    &gDAB_Setup_Screen_ActiveTuner_InfoHierarchyNodes[2],
    &gDABTestModeServiceFollowingInfoHierarchyNodes[1],
    &gPhoneTestMode_ListItemHierarchyNodes[0],
    &gDAB_Test_ModeHierarchyNodes[2],
    &gTuner2HierarchyNodes[4],
    &gDAB_Test_ModeHierarchyNodes[7],
    &gTuner2HierarchyNodes[3],
    &gEngineeringInfo2HierarchyNodes[11],
    &gSxmChannelInfoHierarchyNodes[13],
    &gDAB_Test_ModeHierarchyNodes[16],
    &gDAB_Test_ModeHierarchyNodes[3],
    &gTuner3HierarchyNodes[0],
    &gEngineeringInfo2HierarchyNodes[8],
    &gTunerSource_BandHierarchyNodes[9],
    &gTuner4HierarchyNodes[1],
    &gTuner2HierarchyNodes[10],
    &gPresetInfoWBHierarchyNodes[10],
    &gPresetInfoWBHierarchyNodes[3],
    &gTuner1HierarchyNodes[12],
    &gWBPresetInfoHierarchyNodes[0],
    &gEngineeringInfo1HierarchyNodes[4],
    &gTuner1HierarchyNodes[10],
    &gTunerSource_BandHierarchyNodes[7],
    &gTuner3HierarchyNodes[10],
    &gHealthCareMonitorDTCinfoHierarchyNodes[0],
    &gPresetInfoSXMHierarchyNodes[9],
    &gDABGTestModeActiveCompHierarchyNodes[2],
    &gTuner1HierarchyNodes[0],
    &gDAB_Test_ModeHierarchyNodes[26],
    &gPresetInfoWBHierarchyNodes[12],
    &gDABTestModeEnsembleInfoHierarchyNodes[1],
    &gWBPresetInfoHierarchyNodes[9],
    &gEngineeringInfo2HierarchyNodes[10],
    &gPresetInfoWBHierarchyNodes[4],
    &gEngineeringInfo1HierarchyNodes[2],
    &gTuner2HierarchyNodes[9],
    &gEngineeringInfo2HierarchyNodes[4],
    &gDAB_Setup_Screen_ActiveTuner_InfoHierarchyNodes[3],
    &gDAB_Test_ModeHierarchyNodes[22],
    &gEngineeringInfo2HierarchyNodes[0],
    &gPresetInfoSXMHierarchyNodes[8],
    &gEngineeringInfo1HierarchyNodes[8],
    &gTuner4HierarchyNodes[2],
    &gEngineeringInfoHierarchyNodes[6],
    &gTuner2HierarchyNodes[11],
    &gPresetInfoWBHierarchyNodes[1],
    &gTuner1HierarchyNodes[11],
    &gTuner3HierarchyNodes[7],
    &gDAB_Test_ModeHierarchyNodes[27],
    &gDABTestModeServiceFollowingInfoHierarchyNodes[0],
    &gWBPresetInfoHierarchyNodes[6],
    &gSxmChannelInfoHierarchyNodes[4],
    &gWBPresetInfoHierarchyNodes[3],
    &gTuner4HierarchyNodes[6],
    &gTuner3HierarchyNodes[4],
    &gDABTestModeGAvailabiltyInfoHierarchyNodes[2],
    &gHealthCareMonitorDTCinfoHierarchyNodes[3],
    &gDAB_Setup_ScreenHierarchyNodes[0],
    &gPresetInfoSXMHierarchyNodes[12],
    &gSmart_InfoHierarchyNodes[2],
    &gTuner3HierarchyNodes[6],
    &gDABTestModeEnsembleInfoHierarchyNodes[2],
    &gSxmChannelInfoHierarchyNodes[11],
    &gDAB_Test_ModeHierarchyNodes[15],
    &gSxmChannelInfoHierarchyNodes[1],
    &gDABGTestModeInfoHierarchyNodes[4],
    &gPresetInfoWBHierarchyNodes[2],
    &gWBPresetInfoHierarchyNodes[10],
    &gPresetInfoSXMHierarchyNodes[10],
    &gDABTestModeGAvailabiltyInfoHierarchyNodes[1],
    &gPhoneTestMode_ListItemHierarchyNodes[2],
    &gEngineeringInfo2HierarchyNodes[6],
    &gPresetInfoSXMHierarchyNodes[11],
    &gDAB_Test_ModeHierarchyNodes[10],
    &gPresetInfoSXMHierarchyNodes[4],
    &gSxmChannelInfoHierarchyNodes[8],
    &gDAB_Setup_Screen_ActiveTuner_InfoHierarchyNodes[1],
    &gTuner2HierarchyNodes[12],
    &gSmart_InfoHierarchyNodes[3],
    &gTuner2HierarchyNodes[1],
    &gEngineeringInfoHierarchyNodes[0],
    &gDABTestModeEnsembleInfoHierarchyNodes[0],
    &gEngineeringInfo2HierarchyNodes[9],
    &gSmart_InfoHierarchyNodes[0],
    &gSxmChannelInfoHierarchyNodes[2],
    &gEngineeringInfo2HierarchyNodes[5],
    &gPresetInfoSXMHierarchyNodes[14],
    &gTuner3HierarchyNodes[11],
    &gTuner3HierarchyNodes[2],
    &gDABTestModeGAvailabiltyInfoHierarchyNodes[0],
    &gSxmChannelInfoHierarchyNodes[15],
    &gDABGTestModeInfoHierarchyNodes[0],
    &gDAB_Test_ModeHierarchyNodes[17],
    &gDABGTestModeActiveCompHierarchyNodes[0],
    &gHealthCareMonitorDTCinfoHierarchyNodes[1],
    &gDAB_Test_ModeHierarchyNodes[4],
    &gPhoneTestMode_ListItemHierarchyNodes[1],
    &gDABTestModeGAvailabiltyInfoHierarchyNodes[3],
    &gFMSetupMenuInfoHierarchyNodes[1],
    &gTunerSource_BandHierarchyNodes[2],
    &gWBPresetInfoHierarchyNodes[5],
    &gEngineeringInfoHierarchyNodes[8],
    &gListDataSizeHierarchyNodes[1],
    &gPresetInfoSXMHierarchyNodes[13],
    &gTuner3HierarchyNodes[8],
    &gFMSetupMenuInfoHierarchyNodes[4],
    &gRVCTestModeHierarchyNodes[0],
    &gHealthCareMonitorDTCinfoHierarchyNodes[2],
    &gRVCTestModeHierarchyNodes[1],
    &gDABGTestModeActiveCompHierarchyNodes[1],
    &gEngineeringInfo2HierarchyNodes[3],
    &gSystemSettingTestModeHierarchyNodes[0],
    &gSxmChannelInfoHierarchyNodes[10],
    &gTuner2HierarchyNodes[13],
    &gPresetInfoSXMHierarchyNodes[6],
    &gTuner1HierarchyNodes[7],
    &gTunerSource_BandHierarchyNodes[1],
    &gDAB_Test_ModeHierarchyNodes[18],
    &gListScrollBarInfoHierarchyNodes[1],
    &gDAB_Test_ModeHierarchyNodes[11],
    &gPresetInfoSXMHierarchyNodes[16],
    &gSxmChannelInfoHierarchyNodes[7],
    &gDABGTestModeAnnoStatusInfoHierarchyNodes[0],
    &gPresetInfoWBHierarchyNodes[11],
    &gPresetInfoSXMHierarchyNodes[5],
    &gDAB_Test_ModeHierarchyNodes[19],
    &gWBPresetInfoHierarchyNodes[8],
    &gWBPresetInfoHierarchyNodes[4],
    &gDAB_Test_ModeHierarchyNodes[23],
    &gTuner1HierarchyNodes[13],
    &gTuner2HierarchyNodes[6],
    &gDAB_Test_ModeHierarchyNodes[1],
    &gTuner4HierarchyNodes[0],
    &gTuner4HierarchyNodes[10],
    &gTuner3HierarchyNodes[1],
    &gSxmChannelInfoHierarchyNodes[5],
    &gTuner3HierarchyNodes[5],
    &gTuner4HierarchyNodes[12],
    &gSxmChannelInfoHierarchyNodes[14],
    &gDAB_Setup_ScreenHierarchyNodes[2],
    &gDAB_Setup_ScreenHierarchyNodes[1],
};

// binding source root table - indexed with BindingSourceIndex 
static const ::Courier::Internal::DataBinding::BindingSourceRootStorage gBindingSourceMap[cBindingSourceCount] = {
    { InvalidDataBindingSource::cHierarchyNodeCount, gInvalidHierarchyNodes },
    { DAB_Test_ModeDataBindingSource::cHierarchyNodeCount, gDAB_Test_ModeHierarchyNodes },
    { DAB_Setup_Screen_ActiveTuner_InfoDataBindingSource::cHierarchyNodeCount, gDAB_Setup_Screen_ActiveTuner_InfoHierarchyNodes },
    { Smart_InfoDataBindingSource::cHierarchyNodeCount, gSmart_InfoHierarchyNodes },
    { DABTestModeEnsembleInfoDataBindingSource::cHierarchyNodeCount, gDABTestModeEnsembleInfoHierarchyNodes },
    { HealthCareMonitorDTCinfoDataBindingSource::cHierarchyNodeCount, gHealthCareMonitorDTCinfoHierarchyNodes },
    { Tuner1DataBindingSource::cHierarchyNodeCount, gTuner1HierarchyNodes },
    { Tuner2DataBindingSource::cHierarchyNodeCount, gTuner2HierarchyNodes },
    { Tuner3DataBindingSource::cHierarchyNodeCount, gTuner3HierarchyNodes },
    { Tuner4DataBindingSource::cHierarchyNodeCount, gTuner4HierarchyNodes },
    { DABGTestModeInfoDataBindingSource::cHierarchyNodeCount, gDABGTestModeInfoHierarchyNodes },
    { DAB_Setup_ScreenDataBindingSource::cHierarchyNodeCount, gDAB_Setup_ScreenHierarchyNodes },
    { DABGTestModeAnnoStatusInfoDataBindingSource::cHierarchyNodeCount, gDABGTestModeAnnoStatusInfoHierarchyNodes },
    { DABGTestModeActiveCompDataBindingSource::cHierarchyNodeCount, gDABGTestModeActiveCompHierarchyNodes },
    { DABTestModeGAvailabiltyInfoDataBindingSource::cHierarchyNodeCount, gDABTestModeGAvailabiltyInfoHierarchyNodes },
    { DABTestModeServiceFollowingInfoDataBindingSource::cHierarchyNodeCount, gDABTestModeServiceFollowingInfoHierarchyNodes },
    { EngineeringInfoDataBindingSource::cHierarchyNodeCount, gEngineeringInfoHierarchyNodes },
    { EngineeringInfo1DataBindingSource::cHierarchyNodeCount, gEngineeringInfo1HierarchyNodes },
    { EngineeringInfo2DataBindingSource::cHierarchyNodeCount, gEngineeringInfo2HierarchyNodes },
    { TunerSource_BandDataBindingSource::cHierarchyNodeCount, gTunerSource_BandHierarchyNodes },
    { PresetInfoWBDataBindingSource::cHierarchyNodeCount, gPresetInfoWBHierarchyNodes },
    { WBPresetInfoDataBindingSource::cHierarchyNodeCount, gWBPresetInfoHierarchyNodes },
    { FMSetupMenuInfoDataBindingSource::cHierarchyNodeCount, gFMSetupMenuInfoHierarchyNodes },
    { AudioTestModeDataBindingSource::cHierarchyNodeCount, gAudioTestModeHierarchyNodes },
    { PhoneTestMode_ListItemDataBindingSource::cHierarchyNodeCount, gPhoneTestMode_ListItemHierarchyNodes },
    { ListId_FlexDataBindingSource::cHierarchyNodeCount, gListId_FlexHierarchyNodes },
    { ListDataSizeDataBindingSource::cHierarchyNodeCount, gListDataSizeHierarchyNodes },
    { SystemSettingTestModeDataBindingSource::cHierarchyNodeCount, gSystemSettingTestModeHierarchyNodes },
    { RVCTestModeDataBindingSource::cHierarchyNodeCount, gRVCTestModeHierarchyNodes },
    { SxmChannelInfoDataBindingSource::cHierarchyNodeCount, gSxmChannelInfoHierarchyNodes },
    { SxmTpopChannelInfoDataBindingSource::cHierarchyNodeCount, gSxmTpopChannelInfoHierarchyNodes },
    { PresetInfoSXMDataBindingSource::cHierarchyNodeCount, gPresetInfoSXMHierarchyNodes },
    { SXMAntennaInfoDataBindingSource::cHierarchyNodeCount, gSXMAntennaInfoHierarchyNodes },
    { ListScrollBarInfoDataBindingSource::cHierarchyNodeCount, gListScrollBarInfoHierarchyNodes },
    { CarModeVisibilityDataBindingSource::cHierarchyNodeCount, gCarModeVisibilityHierarchyNodes },
};

// Init function prototype
static bool InitDataBindingGenerated(void);

// Infrastructure defnition
static const ::Courier::Internal::DataBinding::DataBindingInfrastructure gInfrastructure = { 
    cGlobalDataItemHierarchyNodeCount, gGlobalHierachyNodeTable, 
    cBindingSourceCount, gBindingSourceMap,
    cDataItemDescriptorCount, gItemDesc,
    &InitDataBindingGenerated
};

// ------------------------------------------------------------------------
static bool InitDataBindingGenerated(void)
{
    /* if one of these assertion fails, increase the limits defined in Courier/DataBinding/Infrastructure.h */
    COURIER_COMPILETIME_ASSERT(cBindingSourceItemCountMax < ::Courier::cBindingSourceHierarchyNodeMax);
    COURIER_COMPILETIME_ASSERT(cDataItemDescriptorCount < ::Courier::cItemDescriptorMax);
    COURIER_COMPILETIME_ASSERT(cBindingSourceCount < ::Courier::cBindingSourceMax);

    static ::Courier::Internal::DataBinding::BindingSourceRevisionStoreImpl<cBindingSourceCount> theRevisionStore;

    bool ok = true;
    {
        FEATSTD_UNSYNCED_STATIC_OBJECT(DAB_Test_ModeDataBindingSource, bsDAB_Test_Mode);
        FEATSTD_UNSYNCED_STATIC_OBJECT(DAB_Setup_Screen_ActiveTuner_InfoDataBindingSource, bsDAB_Setup_Screen_ActiveTuner_Info);
        FEATSTD_UNSYNCED_STATIC_OBJECT(Smart_InfoDataBindingSource, bsSmart_Info);
        FEATSTD_UNSYNCED_STATIC_OBJECT(DABTestModeEnsembleInfoDataBindingSource, bsDABTestModeEnsembleInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(HealthCareMonitorDTCinfoDataBindingSource, bsHealthCareMonitorDTCinfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(Tuner1DataBindingSource, bsTuner1);
        FEATSTD_UNSYNCED_STATIC_OBJECT(Tuner2DataBindingSource, bsTuner2);
        FEATSTD_UNSYNCED_STATIC_OBJECT(Tuner3DataBindingSource, bsTuner3);
        FEATSTD_UNSYNCED_STATIC_OBJECT(Tuner4DataBindingSource, bsTuner4);
        FEATSTD_UNSYNCED_STATIC_OBJECT(DABGTestModeInfoDataBindingSource, bsDABGTestModeInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(DAB_Setup_ScreenDataBindingSource, bsDAB_Setup_Screen);
        FEATSTD_UNSYNCED_STATIC_OBJECT(DABGTestModeAnnoStatusInfoDataBindingSource, bsDABGTestModeAnnoStatusInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(DABGTestModeActiveCompDataBindingSource, bsDABGTestModeActiveComp);
        FEATSTD_UNSYNCED_STATIC_OBJECT(DABTestModeGAvailabiltyInfoDataBindingSource, bsDABTestModeGAvailabiltyInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(DABTestModeServiceFollowingInfoDataBindingSource, bsDABTestModeServiceFollowingInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(EngineeringInfoDataBindingSource, bsEngineeringInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(EngineeringInfo1DataBindingSource, bsEngineeringInfo1);
        FEATSTD_UNSYNCED_STATIC_OBJECT(EngineeringInfo2DataBindingSource, bsEngineeringInfo2);
        FEATSTD_UNSYNCED_STATIC_OBJECT(TunerSource_BandDataBindingSource, bsTunerSource_Band);
        FEATSTD_UNSYNCED_STATIC_OBJECT(PresetInfoWBDataBindingSource, bsPresetInfoWB);
        FEATSTD_UNSYNCED_STATIC_OBJECT(WBPresetInfoDataBindingSource, bsWBPresetInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(FMSetupMenuInfoDataBindingSource, bsFMSetupMenuInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(AudioTestModeDataBindingSource, bsAudioTestMode);
        FEATSTD_UNSYNCED_STATIC_OBJECT(PhoneTestMode_ListItemDataBindingSource, bsPhoneTestMode_ListItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(ListId_FlexDataBindingSource, bsListId_Flex);
        FEATSTD_UNSYNCED_STATIC_OBJECT(ListDataSizeDataBindingSource, bsListDataSize);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SystemSettingTestModeDataBindingSource, bsSystemSettingTestMode);
        FEATSTD_UNSYNCED_STATIC_OBJECT(RVCTestModeDataBindingSource, bsRVCTestMode);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmChannelInfoDataBindingSource, bsSxmChannelInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmTpopChannelInfoDataBindingSource, bsSxmTpopChannelInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(PresetInfoSXMDataBindingSource, bsPresetInfoSXM);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SXMAntennaInfoDataBindingSource, bsSXMAntennaInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(ListScrollBarInfoDataBindingSource, bsListScrollBarInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(CarModeVisibilityDataBindingSource, bsCarModeVisibility);
        static ::Courier::Internal::ModelBindingSource *bindingSources[cBindingSourceCount] = { 
            0,
            &bsDAB_Test_Mode, 
            &bsDAB_Setup_Screen_ActiveTuner_Info, 
            &bsSmart_Info, 
            &bsDABTestModeEnsembleInfo, 
            &bsHealthCareMonitorDTCinfo, 
            &bsTuner1, 
            &bsTuner2, 
            &bsTuner3, 
            &bsTuner4, 
            &bsDABGTestModeInfo, 
            &bsDAB_Setup_Screen, 
            &bsDABGTestModeAnnoStatusInfo, 
            &bsDABGTestModeActiveComp, 
            &bsDABTestModeGAvailabiltyInfo, 
            &bsDABTestModeServiceFollowingInfo, 
            &bsEngineeringInfo, 
            &bsEngineeringInfo1, 
            &bsEngineeringInfo2, 
            &bsTunerSource_Band, 
            &bsPresetInfoWB, 
            &bsWBPresetInfo, 
            &bsFMSetupMenuInfo, 
            &bsAudioTestMode, 
            &bsPhoneTestMode_ListItem, 
            &bsListId_Flex, 
            &bsListDataSize, 
            &bsSystemSettingTestMode, 
            &bsRVCTestMode, 
            &bsSxmChannelInfo, 
            &bsSxmTpopChannelInfo, 
            &bsPresetInfoSXM, 
            &bsSXMAntennaInfo, 
            &bsListScrollBarInfo, 
            &bsCarModeVisibility, 
        };
        ok = ok && ::Courier::Register(::Courier::ComponentId(::Courier::ComponentType::View), bindingSources, cBindingSourceCount);
    }
    return ok;
}

namespace Courier {
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::DAB_Test_ModeDataBindingSource>, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::DAB_Setup_Screen_ActiveTuner_InfoDataBindingSource>, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::Smart_InfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::DABTestModeEnsembleInfoDataBindingSource>, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::HealthCareMonitorDTCinfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::Tuner1DataBindingSource>, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::Tuner2DataBindingSource>, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::Tuner3DataBindingSource>, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::Tuner4DataBindingSource>, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::DABGTestModeInfoDataBindingSource>, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::DAB_Setup_ScreenDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::DABGTestModeAnnoStatusInfoDataBindingSource>, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::DABGTestModeActiveCompDataBindingSource>, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::DABTestModeGAvailabiltyInfoDataBindingSource>, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::DABTestModeServiceFollowingInfoDataBindingSource>, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::EngineeringInfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::EngineeringInfo1DataBindingSource>, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::EngineeringInfo2DataBindingSource>, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::TunerSource_BandDataBindingSource>, 20);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::PresetInfoWBDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::WBPresetInfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::FMSetupMenuInfoDataBindingSource>, 25);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::AudioTestModeDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::PhoneTestMode_ListItemDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::ListId_FlexDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::ListDataSizeDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SystemSettingTestModeDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::RVCTestModeDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmChannelInfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmTpopChannelInfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::PresetInfoSXMDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SXMAntennaInfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::ListScrollBarInfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::CarModeVisibilityDataBindingSource>, 5);
} // namespace Courier

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DAB_Test_ModeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DAB_Test_ModeDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DAB_Setup_Screen_ActiveTuner_InfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DAB_Setup_Screen_ActiveTuner_InfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Smart_InfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Smart_InfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DABTestModeEnsembleInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DABTestModeEnsembleInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HealthCareMonitorDTCinfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HealthCareMonitorDTCinfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Tuner1DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Tuner1DataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Tuner2DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Tuner2DataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Tuner3DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Tuner3DataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::Tuner4DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::Tuner4DataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DABGTestModeInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DABGTestModeInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DAB_Setup_ScreenDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DAB_Setup_ScreenDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DABGTestModeAnnoStatusInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DABGTestModeAnnoStatusInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DABGTestModeActiveCompDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DABGTestModeActiveCompDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DABTestModeGAvailabiltyInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DABTestModeGAvailabiltyInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DABTestModeServiceFollowingInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DABTestModeServiceFollowingInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::EngineeringInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::EngineeringInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::EngineeringInfo1DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::EngineeringInfo1DataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::EngineeringInfo2DataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::EngineeringInfo2DataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TunerSource_BandDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TunerSource_BandDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PresetInfoWBDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PresetInfoWBDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::WBPresetInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::WBPresetInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::FMSetupMenuInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::FMSetupMenuInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AudioTestModeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AudioTestModeDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PhoneTestMode_ListItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PhoneTestMode_ListItemDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ListId_FlexDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ListId_FlexDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ListDataSizeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ListDataSizeDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SystemSettingTestModeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SystemSettingTestModeDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::RVCTestModeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::RVCTestModeDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmChannelInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmChannelInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmTpopChannelInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmTpopChannelInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PresetInfoSXMDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PresetInfoSXMDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SXMAntennaInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SXMAntennaInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::CarModeVisibilityDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::CarModeVisibilityDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }
} // namespace FeatStd
#endif
COURIER_DATABINDING_INFRASTRUCTURE(::gInfrastructure);
