/************************************************************************
*FILE: AppHmi_SystemStateMachineData.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/*
 * Id:        AppHmi_SystemStateMachineData.cpp
 *
 * Function:  VS System Data Source File.
 *
 * Generated: Tue Apr 29 13:50:49 2025
 *
 * Coder 7, 3, 2, 2426
 * 
 * This is an automatically generated file. It will be overwritten by the Coder.
 * 
 * DO NOT EDIT THE FILE!
 */


#include "AppHmi_SystemStateMachineSEMLibB.h"


#include "AppHmi_SystemStateMachineData.h"


#include <stdarg.h>


/*
 * VS System External Variable Definitions.
 */
VS_UINT8 ActiveRegion_Selection = 2u;

VS_BOOL EXT_bIs_USB_Connected = 0;

VS_INT GenMsgPopup_Priority = 0;

VS_INT LanguageKds_Selection = 0;

VS_UINT8 SM_VehicleType = 0u;

VS_INT Suzuki_VariantType = 0;

VS_INT clockselectoption = 0;

VS_INT exIntClockMode = 0;

VS_INT extSm_MonConnectionStatus = 0;

VS_INT g_sm_Context = 0;

VS_INT sm_RVCSettings = 0;

VS_UINT8 sm_activityID = 0u;

VS_UINT8 sm_contextid = 255u;

VS_BOOL sm_isEntryfromSystemSettings = 0;

VS_INT sm_mt_audio_flag = 0;


/*
 * VS System Internal Variable Initializing Function.
 */
void AppHmi_SystemStateMachine::SEM_InitInternalVariables (void)
{
  BOOL_VolumePopUpActive = 0;
  FromSettingTunerMedia = 0;
  MessageQueued = 0;
  SettingClock = 0;
  bActivateSpeedLockPopUp = 0;
  bDefaultSettingsPopupActive = 0;
  bInCISUpdateMode = 0;
  enConfirmPopupType = 0ul;
  sm_flag = 0;
}


/*
 * SEM Deduct Function.
 */
unsigned char AppHmi_SystemStateMachine::SEM_Deduct (SEM_EVENT_TYPE EventNo, ...)
{
  va_list ap;

  va_start(ap, EventNo);
  if (SEM.State == 0x00u /* STATE_SEM_NOT_INITIALIZED */)
  {
    return SES_NOT_INITIALIZED;
  }
  if (VS_NOF_EVENTS <= EventNo)
  {
    return (SES_RANGE_ERR);
  }
  switch (EventNo)
  {
  case 228:
    EventArgsVar.DB228.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    EventArgsVar.DB228.VS_UINT8Var[0] = (VS_UINT8) va_arg(ap, VS_INT);
    break;

  case 279:
    EventArgsVar.DB228.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 289:
    EventArgsVar.DB228.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 292:
    EventArgsVar.DB228.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 293:
    EventArgsVar.DB228.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 296:
    EventArgsVar.DB228.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 299:
    EventArgsVar.DB228.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 301:
    EventArgsVar.DB228.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 303:
    EventArgsVar.DB228.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 304:
    EventArgsVar.DB228.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 305:
    EventArgsVar.DB228.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 307:
    EventArgsVar.DB228.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 309:
    EventArgsVar.DB228.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 319:
    EventArgsVar.DB228.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 335:
    EventArgsVar.DB228.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 349:
    EventArgsVar.DB228.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 364:
    EventArgsVar.DB228.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 368:
    EventArgsVar.DB228.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 369:
    EventArgsVar.DB228.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 370:
    EventArgsVar.DB228.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 371:
    EventArgsVar.DB228.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 372:
    EventArgsVar.DB228.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 373:
    EventArgsVar.DB373.VS_INT8Var[0] = (VS_INT8) va_arg(ap, VS_INT);
    break;

  case 383:
    EventArgsVar.DB228.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 384:
    EventArgsVar.DB228.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 385:
    EventArgsVar.DB228.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 386:
    EventArgsVar.DB228.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 387:
    EventArgsVar.DB387.VS_INT32Var[0] = (VS_INT32) va_arg(ap, VS_INT32_VAARG);
    EventArgsVar.DB387.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 388:
    EventArgsVar.DB387.VS_INT32Var[0] = (VS_INT32) va_arg(ap, VS_INT32_VAARG);
    EventArgsVar.DB387.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 389:
    EventArgsVar.DB228.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 390:
    EventArgsVar.DB387.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 391:
    EventArgsVar.DB387.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 392:
    EventArgsVar.DB392.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 393:
    EventArgsVar.DB392.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 394:
    EventArgsVar.DB394.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 395:
    EventArgsVar.DB394.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 396:
    EventArgsVar.DB394.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  default:
    break;
  }
  if (EventNo == SE_RESET)
  {
    SEM.EventNo = SE_RESET;
    SEM.DIt = 2;
  }
  else
  {
    SEM.EventNo = VS_TRIGGERLESS_TRIGGER;
    SEM.DIt = 0;
  }
  SEM.State = 0x02u; /* STATE_SEM_PREPARE */
  SEM.InitialEventNo = EventNo;

  va_end(ap);
  return (SES_OKAY);
}


/*
 * Guard Expression Functions.
 */
VS_BOOL AppHmi_SystemStateMachine::VSGuard (SEM_GUARD_EXPRESSION_TYPE i)
{
  switch (i)
  {
  case 0:
    return (VS_BOOL)(EventArgsVar.DB228.VS_UINT32Var[0] == Enum_CLOCK_GADGET);
  case 1:
    return (VS_BOOL)(sm_mt_audio_flag == 1 || g_sm_Context == 181);
  case 2:
    return (VS_BOOL)(g_sm_Context == 184);
  case 3:
    return (VS_BOOL)(g_sm_Context == 187);
  case 4:
    return (VS_BOOL)(g_sm_Context == 186);
  case 5:
    return (VS_BOOL)(g_sm_Context == 193);
  case 6:
    return (VS_BOOL)(EventArgsVar.DB228.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_busy_screen);
  case 7:
    return (VS_BOOL)(EventArgsVar.DB394.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_PopUp_two_line_single_button);
  case 8:
    return (VS_BOOL)(EventArgsVar.DB392.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_PopUp_two_line_single_button);
  case 9:
    return (VS_BOOL)(EventArgsVar.DB394.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_PopUp_three_line_two_button);
  case 10:
    return (VS_BOOL)(EventArgsVar.DB392.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_PopUp_three_line_two_button);
  case 11:
    return (VS_BOOL)(EventArgsVar.DB394.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_PopUp_two_line_two_button);
  case 12:
    return (VS_BOOL)(EventArgsVar.DB392.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_PopUp_two_line_two_button);
  case 13:
    return (VS_BOOL)(EventArgsVar.DB394.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_Popup_Four_line_single_button);
  case 14:
    return (VS_BOOL)(EventArgsVar.DB392.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_Popup_Four_line_single_button);
  case 15:
    return (VS_BOOL)(bInCISUpdateMode == True);
  case 16:
    return (VS_BOOL)(bInCISUpdateMode == False);
  case 17:
    return (VS_BOOL)(EventArgsVar.DB394.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_PopUp_five_line_double_button);
  case 18:
    return (VS_BOOL)(EventArgsVar.DB392.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_PopUp_five_line_double_button);
  case 19:
    return (VS_BOOL)(enConfirmPopupType == Enum_POPUP_FULLUPDATE || enConfirmPopupType == Enum_POPUP_QUICKUPDATE);
  case 20:
    return (VS_BOOL)(enConfirmPopupType == Enum_POPUP_SWSAMEVERSION);
  case 21:
    return (VS_BOOL)(EventArgsVar.DB394.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_Pfo_SysSetFactDefault);
  case 22:
    return (VS_BOOL)(EventArgsVar.DB392.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_Pfo_SysSetFactDefault);
  case 23:
    return (VS_BOOL)(EventArgsVar.DB228.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_Pfo_SysSetFactReset);
  case 24:
    return (VS_BOOL)(EventArgsVar.DB394.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_Pfo_SpeedLock_CP);
  case 25:
    return (VS_BOOL)(EventArgsVar.DB392.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_Pfo_SpeedLock_CP);
  case 26:
    return (VS_BOOL)(EventArgsVar.DB228.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_MIS_SystemUpdate_Progress);
  case 27:
    return (VS_BOOL)(EventArgsVar.DB394.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_PopUp_six_line_two_button);
  case 28:
    return (VS_BOOL)(EventArgsVar.DB392.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_PopUp_six_line_two_button);
  case 29:
    return (VS_BOOL)(EventArgsVar.DB228.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_PopUp_three_line_single_reboot_button);
  case 30:
    return (VS_BOOL)(EventArgsVar.DB228.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_PopUp_three_line_single_button);
  case 31:
    return (VS_BOOL)(EventArgsVar.DB228.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_HOME || EventArgsVar.DB228.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_SRC_COCKPIT || EventArgsVar.DB228.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_NAV || EventArgsVar.DB228.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_SETTINGS || EventArgsVar.DB228.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_CAMERA || EventArgsVar.DB228.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_PHONE_ACCEPT || EventArgsVar.DB228.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_HOME_CABIN || EventArgsVar.DB228.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_SRC_CABIN);
  case 32:
    return (VS_BOOL)(EventArgsVar.DB228.VS_UINT8Var[0] == Enum_hmibase_HARDKEYSTATE_UP);
  case 33:
    return (VS_BOOL)(EventArgsVar.DB394.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_Pfo_SwivelCalibration);
  case 34:
    return (VS_BOOL)(EventArgsVar.DB392.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_Pfo_SwivelCalibration);
  case 35:
    return (VS_BOOL)(EventArgsVar.DB392.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_Pfo_SystemInstallation);
  case 36:
    return (VS_BOOL)(EventArgsVar.DB387.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_Pfo_SystemInstallation);
  case 37:
    return (VS_BOOL)(EventArgsVar.DB228.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_Pfo_SystemInstallation);
  case 38:
    return (VS_BOOL)(EventArgsVar.DB394.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_Pfo_SysInst_SubSys_Unavailable);
  case 39:
    return (VS_BOOL)(EventArgsVar.DB392.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_Pfo_SysInst_SubSys_Unavailable);
  case 40:
    return (VS_BOOL)(EventArgsVar.DB228.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_Pfo_CabinAMonConnection);
  case 41:
    return (VS_BOOL)(EventArgsVar.DB394.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_Pfo_SoftwareVersionFetchingError);
  case 42:
    return (VS_BOOL)(EventArgsVar.DB392.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_Pfo_SoftwareVersionFetchingError);
  case 43:
    return (VS_BOOL)(EventArgsVar.DB228.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_PopUp_three_line_two_button_Swivel_GS_CA);
  case 44:
    return (VS_BOOL)(EventArgsVar.DB228.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_PopUp_three_line_Swivel_GS_CA);
  case 45:
    return (VS_BOOL)(EventArgsVar.DB228.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_Pfo_SysSetSupplierReset);
  case 46:
    return (VS_BOOL)(EventArgsVar.DB394.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_Pfo_2LineAbortStage2);
  case 47:
    return (VS_BOOL)(EventArgsVar.DB392.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_Pfo_2LineAbortStage2);
  case 48:
    return (VS_BOOL)(ActiveRegion_Selection == 2);
  case 49:
    return (VS_BOOL)(ActiveRegion_Selection == 0);
  case 50:
    return (VS_BOOL)(g_sm_Context == 241);
  case 51:
    return (VS_BOOL)(g_sm_Context == 198);
  case 52:
    return (VS_BOOL)(g_sm_Context == 180);
  case 53:
    return (VS_BOOL)(g_sm_Context == 181);
  case 54:
    return (VS_BOOL)(g_sm_Context == 600);
  case 55:
    return (VS_BOOL)(g_sm_Context == 194);
  case 56:
    return (VS_BOOL)(EventArgsVar.DB228.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_PopUp_three_line_three_button);
  case 57:
    return (VS_BOOL)(sm_flag == 1 || sm_contextid == 0);
  case 58:
    return (VS_BOOL)(ActiveRegion_Selection == 1);
  case 59:
    return (VS_BOOL)(sm_contextid != 128 && sm_contextid != 111);
  case 60:
    return (VS_BOOL)(sm_contextid == 128 || sm_contextid == 111);
  case 61:
    return (VS_BOOL)(sm_contextid != 82);
  case 62:
    return (VS_BOOL)(sm_contextid == 82);
  case 63:
    return (VS_BOOL)(EXT_bIs_USB_Connected == True);
  case 64:
    return (VS_BOOL)(EXT_bIs_USB_Connected == False);
  case 65:
    return (VS_BOOL)(EventArgsVar.DB228.VS_UINT32Var[0] != 0 && EventArgsVar.DB228.VS_UINT32Var[0] != 1);
  case 66:
    return (VS_BOOL)(EventArgsVar.DB228.VS_UINT32Var[0] == Enum_DateFmt4GpsRBtnClk);
  case 67:
    return (VS_BOOL)(EventArgsVar.DB228.VS_UINT32Var[0] == Enum_TimeZneRBtnClk);
  case 68:
    return (VS_BOOL)(clockselectoption == 1);
  case 69:
    return (VS_BOOL)(clockselectoption != 1);
  case 70:
    return (VS_BOOL)(SM_VehicleType == 2);
  case 71:
    return (VS_BOOL)(EXT_bIs_USB_Connected == True && EventArgsVar.DB228.VS_UINT32Var[0] == AppHmi_System_SoftwareDownload_MIS_SystemUpdate_Progress);
  case 72:
    return (VS_BOOL)(LanguageKds_Selection == 1);
  }
  return (VS_BOOL)(LanguageKds_Selection != 1);
}


/*
 * Action Expressions Wrapper Function.
 */
VS_VOID AppHmi_SystemStateMachine::VSAction (SEM_ACTION_EXPRESSION_TYPE i)
{
  switch (i)
  {
  case 32:
    Notify_Init_Finished();
    break;
  case 33:
    Perform_Activate_Home_Cabin_A();
    break;
  case 34:
    Perform_Activate_Home_Cabin_B();
    break;
  case 35:
    Perform_Activate_Home_Source();
    break;
  case 46:
    Perform_Brightness_Dec();
    break;
  case 47:
    Perform_Brightness_Inc();
    break;
  case 50:
    Perform_ClkDateFmt1();
    break;
  case 51:
    Perform_ClkDateFmt2();
    break;
  case 52:
    Perform_ClkDateFmt3();
    break;
  case 53:
    Perform_ClkDateFmt4();
    break;
  case 54:
    Perform_ClkDateFmt5();
    break;
  case 55:
    Perform_ClkDateFmt6();
    break;
  case 61:
    Perform_EqlPrstClassic();
    break;
  case 62:
    Perform_EqlPrstFlat();
    break;
  case 63:
    Perform_EqlPrstHiphop();
    break;
  case 64:
    Perform_EqlPrstJazz();
    break;
  case 65:
    Perform_EqlPrstPop();
    break;
  case 66:
    Perform_EqlPrstRock();
    break;
  case 73:
    Perform_FactoryResetSM();
    break;
  case 74:
    Perform_FactoryResetSMBeep();
    break;
  case 79:
    Perform_LevelOff();
    break;
  case 80:
    Perform_LevelOne();
    break;
  case 81:
    Perform_LevelThree();
    break;
  case 82:
    Perform_LevelTwo();
    break;
  case 83:
    Perform_MediaRadioBack4mAudio();
    break;
  case 86:
    Perform_PrivateModeLevelOne();
    break;
  case 87:
    Perform_PrivateModeLevelThree();
    break;
  case 88:
    Perform_PrivateModeLevelTwo();
    break;
  case 106:
    Perform_VideoMixedSourceBack4mCabinHome();
    break;
  case 156:
    acEnableButtonsonNopopType();
    break;
  case 157:
    acHandlePendingSWDL();
    break;
  case 158:
    acHandleRebootOnUSBRemoval();
    break;
  case 159:
    acOEMPinOk();
    break;
  case 161:
    acRVCEntryViewUpdate();
    break;
  case 162:
    acRVCExitViewupdate();
    break;
  case 163:
    acRebootOnSWDLComplete();
    break;
  case 165:
    acSWUpdateAbortReboot();
    break;
  case 166:
    acSendPluginReq();
    break;
  case 167:
    acStartMISStageOneUpdate();
    break;
  case 168:
    acStartSoftwareDownload();
    break;
  case 169:
    acStartUSBStickBinaryValidation();
    break;
  case 170:
    acSystemInstallation();
    break;
  case 178:
    gacPopupFilterDisableReq();
    break;
  case 186:
    extSm_MonConnectionStatus = 0;
    break;
  case 187:
    bInCISUpdateMode = False;
    break;
  case 188:
    sm_isEntryfromSystemSettings = False;
    break;
  case 189:
    enConfirmPopupType = Enum_POPUP_USB_UNAVAILABLE;
    break;
  case 190:
    extSm_MonConnectionStatus = 1;
    break;
  case 191:
    sm_RVCSettings = 1;
    break;
  case 192:
    sm_contextid = 241;
    break;
  case 193:
    sm_isEntryfromSystemSettings = True;
    break;
  case 194:
    sm_flag = 0;
    break;
  case 195:
    enConfirmPopupType = Enum_POPUP_SWSAMEVERSION;
    break;
  case 196:
    bInCISUpdateMode = True;
    break;
  case 197:
    enConfirmPopupType = Enum_POPUP_FULLUPDATE;
    break;
  case 198:
    enConfirmPopupType = Enum_POPUP_FULLUPDATE_SMART;
    break;
  case 199:
    enConfirmPopupType = Enum_POPUP_QUICKUPDATE;
    break;
  case 200:
    enConfirmPopupType = Enum_POPUP_QUICKUPDATE_SMART;
    break;
  case 201:
    enConfirmPopupType = EventArgsVar.DB228.VS_UINT32Var[0];
    break;
  case 202:
    gacViewDestroyReq(AppHmi_System_SoftwareDownload_busy_screen);
    break;
  case 203:
    gacViewDestroyReq(AppHmi_System_SoftwareDownload_PopUp_two_line_single_button);
    break;
  case 204:
    gacViewDestroyReq(AppHmi_System_SoftwareDownload_PopUp_three_line_two_button);
    break;
  case 205:
    gacViewDestroyReq(AppHmi_System_SoftwareDownload_PopUp_two_line_two_button);
    break;
  case 206:
    gacViewDestroyReq(AppHmi_System_SoftwareDownload_Popup_Four_line_single_button);
    break;
  case 207:
    gacViewDestroyReq(AppHmi_System_SoftwareDownload_PopUp_five_line_double_button);
    break;
  case 208:
    gacViewHideAndDestroyReq(AppHmi_System_SoftwareDownload_Pfo_SysSetFactDefault);
    break;
  case 209:
    gacViewHideAndDestroyReq(AppHmi_System_SoftwareDownload_Pfo_SysSetFactReset);
    break;
  case 210:
    gacViewHideAndDestroyReq(AppHmi_System_SoftwareDownload_Pfo_SpeedLock_CP);
    break;
  case 211:
    gacViewDestroyReq(AppHmi_System_SoftwareDownload_MIS_SystemUpdate_Progress);
    break;
  case 212:
    gacViewDestroyReq(AppHmi_System_SoftwareDownload_PopUp_six_line_two_button);
    break;
  case 213:
    gacViewDestroyReq(AppHmi_System_SoftwareDownload_PopUp_three_line_single_reboot_button);
    break;
  case 214:
    gacViewDestroyReq(AppHmi_System_SoftwareDownload_PopUp_three_line_single_button);
    break;
  case 215:
    gacViewDestroyReq(AppHmi_System_SoftwareDownload_PopUp_three_line_three_button);
    break;
  case 216:
    acSendPopupStatus(AppHmi_System_SoftwareDownload_PopUp_three_line_three_button, Enum_PopupINACTIVE);
    break;
  case 217:
    gacViewDestroyReq(AppHmi_System_SoftwareDownload_Pfo_SwivelCalibration);
    break;
  case 218:
    gacViewDestroyReq(AppHmi_System_SoftwareDownload_Pfo_SystemInstallation);
    break;
  case 219:
    gacViewDestroyReq(AppHmi_System_SoftwareDownload_Pfo_SysInst_SubSys_Unavailable);
    break;
  case 220:
    gacViewHideAndDestroyReq(AppHmi_System_SoftwareDownload_Pfo_CabinAMonConnection);
    break;
  case 221:
    gacViewDestroyReq(AppHmi_System_SoftwareDownload_Pfo_SoftwareVersionFetchingError);
    break;
  case 222:
    gacViewHideAndDestroyReq(AppHmi_System_SoftwareDownload_PopUp_three_line_two_button_Swivel_GS_CA);
    break;
  case 223:
    gacViewHideAndDestroyReq(AppHmi_System_SoftwareDownload_PopUp_three_line_Swivel_GS_CA);
    break;
  case 224:
    gacViewHideAndDestroyReq(AppHmi_System_SoftwareDownload_Pfo_SysSetSupplierReset);
    break;
  case 225:
    gacViewHideAndDestroyReq(AppHmi_System_SoftwareDownload_Pfo_2LineAbortStage2);
    break;
  case 226:
    gacPopupSBCloseReq(AppHmi_System_SoftwareDownload_Pfo_SysSetFactReset);
    break;
  case 227:
    gacViewCreateReq(AppHmi_System_Gadget_System_MASTER_GADGET_SYSTEM);
    break;
  case 228:
    gacViewShowReq(AppHmi_System_Gadget_System_MASTER_GADGET_SYSTEM);
    break;
  case 229:
    gacPopupSBCloseReq(AppHmi_System_SoftwareDownload_busy_screen);
    break;
  case 230:
    gacViewHideAndDestroyReq(AppHmi_System_SysSettingsScenes_SO_SysSettings);
    break;
  case 231:
    gacViewHideAndDestroyReq(AppHmi_System_SysSettingsScenes_SO_AS);
    break;
  case 232:
    gacViewHideAndDestroyReq(AppHmi_System_SysSettingsScenes_SO_SysSettings_CA);
    break;
  case 233:
    gacViewHideAndDestroyReq(AppHmi_System_SysSettingsScenes_SO_SysSettings_CB);
    break;
  case 234:
    gacViewHideAndDestroyReq(AppHmi_System_SysSettingsScenes_SO_OSS);
    break;
  case 235:
    gacViewHideAndDestroyReq(AppHmi_System_SysSettingsScenes_SO_CS_Manual);
    break;
  case 236:
    gacViewHideAndDestroyReq(AppHmi_System_SysSettingsScenes_SO_CS_DateFmt);
    break;
  case 237:
    gacViewHideAndDestroyReq(AppHmi_System_SysSettingsScenes_SO_CS_GPS);
    break;
  case 238:
    gacViewHideAndDestroyReq(AppHmi_System_SysSettingsScenes_SO_CS_TimeZone);
    break;
  case 239:
    gacViewHideAndDestroyReq(AppHmi_System_SysSettingsScenes_SO_DS);
    break;
  case 240:
    gacViewHideAndDestroyReq(AppHmi_System_SysSettingsScenes_SO_AS_EqlPreset);
    break;
  case 241:
    gacViewHideAndDestroyReq(AppHmi_System_SysSettingsScenes_SO_AS_SpeedDepVol);
    break;
  case 242:
    gacViewHideAndDestroyReq(AppHmi_System_SysSettingsScenes_SO_AS_PrivateMode);
    break;
  case 243:
    gacViewHideAndDestroyReq(AppHmi_System_SoftwareDownload_screen_3);
    break;
  case 244:
    gacViewHideAndDestroyReq(AppHmi_System_SoftwareDownload_Stage_one_MIS_SystemUpdate);
    break;
  case 245:
    gacViewHideAndDestroyReq(AppHmi_System_SoftwareDownload_MIS_SystemUpdate_Progress);
    break;
  case 246:
    gacViewHideAndDestroyReq(AppHmi_System_SoftwareDownload_SWUpdate_Update_Info);
    break;
  case 247:
    gacViewHideAndDestroyReq(AppHmi_System_SoftwareDownload_screen_4);
    break;
  case 248:
    gacViewHideAndDestroyReq(AppHmi_System_SoftwareDownload_screen_5);
    break;
  case 249:
    gacViewHideAndDestroyReq(AppHmi_System_SoftwareDownload_screen_6);
    break;
  case 250:
    gacViewHideAndDestroyReq(AppHmi_System_SysSettingsScenes_SO_SoftwareVersion_CIS);
    break;
  case 251:
    gacViewHideAndDestroyReq(AppHmi_System_SysSettingsScenes_SO_GS_SwivelCalibration);
    break;
  case 252:
    gacViewHideAndDestroyReq(AppHmi_System_SysSettingsScenes_SO_DTCInformation);
    break;
  case 253:
    gacViewHideAndDestroyReq(AppHmi_System_SysSettingsScenes_SO_OEM_MENU);
    break;
  case 254:
    acSendPopupStatus(AppHmi_System_SysSettingsScenes_SO_OEM_PIN, Enum_PopupACTIVE);
    break;
  case 255:
    gacViewHideAndDestroyReq(AppHmi_System_SysSettingsScenes_SO_OEM_PIN);
    break;
  case 256:
    gacViewHideAndDestroyReq(AppHmi_System_SysSettingsScenes_SO_ConfigurationVersion);
    break;
  case 257:
    gacViewHideAndDestroyReq(AppHmi_System_SysSettingsScenes_SO_LS_EU);
    break;
  case 258:
    gacViewHideAndDestroyReq(AppHmi_System_SysSettingsScenes_SO_LS_Nafta);
    break;
  case 259:
    gacViewHideAndDestroyReq(AppHmi_System_SysSettingsScenes_SO_AudioSettings_CA);
    break;
  case 260:
    gacViewHideAndDestroyReq(AppHmi_System_SysSettingsScenes_SO_GlassSettings_CA);
    break;
  case 261:
    gacViewHideAndDestroyReq(AppHmi_System_SysSettingsScenes_SO_OSS_CA);
    break;
  case 262:
    gacViewHideAndDestroyReq(AppHmi_System_SysSettingsScenes_SO_VideoMixSource_CA);
    break;
  case 263:
    gacViewHideAndDestroyReq(AppHmi_System_SysSettingsScenes_SO_RVCSettings);
    break;
  case 264:
    gacViewHideAndDestroyReq(AppHmi_System_SysSettingsScenes_SO_RVCBrightnessSettings);
    break;
  case 265:
    gacViewHideAndDestroyReq(AppHmi_System_SysSettingsScenes_SO_RVCContrastSettings);
    break;
  case 266:
    gacViewHideAndDestroyReq(AppHmi_System_SysSettingsScenes_SO_MIC_AS);
    break;
  case 267:
    Perform_SettingSceneMsg(181);
    break;
  case 268:
    gacViewCreateAndShowReq(AppHmi_System_SysSettingsScenes_SO_AS);
    break;
  case 269:
    Perform_SettingSceneMsg(184);
    break;
  case 270:
    gacViewCreateAndShowReq(AppHmi_System_SysSettingsScenes_SO_DS);
    break;
  case 271:
    gacViewCreateAndShowReq(AppHmi_System_SysSettingsScenes_SO_OSS);
    break;
  case 272:
    gacViewShowReq(AppHmi_System_SysSettingsScenes_SO_SysSettings);
    break;
  case 273:
    gacViewCreateAndShowReq(AppHmi_System_SysSettingsScenes_SO_CS_Manual);
    break;
  case 274:
    gacViewCreateAndShowReq(AppHmi_System_SysSettingsScenes_SO_CS_DateFmt);
    break;
  case 275:
    gacViewCreateAndShowReq(AppHmi_System_SysSettingsScenes_SO_CS_GPS);
    break;
  case 276:
    gacViewCreateAndShowReq(AppHmi_System_SysSettingsScenes_SO_CS_TimeZone);
    break;
  case 277:
    gacViewCreateAndShowReq(AppHmi_System_SysSettingsScenes_SO_AS_EqlPreset);
    break;
  case 278:
    gacViewCreateAndShowReq(AppHmi_System_SysSettingsScenes_SO_AS_SpeedDepVol);
    break;
  case 279:
    gacViewCreateAndShowReq(AppHmi_System_SysSettingsScenes_SO_AS_PrivateMode);
    break;
  case 280:
    gacViewCreateAndShowReq(AppHmi_System_SoftwareDownload_screen_3);
    break;
  case 281:
    gacViewCreateAndShowReq(AppHmi_System_SoftwareDownload_Stage_one_MIS_SystemUpdate);
    break;
  case 282:
    gacPopupFilterPrioEnableReq(3);
    break;
  case 283:
    Perform_SettingSceneMsg(601);
    break;
  case 284:
    gacViewCreateAndShowReq(AppHmi_System_SoftwareDownload_MIS_SystemUpdate_Progress);
    break;
  case 285:
    Perform_SettingSceneMsg(600);
    break;
  case 286:
    gacViewCreateAndShowReq(AppHmi_System_SoftwareDownload_SWUpdate_Update_Info);
    break;
  case 287:
    gacViewCreateAndShowReq(AppHmi_System_SoftwareDownload_screen_4);
    break;
  case 288:
    gacViewCreateAndShowReq(AppHmi_System_SoftwareDownload_screen_5);
    break;
  case 289:
    gacViewCreateAndShowReq(AppHmi_System_SoftwareDownload_screen_6);
    break;
  case 290:
    gacViewCreateAndShowReq(AppHmi_System_SysSettingsScenes_SO_SoftwareVersion_CIS);
    break;
  case 291:
    gacViewCreateAndShowReq(AppHmi_System_SysSettingsScenes_SO_GS_SwivelCalibration);
    break;
  case 292:
    gacViewCreateAndShowReq(AppHmi_System_SysSettingsScenes_SO_DTCInformation);
    break;
  case 293:
    gacViewCreateAndShowReq(AppHmi_System_SysSettingsScenes_SO_OEM_MENU);
    break;
  case 294:
    gacViewCreateAndShowReq(AppHmi_System_SysSettingsScenes_SO_OEM_PIN);
    break;
  case 295:
    gacViewCreateAndShowReq(AppHmi_System_SysSettingsScenes_SO_ConfigurationVersion);
    break;
  case 296:
    gacViewCreateAndShowReq(AppHmi_System_SysSettingsScenes_SO_LS_EU);
    break;
  case 297:
    gacViewCreateAndShowReq(AppHmi_System_SysSettingsScenes_SO_LS_Nafta);
    break;
  case 298:
    gacViewCreateAndShowReq(AppHmi_System_SysSettingsScenes_SO_SysSettings);
    break;
  case 299:
    acSetReleaseFilter(Enum_SWDL_CUSTOMER_MODE);
    break;
  case 300:
    gacPopupCreateAndSBShowReq(AppHmi_System_SoftwareDownload_busy_screen);
    break;
  case 301:
    acSetReleaseFilter(Enum_SWDL_ENGG_MODE);
    break;
  case 302:
    gacViewCreateAndShowReq(AppHmi_System_SysSettingsScenes_SO_SysSettings_CA);
    break;
  case 303:
    gacViewCreateAndShowReq(AppHmi_System_SysSettingsScenes_SO_SysSettings_CB);
    break;
  case 304:
    Perform_SettingSceneMsg(186);
    break;
  case 305:
    gacViewCreateAndShowReq(AppHmi_System_SysSettingsScenes_SO_AudioSettings_CA);
    break;
  case 306:
    Perform_SettingSceneMsg(187);
    break;
  case 307:
    gacViewCreateAndShowReq(AppHmi_System_SysSettingsScenes_SO_GlassSettings_CA);
    break;
  case 308:
    gacViewCreateAndShowReq(AppHmi_System_SysSettingsScenes_SO_OSS_CA);
    break;
  case 309:
    Perform_SettingSceneMsg(193);
    break;
  case 310:
    gacViewCreateAndShowReq(AppHmi_System_SysSettingsScenes_SO_VideoMixSource_CA);
    break;
  case 311:
    Perform_SettingSceneMsg(194);
    break;
  case 312:
    acStartPopupTimer(AppHmi_System_SoftwareDownload_MIS_SystemUpdate_Progress, 420000);
    break;
  case 313:
    gacViewShowReq(AppHmi_System_SoftwareDownload_busy_screen);
    break;
  case 314:
    gacViewHideReq(AppHmi_System_SoftwareDownload_busy_screen);
    break;
  case 315:
    gacViewClearReq(AppHmi_System_SoftwareDownload_busy_screen);
    break;
  case 316:
    gacViewShowReq(AppHmi_System_SoftwareDownload_PopUp_two_line_single_button);
    break;
  case 317:
    gacViewHideReq(AppHmi_System_SoftwareDownload_PopUp_two_line_single_button);
    break;
  case 318:
    gacViewClearReq(AppHmi_System_SoftwareDownload_PopUp_two_line_single_button);
    break;
  case 319:
    gacPopupSBCloseReq(AppHmi_System_SoftwareDownload_PopUp_two_line_single_button);
    break;
  case 320:
    gacViewShowReq(AppHmi_System_SoftwareDownload_PopUp_three_line_two_button);
    break;
  case 321:
    gacViewHideReq(AppHmi_System_SoftwareDownload_PopUp_three_line_two_button);
    break;
  case 322:
    gacViewClearReq(AppHmi_System_SoftwareDownload_PopUp_three_line_two_button);
    break;
  case 323:
    gacPopupSBCloseReq(AppHmi_System_SoftwareDownload_PopUp_three_line_two_button);
    break;
  case 324:
    gacViewShowReq(AppHmi_System_SoftwareDownload_PopUp_two_line_two_button);
    break;
  case 325:
    gacViewHideReq(AppHmi_System_SoftwareDownload_PopUp_two_line_two_button);
    break;
  case 326:
    gacViewClearReq(AppHmi_System_SoftwareDownload_PopUp_two_line_two_button);
    break;
  case 327:
    gacPopupSBCloseReq(AppHmi_System_SoftwareDownload_PopUp_two_line_two_button);
    break;
  case 328:
    gacViewShowReq(AppHmi_System_SoftwareDownload_Popup_Four_line_single_button);
    break;
  case 329:
    gacViewHideReq(AppHmi_System_SoftwareDownload_Popup_Four_line_single_button);
    break;
  case 330:
    gacViewClearReq(AppHmi_System_SoftwareDownload_Popup_Four_line_single_button);
    break;
  case 331:
    gacPopupSBCloseReq(AppHmi_System_SoftwareDownload_Popup_Four_line_single_button);
    break;
  case 332:
    gacViewShowReq(AppHmi_System_SoftwareDownload_PopUp_five_line_double_button);
    break;
  case 333:
    gacViewHideReq(AppHmi_System_SoftwareDownload_PopUp_five_line_double_button);
    break;
  case 334:
    gacViewClearReq(AppHmi_System_SoftwareDownload_PopUp_five_line_double_button);
    break;
  case 335:
    gacPopupSBCloseReq(AppHmi_System_SoftwareDownload_PopUp_five_line_double_button);
    break;
  case 336:
    gacViewCreateAndShowReq(AppHmi_System_SoftwareDownload_Pfo_SysSetFactDefault);
    break;
  case 337:
    gacPopupSBCloseReq(AppHmi_System_SoftwareDownload_Pfo_SysSetFactDefault);
    break;
  case 338:
    gacPopupCreateAndSBShowReq(AppHmi_System_SoftwareDownload_Pfo_SysSetFactReset);
    break;
  case 339:
    gacViewShowReq(AppHmi_System_SoftwareDownload_Pfo_SysSetFactDefault);
    break;
  case 340:
    gacViewCreateAndShowReq(AppHmi_System_SoftwareDownload_Pfo_SysSetFactReset);
    break;
  case 341:
    gacViewShowReq(AppHmi_System_SoftwareDownload_Pfo_SysSetFactReset);
    break;
  case 342:
    gacViewCreateAndShowReq(AppHmi_System_SoftwareDownload_Pfo_SpeedLock_CP);
    break;
  case 343:
    gacViewShowReq(AppHmi_System_SoftwareDownload_Pfo_SpeedLock_CP);
    break;
  case 344:
    gacViewShowReq(AppHmi_System_SoftwareDownload_MIS_SystemUpdate_Progress);
    break;
  case 345:
    gacViewHideReq(AppHmi_System_SoftwareDownload_MIS_SystemUpdate_Progress);
    break;
  case 346:
    gacViewClearReq(AppHmi_System_SoftwareDownload_MIS_SystemUpdate_Progress);
    break;
  case 347:
    gacViewShowReq(AppHmi_System_SoftwareDownload_PopUp_six_line_two_button);
    break;
  case 348:
    gacViewHideReq(AppHmi_System_SoftwareDownload_PopUp_six_line_two_button);
    break;
  case 349:
    gacViewClearReq(AppHmi_System_SoftwareDownload_PopUp_six_line_two_button);
    break;
  case 350:
    gacPopupSBCloseReq(AppHmi_System_SoftwareDownload_PopUp_six_line_two_button);
    break;
  case 351:
    gacViewShowReq(AppHmi_System_SoftwareDownload_PopUp_three_line_single_reboot_button);
    break;
  case 352:
    gacViewHideReq(AppHmi_System_SoftwareDownload_PopUp_three_line_single_reboot_button);
    break;
  case 353:
    gacViewClearReq(AppHmi_System_SoftwareDownload_PopUp_three_line_single_reboot_button);
    break;
  case 354:
    gacPopupSBCloseReq(AppHmi_System_SoftwareDownload_PopUp_three_line_single_reboot_button);
    break;
  case 355:
    gacViewShowReq(AppHmi_System_SoftwareDownload_PopUp_three_line_single_button);
    break;
  case 356:
    gacViewHideReq(AppHmi_System_SoftwareDownload_PopUp_three_line_single_button);
    break;
  case 357:
    gacViewClearReq(AppHmi_System_SoftwareDownload_PopUp_three_line_single_button);
    break;
  case 358:
    gacPopupSBCloseReq(AppHmi_System_SoftwareDownload_PopUp_three_line_single_button);
    break;
  case 359:
    gacPopupSBCloseReq(AppHmi_System_SoftwareDownload_PopUp_three_line_three_button);
    break;
  case 360:
    gacViewShowReq(AppHmi_System_SoftwareDownload_Pfo_SwivelCalibration);
    break;
  case 361:
    gacViewHideReq(AppHmi_System_SoftwareDownload_Pfo_SwivelCalibration);
    break;
  case 362:
    gacViewClearReq(AppHmi_System_SoftwareDownload_Pfo_SwivelCalibration);
    break;
  case 363:
    gacViewShowReq(AppHmi_System_SoftwareDownload_Pfo_SystemInstallation);
    break;
  case 364:
    acSendPopupStatus(AppHmi_System_SoftwareDownload_Pfo_SystemInstallation, Enum_PopupACTIVE);
    break;
  case 365:
    gacPopupSBCloseReq(AppHmi_System_SoftwareDownload_Pfo_SystemInstallation);
    break;
  case 366:
    gacViewShowReq(AppHmi_System_SoftwareDownload_Pfo_SysInst_SubSys_Unavailable);
    break;
  case 367:
    gacViewHideReq(AppHmi_System_SoftwareDownload_Pfo_SysInst_SubSys_Unavailable);
    break;
  case 368:
    gacViewClearReq(AppHmi_System_SoftwareDownload_Pfo_SysInst_SubSys_Unavailable);
    break;
  case 369:
    gacViewCreateAndShowReq(AppHmi_System_SoftwareDownload_Pfo_CabinAMonConnection);
    break;
  case 370:
    gacViewHideReq(AppHmi_System_SoftwareDownload_Pfo_CabinAMonConnection);
    break;
  case 371:
    gacViewDestroyReq(AppHmi_System_SoftwareDownload_Pfo_CabinAMonConnection);
    break;
  case 372:
    gacViewShowReq(AppHmi_System_SoftwareDownload_Pfo_SoftwareVersionFetchingError);
    break;
  case 373:
    gacViewHideReq(AppHmi_System_SoftwareDownload_Pfo_SoftwareVersionFetchingError);
    break;
  case 374:
    gacViewClearReq(AppHmi_System_SoftwareDownload_Pfo_SoftwareVersionFetchingError);
    break;
  case 375:
    gacViewCreateAndShowReq(AppHmi_System_SoftwareDownload_PopUp_three_line_two_button_Swivel_GS_CA);
    break;
  case 376:
    gacViewHideReq(AppHmi_System_SoftwareDownload_PopUp_three_line_two_button_Swivel_GS_CA);
    break;
  case 377:
    gacViewClearReq(AppHmi_System_SoftwareDownload_PopUp_three_line_two_button_Swivel_GS_CA);
    break;
  case 378:
    PerformCockpitMode(Enum_Battery_ON);
    break;
  case 379:
    PerformCockpitMode(Enum_Battery_OFF);
    break;
  case 380:
    gacViewCreateAndShowReq(AppHmi_System_SoftwareDownload_PopUp_three_line_Swivel_GS_CA);
    break;
  case 381:
    gacViewHideReq(AppHmi_System_SoftwareDownload_PopUp_three_line_Swivel_GS_CA);
    break;
  case 382:
    gacViewClearReq(AppHmi_System_SoftwareDownload_PopUp_three_line_Swivel_GS_CA);
    break;
  case 383:
    gacViewCreateAndShowReq(AppHmi_System_SoftwareDownload_Pfo_SysSetSupplierReset);
    break;
  case 384:
    gacViewHideReq(AppHmi_System_SoftwareDownload_Pfo_SysSetSupplierReset);
    break;
  case 385:
    gacViewClearReq(AppHmi_System_SoftwareDownload_Pfo_SysSetSupplierReset);
    break;
  case 386:
    gacViewCreateAndShowReq(AppHmi_System_SoftwareDownload_Pfo_2LineAbortStage2);
    break;
  case 387:
    gacPopupFilterPrioEnableReq(2);
    break;
  case 388:
    gacViewCreateAndShowReq(AppHmi_System_SysSettingsScenes_SO_RVCSettings);
    break;
  case 389:
    gacViewCreateAndShowReq(AppHmi_System_SysSettingsScenes_SO_MIC_AS);
    break;
  case 390:
    gacViewShowReq(AppHmi_System_SoftwareDownload_PopUp_three_line_three_button);
    break;
  case 391:
    acSendPopupStatus(AppHmi_System_SoftwareDownload_PopUp_three_line_three_button, Enum_PopupACTIVE);
    break;
  case 392:
    gacViewHideReq(AppHmi_System_SoftwareDownload_PopUp_three_line_three_button);
    break;
  case 393:
    gacViewClearReq(AppHmi_System_SoftwareDownload_PopUp_three_line_three_button);
    break;
  case 394:
    acPerformSwivelSetRequest(Enum_Up);
    break;
  case 395:
    acPerformSwivelSetRequest(Enum_Down);
    break;
  case 396:
    acPerformSwivelSetRequest(Enum_Automatic);
    break;
  case 397:
    gacPopupCreateAndSBShowReq(AppHmi_System_SoftwareDownload_Pfo_SysSetFactDefault);
    break;
  case 398:
    gacPopupCreateAndSBShowReq(AppHmi_System_SoftwareDownload_Pfo_SpeedLock_CP);
    break;
  case 399:
    ChangeMonitorUpDown4GammaCASettingModevalReq(EventArgsVar.DB228.VS_UINT32Var[0]);
    break;
  case 400:
    gacViewCreateAndShowReq(AppHmi_System_SysSettingsScenes_SO_RVCBrightnessSettings);
    break;
  case 401:
    gacViewCreateAndShowReq(AppHmi_System_SysSettingsScenes_SO_RVCContrastSettings);
    break;
  case 402:
    acUpdatePopupText(Enum_POPUP_USB_UNAVAILABLE);
    break;
  case 403:
    gacPopupCreateAndSBShowReq(AppHmi_System_SoftwareDownload_Popup_Four_line_single_button);
    break;
  case 404:
    acUpdatePopupText(Enum_POPUP_USB_REMOVED);
    break;
  case 405:
    acUpdatePopupText(Enum_POPUP_USB_UNSUPPORT_FORMAT);
    break;
  case 406:
    acUpdatePopupText(Enum_POPUP_SWDOWNGRADE);
    break;
  case 407:
    acUpdatePopupText(Enum_POPUP_USB_INCOMPATIBLE);
    break;
  case 408:
    acUpdatePopupText(enConfirmPopupType);
    break;
  case 409:
    gacPopupCreateAndSBShowReq(AppHmi_System_SoftwareDownload_PopUp_five_line_double_button);
    break;
  case 410:
    ChangeAuxlevelvalueReq(EventArgsVar.DB228.VS_UINT32Var[0]);
    break;
  case 411:
    ChangeDisplaySettingModevalueReq(EventArgsVar.DB228.VS_UINT32Var[0]);
    break;
  case 412:
    acPerformListRefresh(LIST_ID_SYSTEM_SWVERSION_CIS_LIST);
    break;
  case 413:
    Perform_DTCSubSystemCMC19SwDetailsMsg(EventArgsVar.DB228.VS_UINT32Var[0]);
    break;
  case 414:
    ChangeLCDOnOff4GammaCASettingModevalReq(EventArgsVar.DB228.VS_UINT32Var[0]);
    break;
  case 415:
    ChangeMonitorUpDown4GammaCASettingModevalReq(EventArgsVar.DB228.VS_UINT32Var[0]);
    break;
  case 416:
    ChangeClockTimeformatReq(EventArgsVar.DB228.VS_UINT32Var[0]);
    break;
  case 417:
    ChangeClockformatReq(EventArgsVar.DB228.VS_UINT32Var[0]);
    break;
  case 418:
    ChangeGpsClockTimeformatReq(EventArgsVar.DB228.VS_UINT32Var[0]);
    break;
  case 419:
    ChangeGpsClockClkModeReq(EventArgsVar.DB228.VS_UINT32Var[0]);
    break;
  case 420:
    ChangeClockTimeZoneReq(EventArgsVar.DB228.VS_UINT32Var[0]);
    break;
  case 421:
    acSetSoftwareUpdateType(Enum_UpdateType_Full);
    break;
  case 422:
    acSetSoftwareUpdateType(Enum_UpdateType_Quick);
    break;
  case 423:
    acUpdatePopupText(Enum_POPUP_MIS_UPDATE_FAILED_INVALID_XML);
    break;
  case 424:
    acStopAppPopupTimer(AppHmi_System_SoftwareDownload_MIS_SystemUpdate_Progress);
    break;
  case 425:
    gacPopupCreateAndSBShowReq(AppHmi_System_SoftwareDownload_PopUp_three_line_single_reboot_button);
    break;
  case 426:
    gacPopupCreateAndSBShowReq(AppHmi_System_SoftwareDownload_Pfo_2LineAbortStage2);
    break;
  case 427:
    gacPopupSBCloseReq(AppHmi_System_SoftwareDownload_MIS_SystemUpdate_Progress);
    break;

  default:
    break;
  }
}
