/************************************************************************
*FILE: AppHmi_SystemStateMachine.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(AppHmi_SystemStateMachine_h)
#define AppHmi_SystemStateMachine_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Courier/Messaging/Message.h>
#include <AppHmi_SystemStateMachineSEMLibB.h>
#include <AppHmi_SystemStateMachineData.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Cit/VisualStateGlueLayer/DeductResult.h>
#ifdef CIT_SIMULATION
#include <json/value.h>
#endif
#include <AppHmi_SystemTypes.h>
#include <AppHmi_SystemMessages.h>
#include <AppHmi_SystemConstants.h>
#include <AppHmi_SystemDatabinding.h>
#include <AppHmi_SystemViews.h>
#include <AppHmi_SystemController.h>
// ------------------------------------------------------------------------
class AppHmi_SystemStateMachineImpl : public AppHmi_SystemStateMachine
{
public:
    typedef AppHmi_SystemStateMachine Base;

#ifdef VISUALSTATE_7_TRACE
    // Mapping of data types of API to get rid of include dependencies
    //typedef SEM_ACTION_EXPRESSION_TYPE VS_Type_ActionExpression;
	using Base::VS_Type_ActionExpression;
    //typedef SEM_EVENT_TYPE VS_Type_Event;
	//typedef SEM_STATE_TYPE VS_Type_State;
	//typedef SEM_EXPLANATION_TYPE VS_Type_Explanation;
	//typedef SEM_STATE_MACHINE_TYPE VS_Type_Statemachine;
	using Base::VS_Type_Event;
	using Base::VS_Type_State;
	using Base::VS_Type_Explanation;
	using Base::VS_Type_Statemachine;

    // Mapping of enums and defines of API to get rid of include dependencies
    //enum { VS_Ret_Ok = SES_OKAY };
    //enum { VS_Ret_Found = SES_FOUND };
	enum { VS_Ret_Ok = Base::VS_Ret_Ok };
	enum { VS_Ret_Found = Base::VS_Ret_Found };
    enum { VS_Evt_Reset = SE_RESET };
    enum { VS_Ret_Error = SES_RANGE_ERR };
#else
#ifndef VISUALSTATE_HCODER
    typedef SEM_ACTION_EXPRESSION_TYPE VS_Type_ActionExpression;
    typedef SEM_EVENT_TYPE VS_Type_Event;
    typedef SEM_STATE_TYPE VS_Type_State;
    typedef SEM_EXPLANATION_TYPE VS_Type_Explanation;
    typedef SEM_STATE_MACHINE_TYPE VS_Type_Statemachine;
    enum { VS_Ret_Ok = SES_OKAY };
    enum { VS_Ret_Found = SES_FOUND };
    enum { VS_Evt_Reset = SE_RESET };
    enum { VS_Ret_Error = SES_RANGE_ERR };
#else
    enum { VS_Ret_Ok = 0U };
    enum { VS_Ret_Found = 1U };
    enum { VS_Evt_Reset = 0U };
    enum { VS_Ret_Error = 4U };
#endif
#endif
// ------------------------------------------------------------------------

    // Mapping of args passed as hashId to corresponding identifier
    static const ::FeatStd::Char *GetNameFromId(::FeatStd::UInt32 id);

// ------------------------------------------------------------------------
    virtual void acUpdatePopupText(::FeatStd::UInt8 aPopupTextID);
    virtual void acSystemInstallation();
    virtual void acSWUpdateAbortReboot();
    virtual void acOEMPinOk();
    virtual void acStartUSBStickBinaryValidation();
    virtual void acSetSoftwareUpdateType(::FeatStd::UInt32 aUpdateType);
    virtual void acEnableButtonsonNopopType();
    virtual void acStartSoftwareDownload();
    virtual void acSetReleaseFilter(::FeatStd::UInt32 aDownloadMode);
    virtual void acStartMISStageOneUpdate();
    virtual void acRVCEntryViewUpdate();
    virtual void acRVCExitViewupdate();
    virtual void acHandlePendingSWDL();
    virtual void ChangeMeasurementvalueReq(::FeatStd::UInt32 aMeasurementOptions);
    virtual void ChangeClockTimeformatReq(::FeatStd::UInt32 aTimeFormatOptions);
    virtual void ChangeGpsClockTimeformatReq(::FeatStd::UInt32 aGpsTimeFormatOptions);
    virtual void ChangeGpsClockClkModeReq(::FeatStd::UInt32 aGpsClkClockModeOptions);
    virtual void ChangeClockTimeZoneReq(::FeatStd::UInt32 aSelectedTimeZoneItem);
    virtual void ChangeClockformatReq(::FeatStd::UInt32 aClockFormatOptions);
    virtual void ChangeAuxlevelvalueReq(::FeatStd::UInt32 aAuxLevelOptions);
    virtual void ChangeDisplaySettingModevalueReq(::FeatStd::UInt32 aDisplaySettingModeOptions);
    virtual void ChangeLCDOnOff4GammaCASettingModevalReq(::FeatStd::UInt32 aLCDOnOffGammaCASettingModeOptions);
    virtual void ChangeMonitorUpDown4GammaCASettingModevalReq(::FeatStd::UInt32 aMonitorUpDownGammaCASettingModeOptions);
    virtual void Perform_Activate_Home_Source();
    virtual void Perform_Activate_RVC_Source();
    virtual void Perform_Activate_Home_Cabin_A();
    virtual void Perform_Activate_Home_Cabin_B();
    virtual void Perform_Hour_Dec();
    virtual void Perform_Hour_Inc();
    virtual void Perform_Minute_Dec();
    virtual void Perform_Minute_Inc();
    virtual void Perform_TimeFormat12H();
    virtual void Perform_TimeFormat24H();
    virtual void Perform_CLKSetMode_GPS();
    virtual void Perform_CLKSetMode_Manual();
    virtual void DateFormat_EU_1();
    virtual void DateFormat_EU_2();
    virtual void DateFormat_EU_3();
    virtual void DateFormat_EU_4();
    virtual void DateFormat_EU_5();
    virtual void DateFormat_EU_6();
    virtual void DateFormat_CN_1();
    virtual void DateFormat_CN_2();
    virtual void Candidate_EU_1();
    virtual void Candidate_EU_2();
    virtual void Candidate_EU_3();
    virtual void Candidate_EU_4();
    virtual void Candidate_EU_5();
    virtual void Candidate_EU_6();
    virtual void Candidate_EU_7();
    virtual void Candidate_EU_8();
    virtual void Candidate_EU_9();
    virtual void Candidate_EU_10();
    virtual void Candidate_EU_11();
    virtual void Candidate_EU_12();
    virtual void Candidate_EU_13();
    virtual void Candidate_EU_14();
    virtual void Candidate_EU_15();
    virtual void TimeZone_1();
    virtual void TimeZone_2();
    virtual void TimeZone_3();
    virtual void TimeZone_4();
    virtual void TimeZone_5();
    virtual void TimeZone_6();
    virtual void TimeZone_7();
    virtual void TimeZone_8();
    virtual void TimeZone_9();
    virtual void TimeZone_10();
    virtual void TimeZone_11();
    virtual void TimeZone_12();
    virtual void TimeZone_13();
    virtual void TimeZone_14();
    virtual void TimeZone_15();
    virtual void TimeZone_16();
    virtual void TimeZone_17();
    virtual void TimeZone_18();
    virtual void TimeZone_19();
    virtual void TimeZone_20();
    virtual void TimeZone_21();
    virtual void TimeZone_22();
    virtual void TimeZone_23();
    virtual void TimeZone_24();
    virtual void TimeZone_25();
    virtual void TimeZone_26();
    virtual void TimeZone_27();
    virtual void TimeZone_28();
    virtual void TimeZone_29();
    virtual void TimeZone_30();
    virtual void TimeZone_31();
    virtual void TimeZone_32();
    virtual void TimeZone_33();
    virtual void TimeZone_34();
    virtual void TimeZone_35();
    virtual void TimeZone_36();
    virtual void TimeZone_37();
    virtual void TimeZone_38();
    virtual void TimeZone_39();
    virtual void TimeZone_40();
    virtual void TimeZone_41();
    virtual void TimeZone_42();
    virtual void TimeZone_43();
    virtual void TimeZone_44();
    virtual void TimeZone_45();
    virtual void TimeZone_46();
    virtual void TimeZone_47();
    virtual void TimeZone_48();
    virtual void GoToGPS();
    virtual void GoToManual();
    virtual void Perform_Update_SoundSetting_Entry(::FeatStd::UInt8 aEntryFromApp);
    virtual void Perform_Touch();
    virtual void Perform_SpeedLockTouch();
    virtual void Perform_Bass_Dec();
    virtual void Perform_Bass_Inc();
    virtual void Perform_Treble_Dec();
    virtual void Perform_Treble_Inc();
    virtual void Perform_Balance_Inc();
    virtual void Perform_Balance_Dec();
    virtual void Perform_Fader_Inc();
    virtual void Perform_Fader_Dec();
    virtual void acPerformSwivelSetRequest(::FeatStd::UInt8 aSelectedModeItem);
    virtual void PerformCockpitMode(::FeatStd::UInt8 aCockpitModeStatus);
    virtual void acSendPopupStatus(::FeatStd::UInt32 aActiveViewId, ::FeatStd::UInt8 aPopupStatus);
    virtual void acSendPluginReq();
    virtual void Perform_Aux_Loud();
    virtual void Perform_Aux_Middle();
    virtual void Perform_Aux_Quiet();
    virtual void Perform_Beep();
    virtual void Perform_Touch_Click();
    virtual void Perform_Speed_Off();
    virtual void Perform_Speed_Level1();
    virtual void Perform_Speed_Level2();
    virtual void Perform_Speed_Level3();
    virtual void Perform_Equilizer_Flat();
    virtual void Perform_Equilizer_Pop();
    virtual void Perform_Equilizer_Rock();
    virtual void Perform_Equilizer_Hiphop();
    virtual void Perform_Equilizer_Classic();
    virtual void Perform_Equilizer_Jazz();
    virtual void Perform_Back();
    virtual void SetLanguageReq();
    virtual void Candidate_CN_1();
    virtual void Candidate_CN_2();
    virtual void Candidate_GEX_1();
    virtual void Candidate_GEX_2();
    virtual void Candidate_GEX_3();
    virtual void Candidate_GEX_4();
    virtual void Candidate_GEX_5();
    virtual void Perform_Switch_SoundSettingsApp();
    virtual void Perform_Switch_SecurityPINApp();
    virtual void Perform_Switch_RearViewCamera_SettingsApp();
    virtual void Perform_Switch_Media_SettingsApp();
    virtual void Perform_Switch_Tuner_SettingsApp();
    virtual void Perform_Brightness_Dec();
    virtual void Perform_Brightness_Inc();
    virtual void Perform_ClockHour_Dec();
    virtual void Perform_ClockHour_Inc();
    virtual void Perform_ClockMinute_Dec();
    virtual void Perform_ClockMinute_Inc();
    virtual void Perform_MediaRadioBack4mAudio();
    virtual void Perform_VideoMixedSourceBack4mCabinHome();
    virtual void Perform_LevelOff();
    virtual void Perform_LevelOne();
    virtual void Perform_LevelTwo();
    virtual void Perform_LevelThree();
    virtual void Perform_PrivateModeLevelOne();
    virtual void Perform_PrivateModeLevelTwo();
    virtual void Perform_PrivateModeLevelThree();
    virtual void Perform_EqlPrstFlat();
    virtual void Perform_EqlPrstPop();
    virtual void Perform_EqlPrstRock();
    virtual void Perform_EqlPrstHiphop();
    virtual void Perform_EqlPrstClassic();
    virtual void Perform_EqlPrstJazz();
    virtual void Perform_DTCSubSystemCMC19SwDetailsMsg(::FeatStd::UInt32 aCurrentSubSystemType);
    virtual void acPerformListRefresh(::FeatStd::UInt32 aListId);
    virtual void Perform_ClkDateFmt1();
    virtual void Notify_Init_Finished();
    virtual void Perform_ClkDateFmt2();
    virtual void Perform_ClkDateFmt3();
    virtual void Perform_ClkDateFmt4();
    virtual void Perform_ClkDateFmt5();
    virtual void Perform_ClkDateFmt6();
    virtual void Perform_SettingSceneMsg(::FeatStd::UInt16 aSettingType);
    virtual void acStartPopupTimer(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aTimeout);
    virtual void acRebootOnSWDLComplete();
    virtual void acHandleRebootOnUSBRemoval();
    virtual void acReqSWDLContextSwitchRequest();
    virtual void Perform_SWUpdate_Downgrade();
    virtual void Perform_DisplayClockScene();
    virtual void Perform_FactoryResetSM();
    virtual void Perform_FactoryResetSMBeep();
    virtual void gacChangeLanguageReq(::FeatStd::Int32 aLanguageId);
    virtual void gacHideFocusInViewReq(::FeatStd::UInt32 aView);
    virtual void NextLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PreviousLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void DualViewLeftTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void DualViewRightTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PageFlipBackTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PageFlipFrontTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void ZoomInTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos);
    virtual void ZoomOutTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos);
    virtual void FadeTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void gacWaitAnimationStartReq();
    virtual void acFocusOnRightEncoderReqUpd(bool aIsFocusUsed);
    virtual void acSetGadgetSceenActiveStatus(bool aIsGadgetAtive);
    virtual void acHKNotificationMsg(::FeatStd::Int8 aHKCode, ::FeatStd::Int8 aHKState);
    virtual void acPerform_CloseAllDropdowns();
    virtual void acPerform_CloseDropdown(::FeatStd::UInt32 aListId);
    virtual void acPerform_OpenDropdown(::FeatStd::UInt32 aListId);
    virtual void acPerform_ToggleDropdown(::FeatStd::UInt32 aListId);
    virtual void acStartAppPopupTimer(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aTimeout);
    virtual void acStopAppPopupTimer(::FeatStd::UInt32 aViewId);
    virtual void acPostBeep(::FeatStd::Int8 aBeepType);
    virtual void gacCheckToClosePopup(::FeatStd::UInt32 aPopupId);
    virtual void acRestartAppPopupTimer(::FeatStd::UInt32 aViewId);
    virtual void gacContextSwitchBackRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchCompleteRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchFailedRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchDoneRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchOutReq(::FeatStd::UInt32 aTargetContextId, ::FeatStd::UInt32 aSourceContextId, ::FeatStd::UInt32 aTargetAppId);
    virtual void gacCurrentScreenDisplayReq();
    virtual void gacLaunchBarDisplayReq(bool aVisibility);
    virtual void gacNavTBTSwipe();
    virtual void gacPerformListBtnRightEncoderChangeUpd(::FeatStd::Int8 aSteps, ::FeatStd::UInt32 aListId, ::FeatStd::UInt32 aRowId, ::FeatStd::UInt32 aColumnId);
    virtual void gacScrollListUp();
    virtual void gacScrollListDown();
    virtual void gacScrollPageUp();
    virtual void gacScrollPageDown();
    virtual void gacScrollListFocusUp(::FeatStd::UInt32 aListId);
    virtual void gacScrollListFocusDown(::FeatStd::UInt32 aListId);
    virtual void gacPerformListFocusLockDataResetUpd();
    virtual void gacSetApplicationMode(::FeatStd::UInt32 aModeId);
    virtual void gacSpellerBbehaviorReq(bool aEnable);
    virtual void gacStatusBarDisplayReq(bool aVisibility, ::FeatStd::Int32 aHeaderType);
    virtual void gacTBTRetriggerAcousticOutput();
    virtual void gacWaitAnimationStopReq();
    virtual void gacViewCreateReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateAllReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewDestroyReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewClearReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewHideReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateWithoutLoadReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewAsyncLoadReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewActivateWithoutRenderingReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupCreateAndSBShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupCreateAndSBShowReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacPopupSBCloseReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupSBCloseReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacPopupRestartTimerReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupRestartTimerReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateAndShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewHideAndDestroyReq(::FeatStd::UInt32 aViewId);
    virtual void gacSceneTransitionEnter(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint);
    virtual void gacSceneTransitionLeave(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint);
    virtual void gacDisplayStatusLineReq(::FeatStd::Int32 aDisplayRegionType);
    virtual void gacHideStatusLineReq(::FeatStd::Int32 aDisplayRegionType);
    virtual void gacDisplayFooterLineReq();
    virtual void gacHideFooterLineReq();
    virtual void gacDisplayStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacHideStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacDisplayFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacHideFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacRegisterForCloseOnTouchSession(::FeatStd::UInt32 aViewId);
    virtual void gacDeregisterForCloseOnTouchSessionReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupFilterPrioEnableReq(::FeatStd::UInt32 aPrio);
    virtual void gacPopupFilterAllEnableReq();
    virtual void gacPopupFilterDisableReq();
    virtual void gacProfileChange(::FeatStd::Int8 aProfile);
    virtual void gacPopupFilterPrioEnableReqForDisplay(::FeatStd::UInt32 aPrio, ::FeatStd::UInt32 aDisplayID);
    virtual void gacPopupFilterAllEnableReqForDisplay(::FeatStd::UInt32 aDisplayID);
    virtual void gacPopupFilterDisableReqForDisplay(::FeatStd::UInt32 aDisplayID);
    virtual void gacStartSceneTransitionAnimation(::FeatStd::UInt32 aSourceView, ::FeatStd::UInt32 aDestinationView, ::FeatStd::UInt32 aUserData1, ::FeatStd::Int8 aUserData2);
    virtual void gacDecrementActiveAnimationCount();

#ifdef CIT_SIMULATION
    bool CallAction(const ::FeatStd::Char* actionName, const ::Json::Value& parameters, ::Json::Value &response);
    const ::FeatStd::Char* GetEventName(::FeatStd::UInt32 eventId, ::Courier::Message const & message, Json::Value& eventArgument);
#endif
    // Added function for deduction of one event to simplify the event loop
    bool HandleDataBindingEventMapping(::Courier::AbstractDataItemMsg const & message, ::FeatStd::UInt32& eventId) const;
    bool HandleEventMapping(::Courier::Message const & message, ::FeatStd::UInt32& eventId) const;

    ::Cit::DeductResult::Enum DeductEvent(::Courier::Message const & message, ::FeatStd::UInt32 eventId);

    //====  member function with TTFis output - added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====

	virtual unsigned short GetTraceClass();
	int GetNumberOfStatemachines();
    //====  member function with TTFis output - end                        key: SM_TTFis_SBHFMSRF ====
};

// ------------------------------------------------------------------------
bool SendUpdatePopupTextReqMsg(enPopUpType const & aPopupTextID);
bool SendSystemInstallationMsg();
bool SendSWUpdateAbortRebootMsg();
bool SendOEMPinOkMsg();
bool SendStartUSBStickBinaryValidationReqMsg();
bool SendSetSoftwareUpdateTypeMsg(enSoftwareUpdateType const & aUpdateType);
bool SendEnableButtonsonNopopMsg();
bool SendStartDownloadReqMsg();
bool SendSetReleaseFilterReqMsg(enSoftwareDownloadMode const & aDownloadMode);
bool SendStartMISStageOneUpdateMsg();
bool SendrvcEntryView();
bool SendrvcExitView();
bool SendHandlePendingSWDLMsg();
bool SendChangeMeasurementvalueReqMsg(enMenu const & aMeasurementOptions, enReaction const & aReaction);
bool SendChangeClockTimeformatReqMsg(enTimeformatOption const & aTimeFormatOptions, enReaction const & aReaction);
bool SendChangeGpsClockTimeformatReqMsg(enGpsClkTimeformatOption const & aGpsTimeFormatOptions, enReaction const & aReaction);
bool SendChangeGpsClockClkModeReqMsg(enGpsClkClockModeformatOption const & aGpsClkClockModeOptions, enReaction const & aReaction);
bool SendChangeClockTimeZoneReqMsg(Courier::UInt16 const & aSelectedTimeZoneItem);
bool SendChangeClockformatReqMsg(enClockformatOption const & aClockFormatOptions, enReaction const & aReaction);
bool SendChangeAuxlevelvalueReqMsg(enAuxlevelOption const & aAuxLevelOptions, enReaction const & aReaction);
bool SendChangeDisplaySettingModevalueReqMsg(enDisplaySettingModeOption const & aDisplaySettingModeOptions, enReaction const & aReaction);
bool SendChangeLCDOnOff4GammaCASettingModevalReqMsg(enLCDOnOffGammaCASettingModeOption const & aLCDOnOffGammaCASettingModeOptions, enReaction const & aReaction);
bool SendChangeMonitorUpDown4GammaCASettingModevalReqMsg(enMonitorUpDownGammaCASettingModeOption const & aMonitorUpDownGammaCASettingModeOptions, enReaction const & aReaction);
bool SendSwitchApplicationReq(enApplicationId const & aApplicationID, enSurfaceId const & aSurfaceID);
bool SendSwitchCabin_A_ApplicationReq(enApplicationId const & aApplicationID, enSurfaceId const & aSurfaceID);
bool SendSwitchCabin_B_ApplicationReq(enApplicationId const & aApplicationID, enSurfaceId const & aSurfaceID);
bool SendChangeHourValueReq(Courier::UInt8 const & aHrValue_Incr_or_Decr);
bool SendChangeMinuteValueReq(Courier::UInt8 const & aMinuteValue_Incr_or_Decr);
bool SendTimeFormatPL_Msg(Courier::UInt8 const & aTimeFormat_12Hor24H);
bool SendCLKSetModePL_Msg(Courier::UInt8 const & aCLKSetModeGPS_Manual_PL);
bool SendDateFormat_PL_EU_HMI(Courier::UInt8 const & aDateEU);
bool SendDateFormat_PL_CN_HMI(Courier::UInt8 const & aDateCN);
bool SendChangeLanguageReq(Courier::UInt8 const & aRegion_ID, Courier::UInt8 const & aCountry_ID, Courier::UInt8 const & aLanguage_ID);
bool SendTimeZone_PL(Courier::UInt16 const & aTimeZone);
bool SendUpdateCLKSetModeResp(Courier::UInt8 const & aUpdated_CLKSetMode);
bool SendUpdate_EntryIDSoundSettings(Courier::UInt8 const & aEntryFromApp);
bool SendDayLightSaving_Touch_PL(bool const & aDayLightSaving_Touch);
bool SendSpeedLockChangeReqMsg(Courier::Int8 const & aSLCheckBoxStatus);
bool SendAS_Inc_Dec_Msg(Courier::Int8 const & aAS_Inc_Dec);
bool SendSwivelModeMsg(Courier::UInt8 const & aSelectedModeItem);
bool SendCockpitModeMsg(enBatterySaverModeType const & aCockpitModeStatus);
bool SendPopupStatusMsg(Courier::UInt32 const & aActiveViewId, Courier::UInt8 const & aPopupStatus);
bool SendSendPluginReq();
bool SendAS_AuxLevel_PL_Msg(Courier::Int8 const & aAS_AuxLevel_PL);
bool SendAS_Beep_Touch_PL_Msg(Courier::Int8 const & aAS_Beep_Touch_PL);
bool SendAS_Speed_Volume_PL_Msg(Courier::Int8 const & aAS_Speed_Volume_PL);
bool SendAS_Equilizer_PL_Msg(Courier::Int8 const & aAS_Equilizer_PL);
bool SendAS_SwitchSetting_Msg();
bool SendUpdateLanguageRegionCN_HMI(Candera::UInt8 const & aCandidateCN);
bool SendUpdateLanguageRegionGEX_HMI(Candera::UInt8 const & aCandidateGEX);
bool SendSwitchApplicationStateReq(Candera::UInt16 const & aApplicationID, Candera::UInt16 const & aApplicationState, Candera::UInt8 const & aActivityID);
bool SendSwitchToRVCApplication();
bool SendSwitchToMediaApplication();
bool SendSwitchToTunerApplication();
bool SendDecBrightnessLevelMsg();
bool SendIncBrightnessLevelMsg();
bool SendDecClockHourLevelMsg();
bool SendIncClockHourLevelMsg();
bool SendDecClockMinuteLevelMsg();
bool SendIncClockMinuteLevelMsg();
bool SendMediaRadioBack4mAudio();
bool SendVideoMixedSourceBack4mCabinHome();
bool SendLevelOff();
bool SendLevelOne();
bool SendLevelTwo();
bool SendLevelThree();
bool SendPrivateModeLevelOne();
bool SendPrivateModeLevelTwo();
bool SendPrivateModeLevelThree();
bool SendEqlPrstFlat();
bool SendEqlPrstPop();
bool SendEqlPrstRock();
bool SendEqlPrstHiphop();
bool SendEqlPrstClassic();
bool SendEqlPrstJazz();
bool SendDTCSubSystemCMC19SwDetailsMsg(Courier::UInt32 const & aCurrentSubSystemType);
bool SendListRefreshMsg(Courier::UInt32 const & aListId);
bool SendClkDateFmt1();
bool SendGuiStartupFinishedUpdMsg();
bool SendClkDateFmt2();
bool SendClkDateFmt3();
bool SendClkDateFmt4();
bool SendClkDateFmt5();
bool SendClkDateFmt6();
bool SendSettingSceneMsg(Courier::UInt16 const & aSettingType);
bool SendStartPopupTimerReqMsg(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout);
bool SendRebootOnSWDLCompleteMsg();
bool SendHandleRebootOnUSBRemovalMsg();
bool SendRequestMISupdateContextSwitchMsg();
bool SendStartSWDowngrade();
bool SendDisplayClockScene();
bool SendFactoryResetSM();
bool SendFactoryResetSMBeep();
bool SendChangeLanguageReqMsg(enLanguageId const & aLanguageId);
bool SendFocusReqMsg(FocusActionEnum const & aAction, FocusTimerActionEnum const & aTimerAction, ::Courier::ViewId const & aView, Candera::String const & aWidget);
bool SendDummyMess(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
bool SendAnimationReqMsg(Courier::AnimationAction::Enum const & aAnimationAction, ::Courier::ViewId const & aViewId, Courier::CompositePath const & aCompositePath, ::Courier::ItemId const & aAnimationId, Courier::AnimationProperties const & aAnimationProperties);
bool SendFocusOnRightEncoderReqUpdMsg(bool const & aIsFocusUsed);
bool SendStoreActiveGadgetReqMsg(bool const & aIsGadgetAtive);
bool SendHardKeyPressNotificationMsg(Courier::UInt8 const & aDummy, Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState);
bool SendDropdownChangeMsg(::Candera::DropdownChangeType const & aDropdownChangeType, ::Courier::UInt32 const & aListId);
bool SendStopPopupTimerReqMsg(Courier::UInt32 const & aViewId);
bool SendPlayBeepReqMsg(Courier::Int32 const & aBeepType);
bool SendCheckToClosePopupMsg(Courier::UInt32 const & aPopupId);
bool SendRestartPopupTimerReqMsg(Courier::UInt32 const & aViewId);
bool SendContextSwitchInResMsg(Courier::UInt32 const & aSwitchId, Courier::UInt32 const & aResponseType);
bool SendContextSwitchOutReqMsg(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId);
bool SendCurrentScreenDisplayReqMsg();
bool SendLaunchBarDisplayReqMsg(bool const & aVisibility);
bool SendNavTBTSwipeReqMsg();
bool SendListItemRightEncoderChangeUpdMsg(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId);
bool SendListChangeMsg(::Courier::UInt32 const & aListId, ListChangeType const & aListChangeType, ::Courier::Int32 const & aValue, ListChangeMsgSourceType const & aListChangeMsgSource, bool const & aImmediatePositioning);
bool SendListFocusScrollReqMsg(Courier::UInt32 const & aListId, Courier::Int32 const & aSteps);
bool SendListFocusLockDataResetReqMsg();
bool SendSetApplicationModeReqMsg(Courier::UInt32 const & aModeId);
bool SendSpellerBbehaviorReqMsg(bool const & aEnable);
bool SendStatusBarDisplayReqMsg(bool const & aVisibility, Courier::Int32 const & aHeaderType);
bool SendTBTRetriggerAcousticMsg();
bool SendViewReqMsg(Courier::ViewAction::Enum const & aViewAction, ::Courier::ViewId const & aViewId, bool const & aShallInitScene, bool const & aShallLoadScene);
bool SendActivationReqMsg(::Courier::ViewId const & aViewId, bool const & aActivation, bool const & aEnableRendering);
bool SendAsyncLoadReqMsg(::Courier::ViewId const & aViewId, bool const & aLoad);
bool SendPopupReqMsg(hmibase::popups::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aPopupDisplayID);
bool SendExtendedViewReqMsg(hmibase::views::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
bool SendShowHMISubSurfaceReqMsg(hmibase::displayRegion const & aDisplayRegion, Courier::Int32 const & aDisplayRegionType, bool const & aShowSubSurface, Courier::UInt32 const & aDisplayID, bool const & aLockSubSurface);
bool SendRegisterForCloseOnTouchSessionReqMsg(bool const & aRegister, ::Courier::ViewId const & aViewId);
bool SendPopupFilterPrioEnableReqMsg(Courier::UInt32 const & aPrio);
bool SendPopupFilterAllEnableReqMsg();
bool SendPopupFilterDisableReqMsg();
bool SendProfileSwitchMsg(Courier::UInt32 const & aProfile);
bool SendMultiDisplayPopupFilterReqMsg(hmibase::PopupFilterType const & aPopupFilterType, Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID);
bool SendCreateNewDestroyOld(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2);
bool SendNotifierMessage();

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acUpdatePopupText(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acUpdatePopupText(enPopUpType const & aPopupTextID);
#ifdef CIT_SIMULATION
bool CallAction_acSystemInstallation(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSystemInstallation();
#ifdef CIT_SIMULATION
bool CallAction_acSWUpdateAbortReboot(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSWUpdateAbortReboot();
#ifdef CIT_SIMULATION
bool CallAction_acOEMPinOk(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acOEMPinOk();
#ifdef CIT_SIMULATION
bool CallAction_acStartUSBStickBinaryValidation(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStartUSBStickBinaryValidation();
#ifdef CIT_SIMULATION
bool CallAction_acSetSoftwareUpdateType(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetSoftwareUpdateType(enSoftwareUpdateType const & aUpdateType);
#ifdef CIT_SIMULATION
bool CallAction_acEnableButtonsonNopopType(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acEnableButtonsonNopopType();
#ifdef CIT_SIMULATION
bool CallAction_acStartSoftwareDownload(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStartSoftwareDownload();
#ifdef CIT_SIMULATION
bool CallAction_acSetReleaseFilter(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetReleaseFilter(enSoftwareDownloadMode const & aDownloadMode);
#ifdef CIT_SIMULATION
bool CallAction_acStartMISStageOneUpdate(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStartMISStageOneUpdate();
#ifdef CIT_SIMULATION
bool CallAction_acRVCEntryViewUpdate(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acRVCEntryViewUpdate();
#ifdef CIT_SIMULATION
bool CallAction_acRVCExitViewupdate(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acRVCExitViewupdate();
#ifdef CIT_SIMULATION
bool CallAction_acHandlePendingSWDL(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acHandlePendingSWDL();
#ifdef CIT_SIMULATION
bool CallAction_ChangeMeasurementvalueReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ChangeMeasurementvalueReq(enMenu const & aMeasurementOptions);
#ifdef CIT_SIMULATION
bool CallAction_ChangeClockTimeformatReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ChangeClockTimeformatReq(enTimeformatOption const & aTimeFormatOptions);
#ifdef CIT_SIMULATION
bool CallAction_ChangeGpsClockTimeformatReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ChangeGpsClockTimeformatReq(enGpsClkTimeformatOption const & aGpsTimeFormatOptions);
#ifdef CIT_SIMULATION
bool CallAction_ChangeGpsClockClkModeReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ChangeGpsClockClkModeReq(enGpsClkClockModeformatOption const & aGpsClkClockModeOptions);
#ifdef CIT_SIMULATION
bool CallAction_ChangeClockTimeZoneReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ChangeClockTimeZoneReq(Courier::UInt16 const & aSelectedTimeZoneItem);
#ifdef CIT_SIMULATION
bool CallAction_ChangeClockformatReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ChangeClockformatReq(enClockformatOption const & aClockFormatOptions);
#ifdef CIT_SIMULATION
bool CallAction_ChangeAuxlevelvalueReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ChangeAuxlevelvalueReq(enAuxlevelOption const & aAuxLevelOptions);
#ifdef CIT_SIMULATION
bool CallAction_ChangeDisplaySettingModevalueReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ChangeDisplaySettingModevalueReq(enDisplaySettingModeOption const & aDisplaySettingModeOptions);
#ifdef CIT_SIMULATION
bool CallAction_ChangeLCDOnOff4GammaCASettingModevalReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ChangeLCDOnOff4GammaCASettingModevalReq(enLCDOnOffGammaCASettingModeOption const & aLCDOnOffGammaCASettingModeOptions);
#ifdef CIT_SIMULATION
bool CallAction_ChangeMonitorUpDown4GammaCASettingModevalReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ChangeMonitorUpDown4GammaCASettingModevalReq(enMonitorUpDownGammaCASettingModeOption const & aMonitorUpDownGammaCASettingModeOptions);
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_Home_Source(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Activate_Home_Source();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_RVC_Source(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Activate_RVC_Source();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_Home_Cabin_A(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Activate_Home_Cabin_A();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Activate_Home_Cabin_B(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Activate_Home_Cabin_B();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Hour_Dec(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Hour_Dec();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Hour_Inc(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Hour_Inc();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Minute_Dec(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Minute_Dec();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Minute_Inc(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Minute_Inc();
#ifdef CIT_SIMULATION
bool CallAction_Perform_TimeFormat12H(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_TimeFormat12H();
#ifdef CIT_SIMULATION
bool CallAction_Perform_TimeFormat24H(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_TimeFormat24H();
#ifdef CIT_SIMULATION
bool CallAction_Perform_CLKSetMode_GPS(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_CLKSetMode_GPS();
#ifdef CIT_SIMULATION
bool CallAction_Perform_CLKSetMode_Manual(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_CLKSetMode_Manual();
#ifdef CIT_SIMULATION
bool CallAction_DateFormat_EU_1(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DateFormat_EU_1();
#ifdef CIT_SIMULATION
bool CallAction_DateFormat_EU_2(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DateFormat_EU_2();
#ifdef CIT_SIMULATION
bool CallAction_DateFormat_EU_3(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DateFormat_EU_3();
#ifdef CIT_SIMULATION
bool CallAction_DateFormat_EU_4(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DateFormat_EU_4();
#ifdef CIT_SIMULATION
bool CallAction_DateFormat_EU_5(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DateFormat_EU_5();
#ifdef CIT_SIMULATION
bool CallAction_DateFormat_EU_6(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DateFormat_EU_6();
#ifdef CIT_SIMULATION
bool CallAction_DateFormat_CN_1(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DateFormat_CN_1();
#ifdef CIT_SIMULATION
bool CallAction_DateFormat_CN_2(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DateFormat_CN_2();
#ifdef CIT_SIMULATION
bool CallAction_Candidate_EU_1(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Candidate_EU_1();
#ifdef CIT_SIMULATION
bool CallAction_Candidate_EU_2(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Candidate_EU_2();
#ifdef CIT_SIMULATION
bool CallAction_Candidate_EU_3(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Candidate_EU_3();
#ifdef CIT_SIMULATION
bool CallAction_Candidate_EU_4(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Candidate_EU_4();
#ifdef CIT_SIMULATION
bool CallAction_Candidate_EU_5(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Candidate_EU_5();
#ifdef CIT_SIMULATION
bool CallAction_Candidate_EU_6(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Candidate_EU_6();
#ifdef CIT_SIMULATION
bool CallAction_Candidate_EU_7(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Candidate_EU_7();
#ifdef CIT_SIMULATION
bool CallAction_Candidate_EU_8(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Candidate_EU_8();
#ifdef CIT_SIMULATION
bool CallAction_Candidate_EU_9(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Candidate_EU_9();
#ifdef CIT_SIMULATION
bool CallAction_Candidate_EU_10(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Candidate_EU_10();
#ifdef CIT_SIMULATION
bool CallAction_Candidate_EU_11(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Candidate_EU_11();
#ifdef CIT_SIMULATION
bool CallAction_Candidate_EU_12(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Candidate_EU_12();
#ifdef CIT_SIMULATION
bool CallAction_Candidate_EU_13(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Candidate_EU_13();
#ifdef CIT_SIMULATION
bool CallAction_Candidate_EU_14(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Candidate_EU_14();
#ifdef CIT_SIMULATION
bool CallAction_Candidate_EU_15(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Candidate_EU_15();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_1(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_1();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_2(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_2();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_3(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_3();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_4(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_4();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_5(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_5();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_6(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_6();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_7(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_7();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_8(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_8();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_9(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_9();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_10(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_10();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_11(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_11();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_12(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_12();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_13(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_13();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_14(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_14();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_15(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_15();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_16(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_16();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_17(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_17();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_18(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_18();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_19(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_19();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_20(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_20();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_21(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_21();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_22(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_22();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_23(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_23();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_24(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_24();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_25(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_25();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_26(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_26();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_27(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_27();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_28(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_28();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_29(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_29();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_30(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_30();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_31(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_31();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_32(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_32();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_33(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_33();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_34(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_34();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_35(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_35();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_36(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_36();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_37(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_37();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_38(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_38();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_39(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_39();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_40(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_40();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_41(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_41();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_42(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_42();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_43(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_43();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_44(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_44();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_45(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_45();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_46(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_46();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_47(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_47();
#ifdef CIT_SIMULATION
bool CallAction_TimeZone_48(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_TimeZone_48();
#ifdef CIT_SIMULATION
bool CallAction_GoToGPS(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_GoToGPS();
#ifdef CIT_SIMULATION
bool CallAction_GoToManual(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_GoToManual();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Update_SoundSetting_Entry(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Update_SoundSetting_Entry(Courier::UInt8 const & aEntryFromApp);
#ifdef CIT_SIMULATION
bool CallAction_Perform_Touch(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Touch();
#ifdef CIT_SIMULATION
bool CallAction_Perform_SpeedLockTouch(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_SpeedLockTouch();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Bass_Dec(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Bass_Dec();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Bass_Inc(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Bass_Inc();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Treble_Dec(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Treble_Dec();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Treble_Inc(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Treble_Inc();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Balance_Inc(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Balance_Inc();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Balance_Dec(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Balance_Dec();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Fader_Inc(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Fader_Inc();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Fader_Dec(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Fader_Dec();
#ifdef CIT_SIMULATION
bool CallAction_acPerformSwivelSetRequest(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerformSwivelSetRequest(Courier::UInt8 const & aSelectedModeItem);
#ifdef CIT_SIMULATION
bool CallAction_PerformCockpitMode(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PerformCockpitMode(enBatterySaverModeType const & aCockpitModeStatus);
#ifdef CIT_SIMULATION
bool CallAction_acSendPopupStatus(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSendPopupStatus(Courier::UInt32 const & aActiveViewId, Courier::UInt8 const & aPopupStatus);
#ifdef CIT_SIMULATION
bool CallAction_acSendPluginReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSendPluginReq();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Aux_Loud(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Aux_Loud();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Aux_Middle(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Aux_Middle();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Aux_Quiet(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Aux_Quiet();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Beep(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Beep();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Touch_Click(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Touch_Click();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Speed_Off(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Speed_Off();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Speed_Level1(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Speed_Level1();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Speed_Level2(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Speed_Level2();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Speed_Level3(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Speed_Level3();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Equilizer_Flat(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Equilizer_Flat();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Equilizer_Pop(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Equilizer_Pop();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Equilizer_Rock(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Equilizer_Rock();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Equilizer_Hiphop(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Equilizer_Hiphop();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Equilizer_Classic(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Equilizer_Classic();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Equilizer_Jazz(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Equilizer_Jazz();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Back(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Back();
#ifdef CIT_SIMULATION
bool CallAction_SetLanguageReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_SetLanguageReq();
#ifdef CIT_SIMULATION
bool CallAction_Candidate_CN_1(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Candidate_CN_1();
#ifdef CIT_SIMULATION
bool CallAction_Candidate_CN_2(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Candidate_CN_2();
#ifdef CIT_SIMULATION
bool CallAction_Candidate_GEX_1(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Candidate_GEX_1();
#ifdef CIT_SIMULATION
bool CallAction_Candidate_GEX_2(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Candidate_GEX_2();
#ifdef CIT_SIMULATION
bool CallAction_Candidate_GEX_3(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Candidate_GEX_3();
#ifdef CIT_SIMULATION
bool CallAction_Candidate_GEX_4(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Candidate_GEX_4();
#ifdef CIT_SIMULATION
bool CallAction_Candidate_GEX_5(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Candidate_GEX_5();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Switch_SoundSettingsApp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Switch_SoundSettingsApp();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Switch_SecurityPINApp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Switch_SecurityPINApp();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Switch_RearViewCamera_SettingsApp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Switch_RearViewCamera_SettingsApp();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Switch_Media_SettingsApp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Switch_Media_SettingsApp();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Switch_Tuner_SettingsApp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Switch_Tuner_SettingsApp();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Brightness_Dec(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Brightness_Dec();
#ifdef CIT_SIMULATION
bool CallAction_Perform_Brightness_Inc(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_Brightness_Inc();
#ifdef CIT_SIMULATION
bool CallAction_Perform_ClockHour_Dec(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_ClockHour_Dec();
#ifdef CIT_SIMULATION
bool CallAction_Perform_ClockHour_Inc(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_ClockHour_Inc();
#ifdef CIT_SIMULATION
bool CallAction_Perform_ClockMinute_Dec(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_ClockMinute_Dec();
#ifdef CIT_SIMULATION
bool CallAction_Perform_ClockMinute_Inc(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_ClockMinute_Inc();
#ifdef CIT_SIMULATION
bool CallAction_Perform_MediaRadioBack4mAudio(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_MediaRadioBack4mAudio();
#ifdef CIT_SIMULATION
bool CallAction_Perform_VideoMixedSourceBack4mCabinHome(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_VideoMixedSourceBack4mCabinHome();
#ifdef CIT_SIMULATION
bool CallAction_Perform_LevelOff(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_LevelOff();
#ifdef CIT_SIMULATION
bool CallAction_Perform_LevelOne(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_LevelOne();
#ifdef CIT_SIMULATION
bool CallAction_Perform_LevelTwo(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_LevelTwo();
#ifdef CIT_SIMULATION
bool CallAction_Perform_LevelThree(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_LevelThree();
#ifdef CIT_SIMULATION
bool CallAction_Perform_PrivateModeLevelOne(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_PrivateModeLevelOne();
#ifdef CIT_SIMULATION
bool CallAction_Perform_PrivateModeLevelTwo(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_PrivateModeLevelTwo();
#ifdef CIT_SIMULATION
bool CallAction_Perform_PrivateModeLevelThree(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_PrivateModeLevelThree();
#ifdef CIT_SIMULATION
bool CallAction_Perform_EqlPrstFlat(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_EqlPrstFlat();
#ifdef CIT_SIMULATION
bool CallAction_Perform_EqlPrstPop(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_EqlPrstPop();
#ifdef CIT_SIMULATION
bool CallAction_Perform_EqlPrstRock(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_EqlPrstRock();
#ifdef CIT_SIMULATION
bool CallAction_Perform_EqlPrstHiphop(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_EqlPrstHiphop();
#ifdef CIT_SIMULATION
bool CallAction_Perform_EqlPrstClassic(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_EqlPrstClassic();
#ifdef CIT_SIMULATION
bool CallAction_Perform_EqlPrstJazz(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_EqlPrstJazz();
#ifdef CIT_SIMULATION
bool CallAction_Perform_DTCSubSystemCMC19SwDetailsMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_DTCSubSystemCMC19SwDetailsMsg(Courier::UInt32 const & aCurrentSubSystemType);
#ifdef CIT_SIMULATION
bool CallAction_acPerformListRefresh(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerformListRefresh(Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_Perform_ClkDateFmt1(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_ClkDateFmt1();
#ifdef CIT_SIMULATION
bool CallAction_Notify_Init_Finished(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Notify_Init_Finished();
#ifdef CIT_SIMULATION
bool CallAction_Perform_ClkDateFmt2(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_ClkDateFmt2();
#ifdef CIT_SIMULATION
bool CallAction_Perform_ClkDateFmt3(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_ClkDateFmt3();
#ifdef CIT_SIMULATION
bool CallAction_Perform_ClkDateFmt4(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_ClkDateFmt4();
#ifdef CIT_SIMULATION
bool CallAction_Perform_ClkDateFmt5(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_ClkDateFmt5();
#ifdef CIT_SIMULATION
bool CallAction_Perform_ClkDateFmt6(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_ClkDateFmt6();
#ifdef CIT_SIMULATION
bool CallAction_Perform_SettingSceneMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_SettingSceneMsg(Courier::UInt16 const & aSettingType);
#ifdef CIT_SIMULATION
bool CallAction_acStartPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStartPopupTimer(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout);
#ifdef CIT_SIMULATION
bool CallAction_acRebootOnSWDLComplete(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acRebootOnSWDLComplete();
#ifdef CIT_SIMULATION
bool CallAction_acHandleRebootOnUSBRemoval(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acHandleRebootOnUSBRemoval();
#ifdef CIT_SIMULATION
bool CallAction_acReqSWDLContextSwitchRequest(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acReqSWDLContextSwitchRequest();
#ifdef CIT_SIMULATION
bool CallAction_Perform_SWUpdate_Downgrade(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_SWUpdate_Downgrade();
#ifdef CIT_SIMULATION
bool CallAction_Perform_DisplayClockScene(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_DisplayClockScene();
#ifdef CIT_SIMULATION
bool CallAction_Perform_FactoryResetSM(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_FactoryResetSM();
#ifdef CIT_SIMULATION
bool CallAction_Perform_FactoryResetSMBeep(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Perform_FactoryResetSMBeep();
#ifdef CIT_SIMULATION
bool CallAction_gacChangeLanguageReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacChangeLanguageReq(enLanguageId const & aLanguageId);
#ifdef CIT_SIMULATION
bool CallAction_gacHideFocusInViewReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFocusInViewReq(::Courier::ViewId const & aView);
#ifdef CIT_SIMULATION
bool CallAction_NextLevelTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_NextLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PreviousLevelTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PreviousLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_DualViewLeftTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DualViewLeftTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_DualViewRightTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DualViewRightTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PageFlipBackTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PageFlipBackTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PageFlipFrontTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PageFlipFrontTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_ZoomInTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ZoomInTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
#ifdef CIT_SIMULATION
bool CallAction_ZoomOutTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ZoomOutTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
#ifdef CIT_SIMULATION
bool CallAction_FadeTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_FadeTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStartReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacWaitAnimationStartReq();
#ifdef CIT_SIMULATION
bool CallAction_acFocusOnRightEncoderReqUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acFocusOnRightEncoderReqUpd(bool const & aIsFocusUsed);
#ifdef CIT_SIMULATION
bool CallAction_acSetGadgetSceenActiveStatus(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetGadgetSceenActiveStatus(bool const & aIsGadgetAtive);
#ifdef CIT_SIMULATION
bool CallAction_acHKNotificationMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acHKNotificationMsg(Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseAllDropdowns(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_CloseAllDropdowns();
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_CloseDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_OpenDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_OpenDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_ToggleDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_ToggleDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acStartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStartAppPopupTimer(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout);
#ifdef CIT_SIMULATION
bool CallAction_acStopAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStopAppPopupTimer(Courier::UInt32 const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_acPostBeep(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPostBeep(Courier::Int32 const & aBeepType);
#ifdef CIT_SIMULATION
bool CallAction_gacCheckToClosePopup(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacCheckToClosePopup(Courier::UInt32 const & aPopupId);
#ifdef CIT_SIMULATION
bool CallAction_acRestartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acRestartAppPopupTimer(Courier::UInt32 const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchBackRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchBackRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchCompleteRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchCompleteRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchFailedRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchFailedRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchDoneRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchDoneRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchOutReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchOutReq(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId);
#ifdef CIT_SIMULATION
bool CallAction_gacCurrentScreenDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacCurrentScreenDisplayReq();
#ifdef CIT_SIMULATION
bool CallAction_gacLaunchBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacLaunchBarDisplayReq(bool const & aVisibility);
#ifdef CIT_SIMULATION
bool CallAction_gacNavTBTSwipe(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacNavTBTSwipe();
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListBtnRightEncoderChangeUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPerformListBtnRightEncoderChangeUpd(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId);
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListUp();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListDown();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollPageUp();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollPageDown();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListFocusUp(Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListFocusDown(Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListFocusLockDataResetUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPerformListFocusLockDataResetUpd();
#ifdef CIT_SIMULATION
bool CallAction_gacSetApplicationMode(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSetApplicationMode(Courier::UInt32 const & aModeId);
#ifdef CIT_SIMULATION
bool CallAction_gacSpellerBbehaviorReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSpellerBbehaviorReq(bool const & aEnable);
#ifdef CIT_SIMULATION
bool CallAction_gacStatusBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacStatusBarDisplayReq(bool const & aVisibility, Courier::Int32 const & aHeaderType);
#ifdef CIT_SIMULATION
bool CallAction_gacTBTRetriggerAcousticOutput(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacTBTRetriggerAcousticOutput();
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStopReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacWaitAnimationStopReq();
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAllReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateAllReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewDestroyReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewDestroyReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewClearReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewClearReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewHideReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateWithoutLoadReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateWithoutLoadReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewAsyncLoadReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewAsyncLoadReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewActivateWithoutRenderingReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupCreateAndSBShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupCreateAndSBShowReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupSBCloseReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupSBCloseReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupRestartTimerReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupRestartTimerReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAndShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateAndShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideAndDestroyReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewHideAndDestroyReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionEnter(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSceneTransitionEnter(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionLeave(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSceneTransitionLeave(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayStatusLineReq(Courier::Int32 const & aDisplayRegionType);
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideStatusLineReq(Courier::Int32 const & aDisplayRegionType);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayFooterLineReq();
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFooterLineReq();
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacRegisterForCloseOnTouchSession(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacDeregisterForCloseOnTouchSessionReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterPrioEnableReq(Courier::UInt32 const & aPrio);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterAllEnableReq();
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterDisableReq();
#ifdef CIT_SIMULATION
bool CallAction_gacProfileChange(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacProfileChange(Courier::UInt32 const & aProfile);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterPrioEnableReqForDisplay(Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterAllEnableReqForDisplay(Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterDisableReqForDisplay(Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacStartSceneTransitionAnimation(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacStartSceneTransitionAnimation(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2);
#ifdef CIT_SIMULATION
bool CallAction_gacDecrementActiveAnimationCount(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDecrementActiveAnimationCount();

// overall number of HierarchyNodes
static const ::FeatStd::UInt32 cGlobalDataItemHierarchyNodeCount = 248;
// overall number of DataItemDescriptor nodes
static const ::FeatStd::UInt32 cDataItemDescriptorCount = 248;
// overall number of BindingSources
static const ::FeatStd::UInt32 cBindingSourceCount = 72;
// maximum number of HierarchyNodes in a BindingSource
static const ::FeatStd::UInt32 cBindingSourceItemCountMax = 13;

// =========================================================================

class DropdownmenuComboDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 1;
    static const ::Courier::DataItemKey cDataItemKey = 127;

    typedef ::DropdownmenuComboData Data;

    DropdownmenuComboDataBindingSource();
};

typedef ::Courier::DataItemMsg< DropdownmenuComboDataBindingSource > DropdownmenuComboDataItemMsg;

// =========================================================================

class CheckBoxListItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 2;
    static const ::Courier::DataItemKey cDataItemKey = 200;

    typedef ::CheckBoxListItemData Data;

    CheckBoxListItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< CheckBoxListItemDataBindingSource > CheckBoxListItemDataItemMsg;

// =========================================================================

class SwVersionNodeSwitchItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 3;
    static const ::Courier::DataItemKey cDataItemKey = 209;

    typedef ::SwVersionNodeSwitchItemData Data;

    SwVersionNodeSwitchItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< SwVersionNodeSwitchItemDataBindingSource > SwVersionNodeSwitchItemDataItemMsg;

// =========================================================================

class SystemSettingsNodeSwitchItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 4;
    static const ::Courier::DataItemKey cDataItemKey = 134;

    typedef ::SystemSettingsNodeSwitchItemData Data;

    SystemSettingsNodeSwitchItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< SystemSettingsNodeSwitchItemDataBindingSource > SystemSettingsNodeSwitchItemDataItemMsg;

// =========================================================================

class DisplaySettingsModeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 5;
    static const ::Courier::DataItemKey cDataItemKey = 179;

    typedef ::DisplaySettingsModeData Data;

    DisplaySettingsModeDataBindingSource();
};

typedef ::Courier::DataItemMsg< DisplaySettingsModeDataBindingSource > DisplaySettingsModeDataItemMsg;

// =========================================================================

class DisplaySettingsBrightnessDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 6;
    static const ::Courier::DataItemKey cDataItemKey = 10;

    typedef ::DisplaySettingsBrightnessData Data;

    DisplaySettingsBrightnessDataBindingSource();
};

typedef ::Courier::DataItemMsg< DisplaySettingsBrightnessDataBindingSource > DisplaySettingsBrightnessDataItemMsg;

// =========================================================================

class BrightnessIncValDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 7;
    static const ::Courier::DataItemKey cDataItemKey = 139;

    typedef ::BrightnessIncValData Data;

    BrightnessIncValDataBindingSource();
};

typedef ::Courier::DataItemMsg< BrightnessIncValDataBindingSource > BrightnessIncValDataItemMsg;

// =========================================================================

class BrightnessDecValDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 8;
    static const ::Courier::DataItemKey cDataItemKey = 162;

    typedef ::BrightnessDecValData Data;

    BrightnessDecValDataBindingSource();
};

typedef ::Courier::DataItemMsg< BrightnessDecValDataBindingSource > BrightnessDecValDataItemMsg;

// =========================================================================

class GenPopupMsgDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 9;
    static const ::Courier::DataItemKey cDataItemKey = 66;

    typedef ::GenPopupMsgData Data;

    GenPopupMsgDataBindingSource();
};

typedef ::Courier::DataItemMsg< GenPopupMsgDataBindingSource > GenPopupMsgDataItemMsg;

// =========================================================================

class CAAudiolevelUpdateItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 10;
    static const ::Courier::DataItemKey cDataItemKey = 110;

    typedef ::CAAudiolevelUpdateItemData Data;

    CAAudiolevelUpdateItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< CAAudiolevelUpdateItemDataBindingSource > CAAudiolevelUpdateItemDataItemMsg;

// =========================================================================

class CAMICBeepAudiolevelUpdateItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 11;
    static const ::Courier::DataItemKey cDataItemKey = 108;

    typedef ::CAMICBeepAudiolevelUpdateItemData Data;

    CAMICBeepAudiolevelUpdateItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< CAMICBeepAudiolevelUpdateItemDataBindingSource > CAMICBeepAudiolevelUpdateItemDataItemMsg;

// =========================================================================

class BasslevelUpdateItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 12;
    static const ::Courier::DataItemKey cDataItemKey = 132;

    typedef ::BasslevelUpdateItemData Data;

    BasslevelUpdateItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< BasslevelUpdateItemDataBindingSource > BasslevelUpdateItemDataItemMsg;

// =========================================================================

class RVCBrightnessUpdateItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 13;
    static const ::Courier::DataItemKey cDataItemKey = 158;

    typedef ::RVCBrightnessUpdateItemData Data;

    RVCBrightnessUpdateItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< RVCBrightnessUpdateItemDataBindingSource > RVCBrightnessUpdateItemDataItemMsg;

// =========================================================================

class RVCContrastUpdateItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 14;
    static const ::Courier::DataItemKey cDataItemKey = 2;

    typedef ::RVCContrastUpdateItemData Data;

    RVCContrastUpdateItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< RVCContrastUpdateItemDataBindingSource > RVCContrastUpdateItemDataItemMsg;

// =========================================================================

class DispSettingValueUpdateItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 15;
    static const ::Courier::DataItemKey cDataItemKey = 14;

    typedef ::DispSettingValueUpdateItemData Data;

    DispSettingValueUpdateItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< DispSettingValueUpdateItemDataBindingSource > DispSettingValueUpdateItemDataItemMsg;

// =========================================================================

class HourValueUpdateItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 16;
    static const ::Courier::DataItemKey cDataItemKey = 227;

    typedef ::HourValueUpdateItemData Data;

    HourValueUpdateItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< HourValueUpdateItemDataBindingSource > HourValueUpdateItemDataItemMsg;

// =========================================================================

class TreblelevelUpdateItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 17;
    static const ::Courier::DataItemKey cDataItemKey = 182;

    typedef ::TreblelevelUpdateItemData Data;

    TreblelevelUpdateItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< TreblelevelUpdateItemDataBindingSource > TreblelevelUpdateItemDataItemMsg;

// =========================================================================

class BalancelevelUpdateItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 18;
    static const ::Courier::DataItemKey cDataItemKey = 126;

    typedef ::BalancelevelUpdateItemData Data;

    BalancelevelUpdateItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< BalancelevelUpdateItemDataBindingSource > BalancelevelUpdateItemDataItemMsg;

// =========================================================================

class LanguageSettingMenuDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 19;
    static const ::Courier::DataItemKey cDataItemKey = 170;

    typedef ::LanguageSettingMenuData Data;

    LanguageSettingMenuDataBindingSource();
};

typedef ::Courier::DataItemMsg< LanguageSettingMenuDataBindingSource > LanguageSettingMenuDataItemMsg;

// =========================================================================

class OEMPINKeyInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 20;
    static const ::Courier::DataItemKey cDataItemKey = 238;

    typedef ::OEMPINKeyInfoData Data;

    OEMPINKeyInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< OEMPINKeyInfoDataBindingSource > OEMPINKeyInfoDataItemMsg;

// =========================================================================

class OEMPINCursorStateDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 5;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 21;
    static const ::Courier::DataItemKey cDataItemKey = 180;

    typedef ::OEMPINCursorStateData Data;

    OEMPINCursorStateDataBindingSource();
};

typedef ::Courier::DataItemMsg< OEMPINCursorStateDataBindingSource > OEMPINCursorStateDataItemMsg;

// =========================================================================

class OEMPINEditableStateDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 5;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 22;
    static const ::Courier::DataItemKey cDataItemKey = 147;

    typedef ::OEMPINEditableStateData Data;

    OEMPINEditableStateDataBindingSource();
};

typedef ::Courier::DataItemMsg< OEMPINEditableStateDataBindingSource > OEMPINEditableStateDataItemMsg;

// =========================================================================

class OEMPIN1TextInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 23;
    static const ::Courier::DataItemKey cDataItemKey = 247;

    typedef ::OEMPIN1TextInfoData Data;

    OEMPIN1TextInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< OEMPIN1TextInfoDataBindingSource > OEMPIN1TextInfoDataItemMsg;

// =========================================================================

class OEMPIN2TextInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 24;
    static const ::Courier::DataItemKey cDataItemKey = 42;

    typedef ::OEMPIN2TextInfoData Data;

    OEMPIN2TextInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< OEMPIN2TextInfoDataBindingSource > OEMPIN2TextInfoDataItemMsg;

// =========================================================================

class OEMPIN3TextInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 25;
    static const ::Courier::DataItemKey cDataItemKey = 197;

    typedef ::OEMPIN3TextInfoData Data;

    OEMPIN3TextInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< OEMPIN3TextInfoDataBindingSource > OEMPIN3TextInfoDataItemMsg;

// =========================================================================

class OEMPIN4TextInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 26;
    static const ::Courier::DataItemKey cDataItemKey = 221;

    typedef ::OEMPIN4TextInfoData Data;

    OEMPIN4TextInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< OEMPIN4TextInfoDataBindingSource > OEMPIN4TextInfoDataItemMsg;

// =========================================================================

class OEMKey1InputDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 27;
    static const ::Courier::DataItemKey cDataItemKey = 176;

    typedef ::OEMKey1InputData Data;

    OEMKey1InputDataBindingSource();
};

typedef ::Courier::DataItemMsg< OEMKey1InputDataBindingSource > OEMKey1InputDataItemMsg;

// =========================================================================

class OEMKey2InputDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 28;
    static const ::Courier::DataItemKey cDataItemKey = 93;

    typedef ::OEMKey2InputData Data;

    OEMKey2InputDataBindingSource();
};

typedef ::Courier::DataItemMsg< OEMKey2InputDataBindingSource > OEMKey2InputDataItemMsg;

// =========================================================================

class OEMKey3InputDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 29;
    static const ::Courier::DataItemKey cDataItemKey = 131;

    typedef ::OEMKey3InputData Data;

    OEMKey3InputDataBindingSource();
};

typedef ::Courier::DataItemMsg< OEMKey3InputDataBindingSource > OEMKey3InputDataItemMsg;

// =========================================================================

class OEMKey4InputDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 30;
    static const ::Courier::DataItemKey cDataItemKey = 104;

    typedef ::OEMKey4InputData Data;

    OEMKey4InputDataBindingSource();
};

typedef ::Courier::DataItemMsg< OEMKey4InputDataBindingSource > OEMKey4InputDataItemMsg;

// =========================================================================

class OEMAuthenticationInfoTextDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 5;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 31;
    static const ::Courier::DataItemKey cDataItemKey = 69;

    typedef ::OEMAuthenticationInfoTextData Data;

    OEMAuthenticationInfoTextDataBindingSource();
};

typedef ::Courier::DataItemMsg< OEMAuthenticationInfoTextDataBindingSource > OEMAuthenticationInfoTextDataItemMsg;

// =========================================================================

class OEMSpeedLockUpdateDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 32;
    static const ::Courier::DataItemKey cDataItemKey = 202;

    typedef ::OEMSpeedLockUpdateData Data;

    OEMSpeedLockUpdateDataBindingSource();
};

typedef ::Courier::DataItemMsg< OEMSpeedLockUpdateDataBindingSource > OEMSpeedLockUpdateDataItemMsg;

// =========================================================================

class NaftaLang_SettingMenuDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 33;
    static const ::Courier::DataItemKey cDataItemKey = 72;

    typedef ::NaftaLang_SettingMenuData Data;

    NaftaLang_SettingMenuDataBindingSource();
};

typedef ::Courier::DataItemMsg< NaftaLang_SettingMenuDataBindingSource > NaftaLang_SettingMenuDataItemMsg;

// =========================================================================

class vmsCabinMenuDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 34;
    static const ::Courier::DataItemKey cDataItemKey = 75;

    typedef ::vmsCabinMenuData Data;

    vmsCabinMenuDataBindingSource();
};

typedef ::Courier::DataItemMsg< vmsCabinMenuDataBindingSource > vmsCabinMenuDataItemMsg;

// =========================================================================

class ClockHourSettingValueDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 35;
    static const ::Courier::DataItemKey cDataItemKey = 148;

    typedef ::ClockHourSettingValueData Data;

    ClockHourSettingValueDataBindingSource();
};

typedef ::Courier::DataItemMsg< ClockHourSettingValueDataBindingSource > ClockHourSettingValueDataItemMsg;

// =========================================================================

class ClockMinuteSettingValueDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 36;
    static const ::Courier::DataItemKey cDataItemKey = 13;

    typedef ::ClockMinuteSettingValueData Data;

    ClockMinuteSettingValueDataBindingSource();
};

typedef ::Courier::DataItemMsg< ClockMinuteSettingValueDataBindingSource > ClockMinuteSettingValueDataItemMsg;

// =========================================================================

class ClockTimeZoneDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 37;
    static const ::Courier::DataItemKey cDataItemKey = 175;

    typedef ::ClockTimeZoneData Data;

    ClockTimeZoneDataBindingSource();
};

typedef ::Courier::DataItemMsg< ClockTimeZoneDataBindingSource > ClockTimeZoneDataItemMsg;

// =========================================================================

class SpeedDependentVolumeControlDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 9;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 38;
    static const ::Courier::DataItemKey cDataItemKey = 27;

    typedef ::SpeedDependentVolumeControlData Data;

    SpeedDependentVolumeControlDataBindingSource();
};

typedef ::Courier::DataItemMsg< SpeedDependentVolumeControlDataBindingSource > SpeedDependentVolumeControlDataItemMsg;

// =========================================================================

class PrivateModeSettingDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 39;
    static const ::Courier::DataItemKey cDataItemKey = 67;

    typedef ::PrivateModeSettingData Data;

    PrivateModeSettingDataBindingSource();
};

typedef ::Courier::DataItemMsg< PrivateModeSettingDataBindingSource > PrivateModeSettingDataItemMsg;

// =========================================================================

class DTCHeadingUpdateItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 40;
    static const ::Courier::DataItemKey cDataItemKey = 165;

    typedef ::DTCHeadingUpdateItemData Data;

    DTCHeadingUpdateItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< DTCHeadingUpdateItemDataBindingSource > DTCHeadingUpdateItemDataItemMsg;

// =========================================================================

class SOASEquilizerPresetDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 13;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 41;
    static const ::Courier::DataItemKey cDataItemKey = 208;

    typedef ::SOASEquilizerPresetData Data;

    SOASEquilizerPresetDataBindingSource();
};

typedef ::Courier::DataItemMsg< SOASEquilizerPresetDataBindingSource > SOASEquilizerPresetDataItemMsg;

// =========================================================================

class ClockDateFormatDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 13;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 42;
    static const ::Courier::DataItemKey cDataItemKey = 160;

    typedef ::ClockDateFormatData Data;

    ClockDateFormatDataBindingSource();
};

typedef ::Courier::DataItemMsg< ClockDateFormatDataBindingSource > ClockDateFormatDataItemMsg;

// =========================================================================

class DateFmtUpdateItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 43;
    static const ::Courier::DataItemKey cDataItemKey = 48;

    typedef ::DateFmtUpdateItemData Data;

    DateFmtUpdateItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< DateFmtUpdateItemDataBindingSource > DateFmtUpdateItemDataItemMsg;

// =========================================================================

class MasterGadgetSystemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 44;
    static const ::Courier::DataItemKey cDataItemKey = 211;

    typedef ::MasterGadgetSystemData Data;

    MasterGadgetSystemDataBindingSource();
};

typedef ::Courier::DataItemMsg< MasterGadgetSystemDataBindingSource > MasterGadgetSystemDataItemMsg;

// =========================================================================

class SWUpdateDetailsDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 45;
    static const ::Courier::DataItemKey cDataItemKey = 4;

    typedef ::SWUpdateDetailsData Data;

    SWUpdateDetailsDataBindingSource();
};

typedef ::Courier::DataItemMsg< SWUpdateDetailsDataBindingSource > SWUpdateDetailsDataItemMsg;

// =========================================================================

class SWUpdateMainDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 12;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 46;
    static const ::Courier::DataItemKey cDataItemKey = 71;

    typedef ::SWUpdateMainData Data;

    SWUpdateMainDataBindingSource();
};

typedef ::Courier::DataItemMsg< SWUpdateMainDataBindingSource > SWUpdateMainDataItemMsg;

// =========================================================================

class SWUpdateHistoryDetailsDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 47;
    static const ::Courier::DataItemKey cDataItemKey = 149;

    typedef ::SWUpdateHistoryDetailsData Data;

    SWUpdateHistoryDetailsDataBindingSource();
};

typedef ::Courier::DataItemMsg< SWUpdateHistoryDetailsDataBindingSource > SWUpdateHistoryDetailsDataItemMsg;

// =========================================================================

class SwivelPopupDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 48;
    static const ::Courier::DataItemKey cDataItemKey = 40;

    typedef ::SwivelPopupData Data;

    SwivelPopupDataBindingSource();
};

typedef ::Courier::DataItemMsg< SwivelPopupDataBindingSource > SwivelPopupDataItemMsg;

// =========================================================================

class SWUpdateStickInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 49;
    static const ::Courier::DataItemKey cDataItemKey = 152;

    typedef ::SWUpdateStickInfoData Data;

    SWUpdateStickInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< SWUpdateStickInfoDataBindingSource > SWUpdateStickInfoDataItemMsg;

// =========================================================================

class SWQuickUpdateEnableDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 50;
    static const ::Courier::DataItemKey cDataItemKey = 174;

    typedef ::SWQuickUpdateEnableData Data;

    SWQuickUpdateEnableDataBindingSource();
};

typedef ::Courier::DataItemMsg< SWQuickUpdateEnableDataBindingSource > SWQuickUpdateEnableDataItemMsg;

// =========================================================================

class SWFullUpdateEnableDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 51;
    static const ::Courier::DataItemKey cDataItemKey = 171;

    typedef ::SWFullUpdateEnableData Data;

    SWFullUpdateEnableDataBindingSource();
};

typedef ::Courier::DataItemMsg< SWFullUpdateEnableDataBindingSource > SWFullUpdateEnableDataItemMsg;

// =========================================================================

class SWUpdateDetailsEnableDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 52;
    static const ::Courier::DataItemKey cDataItemKey = 190;

    typedef ::SWUpdateDetailsEnableData Data;

    SWUpdateDetailsEnableDataBindingSource();
};

typedef ::Courier::DataItemMsg< SWUpdateDetailsEnableDataBindingSource > SWUpdateDetailsEnableDataItemMsg;

// =========================================================================

class SWUpdatebackbuttonEnableDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 53;
    static const ::Courier::DataItemKey cDataItemKey = 74;

    typedef ::SWUpdatebackbuttonEnableData Data;

    SWUpdatebackbuttonEnableDataBindingSource();
};

typedef ::Courier::DataItemMsg< SWUpdatebackbuttonEnableDataBindingSource > SWUpdatebackbuttonEnableDataItemMsg;

// =========================================================================

class DownlaodTypeInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 54;
    static const ::Courier::DataItemKey cDataItemKey = 136;

    typedef ::DownlaodTypeInfoData Data;

    DownlaodTypeInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< DownlaodTypeInfoDataBindingSource > DownlaodTypeInfoDataItemMsg;

// =========================================================================

class SWUpdateNameSmartDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 55;
    static const ::Courier::DataItemKey cDataItemKey = 21;

    typedef ::SWUpdateNameSmartData Data;

    SWUpdateNameSmartDataBindingSource();
};

typedef ::Courier::DataItemMsg< SWUpdateNameSmartDataBindingSource > SWUpdateNameSmartDataItemMsg;

// =========================================================================

class PopupTextDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 9;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 56;
    static const ::Courier::DataItemKey cDataItemKey = 68;

    typedef ::PopupTextData Data;

    PopupTextDataBindingSource();
};

typedef ::Courier::DataItemMsg< PopupTextDataBindingSource > PopupTextDataItemMsg;

// =========================================================================

class SystemInstallationDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 10;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 57;
    static const ::Courier::DataItemKey cDataItemKey = 189;

    typedef ::SystemInstallationData Data;

    SystemInstallationDataBindingSource();
};

typedef ::Courier::DataItemMsg< SystemInstallationDataBindingSource > SystemInstallationDataItemMsg;

// =========================================================================

class SWDetailsTextDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 58;
    static const ::Courier::DataItemKey cDataItemKey = 80;

    typedef ::SWDetailsTextData Data;

    SWDetailsTextDataBindingSource();
};

typedef ::Courier::DataItemMsg< SWDetailsTextDataBindingSource > SWDetailsTextDataItemMsg;

// =========================================================================

class SWHistoryDetailsTextDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 5;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 59;
    static const ::Courier::DataItemKey cDataItemKey = 45;

    typedef ::SWHistoryDetailsTextData Data;

    SWHistoryDetailsTextDataBindingSource();
};

typedef ::Courier::DataItemMsg< SWHistoryDetailsTextDataBindingSource > SWHistoryDetailsTextDataItemMsg;

// =========================================================================

class SWUpdateResultsDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 60;
    static const ::Courier::DataItemKey cDataItemKey = 216;

    typedef ::SWUpdateResultsData Data;

    SWUpdateResultsDataBindingSource();
};

typedef ::Courier::DataItemMsg< SWUpdateResultsDataBindingSource > SWUpdateResultsDataItemMsg;

// =========================================================================

class SystemsettingMainIconDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 6;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 61;
    static const ::Courier::DataItemKey cDataItemKey = 50;

    typedef ::SystemsettingMainIconData Data;

    SystemsettingMainIconDataBindingSource();
};

typedef ::Courier::DataItemMsg< SystemsettingMainIconDataBindingSource > SystemsettingMainIconDataItemMsg;

// =========================================================================

class CabinAsettingMainIconDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 62;
    static const ::Courier::DataItemKey cDataItemKey = 49;

    typedef ::CabinAsettingMainIconData Data;

    CabinAsettingMainIconDataBindingSource();
};

typedef ::Courier::DataItemMsg< CabinAsettingMainIconDataBindingSource > CabinAsettingMainIconDataItemMsg;

// =========================================================================

class CabinBsettingMainIconDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 6;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 63;
    static const ::Courier::DataItemKey cDataItemKey = 121;

    typedef ::CabinBsettingMainIconData Data;

    CabinBsettingMainIconDataBindingSource();
};

typedef ::Courier::DataItemMsg< CabinBsettingMainIconDataBindingSource > CabinBsettingMainIconDataItemMsg;

// =========================================================================

class SystemsettingSwVerNDLanguageIconDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 64;
    static const ::Courier::DataItemKey cDataItemKey = 47;

    typedef ::SystemsettingSwVerNDLanguageIconData Data;

    SystemsettingSwVerNDLanguageIconDataBindingSource();
};

typedef ::Courier::DataItemMsg< SystemsettingSwVerNDLanguageIconDataBindingSource > SystemsettingSwVerNDLanguageIconDataItemMsg;

// =========================================================================

class speedlockUpdatesVisibilityDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 65;
    static const ::Courier::DataItemKey cDataItemKey = 188;

    typedef ::speedlockUpdatesVisibilityData Data;

    speedlockUpdatesVisibilityDataBindingSource();
};

typedef ::Courier::DataItemMsg< speedlockUpdatesVisibilityDataBindingSource > speedlockUpdatesVisibilityDataItemMsg;

// =========================================================================

class bluetoothVisibilityDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 66;
    static const ::Courier::DataItemKey cDataItemKey = 58;

    typedef ::bluetoothVisibilityData Data;

    bluetoothVisibilityDataBindingSource();
};

typedef ::Courier::DataItemMsg< bluetoothVisibilityDataBindingSource > bluetoothVisibilityDataItemMsg;

// =========================================================================

class PopUpButtonVisibilityDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 67;
    static const ::Courier::DataItemKey cDataItemKey = 95;

    typedef ::PopUpButtonVisibilityData Data;

    PopUpButtonVisibilityDataBindingSource();
};

typedef ::Courier::DataItemMsg< PopUpButtonVisibilityDataBindingSource > PopUpButtonVisibilityDataItemMsg;

// =========================================================================

class SWUpdateListItemEnableDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 68;
    static const ::Courier::DataItemKey cDataItemKey = 130;

    typedef ::SWUpdateListItemEnableData Data;

    SWUpdateListItemEnableDataBindingSource();
};

typedef ::Courier::DataItemMsg< SWUpdateListItemEnableDataBindingSource > SWUpdateListItemEnableDataItemMsg;

// =========================================================================

class MISStage1ResultsDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 69;
    static const ::Courier::DataItemKey cDataItemKey = 85;

    typedef ::MISStage1ResultsData Data;

    MISStage1ResultsDataBindingSource();
};

typedef ::Courier::DataItemMsg< MISStage1ResultsDataBindingSource > MISStage1ResultsDataItemMsg;

// =========================================================================

class ListScrollBarInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 70;
    static const ::Courier::DataItemKey cDataItemKey = 84;

    typedef ::ListScrollBarInfoData Data;

    ListScrollBarInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< ListScrollBarInfoDataBindingSource > ListScrollBarInfoDataItemMsg;

// =========================================================================

class CarModeVisibilityDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 71;
    static const ::Courier::DataItemKey cDataItemKey = 11;

    typedef ::CarModeVisibilityData Data;

    CarModeVisibilityDataBindingSource();
};

typedef ::Courier::DataItemMsg< CarModeVisibilityDataBindingSource > CarModeVisibilityDataItemMsg;

namespace ItemKey {
        static const ::Courier::DataItemKey InvalidItem = 0;
        static const ::Courier::DataItemKey RVCContrastUpdateItemItem = 2;
        static const ::Courier::DataItemKey SWUpdateDetailsItem = 4;
        static const ::Courier::DataItemKey DisplaySettingsBrightnessItem = 10;
        static const ::Courier::DataItemKey CarModeVisibilityItem = 11;
        static const ::Courier::DataItemKey ClockMinuteSettingValueItem = 13;
        static const ::Courier::DataItemKey DispSettingValueUpdateItemItem = 14;
        static const ::Courier::DataItemKey SWUpdateNameSmartItem = 21;
        static const ::Courier::DataItemKey SpeedDependentVolumeControlItem = 27;
        static const ::Courier::DataItemKey SwivelPopupItem = 40;
        static const ::Courier::DataItemKey OEMPIN2TextInfoItem = 42;
        static const ::Courier::DataItemKey SWHistoryDetailsTextItem = 45;
        static const ::Courier::DataItemKey SystemsettingSwVerNDLanguageIconItem = 47;
        static const ::Courier::DataItemKey DateFmtUpdateItemItem = 48;
        static const ::Courier::DataItemKey CabinAsettingMainIconItem = 49;
        static const ::Courier::DataItemKey SystemsettingMainIconItem = 50;
        static const ::Courier::DataItemKey bluetoothVisibilityItem = 58;
        static const ::Courier::DataItemKey GenPopupMsgItem = 66;
        static const ::Courier::DataItemKey PrivateModeSettingItem = 67;
        static const ::Courier::DataItemKey PopupTextItem = 68;
        static const ::Courier::DataItemKey OEMAuthenticationInfoTextItem = 69;
        static const ::Courier::DataItemKey SWUpdateMainItem = 71;
        static const ::Courier::DataItemKey NaftaLang_SettingMenuItem = 72;
        static const ::Courier::DataItemKey SWUpdatebackbuttonEnableItem = 74;
        static const ::Courier::DataItemKey vmsCabinMenuItem = 75;
        static const ::Courier::DataItemKey SWDetailsTextItem = 80;
        static const ::Courier::DataItemKey ListScrollBarInfoItem = 84;
        static const ::Courier::DataItemKey MISStage1ResultsItem = 85;
        static const ::Courier::DataItemKey OEMKey2InputItem = 93;
        static const ::Courier::DataItemKey PopUpButtonVisibilityItem = 95;
        static const ::Courier::DataItemKey OEMKey4InputItem = 104;
        static const ::Courier::DataItemKey CAMICBeepAudiolevelUpdateItemItem = 108;
        static const ::Courier::DataItemKey CAAudiolevelUpdateItemItem = 110;
        static const ::Courier::DataItemKey CabinBsettingMainIconItem = 121;
        static const ::Courier::DataItemKey BalancelevelUpdateItemItem = 126;
        static const ::Courier::DataItemKey DropdownmenuComboItem = 127;
        static const ::Courier::DataItemKey SWUpdateListItemEnableItem = 130;
        static const ::Courier::DataItemKey OEMKey3InputItem = 131;
        static const ::Courier::DataItemKey BasslevelUpdateItemItem = 132;
        static const ::Courier::DataItemKey SystemSettingsNodeSwitchItemItem = 134;
        static const ::Courier::DataItemKey DownlaodTypeInfoItem = 136;
        static const ::Courier::DataItemKey BrightnessIncValItem = 139;
        static const ::Courier::DataItemKey OEMPINEditableStateItem = 147;
        static const ::Courier::DataItemKey ClockHourSettingValueItem = 148;
        static const ::Courier::DataItemKey SWUpdateHistoryDetailsItem = 149;
        static const ::Courier::DataItemKey SWUpdateStickInfoItem = 152;
        static const ::Courier::DataItemKey RVCBrightnessUpdateItemItem = 158;
        static const ::Courier::DataItemKey ClockDateFormatItem = 160;
        static const ::Courier::DataItemKey BrightnessDecValItem = 162;
        static const ::Courier::DataItemKey DTCHeadingUpdateItemItem = 165;
        static const ::Courier::DataItemKey LanguageSettingMenuItem = 170;
        static const ::Courier::DataItemKey SWFullUpdateEnableItem = 171;
        static const ::Courier::DataItemKey SWQuickUpdateEnableItem = 174;
        static const ::Courier::DataItemKey ClockTimeZoneItem = 175;
        static const ::Courier::DataItemKey OEMKey1InputItem = 176;
        static const ::Courier::DataItemKey DisplaySettingsModeItem = 179;
        static const ::Courier::DataItemKey OEMPINCursorStateItem = 180;
        static const ::Courier::DataItemKey TreblelevelUpdateItemItem = 182;
        static const ::Courier::DataItemKey speedlockUpdatesVisibilityItem = 188;
        static const ::Courier::DataItemKey SystemInstallationItem = 189;
        static const ::Courier::DataItemKey SWUpdateDetailsEnableItem = 190;
        static const ::Courier::DataItemKey OEMPIN3TextInfoItem = 197;
        static const ::Courier::DataItemKey CheckBoxListItemItem = 200;
        static const ::Courier::DataItemKey OEMSpeedLockUpdateItem = 202;
        static const ::Courier::DataItemKey SOASEquilizerPresetItem = 208;
        static const ::Courier::DataItemKey SwVersionNodeSwitchItemItem = 209;
        static const ::Courier::DataItemKey MasterGadgetSystemItem = 211;
        static const ::Courier::DataItemKey SWUpdateResultsItem = 216;
        static const ::Courier::DataItemKey OEMPIN4TextInfoItem = 221;
        static const ::Courier::DataItemKey HourValueUpdateItemItem = 227;
        static const ::Courier::DataItemKey OEMPINKeyInfoItem = 238;
        static const ::Courier::DataItemKey OEMPIN1TextInfoItem = 247;

    namespace RVCContrastUpdateItem {
            static const ::Courier::DataItemKey RVCContrastIndexItem = 210;
    } // namespace RVCContrastUpdateItem

    namespace SWUpdateDetails {
            static const ::Courier::DataItemKey MainCurrentVersionItem = 151;
    } // namespace SWUpdateDetails

    namespace DisplaySettingsBrightness {
            static const ::Courier::DataItemKey CurrBrightnessValItem = 140;
    } // namespace DisplaySettingsBrightness

    namespace CarModeVisibility {
            static const ::Courier::DataItemKey VisibleStatusItem = 30;
    } // namespace CarModeVisibility

    namespace ClockMinuteSettingValue {
            static const ::Courier::DataItemKey CurrMinuteValItem = 38;
    } // namespace ClockMinuteSettingValue

    namespace DispSettingValueUpdateItem {
            static const ::Courier::DataItemKey DispLevelIndexItem = 235;
            static const ::Courier::DataItemKey GreyBrightnessTextCumImageItem = 241;
    } // namespace DispSettingValueUpdateItem

    namespace SWUpdateNameSmart {
            static const ::Courier::DataItemKey isVisbleItem = 218;
    } // namespace SWUpdateNameSmart

    namespace SpeedDependentVolumeControl {
            static const ::Courier::DataItemKey ToggleOFFItem = 111;
            static const ::Courier::DataItemKey ToggleLVL1Item = 39;
            static const ::Courier::DataItemKey ToggleLVL2Item = 87;
            static const ::Courier::DataItemKey ToggleLVL3Item = 223;
            static const ::Courier::DataItemKey ColorOFFItem = 239;
            static const ::Courier::DataItemKey ColorLVL1Item = 198;
            static const ::Courier::DataItemKey ColorLVL2Item = 213;
            static const ::Courier::DataItemKey ColorLVL3Item = 232;
    } // namespace SpeedDependentVolumeControl

    namespace SwivelPopup {
            static const ::Courier::DataItemKey ActiveSwivelStateAutoItem = 36;
            static const ::Courier::DataItemKey ActiveSwivelStateUpItem = 120;
            static const ::Courier::DataItemKey ActiveSwivelStateDownItem = 81;
    } // namespace SwivelPopup

    namespace OEMPIN2TextInfo {
            static const ::Courier::DataItemKey TextItem = 157;
    } // namespace OEMPIN2TextInfo

    namespace SWHistoryDetailsText {
            static const ::Courier::DataItemKey devicenameItem = 54;
            static const ::Courier::DataItemKey modulenameItem = 99;
            static const ::Courier::DataItemKey submoduleItem = 212;
            static const ::Courier::DataItemKey submoduleversionItem = 119;
    } // namespace SWHistoryDetailsText

    namespace SystemsettingSwVerNDLanguageIcon {
            static const ::Courier::DataItemKey SystemSwVerNDLanguageIconNormalBitmapItem = 79;
            static const ::Courier::DataItemKey SystemSwVerNDLanguageIconPressedBitmapItem = 37;
            static const ::Courier::DataItemKey SystemSwVerNDLanguageIconFocusedBitmapItem = 142;
    } // namespace SystemsettingSwVerNDLanguageIcon

    namespace DateFmtUpdateItem {
            static const ::Courier::DataItemKey DateItemItem = 43;
    } // namespace DateFmtUpdateItem

    namespace CabinAsettingMainIcon {
            static const ::Courier::DataItemKey CabinAMainIconNormalBitmapItem = 243;
            static const ::Courier::DataItemKey CabinAMainIconPressedBitmapItem = 5;
            static const ::Courier::DataItemKey CabinAMainIconFocusedBitmapItem = 204;
            static const ::Courier::DataItemKey CabinAMainIconDisbaledBitmapItem = 125;
            static const ::Courier::DataItemKey CabinAMainNameInfoItem = 244;
            static const ::Courier::DataItemKey CabinAMainActiveTextInfoItem = 231;
    } // namespace CabinAsettingMainIcon

    namespace SystemsettingMainIcon {
            static const ::Courier::DataItemKey SystemMainIconNormalBitmapItem = 62;
            static const ::Courier::DataItemKey SystemMainIconPressedBitmapItem = 26;
            static const ::Courier::DataItemKey SystemMainIconFocusedBitmapItem = 77;
            static const ::Courier::DataItemKey SystemMainNameInfoItem = 106;
            static const ::Courier::DataItemKey SystemMainActiveTextInfoItem = 172;
    } // namespace SystemsettingMainIcon

    namespace bluetoothVisibility {
            static const ::Courier::DataItemKey ButtonHighlightItem = 206;
    } // namespace bluetoothVisibility

    namespace GenPopupMsg {
            static const ::Courier::DataItemKey CurrMsgItem = 70;
    } // namespace GenPopupMsg

    namespace PrivateModeSetting {
            static const ::Courier::DataItemKey Private_1_ToggleItem = 22;
            static const ::Courier::DataItemKey Private_2_ToggleItem = 183;
            static const ::Courier::DataItemKey Private_3_ToggleItem = 12;
            static const ::Courier::DataItemKey Private_1_ColorChgItem = 8;
            static const ::Courier::DataItemKey Private_2_ColorChgItem = 97;
            static const ::Courier::DataItemKey Private_3_ColorChgItem = 92;
    } // namespace PrivateModeSetting

    namespace PopupText {
            static const ::Courier::DataItemKey Line1Item = 159;
            static const ::Courier::DataItemKey Line2Item = 168;
            static const ::Courier::DataItemKey Line3Item = 185;
            static const ::Courier::DataItemKey Line4Item = 201;
            static const ::Courier::DataItemKey Line5Item = 222;
            static const ::Courier::DataItemKey Line6Item = 236;
            static const ::Courier::DataItemKey ProgressValueItem = 146;
            static const ::Courier::DataItemKey ProgressValueStrItem = 7;
    } // namespace PopupText

    namespace OEMAuthenticationInfoText {
            static const ::Courier::DataItemKey TextItem = 114;
            static const ::Courier::DataItemKey TextColorItem = 194;
            static const ::Courier::DataItemKey SpellerEnableItem = 242;
            static const ::Courier::DataItemKey ActiveStatusItem = 88;
    } // namespace OEMAuthenticationInfoText

    namespace SWUpdateMain {
            static const ::Courier::DataItemKey MediaVersionItem = 98;
            static const ::Courier::DataItemKey CurrentVersionItem = 34;
            static const ::Courier::DataItemKey IsNeedFlashingItem = 28;
            static const ::Courier::DataItemKey EstimatedTimeItem = 89;
            static const ::Courier::DataItemKey SameversionTextItem = 150;
            static const ::Courier::DataItemKey IsSameversionTextvisibleItem = 137;
            static const ::Courier::DataItemKey EstimatedTimeofFotaItem = 116;
            static const ::Courier::DataItemKey EstimatedTotalOtaTimeItem = 187;
            static const ::Courier::DataItemKey EstimatedMinutesItem = 246;
            static const ::Courier::DataItemKey CustomerPopupDetailsItem = 61;
            static const ::Courier::DataItemKey BackGroundUpdTextInfoItem = 141;
    } // namespace SWUpdateMain

    namespace NaftaLang_SettingMenu {
            static const ::Courier::DataItemKey naftalang_valItem = 35;
            static const ::Courier::DataItemKey naftalang_ActiveColorItem = 56;
    } // namespace NaftaLang_SettingMenu

    namespace SWUpdatebackbuttonEnable {
            static const ::Courier::DataItemKey ButtonenableItem = 96;
    } // namespace SWUpdatebackbuttonEnable

    namespace vmsCabinMenu {
            static const ::Courier::DataItemKey vmsSourceNameItem = 20;
            static const ::Courier::DataItemKey vmsSourceRadioBtnEnDisbItem = 16;
            static const ::Courier::DataItemKey vmsSourceTextEnDisbItem = 138;
    } // namespace vmsCabinMenu

    namespace SWDetailsText {
            static const ::Courier::DataItemKey SubModuleNameItem = 31;
            static const ::Courier::DataItemKey CurrentVersionItem = 169;
            static const ::Courier::DataItemKey MediaVersionItem = 135;
    } // namespace SWDetailsText

    namespace ListScrollBarInfo {
            static const ::Courier::DataItemKey EnabledItem = 217;
    } // namespace ListScrollBarInfo

    namespace MISStage1Results {
            static const ::Courier::DataItemKey AbortButtonEnableItem = 103;
            static const ::Courier::DataItemKey NextbuttonEnableItem = 55;
            static const ::Courier::DataItemKey DetailsbuttonEnableItem = 46;
    } // namespace MISStage1Results

    namespace OEMKey2Input {
            static const ::Courier::DataItemKey TextItem = 105;
    } // namespace OEMKey2Input

    namespace PopUpButtonVisibility {
            static const ::Courier::DataItemKey ButtonVisibilityItem = 233;
    } // namespace PopUpButtonVisibility

    namespace OEMKey4Input {
            static const ::Courier::DataItemKey TextItem = 230;
    } // namespace OEMKey4Input

    namespace CAMICBeepAudiolevelUpdateItem {
            static const ::Courier::DataItemKey CAMicBeepAudiolevelIndexItem = 245;
    } // namespace CAMICBeepAudiolevelUpdateItem

    namespace CAAudiolevelUpdateItem {
            static const ::Courier::DataItemKey CAAudiolevelIndexItem = 203;
    } // namespace CAAudiolevelUpdateItem

    namespace CabinBsettingMainIcon {
            static const ::Courier::DataItemKey CabinBMainIconNormalBitmapItem = 219;
            static const ::Courier::DataItemKey CabinBMainIconPressedBitmapItem = 220;
            static const ::Courier::DataItemKey CabinBMainIconFocusedBitmapItem = 65;
            static const ::Courier::DataItemKey CabinBMainNameInfoItem = 226;
            static const ::Courier::DataItemKey CabinBMainActiveTextInfoItem = 52;
    } // namespace CabinBsettingMainIcon

    namespace BalancelevelUpdateItem {
            static const ::Courier::DataItemKey BalancelevelIndexItem = 155;
    } // namespace BalancelevelUpdateItem

    namespace DropdownmenuCombo {
            static const ::Courier::DataItemKey ItemItem = 195;
            static const ::Courier::DataItemKey ItemvalueItem = 192;
    } // namespace DropdownmenuCombo

    namespace SWUpdateListItemEnable {
            static const ::Courier::DataItemKey ButtonEnableItem = 73;
    } // namespace SWUpdateListItemEnable

    namespace OEMKey3Input {
            static const ::Courier::DataItemKey TextItem = 186;
    } // namespace OEMKey3Input

    namespace BasslevelUpdateItem {
            static const ::Courier::DataItemKey BasslevelIndexItem = 145;
    } // namespace BasslevelUpdateItem

    namespace SystemSettingsNodeSwitchItem {
            static const ::Courier::DataItemKey isWaitAnimationEnabledItem = 237;
    } // namespace SystemSettingsNodeSwitchItem

    namespace DownlaodTypeInfo {
            static const ::Courier::DataItemKey DownlaodTypeItem = 123;
    } // namespace DownlaodTypeInfo

    namespace BrightnessIncVal {
            static const ::Courier::DataItemKey isClicked_IncItem = 23;
    } // namespace BrightnessIncVal

    namespace OEMPINEditableState {
            static const ::Courier::DataItemKey EditableState1Item = 240;
            static const ::Courier::DataItemKey EditableState2Item = 193;
            static const ::Courier::DataItemKey EditableState3Item = 207;
            static const ::Courier::DataItemKey EditableState4Item = 173;
    } // namespace OEMPINEditableState

    namespace ClockHourSettingValue {
            static const ::Courier::DataItemKey CurrHourValItem = 51;
    } // namespace ClockHourSettingValue

    namespace SWUpdateHistoryDetails {
            static const ::Courier::DataItemKey HistoryDetailItem = 117;
    } // namespace SWUpdateHistoryDetails

    namespace SWUpdateStickInfo {
            static const ::Courier::DataItemKey ValidDownloadStickStatusItem = 225;
            static const ::Courier::DataItemKey UsbStickAvailableStatusItem = 118;
            static const ::Courier::DataItemKey IsNotSameVersionItem = 17;
    } // namespace SWUpdateStickInfo

    namespace RVCBrightnessUpdateItem {
            static const ::Courier::DataItemKey RVCBrightnessIndexItem = 196;
    } // namespace RVCBrightnessUpdateItem

    namespace ClockDateFormat {
            static const ::Courier::DataItemKey ToggleClkDateFmt1Item = 163;
            static const ::Courier::DataItemKey ToggleClkDateFmt2Item = 229;
            static const ::Courier::DataItemKey ToggleClkDateFmt3Item = 33;
            static const ::Courier::DataItemKey ToggleClkDateFmt4Item = 90;
            static const ::Courier::DataItemKey ToggleClkDateFmt5Item = 3;
            static const ::Courier::DataItemKey ToggleClkDateFmt6Item = 41;
            static const ::Courier::DataItemKey ColorClkDateFmt1Item = 18;
            static const ::Courier::DataItemKey ColorClkDateFmt2Item = 102;
            static const ::Courier::DataItemKey ColorClkDateFmt3Item = 59;
            static const ::Courier::DataItemKey ColorClkDateFmt4Item = 215;
            static const ::Courier::DataItemKey ColorClkDateFmt5Item = 15;
            static const ::Courier::DataItemKey ColorClkDateFmt6Item = 32;
    } // namespace ClockDateFormat

    namespace BrightnessDecVal {
            static const ::Courier::DataItemKey isClicked_DecItem = 83;
    } // namespace BrightnessDecVal

    namespace DTCHeadingUpdateItem {
            static const ::Courier::DataItemKey DTCHeadingDataItem = 91;
    } // namespace DTCHeadingUpdateItem

    namespace LanguageSettingMenu {
            static const ::Courier::DataItemKey languagevalItem = 144;
            static const ::Courier::DataItemKey LanguageActiveColorTextInfoItem = 153;
    } // namespace LanguageSettingMenu

    namespace SWFullUpdateEnable {
            static const ::Courier::DataItemKey ButtonenableItem = 76;
    } // namespace SWFullUpdateEnable

    namespace SWQuickUpdateEnable {
            static const ::Courier::DataItemKey ButtonenableItem = 143;
    } // namespace SWQuickUpdateEnable

    namespace ClockTimeZone {
            static const ::Courier::DataItemKey OFFSetHourTextItem = 82;
            static const ::Courier::DataItemKey OFFSetMinuteTextItem = 191;
    } // namespace ClockTimeZone

    namespace OEMKey1Input {
            static const ::Courier::DataItemKey TextItem = 228;
    } // namespace OEMKey1Input

    namespace DisplaySettingsMode {
            static const ::Courier::DataItemKey CurrModeValItem = 64;
    } // namespace DisplaySettingsMode

    namespace OEMPINCursorState {
            static const ::Courier::DataItemKey State1Item = 214;
            static const ::Courier::DataItemKey State2Item = 199;
            static const ::Courier::DataItemKey State3Item = 133;
            static const ::Courier::DataItemKey State4Item = 234;
    } // namespace OEMPINCursorState

    namespace TreblelevelUpdateItem {
            static const ::Courier::DataItemKey TreblelevelIndexItem = 184;
    } // namespace TreblelevelUpdateItem

    namespace speedlockUpdatesVisibility {
            static const ::Courier::DataItemKey SpeedlocktextVisibilityItem = 94;
            static const ::Courier::DataItemKey SpeedlocktextVisibility_1Item = 166;
    } // namespace speedlockUpdatesVisibility

    namespace SystemInstallation {
            static const ::Courier::DataItemKey SysInstallationProgressValueItem = 154;
            static const ::Courier::DataItemKey SysInstallationProgressValueStrItem = 9;
            static const ::Courier::DataItemKey Textbox1VisibilityItem = 224;
            static const ::Courier::DataItemKey Textbox2VisibilityItem = 60;
            static const ::Courier::DataItemKey Textbox3VisibilityItem = 44;
            static const ::Courier::DataItemKey Textbox4VisibilityItem = 156;
            static const ::Courier::DataItemKey Textbox5VisibilityItem = 112;
            static const ::Courier::DataItemKey WaitAnimationVisibilityItem = 109;
            static const ::Courier::DataItemKey FailureMessageItem = 128;
    } // namespace SystemInstallation

    namespace SWUpdateDetailsEnable {
            static const ::Courier::DataItemKey ButtonenableItem = 78;
    } // namespace SWUpdateDetailsEnable

    namespace OEMPIN3TextInfo {
            static const ::Courier::DataItemKey TextItem = 25;
    } // namespace OEMPIN3TextInfo

    namespace CheckBoxListItem {
            static const ::Courier::DataItemKey ToggleIconSwitchIndexItem = 177;
    } // namespace CheckBoxListItem

    namespace OEMSpeedLockUpdate {
            static const ::Courier::DataItemKey statusItem = 129;
    } // namespace OEMSpeedLockUpdate

    namespace SOASEquilizerPreset {
            static const ::Courier::DataItemKey ToggleEqlPrstFLATItem = 113;
            static const ::Courier::DataItemKey ToggleEqlPrstPOPItem = 167;
            static const ::Courier::DataItemKey ToggleEqlPrstROCKItem = 115;
            static const ::Courier::DataItemKey ToggleEqlPrstHIPHOPItem = 63;
            static const ::Courier::DataItemKey ToggleEqlPrstCLASSICItem = 57;
            static const ::Courier::DataItemKey ToggleEqlPrstJAZZItem = 24;
            static const ::Courier::DataItemKey ColorEqlPrstFLATItem = 205;
            static const ::Courier::DataItemKey ColorEqlPrstPOPItem = 178;
            static const ::Courier::DataItemKey ColorEqlPrstROCKItem = 107;
            static const ::Courier::DataItemKey ColorEqlPrstHIPHOPItem = 164;
            static const ::Courier::DataItemKey ColorEqlPrstCLASSICItem = 19;
            static const ::Courier::DataItemKey ColorEqlPrstJAZZItem = 161;
    } // namespace SOASEquilizerPreset

    namespace SwVersionNodeSwitchItem {
            static const ::Courier::DataItemKey ToggleNodeIndexItem = 122;
    } // namespace SwVersionNodeSwitchItem

    namespace MasterGadgetSystem {
            static const ::Courier::DataItemKey TimevalueItem = 124;
            static const ::Courier::DataItemKey TimeAmPmItem = 101;
    } // namespace MasterGadgetSystem

    namespace SWUpdateResults {
            static const ::Courier::DataItemKey ComponentNameItem = 86;
            static const ::Courier::DataItemKey UpdateResultItem = 29;
            static const ::Courier::DataItemKey ReservedItem = 1;
    } // namespace SWUpdateResults

    namespace OEMPIN4TextInfo {
            static const ::Courier::DataItemKey TextItem = 181;
    } // namespace OEMPIN4TextInfo

    namespace HourValueUpdateItem {
            static const ::Courier::DataItemKey HourValueIndexItem = 6;
    } // namespace HourValueUpdateItem

    namespace OEMPINKeyInfo {
            static const ::Courier::DataItemKey PressedKeyItem = 53;
    } // namespace OEMPINKeyInfo

    namespace OEMPIN1TextInfo {
            static const ::Courier::DataItemKey TextItem = 100;
    } // namespace OEMPIN1TextInfo
} // namespace ItemKey

bool InitDataBinding();

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DropdownmenuComboDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DropdownmenuComboDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::CheckBoxListItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::CheckBoxListItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SwVersionNodeSwitchItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SwVersionNodeSwitchItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SystemSettingsNodeSwitchItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SystemSettingsNodeSwitchItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DisplaySettingsModeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DisplaySettingsModeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DisplaySettingsBrightnessDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DisplaySettingsBrightnessDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BrightnessIncValDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BrightnessIncValDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BrightnessDecValDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BrightnessDecValDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::GenPopupMsgDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::GenPopupMsgDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::CAAudiolevelUpdateItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::CAAudiolevelUpdateItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::CAMICBeepAudiolevelUpdateItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::CAMICBeepAudiolevelUpdateItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BasslevelUpdateItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BasslevelUpdateItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::RVCBrightnessUpdateItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::RVCBrightnessUpdateItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::RVCContrastUpdateItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::RVCContrastUpdateItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DispSettingValueUpdateItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DispSettingValueUpdateItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HourValueUpdateItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HourValueUpdateItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TreblelevelUpdateItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TreblelevelUpdateItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BalancelevelUpdateItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BalancelevelUpdateItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::LanguageSettingMenuDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::LanguageSettingMenuDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::OEMPINKeyInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::OEMPINKeyInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::OEMPINCursorStateDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::OEMPINCursorStateDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::OEMPINEditableStateDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::OEMPINEditableStateDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::OEMPIN1TextInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::OEMPIN1TextInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::OEMPIN2TextInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::OEMPIN2TextInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::OEMPIN3TextInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::OEMPIN3TextInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::OEMPIN4TextInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::OEMPIN4TextInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::OEMKey1InputDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::OEMKey1InputDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::OEMKey2InputDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::OEMKey2InputDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::OEMKey3InputDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::OEMKey3InputDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::OEMKey4InputDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::OEMKey4InputDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::OEMAuthenticationInfoTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::OEMAuthenticationInfoTextDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::OEMSpeedLockUpdateDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::OEMSpeedLockUpdateDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::NaftaLang_SettingMenuDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::NaftaLang_SettingMenuDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::vmsCabinMenuDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::vmsCabinMenuDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ClockHourSettingValueDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ClockHourSettingValueDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ClockMinuteSettingValueDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ClockMinuteSettingValueDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ClockTimeZoneDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ClockTimeZoneDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SpeedDependentVolumeControlDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SpeedDependentVolumeControlDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PrivateModeSettingDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PrivateModeSettingDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DTCHeadingUpdateItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DTCHeadingUpdateItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SOASEquilizerPresetDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SOASEquilizerPresetDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ClockDateFormatDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ClockDateFormatDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DateFmtUpdateItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DateFmtUpdateItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MasterGadgetSystemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MasterGadgetSystemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SWUpdateDetailsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SWUpdateDetailsDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SWUpdateMainDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SWUpdateMainDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SWUpdateHistoryDetailsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SWUpdateHistoryDetailsDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SwivelPopupDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SwivelPopupDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SWUpdateStickInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SWUpdateStickInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SWQuickUpdateEnableDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SWQuickUpdateEnableDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SWFullUpdateEnableDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SWFullUpdateEnableDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SWUpdateDetailsEnableDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SWUpdateDetailsEnableDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SWUpdatebackbuttonEnableDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SWUpdatebackbuttonEnableDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DownlaodTypeInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DownlaodTypeInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SWUpdateNameSmartDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SWUpdateNameSmartDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PopupTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PopupTextDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SystemInstallationDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SystemInstallationDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SWDetailsTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SWDetailsTextDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SWHistoryDetailsTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SWHistoryDetailsTextDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SWUpdateResultsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SWUpdateResultsDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SystemsettingMainIconDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SystemsettingMainIconDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::CabinAsettingMainIconDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::CabinAsettingMainIconDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::CabinBsettingMainIconDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::CabinBsettingMainIconDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SystemsettingSwVerNDLanguageIconDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SystemsettingSwVerNDLanguageIconDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::speedlockUpdatesVisibilityDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::speedlockUpdatesVisibilityDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::bluetoothVisibilityDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::bluetoothVisibilityDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PopUpButtonVisibilityDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PopUpButtonVisibilityDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SWUpdateListItemEnableDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SWUpdateListItemEnableDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MISStage1ResultsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MISStage1ResultsDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::CarModeVisibilityDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::CarModeVisibilityDataBindingSource > const& dataItemContainer);
} // namespace FeatStd
#endif // FEATSTD_STRINGBUFFER_APPENDER_ENABLED
#endif // AppHmi_SystemStateMachine_h
