/************************************************************************
*FILE: AppHmi_SxmStateMachine.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(AppHmi_SxmStateMachine_h)
#define AppHmi_SxmStateMachine_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Courier/Platform/MessageFactory.h>
#include <Courier/Messaging/Message.h>
#include <AppHmi_SxmStateMachineSEMLibB.h>
#include <AppHmi_SxmStateMachineData.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Cit/VisualStateGlueLayer/DeductResult.h>
#ifdef CIT_SIMULATION
#include <json/value.h>
#endif
#include <AppHmi_SxmTypes.h>
#include <AppHmi_SxmConstants.h>
#include <AppHmi_SxmMessages.h>
#include <AppHmi_SxmDatabinding.h>
#include <AppHmi_SxmViews.h>
#include <AppHmi_SxmController.h>
// ------------------------------------------------------------------------
class AppHmi_SxmStateMachineImpl : public AppHmi_SxmStateMachine
{
public:
    typedef AppHmi_SxmStateMachine Base;

#ifdef VISUALSTATE_7_TRACE
    // Mapping of data types of API to get rid of include dependencies
    //typedef SEM_ACTION_EXPRESSION_TYPE VS_Type_ActionExpression;
	using Base::VS_Type_ActionExpression;
    //typedef SEM_EVENT_TYPE VS_Type_Event;
	//typedef SEM_STATE_TYPE VS_Type_State;
	//typedef SEM_EXPLANATION_TYPE VS_Type_Explanation;
	//typedef SEM_STATE_MACHINE_TYPE VS_Type_Statemachine;
	using Base::VS_Type_Event;
	using Base::VS_Type_State;
	using Base::VS_Type_Explanation;
	using Base::VS_Type_Statemachine;

    // Mapping of enums and defines of API to get rid of include dependencies
    //enum { VS_Ret_Ok = SES_OKAY };
    //enum { VS_Ret_Found = SES_FOUND };
	enum { VS_Ret_Ok = Base::VS_Ret_Ok };
	enum { VS_Ret_Found = Base::VS_Ret_Found };
    enum { VS_Evt_Reset = SE_RESET };
    enum { VS_Ret_Error = SES_RANGE_ERR };
#else
#ifndef VISUALSTATE_HCODER
    typedef SEM_ACTION_EXPRESSION_TYPE VS_Type_ActionExpression;
    typedef SEM_EVENT_TYPE VS_Type_Event;
    typedef SEM_STATE_TYPE VS_Type_State;
    typedef SEM_EXPLANATION_TYPE VS_Type_Explanation;
    typedef SEM_STATE_MACHINE_TYPE VS_Type_Statemachine;
    enum { VS_Ret_Ok = SES_OKAY };
    enum { VS_Ret_Found = SES_FOUND };
    enum { VS_Evt_Reset = SE_RESET };
    enum { VS_Ret_Error = SES_RANGE_ERR };
#else
    enum { VS_Ret_Ok = 0U };
    enum { VS_Ret_Found = 1U };
    enum { VS_Evt_Reset = 0U };
    enum { VS_Ret_Error = 4U };
#endif
#endif
// ------------------------------------------------------------------------

    // Mapping of args passed as hashId to corresponding identifier
    static const ::FeatStd::Char *GetNameFromId(::FeatStd::UInt32 id);

// ------------------------------------------------------------------------
    virtual void acSxmContextSwitchScreen(::FeatStd::UInt32 aContextId);
    virtual void acSxmSelectedTab(::FeatStd::UInt32 aListId, ::FeatStd::UInt8 aTabIndex, ::FeatStd::UInt8 aTriggerType);
    virtual void acSxmTabListEntrySelection(::FeatStd::UInt32 aListId, ::FeatStd::UInt32 aHdl, ::FeatStd::UInt32 aSubHdl);
    virtual void acSxmUpdateCurrentBindingIndexMsg(::FeatStd::UInt8 aTabIndex);
    virtual void acSXMSourceChangeReqMsg();
    virtual void acSXMClearActiveContexts();
    virtual void acSxmSportsContextViewMsg(::FeatStd::UInt32 aContextId, bool aAddRemove);
    virtual void acSXMAudioMonitorUpdatesMsg(::FeatStd::UInt32 aListId, bool aEnableMonitoring);
    virtual void acSXMPopUpStateUpdMsg(bool aVisible);
    virtual void acSXMActiveServiceMsg(::FeatStd::UInt8 aServiceType, ::FeatStd::UInt8 aServiceEntryExitStatus);
    virtual void acSXMTuneToChannel(::FeatStd::UInt8 aSelectionMode, ::FeatStd::UInt16 aCidOrSidNumber, ::FeatStd::Int8 aSteps);
    virtual void acSXMTuneSelectedChannelItem(::FeatStd::UInt32 aListId, ::FeatStd::UInt32 aRowId);
    virtual void acSxmAudioCategories();
    virtual void acSxmAudioUpdatePresetList();
    virtual void acSxmAudioChangePresetBank(::FeatStd::Int8 aDirection);
    virtual void acSXMAudioChannelList(::FeatStd::UInt32 aRowId, ::FeatStd::UInt32 aListId);
    virtual void acSXMAudioRecallorStore(::FeatStd::UInt8 aPresetRowIndex, ::FeatStd::UInt8 aPresetColIndex, ::FeatStd::UInt8 aPresetAction);
    virtual void acSxmAudioContentAlertList(::FeatStd::UInt8 aHdl, ::FeatStd::UInt8 aFavType);
    virtual void acSxmAudioAlertSettingOnOff(::FeatStd::UInt32 aHdl);
    virtual void acSxmAudioPresetControl(::FeatStd::UInt8 aPressedButton);
    virtual void acSXMAudioReplayControl(::FeatStd::UInt32 aPressedButton);
    virtual void acSXMAudioCustomizeList();
    virtual void acSXMAudioCustomizeControl(::FeatStd::UInt32 aHdl);
    virtual void acSXMAudioCustomizeClearSelect(::FeatStd::UInt8 aValue);
    virtual void acSXMAudioAlertsTurnOnOff(::FeatStd::UInt32 aOnOffStatus, ::FeatStd::UInt32 aFavoriteType);
    virtual void acSXMAudioEnableDeleteFav(::FeatStd::UInt32 aFavoriteType, ::FeatStd::UInt32 aHdl, ::FeatStd::UInt32 aSubHdl);
    virtual void acSXMSettingTestmodeListUpdate(::FeatStd::UInt32 aHdl, ::FeatStd::UInt32 aTestmodeListId);
    virtual void acSXMAudioDirectTuneOk();
    virtual void acSXMAudioDirectTuneClearSpeller();
    virtual void acSXMAudioDirectTuneDeletePos();
    virtual void acSXMAudioTuneStart();
    virtual void acSXMAudioScanOpertation(::FeatStd::UInt8 aOperationType);
    virtual void acSXMAudioSportsLeagueList();
    virtual void acSXMAudioSportsTeamListForLeague(::FeatStd::UInt32 aHdl);
    virtual void acSXMAudioSportsOnPressTeamName(::FeatStd::UInt32 aHdl);
    virtual void acSXMAudioSportsCloseOfMaxFavPopup();
    virtual void acSXMAudioSportsOnPressReplaceTeamName(::FeatStd::UInt32 aHdl);
    virtual void acSXMAudioSportsRefreshTeamList();
    virtual void acSXMAudioSportsAlertList();
    virtual void acSXMAudioSportsFavList();
    virtual void acSXMAudioGoToAudioMain();
    virtual void acSXMAudioSportsflashTurnAlertOn(::FeatStd::UInt8 aSxm_SportsflashAlertStatus);
    virtual void acSXMAudioSportsflashDeleteFavtTeam(::FeatStd::UInt32 aListId, ::FeatStd::UInt32 aHdl, ::FeatStd::UInt32 aSubHdl);
    virtual void acSxmSFButtonPress(::FeatStd::UInt32 aButtonColor);
    virtual void acSxmSFDisableMonitorMsg();
    virtual void acSxmSFYesForMonitorPopupMsg();
    virtual void acSxmSFTuneChannelMsg();
    virtual void acSxmSFReturnChannelMsg();
    virtual void acSxmSFAlertClose();
    virtual void acSxmTWNListSettings();
    virtual void acSxmTWNYesForPopup();
    virtual void acSxmTWNListSelect(::FeatStd::UInt32 aListId, ::FeatStd::UInt32 aHdl);
    virtual void acSxmTWNButtonPress(::FeatStd::UInt32 aBtnColor);
    virtual void acSxmAudioSaveFav(::FeatStd::UInt32 aFavoriteType);
    virtual void acSxmAudioDeleteallFav(::FeatStd::UInt32 aFavoriteType);
    virtual void acSxmAudioDeleteAllConfirmMsg();
    virtual void acSxmAudioCloseFavMaxReachedPopup();
    virtual void acSxmAudioReplaceSelectedFav(::FeatStd::UInt32 aRowId);
    virtual void acSxmAudioTunetoContentAlert();
    virtual void acSxmAudioCloseContentAlertPopup();
    virtual void acSxmAudioChannelLockStatus();
    virtual void acSetTpopInfo(bool aIsActive);
    virtual void acSxmAudioFocusReset(::FeatStd::UInt32 aViewId);
    virtual void acSXMInfoUpdatedatabinding();
    virtual void acSxmDTMTestModeMonitorSel(bool aStartMonitor);
    virtual void acSxmWaitSyncCancelled();
    virtual void acSXMFooterListIdReqMsg(::FeatStd::UInt32 aListId);
    virtual void Notify_Init_Finished();
    virtual void gacChangeLanguageReq(::FeatStd::Int32 aLanguageId);
    virtual void gacHideFocusInViewReq(::FeatStd::UInt32 aView);
    virtual void NextLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PreviousLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void DualViewLeftTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void DualViewRightTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PageFlipBackTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PageFlipFrontTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void ZoomInTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos);
    virtual void ZoomOutTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos);
    virtual void FadeTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void gacWaitAnimationStartReq();
    virtual void acFocusOnRightEncoderReqUpd(bool aIsFocusUsed);
    virtual void acSetGadgetSceenActiveStatus(bool aIsGadgetAtive);
    virtual void acHKNotificationMsg(::FeatStd::Int8 aHKCode, ::FeatStd::Int8 aHKState);
    virtual void acPerform_CloseAllDropdowns();
    virtual void acPerform_CloseDropdown(::FeatStd::UInt32 aListId);
    virtual void acPerform_OpenDropdown(::FeatStd::UInt32 aListId);
    virtual void acPerform_ToggleDropdown(::FeatStd::UInt32 aListId);
    virtual void acStartAppPopupTimer(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aTimeout);
    virtual void acStopAppPopupTimer(::FeatStd::UInt32 aViewId);
    virtual void acPostBeep(::FeatStd::Int8 aBeepType);
    virtual void gacCheckToClosePopup(::FeatStd::UInt32 aPopupId);
    virtual void acRestartAppPopupTimer(::FeatStd::UInt32 aViewId);
    virtual void gacContextSwitchBackRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchCompleteRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchFailedRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchDoneRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchOutReq(::FeatStd::UInt32 aTargetContextId, ::FeatStd::UInt32 aSourceContextId, ::FeatStd::UInt32 aTargetAppId);
    virtual void gacCurrentScreenDisplayReq();
    virtual void gacLaunchBarDisplayReq(bool aVisibility);
    virtual void gacNavTBTSwipe();
    virtual void gacPerformListBtnRightEncoderChangeUpd(::FeatStd::Int8 aSteps, ::FeatStd::UInt32 aListId, ::FeatStd::UInt32 aRowId, ::FeatStd::UInt32 aColumnId);
    virtual void gacScrollListUp();
    virtual void gacScrollListDown();
    virtual void gacScrollPageUp();
    virtual void gacScrollPageDown();
    virtual void gacScrollListFocusUp(::FeatStd::UInt32 aListId);
    virtual void gacScrollListFocusDown(::FeatStd::UInt32 aListId);
    virtual void gacPerformListFocusLockDataResetUpd();
    virtual void gacSetApplicationMode(::FeatStd::UInt32 aModeId);
    virtual void gacSpellerBbehaviorReq(bool aEnable);
    virtual void gacStatusBarDisplayReq(bool aVisibility, ::FeatStd::Int32 aHeaderType);
    virtual void gacTBTRetriggerAcousticOutput();
    virtual void gacWaitAnimationStopReq();
    virtual void gacViewCreateReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateAllReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewDestroyReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewClearReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewHideReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateWithoutLoadReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewAsyncLoadReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewActivateWithoutRenderingReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupCreateAndSBShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupCreateAndSBShowReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacPopupSBCloseReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupSBCloseReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacPopupRestartTimerReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupRestartTimerReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateAndShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewHideAndDestroyReq(::FeatStd::UInt32 aViewId);
    virtual void gacSceneTransitionEnter(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint);
    virtual void gacSceneTransitionLeave(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint);
    virtual void gacDisplayStatusLineReq(::FeatStd::Int32 aDisplayRegionType);
    virtual void gacHideStatusLineReq(::FeatStd::Int32 aDisplayRegionType);
    virtual void gacDisplayFooterLineReq();
    virtual void gacHideFooterLineReq();
    virtual void gacDisplayStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacHideStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacDisplayFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacHideFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacRegisterForCloseOnTouchSession(::FeatStd::UInt32 aViewId);
    virtual void gacDeregisterForCloseOnTouchSessionReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupFilterPrioEnableReq(::FeatStd::UInt32 aPrio);
    virtual void gacPopupFilterAllEnableReq();
    virtual void gacPopupFilterDisableReq();
    virtual void gacProfileChange(::FeatStd::Int8 aProfile);
    virtual void gacPopupFilterPrioEnableReqForDisplay(::FeatStd::UInt32 aPrio, ::FeatStd::UInt32 aDisplayID);
    virtual void gacPopupFilterAllEnableReqForDisplay(::FeatStd::UInt32 aDisplayID);
    virtual void gacPopupFilterDisableReqForDisplay(::FeatStd::UInt32 aDisplayID);
    virtual void gacStartSceneTransitionAnimation(::FeatStd::UInt32 aSourceView, ::FeatStd::UInt32 aDestinationView, ::FeatStd::UInt32 aUserData1, ::FeatStd::Int8 aUserData2);
    virtual void gacDecrementActiveAnimationCount();

// ------------------------------------------------------------------------
    virtual ::FeatStd::UInt8 gacGetDataServiceStatus(::FeatStd::UInt8 aServiceType);

// ------------------------------------------------------------------------
    virtual bool dgSxmAudioScanStatus();
    virtual bool dgSxmPopupVisible();
    virtual bool dgSxmApplicationState();

#ifdef CIT_SIMULATION
    bool CallAction(const ::FeatStd::Char* actionName, const ::Json::Value& parameters, ::Json::Value &response);
    const ::FeatStd::Char* GetEventName(::FeatStd::UInt32 eventId, ::Courier::Message const & message, Json::Value& eventArgument);
#endif
    // Added function for deduction of one event to simplify the event loop
    bool HandleDataBindingEventMapping(::Courier::AbstractDataItemMsg const & message, ::FeatStd::UInt32& eventId) const;
    bool HandleEventMapping(::Courier::Message const & message, ::FeatStd::UInt32& eventId) const;

    ::Cit::DeductResult::Enum DeductEvent(::Courier::Message const & message, ::FeatStd::UInt32 eventId);

    //====  member function with TTFis output - added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====

	virtual unsigned short GetTraceClass();
	int GetNumberOfStatemachines();
    //====  member function with TTFis output - end                        key: SM_TTFis_SBHFMSRF ====
};

// ------------------------------------------------------------------------
bool SendSxmContextSwitchScreenReqMsg(Courier::UInt32 const & aContextId);
bool SendSxmSelectedTabReqMsg(Courier::UInt32 const & aListId, Courier::UInt8 const & aTabIndex, Courier::UInt8 const & aTriggerType);
bool SendSxmTabListEntrySelectionReqMsg(Courier::UInt32 const & aListId, Courier::UInt32 const & aHdl, Courier::UInt32 const & aSubHdl);
bool SendSxmUpdateCurrentBindingIndexMsg(Courier::UInt8 const & aTabIndex);
bool SendSXMSourceChangeReqMsg();
bool SendSXMClearActiveContextsMsg();
bool SendSxmSportsContextViewMsg(Courier::UInt32 const & aContextId, bool const & aAddRemove);
bool SendSXMAudioMonitorUpdatesMsg(Courier::UInt32 const & aListId, bool const & aEnableMonitoring);
bool SendSXMPopUpStateUpdMsg(bool const & aVisible);
bool SendSXMActiveServiceMsg(Courier::UInt8 const & aServiceType, Courier::UInt8 const & aServiceEntryExitStatus);
bool SendSXMTuneToChannelReqMsg(Courier::UInt8 const & aSelectionMode, Courier::UInt16 const & aCidOrSidNumber, Courier::Int8 const & aSteps);
bool SendSXMTuneSelectedChannelItemReqMsg(Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId);
bool SendSxmAudioCategoriesReqMsg();
bool SendSxmAudioUpdatePresetListReqMsg();
bool SendSxmAudioChangePresetBankReqMsg(Courier::Int8 const & aDirection);
bool SendSXMAudioChannelListReqMsg(Courier::UInt32 const & aRowId, Courier::UInt32 const & aListId);
bool SendSXMAudioRecallorStoreReqMsg(Courier::UInt8 const & aPresetRowIndex, Courier::UInt8 const & aPresetColIndex, Courier::UInt8 const & aPresetAction);
bool SendSxmAudioContentAlertListReqMsg(Courier::UInt8 const & aHdl, Courier::UInt8 const & aFavType);
bool SendSxmAudioAlertSettingOnOffReqMsg(Courier::UInt32 const & aHdl);
bool SendSxmAudioPresetControlReqMsg(Courier::UInt8 const & aPressedButton);
bool SendSXMAudioReplayControlReqMsg(Courier::UInt8 const & aPressedButton);
bool SendSXMAudioCustomizeListReqMsg();
bool SendSXMAudioCustomizeControlReqMsg(Courier::UInt32 const & aHdl);
bool SendSXMAudioCustomizeClearSelectReqMsg(Courier::UInt8 const & aValue);
bool SendSXMAudioAlertsTurnOnOffReqMsg(Courier::Int32 const & aOnOffStatus, Courier::Int32 const & aFavoriteType);
bool SendSXMAudioEnableDeleteFavReqMsg(Courier::Int32 const & aFavoriteType, Courier::Int32 const & aHdl, Courier::Int32 const & aSubHdl);
bool SendSXMSettingsTestModeListReqMsg(Courier::UInt32 const & aHdl, Courier::UInt32 const & aTestmodeListId);
bool SendSXMAudioDirectTuneOkReqMsg();
bool SendSXMAudioDirectTuneClearSpellerReqMsg();
bool SendSXMAudioDirectTuneDeletePosReqMsg();
bool SendSXMAudioTuneStartReqMsg();
bool SendSXMAudioScanOpertationReqMsg(Courier::UInt8 const & aOperationType);
bool SendSXMAudioSportsLeagueListReqMsg();
bool SendSXMAudioSportsTeamListForLeagueReqMsg(Courier::UInt32 const & aHdl);
bool SendSXMAudioSportsOnPressTeamNameReqMsg(Courier::UInt32 const & aHdl);
bool SendSXMAudioSportsCloseOfMaxFavPopupReqMsg();
bool SendSXMAudioSportsOnPressReplaceTeamNameReqMsg(Courier::UInt32 const & aHdl);
bool SendSXMAudioSportsRefreshTeamListReqMsg();
bool SendSXMAudioSportsAlertListReqMsg();
bool SendSXMAudioSportsFavListReqMsg();
bool SendSXMAudioGotoAudioMainMsg();
bool SendSXMAudioSportsflashTurnAlertAllOnReqMsg(Courier::UInt32 const & aSxm_SportsflashAlertStatus);
bool SendSXMAudioSportsflashDeleteFavtTeamReqMsg(Courier::UInt32 const & aListId, Courier::UInt32 const & aHdl, Courier::UInt32 const & aSubHdl);
bool SendSxmSFButtonPressReqMsg(Courier::UInt32 const & aButtonColor);
bool SendSxmSFDisableMonitorReqMsg();
bool SendSxmSFYesForMonitorPopupReqMsg();
bool SendSxmSFTuneChannelReqMsg();
bool SendSxmSFReturnChannelReqMsg();
bool SendSxmSFAlertCloseReqMsg();
bool SendSxmTWNSettingsReqMsg();
bool SendSxmTWNYesForPopupMsg();
bool SendSxmTWNListSelectReqMsg(Courier::UInt32 const & aListId, Courier::UInt32 const & aHdl);
bool SendSxmTWNButtonPressReqMsg(Courier::UInt32 const & aBtnColor);
bool SendSxmAudioSaveFavReqMsg(Courier::UInt32 const & aFavoriteType);
bool SendSxmAudioDeleteAllFavReqMsg(Courier::UInt32 const & aFavoriteType);
bool SendSxmAudioDeleteAllConfirmReqMsg();
bool SendSxmAudioCloseFavMaxReachedPopupReqMsg();
bool SendSxmAudioReplaceSelectedFavReqMsg(Courier::UInt32 const & aRowId);
bool SendSxmAudioTunetoContentAlertReqMsg();
bool SendSxmAudioCloseContentAlertPopupReqMsg();
bool SendSxmChannelLockStatusReqMsg();
bool SendSXMTPopUpAudioStateUpdMsg(bool const & aIsActive);
bool SendSxmAudioFocusResetReqMsg(Courier::UInt32 const & aViewId);
bool SendSXMInfoUpdatedatabindingReqMsg();
bool SendSxmDTMTestModeMonitorSelReqMsg(bool const & aStartMonitor);
bool SendSxmWaitSyncCancelledMsg();
bool SendSxmFooterListIdReqMsg(Courier::UInt32 const & aListId);
bool SendGuiStartupFinishedUpdMsg();
bool SendChangeLanguageReqMsg(enLanguageId const & aLanguageId);
bool SendFocusReqMsg(FocusActionEnum const & aAction, FocusTimerActionEnum const & aTimerAction, ::Courier::ViewId const & aView, Candera::String const & aWidget);
bool SendDummyMess(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
bool SendAnimationReqMsg(Courier::AnimationAction::Enum const & aAnimationAction, ::Courier::ViewId const & aViewId, Courier::CompositePath const & aCompositePath, ::Courier::ItemId const & aAnimationId, Courier::AnimationProperties const & aAnimationProperties);
bool SendFocusOnRightEncoderReqUpdMsg(bool const & aIsFocusUsed);
bool SendStoreActiveGadgetReqMsg(bool const & aIsGadgetAtive);
bool SendHardKeyPressNotificationMsg(Courier::UInt8 const & aDummy, Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState);
bool SendDropdownChangeMsg(::Candera::DropdownChangeType const & aDropdownChangeType, ::Courier::UInt32 const & aListId);
bool SendStartPopupTimerReqMsg(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout);
bool SendStopPopupTimerReqMsg(Courier::UInt32 const & aViewId);
bool SendPlayBeepReqMsg(Courier::Int32 const & aBeepType);
bool SendCheckToClosePopupMsg(Courier::UInt32 const & aPopupId);
bool SendRestartPopupTimerReqMsg(Courier::UInt32 const & aViewId);
bool SendContextSwitchInResMsg(Courier::UInt32 const & aSwitchId, Courier::UInt32 const & aResponseType);
bool SendContextSwitchOutReqMsg(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId);
bool SendCurrentScreenDisplayReqMsg();
bool SendLaunchBarDisplayReqMsg(bool const & aVisibility);
bool SendNavTBTSwipeReqMsg();
bool SendListItemRightEncoderChangeUpdMsg(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId);
bool SendListChangeMsg(::Courier::UInt32 const & aListId, ListChangeType const & aListChangeType, ::Courier::Int32 const & aValue, ListChangeMsgSourceType const & aListChangeMsgSource, bool const & aImmediatePositioning);
bool SendListFocusScrollReqMsg(Courier::UInt32 const & aListId, Courier::Int32 const & aSteps);
bool SendListFocusLockDataResetReqMsg();
bool SendSetApplicationModeReqMsg(Courier::UInt32 const & aModeId);
bool SendSpellerBbehaviorReqMsg(bool const & aEnable);
bool SendStatusBarDisplayReqMsg(bool const & aVisibility, Courier::Int32 const & aHeaderType);
bool SendTBTRetriggerAcousticMsg();
bool SendViewReqMsg(Courier::ViewAction::Enum const & aViewAction, ::Courier::ViewId const & aViewId, bool const & aShallInitScene, bool const & aShallLoadScene);
bool SendActivationReqMsg(::Courier::ViewId const & aViewId, bool const & aActivation, bool const & aEnableRendering);
bool SendAsyncLoadReqMsg(::Courier::ViewId const & aViewId, bool const & aLoad);
bool SendPopupReqMsg(hmibase::popups::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aPopupDisplayID);
bool SendExtendedViewReqMsg(hmibase::views::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
bool SendShowHMISubSurfaceReqMsg(hmibase::displayRegion const & aDisplayRegion, Courier::Int32 const & aDisplayRegionType, bool const & aShowSubSurface, Courier::UInt32 const & aDisplayID, bool const & aLockSubSurface);
bool SendRegisterForCloseOnTouchSessionReqMsg(bool const & aRegister, ::Courier::ViewId const & aViewId);
bool SendPopupFilterPrioEnableReqMsg(Courier::UInt32 const & aPrio);
bool SendPopupFilterAllEnableReqMsg();
bool SendPopupFilterDisableReqMsg();
bool SendProfileSwitchMsg(Courier::UInt32 const & aProfile);
bool SendMultiDisplayPopupFilterReqMsg(hmibase::PopupFilterType const & aPopupFilterType, Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID);
bool SendCreateNewDestroyOld(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2);
bool SendNotifierMessage();

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmContextSwitchScreen(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSxmContextSwitchScreen(Courier::UInt32 const & aContextId);
#ifdef CIT_SIMULATION
bool CallAction_acSxmSelectedTab(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSxmSelectedTab(Courier::UInt32 const & aListId, Courier::UInt8 const & aTabIndex, Courier::UInt8 const & aTriggerType);
#ifdef CIT_SIMULATION
bool CallAction_acSxmTabListEntrySelection(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSxmTabListEntrySelection(Courier::UInt32 const & aListId, Courier::UInt32 const & aHdl, Courier::UInt32 const & aSubHdl);
#ifdef CIT_SIMULATION
bool CallAction_acSxmUpdateCurrentBindingIndexMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSxmUpdateCurrentBindingIndexMsg(Courier::UInt8 const & aTabIndex);
#ifdef CIT_SIMULATION
bool CallAction_acSXMSourceChangeReqMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMSourceChangeReqMsg();
#ifdef CIT_SIMULATION
bool CallAction_acSXMClearActiveContexts(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMClearActiveContexts();
#ifdef CIT_SIMULATION
bool CallAction_acSxmSportsContextViewMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSxmSportsContextViewMsg(Courier::UInt32 const & aContextId, bool const & aAddRemove);
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioMonitorUpdatesMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMAudioMonitorUpdatesMsg(Courier::UInt32 const & aListId, bool const & aEnableMonitoring);
#ifdef CIT_SIMULATION
bool CallAction_acSXMPopUpStateUpdMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMPopUpStateUpdMsg(bool const & aVisible);
#ifdef CIT_SIMULATION
bool CallAction_acSXMActiveServiceMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMActiveServiceMsg(Courier::UInt8 const & aServiceType, Courier::UInt8 const & aServiceEntryExitStatus);
#ifdef CIT_SIMULATION
bool CallAction_acSXMTuneToChannel(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMTuneToChannel(Courier::UInt8 const & aSelectionMode, Courier::UInt16 const & aCidOrSidNumber, Courier::Int8 const & aSteps);
#ifdef CIT_SIMULATION
bool CallAction_acSXMTuneSelectedChannelItem(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMTuneSelectedChannelItem(Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId);
#ifdef CIT_SIMULATION
bool CallAction_acSxmAudioCategories(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSxmAudioCategories();
#ifdef CIT_SIMULATION
bool CallAction_acSxmAudioUpdatePresetList(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSxmAudioUpdatePresetList();
#ifdef CIT_SIMULATION
bool CallAction_acSxmAudioChangePresetBank(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSxmAudioChangePresetBank(Courier::Int8 const & aDirection);
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioChannelList(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMAudioChannelList(Courier::UInt32 const & aRowId, Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioRecallorStore(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMAudioRecallorStore(Courier::UInt8 const & aPresetRowIndex, Courier::UInt8 const & aPresetColIndex, Courier::UInt8 const & aPresetAction);
#ifdef CIT_SIMULATION
bool CallAction_acSxmAudioContentAlertList(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSxmAudioContentAlertList(Courier::UInt8 const & aHdl, Courier::UInt8 const & aFavType);
#ifdef CIT_SIMULATION
bool CallAction_acSxmAudioAlertSettingOnOff(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSxmAudioAlertSettingOnOff(Courier::UInt32 const & aHdl);
#ifdef CIT_SIMULATION
bool CallAction_acSxmAudioPresetControl(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSxmAudioPresetControl(Courier::UInt8 const & aPressedButton);
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioReplayControl(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMAudioReplayControl(Courier::UInt8 const & aPressedButton);
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioCustomizeList(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMAudioCustomizeList();
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioCustomizeControl(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMAudioCustomizeControl(Courier::UInt32 const & aHdl);
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioCustomizeClearSelect(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMAudioCustomizeClearSelect(Courier::UInt8 const & aValue);
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioAlertsTurnOnOff(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMAudioAlertsTurnOnOff(Courier::Int32 const & aOnOffStatus, Courier::Int32 const & aFavoriteType);
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioEnableDeleteFav(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMAudioEnableDeleteFav(Courier::Int32 const & aFavoriteType, Courier::Int32 const & aHdl, Courier::Int32 const & aSubHdl);
#ifdef CIT_SIMULATION
bool CallAction_acSXMSettingTestmodeListUpdate(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMSettingTestmodeListUpdate(Courier::UInt32 const & aHdl, Courier::UInt32 const & aTestmodeListId);
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioDirectTuneOk(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMAudioDirectTuneOk();
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioDirectTuneClearSpeller(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMAudioDirectTuneClearSpeller();
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioDirectTuneDeletePos(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMAudioDirectTuneDeletePos();
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioTuneStart(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMAudioTuneStart();
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioScanOpertation(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMAudioScanOpertation(Courier::UInt8 const & aOperationType);
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioSportsLeagueList(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMAudioSportsLeagueList();
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioSportsTeamListForLeague(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMAudioSportsTeamListForLeague(Courier::UInt32 const & aHdl);
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioSportsOnPressTeamName(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMAudioSportsOnPressTeamName(Courier::UInt32 const & aHdl);
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioSportsCloseOfMaxFavPopup(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMAudioSportsCloseOfMaxFavPopup();
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioSportsOnPressReplaceTeamName(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMAudioSportsOnPressReplaceTeamName(Courier::UInt32 const & aHdl);
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioSportsRefreshTeamList(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMAudioSportsRefreshTeamList();
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioSportsAlertList(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMAudioSportsAlertList();
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioSportsFavList(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMAudioSportsFavList();
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioGoToAudioMain(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMAudioGoToAudioMain();
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioSportsflashTurnAlertOn(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMAudioSportsflashTurnAlertOn(Courier::UInt32 const & aSxm_SportsflashAlertStatus);
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioSportsflashDeleteFavtTeam(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMAudioSportsflashDeleteFavtTeam(Courier::UInt32 const & aListId, Courier::UInt32 const & aHdl, Courier::UInt32 const & aSubHdl);
#ifdef CIT_SIMULATION
bool CallAction_acSxmSFButtonPress(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSxmSFButtonPress(Courier::UInt32 const & aButtonColor);
#ifdef CIT_SIMULATION
bool CallAction_acSxmSFDisableMonitorMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSxmSFDisableMonitorMsg();
#ifdef CIT_SIMULATION
bool CallAction_acSxmSFYesForMonitorPopupMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSxmSFYesForMonitorPopupMsg();
#ifdef CIT_SIMULATION
bool CallAction_acSxmSFTuneChannelMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSxmSFTuneChannelMsg();
#ifdef CIT_SIMULATION
bool CallAction_acSxmSFReturnChannelMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSxmSFReturnChannelMsg();
#ifdef CIT_SIMULATION
bool CallAction_acSxmSFAlertClose(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSxmSFAlertClose();
#ifdef CIT_SIMULATION
bool CallAction_acSxmTWNListSettings(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSxmTWNListSettings();
#ifdef CIT_SIMULATION
bool CallAction_acSxmTWNYesForPopup(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSxmTWNYesForPopup();
#ifdef CIT_SIMULATION
bool CallAction_acSxmTWNListSelect(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSxmTWNListSelect(Courier::UInt32 const & aListId, Courier::UInt32 const & aHdl);
#ifdef CIT_SIMULATION
bool CallAction_acSxmTWNButtonPress(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSxmTWNButtonPress(Courier::UInt32 const & aBtnColor);
#ifdef CIT_SIMULATION
bool CallAction_acSxmAudioSaveFav(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSxmAudioSaveFav(Courier::UInt32 const & aFavoriteType);
#ifdef CIT_SIMULATION
bool CallAction_acSxmAudioDeleteallFav(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSxmAudioDeleteallFav(Courier::UInt32 const & aFavoriteType);
#ifdef CIT_SIMULATION
bool CallAction_acSxmAudioDeleteAllConfirmMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSxmAudioDeleteAllConfirmMsg();
#ifdef CIT_SIMULATION
bool CallAction_acSxmAudioCloseFavMaxReachedPopup(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSxmAudioCloseFavMaxReachedPopup();
#ifdef CIT_SIMULATION
bool CallAction_acSxmAudioReplaceSelectedFav(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSxmAudioReplaceSelectedFav(Courier::UInt32 const & aRowId);
#ifdef CIT_SIMULATION
bool CallAction_acSxmAudioTunetoContentAlert(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSxmAudioTunetoContentAlert();
#ifdef CIT_SIMULATION
bool CallAction_acSxmAudioCloseContentAlertPopup(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSxmAudioCloseContentAlertPopup();
#ifdef CIT_SIMULATION
bool CallAction_acSxmAudioChannelLockStatus(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSxmAudioChannelLockStatus();
#ifdef CIT_SIMULATION
bool CallAction_acSetTpopInfo(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetTpopInfo(bool const & aIsActive);
#ifdef CIT_SIMULATION
bool CallAction_acSxmAudioFocusReset(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSxmAudioFocusReset(Courier::UInt32 const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_acSXMInfoUpdatedatabinding(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMInfoUpdatedatabinding();
#ifdef CIT_SIMULATION
bool CallAction_acSxmDTMTestModeMonitorSel(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSxmDTMTestModeMonitorSel(bool const & aStartMonitor);
#ifdef CIT_SIMULATION
bool CallAction_acSxmWaitSyncCancelled(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSxmWaitSyncCancelled();
#ifdef CIT_SIMULATION
bool CallAction_acSXMFooterListIdReqMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSXMFooterListIdReqMsg(Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_Notify_Init_Finished(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Notify_Init_Finished();
#ifdef CIT_SIMULATION
bool CallAction_gacChangeLanguageReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacChangeLanguageReq(enLanguageId const & aLanguageId);
#ifdef CIT_SIMULATION
bool CallAction_gacHideFocusInViewReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFocusInViewReq(::Courier::ViewId const & aView);
#ifdef CIT_SIMULATION
bool CallAction_NextLevelTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_NextLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PreviousLevelTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PreviousLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_DualViewLeftTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DualViewLeftTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_DualViewRightTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DualViewRightTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PageFlipBackTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PageFlipBackTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PageFlipFrontTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PageFlipFrontTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_ZoomInTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ZoomInTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
#ifdef CIT_SIMULATION
bool CallAction_ZoomOutTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ZoomOutTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
#ifdef CIT_SIMULATION
bool CallAction_FadeTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_FadeTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStartReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacWaitAnimationStartReq();
#ifdef CIT_SIMULATION
bool CallAction_acFocusOnRightEncoderReqUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acFocusOnRightEncoderReqUpd(bool const & aIsFocusUsed);
#ifdef CIT_SIMULATION
bool CallAction_acSetGadgetSceenActiveStatus(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetGadgetSceenActiveStatus(bool const & aIsGadgetAtive);
#ifdef CIT_SIMULATION
bool CallAction_acHKNotificationMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acHKNotificationMsg(Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseAllDropdowns(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_CloseAllDropdowns();
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_CloseDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_OpenDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_OpenDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_ToggleDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_ToggleDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acStartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStartAppPopupTimer(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout);
#ifdef CIT_SIMULATION
bool CallAction_acStopAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStopAppPopupTimer(Courier::UInt32 const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_acPostBeep(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPostBeep(Courier::Int32 const & aBeepType);
#ifdef CIT_SIMULATION
bool CallAction_gacCheckToClosePopup(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacCheckToClosePopup(Courier::UInt32 const & aPopupId);
#ifdef CIT_SIMULATION
bool CallAction_acRestartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acRestartAppPopupTimer(Courier::UInt32 const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchBackRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchBackRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchCompleteRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchCompleteRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchFailedRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchFailedRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchDoneRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchDoneRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchOutReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchOutReq(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId);
#ifdef CIT_SIMULATION
bool CallAction_gacCurrentScreenDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacCurrentScreenDisplayReq();
#ifdef CIT_SIMULATION
bool CallAction_gacLaunchBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacLaunchBarDisplayReq(bool const & aVisibility);
#ifdef CIT_SIMULATION
bool CallAction_gacNavTBTSwipe(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacNavTBTSwipe();
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListBtnRightEncoderChangeUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPerformListBtnRightEncoderChangeUpd(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId);
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListUp();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListDown();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollPageUp();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollPageDown();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListFocusUp(Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListFocusDown(Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListFocusLockDataResetUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPerformListFocusLockDataResetUpd();
#ifdef CIT_SIMULATION
bool CallAction_gacSetApplicationMode(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSetApplicationMode(Courier::UInt32 const & aModeId);
#ifdef CIT_SIMULATION
bool CallAction_gacSpellerBbehaviorReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSpellerBbehaviorReq(bool const & aEnable);
#ifdef CIT_SIMULATION
bool CallAction_gacStatusBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacStatusBarDisplayReq(bool const & aVisibility, Courier::Int32 const & aHeaderType);
#ifdef CIT_SIMULATION
bool CallAction_gacTBTRetriggerAcousticOutput(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacTBTRetriggerAcousticOutput();
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStopReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacWaitAnimationStopReq();
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAllReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateAllReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewDestroyReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewDestroyReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewClearReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewClearReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewHideReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateWithoutLoadReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateWithoutLoadReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewAsyncLoadReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewAsyncLoadReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewActivateWithoutRenderingReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupCreateAndSBShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupCreateAndSBShowReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupSBCloseReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupSBCloseReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupRestartTimerReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupRestartTimerReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAndShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateAndShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideAndDestroyReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewHideAndDestroyReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionEnter(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSceneTransitionEnter(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionLeave(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSceneTransitionLeave(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayStatusLineReq(Courier::Int32 const & aDisplayRegionType);
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideStatusLineReq(Courier::Int32 const & aDisplayRegionType);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayFooterLineReq();
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFooterLineReq();
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacRegisterForCloseOnTouchSession(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacDeregisterForCloseOnTouchSessionReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterPrioEnableReq(Courier::UInt32 const & aPrio);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterAllEnableReq();
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterDisableReq();
#ifdef CIT_SIMULATION
bool CallAction_gacProfileChange(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacProfileChange(Courier::UInt32 const & aProfile);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterPrioEnableReqForDisplay(Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterAllEnableReqForDisplay(Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterDisableReqForDisplay(Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacStartSceneTransitionAnimation(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacStartSceneTransitionAnimation(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2);
#ifdef CIT_SIMULATION
bool CallAction_gacDecrementActiveAnimationCount(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDecrementActiveAnimationCount();

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacGetDataServiceStatus(const ::Json::Value& parameters, ::Json::Value &response);
#endif
::FeatStd::UInt8 gacGetDataServiceStatus(::FeatStd::UInt8 aServiceType);

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_dgSxmAudioScanStatus(const ::Json::Value& parameters, ::Json::Value &response);
#endif
bool Action_dgSxmAudioScanStatus();
#ifdef CIT_SIMULATION
bool CallAction_dgSxmPopupVisible(const ::Json::Value& parameters, ::Json::Value &response);
#endif
bool Action_dgSxmPopupVisible();
#ifdef CIT_SIMULATION
bool CallAction_dgSxmApplicationState(const ::Json::Value& parameters, ::Json::Value &response);
#endif
bool Action_dgSxmApplicationState();

// overall number of HierarchyNodes
static const ::FeatStd::UInt32 cGlobalDataItemHierarchyNodeCount = 239;
// overall number of DataItemDescriptor nodes
static const ::FeatStd::UInt32 cDataItemDescriptorCount = 239;
// overall number of BindingSources
static const ::FeatStd::UInt32 cBindingSourceCount = 66;
// maximum number of HierarchyNodes in a BindingSource
static const ::FeatStd::UInt32 cBindingSourceItemCountMax = 17;

// =========================================================================

class HeaderTextDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 1;
    static const ::Courier::DataItemKey cDataItemKey = 79;

    typedef ::HeaderTextData Data;

    HeaderTextDataBindingSource();
};

typedef ::Courier::DataItemMsg< HeaderTextDataBindingSource > HeaderTextDataItemMsg;

// =========================================================================

class AudioMuteInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 2;
    static const ::Courier::DataItemKey cDataItemKey = 115;

    typedef ::AudioMuteInfoData Data;

    AudioMuteInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< AudioMuteInfoDataBindingSource > AudioMuteInfoDataItemMsg;

// =========================================================================

class SxmTabControlListDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 17;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 3;
    static const ::Courier::DataItemKey cDataItemKey = 132;

    typedef ::SxmTabControlListData Data;

    SxmTabControlListDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmTabControlListDataBindingSource > SxmTabControlListDataItemMsg;

// =========================================================================

class SxmSpeedLockUpdateForListItemScrollDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 4;
    static const ::Courier::DataItemKey cDataItemKey = 19;

    typedef ::SxmSpeedLockUpdateForListItemScrollData Data;

    SxmSpeedLockUpdateForListItemScrollDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmSpeedLockUpdateForListItemScrollDataBindingSource > SxmSpeedLockUpdateForListItemScrollDataItemMsg;

// =========================================================================

class SxmAudioFavArtistSongTeamListDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 5;
    static const ::Courier::DataItemKey cDataItemKey = 101;

    typedef ::SxmAudioFavArtistSongTeamListData Data;

    SxmAudioFavArtistSongTeamListDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmAudioFavArtistSongTeamListDataBindingSource > SxmAudioFavArtistSongTeamListDataItemMsg;

// =========================================================================

class SxmUpdateFooterDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 6;
    static const ::Courier::DataItemKey cDataItemKey = 210;

    typedef ::SxmUpdateFooterData Data;

    SxmUpdateFooterDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmUpdateFooterDataBindingSource > SxmUpdateFooterDataItemMsg;

// =========================================================================

class SxmPopupInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 7;
    static const ::Courier::DataItemKey cDataItemKey = 133;

    typedef ::SxmPopupInfoData Data;

    SxmPopupInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmPopupInfoDataBindingSource > SxmPopupInfoDataItemMsg;

// =========================================================================

class SxmPresetListDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 8;
    static const ::Courier::DataItemKey cDataItemKey = 56;

    typedef ::SxmPresetListData Data;

    SxmPresetListDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmPresetListDataBindingSource > SxmPresetListDataItemMsg;

// =========================================================================

class SxmAudioLoadingInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 5;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 9;
    static const ::Courier::DataItemKey cDataItemKey = 129;

    typedef ::SxmAudioLoadingInfoData Data;

    SxmAudioLoadingInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmAudioLoadingInfoDataBindingSource > SxmAudioLoadingInfoDataItemMsg;

// =========================================================================

class SxmAudioModeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 5;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 10;
    static const ::Courier::DataItemKey cDataItemKey = 113;

    typedef ::SxmAudioModeData Data;

    SxmAudioModeDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmAudioModeDataBindingSource > SxmAudioModeDataItemMsg;

// =========================================================================

class SxmAudioMaintextAnimationDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 11;
    static const ::Courier::DataItemKey cDataItemKey = 84;

    typedef ::SxmAudioMaintextAnimationData Data;

    SxmAudioMaintextAnimationDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmAudioMaintextAnimationDataBindingSource > SxmAudioMaintextAnimationDataItemMsg;

// =========================================================================

class SxmAudioTuneScanDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 12;
    static const ::Courier::DataItemKey cDataItemKey = 109;

    typedef ::SxmAudioTuneScanData Data;

    SxmAudioTuneScanDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmAudioTuneScanDataBindingSource > SxmAudioTuneScanDataItemMsg;

// =========================================================================

class SxmMenuListDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 6;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 13;
    static const ::Courier::DataItemKey cDataItemKey = 150;

    typedef ::SxmMenuListData Data;

    SxmMenuListDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmMenuListDataBindingSource > SxmMenuListDataItemMsg;

// =========================================================================

class SxmMenuItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 14;
    static const ::Courier::DataItemKey cDataItemKey = 226;

    typedef ::SxmMenuItemData Data;

    SxmMenuItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmMenuItemDataBindingSource > SxmMenuItemDataItemMsg;

// =========================================================================

class SxmChannelInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 17;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 15;
    static const ::Courier::DataItemKey cDataItemKey = 12;

    typedef ::SxmChannelInfoData Data;

    SxmChannelInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmChannelInfoDataBindingSource > SxmChannelInfoDataItemMsg;

// =========================================================================

class SxmTpopChannelInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 16;
    static const ::Courier::DataItemKey cDataItemKey = 51;

    typedef ::SxmTpopChannelInfoData Data;

    SxmTpopChannelInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmTpopChannelInfoDataBindingSource > SxmTpopChannelInfoDataItemMsg;

// =========================================================================

class SxmGadgetChannelInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 17;
    static const ::Courier::DataItemKey cDataItemKey = 122;

    typedef ::SxmGadgetChannelInfoData Data;

    SxmGadgetChannelInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmGadgetChannelInfoDataBindingSource > SxmGadgetChannelInfoDataItemMsg;

// =========================================================================

class SxmAudioInfoForPopupDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 9;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 18;
    static const ::Courier::DataItemKey cDataItemKey = 99;

    typedef ::SxmAudioInfoForPopupData Data;

    SxmAudioInfoForPopupDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmAudioInfoForPopupDataBindingSource > SxmAudioInfoForPopupDataItemMsg;

// =========================================================================

class SxmActivePresetBankDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 19;
    static const ::Courier::DataItemKey cDataItemKey = 83;

    typedef ::SxmActivePresetBankData Data;

    SxmActivePresetBankDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmActivePresetBankDataBindingSource > SxmActivePresetBankDataItemMsg;

// =========================================================================

class SxmCategoriesListDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 20;
    static const ::Courier::DataItemKey cDataItemKey = 137;

    typedef ::SxmCategoriesListData Data;

    SxmCategoriesListDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmCategoriesListDataBindingSource > SxmCategoriesListDataItemMsg;

// =========================================================================

class SxmChannelLogoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 21;
    static const ::Courier::DataItemKey cDataItemKey = 204;

    typedef ::SxmChannelLogoData Data;

    SxmChannelLogoDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmChannelLogoDataBindingSource > SxmChannelLogoDataItemMsg;

// =========================================================================

class SxmAudioPresetControlDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 6;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 22;
    static const ::Courier::DataItemKey cDataItemKey = 62;

    typedef ::SxmAudioPresetControlData Data;

    SxmAudioPresetControlDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmAudioPresetControlDataBindingSource > SxmAudioPresetControlDataItemMsg;

// =========================================================================

class SxmAudioPlayPauseDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 23;
    static const ::Courier::DataItemKey cDataItemKey = 135;

    typedef ::SxmAudioPlayPauseData Data;

    SxmAudioPlayPauseDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmAudioPlayPauseDataBindingSource > SxmAudioPlayPauseDataItemMsg;

// =========================================================================

class SxmAudioAlertSettingDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 24;
    static const ::Courier::DataItemKey cDataItemKey = 130;

    typedef ::SxmAudioAlertSettingData Data;

    SxmAudioAlertSettingDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmAudioAlertSettingDataBindingSource > SxmAudioAlertSettingDataItemMsg;

// =========================================================================

class SxmAudioFavAlertButtonEnableDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 25;
    static const ::Courier::DataItemKey cDataItemKey = 21;

    typedef ::SxmAudioFavAlertButtonEnableData Data;

    SxmAudioFavAlertButtonEnableDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmAudioFavAlertButtonEnableDataBindingSource > SxmAudioFavAlertButtonEnableDataItemMsg;

// =========================================================================

class SxmAudioAlertFavtUpdatePopupDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 6;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 26;
    static const ::Courier::DataItemKey cDataItemKey = 93;

    typedef ::SxmAudioAlertFavtUpdatePopupData Data;

    SxmAudioAlertFavtUpdatePopupDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmAudioAlertFavtUpdatePopupDataBindingSource > SxmAudioAlertFavtUpdatePopupDataItemMsg;

// =========================================================================

class SxmPresetItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 27;
    static const ::Courier::DataItemKey cDataItemKey = 11;

    typedef ::SxmPresetItemData Data;

    SxmPresetItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmPresetItemDataBindingSource > SxmPresetItemDataItemMsg;

// =========================================================================

class SxmAudioChannelListDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 28;
    static const ::Courier::DataItemKey cDataItemKey = 183;

    typedef ::SxmAudioChannelListData Data;

    SxmAudioChannelListDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmAudioChannelListDataBindingSource > SxmAudioChannelListDataItemMsg;

// =========================================================================

class SxmAudioSubScreenHeaderTextDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 29;
    static const ::Courier::DataItemKey cDataItemKey = 94;

    typedef ::SxmAudioSubScreenHeaderTextData Data;

    SxmAudioSubScreenHeaderTextDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmAudioSubScreenHeaderTextDataBindingSource > SxmAudioSubScreenHeaderTextDataItemMsg;

// =========================================================================

class SxmAudioFavoriteArtistDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 30;
    static const ::Courier::DataItemKey cDataItemKey = 215;

    typedef ::SxmAudioFavoriteArtistData Data;

    SxmAudioFavoriteArtistDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmAudioFavoriteArtistDataBindingSource > SxmAudioFavoriteArtistDataItemMsg;

// =========================================================================

class SxmAudioFavoriteSongDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 31;
    static const ::Courier::DataItemKey cDataItemKey = 117;

    typedef ::SxmAudioFavoriteSongData Data;

    SxmAudioFavoriteSongDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmAudioFavoriteSongDataBindingSource > SxmAudioFavoriteSongDataItemMsg;

// =========================================================================

class SxmLeagueOrReplaceListDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 32;
    static const ::Courier::DataItemKey cDataItemKey = 58;

    typedef ::SxmLeagueOrReplaceListData Data;

    SxmLeagueOrReplaceListDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmLeagueOrReplaceListDataBindingSource > SxmLeagueOrReplaceListDataItemMsg;

// =========================================================================

class SxmInfoButtonEnableDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 33;
    static const ::Courier::DataItemKey cDataItemKey = 81;

    typedef ::SxmInfoButtonEnableData Data;

    SxmInfoButtonEnableDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmInfoButtonEnableDataBindingSource > SxmInfoButtonEnableDataItemMsg;

// =========================================================================

class SxmAudioReplayContentDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 11;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 34;
    static const ::Courier::DataItemKey cDataItemKey = 61;

    typedef ::SxmAudioReplayContentData Data;

    SxmAudioReplayContentDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmAudioReplayContentDataBindingSource > SxmAudioReplayContentDataItemMsg;

// =========================================================================

class SXMAudioCustomizeChannelDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 35;
    static const ::Courier::DataItemKey cDataItemKey = 63;

    typedef ::SXMAudioCustomizeChannelData Data;

    SXMAudioCustomizeChannelDataBindingSource();
};

typedef ::Courier::DataItemMsg< SXMAudioCustomizeChannelDataBindingSource > SXMAudioCustomizeChannelDataItemMsg;

// =========================================================================

class SXMAudioCustomizeChannelListItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 36;
    static const ::Courier::DataItemKey cDataItemKey = 14;

    typedef ::SXMAudioCustomizeChannelListItemData Data;

    SXMAudioCustomizeChannelListItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< SXMAudioCustomizeChannelListItemDataBindingSource > SXMAudioCustomizeChannelListItemDataItemMsg;

// =========================================================================

class SxmAudioDirectTuneTextInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 37;
    static const ::Courier::DataItemKey cDataItemKey = 18;

    typedef ::SxmAudioDirectTuneTextInfoData Data;

    SxmAudioDirectTuneTextInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmAudioDirectTuneTextInfoDataBindingSource > SxmAudioDirectTuneTextInfoDataItemMsg;

// =========================================================================

class SxmAudioDirectTuneKeyPressInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 38;
    static const ::Courier::DataItemKey cDataItemKey = 73;

    typedef ::SxmAudioDirectTuneKeyPressInfoData Data;

    SxmAudioDirectTuneKeyPressInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmAudioDirectTuneKeyPressInfoDataBindingSource > SxmAudioDirectTuneKeyPressInfoDataItemMsg;

// =========================================================================

class SpellerDeleteBtnStateDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 39;
    static const ::Courier::DataItemKey cDataItemKey = 152;

    typedef ::SpellerDeleteBtnStateData Data;

    SpellerDeleteBtnStateDataBindingSource();
};

typedef ::Courier::DataItemMsg< SpellerDeleteBtnStateDataBindingSource > SpellerDeleteBtnStateDataItemMsg;

// =========================================================================

class SxmAudioChannelNotAvailablePopupDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 40;
    static const ::Courier::DataItemKey cDataItemKey = 178;

    typedef ::SxmAudioChannelNotAvailablePopupData Data;

    SxmAudioChannelNotAvailablePopupDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmAudioChannelNotAvailablePopupDataBindingSource > SxmAudioChannelNotAvailablePopupDataItemMsg;

// =========================================================================

class SxmAudioChannelNotSubscribedPopupDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 41;
    static const ::Courier::DataItemKey cDataItemKey = 43;

    typedef ::SxmAudioChannelNotSubscribedPopupData Data;

    SxmAudioChannelNotSubscribedPopupDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmAudioChannelNotSubscribedPopupDataBindingSource > SxmAudioChannelNotSubscribedPopupDataItemMsg;

// =========================================================================

class SxmAudioTuneStartDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 42;
    static const ::Courier::DataItemKey cDataItemKey = 143;

    typedef ::SxmAudioTuneStartData Data;

    SxmAudioTuneStartDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmAudioTuneStartDataBindingSource > SxmAudioTuneStartDataItemMsg;

// =========================================================================

class SxmAudioScanDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 43;
    static const ::Courier::DataItemKey cDataItemKey = 189;

    typedef ::SxmAudioScanData Data;

    SxmAudioScanDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmAudioScanDataBindingSource > SxmAudioScanDataItemMsg;

// =========================================================================

class SxmAudioSportsFlashTeamNamePopupDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 44;
    static const ::Courier::DataItemKey cDataItemKey = 193;

    typedef ::SxmAudioSportsFlashTeamNamePopupData Data;

    SxmAudioSportsFlashTeamNamePopupDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmAudioSportsFlashTeamNamePopupDataBindingSource > SxmAudioSportsFlashTeamNamePopupDataItemMsg;

// =========================================================================

class SxmAudioSportsFlashAlertAdvisoryDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 45;
    static const ::Courier::DataItemKey cDataItemKey = 5;

    typedef ::SxmAudioSportsFlashAlertAdvisoryData Data;

    SxmAudioSportsFlashAlertAdvisoryDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmAudioSportsFlashAlertAdvisoryDataBindingSource > SxmAudioSportsFlashAlertAdvisoryDataItemMsg;

// =========================================================================

class SXMAudioSportsflashAlertDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 46;
    static const ::Courier::DataItemKey cDataItemKey = 48;

    typedef ::SXMAudioSportsflashAlertData Data;

    SXMAudioSportsflashAlertDataBindingSource();
};

typedef ::Courier::DataItemMsg< SXMAudioSportsflashAlertDataBindingSource > SXMAudioSportsflashAlertDataItemMsg;

// =========================================================================

class SXMAudioSportsflashListItemAlertDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 47;
    static const ::Courier::DataItemKey cDataItemKey = 166;

    typedef ::SXMAudioSportsflashListItemAlertData Data;

    SXMAudioSportsflashListItemAlertDataBindingSource();
};

typedef ::Courier::DataItemMsg< SXMAudioSportsflashListItemAlertDataBindingSource > SXMAudioSportsflashListItemAlertDataItemMsg;

// =========================================================================

class SXMAudioSportsflashFavAdvisoryDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 48;
    static const ::Courier::DataItemKey cDataItemKey = 37;

    typedef ::SXMAudioSportsflashFavAdvisoryData Data;

    SXMAudioSportsflashFavAdvisoryDataBindingSource();
};

typedef ::Courier::DataItemMsg< SXMAudioSportsflashFavAdvisoryDataBindingSource > SXMAudioSportsflashFavAdvisoryDataItemMsg;

// =========================================================================

class SxmAudioSportsflashEnableDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 49;
    static const ::Courier::DataItemKey cDataItemKey = 156;

    typedef ::SxmAudioSportsflashEnableData Data;

    SxmAudioSportsflashEnableDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmAudioSportsflashEnableDataBindingSource > SxmAudioSportsflashEnableDataItemMsg;

// =========================================================================

class SxmAudioMenuChannelLockDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 50;
    static const ::Courier::DataItemKey cDataItemKey = 20;

    typedef ::SxmAudioMenuChannelLockData Data;

    SxmAudioMenuChannelLockDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmAudioMenuChannelLockDataBindingSource > SxmAudioMenuChannelLockDataItemMsg;

// =========================================================================

class SxmAudioCustomizeButtonDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 51;
    static const ::Courier::DataItemKey cDataItemKey = 82;

    typedef ::SxmAudioCustomizeButtonData Data;

    SxmAudioCustomizeButtonDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmAudioCustomizeButtonDataBindingSource > SxmAudioCustomizeButtonDataItemMsg;

// =========================================================================

class SXMAudioTWNDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 52;
    static const ::Courier::DataItemKey cDataItemKey = 131;

    typedef ::SXMAudioTWNData Data;

    SXMAudioTWNDataBindingSource();
};

typedef ::Courier::DataItemMsg< SXMAudioTWNDataBindingSource > SXMAudioTWNDataItemMsg;

// =========================================================================

class SXMAudioTWNNoInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 53;
    static const ::Courier::DataItemKey cDataItemKey = 209;

    typedef ::SXMAudioTWNNoInfoData Data;

    SXMAudioTWNNoInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< SXMAudioTWNNoInfoDataBindingSource > SXMAudioTWNNoInfoDataItemMsg;

// =========================================================================

class SXTWNButtonDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 54;
    static const ::Courier::DataItemKey cDataItemKey = 120;

    typedef ::SXTWNButtonData Data;

    SXTWNButtonDataBindingSource();
};

typedef ::Courier::DataItemMsg< SXTWNButtonDataBindingSource > SXTWNButtonDataItemMsg;

// =========================================================================

class SXMSFButtonDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 55;
    static const ::Courier::DataItemKey cDataItemKey = 145;

    typedef ::SXMSFButtonData Data;

    SXMSFButtonDataBindingSource();
};

typedef ::Courier::DataItemMsg< SXMSFButtonDataBindingSource > SXMSFButtonDataItemMsg;

// =========================================================================

class SxmSFTunePopupDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 56;
    static const ::Courier::DataItemKey cDataItemKey = 1;

    typedef ::SxmSFTunePopupData Data;

    SxmSFTunePopupDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmSFTunePopupDataBindingSource > SxmSFTunePopupDataItemMsg;

// =========================================================================

class SxmAudioSliderConfDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 57;
    static const ::Courier::DataItemKey cDataItemKey = 134;

    typedef ::SxmAudioSliderConfData Data;

    SxmAudioSliderConfDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmAudioSliderConfDataBindingSource > SxmAudioSliderConfDataItemMsg;

// =========================================================================

class SxmSettingTestmodeUpdatePopupDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 58;
    static const ::Courier::DataItemKey cDataItemKey = 138;

    typedef ::SxmSettingTestmodeUpdatePopupData Data;

    SxmSettingTestmodeUpdatePopupDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmSettingTestmodeUpdatePopupDataBindingSource > SxmSettingTestmodeUpdatePopupDataItemMsg;

// =========================================================================

class SxmSettingTestmodeExternalDiagDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 59;
    static const ::Courier::DataItemKey cDataItemKey = 118;

    typedef ::SxmSettingTestmodeExternalDiagData Data;

    SxmSettingTestmodeExternalDiagDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmSettingTestmodeExternalDiagDataBindingSource > SxmSettingTestmodeExternalDiagDataItemMsg;

// =========================================================================

class SxmAudioContentAlertDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 60;
    static const ::Courier::DataItemKey cDataItemKey = 168;

    typedef ::SxmAudioContentAlertData Data;

    SxmAudioContentAlertDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmAudioContentAlertDataBindingSource > SxmAudioContentAlertDataItemMsg;

// =========================================================================

class SxmFavtUpdatePopupDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 61;
    static const ::Courier::DataItemKey cDataItemKey = 92;

    typedef ::SxmFavtUpdatePopupData Data;

    SxmFavtUpdatePopupDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmFavtUpdatePopupDataBindingSource > SxmFavtUpdatePopupDataItemMsg;

// =========================================================================

class SxmFavtDeletePopupDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 62;
    static const ::Courier::DataItemKey cDataItemKey = 3;

    typedef ::SxmFavtDeletePopupData Data;

    SxmFavtDeletePopupDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmFavtDeletePopupDataBindingSource > SxmFavtDeletePopupDataItemMsg;

// =========================================================================

class SxmApplicationStateDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 63;
    static const ::Courier::DataItemKey cDataItemKey = 53;

    typedef ::SxmApplicationStateData Data;

    SxmApplicationStateDataBindingSource();
};

typedef ::Courier::DataItemMsg< SxmApplicationStateDataBindingSource > SxmApplicationStateDataItemMsg;

// =========================================================================

class ListScrollBarInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 64;
    static const ::Courier::DataItemKey cDataItemKey = 64;

    typedef ::ListScrollBarInfoData Data;

    ListScrollBarInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< ListScrollBarInfoDataBindingSource > ListScrollBarInfoDataItemMsg;

// =========================================================================

class CarModeVisibilityDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 65;
    static const ::Courier::DataItemKey cDataItemKey = 8;

    typedef ::CarModeVisibilityData Data;

    CarModeVisibilityDataBindingSource();
};

typedef ::Courier::DataItemMsg< CarModeVisibilityDataBindingSource > CarModeVisibilityDataItemMsg;

namespace ItemKey {
        static const ::Courier::DataItemKey InvalidItem = 0;
        static const ::Courier::DataItemKey SxmSFTunePopupItem = 1;
        static const ::Courier::DataItemKey SxmFavtDeletePopupItem = 3;
        static const ::Courier::DataItemKey SxmAudioSportsFlashAlertAdvisoryItem = 5;
        static const ::Courier::DataItemKey CarModeVisibilityItem = 8;
        static const ::Courier::DataItemKey SxmPresetItemItem = 11;
        static const ::Courier::DataItemKey SxmChannelInfoItem = 12;
        static const ::Courier::DataItemKey SXMAudioCustomizeChannelListItemItem = 14;
        static const ::Courier::DataItemKey SxmAudioDirectTuneTextInfoItem = 18;
        static const ::Courier::DataItemKey SxmSpeedLockUpdateForListItemScrollItem = 19;
        static const ::Courier::DataItemKey SxmAudioMenuChannelLockItem = 20;
        static const ::Courier::DataItemKey SxmAudioFavAlertButtonEnableItem = 21;
        static const ::Courier::DataItemKey SXMAudioSportsflashFavAdvisoryItem = 37;
        static const ::Courier::DataItemKey SxmAudioChannelNotSubscribedPopupItem = 43;
        static const ::Courier::DataItemKey SXMAudioSportsflashAlertItem = 48;
        static const ::Courier::DataItemKey SxmTpopChannelInfoItem = 51;
        static const ::Courier::DataItemKey SxmApplicationStateItem = 53;
        static const ::Courier::DataItemKey SxmPresetListItem = 56;
        static const ::Courier::DataItemKey SxmLeagueOrReplaceListItem = 58;
        static const ::Courier::DataItemKey SxmAudioReplayContentItem = 61;
        static const ::Courier::DataItemKey SxmAudioPresetControlItem = 62;
        static const ::Courier::DataItemKey SXMAudioCustomizeChannelItem = 63;
        static const ::Courier::DataItemKey ListScrollBarInfoItem = 64;
        static const ::Courier::DataItemKey SxmAudioDirectTuneKeyPressInfoItem = 73;
        static const ::Courier::DataItemKey HeaderTextItem = 79;
        static const ::Courier::DataItemKey SxmInfoButtonEnableItem = 81;
        static const ::Courier::DataItemKey SxmAudioCustomizeButtonItem = 82;
        static const ::Courier::DataItemKey SxmActivePresetBankItem = 83;
        static const ::Courier::DataItemKey SxmAudioMaintextAnimationItem = 84;
        static const ::Courier::DataItemKey SxmFavtUpdatePopupItem = 92;
        static const ::Courier::DataItemKey SxmAudioAlertFavtUpdatePopupItem = 93;
        static const ::Courier::DataItemKey SxmAudioSubScreenHeaderTextItem = 94;
        static const ::Courier::DataItemKey SxmAudioInfoForPopupItem = 99;
        static const ::Courier::DataItemKey SxmAudioFavArtistSongTeamListItem = 101;
        static const ::Courier::DataItemKey SxmAudioTuneScanItem = 109;
        static const ::Courier::DataItemKey SxmAudioModeItem = 113;
        static const ::Courier::DataItemKey AudioMuteInfoItem = 115;
        static const ::Courier::DataItemKey SxmAudioFavoriteSongItem = 117;
        static const ::Courier::DataItemKey SxmSettingTestmodeExternalDiagItem = 118;
        static const ::Courier::DataItemKey SXTWNButtonItem = 120;
        static const ::Courier::DataItemKey SxmGadgetChannelInfoItem = 122;
        static const ::Courier::DataItemKey SxmAudioLoadingInfoItem = 129;
        static const ::Courier::DataItemKey SxmAudioAlertSettingItem = 130;
        static const ::Courier::DataItemKey SXMAudioTWNItem = 131;
        static const ::Courier::DataItemKey SxmTabControlListItem = 132;
        static const ::Courier::DataItemKey SxmPopupInfoItem = 133;
        static const ::Courier::DataItemKey SxmAudioSliderConfItem = 134;
        static const ::Courier::DataItemKey SxmAudioPlayPauseItem = 135;
        static const ::Courier::DataItemKey SxmCategoriesListItem = 137;
        static const ::Courier::DataItemKey SxmSettingTestmodeUpdatePopupItem = 138;
        static const ::Courier::DataItemKey SxmAudioTuneStartItem = 143;
        static const ::Courier::DataItemKey SXMSFButtonItem = 145;
        static const ::Courier::DataItemKey SxmMenuListItem = 150;
        static const ::Courier::DataItemKey SpellerDeleteBtnStateItem = 152;
        static const ::Courier::DataItemKey SxmAudioSportsflashEnableItem = 156;
        static const ::Courier::DataItemKey SXMAudioSportsflashListItemAlertItem = 166;
        static const ::Courier::DataItemKey SxmAudioContentAlertItem = 168;
        static const ::Courier::DataItemKey SxmAudioChannelNotAvailablePopupItem = 178;
        static const ::Courier::DataItemKey SxmAudioChannelListItem = 183;
        static const ::Courier::DataItemKey SxmAudioScanItem = 189;
        static const ::Courier::DataItemKey SxmAudioSportsFlashTeamNamePopupItem = 193;
        static const ::Courier::DataItemKey SxmChannelLogoItem = 204;
        static const ::Courier::DataItemKey SXMAudioTWNNoInfoItem = 209;
        static const ::Courier::DataItemKey SxmUpdateFooterItem = 210;
        static const ::Courier::DataItemKey SxmAudioFavoriteArtistItem = 215;
        static const ::Courier::DataItemKey SxmMenuItemItem = 226;

    namespace SxmSFTunePopup {
            static const ::Courier::DataItemKey TeamsItem = 17;
            static const ::Courier::DataItemKey SFTextTypeItem = 202;
            static const ::Courier::DataItemKey isRegionTextAllowedItem = 80;
    } // namespace SxmSFTunePopup

    namespace SxmFavtDeletePopup {
            static const ::Courier::DataItemKey TextItem = 153;
    } // namespace SxmFavtDeletePopup

    namespace SxmAudioSportsFlashAlertAdvisory {
            static const ::Courier::DataItemKey Text1Item = 71;
    } // namespace SxmAudioSportsFlashAlertAdvisory

    namespace CarModeVisibility {
            static const ::Courier::DataItemKey VisibleStatusItem = 27;
    } // namespace CarModeVisibility

    namespace SxmPresetItem {
            static const ::Courier::DataItemKey ChannelNoItem = 157;
            static const ::Courier::DataItemKey PresetNoItem = 22;
            static const ::Courier::DataItemKey IsSmartFavItem = 57;
            static const ::Courier::DataItemKey SxmLogoItem = 59;
            static const ::Courier::DataItemKey IsEnableItem = 182;
            static const ::Courier::DataItemKey IsSelectedItem = 142;
    } // namespace SxmPresetItem

    namespace SxmChannelInfo {
            static const ::Courier::DataItemKey ChannelIDItem = 155;
            static const ::Courier::DataItemKey CategoryNameItem = 172;
            static const ::Courier::DataItemKey ArtistNameItem = 23;
            static const ::Courier::DataItemKey SongTitleItem = 149;
            static const ::Courier::DataItemKey PresetNumberItem = 234;
            static const ::Courier::DataItemKey ChannelNameItem = 9;
            static const ::Courier::DataItemKey SxmCGItem = 151;
            static const ::Courier::DataItemKey SxmCGVisibilityItem = 208;
            static const ::Courier::DataItemKey SxmAlbumartItem = 212;
            static const ::Courier::DataItemKey SxmAlbumartVisibilityItem = 162;
            static const ::Courier::DataItemKey PresetNumberVisibilityItem = 32;
            static const ::Courier::DataItemKey AdvisoryMessageItem = 197;
            static const ::Courier::DataItemKey AdvisoryMessageVisibilityItem = 154;
            static const ::Courier::DataItemKey StatusLineTextorIconItem = 2;
            static const ::Courier::DataItemKey PresetNumberForGadgetItem = 105;
            static const ::Courier::DataItemKey SxmInitializedItem = 238;
    } // namespace SxmChannelInfo

    namespace SXMAudioCustomizeChannelListItem {
            static const ::Courier::DataItemKey ChannelNumberItem = 86;
            static const ::Courier::DataItemKey ChannelNameItem = 35;
            static const ::Courier::DataItemKey IndexItem = 52;
            static const ::Courier::DataItemKey EnableItem = 235;
            static const ::Courier::DataItemKey VisiblityItem = 66;
            static const ::Courier::DataItemKey SxmLogoItem = 175;
    } // namespace SXMAudioCustomizeChannelListItem

    namespace SxmAudioDirectTuneTextInfo {
            static const ::Courier::DataItemKey EditorTextItem = 179;
            static const ::Courier::DataItemKey OkButtonEnabilityItem = 36;
            static const ::Courier::DataItemKey IsMaxCharReachedItem = 49;
    } // namespace SxmAudioDirectTuneTextInfo

    namespace SxmSpeedLockUpdateForListItemScroll {
            static const ::Courier::DataItemKey isFocusGainItem = 89;
    } // namespace SxmSpeedLockUpdateForListItemScroll

    namespace SxmAudioMenuChannelLock {
            static const ::Courier::DataItemKey OffOrOnItem = 68;
    } // namespace SxmAudioMenuChannelLock

    namespace SxmAudioFavAlertButtonEnable {
            static const ::Courier::DataItemKey EnableItem = 40;
    } // namespace SxmAudioFavAlertButtonEnable

    namespace SXMAudioSportsflashFavAdvisory {
            static const ::Courier::DataItemKey AdvisoryTextItem = 190;
    } // namespace SXMAudioSportsflashFavAdvisory

    namespace SxmAudioChannelNotSubscribedPopup {
            static const ::Courier::DataItemKey TextItem = 169;
    } // namespace SxmAudioChannelNotSubscribedPopup

    namespace SXMAudioSportsflashAlert {
            static const ::Courier::DataItemKey SwitchOnorOffItem = 187;
    } // namespace SXMAudioSportsflashAlert

    namespace SxmTpopChannelInfo {
            static const ::Courier::DataItemKey ChannelIDItem = 7;
            static const ::Courier::DataItemKey ChannelNameItem = 91;
    } // namespace SxmTpopChannelInfo

    namespace SxmApplicationState {
            static const ::Courier::DataItemKey StateItem = 103;
    } // namespace SxmApplicationState

    namespace SxmPresetList {
            static const ::Courier::DataItemKey BtnListLeftEnableItem = 195;
            static const ::Courier::DataItemKey BtnListRightEnableItem = 188;
            static const ::Courier::DataItemKey PageIndicatorItem = 34;
    } // namespace SxmPresetList

    namespace SxmLeagueOrReplaceList {
            static const ::Courier::DataItemKey TextItem = 10;
            static const ::Courier::DataItemKey IsEnableItem = 6;
    } // namespace SxmLeagueOrReplaceList

    namespace SxmAudioReplayContent {
            static const ::Courier::DataItemKey ActiveReplayModeItem = 165;
            static const ::Courier::DataItemKey ReplayOrScanItem = 44;
            static const ::Courier::DataItemKey ReplayModeTextVisibilityItem = 214;
            static const ::Courier::DataItemKey TimeToLiveItem = 159;
            static const ::Courier::DataItemKey PlayEnabledItem = 220;
            static const ::Courier::DataItemKey PauseEnabledItem = 67;
            static const ::Courier::DataItemKey SkipBackEnabledItem = 221;
            static const ::Courier::DataItemKey RewindEnabledItem = 124;
            static const ::Courier::DataItemKey FastForwardEnabledItem = 225;
            static const ::Courier::DataItemKey ForwardEnabledItem = 198;
    } // namespace SxmAudioReplayContent

    namespace SxmAudioPresetControl {
            static const ::Courier::DataItemKey SwitchPresetOrCtrlButtonItem = 177;
            static const ::Courier::DataItemKey EnabilityPresetOrCtrlButtonItem = 192;
            static const ::Courier::DataItemKey SwitchPresetOrCtrlOrScanItem = 26;
            static const ::Courier::DataItemKey DefaultFocusItem = 171;
            static const ::Courier::DataItemKey LapFocusItem = 123;
    } // namespace SxmAudioPresetControl

    namespace SXMAudioCustomizeChannel {
            static const ::Courier::DataItemKey SwitchClearOrSelectItem = 216;
    } // namespace SXMAudioCustomizeChannel

    namespace ListScrollBarInfo {
            static const ::Courier::DataItemKey EnabledItem = 206;
    } // namespace ListScrollBarInfo

    namespace SxmAudioDirectTuneKeyPressInfo {
            static const ::Courier::DataItemKey KeyPressedItem = 211;
    } // namespace SxmAudioDirectTuneKeyPressInfo

    namespace HeaderText {
            static const ::Courier::DataItemKey HeaderTextItem = 223;
            static const ::Courier::DataItemKey VisibleItem = 4;
    } // namespace HeaderText

    namespace SxmInfoButtonEnable {
            static const ::Courier::DataItemKey EnableItem = 76;
    } // namespace SxmInfoButtonEnable

    namespace SxmAudioCustomizeButton {
            static const ::Courier::DataItemKey EnableOrDisableItem = 136;
    } // namespace SxmAudioCustomizeButton

    namespace SxmActivePresetBank {
            static const ::Courier::DataItemKey ActivePresetBankItem = 233;
    } // namespace SxmActivePresetBank

    namespace SxmAudioMaintextAnimation {
            static const ::Courier::DataItemKey shouldrunItem = 104;
            static const ::Courier::DataItemKey textInformationItem = 146;
    } // namespace SxmAudioMaintextAnimation

    namespace SxmFavtUpdatePopup {
            static const ::Courier::DataItemKey TextItem = 70;
            static const ::Courier::DataItemKey PopupTypeItem = 77;
    } // namespace SxmFavtUpdatePopup

    namespace SxmAudioAlertFavtUpdatePopup {
            static const ::Courier::DataItemKey TextTypeItem = 161;
            static const ::Courier::DataItemKey TextChInfoItem = 114;
            static const ::Courier::DataItemKey TextDetailInfoItem = 227;
            static const ::Courier::DataItemKey AlertIconItem = 230;
            static const ::Courier::DataItemKey isRegionTextAllowedItem = 228;
    } // namespace SxmAudioAlertFavtUpdatePopup

    namespace SxmAudioSubScreenHeaderText {
            static const ::Courier::DataItemKey IndexItem = 24;
    } // namespace SxmAudioSubScreenHeaderText

    namespace SxmAudioInfoForPopup {
            static const ::Courier::DataItemKey ChannelNumberItem = 85;
            static const ::Courier::DataItemKey ChannelNameItem = 87;
            static const ::Courier::DataItemKey ArtistNameItem = 176;
            static const ::Courier::DataItemKey SongNameItem = 74;
            static const ::Courier::DataItemKey ChannelLockedItem = 98;
            static const ::Courier::DataItemKey ChannelMatureItem = 33;
            static const ::Courier::DataItemKey ChannelNotAvailableItem = 29;
            static const ::Courier::DataItemKey ChannelNotSubscribedItem = 121;
    } // namespace SxmAudioInfoForPopup

    namespace SxmAudioFavArtistSongTeamList {
            static const ::Courier::DataItemKey OnOrOffItem = 237;
            static const ::Courier::DataItemKey FavNameItem = 38;
    } // namespace SxmAudioFavArtistSongTeamList

    namespace SxmAudioTuneScan {
            static const ::Courier::DataItemKey EnableItem = 28;
    } // namespace SxmAudioTuneScan

    namespace SxmAudioMode {
            static const ::Courier::DataItemKey Scan1Item = 184;
            static const ::Courier::DataItemKey Scan2Item = 164;
            static const ::Courier::DataItemKey Scan3Item = 219;
            static const ::Courier::DataItemKey Scan4Item = 200;
    } // namespace SxmAudioMode

    namespace AudioMuteInfo {
            static const ::Courier::DataItemKey MuteStatusItem = 75;
    } // namespace AudioMuteInfo

    namespace SxmAudioFavoriteSong {
            static const ::Courier::DataItemKey SwitchSongtOnOrOffOrDeleteItem = 15;
    } // namespace SxmAudioFavoriteSong

    namespace SxmSettingTestmodeExternalDiag {
            static const ::Courier::DataItemKey ExternOnorOffItem = 160;
    } // namespace SxmSettingTestmodeExternalDiag

    namespace SXTWNButton {
            static const ::Courier::DataItemKey TWNButtonItem = 174;
            static const ::Courier::DataItemKey BtnEnableItem = 90;
            static const ::Courier::DataItemKey AdvisoryorListItem = 45;
    } // namespace SXTWNButton

    namespace SxmGadgetChannelInfo {
            static const ::Courier::DataItemKey AdvisoryMessageItem = 69;
            static const ::Courier::DataItemKey AdvisoryMessageVisibilityItem = 46;
            static const ::Courier::DataItemKey SxmInitializedItem = 231;
    } // namespace SxmGadgetChannelInfo

    namespace SxmAudioLoadingInfo {
            static const ::Courier::DataItemKey Load1Item = 128;
            static const ::Courier::DataItemKey Load2Item = 106;
            static const ::Courier::DataItemKey Load3Item = 95;
            static const ::Courier::DataItemKey Load4Item = 88;
    } // namespace SxmAudioLoadingInfo

    namespace SxmAudioAlertSetting {
            static const ::Courier::DataItemKey AlertTextItem = 199;
            static const ::Courier::DataItemKey OnOrOffItem = 207;
    } // namespace SxmAudioAlertSetting

    namespace SXMAudioTWN {
            static const ::Courier::DataItemKey OnOrOffItem = 116;
            static const ::Courier::DataItemKey CityItem = 163;
    } // namespace SXMAudioTWN

    namespace SxmTabControlList {
            static const ::Courier::DataItemKey CurrentActiveTabIndexItem = 30;
            static const ::Courier::DataItemKey IsTab1ButtonEnabledItem = 140;
            static const ::Courier::DataItemKey IsTab2ButtonEnabledItem = 224;
            static const ::Courier::DataItemKey IsTab3ButtonEnabledItem = 96;
            static const ::Courier::DataItemKey IsTab4ButtonEnabledItem = 72;
            static const ::Courier::DataItemKey IsTab1ButtonActiveItem = 196;
            static const ::Courier::DataItemKey IsTab2ButtonActiveItem = 218;
            static const ::Courier::DataItemKey IsTab3ButtonActiveItem = 55;
            static const ::Courier::DataItemKey IsTab4ButtonActiveItem = 16;
            static const ::Courier::DataItemKey Tab1ButtonNameTextItem = 41;
            static const ::Courier::DataItemKey Tab2ButtonNameTextItem = 203;
            static const ::Courier::DataItemKey Tab3ButtonNameTextItem = 180;
            static const ::Courier::DataItemKey Tab4ButtonNameTextItem = 108;
            static const ::Courier::DataItemKey HeaderTextItem = 111;
            static const ::Courier::DataItemKey CurrentServiceHeaderIndexItem = 107;
            static const ::Courier::DataItemKey Tab3BtnSwitchIndexItem = 229;
    } // namespace SxmTabControlList

    namespace SxmPopupInfo {
            static const ::Courier::DataItemKey PopupVisibleItem = 110;
    } // namespace SxmPopupInfo

    namespace SxmAudioSliderConf {
            static const ::Courier::DataItemKey SliderValueItem = 170;
            static const ::Courier::DataItemKey BufferValueItem = 217;
    } // namespace SxmAudioSliderConf

    namespace SxmAudioPlayPause {
            static const ::Courier::DataItemKey PlayOrPauseItem = 54;
    } // namespace SxmAudioPlayPause

    namespace SxmCategoriesList {
            static const ::Courier::DataItemKey CategoryNameItem = 65;
            static const ::Courier::DataItemKey CurrentCategoryItem = 144;
    } // namespace SxmCategoriesList

    namespace SxmSettingTestmodeUpdatePopup {
            static const ::Courier::DataItemKey TextItem = 102;
    } // namespace SxmSettingTestmodeUpdatePopup

    namespace SxmAudioTuneStart {
            static const ::Courier::DataItemKey TuneStartOnItem = 126;
    } // namespace SxmAudioTuneStart

    namespace SXMSFButton {
            static const ::Courier::DataItemKey SFButtonItem = 173;
            static const ::Courier::DataItemKey AdvisoryorListItem = 232;
            static const ::Courier::DataItemKey BtnEnableItem = 222;
    } // namespace SXMSFButton

    namespace SxmMenuList {
            static const ::Courier::DataItemKey SxmMenuLogoItem = 185;
            static const ::Courier::DataItemKey EnableItem = 141;
            static const ::Courier::DataItemKey MenuTextItem = 125;
            static const ::Courier::DataItemKey SignalQualityItem = 213;
            static const ::Courier::DataItemKey TuneScanChoiceItem = 148;
    } // namespace SxmMenuList

    namespace SpellerDeleteBtnState {
            static const ::Courier::DataItemKey IsEnabledItem = 25;
    } // namespace SpellerDeleteBtnState

    namespace SxmAudioSportsflashEnable {
            static const ::Courier::DataItemKey EnableOnItem = 236;
    } // namespace SxmAudioSportsflashEnable

    namespace SXMAudioSportsflashListItemAlert {
            static const ::Courier::DataItemKey SwitchOnorOffItem = 158;
    } // namespace SXMAudioSportsflashListItemAlert

    namespace SxmAudioContentAlert {
            static const ::Courier::DataItemKey AdvisoryMessageItem = 191;
            static const ::Courier::DataItemKey AdvisoryorListItem = 186;
            static const ::Courier::DataItemKey AdvisoryLoadingItem = 60;
    } // namespace SxmAudioContentAlert

    namespace SxmAudioChannelNotAvailablePopup {
            static const ::Courier::DataItemKey TextItem = 97;
    } // namespace SxmAudioChannelNotAvailablePopup

    namespace SxmAudioChannelList {
            static const ::Courier::DataItemKey ChannelNumberItem = 100;
            static const ::Courier::DataItemKey SxmLogoItem = 201;
            static const ::Courier::DataItemKey ChannelNameItem = 167;
            static const ::Courier::DataItemKey ArtistItem = 119;
            static const ::Courier::DataItemKey SongItem = 205;
            static const ::Courier::DataItemKey CurrentPlayItem = 127;
    } // namespace SxmAudioChannelList

    namespace SxmAudioScan {
            static const ::Courier::DataItemKey ScanOnItem = 47;
            static const ::Courier::DataItemKey ScanContentAvailItem = 78;
    } // namespace SxmAudioScan

    namespace SxmAudioSportsFlashTeamNamePopup {
            static const ::Courier::DataItemKey TextItem = 112;
    } // namespace SxmAudioSportsFlashTeamNamePopup

    namespace SxmChannelLogo {
            static const ::Courier::DataItemKey ImageSizeItem = 42;
            static const ::Courier::DataItemKey SxmCGLogoItem = 194;
    } // namespace SxmChannelLogo

    namespace SXMAudioTWNNoInfo {
            static const ::Courier::DataItemKey textItem = 39;
    } // namespace SXMAudioTWNNoInfo

    namespace SxmUpdateFooter {
            static const ::Courier::DataItemKey FocusedIndexItem = 139;
            static const ::Courier::DataItemKey TotalCountItem = 31;
            static const ::Courier::DataItemKey FooterVisibleItem = 181;
    } // namespace SxmUpdateFooter

    namespace SxmAudioFavoriteArtist {
            static const ::Courier::DataItemKey SwitchArtistOnOrOffOrDeleteItem = 147;
    } // namespace SxmAudioFavoriteArtist

    namespace SxmMenuItem {
            static const ::Courier::DataItemKey ArtistEnableItem = 13;
            static const ::Courier::DataItemKey SongEnableItem = 50;
    } // namespace SxmMenuItem
} // namespace ItemKey

bool InitDataBinding();

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HeaderTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HeaderTextDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AudioMuteInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AudioMuteInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmTabControlListDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmTabControlListDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmSpeedLockUpdateForListItemScrollDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmSpeedLockUpdateForListItemScrollDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioFavArtistSongTeamListDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioFavArtistSongTeamListDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmUpdateFooterDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmUpdateFooterDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmPopupInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmPopupInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmPresetListDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmPresetListDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioLoadingInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioLoadingInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioModeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioModeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioMaintextAnimationDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioMaintextAnimationDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioTuneScanDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioTuneScanDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmMenuListDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmMenuListDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmMenuItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmMenuItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmChannelInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmChannelInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmTpopChannelInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmTpopChannelInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmGadgetChannelInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmGadgetChannelInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioInfoForPopupDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioInfoForPopupDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmActivePresetBankDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmActivePresetBankDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmCategoriesListDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmCategoriesListDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmChannelLogoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmChannelLogoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioPresetControlDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioPresetControlDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioPlayPauseDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioPlayPauseDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioAlertSettingDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioAlertSettingDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioFavAlertButtonEnableDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioFavAlertButtonEnableDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioAlertFavtUpdatePopupDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioAlertFavtUpdatePopupDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmPresetItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmPresetItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioChannelListDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioChannelListDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioSubScreenHeaderTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioSubScreenHeaderTextDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioFavoriteArtistDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioFavoriteArtistDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioFavoriteSongDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioFavoriteSongDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmLeagueOrReplaceListDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmLeagueOrReplaceListDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmInfoButtonEnableDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmInfoButtonEnableDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioReplayContentDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioReplayContentDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SXMAudioCustomizeChannelDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SXMAudioCustomizeChannelDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SXMAudioCustomizeChannelListItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SXMAudioCustomizeChannelListItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioDirectTuneTextInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioDirectTuneTextInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioDirectTuneKeyPressInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioDirectTuneKeyPressInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SpellerDeleteBtnStateDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SpellerDeleteBtnStateDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioChannelNotAvailablePopupDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioChannelNotAvailablePopupDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioChannelNotSubscribedPopupDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioChannelNotSubscribedPopupDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioTuneStartDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioTuneStartDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioScanDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioScanDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioSportsFlashTeamNamePopupDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioSportsFlashTeamNamePopupDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioSportsFlashAlertAdvisoryDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioSportsFlashAlertAdvisoryDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SXMAudioSportsflashAlertDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SXMAudioSportsflashAlertDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SXMAudioSportsflashListItemAlertDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SXMAudioSportsflashListItemAlertDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SXMAudioSportsflashFavAdvisoryDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SXMAudioSportsflashFavAdvisoryDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioSportsflashEnableDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioSportsflashEnableDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioMenuChannelLockDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioMenuChannelLockDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioCustomizeButtonDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioCustomizeButtonDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SXMAudioTWNDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SXMAudioTWNDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SXMAudioTWNNoInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SXMAudioTWNNoInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SXTWNButtonDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SXTWNButtonDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SXMSFButtonDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SXMSFButtonDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmSFTunePopupDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmSFTunePopupDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioSliderConfDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioSliderConfDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmSettingTestmodeUpdatePopupDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmSettingTestmodeUpdatePopupDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmSettingTestmodeExternalDiagDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmSettingTestmodeExternalDiagDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioContentAlertDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioContentAlertDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmFavtUpdatePopupDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmFavtUpdatePopupDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmFavtDeletePopupDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmFavtDeletePopupDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmApplicationStateDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmApplicationStateDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::CarModeVisibilityDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::CarModeVisibilityDataBindingSource > const& dataItemContainer);
} // namespace FeatStd
#endif // FEATSTD_STRINGBUFFER_APPENDER_ENABLED
#endif // AppHmi_SxmStateMachine_h
