/************************************************************************
*FILE: AppHmi_SxmStateMachine.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "AppHmi_SxmStateMachine.h"
#include <FeatStd/Util/StaticObject.h>
#include <Cit/VisualStateGlueLayer/VisualStateGlueLayer.h>
#include <Courier/Util/Util.h>
using namespace ::hmibase;
using namespace ::hmi;

//====  defines and includes TTFis output - added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
#include "hmi_trace_if.h"
#include "View/CGI/CourierMsgTracing/CourierMessageMapTrace.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_SM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/AppHmi_SxmStateMachine.cpp.trc.h"
#endif                            
//====  defines and includes TTFis output - end                        key: SM_TTFis_SBHFMSRF ====

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
bool SendSxmContextSwitchScreenReqMsg(Courier::UInt32 const & aContextId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmContextSwitchScreenReqMsg)(aContextId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmSelectedTabReqMsg(Courier::UInt32 const & aListId, Courier::UInt8 const & aTabIndex, Courier::UInt8 const & aTriggerType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmSelectedTabReqMsg)(aListId, aTabIndex, aTriggerType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmTabListEntrySelectionReqMsg(Courier::UInt32 const & aListId, Courier::UInt32 const & aHdl, Courier::UInt32 const & aSubHdl)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmTabListEntrySelectionReqMsg)(aListId, aHdl, aSubHdl);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmUpdateCurrentBindingIndexMsg(Courier::UInt8 const & aTabIndex)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmUpdateCurrentBindingIndexMsg)(aTabIndex);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMSourceChangeReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMSourceChangeReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMClearActiveContextsMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMClearActiveContextsMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmSportsContextViewMsg(Courier::UInt32 const & aContextId, bool const & aAddRemove)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmSportsContextViewMsg)(aContextId, aAddRemove);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMAudioMonitorUpdatesMsg(Courier::UInt32 const & aListId, bool const & aEnableMonitoring)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMAudioMonitorUpdatesMsg)(aListId, aEnableMonitoring);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMPopUpStateUpdMsg(bool const & aVisible)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMPopUpStateUpdMsg)(aVisible);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMActiveServiceMsg(Courier::UInt8 const & aServiceType, Courier::UInt8 const & aServiceEntryExitStatus)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMActiveServiceMsg)(aServiceType, aServiceEntryExitStatus);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMTuneToChannelReqMsg(Courier::UInt8 const & aSelectionMode, Courier::UInt16 const & aCidOrSidNumber, Courier::Int8 const & aSteps)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMTuneToChannelReqMsg)(aSelectionMode, aCidOrSidNumber, aSteps);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMTuneSelectedChannelItemReqMsg(Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMTuneSelectedChannelItemReqMsg)(aListId, aRowId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmAudioCategoriesReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmAudioCategoriesReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmAudioUpdatePresetListReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmAudioUpdatePresetListReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmAudioChangePresetBankReqMsg(Courier::Int8 const & aDirection)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmAudioChangePresetBankReqMsg)(aDirection);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMAudioChannelListReqMsg(Courier::UInt32 const & aRowId, Courier::UInt32 const & aListId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMAudioChannelListReqMsg)(aRowId, aListId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMAudioRecallorStoreReqMsg(Courier::UInt8 const & aPresetRowIndex, Courier::UInt8 const & aPresetColIndex, Courier::UInt8 const & aPresetAction)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMAudioRecallorStoreReqMsg)(aPresetRowIndex, aPresetColIndex, aPresetAction);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmAudioContentAlertListReqMsg(Courier::UInt8 const & aHdl, Courier::UInt8 const & aFavType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmAudioContentAlertListReqMsg)(aHdl, aFavType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmAudioAlertSettingOnOffReqMsg(Courier::UInt32 const & aHdl)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmAudioAlertSettingOnOffReqMsg)(aHdl);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmAudioPresetControlReqMsg(Courier::UInt8 const & aPressedButton)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmAudioPresetControlReqMsg)(aPressedButton);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMAudioReplayControlReqMsg(Courier::UInt8 const & aPressedButton)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMAudioReplayControlReqMsg)(aPressedButton);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMAudioCustomizeListReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMAudioCustomizeListReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMAudioCustomizeControlReqMsg(Courier::UInt32 const & aHdl)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMAudioCustomizeControlReqMsg)(aHdl);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMAudioCustomizeClearSelectReqMsg(Courier::UInt8 const & aValue)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMAudioCustomizeClearSelectReqMsg)(aValue);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMAudioAlertsTurnOnOffReqMsg(Courier::Int32 const & aOnOffStatus, Courier::Int32 const & aFavoriteType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMAudioAlertsTurnOnOffReqMsg)(aOnOffStatus, aFavoriteType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMAudioEnableDeleteFavReqMsg(Courier::Int32 const & aFavoriteType, Courier::Int32 const & aHdl, Courier::Int32 const & aSubHdl)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMAudioEnableDeleteFavReqMsg)(aFavoriteType, aHdl, aSubHdl);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMSettingsTestModeListReqMsg(Courier::UInt32 const & aHdl, Courier::UInt32 const & aTestmodeListId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMSettingsTestModeListReqMsg)(aHdl, aTestmodeListId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMAudioDirectTuneOkReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMAudioDirectTuneOkReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMAudioDirectTuneClearSpellerReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMAudioDirectTuneClearSpellerReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMAudioDirectTuneDeletePosReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMAudioDirectTuneDeletePosReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMAudioTuneStartReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMAudioTuneStartReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMAudioScanOpertationReqMsg(Courier::UInt8 const & aOperationType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMAudioScanOpertationReqMsg)(aOperationType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMAudioSportsLeagueListReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMAudioSportsLeagueListReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMAudioSportsTeamListForLeagueReqMsg(Courier::UInt32 const & aHdl)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMAudioSportsTeamListForLeagueReqMsg)(aHdl);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMAudioSportsOnPressTeamNameReqMsg(Courier::UInt32 const & aHdl)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMAudioSportsOnPressTeamNameReqMsg)(aHdl);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMAudioSportsCloseOfMaxFavPopupReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMAudioSportsCloseOfMaxFavPopupReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMAudioSportsOnPressReplaceTeamNameReqMsg(Courier::UInt32 const & aHdl)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMAudioSportsOnPressReplaceTeamNameReqMsg)(aHdl);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMAudioSportsRefreshTeamListReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMAudioSportsRefreshTeamListReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMAudioSportsAlertListReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMAudioSportsAlertListReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMAudioSportsFavListReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMAudioSportsFavListReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMAudioGotoAudioMainMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMAudioGotoAudioMainMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMAudioSportsflashTurnAlertAllOnReqMsg(Courier::UInt32 const & aSxm_SportsflashAlertStatus)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMAudioSportsflashTurnAlertAllOnReqMsg)(aSxm_SportsflashAlertStatus);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMAudioSportsflashDeleteFavtTeamReqMsg(Courier::UInt32 const & aListId, Courier::UInt32 const & aHdl, Courier::UInt32 const & aSubHdl)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMAudioSportsflashDeleteFavtTeamReqMsg)(aListId, aHdl, aSubHdl);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmSFButtonPressReqMsg(Courier::UInt32 const & aButtonColor)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmSFButtonPressReqMsg)(aButtonColor);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmSFDisableMonitorReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmSFDisableMonitorReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmSFYesForMonitorPopupReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmSFYesForMonitorPopupReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmSFTuneChannelReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmSFTuneChannelReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmSFReturnChannelReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmSFReturnChannelReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmSFAlertCloseReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmSFAlertCloseReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmTWNSettingsReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmTWNSettingsReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmTWNYesForPopupMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmTWNYesForPopupMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmTWNListSelectReqMsg(Courier::UInt32 const & aListId, Courier::UInt32 const & aHdl)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmTWNListSelectReqMsg)(aListId, aHdl);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmTWNButtonPressReqMsg(Courier::UInt32 const & aBtnColor)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmTWNButtonPressReqMsg)(aBtnColor);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmAudioSaveFavReqMsg(Courier::UInt32 const & aFavoriteType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmAudioSaveFavReqMsg)(aFavoriteType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmAudioDeleteAllFavReqMsg(Courier::UInt32 const & aFavoriteType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmAudioDeleteAllFavReqMsg)(aFavoriteType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmAudioDeleteAllConfirmReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmAudioDeleteAllConfirmReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmAudioCloseFavMaxReachedPopupReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmAudioCloseFavMaxReachedPopupReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmAudioReplaceSelectedFavReqMsg(Courier::UInt32 const & aRowId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmAudioReplaceSelectedFavReqMsg)(aRowId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmAudioTunetoContentAlertReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmAudioTunetoContentAlertReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmAudioCloseContentAlertPopupReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmAudioCloseContentAlertPopupReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmChannelLockStatusReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmChannelLockStatusReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMTPopUpAudioStateUpdMsg(bool const & aIsActive)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMTPopUpAudioStateUpdMsg)(aIsActive);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmAudioFocusResetReqMsg(Courier::UInt32 const & aViewId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmAudioFocusResetReqMsg)(aViewId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSXMInfoUpdatedatabindingReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SXMInfoUpdatedatabindingReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmDTMTestModeMonitorSelReqMsg(bool const & aStartMonitor)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmDTMTestModeMonitorSelReqMsg)(aStartMonitor);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmWaitSyncCancelledMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmWaitSyncCancelledMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSxmFooterListIdReqMsg(Courier::UInt32 const & aListId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SxmFooterListIdReqMsg)(aListId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendGuiStartupFinishedUpdMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::GuiStartupFinishedUpdMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeLanguageReqMsg(enLanguageId const & aLanguageId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeLanguageReqMsg)(aLanguageId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFocusReqMsg(FocusActionEnum const & aAction, FocusTimerActionEnum const & aTimerAction, ::Courier::ViewId const & aView, Candera::String const & aWidget)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FocusReqMsg)(aAction, aTimerAction, aView, aWidget);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDummyMess(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DummyMess)(aFirstView, aSecondView, aPos);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAnimationReqMsg(Courier::AnimationAction::Enum const & aAnimationAction, ::Courier::ViewId const & aViewId, Courier::CompositePath const & aCompositePath, ::Courier::ItemId const & aAnimationId, Courier::AnimationProperties const & aAnimationProperties)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::AnimationReqMsg)(aAnimationAction, aViewId, aCompositePath, aAnimationId, aAnimationProperties);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFocusOnRightEncoderReqUpdMsg(bool const & aIsFocusUsed)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FocusOnRightEncoderReqUpdMsg)(aIsFocusUsed);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStoreActiveGadgetReqMsg(bool const & aIsGadgetAtive)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StoreActiveGadgetReqMsg)(aIsGadgetAtive);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendHardKeyPressNotificationMsg(Courier::UInt8 const & aDummy, Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::HardKeyPressNotificationMsg)(aDummy, aHKCode, aHKState);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDropdownChangeMsg(::Candera::DropdownChangeType const & aDropdownChangeType, ::Courier::UInt32 const & aListId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DropdownChangeMsg)(aDropdownChangeType, aListId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStartPopupTimerReqMsg(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StartPopupTimerReqMsg)(aViewId, aTimeout);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStopPopupTimerReqMsg(Courier::UInt32 const & aViewId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StopPopupTimerReqMsg)(aViewId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPlayBeepReqMsg(Courier::Int32 const & aBeepType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PlayBeepReqMsg)(aBeepType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCheckToClosePopupMsg(Courier::UInt32 const & aPopupId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CheckToClosePopupMsg)(aPopupId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendRestartPopupTimerReqMsg(Courier::UInt32 const & aViewId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::RestartPopupTimerReqMsg)(aViewId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendContextSwitchInResMsg(Courier::UInt32 const & aSwitchId, Courier::UInt32 const & aResponseType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ContextSwitchInResMsg)(aSwitchId, aResponseType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendContextSwitchOutReqMsg(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ContextSwitchOutReqMsg)(aTargetContextId, aSourceContextId, aTargetAppId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCurrentScreenDisplayReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CurrentScreenDisplayReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendLaunchBarDisplayReqMsg(bool const & aVisibility)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::LaunchBarDisplayReqMsg)(aVisibility);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendNavTBTSwipeReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::NavTBTSwipeReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListItemRightEncoderChangeUpdMsg(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListItemRightEncoderChangeUpdMsg)(aSteps, aListId, aRowId, aColumnId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListChangeMsg(::Courier::UInt32 const & aListId, ListChangeType const & aListChangeType, ::Courier::Int32 const & aValue, ListChangeMsgSourceType const & aListChangeMsgSource, bool const & aImmediatePositioning)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListChangeMsg)(aListId, aListChangeType, aValue, aListChangeMsgSource, aImmediatePositioning);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListFocusScrollReqMsg(Courier::UInt32 const & aListId, Courier::Int32 const & aSteps)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListFocusScrollReqMsg)(aListId, aSteps);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListFocusLockDataResetReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListFocusLockDataResetReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSetApplicationModeReqMsg(Courier::UInt32 const & aModeId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SetApplicationModeReqMsg)(aModeId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSpellerBbehaviorReqMsg(bool const & aEnable)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SpellerBbehaviorReqMsg)(aEnable);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStatusBarDisplayReqMsg(bool const & aVisibility, Courier::Int32 const & aHeaderType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StatusBarDisplayReqMsg)(aVisibility, aHeaderType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendTBTRetriggerAcousticMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::TBTRetriggerAcousticMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendViewReqMsg(Courier::ViewAction::Enum const & aViewAction, ::Courier::ViewId const & aViewId, bool const & aShallInitScene, bool const & aShallLoadScene)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::ViewReqMsg)(aViewAction, aViewId, aShallInitScene, aShallLoadScene);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendActivationReqMsg(::Courier::ViewId const & aViewId, bool const & aActivation, bool const & aEnableRendering)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::ActivationReqMsg)(aViewId, aActivation, aEnableRendering);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAsyncLoadReqMsg(::Courier::ViewId const & aViewId, bool const & aLoad)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::AsyncLoadReqMsg)(aViewId, aLoad);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupReqMsg(hmibase::popups::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aPopupDisplayID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupReqMsg)(aCommand, aViewId, aPopupDisplayID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendExtendedViewReqMsg(hmibase::views::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ExtendedViewReqMsg)(aCommand, aViewId, aHint);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendShowHMISubSurfaceReqMsg(hmibase::displayRegion const & aDisplayRegion, Courier::Int32 const & aDisplayRegionType, bool const & aShowSubSurface, Courier::UInt32 const & aDisplayID, bool const & aLockSubSurface)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ShowHMISubSurfaceReqMsg)(aDisplayRegion, aDisplayRegionType, aShowSubSurface, aDisplayID, aLockSubSurface);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendRegisterForCloseOnTouchSessionReqMsg(bool const & aRegister, ::Courier::ViewId const & aViewId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::RegisterForCloseOnTouchSessionReqMsg)(aRegister, aViewId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupFilterPrioEnableReqMsg(Courier::UInt32 const & aPrio)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupFilterPrioEnableReqMsg)(aPrio);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupFilterAllEnableReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupFilterAllEnableReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupFilterDisableReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupFilterDisableReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendProfileSwitchMsg(Courier::UInt32 const & aProfile)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ProfileSwitchMsg)(aProfile);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendMultiDisplayPopupFilterReqMsg(hmibase::PopupFilterType const & aPopupFilterType, Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::MultiDisplayPopupFilterReqMsg)(aPopupFilterType, aPrio, aDisplayID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCreateNewDestroyOld(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CreateNewDestroyOld)(aSourceView, aDestinationView, aUserData1, aUserData2);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendNotifierMessage()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::NotifierMessage)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmContextSwitchScreen(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acSxmContextSwitchScreen(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acSxmContextSwitchScreen(Courier::UInt32 const & aContextId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSxmContextSwitchScreen(aContextId = %d)", aContextId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmContextSwitchScreenReqMsg(aContextId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmSelectedTab(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt())) { return false; }
    Action_acSxmSelectedTab(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt(), parameters[(::Json::Value::UInt)2].asUInt());
    return true;
}
#endif
void Action_acSxmSelectedTab(Courier::UInt32 const & aListId, Courier::UInt8 const & aTabIndex, Courier::UInt8 const & aTriggerType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSxmSelectedTab(aListId = %d, aTabIndex = %d, aTriggerType = %d)", aListId,aTabIndex,aTriggerType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmSelectedTabReqMsg(aListId, aTabIndex, aTriggerType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmTabListEntrySelection(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt())) { return false; }
    Action_acSxmTabListEntrySelection(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt(), parameters[(::Json::Value::UInt)2].asUInt());
    return true;
}
#endif
void Action_acSxmTabListEntrySelection(Courier::UInt32 const & aListId, Courier::UInt32 const & aHdl, Courier::UInt32 const & aSubHdl)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSxmTabListEntrySelection(aListId = %d, aHdl = %d, aSubHdl = %d)", aListId,aHdl,aSubHdl));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmTabListEntrySelectionReqMsg(aListId, aHdl, aSubHdl);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmUpdateCurrentBindingIndexMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acSxmUpdateCurrentBindingIndexMsg(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acSxmUpdateCurrentBindingIndexMsg(Courier::UInt8 const & aTabIndex)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSxmUpdateCurrentBindingIndexMsg(aTabIndex = %d)", aTabIndex));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmUpdateCurrentBindingIndexMsg(aTabIndex);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMSourceChangeReqMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSXMSourceChangeReqMsg();
    return true;
}
#endif
void Action_acSXMSourceChangeReqMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMSourceChangeReqMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMSourceChangeReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMClearActiveContexts(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSXMClearActiveContexts();
    return true;
}
#endif
void Action_acSXMClearActiveContexts()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMClearActiveContexts()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMClearActiveContextsMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmSportsContextViewMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isBool())) { return false; }
    Action_acSxmSportsContextViewMsg(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asBool());
    return true;
}
#endif
void Action_acSxmSportsContextViewMsg(Courier::UInt32 const & aContextId, bool const & aAddRemove)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSxmSportsContextViewMsg(aContextId = %d, aAddRemove = %d)", aContextId,aAddRemove));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmSportsContextViewMsg(aContextId, aAddRemove);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioMonitorUpdatesMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isBool())) { return false; }
    Action_acSXMAudioMonitorUpdatesMsg(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asBool());
    return true;
}
#endif
void Action_acSXMAudioMonitorUpdatesMsg(Courier::UInt32 const & aListId, bool const & aEnableMonitoring)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMAudioMonitorUpdatesMsg(aListId = %d, aEnableMonitoring = %d)", aListId,aEnableMonitoring));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMAudioMonitorUpdatesMsg(aListId, aEnableMonitoring);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMPopUpStateUpdMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acSXMPopUpStateUpdMsg(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acSXMPopUpStateUpdMsg(bool const & aVisible)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMPopUpStateUpdMsg(aVisible = %d)", aVisible));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMPopUpStateUpdMsg(aVisible);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMActiveServiceMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_acSXMActiveServiceMsg(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_acSXMActiveServiceMsg(Courier::UInt8 const & aServiceType, Courier::UInt8 const & aServiceEntryExitStatus)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMActiveServiceMsg(aServiceType = %d, aServiceEntryExitStatus = %d)", aServiceType,aServiceEntryExitStatus));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMActiveServiceMsg(aServiceType, aServiceEntryExitStatus);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMTuneToChannel(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isInt())) { return false; }
    Action_acSXMTuneToChannel(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt(), parameters[(::Json::Value::UInt)2].asInt());
    return true;
}
#endif
void Action_acSXMTuneToChannel(Courier::UInt8 const & aSelectionMode, Courier::UInt16 const & aCidOrSidNumber, Courier::Int8 const & aSteps)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMTuneToChannel(aSelectionMode = %d, aCidOrSidNumber = %d, aSteps = %d)", aSelectionMode,aCidOrSidNumber,aSteps));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMTuneToChannelReqMsg(aSelectionMode, aCidOrSidNumber, aSteps);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMTuneSelectedChannelItem(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_acSXMTuneSelectedChannelItem(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_acSXMTuneSelectedChannelItem(Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMTuneSelectedChannelItem(aListId = %d, aRowId = %d)", aListId,aRowId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMTuneSelectedChannelItemReqMsg(aListId, aRowId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmAudioCategories(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSxmAudioCategories();
    return true;
}
#endif
void Action_acSxmAudioCategories()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSxmAudioCategories()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmAudioCategoriesReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmAudioUpdatePresetList(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSxmAudioUpdatePresetList();
    return true;
}
#endif
void Action_acSxmAudioUpdatePresetList()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSxmAudioUpdatePresetList()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmAudioUpdatePresetListReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmAudioChangePresetBank(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_acSxmAudioChangePresetBank(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_acSxmAudioChangePresetBank(Courier::Int8 const & aDirection)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSxmAudioChangePresetBank(aDirection = %d)", aDirection));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmAudioChangePresetBankReqMsg(aDirection);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioChannelList(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_acSXMAudioChannelList(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_acSXMAudioChannelList(Courier::UInt32 const & aRowId, Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMAudioChannelList(aRowId = %d, aListId = %d)", aRowId,aListId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMAudioChannelListReqMsg(aRowId, aListId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioRecallorStore(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt())) { return false; }
    Action_acSXMAudioRecallorStore(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt(), parameters[(::Json::Value::UInt)2].asUInt());
    return true;
}
#endif
void Action_acSXMAudioRecallorStore(Courier::UInt8 const & aPresetRowIndex, Courier::UInt8 const & aPresetColIndex, Courier::UInt8 const & aPresetAction)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMAudioRecallorStore(aPresetRowIndex = %d, aPresetColIndex = %d, aPresetAction = %d)", aPresetRowIndex,aPresetColIndex,aPresetAction));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMAudioRecallorStoreReqMsg(aPresetRowIndex, aPresetColIndex, aPresetAction);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmAudioContentAlertList(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_acSxmAudioContentAlertList(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_acSxmAudioContentAlertList(Courier::UInt8 const & aHdl, Courier::UInt8 const & aFavType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSxmAudioContentAlertList(aHdl = %d, aFavType = %d)", aHdl,aFavType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmAudioContentAlertListReqMsg(aHdl, aFavType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmAudioAlertSettingOnOff(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acSxmAudioAlertSettingOnOff(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acSxmAudioAlertSettingOnOff(Courier::UInt32 const & aHdl)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSxmAudioAlertSettingOnOff(aHdl = %d)", aHdl));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmAudioAlertSettingOnOffReqMsg(aHdl);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmAudioPresetControl(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acSxmAudioPresetControl(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acSxmAudioPresetControl(Courier::UInt8 const & aPressedButton)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSxmAudioPresetControl(aPressedButton = %d)", aPressedButton));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmAudioPresetControlReqMsg(aPressedButton);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioReplayControl(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acSXMAudioReplayControl(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acSXMAudioReplayControl(Courier::UInt8 const & aPressedButton)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMAudioReplayControl(aPressedButton = %d)", aPressedButton));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMAudioReplayControlReqMsg(aPressedButton);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioCustomizeList(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSXMAudioCustomizeList();
    return true;
}
#endif
void Action_acSXMAudioCustomizeList()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMAudioCustomizeList()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMAudioCustomizeListReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioCustomizeControl(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acSXMAudioCustomizeControl(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acSXMAudioCustomizeControl(Courier::UInt32 const & aHdl)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMAudioCustomizeControl(aHdl = %d)", aHdl));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMAudioCustomizeControlReqMsg(aHdl);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioCustomizeClearSelect(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acSXMAudioCustomizeClearSelect(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acSXMAudioCustomizeClearSelect(Courier::UInt8 const & aValue)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMAudioCustomizeClearSelect(aValue = %d)", aValue));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMAudioCustomizeClearSelectReqMsg(aValue);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioAlertsTurnOnOff(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_acSXMAudioAlertsTurnOnOff(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_acSXMAudioAlertsTurnOnOff(Courier::Int32 const & aOnOffStatus, Courier::Int32 const & aFavoriteType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMAudioAlertsTurnOnOff(aOnOffStatus = %d, aFavoriteType = %d)", aOnOffStatus,aFavoriteType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMAudioAlertsTurnOnOffReqMsg(aOnOffStatus, aFavoriteType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioEnableDeleteFav(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt())) { return false; }
    Action_acSXMAudioEnableDeleteFav(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt(), parameters[(::Json::Value::UInt)2].asUInt());
    return true;
}
#endif
void Action_acSXMAudioEnableDeleteFav(Courier::Int32 const & aFavoriteType, Courier::Int32 const & aHdl, Courier::Int32 const & aSubHdl)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMAudioEnableDeleteFav(aFavoriteType = %d, aHdl = %d, aSubHdl = %d)", aFavoriteType,aHdl,aSubHdl));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMAudioEnableDeleteFavReqMsg(aFavoriteType, aHdl, aSubHdl);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMSettingTestmodeListUpdate(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_acSXMSettingTestmodeListUpdate(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_acSXMSettingTestmodeListUpdate(Courier::UInt32 const & aHdl, Courier::UInt32 const & aTestmodeListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMSettingTestmodeListUpdate(aHdl = %d, aTestmodeListId = %d)", aHdl,aTestmodeListId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMSettingsTestModeListReqMsg(aHdl, aTestmodeListId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioDirectTuneOk(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSXMAudioDirectTuneOk();
    return true;
}
#endif
void Action_acSXMAudioDirectTuneOk()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMAudioDirectTuneOk()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMAudioDirectTuneOkReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioDirectTuneClearSpeller(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSXMAudioDirectTuneClearSpeller();
    return true;
}
#endif
void Action_acSXMAudioDirectTuneClearSpeller()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMAudioDirectTuneClearSpeller()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMAudioDirectTuneClearSpellerReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioDirectTuneDeletePos(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSXMAudioDirectTuneDeletePos();
    return true;
}
#endif
void Action_acSXMAudioDirectTuneDeletePos()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMAudioDirectTuneDeletePos()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMAudioDirectTuneDeletePosReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioTuneStart(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSXMAudioTuneStart();
    return true;
}
#endif
void Action_acSXMAudioTuneStart()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMAudioTuneStart()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMAudioTuneStartReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioScanOpertation(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acSXMAudioScanOpertation(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acSXMAudioScanOpertation(Courier::UInt8 const & aOperationType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMAudioScanOpertation(aOperationType = %d)", aOperationType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMAudioScanOpertationReqMsg(aOperationType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioSportsLeagueList(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSXMAudioSportsLeagueList();
    return true;
}
#endif
void Action_acSXMAudioSportsLeagueList()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMAudioSportsLeagueList()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMAudioSportsLeagueListReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioSportsTeamListForLeague(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acSXMAudioSportsTeamListForLeague(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acSXMAudioSportsTeamListForLeague(Courier::UInt32 const & aHdl)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMAudioSportsTeamListForLeague(aHdl = %d)", aHdl));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMAudioSportsTeamListForLeagueReqMsg(aHdl);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioSportsOnPressTeamName(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acSXMAudioSportsOnPressTeamName(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acSXMAudioSportsOnPressTeamName(Courier::UInt32 const & aHdl)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMAudioSportsOnPressTeamName(aHdl = %d)", aHdl));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMAudioSportsOnPressTeamNameReqMsg(aHdl);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioSportsCloseOfMaxFavPopup(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSXMAudioSportsCloseOfMaxFavPopup();
    return true;
}
#endif
void Action_acSXMAudioSportsCloseOfMaxFavPopup()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMAudioSportsCloseOfMaxFavPopup()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMAudioSportsCloseOfMaxFavPopupReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioSportsOnPressReplaceTeamName(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acSXMAudioSportsOnPressReplaceTeamName(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acSXMAudioSportsOnPressReplaceTeamName(Courier::UInt32 const & aHdl)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMAudioSportsOnPressReplaceTeamName(aHdl = %d)", aHdl));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMAudioSportsOnPressReplaceTeamNameReqMsg(aHdl);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioSportsRefreshTeamList(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSXMAudioSportsRefreshTeamList();
    return true;
}
#endif
void Action_acSXMAudioSportsRefreshTeamList()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMAudioSportsRefreshTeamList()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMAudioSportsRefreshTeamListReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioSportsAlertList(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSXMAudioSportsAlertList();
    return true;
}
#endif
void Action_acSXMAudioSportsAlertList()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMAudioSportsAlertList()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMAudioSportsAlertListReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioSportsFavList(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSXMAudioSportsFavList();
    return true;
}
#endif
void Action_acSXMAudioSportsFavList()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMAudioSportsFavList()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMAudioSportsFavListReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioGoToAudioMain(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSXMAudioGoToAudioMain();
    return true;
}
#endif
void Action_acSXMAudioGoToAudioMain()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMAudioGoToAudioMain()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMAudioGotoAudioMainMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioSportsflashTurnAlertOn(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acSXMAudioSportsflashTurnAlertOn(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acSXMAudioSportsflashTurnAlertOn(Courier::UInt32 const & aSxm_SportsflashAlertStatus)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMAudioSportsflashTurnAlertOn(aSxm_SportsflashAlertStatus = %d)", aSxm_SportsflashAlertStatus));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMAudioSportsflashTurnAlertAllOnReqMsg(aSxm_SportsflashAlertStatus);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMAudioSportsflashDeleteFavtTeam(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt())) { return false; }
    Action_acSXMAudioSportsflashDeleteFavtTeam(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt(), parameters[(::Json::Value::UInt)2].asUInt());
    return true;
}
#endif
void Action_acSXMAudioSportsflashDeleteFavtTeam(Courier::UInt32 const & aListId, Courier::UInt32 const & aHdl, Courier::UInt32 const & aSubHdl)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMAudioSportsflashDeleteFavtTeam(aListId = %d, aHdl = %d, aSubHdl = %d)", aListId,aHdl,aSubHdl));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMAudioSportsflashDeleteFavtTeamReqMsg(aListId, aHdl, aSubHdl);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmSFButtonPress(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acSxmSFButtonPress(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acSxmSFButtonPress(Courier::UInt32 const & aButtonColor)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSxmSFButtonPress(aButtonColor = %d)", aButtonColor));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmSFButtonPressReqMsg(aButtonColor);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmSFDisableMonitorMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSxmSFDisableMonitorMsg();
    return true;
}
#endif
void Action_acSxmSFDisableMonitorMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSxmSFDisableMonitorMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmSFDisableMonitorReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmSFYesForMonitorPopupMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSxmSFYesForMonitorPopupMsg();
    return true;
}
#endif
void Action_acSxmSFYesForMonitorPopupMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSxmSFYesForMonitorPopupMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmSFYesForMonitorPopupReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmSFTuneChannelMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSxmSFTuneChannelMsg();
    return true;
}
#endif
void Action_acSxmSFTuneChannelMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSxmSFTuneChannelMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmSFTuneChannelReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmSFReturnChannelMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSxmSFReturnChannelMsg();
    return true;
}
#endif
void Action_acSxmSFReturnChannelMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSxmSFReturnChannelMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmSFReturnChannelReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmSFAlertClose(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSxmSFAlertClose();
    return true;
}
#endif
void Action_acSxmSFAlertClose()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSxmSFAlertClose()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmSFAlertCloseReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmTWNListSettings(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSxmTWNListSettings();
    return true;
}
#endif
void Action_acSxmTWNListSettings()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSxmTWNListSettings()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmTWNSettingsReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmTWNYesForPopup(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSxmTWNYesForPopup();
    return true;
}
#endif
void Action_acSxmTWNYesForPopup()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSxmTWNYesForPopup()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmTWNYesForPopupMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmTWNListSelect(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_acSxmTWNListSelect(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_acSxmTWNListSelect(Courier::UInt32 const & aListId, Courier::UInt32 const & aHdl)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSxmTWNListSelect(aListId = %d, aHdl = %d)", aListId,aHdl));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmTWNListSelectReqMsg(aListId, aHdl);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmTWNButtonPress(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acSxmTWNButtonPress(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acSxmTWNButtonPress(Courier::UInt32 const & aBtnColor)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSxmTWNButtonPress(aBtnColor = %d)", aBtnColor));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmTWNButtonPressReqMsg(aBtnColor);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmAudioSaveFav(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acSxmAudioSaveFav(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acSxmAudioSaveFav(Courier::UInt32 const & aFavoriteType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSxmAudioSaveFav(aFavoriteType = %d)", aFavoriteType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmAudioSaveFavReqMsg(aFavoriteType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmAudioDeleteallFav(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acSxmAudioDeleteallFav(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acSxmAudioDeleteallFav(Courier::UInt32 const & aFavoriteType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSxmAudioDeleteallFav(aFavoriteType = %d)", aFavoriteType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmAudioDeleteAllFavReqMsg(aFavoriteType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmAudioDeleteAllConfirmMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSxmAudioDeleteAllConfirmMsg();
    return true;
}
#endif
void Action_acSxmAudioDeleteAllConfirmMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSxmAudioDeleteAllConfirmMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmAudioDeleteAllConfirmReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmAudioCloseFavMaxReachedPopup(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSxmAudioCloseFavMaxReachedPopup();
    return true;
}
#endif
void Action_acSxmAudioCloseFavMaxReachedPopup()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSxmAudioCloseFavMaxReachedPopup()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmAudioCloseFavMaxReachedPopupReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmAudioReplaceSelectedFav(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acSxmAudioReplaceSelectedFav(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acSxmAudioReplaceSelectedFav(Courier::UInt32 const & aRowId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSxmAudioReplaceSelectedFav(aRowId = %d)", aRowId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmAudioReplaceSelectedFavReqMsg(aRowId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmAudioTunetoContentAlert(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSxmAudioTunetoContentAlert();
    return true;
}
#endif
void Action_acSxmAudioTunetoContentAlert()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSxmAudioTunetoContentAlert()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmAudioTunetoContentAlertReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmAudioCloseContentAlertPopup(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSxmAudioCloseContentAlertPopup();
    return true;
}
#endif
void Action_acSxmAudioCloseContentAlertPopup()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSxmAudioCloseContentAlertPopup()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmAudioCloseContentAlertPopupReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmAudioChannelLockStatus(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSxmAudioChannelLockStatus();
    return true;
}
#endif
void Action_acSxmAudioChannelLockStatus()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSxmAudioChannelLockStatus()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmChannelLockStatusReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetTpopInfo(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acSetTpopInfo(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acSetTpopInfo(bool const & aIsActive)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSetTpopInfo(aIsActive = %d)", aIsActive));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMTPopUpAudioStateUpdMsg(aIsActive);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmAudioFocusReset(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acSxmAudioFocusReset(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acSxmAudioFocusReset(Courier::UInt32 const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSxmAudioFocusReset(aViewId = %d)", aViewId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmAudioFocusResetReqMsg(aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMInfoUpdatedatabinding(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSXMInfoUpdatedatabinding();
    return true;
}
#endif
void Action_acSXMInfoUpdatedatabinding()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMInfoUpdatedatabinding()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSXMInfoUpdatedatabindingReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmDTMTestModeMonitorSel(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acSxmDTMTestModeMonitorSel(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acSxmDTMTestModeMonitorSel(bool const & aStartMonitor)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSxmDTMTestModeMonitorSel(aStartMonitor = %d)", aStartMonitor));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmDTMTestModeMonitorSelReqMsg(aStartMonitor);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSxmWaitSyncCancelled(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSxmWaitSyncCancelled();
    return true;
}
#endif
void Action_acSxmWaitSyncCancelled()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSxmWaitSyncCancelled()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmWaitSyncCancelledMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSXMFooterListIdReqMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acSXMFooterListIdReqMsg(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acSXMFooterListIdReqMsg(Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSXMFooterListIdReqMsg(aListId = %d)", aListId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSxmFooterListIdReqMsg(aListId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Notify_Init_Finished(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Notify_Init_Finished();
    return true;
}
#endif
void Action_Notify_Init_Finished()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action Notify_Init_Finished()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendGuiStartupFinishedUpdMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacChangeLanguageReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacChangeLanguageReq(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacChangeLanguageReq(enLanguageId const & aLanguageId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacChangeLanguageReq(aLanguageId = ?enLanguageId?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeLanguageReqMsg(aLanguageId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideFocusInViewReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacHideFocusInViewReq(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacHideFocusInViewReq(::Courier::ViewId const & aView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacHideFocusInViewReq(aView = %50s)", aView.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFocusReqMsg(FOCUS_HIDE, FOCUS_TIMER_NO_ACTION, aView, Candera::String());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_NextLevelTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_NextLevelTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_NextLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action NextLevelTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PreviousLevelTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_PreviousLevelTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_PreviousLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action PreviousLevelTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_DualViewLeftTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_DualViewLeftTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_DualViewLeftTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action DualViewLeftTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_DualViewRightTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_DualViewRightTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_DualViewRightTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action DualViewRightTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PageFlipBackTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_PageFlipBackTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_PageFlipBackTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action PageFlipBackTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PageFlipFrontTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_PageFlipFrontTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_PageFlipFrontTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action PageFlipFrontTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ZoomInTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt() && parameters[(::Json::Value::UInt)2].isInt())) { return false; }
    Action_ZoomInTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt(), parameters[(::Json::Value::UInt)2].asInt());
    return true;
}
#endif
void Action_ZoomInTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action ZoomInTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?, aPos = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, aPos);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ZoomOutTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt() && parameters[(::Json::Value::UInt)2].isInt())) { return false; }
    Action_ZoomOutTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt(), parameters[(::Json::Value::UInt)2].asInt());
    return true;
}
#endif
void Action_ZoomOutTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action ZoomOutTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?, aPos = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, aPos);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_FadeTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_FadeTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_FadeTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action FadeTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStartReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacWaitAnimationStartReq();
    return true;
}
#endif
void Action_gacWaitAnimationStartReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacWaitAnimationStartReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAnimationReqMsg(Courier::AnimationAction::Start, ::Courier::ViewId(), Courier::CompositePath(), ::Courier::ItemId("Global#Animations#WAIT_ANIMATION"), Courier::AnimationProperties());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acFocusOnRightEncoderReqUpd(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acFocusOnRightEncoderReqUpd(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acFocusOnRightEncoderReqUpd(bool const & aIsFocusUsed)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acFocusOnRightEncoderReqUpd(aIsFocusUsed = %d)", aIsFocusUsed));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFocusOnRightEncoderReqUpdMsg(aIsFocusUsed);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetGadgetSceenActiveStatus(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acSetGadgetSceenActiveStatus(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acSetGadgetSceenActiveStatus(bool const & aIsGadgetAtive)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acSetGadgetSceenActiveStatus(aIsGadgetAtive = %d)", aIsGadgetAtive));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStoreActiveGadgetReqMsg(aIsGadgetAtive);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acHKNotificationMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_acHKNotificationMsg(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_acHKNotificationMsg(Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acHKNotificationMsg(aHKCode = %d, aHKState = %d)", aHKCode,aHKState));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendHardKeyPressNotificationMsg(1, aHKCode, aHKState);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseAllDropdowns(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acPerform_CloseAllDropdowns();
    return true;
}
#endif
void Action_acPerform_CloseAllDropdowns()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acPerform_CloseAllDropdowns()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeClose, 0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseDropdown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acPerform_CloseDropdown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acPerform_CloseDropdown(::Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acPerform_CloseDropdown(aListId = ?::Courier::UInt32?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeClose, aListId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_OpenDropdown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acPerform_OpenDropdown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acPerform_OpenDropdown(::Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acPerform_OpenDropdown(aListId = ?::Courier::UInt32?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeOpen, aListId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_ToggleDropdown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acPerform_ToggleDropdown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acPerform_ToggleDropdown(::Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acPerform_ToggleDropdown(aListId = ?::Courier::UInt32?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeToggle, aListId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acStartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_acStartAppPopupTimer(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_acStartAppPopupTimer(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acStartAppPopupTimer(aViewId = %d, aTimeout = %d)", aViewId,aTimeout));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStartPopupTimerReqMsg(aViewId, aTimeout);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acStopAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acStopAppPopupTimer(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acStopAppPopupTimer(Courier::UInt32 const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acStopAppPopupTimer(aViewId = %d)", aViewId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStopPopupTimerReqMsg(aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPostBeep(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_acPostBeep(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_acPostBeep(Courier::Int32 const & aBeepType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acPostBeep(aBeepType = %d)", aBeepType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPlayBeepReqMsg(aBeepType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacCheckToClosePopup(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacCheckToClosePopup(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacCheckToClosePopup(Courier::UInt32 const & aPopupId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacCheckToClosePopup(aPopupId = %d)", aPopupId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCheckToClosePopupMsg(aPopupId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acRestartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acRestartAppPopupTimer(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acRestartAppPopupTimer(Courier::UInt32 const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action acRestartAppPopupTimer(aViewId = %d)", aViewId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRestartPopupTimerReqMsg(aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchBackRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchBackRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchBackRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacContextSwitchBackRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_BACK);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchCompleteRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchCompleteRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchCompleteRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacContextSwitchCompleteRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_COMPLETE);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchFailedRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchFailedRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchFailedRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacContextSwitchFailedRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_FAILED);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchDoneRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchDoneRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchDoneRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacContextSwitchDoneRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_DONE);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchOutReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt())) { return false; }
    Action_gacContextSwitchOutReq(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt(), parameters[(::Json::Value::UInt)2].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchOutReq(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacContextSwitchOutReq(aTargetContextId = %d, aSourceContextId = %d, aTargetAppId = %d)", aTargetContextId,aSourceContextId,aTargetAppId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchOutReqMsg(aTargetContextId, aSourceContextId, aTargetAppId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacCurrentScreenDisplayReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacCurrentScreenDisplayReq();
    return true;
}
#endif
void Action_gacCurrentScreenDisplayReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacCurrentScreenDisplayReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCurrentScreenDisplayReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacLaunchBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_gacLaunchBarDisplayReq(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_gacLaunchBarDisplayReq(bool const & aVisibility)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacLaunchBarDisplayReq(aVisibility = %d)", aVisibility));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendLaunchBarDisplayReqMsg(aVisibility);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacNavTBTSwipe(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacNavTBTSwipe();
    return true;
}
#endif
void Action_gacNavTBTSwipe()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacNavTBTSwipe()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendNavTBTSwipeReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListBtnRightEncoderChangeUpd(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 4) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt() && parameters[(::Json::Value::UInt)3].isUInt())) { return false; }
    Action_gacPerformListBtnRightEncoderChangeUpd(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt(), parameters[(::Json::Value::UInt)2].asUInt(), parameters[(::Json::Value::UInt)3].asUInt());
    return true;
}
#endif
void Action_gacPerformListBtnRightEncoderChangeUpd(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacPerformListBtnRightEncoderChangeUpd(aSteps = %d, aListId = %d, aRowId = %d, aColumnId = %d)", aSteps,aListId,aRowId,aColumnId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListItemRightEncoderChangeUpdMsg(aSteps, aListId, aRowId, aColumnId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListUp(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollListUp();
    return true;
}
#endif
void Action_gacScrollListUp()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacScrollListUp()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangeUp, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListDown(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollListDown();
    return true;
}
#endif
void Action_gacScrollListDown()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacScrollListDown()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangeDown, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageUp(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollPageUp();
    return true;
}
#endif
void Action_gacScrollPageUp()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacScrollPageUp()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangePageUp, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageDown(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollPageDown();
    return true;
}
#endif
void Action_gacScrollPageDown()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacScrollPageDown()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangePageDown, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusUp(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacScrollListFocusUp(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacScrollListFocusUp(Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacScrollListFocusUp(aListId = %d)", aListId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListFocusScrollReqMsg(aListId, -1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusDown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacScrollListFocusDown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacScrollListFocusDown(Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacScrollListFocusDown(aListId = %d)", aListId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListFocusScrollReqMsg(aListId, 1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListFocusLockDataResetUpd(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacPerformListFocusLockDataResetUpd();
    return true;
}
#endif
void Action_gacPerformListFocusLockDataResetUpd()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacPerformListFocusLockDataResetUpd()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListFocusLockDataResetReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSetApplicationMode(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacSetApplicationMode(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacSetApplicationMode(Courier::UInt32 const & aModeId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacSetApplicationMode(aModeId = %d)", aModeId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSetApplicationModeReqMsg(aModeId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSpellerBbehaviorReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_gacSpellerBbehaviorReq(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_gacSpellerBbehaviorReq(bool const & aEnable)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacSpellerBbehaviorReq(aEnable = %d)", aEnable));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSpellerBbehaviorReqMsg(aEnable);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacStatusBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_gacStatusBarDisplayReq(parameters[(::Json::Value::UInt)0].asBool(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_gacStatusBarDisplayReq(bool const & aVisibility, Courier::Int32 const & aHeaderType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacStatusBarDisplayReq(aVisibility = %d, aHeaderType = %d)", aVisibility,aHeaderType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStatusBarDisplayReqMsg(aVisibility, aHeaderType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacTBTRetriggerAcousticOutput(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacTBTRetriggerAcousticOutput();
    return true;
}
#endif
void Action_gacTBTRetriggerAcousticOutput()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacTBTRetriggerAcousticOutput()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTBTRetriggerAcousticMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStopReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacWaitAnimationStopReq();
    return true;
}
#endif
void Action_gacWaitAnimationStopReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacWaitAnimationStopReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAnimationReqMsg(Courier::AnimationAction::Stop, ::Courier::ViewId(), Courier::CompositePath(), ::Courier::ItemId("Global#Animations#WAIT_ANIMATION"), Courier::AnimationProperties());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateReq(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacViewCreateReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Create, aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAllReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateAllReq(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateAllReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacViewCreateAllReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::CreateAll, aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewDestroyReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewDestroyReq(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewDestroyReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacViewDestroyReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Destroy, aViewId, false, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewClearReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewClearReq(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewClearReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacViewClearReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Clear, aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewShowReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewShowReq(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewShowReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacViewShowReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivationReqMsg(aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewHideReq(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewHideReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacViewHideReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivationReqMsg(aViewId, false, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateWithoutLoadReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateWithoutLoadReq(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateWithoutLoadReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacViewCreateWithoutLoadReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Create, aViewId, false, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewAsyncLoadReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewAsyncLoadReq(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewAsyncLoadReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacViewAsyncLoadReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAsyncLoadReqMsg(aViewId, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewActivateWithoutRenderingReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacViewActivateWithoutRenderingReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivationReqMsg(aViewId, true, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupCreateAndSBShowReq(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacPopupCreateAndSBShowReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacPopupCreateAndSBShowReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Show, aViewId, hmibase::DEFAULT_UNKNOWN_DISPLAY);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupCreateAndSBShowReqForMultiDisplay(parameters[(::Json::Value::UInt)0].asUInt(), ::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt())));
    return true;
}
#endif
void Action_gacPopupCreateAndSBShowReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacPopupCreateAndSBShowReqForMultiDisplay(aPopupDisplayID = %d, aViewId = %50s)", aPopupDisplayID,aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Show, aViewId, aPopupDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupSBCloseReq(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacPopupSBCloseReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacPopupSBCloseReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Hide, aViewId, hmibase::DEFAULT_UNKNOWN_DISPLAY);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupSBCloseReqForMultiDisplay(parameters[(::Json::Value::UInt)0].asUInt(), ::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt())));
    return true;
}
#endif
void Action_gacPopupSBCloseReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacPopupSBCloseReqForMultiDisplay(aPopupDisplayID = %d, aViewId = %50s)", aPopupDisplayID,aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Hide, aViewId, aPopupDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupRestartTimerReq(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacPopupRestartTimerReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacPopupRestartTimerReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::RestartTimer, aViewId, hmibase::DEFAULT_UNKNOWN_DISPLAY);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupRestartTimerReqForMultiDisplay(parameters[(::Json::Value::UInt)0].asUInt(), ::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt())));
    return true;
}
#endif
void Action_gacPopupRestartTimerReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacPopupRestartTimerReqForMultiDisplay(aPopupDisplayID = %d, aViewId = %50s)", aPopupDisplayID,aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::RestartTimer, aViewId, aPopupDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAndShowReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateAndShowReq(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateAndShowReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacViewCreateAndShowReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::CreateAndShow, aViewId, 0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideAndDestroyReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewHideAndDestroyReq(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewHideAndDestroyReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacViewHideAndDestroyReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::HideAndDestroy, aViewId, 0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionEnter(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacSceneTransitionEnter(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt(), ))parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacSceneTransitionEnter(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacSceneTransitionEnter(aViewId = %50s, aHint = %d)", aViewId.CStr(),aHint));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::TransitionEnter, aViewId, aHint);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionLeave(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacSceneTransitionLeave(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt(), ))parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacSceneTransitionLeave(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacSceneTransitionLeave(aViewId = %50s, aHint = %d)", aViewId.CStr(),aHint));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::TransitionLeave, aViewId, aHint);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacDisplayStatusLineReq(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacDisplayStatusLineReq(Courier::Int32 const & aDisplayRegionType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacDisplayStatusLineReq(aDisplayRegionType = %d)", aDisplayRegionType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, true, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacHideStatusLineReq(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacHideStatusLineReq(Courier::Int32 const & aDisplayRegionType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacHideStatusLineReq(aDisplayRegionType = %d)", aDisplayRegionType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, false, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacDisplayFooterLineReq();
    return true;
}
#endif
void Action_gacDisplayFooterLineReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacDisplayFooterLineReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, Courier::Int32(), true, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacHideFooterLineReq();
    return true;
}
#endif
void Action_gacHideFooterLineReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacHideFooterLineReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, Courier::Int32(), false, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacDisplayStatusLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacDisplayStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacDisplayStatusLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, true, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacHideStatusLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacHideStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacHideStatusLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, false, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacDisplayFooterLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacDisplayFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacDisplayFooterLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, aDisplayRegionType, true, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacHideFooterLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacHideFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacHideFooterLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, aDisplayRegionType, false, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacRegisterForCloseOnTouchSession(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacRegisterForCloseOnTouchSession(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRegisterForCloseOnTouchSessionReqMsg(true, aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDeregisterForCloseOnTouchSessionReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacDeregisterForCloseOnTouchSessionReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRegisterForCloseOnTouchSessionReqMsg(false, aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupFilterPrioEnableReq(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterPrioEnableReq(Courier::UInt32 const & aPrio)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacPopupFilterPrioEnableReq(aPrio = %d)", aPrio));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupFilterPrioEnableReqMsg(aPrio);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacPopupFilterAllEnableReq();
    return true;
}
#endif
void Action_gacPopupFilterAllEnableReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacPopupFilterAllEnableReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupFilterAllEnableReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacPopupFilterDisableReq();
    return true;
}
#endif
void Action_gacPopupFilterDisableReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacPopupFilterDisableReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupFilterDisableReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacProfileChange(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacProfileChange(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacProfileChange(Courier::UInt32 const & aProfile)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacProfileChange(aProfile = %d)", aProfile));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendProfileSwitchMsg(aProfile);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupFilterPrioEnableReqForDisplay(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterPrioEnableReqForDisplay(Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacPopupFilterPrioEnableReqForDisplay(aPrio = %d, aDisplayID = %d)", aPrio,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMultiDisplayPopupFilterReqMsg(hmibase::ENABLE_PRIO, aPrio, aDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupFilterAllEnableReqForDisplay(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterAllEnableReqForDisplay(Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacPopupFilterAllEnableReqForDisplay(aDisplayID = %d)", aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMultiDisplayPopupFilterReqMsg(hmibase::ENABLE_ALL, 0, aDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupFilterDisableReqForDisplay(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterDisableReqForDisplay(Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacPopupFilterDisableReqForDisplay(aDisplayID = %d)", aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMultiDisplayPopupFilterReqMsg(hmibase::DISABLE_ALL, 0, aDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacStartSceneTransitionAnimation(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 4) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt() && parameters[(::Json::Value::UInt)3].isInt())) { return false; }
    Action_gacStartSceneTransitionAnimation(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt(), ))::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt(), ))parameters[(::Json::Value::UInt)2].asUInt(), parameters[(::Json::Value::UInt)3].asInt());
    return true;
}
#endif
void Action_gacStartSceneTransitionAnimation(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacStartSceneTransitionAnimation(aSourceView = %50s, aDestinationView = %50s, aUserData1 = %d, aUserData2 = %d)", aSourceView.CStr(),aDestinationView.CStr(),aUserData1,aUserData2));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCreateNewDestroyOld(aSourceView, aDestinationView, aUserData1, aUserData2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDecrementActiveAnimationCount(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacDecrementActiveAnimationCount();
    return true;
}
#endif
void Action_gacDecrementActiveAnimationCount()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_SXM_SM, "SM_ACTIONS:    Trigger action gacDecrementActiveAnimationCount()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendNotifierMessage();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacGetDataServiceStatus(const ::Json::Value& parameters, ::Json::Value &response)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    response["result"] = (::Json::Value::UInt)gacGetDataServiceStatus((::FeatStd::UInt8)parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_dgSxmAudioScanStatus(const ::Json::Value& /* parameters */, ::Json::Value &response)
{
    response["result"] = (bool)Action_dgSxmAudioScanStatus();
    return true;
}
#endif
bool Action_dgSxmAudioScanStatus()
{
    const bool* dataItem = ::Courier::Internal::AsyncGenericModelBindingSource::GetDataItemValue< const bool >(
        ::Courier::ComponentId(::Courier::ComponentType::Controller),
        ItemKey::SxmAudioScan::ScanOnItem);
    return (dataItem == 0) ? bool() : (bool)*dataItem;
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_dgSxmPopupVisible(const ::Json::Value& /* parameters */, ::Json::Value &response)
{
    response["result"] = (bool)Action_dgSxmPopupVisible();
    return true;
}
#endif
bool Action_dgSxmPopupVisible()
{
    const bool* dataItem = ::Courier::Internal::AsyncGenericModelBindingSource::GetDataItemValue< const bool >(
        ::Courier::ComponentId(::Courier::ComponentType::Controller),
        ItemKey::SxmPopupInfo::PopupVisibleItem);
    return (dataItem == 0) ? bool() : (bool)*dataItem;
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_dgSxmApplicationState(const ::Json::Value& /* parameters */, ::Json::Value &response)
{
    response["result"] = (bool)Action_dgSxmApplicationState();
    return true;
}
#endif
bool Action_dgSxmApplicationState()
{
    const bool* dataItem = ::Courier::Internal::AsyncGenericModelBindingSource::GetDataItemValue< const bool >(
        ::Courier::ComponentId(::Courier::ComponentType::Controller),
        ItemKey::SxmApplicationState::StateItem);
    return (dataItem == 0) ? bool() : (bool)*dataItem;
}
//====  defines and includes TTFis output - added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====    

unsigned short AppHmi_SxmStateMachineImpl::GetTraceClass (){  
   return TR_CLASS_APPHMI_SXM_SM; 
}

//====  member function with TTFis output - end                        key: SM_TTFis_SBHFMSRF ==== 

#include "hmibase/util/Macros.h"

#ifdef CIT_SIMULATION
#define CIT_EVENT_ID(eventId, hashId) hashId
#else
#define CIT_EVENT_ID(eventId, hashId) eventId
#endif
// ------------------------------------------------------------------------
static bool HandleEventMappingForButtonReactionMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::ButtonReactionMsg const & message = static_cast< ::ButtonReactionMsg const &>(aMessage);

#ifdef onSxmSourcePressOnMainScreen
    if ((message.GetSender() == ::Courier::Identifier(0x9fc20a11 /* Btn_SxmSource/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmSourcePressOnMainScreen, 0x325146D5); return true; }
#endif
#ifdef onSxmAudioScanAudioPlay
    if ((message.GetSender() == ::Courier::Identifier(0x086d4b57 /* Btn_Scan_SxmAudioPlay/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmAudioScanAudioPlay, 0x443FE03A); return true; }
#endif
#ifdef onSxmAudioScanSkipBackward
    if ((message.GetSender() == ::Courier::Identifier(0x939ffe70 /* Btn_Scan_SkipBackward/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmAudioScanSkipBackward, 0x7D001AC0); return true; }
#endif
#ifdef onSXMAudioScanAbort
    if ((message.GetSender() == ::Courier::Identifier(0x97cf3316 /* Btn_SxmAudioScanAbort/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSXMAudioScanAbort, 0xD592F317); return true; }
#endif
#ifdef onSXMAudiodeleteFavoriteItem
    if ((message.GetSender() == ::Courier::Identifier(0x911abab0 /* Btn_DeleteAll/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSXMAudiodeleteFavoriteItem, 0x0D401A9E); return true; }
#endif
#ifdef onSXMAudioFavtSportsHistory
    if ((message.GetSender() == ::Courier::Identifier(0xea646805 /* Layer_Favorite FlashHistory/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSXMAudioFavtSportsHistory, 0xCC701628); return true; }
#endif
#ifdef onSXMAudioTurnAlertOff
    if ((message.GetSender() == ::Courier::Identifier(0x5b8ac3d9 /* Btn_TurnAlertOff/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSXMAudioTurnAlertOff, 0x27BF5640); return true; }
#endif
#ifdef onSxmAudioScanFastForward
    if ((message.GetSender() == ::Courier::Identifier(0xc43b8a31 /* Btn_Scan_FastForward/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmAudioScanFastForward, 0xD22B1A3E); return true; }
#endif
#ifdef onSXMAudioTurnAlertOn
    if ((message.GetSender() == ::Courier::Identifier(0x32195436 /* Btn_TurnAlertOn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSXMAudioTurnAlertOn, 0x568D1296); return true; }
#endif
#ifdef onSXMAudioFavtSongHistory
    if ((message.GetSender() == ::Courier::Identifier(0x1a1dedcc /* Layer_Favorite Song/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSXMAudioFavtSongHistory, 0x0DDB04BB); return true; }
#endif
#ifdef onSXMAudioFavtSongNotifyAllOff
    if ((message.GetSender() == ::Courier::Identifier(0x77304da4 /* Btn_SongNotifyAlertAllOFF/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSXMAudioFavtSongNotifyAllOff, 0x537A4F7B); return true; }
#endif
#ifdef onSXMAudioFavtSongNotifyAllOn
    if ((message.GetSender() == ::Courier::Identifier(0x24b732e8 /* Btn_SongNotifyAlertAllON/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSXMAudioFavtSongNotifyAllOn, 0xAE2F3F1D); return true; }
#endif
#ifdef onSXMAudioFavtArtistHistory
    if ((message.GetSender() == ::Courier::Identifier(0xecef5a42 /* Layer_Favorite Artists/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSXMAudioFavtArtistHistory, 0x9D9A7C6D); return true; }
#endif
#ifdef onSXMAudioFavtArtistNotifyAllOff
    if ((message.GetSender() == ::Courier::Identifier(0xf3f0b1eb /* Btn_ArtistNotifyAlertAllOFF/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSXMAudioFavtArtistNotifyAllOff, 0xDBE7D83F); return true; }
#endif
#ifdef onSXMAudioFavtArtistNotifyAllOn
    if ((message.GetSender() == ::Courier::Identifier(0x57d32820 /* Btn_ArtistNotifyAlertAllON/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSXMAudioFavtArtistNotifyAllOn, 0x9894E1D3); return true; }
#endif
#ifdef onSXMAudioSFAddTeam
    if ((message.GetSender() == ::Courier::Identifier(0x756938b2 /* Btn_AddTeam/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSXMAudioSFAddTeam, 0x1D2B6F14); return true; }
#endif
#ifdef onSxmAudioScan
    if ((message.GetSender() == ::Courier::Identifier(0xeca0ddd3 /* Btn_SxmScan/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmAudioScan, 0xA13F5476); return true; }
#endif
#ifdef onSxmAudioNowPlaying
    if ((message.GetSender() == ::Courier::Identifier(0x542acac1 /* BtnNowPlaying/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmAudioNowPlaying, 0x4016CCEE); return true; }
#endif
#ifdef onSxmSFGray
    if ((message.GetSender() == ::Courier::Identifier(0x50b20dd6 /* Btn_SFGrey/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmSFGray, 0x1ECBEC91); return true; }
#endif
#ifdef onSxmSceneButtonCancel
    if ((message.GetSender() == ::Courier::Identifier(0x01b94b35 /* Btn_SceneCancel/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmSceneButtonCancel, 0x65F4D6C9); return true; }
#endif
#ifdef onSxmPopupButtonCancel
    if ((message.GetSender() == ::Courier::Identifier(0x23e07431 /* Btn_PopupCancel/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmPopupButtonCancel, 0x68873B1A); return true; }
#endif
#ifdef onSxmInfoPopupOK
    if ((message.GetSender() == ::Courier::Identifier(0x7ffc9645 /* Btn_SxmInfoOk/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmInfoPopupOK, 0x90EA0B7F); return true; }
#endif
#ifdef onSxmInfoSubscribe
    if ((message.GetSender() == ::Courier::Identifier(0x320e2c35 /* Btn_SxmInfoSubscribe/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmInfoSubscribe, 0x87197D86); return true; }
#endif
#ifdef onSXMAudioGadgetTransparent
    if ((message.GetSender() == ::Courier::Identifier(0x4087bb7c /* Btn_SXMTransparent/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSXMAudioGadgetTransparent, 0xB5E41E72); return true; }
#endif
#ifdef onSXMAudioAlertFavtTune
    if ((message.GetSender() == ::Courier::Identifier(0x9739cb99 /* Btn_Tune/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSXMAudioAlertFavtTune, 0x023426EC); return true; }
#endif
#ifdef onSxmTWNRed
    if ((message.GetSender() == ::Courier::Identifier(0x971bd0ea /* Btn_TwnRed/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmTWNRed, 0x9970F882); return true; }
#endif
#ifdef onSxmTWNWhite
    if ((message.GetSender() == ::Courier::Identifier(0xd3e3a09d /* Btn_TwnWhite/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmTWNWhite, 0x29E74C6E); return true; }
#endif
#ifdef onSxmTWNGreen
    if ((message.GetSender() == ::Courier::Identifier(0x5682ef91 /* Btn_TwnGreen/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmTWNGreen, 0x5B86652E); return true; }
#endif
#ifdef onSxmTWNGray
    if ((message.GetSender() == ::Courier::Identifier(0x04dcbc87 /* Btn_TwnGray/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmTWNGray, 0x03FFE536); return true; }
#endif
#ifdef onSxmSFReturn
    if ((message.GetSender() == ::Courier::Identifier(0xedacee93 /* Btn_SFReturn/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmSFReturn, 0x21FE62B3); return true; }
#endif
#ifdef onSxmSFTune
    if ((message.GetSender() == ::Courier::Identifier(0xbee00476 /* Btn_SFTune/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmSFTune, 0x644191E2); return true; }
#endif
#ifdef onSxmSFRed
    if ((message.GetSender() == ::Courier::Identifier(0xdc419e02 /* Btn_SFRed/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmSFRed, 0x7C8E80B9); return true; }
#endif
#ifdef onSxmSFGreen
    if ((message.GetSender() == ::Courier::Identifier(0xf3cd1110 /* Btn_SFGreen/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmSFGreen, 0xE7945364); return true; }
#endif
#ifdef onSxmSFWhite
    if ((message.GetSender() == ::Courier::Identifier(0xb3eb0d61 /* Btn_SFWhite/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmSFWhite, 0xFF554537); return true; }
#endif
#ifdef onSXMAudioCustomizeSelectAll
    if ((message.GetSender() == ::Courier::Identifier(0x0e44a66d /* Btn_SelectAll/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSXMAudioCustomizeSelectAll, 0xE7F18622); return true; }
#endif
#ifdef onSXMAudioCustomizeClearAll
    if ((message.GetSender() == ::Courier::Identifier(0x9535d407 /* Btn_ClearAll/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSXMAudioCustomizeClearAll, 0x39E920C5); return true; }
#endif
#ifdef onSXMAudioDirectTuneOk
    if ((message.GetSender() == ::Courier::Identifier(0x07fbf2d9 /* Btn_DirectTuneOk/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSXMAudioDirectTuneOk, 0xCECDE44B); return true; }
#endif
#ifdef onSXMAudioMenuDirectTune
    if ((message.GetSender() == ::Courier::Identifier(0x35412eed /* Btn_DirectTune/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSXMAudioMenuDirectTune, 0x135A2E87); return true; }
#endif
#ifdef onSxmAudioMenu
    if ((message.GetSender() == ::Courier::Identifier(0x5dd7f421 /* Btn_SxmAudioMenu/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmAudioMenu, 0xE14366AD); return true; }
#endif
#ifdef onSxmAudioChangePresetBankRight
    if ((message.GetSender() == ::Courier::Identifier(0x7b9eeb41 /* Btn_ListRight/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmAudioChangePresetBankRight, 0x3C45D5DC); return true; }
#endif
#ifdef onSxmAudioChangePresetBankLeft
    if ((message.GetSender() == ::Courier::Identifier(0xa1a95f13 /* Btn_ListLeft/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmAudioChangePresetBankLeft, 0xF21D1BCF); return true; }
#endif
#ifdef onSxmTab4Selection
    if ((message.GetSender() == ::Courier::Identifier(0x8ef86d29 /* Btn_Tab4/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmTab4Selection, 0x1F757021); return true; }
#endif
#ifdef onSxmTab3BtnCondensedSelection
    if ((message.GetSender() == ::Courier::Identifier(0x4424de05 /* Btn_Tab3Condensed/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmTab3BtnCondensedSelection, 0xB9AF50E2); return true; }
#endif
#ifdef onSxmTab3Selection
    if ((message.GetSender() == ::Courier::Identifier(0x052d6ff5 /* Btn_Tab3/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmTab3Selection, 0x48BD2620); return true; }
#endif
#ifdef onSxmTab2Selection
    if ((message.GetSender() == ::Courier::Identifier(0x7d6ffa92 /* Btn_Tab2/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmTab2Selection, 0x7B58F48F); return true; }
#endif
#ifdef onSxmTab1Selection
    if ((message.GetSender() == ::Courier::Identifier(0xce10667c /* Btn_Tab1/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmTab1Selection, 0xBD62D658); return true; }
#endif
#ifdef onPopupTouch2Line
    if ((message.GetSender() == ::Courier::Identifier(0x4cc74ab0 /* Button_PopupTouch2line/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onPopupTouch2Line, 0xF67F4B82); return true; }
#endif
#ifdef onSxmSourceLongPressOnMainScreen
    if ((message.GetSender() == ::Courier::Identifier(0x9fc20a11 /* Btn_SxmSource/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(onSxmSourceLongPressOnMainScreen, 0x689D5812); return true; }
#endif
#ifdef onSxmBackPressOnSxmDTMMain
    if ((message.GetSender() == ::Courier::Identifier(0x59199552 /* Btn_SxmDTMMain/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmBackPressOnSxmDTMMain, 0x6B07AAC6); return true; }
#endif
#ifdef onSxmBackPressOnTestModeMonitor
    if ((message.GetSender() == ::Courier::Identifier(0x49e95f8c /* Btn_SxmTestModeMonitor/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmBackPressOnTestModeMonitor, 0xDCD6A4C5); return true; }
#endif
#ifdef onSxmGadgetTouchArea
    if ((message.GetSender() == ::Courier::Identifier(0x1d96572a /* BtnToucharea_AlbumInfo/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmGadgetTouchArea, 0x86C462E2); return true; }
#endif
#ifdef onSxmSourcePressOnToggle
    if ((message.GetSender() == ::Courier::Identifier(0x07716648 /* Btn_Sxm/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmSourcePressOnToggle, 0xF7A4EE9D); return true; }
#endif
#ifdef onSxmSourcePressOnHomeScreen
    if ((message.GetSender() == ::Courier::Identifier(0x7c79e5ed /* HomeBtn_Sxm/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmSourcePressOnHomeScreen, 0x1D29D9BD); return true; }
#endif
#ifdef onSxmAudioBack
    if ((message.GetSender() == ::Courier::Identifier(0x711995cd /* Btn_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmAudioBack, 0x29FF999C); return true; }
#endif
#ifdef onSxmAudioGadgetNextChannel
    if ((message.GetSender() == ::Courier::Identifier(0x3b0da4f7 /* Btn_Next/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmAudioGadgetNextChannel, 0xEBFF91BA); return true; }
#endif
#ifdef onSxmAudioPresetOn
    if ((message.GetSender() == ::Courier::Identifier(0xab5593fd /* Btn_SxmPreset/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmAudioPresetOn, 0x5E3FF1B3); return true; }
#endif
#ifdef onSxmAudioSkipBackward
    if ((message.GetSender() == ::Courier::Identifier(0xe44b215b /* Btn_SkipBackward/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmAudioSkipBackward, 0x556F43FB); return true; }
#endif
#ifdef onSXMAudioMenuSaveSong
    if ((message.GetSender() == ::Courier::Identifier(0x8213cb8a /* Btn_SaveSong/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSXMAudioMenuSaveSong, 0x65EC1804); return true; }
#endif
#ifdef onSXMAudioMenuFavorite
    if ((message.GetSender() == ::Courier::Identifier(0x19490ee7 /* Btn_FavoriteList/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSXMAudioMenuFavorite, 0x586354D8); return true; }
#endif
#ifdef onSXMAudioMenuCategories
    if ((message.GetSender() == ::Courier::Identifier(0x9615ca37 /* Btn_CategoryList/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSXMAudioMenuCategories, 0xA5159580); return true; }
#endif
#ifdef onSXMAudioMenuSaveArtist
    if ((message.GetSender() == ::Courier::Identifier(0xa14f3612 /* Btn_SaveArtist/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSXMAudioMenuSaveArtist, 0x522B4B36); return true; }
#endif
#ifdef onSXMAudioMenuChannelList
    if ((message.GetSender() == ::Courier::Identifier(0x37ad0ac6 /* Btn_ChannelList/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSXMAudioMenuChannelList, 0xE798C26F); return true; }
#endif
#ifdef onEvSXMSource
    if ((message.GetSender() == ::Courier::Identifier(0x9fc20a11 /* Btn_SxmSource/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onEvSXMSource, 0xABF88A00); return true; }
#endif
#ifdef onSxmAudioSkipToLive
    if ((message.GetSender() == ::Courier::Identifier(0x1987b435 /* Btn_FastForward/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(onSxmAudioSkipToLive, 0x5AFD0249); return true; }
#endif
#ifdef onSxmAudioForwardStop
    if ((message.GetSender() == ::Courier::Identifier(0x231f0447 /* Btn_Forward/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmAudioForwardStop, 0xC5BB6589); return true; }
#endif
#ifdef onSxmAudioForward
    if ((message.GetSender() == ::Courier::Identifier(0x231f0447 /* Btn_Forward/ButtonWidget */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(onSxmAudioForward, 0x77525206); return true; }
#endif
#ifdef onSxmAudioFastForward
    if ((message.GetSender() == ::Courier::Identifier(0x1987b435 /* Btn_FastForward/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmAudioFastForward, 0xE997283B); return true; }
#endif
#ifdef onSxmAudioPause
    if ((message.GetSender() == ::Courier::Identifier(0xc9e71c28 /* Btn_SxmAudioPause/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmAudioPause, 0xDFD78429); return true; }
#endif
#ifdef onSxmAudioPlay
    if ((message.GetSender() == ::Courier::Identifier(0xbcb3a619 /* Btn_SxmAudioPlay/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmAudioPlay, 0x34ABC619); return true; }
#endif
#ifdef onSxmAudioRewindStop
    if ((message.GetSender() == ::Courier::Identifier(0x3df7cbd9 /* Btn_Rewind/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmAudioRewindStop, 0xF93FDB5D); return true; }
#endif
#ifdef onSxmAudioRewind
    if ((message.GetSender() == ::Courier::Identifier(0x3df7cbd9 /* Btn_Rewind/ButtonWidget */)) && (message.GetEnReaction() == enPress)) { eventId = CIT_EVENT_ID(onSxmAudioRewind, 0x5D610D51); return true; }
#endif
#ifdef onSxmAudioSkipEndOfBuffer
    if ((message.GetSender() == ::Courier::Identifier(0xe44b215b /* Btn_SkipBackward/ButtonWidget */)) && (message.GetEnReaction() == enLongPress)) { eventId = CIT_EVENT_ID(onSxmAudioSkipEndOfBuffer, 0x544C254D); return true; }
#endif
#ifdef onSxmAudioPresetOff
    if ((message.GetSender() == ::Courier::Identifier(0xe2fe0247 /* Btn_SxmControl/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmAudioPresetOff, 0x6381C239); return true; }
#endif
#ifdef onSxmAudioGadgetPrevChannel
    if ((message.GetSender() == ::Courier::Identifier(0x350527b1 /* Btn_Prev/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSxmAudioGadgetPrevChannel, 0xE39AAA61); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForButtonReactionMsg(AppHmi_SxmStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ButtonReactionMsg const & message = static_cast< ::ButtonReactionMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onSxmTopPopupSurfaceInvisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSxmTopPopupSurfaceInvisible 0xffff
#pragma _REMINDER("Using dummy value symbol onSxmTopPopupSurfaceInvisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSxmTopPopupSurfaceInvisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onSxmTopPopupSurfaceVisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSxmTopPopupSurfaceVisible 0xffff
#pragma _REMINDER("Using dummy value symbol onSxmTopPopupSurfaceVisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSxmTopPopupSurfaceVisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onSxmTopPopupSurfaceUnqueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSxmTopPopupSurfaceUnqueued 0xffff
#pragma _REMINDER("Using dummy value symbol onSxmTopPopupSurfaceUnqueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSxmTopPopupSurfaceUnqueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onSxmTopPopupSurfaceQueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSxmTopPopupSurfaceQueued 0xffff
#pragma _REMINDER("Using dummy value symbol onSxmTopPopupSurfaceQueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSxmTopPopupSurfaceQueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onPopupInvisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupInvisible 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupInvisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupInvisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onPopupVisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupVisible 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupVisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupVisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onPopupUnqueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupUnqueued 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupUnqueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupUnqueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onPopupQueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupQueued 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupQueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupQueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForSurfaceStateChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);

#ifdef onSxmTopPopupSurfaceInvisible
    if ((message.GetSurfaceId() == SURFACEID_TOP_POPUP_SURFACE_SXM) && (message.GetState() == SURFACESTATE_INVISIBLE)) { eventId = CIT_EVENT_ID(onSxmTopPopupSurfaceInvisible, 0x6D8C7BFD); return true; }
#endif
#ifdef onSxmTopPopupSurfaceVisible
    if ((message.GetSurfaceId() == SURFACEID_TOP_POPUP_SURFACE_SXM) && (message.GetState() == SURFACESTATE_VISIBLE)) { eventId = CIT_EVENT_ID(onSxmTopPopupSurfaceVisible, 0x2F433643); return true; }
#endif
#ifdef onSxmTopPopupSurfaceUnqueued
    if ((message.GetSurfaceId() == SURFACEID_TOP_POPUP_SURFACE_SXM) && (message.GetState() == SURFACESTATE_UNQUEUED)) { eventId = CIT_EVENT_ID(onSxmTopPopupSurfaceUnqueued, 0x0619E9FB); return true; }
#endif
#ifdef onSxmTopPopupSurfaceQueued
    if ((message.GetSurfaceId() == SURFACEID_TOP_POPUP_SURFACE_SXM) && (message.GetState() == SURFACESTATE_QUEUED)) { eventId = CIT_EVENT_ID(onSxmTopPopupSurfaceQueued, 0x91C30CD4); return true; }
#endif
#ifdef onPopupInvisible
    if ((message.GetState() == SURFACESTATE_INVISIBLE)) { eventId = CIT_EVENT_ID(onPopupInvisible, 0x6C1CD62F); return true; }
#endif
#ifdef onPopupVisible
    if ((message.GetState() == SURFACESTATE_VISIBLE)) { eventId = CIT_EVENT_ID(onPopupVisible, 0xB78D7AE0); return true; }
#endif
#ifdef onPopupUnqueued
    if ((message.GetState() == SURFACESTATE_UNQUEUED)) { eventId = CIT_EVENT_ID(onPopupUnqueued, 0xDB0D29F4); return true; }
#endif
#ifdef onPopupQueued
    if ((message.GetState() == SURFACESTATE_QUEUED)) { eventId = CIT_EVENT_ID(onPopupQueued, 0xBBE6896C); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSurfaceStateChangedUpdMsg(AppHmi_SxmStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
#ifdef onSxmTopPopupSurfaceInvisible
    if (eventId == onSxmTopPopupSurfaceInvisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSxmTopPopupSurfaceInvisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onSxmTopPopupSurfaceVisible
    if (eventId == onSxmTopPopupSurfaceVisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSxmTopPopupSurfaceVisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onSxmTopPopupSurfaceUnqueued
    if (eventId == onSxmTopPopupSurfaceUnqueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSxmTopPopupSurfaceUnqueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onSxmTopPopupSurfaceQueued
    if (eventId == onSxmTopPopupSurfaceQueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSxmTopPopupSurfaceQueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onPopupInvisible
    if (eventId == onPopupInvisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupInvisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onPopupVisible
    if (eventId == onPopupVisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupVisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onPopupUnqueued
    if (eventId == onPopupUnqueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupUnqueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onPopupQueued
    if (eventId == onPopupQueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupQueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onSxmCloseOnTouchReqMsg
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSxmCloseOnTouchReqMsg 0xffff
#pragma _REMINDER("Using dummy value symbol onSxmCloseOnTouchReqMsg ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSxmCloseOnTouchReqMsg -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForCloseOnTouchReqMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onSxmCloseOnTouchReqMsg, 0x99758D01);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForCloseOnTouchReqMsg(AppHmi_SxmStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::CloseOnTouchReqMsg const & message = static_cast< ::CloseOnTouchReqMsg const &>(aMessage);
#ifdef onSxmCloseOnTouchReqMsg
    if (eventId == onSxmCloseOnTouchReqMsg) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSxmCloseOnTouchReqMsg.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onSxmClosePopupOnViewChange
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSxmClosePopupOnViewChange 0xffff
#pragma _REMINDER("Using dummy value symbol onSxmClosePopupOnViewChange ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSxmClosePopupOnViewChange -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForViewResMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onSxmClosePopupOnViewChange, 0x39A7DCE6);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForViewResMsg(AppHmi_SxmStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::Courier::ViewResMsg const & message = static_cast< ::Courier::ViewResMsg const &>(aMessage);
#ifdef onSxmClosePopupOnViewChange
    if (eventId == onSxmClosePopupOnViewChange) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue(), message.GetViewAction()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSxmClosePopupOnViewChange.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        onClickParam.VSEPS_onSxmClosePopupOnViewChange.ViewAction = message.GetViewAction();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onSxmRenderCompleteMsg
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSxmRenderCompleteMsg 0xffff
#pragma _REMINDER("Using dummy value symbol onSxmRenderCompleteMsg ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSxmRenderCompleteMsg -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForSxmRenderCompleteMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onSxmRenderCompleteMsg, 0xB68B1134);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSxmRenderCompleteMsg(AppHmi_SxmStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SxmRenderCompleteMsg const & message = static_cast< ::SxmRenderCompleteMsg const &>(aMessage);
#ifdef onSxmRenderCompleteMsg
    if (eventId == onSxmRenderCompleteMsg) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetViewId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSxmRenderCompleteMsg.ViewId = message.GetViewId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSxmClearContextsMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onSxmClearContexts, 0x3B1917E6);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSxmClearContextsMsg(AppHmi_SxmStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onSXMFooterIsUpdated
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSXMFooterIsUpdated 0xffff
#pragma _REMINDER("Using dummy value symbol onSXMFooterIsUpdated ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSXMFooterIsUpdated -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForSXMFooterIsUpdatedMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onSXMFooterIsUpdated, 0x0DC4753E);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSXMFooterIsUpdatedMsg(AppHmi_SxmStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SXMFooterIsUpdatedMsg const & message = static_cast< ::SXMFooterIsUpdatedMsg const &>(aMessage);
#ifdef onSXMFooterIsUpdated
    if (eventId == onSXMFooterIsUpdated) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetListId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSXMFooterIsUpdated.ListId = message.GetListId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSxmWaitAnimationReqMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::SxmWaitAnimationReqMsg const & message = static_cast< ::SxmWaitAnimationReqMsg const &>(aMessage);

#ifdef onSxmWaitAnimationStart
    if ((message.GetRequestType() == ANIMATION_START)) { eventId = CIT_EVENT_ID(onSxmWaitAnimationStart, 0x289869E9); return true; }
#endif
#ifdef onSxmWaitAnimationStop
    if ((message.GetRequestType() == ANIMATION_STOP)) { eventId = CIT_EVENT_ID(onSxmWaitAnimationStop, 0x6540B6E9); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSxmWaitAnimationReqMsg(AppHmi_SxmStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SxmWaitAnimationReqMsg const & message = static_cast< ::SxmWaitAnimationReqMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onSxmSceneTransition
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSxmSceneTransition 0xffff
#pragma _REMINDER("Using dummy value symbol onSxmSceneTransition ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSxmSceneTransition -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForSxmSceneTransitionReqMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onSxmSceneTransition, 0xED55FB03);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSxmSceneTransitionReqMsg(AppHmi_SxmStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SxmSceneTransitionReqMsg const & message = static_cast< ::SxmSceneTransitionReqMsg const &>(aMessage);
#ifdef onSxmSceneTransition
    if (eventId == onSxmSceneTransition) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetViewID()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSxmSceneTransition.ViewID = message.GetViewID();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onHKStatusChanged_HKAUDIO
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onHKStatusChanged_HKAUDIO 0xffff
#pragma _REMINDER("Using dummy value symbol onHKStatusChanged_HKAUDIO ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onHKStatusChanged_HKAUDIO -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForHKStatusChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::HKStatusChangedUpdMsg const & message = static_cast< ::HKStatusChangedUpdMsg const &>(aMessage);

#ifdef onHKStatusChanged_HK_SELECT_UP
    if ((message.GetHKCode() == HARDKEYCODE_HK_SELECT) && (message.GetHKState() == HARDKEYSTATE_UP)) { eventId = CIT_EVENT_ID(onHKStatusChanged_HK_SELECT_UP, 0x263EAF7F); return true; }
#endif
#ifdef onHKStatusChanged_HKAUDIO
    if ((message.GetHKCode() == HARDKEYCODE_HK_AUDIO)) { eventId = CIT_EVENT_ID(onHKStatusChanged_HKAUDIO, 0x50D2C7EC); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForHKStatusChangedUpdMsg(AppHmi_SxmStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::HKStatusChangedUpdMsg const & message = static_cast< ::HKStatusChangedUpdMsg const &>(aMessage);
#ifdef onHKStatusChanged_HKAUDIO
    if (eventId == onHKStatusChanged_HKAUDIO) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetHKState()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onHKStatusChanged_HKAUDIO.HKState = message.GetHKState();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onSXMListSelection
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSXMListSelection 0xffff
#pragma _REMINDER("Using dummy value symbol onSXMListSelection ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSXMListSelection -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onSXMPresetItemRecall
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSXMPresetItemRecall 0xffff
#pragma _REMINDER("Using dummy value symbol onSXMPresetItemRecall ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSXMPresetItemRecall -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onSXMPresetItemStore
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSXMPresetItemStore 0xffff
#pragma _REMINDER("Using dummy value symbol onSXMPresetItemStore ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSXMPresetItemStore -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForButtonListItemUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);

#ifdef onSXMPresetItemRecall
    if ((message.GetListId() == LIST_ID_SXM_PRESET_BANK) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSXMPresetItemRecall, 0xAD79E27B); return true; }
#endif
#ifdef onSXMPresetItemStore
    if ((message.GetListId() == LIST_ID_SXM_PRESET_BANK) && (message.GetReaction() == enLongPress)) { eventId = CIT_EVENT_ID(onSXMPresetItemStore, 0xE62CB708); return true; }
#endif
#ifdef onSXMListSelection
    if ((message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(onSXMListSelection, 0x881477F5); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForButtonListItemUpdMsg(AppHmi_SxmStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);
#ifdef onSXMListSelection
    if (eventId == onSXMListSelection) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetListId(), message.GetHdl(), message.GetSubHdl()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSXMListSelection.ListId = message.GetListId();
        onClickParam.VSEPS_onSXMListSelection.Hdl = message.GetHdl();
        onClickParam.VSEPS_onSXMListSelection.SubHdl = message.GetSubHdl();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onSXMPresetItemRecall
    if (eventId == onSXMPresetItemRecall) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetHdl(), message.GetSubHdl()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSXMPresetItemRecall.Hdl = message.GetHdl();
        onClickParam.VSEPS_onSXMPresetItemRecall.SubHdl = message.GetSubHdl();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onSXMPresetItemStore
    if (eventId == onSXMPresetItemStore) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetHdl(), message.GetSubHdl()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSXMPresetItemStore.Hdl = message.GetHdl();
        onClickParam.VSEPS_onSXMPresetItemStore.SubHdl = message.GetSubHdl();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onSXMActivatePopUp
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSXMActivatePopUp 0xffff
#pragma _REMINDER("Using dummy value symbol onSXMActivatePopUp ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSXMActivatePopUp -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForSXMActivatePopUpMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onSXMActivatePopUp, 0x1F0F609D);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSXMActivatePopUpMsg(AppHmi_SxmStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SXMActivatePopUpMsg const & message = static_cast< ::SXMActivatePopUpMsg const &>(aMessage);
#ifdef onSXMActivatePopUp
    if (eventId == onSXMActivatePopUp) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetPopUpId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSXMActivatePopUp.PopUpId = message.GetPopUpId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onSXMDeActivatePopUp
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSXMDeActivatePopUp 0xffff
#pragma _REMINDER("Using dummy value symbol onSXMDeActivatePopUp ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSXMDeActivatePopUp -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForSXMDeActivatePopUpMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onSXMDeActivatePopUp, 0x4CD05341);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSXMDeActivatePopUpMsg(AppHmi_SxmStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SXMDeActivatePopUpMsg const & message = static_cast< ::SXMDeActivatePopUpMsg const &>(aMessage);
#ifdef onSXMDeActivatePopUp
    if (eventId == onSXMDeActivatePopUp) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetPopUpId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSXMDeActivatePopUp.PopUpId = message.GetPopUpId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSXMAudioGotoAudioMainMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onSXMAudioGoToAudioMain, 0xBC094CC8);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSXMAudioGotoAudioMainMsg(AppHmi_SxmStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSXMAudioGotoAudioSettingsMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onSXMAudioGoToAudioSettings, 0x6D7FFEED);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSXMAudioGotoAudioSettingsMsg(AppHmi_SxmStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSXMAudioGotoAudioSXMMonitorMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onSXMAudioGoToAudioSXMMonitor, 0xD3281AEE);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSXMAudioGotoAudioSXMMonitorMsg(AppHmi_SxmStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSXMAudioGotoAudioSXMDTMSettingsMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onSXMAudioGoToAudioSXMDTMSettings, 0x64AC0078);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSXMAudioGotoAudioSXMDTMSettingsMsg(AppHmi_SxmStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSxmTWNYesForPopupMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onSxmTWNYesForPopup, 0x175EF1AA);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSxmTWNYesForPopupMsg(AppHmi_SxmStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSxmContextSwitchInfoUpdateMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onSxmContextSwitchInfoUpdate, 0xCDA808F4);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSxmContextSwitchInfoUpdateMsg(AppHmi_SxmStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onSxmLaunchBarActivationResponseUpdMsg
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSxmLaunchBarActivationResponseUpdMsg 0xffff
#pragma _REMINDER("Using dummy value symbol onSxmLaunchBarActivationResponseUpdMsg ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSxmLaunchBarActivationResponseUpdMsg -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForSxmLaunchBarActivationResponseUpdMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onSxmLaunchBarActivationResponseUpdMsg, 0x68E2C8C8);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSxmLaunchBarActivationResponseUpdMsg(AppHmi_SxmStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SxmLaunchBarActivationResponseUpdMsg const & message = static_cast< ::SxmLaunchBarActivationResponseUpdMsg const &>(aMessage);
#ifdef onSxmLaunchBarActivationResponseUpdMsg
    if (eventId == onSxmLaunchBarActivationResponseUpdMsg) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetSurfaceState()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSxmLaunchBarActivationResponseUpdMsg.SurfaceState = message.GetSurfaceState();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onSXMStatusBarActivationResponseUpdMsg
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSXMStatusBarActivationResponseUpdMsg 0xffff
#pragma _REMINDER("Using dummy value symbol onSXMStatusBarActivationResponseUpdMsg ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSXMStatusBarActivationResponseUpdMsg -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForSXMStatusBarActivationResponseUpdMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onSXMStatusBarActivationResponseUpdMsg, 0xB1DEE545);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSXMStatusBarActivationResponseUpdMsg(AppHmi_SxmStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SXMStatusBarActivationResponseUpdMsg const & message = static_cast< ::SXMStatusBarActivationResponseUpdMsg const &>(aMessage);
#ifdef onSXMStatusBarActivationResponseUpdMsg
    if (eventId == onSXMStatusBarActivationResponseUpdMsg) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetSurfaceState()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSXMStatusBarActivationResponseUpdMsg.SurfaceState = message.GetSurfaceState();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSXMActiveTabUpdateMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onSXMActiveTabUpdate, 0x26DA4A8F);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSXMActiveTabUpdateMsg(AppHmi_SxmStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onSXMSwitchToActiveTab
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSXMSwitchToActiveTab 0xffff
#pragma _REMINDER("Using dummy value symbol onSXMSwitchToActiveTab ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSXMSwitchToActiveTab -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForSXMSwitchToActiveTabMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onSXMSwitchToActiveTab, 0x46ECA137);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSXMSwitchToActiveTabMsg(AppHmi_SxmStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SXMSwitchToActiveTabMsg const & message = static_cast< ::SXMSwitchToActiveTabMsg const &>(aMessage);
#ifdef onSXMSwitchToActiveTab
    if (eventId == onSXMSwitchToActiveTab) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetTabIndex()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSXMSwitchToActiveTab.TabIndex = message.GetTabIndex();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onEncoderStatusChanged_RIGHT_ENC
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onEncoderStatusChanged_RIGHT_ENC 0xffff
#pragma _REMINDER("Using dummy value symbol onEncoderStatusChanged_RIGHT_ENC ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onEncoderStatusChanged_RIGHT_ENC -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForEncoderStatusChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::EncoderStatusChangedUpdMsg const & message = static_cast< ::EncoderStatusChangedUpdMsg const &>(aMessage);

#ifdef onEncoderStatusChanged_RIGHT_ENC
    if ((message.GetEncCode() == ENCCODE_RIGHT_ENCODER)) { eventId = CIT_EVENT_ID(onEncoderStatusChanged_RIGHT_ENC, 0x67E5D82B); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForEncoderStatusChangedUpdMsg(AppHmi_SxmStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::EncoderStatusChangedUpdMsg const & message = static_cast< ::EncoderStatusChangedUpdMsg const &>(aMessage);
#ifdef onEncoderStatusChanged_RIGHT_ENC
    if (eventId == onEncoderStatusChanged_RIGHT_ENC) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetEncSteps()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onEncoderStatusChanged_RIGHT_ENC.EncSteps = message.GetEncSteps();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onPopupTimerExpiry
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupTimerExpiry 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupTimerExpiry ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupTimerExpiry -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForExpiredPopupTimerResMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onPopupTimerExpiry, 0xF3C96D17);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForExpiredPopupTimerResMsg(AppHmi_SxmStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ExpiredPopupTimerResMsg const & message = static_cast< ::ExpiredPopupTimerResMsg const &>(aMessage);
#ifdef onPopupTimerExpiry
    if (eventId == onPopupTimerExpiry) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetViewId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupTimerExpiry.ViewId = message.GetViewId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onActivateImageProviderRequest
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onActivateImageProviderRequest 0xffff
#pragma _REMINDER("Using dummy value symbol onActivateImageProviderRequest ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onActivateImageProviderRequest -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onDeactivateImageProviderRequest
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onDeactivateImageProviderRequest 0xffff
#pragma _REMINDER("Using dummy value symbol onDeactivateImageProviderRequest ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onDeactivateImageProviderRequest -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForActivateImageProviderReqMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);

#ifdef onActivateImageProviderRequest
    if ((message.GetActivate() == 1)) { eventId = CIT_EVENT_ID(onActivateImageProviderRequest, 0xDD62EA5B); return true; }
#endif
#ifdef onDeactivateImageProviderRequest
    if ((message.GetActivate() == 0)) { eventId = CIT_EVENT_ID(onDeactivateImageProviderRequest, 0x9FE98C1E); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateImageProviderReqMsg(AppHmi_SxmStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);
#ifdef onActivateImageProviderRequest
    if (eventId == onActivateImageProviderRequest) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetInstanceId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onActivateImageProviderRequest.InstanceId = message.GetInstanceId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onDeactivateImageProviderRequest
    if (eventId == onDeactivateImageProviderRequest) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetInstanceId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onDeactivateImageProviderRequest.InstanceId = message.GetInstanceId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForHMISubStateChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::HMISubStateChangedUpdMsg const & message = static_cast< ::HMISubStateChangedUpdMsg const &>(aMessage);

#ifdef onHMISubStateChanged_ON
    if ((message.GetSubState() == HMISTATE_SHOW_HMI)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_ON, 0x76CF2B88); return true; }
#endif
#ifdef onHMISubStateChanged_CLOCK
    if ((message.GetSubState() == HMISTATE_SHOW_CLOCK)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_CLOCK, 0xF96478DC); return true; }
#endif
#ifdef onHMISubStateChanged_OFF
    if ((message.GetSubState() == HMISTATE_SHOW_OFF)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_OFF, 0x776D7D8A); return true; }
#endif
#ifdef onHMISubStateChanged_STANDBY_RESTRICTED
    if ((message.GetSubState() == HMISTATE_STANDBY_RESTRICTED)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_STANDBY_RESTRICTED, 0xA15C3CEE); return true; }
#endif
#ifdef onHMISubStateChanged_STANDBY
    if ((message.GetSubState() == HMISTATE_STANDBY)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_STANDBY, 0x0D0F5602); return true; }
#endif
#ifdef onHMISubStateChanged_PHONE
    if ((message.GetSubState() == HMISTATE_PHONE)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_PHONE, 0xC8D83B8B); return true; }
#endif
#ifdef onHMISubStateChanged_NO_DISPLAY
    if ((message.GetSubState() == HMISTATE_SHOW_NO_DISPLAY)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_NO_DISPLAY, 0xE4658CFD); return true; }
#endif
#ifdef onHMISubStateChanged_SECURE
    if ((message.GetSubState() == HMISTATE_SECURE)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_SECURE, 0xAB89D7A8); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForHMISubStateChangedUpdMsg(AppHmi_SxmStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::HMISubStateChangedUpdMsg const & message = static_cast< ::HMISubStateChangedUpdMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForApplicationStateUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::ApplicationStateUpdMsg const & message = static_cast< ::ApplicationStateUpdMsg const &>(aMessage);

#ifdef onAppStatusChanged_FOREGROUND
    if ((message.GetState() == hmibase::IN_FOREGROUND)) { eventId = CIT_EVENT_ID(onAppStatusChanged_FOREGROUND, 0xDE9448E3); return true; }
#endif
#ifdef onAppStatusChanged_BACKGROUND
    if ((message.GetState() == hmibase::IN_BACKGROUND)) { eventId = CIT_EVENT_ID(onAppStatusChanged_BACKGROUND, 0x6D1B3A68); return true; }
#endif
#ifdef onAppStatusPrepare_BACKGROUND
    if ((message.GetState() == hmibase::TO_BACKGROUND)) { eventId = CIT_EVENT_ID(onAppStatusPrepare_BACKGROUND, 0x4C8518AE); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForApplicationStateUpdMsg(AppHmi_SxmStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ApplicationStateUpdMsg const & message = static_cast< ::ApplicationStateUpdMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onSubSurfaceUpdMsgChanged_FOREGROUND
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSubSurfaceUpdMsgChanged_FOREGROUND 0xffff
#pragma _REMINDER("Using dummy value symbol onSubSurfaceUpdMsgChanged_FOREGROUND ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSubSurfaceUpdMsgChanged_FOREGROUND -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onSubSurfaceUpdMsgChanged_BACKGROUND
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSubSurfaceUpdMsgChanged_BACKGROUND 0xffff
#pragma _REMINDER("Using dummy value symbol onSubSurfaceUpdMsgChanged_BACKGROUND ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSubSurfaceUpdMsgChanged_BACKGROUND -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForSubSurfaceUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);

#ifdef onSubSurfaceUpdMsgChanged_FOREGROUND
    if ((message.GetState() == hmibase::IN_FOREGROUND)) { eventId = CIT_EVENT_ID(onSubSurfaceUpdMsgChanged_FOREGROUND, 0x9D4DF4FC); return true; }
#endif
#ifdef onSubSurfaceUpdMsgChanged_BACKGROUND
    if ((message.GetState() == hmibase::IN_BACKGROUND)) { eventId = CIT_EVENT_ID(onSubSurfaceUpdMsgChanged_BACKGROUND, 0x5790D8C1); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSubSurfaceUpdMsg(AppHmi_SxmStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);
#ifdef onSubSurfaceUpdMsgChanged_FOREGROUND
    if (eventId == onSubSurfaceUpdMsgChanged_FOREGROUND) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetDisplayRegion(), message.GetDisplayID()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_FOREGROUND.DisplayRegion = message.GetDisplayRegion();
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_FOREGROUND.DisplayID = message.GetDisplayID();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onSubSurfaceUpdMsgChanged_BACKGROUND
    if (eventId == onSubSurfaceUpdMsgChanged_BACKGROUND) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetDisplayRegion(), message.GetDisplayID()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_BACKGROUND.DisplayRegion = message.GetDisplayRegion();
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_BACKGROUND.DisplayID = message.GetDisplayID();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForTransitionIndMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::Courier::TransitionIndMsg const & message = static_cast< ::Courier::TransitionIndMsg const &>(aMessage);

#ifdef OnNextLevelTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("NextLevelTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnNextLevelTransitionFinished, 0xE7DCE080); return true; }
#endif
#ifdef OnPreviousLevelTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("PreviousLevelTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPreviousLevelTransitionFinished, 0x26C30D04); return true; }
#endif
#ifdef OnPageFlipBackFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipBackTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipBackFinished, 0x74F534EE); return true; }
#endif
#ifdef OnPageFlipFrontFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipFrontTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipFrontFinished, 0x437D9EFE); return true; }
#endif
#ifdef OnZoomInFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("ZoomInTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnZoomInFinished, 0xFBEEA58F); return true; }
#endif
#ifdef OnZoomOutFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("ZoomOutTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnZoomOutFinished, 0xF84B3BD1); return true; }
#endif
#ifdef OnFadeAnimationFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("FadeTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnFadeAnimationFinished, 0xE9A6D56C); return true; }
#endif
#ifdef OnDualViewLeftTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("DualViewLeftTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnDualViewLeftTransitionFinished, 0x403A65A4); return true; }
#endif
#ifdef OnDualViewRightTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("DualViewRightTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnDualViewRightTransitionFinished, 0x50B4DCCA); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForTransitionIndMsg(AppHmi_SxmStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::Courier::TransitionIndMsg const & message = static_cast< ::Courier::TransitionIndMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_SxmStateMachineImpl::VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
struct EventMapping
{
    ::FeatStd::UInt32 mHashId;
    bool (*mEventCallHandler)(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId);
};

struct EventDeductionMapping
{
    ::FeatStd::UInt32 mHashId;
    ::Cit::DeductResult::Enum (*mEventCallHandler)(AppHmi_SxmStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId);
};

static ::FeatStd::Int EventMappingCmp(::FeatStd::UInt32 hash, const EventMapping& em)
{
    return (hash == em.mHashId) ? 0 : ((hash < em.mHashId) ? -1 : 1);
}

static ::FeatStd::Int EventDeductionMappingCmp(::FeatStd::UInt32 hash, const EventDeductionMapping& em)
{
    return (hash == em.mHashId) ? 0 : ((hash < em.mHashId) ? -1 : 1);
}

bool AppHmi_SxmStateMachineImpl::HandleEventMapping(::Courier::Message const & message, ::FeatStd::UInt32& eventId) const
{
    static EventMapping events[30] = {
        { 0x01C86EFC, HandleEventMappingForSXMAudioGotoAudioSXMDTMSettingsMsg },
        { 0x04B8AFB9, HandleEventMappingForHKStatusChangedUpdMsg },
        { 0x052AA37C, HandleEventMappingForSxmTWNYesForPopupMsg },
        { 0x060F0772, HandleEventMappingForSXMActiveTabUpdateMsg },
        { 0x1536C3F4, HandleEventMappingForButtonListItemUpdMsg },
        { 0x22A0F158, HandleEventMappingForSXMAudioGotoAudioSXMMonitorMsg },
        { 0x3824FE1D, HandleEventMappingForApplicationStateUpdMsg },
        { 0x4A69141E, HandleEventMappingForHMISubStateChangedUpdMsg },
        { 0x4FF79763, HandleEventMappingForEncoderStatusChangedUpdMsg },
        { 0x5D1FD9FC, HandleEventMappingForSXMFooterIsUpdatedMsg },
        { 0x6296CD28, HandleEventMappingForSXMDeActivatePopUpMsg },
        { 0x69FAC6F1, HandleEventMappingForSubSurfaceUpdMsg },
        { 0x6AE0FD3C, HandleEventMappingForButtonReactionMsg },
        { 0x81AB6495, HandleEventMappingForSxmSceneTransitionReqMsg },
        { 0x86D84EB4, HandleEventMappingForSXMAudioGotoAudioMainMsg },
        { 0x8DFB5B2A, HandleEventMappingForSxmLaunchBarActivationResponseUpdMsg },
        { 0x9606185B, HandleEventMappingForSXMAudioGotoAudioSettingsMsg },
        { 0x9787D085, HandleEventMappingForSxmClearContextsMsg },
        { 0xAE3CAAA7, HandleEventMappingForExpiredPopupTimerResMsg },
        { 0xBB37521A, HandleEventMappingForSxmContextSwitchInfoUpdateMsg },
        { 0xBB653851, HandleEventMappingForCloseOnTouchReqMsg },
        { 0xBDD36A0E, HandleEventMappingForSXMStatusBarActivationResponseUpdMsg },
        { 0xC613E40C, HandleEventMappingForActivateImageProviderReqMsg },
        { 0xC7B455FB, HandleEventMappingForTransitionIndMsg },
        { 0xD60DD439, HandleEventMappingForViewResMsg },
        { 0xD76723F0, HandleEventMappingForSxmRenderCompleteMsg },
        { 0xD82EEBEF, HandleEventMappingForSxmWaitAnimationReqMsg },
        { 0xDC9E389A, HandleEventMappingForSXMActivatePopUpMsg },
        { 0xE2F61D55, HandleEventMappingForSurfaceStateChangedUpdMsg },
        { 0xFB148DFE, HandleEventMappingForSXMSwitchToActiveTabMsg },
    };
    ::FeatStd::UInt32 hashId = message.GetId();
    const EventMapping* eventEntry = ::Courier::BinarySearch(hashId, events, 30, &EventMappingCmp);
    if (eventEntry && (hashId == eventEntry->mHashId)) {
        return eventEntry->mEventCallHandler(message, eventId);
    }
    return false;
}

// ------------------------------------------------------------------------
::Cit::DeductResult::Enum AppHmi_SxmStateMachineImpl::DeductEvent(::Courier::Message const & aMessage, ::FeatStd::UInt32 eventId)
{
    ::Cit::DeductResult::Enum deductResult = Cit::DeductResult::DeductOk;
    static EventDeductionMapping events[30] = {
        { 0x01C86EFC, HandleEventDeductionForSXMAudioGotoAudioSXMDTMSettingsMsg },
        { 0x04B8AFB9, HandleEventDeductionForHKStatusChangedUpdMsg },
        { 0x052AA37C, HandleEventDeductionForSxmTWNYesForPopupMsg },
        { 0x060F0772, HandleEventDeductionForSXMActiveTabUpdateMsg },
        { 0x1536C3F4, HandleEventDeductionForButtonListItemUpdMsg },
        { 0x22A0F158, HandleEventDeductionForSXMAudioGotoAudioSXMMonitorMsg },
        { 0x3824FE1D, HandleEventDeductionForApplicationStateUpdMsg },
        { 0x4A69141E, HandleEventDeductionForHMISubStateChangedUpdMsg },
        { 0x4FF79763, HandleEventDeductionForEncoderStatusChangedUpdMsg },
        { 0x5D1FD9FC, HandleEventDeductionForSXMFooterIsUpdatedMsg },
        { 0x6296CD28, HandleEventDeductionForSXMDeActivatePopUpMsg },
        { 0x69FAC6F1, HandleEventDeductionForSubSurfaceUpdMsg },
        { 0x6AE0FD3C, HandleEventDeductionForButtonReactionMsg },
        { 0x81AB6495, HandleEventDeductionForSxmSceneTransitionReqMsg },
        { 0x86D84EB4, HandleEventDeductionForSXMAudioGotoAudioMainMsg },
        { 0x8DFB5B2A, HandleEventDeductionForSxmLaunchBarActivationResponseUpdMsg },
        { 0x9606185B, HandleEventDeductionForSXMAudioGotoAudioSettingsMsg },
        { 0x9787D085, HandleEventDeductionForSxmClearContextsMsg },
        { 0xAE3CAAA7, HandleEventDeductionForExpiredPopupTimerResMsg },
        { 0xBB37521A, HandleEventDeductionForSxmContextSwitchInfoUpdateMsg },
        { 0xBB653851, HandleEventDeductionForCloseOnTouchReqMsg },
        { 0xBDD36A0E, HandleEventDeductionForSXMStatusBarActivationResponseUpdMsg },
        { 0xC613E40C, HandleEventDeductionForActivateImageProviderReqMsg },
        { 0xC7B455FB, HandleEventDeductionForTransitionIndMsg },
        { 0xD60DD439, HandleEventDeductionForViewResMsg },
        { 0xD76723F0, HandleEventDeductionForSxmRenderCompleteMsg },
        { 0xD82EEBEF, HandleEventDeductionForSxmWaitAnimationReqMsg },
        { 0xDC9E389A, HandleEventDeductionForSXMActivatePopUpMsg },
        { 0xE2F61D55, HandleEventDeductionForSurfaceStateChangedUpdMsg },
        { 0xFB148DFE, HandleEventDeductionForSXMSwitchToActiveTabMsg },
    };
    ::FeatStd::UInt32 hashId = aMessage.GetId();
    const EventDeductionMapping* eventEntry = ::Courier::BinarySearch(hashId, events, 30, &EventDeductionMappingCmp);
    if (eventEntry && (hashId == eventEntry->mHashId)) {
        deductResult = eventEntry->mEventCallHandler(this, aMessage, eventId);
    }
    else {
        typedef Cit::Internal::VSDeductHelper<VS_Ret_Ok, AppHmi_SxmStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
        return VSDeductHelper::ProcessOutput(*this, (*this.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
        return VSDeductHelper::ProcessOutput(*this, (*this.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
    }
    return deductResult;
}

// ------------------------------------------------------------------------
bool AppHmi_SxmStateMachineImpl::HandleDataBindingEventMapping(::Courier::AbstractDataItemMsg const & /* message */, ::FeatStd::UInt32 & /* eventId */) const
{
    return false;
}

#ifdef CIT_SIMULATION
struct EventNameMapping
{
    ::FeatStd::UInt32 mEventId;
    const ::FeatStd::Char* mEventName;
    void (*mGetEventArguments)(::Courier::Message const & message, Json::Value& eventArguments);
};

static ::FeatStd::Int EventNameMappingCmp(::FeatStd::UInt32 eventId, const EventNameMapping& em)
{
    return (eventId == em.mEventId) ? 0 : ((eventId < em.mEventId) ? -1 : 1);
}

static void GetEventArgumentsForonSxmTopPopupSurfaceUnqueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonSXMFooterIsUpdated(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SXMFooterIsUpdatedMsg const & message = static_cast< ::SXMFooterIsUpdatedMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetListId();
}

static void GetEventArgumentsForonSXMActivatePopUp(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SXMActivatePopUpMsg const & message = static_cast< ::SXMActivatePopUpMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetPopUpId();
}

static void GetEventArgumentsForonSxmTopPopupSurfaceVisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonSxmClosePopupOnViewChange(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::Courier::ViewResMsg const & message = static_cast< ::Courier::ViewResMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetViewAction();
}

static void GetEventArgumentsForonSXMSwitchToActiveTab(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SXMSwitchToActiveTabMsg const & message = static_cast< ::SXMSwitchToActiveTabMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetTabIndex();
}

static void GetEventArgumentsForonSXMDeActivatePopUp(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SXMDeActivatePopUpMsg const & message = static_cast< ::SXMDeActivatePopUpMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetPopUpId();
}

static void GetEventArgumentsForonHKStatusChanged_HKAUDIO(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::HKStatusChangedUpdMsg const & message = static_cast< ::HKStatusChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetHKState();
}

static void GetEventArgumentsForonSubSurfaceUpdMsgChanged_BACKGROUND(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetDisplayRegion();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetDisplayID();
}

static void GetEventArgumentsForonEncoderStatusChanged_RIGHT_ENC(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::EncoderStatusChangedUpdMsg const & message = static_cast< ::EncoderStatusChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetEncSteps();
}

static void GetEventArgumentsForonSxmLaunchBarActivationResponseUpdMsg(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SxmLaunchBarActivationResponseUpdMsg const & message = static_cast< ::SxmLaunchBarActivationResponseUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetSurfaceState();
}

static void GetEventArgumentsForonPopupInvisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonSxmTopPopupSurfaceInvisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonSXMListSelection(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetListId();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetHdl();
    eventArguments[(::Json::Value::UInt)2] = (::Json::Value::UInt)message.GetSubHdl();
}

static void GetEventArgumentsForonSxmTopPopupSurfaceQueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonSxmCloseOnTouchReqMsg(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::CloseOnTouchReqMsg const & message = static_cast< ::CloseOnTouchReqMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonSubSurfaceUpdMsgChanged_FOREGROUND(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetDisplayRegion();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetDisplayID();
}

static void GetEventArgumentsForonDeactivateImageProviderRequest(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetInstanceId();
}

static void GetEventArgumentsForonSXMPresetItemRecall(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetHdl();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetSubHdl();
}

static void GetEventArgumentsForonSXMStatusBarActivationResponseUpdMsg(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SXMStatusBarActivationResponseUpdMsg const & message = static_cast< ::SXMStatusBarActivationResponseUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetSurfaceState();
}

static void GetEventArgumentsForonSxmRenderCompleteMsg(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SxmRenderCompleteMsg const & message = static_cast< ::SxmRenderCompleteMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId();
}

static void GetEventArgumentsForonPopupVisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonPopupQueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonPopupUnqueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonActivateImageProviderRequest(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetInstanceId();
}

static void GetEventArgumentsForonSXMPresetItemStore(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetHdl();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetSubHdl();
}

static void GetEventArgumentsForonSxmSceneTransition(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SxmSceneTransitionReqMsg const & message = static_cast< ::SxmSceneTransitionReqMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewID();
}

static void GetEventArgumentsForonPopupTimerExpiry(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ExpiredPopupTimerResMsg const & message = static_cast< ::ExpiredPopupTimerResMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId();
}

const ::FeatStd::Char* AppHmi_SxmStateMachineImpl::GetEventName(::FeatStd::UInt32 eventId, ::Courier::Message const & message, Json::Value& eventArguments)
{
    static EventNameMapping events[133] = {
        { 0x023426EC, "onSXMAudioAlertFavtTune", 0 },
        { 0x03FFE536, "onSxmTWNGray", 0 },
        { 0x0619E9FB, "onSxmTopPopupSurfaceUnqueued", GetEventArgumentsForonSxmTopPopupSurfaceUnqueued },
        { 0x0D0F5602, "onHMISubStateChanged_STANDBY", 0 },
        { 0x0D401A9E, "onSXMAudiodeleteFavoriteItem", 0 },
        { 0x0DC4753E, "onSXMFooterIsUpdated", GetEventArgumentsForonSXMFooterIsUpdated },
        { 0x0DDB04BB, "onSXMAudioFavtSongHistory", 0 },
        { 0x135A2E87, "onSXMAudioMenuDirectTune", 0 },
        { 0x175EF1AA, "onSxmTWNYesForPopup", 0 },
        { 0x1D29D9BD, "onSxmSourcePressOnHomeScreen", 0 },
        { 0x1D2B6F14, "onSXMAudioSFAddTeam", 0 },
        { 0x1ECBEC91, "onSxmSFGray", 0 },
        { 0x1F0F609D, "onSXMActivatePopUp", GetEventArgumentsForonSXMActivatePopUp },
        { 0x1F757021, "onSxmTab4Selection", 0 },
        { 0x21FE62B3, "onSxmSFReturn", 0 },
        { 0x263EAF7F, "onHKStatusChanged_HK_SELECT_UP", 0 },
        { 0x26C30D04, "OnPreviousLevelTransitionFinished", 0 },
        { 0x26DA4A8F, "onSXMActiveTabUpdate", 0 },
        { 0x27BF5640, "onSXMAudioTurnAlertOff", 0 },
        { 0x289869E9, "onSxmWaitAnimationStart", 0 },
        { 0x29E74C6E, "onSxmTWNWhite", 0 },
        { 0x29FF999C, "onSxmAudioBack", 0 },
        { 0x2F433643, "onSxmTopPopupSurfaceVisible", GetEventArgumentsForonSxmTopPopupSurfaceVisible },
        { 0x325146D5, "onSxmSourcePressOnMainScreen", 0 },
        { 0x34ABC619, "onSxmAudioPlay", 0 },
        { 0x39A7DCE6, "onSxmClosePopupOnViewChange", GetEventArgumentsForonSxmClosePopupOnViewChange },
        { 0x39E920C5, "onSXMAudioCustomizeClearAll", 0 },
        { 0x3B1917E6, "onSxmClearContexts", 0 },
        { 0x3C45D5DC, "onSxmAudioChangePresetBankRight", 0 },
        { 0x4016CCEE, "onSxmAudioNowPlaying", 0 },
        { 0x403A65A4, "OnDualViewLeftTransitionFinished", 0 },
        { 0x437D9EFE, "OnPageFlipFrontFinished", 0 },
        { 0x443FE03A, "onSxmAudioScanAudioPlay", 0 },
        { 0x46ECA137, "onSXMSwitchToActiveTab", GetEventArgumentsForonSXMSwitchToActiveTab },
        { 0x48BD2620, "onSxmTab3Selection", 0 },
        { 0x4C8518AE, "onAppStatusPrepare_BACKGROUND", 0 },
        { 0x4CD05341, "onSXMDeActivatePopUp", GetEventArgumentsForonSXMDeActivatePopUp },
        { 0x50B4DCCA, "OnDualViewRightTransitionFinished", 0 },
        { 0x50D2C7EC, "onHKStatusChanged_HKAUDIO", GetEventArgumentsForonHKStatusChanged_HKAUDIO },
        { 0x522B4B36, "onSXMAudioMenuSaveArtist", 0 },
        { 0x537A4F7B, "onSXMAudioFavtSongNotifyAllOff", 0 },
        { 0x544C254D, "onSxmAudioSkipEndOfBuffer", 0 },
        { 0x556F43FB, "onSxmAudioSkipBackward", 0 },
        { 0x568D1296, "onSXMAudioTurnAlertOn", 0 },
        { 0x5790D8C1, "onSubSurfaceUpdMsgChanged_BACKGROUND", GetEventArgumentsForonSubSurfaceUpdMsgChanged_BACKGROUND },
        { 0x586354D8, "onSXMAudioMenuFavorite", 0 },
        { 0x5AFD0249, "onSxmAudioSkipToLive", 0 },
        { 0x5B86652E, "onSxmTWNGreen", 0 },
        { 0x5D610D51, "onSxmAudioRewind", 0 },
        { 0x5E3FF1B3, "onSxmAudioPresetOn", 0 },
        { 0x6381C239, "onSxmAudioPresetOff", 0 },
        { 0x644191E2, "onSxmSFTune", 0 },
        { 0x64AC0078, "onSXMAudioGoToAudioSXMDTMSettings", 0 },
        { 0x6540B6E9, "onSxmWaitAnimationStop", 0 },
        { 0x65EC1804, "onSXMAudioMenuSaveSong", 0 },
        { 0x65F4D6C9, "onSxmSceneButtonCancel", 0 },
        { 0x67E5D82B, "onEncoderStatusChanged_RIGHT_ENC", GetEventArgumentsForonEncoderStatusChanged_RIGHT_ENC },
        { 0x68873B1A, "onSxmPopupButtonCancel", 0 },
        { 0x689D5812, "onSxmSourceLongPressOnMainScreen", 0 },
        { 0x68E2C8C8, "onSxmLaunchBarActivationResponseUpdMsg", GetEventArgumentsForonSxmLaunchBarActivationResponseUpdMsg },
        { 0x6B07AAC6, "onSxmBackPressOnSxmDTMMain", 0 },
        { 0x6C1CD62F, "onPopupInvisible", GetEventArgumentsForonPopupInvisible },
        { 0x6D1B3A68, "onAppStatusChanged_BACKGROUND", 0 },
        { 0x6D7FFEED, "onSXMAudioGoToAudioSettings", 0 },
        { 0x6D8C7BFD, "onSxmTopPopupSurfaceInvisible", GetEventArgumentsForonSxmTopPopupSurfaceInvisible },
        { 0x74F534EE, "OnPageFlipBackFinished", 0 },
        { 0x76CF2B88, "onHMISubStateChanged_ON", 0 },
        { 0x77525206, "onSxmAudioForward", 0 },
        { 0x776D7D8A, "onHMISubStateChanged_OFF", 0 },
        { 0x7B58F48F, "onSxmTab2Selection", 0 },
        { 0x7C8E80B9, "onSxmSFRed", 0 },
        { 0x7D001AC0, "onSxmAudioScanSkipBackward", 0 },
        { 0x86C462E2, "onSxmGadgetTouchArea", 0 },
        { 0x87197D86, "onSxmInfoSubscribe", 0 },
        { 0x881477F5, "onSXMListSelection", GetEventArgumentsForonSXMListSelection },
        { 0x90EA0B7F, "onSxmInfoPopupOK", 0 },
        { 0x91C30CD4, "onSxmTopPopupSurfaceQueued", GetEventArgumentsForonSxmTopPopupSurfaceQueued },
        { 0x9894E1D3, "onSXMAudioFavtArtistNotifyAllOn", 0 },
        { 0x9970F882, "onSxmTWNRed", 0 },
        { 0x99758D01, "onSxmCloseOnTouchReqMsg", GetEventArgumentsForonSxmCloseOnTouchReqMsg },
        { 0x9D4DF4FC, "onSubSurfaceUpdMsgChanged_FOREGROUND", GetEventArgumentsForonSubSurfaceUpdMsgChanged_FOREGROUND },
        { 0x9D9A7C6D, "onSXMAudioFavtArtistHistory", 0 },
        { 0x9FE98C1E, "onDeactivateImageProviderRequest", GetEventArgumentsForonDeactivateImageProviderRequest },
        { 0xA13F5476, "onSxmAudioScan", 0 },
        { 0xA15C3CEE, "onHMISubStateChanged_STANDBY_RESTRICTED", 0 },
        { 0xA5159580, "onSXMAudioMenuCategories", 0 },
        { 0xAB89D7A8, "onHMISubStateChanged_SECURE", 0 },
        { 0xABF88A00, "onEvSXMSource", 0 },
        { 0xAD79E27B, "onSXMPresetItemRecall", GetEventArgumentsForonSXMPresetItemRecall },
        { 0xAE2F3F1D, "onSXMAudioFavtSongNotifyAllOn", 0 },
        { 0xB1DEE545, "onSXMStatusBarActivationResponseUpdMsg", GetEventArgumentsForonSXMStatusBarActivationResponseUpdMsg },
        { 0xB5E41E72, "onSXMAudioGadgetTransparent", 0 },
        { 0xB68B1134, "onSxmRenderCompleteMsg", GetEventArgumentsForonSxmRenderCompleteMsg },
        { 0xB78D7AE0, "onPopupVisible", GetEventArgumentsForonPopupVisible },
        { 0xB9AF50E2, "onSxmTab3BtnCondensedSelection", 0 },
        { 0xBBE6896C, "onPopupQueued", GetEventArgumentsForonPopupQueued },
        { 0xBC094CC8, "onSXMAudioGoToAudioMain", 0 },
        { 0xBD62D658, "onSxmTab1Selection", 0 },
        { 0xC5BB6589, "onSxmAudioForwardStop", 0 },
        { 0xC8D83B8B, "onHMISubStateChanged_PHONE", 0 },
        { 0xCC701628, "onSXMAudioFavtSportsHistory", 0 },
        { 0xCDA808F4, "onSxmContextSwitchInfoUpdate", 0 },
        { 0xCECDE44B, "onSXMAudioDirectTuneOk", 0 },
        { 0xD22B1A3E, "onSxmAudioScanFastForward", 0 },
        { 0xD3281AEE, "onSXMAudioGoToAudioSXMMonitor", 0 },
        { 0xD592F317, "onSXMAudioScanAbort", 0 },
        { 0xDB0D29F4, "onPopupUnqueued", GetEventArgumentsForonPopupUnqueued },
        { 0xDBE7D83F, "onSXMAudioFavtArtistNotifyAllOff", 0 },
        { 0xDCD6A4C5, "onSxmBackPressOnTestModeMonitor", 0 },
        { 0xDD62EA5B, "onActivateImageProviderRequest", GetEventArgumentsForonActivateImageProviderRequest },
        { 0xDE9448E3, "onAppStatusChanged_FOREGROUND", 0 },
        { 0xDFD78429, "onSxmAudioPause", 0 },
        { 0xE14366AD, "onSxmAudioMenu", 0 },
        { 0xE39AAA61, "onSxmAudioGadgetPrevChannel", 0 },
        { 0xE4658CFD, "onHMISubStateChanged_NO_DISPLAY", 0 },
        { 0xE62CB708, "onSXMPresetItemStore", GetEventArgumentsForonSXMPresetItemStore },
        { 0xE7945364, "onSxmSFGreen", 0 },
        { 0xE798C26F, "onSXMAudioMenuChannelList", 0 },
        { 0xE7DCE080, "OnNextLevelTransitionFinished", 0 },
        { 0xE7F18622, "onSXMAudioCustomizeSelectAll", 0 },
        { 0xE997283B, "onSxmAudioFastForward", 0 },
        { 0xE9A6D56C, "OnFadeAnimationFinished", 0 },
        { 0xEBFF91BA, "onSxmAudioGadgetNextChannel", 0 },
        { 0xED55FB03, "onSxmSceneTransition", GetEventArgumentsForonSxmSceneTransition },
        { 0xF21D1BCF, "onSxmAudioChangePresetBankLeft", 0 },
        { 0xF3C96D17, "onPopupTimerExpiry", GetEventArgumentsForonPopupTimerExpiry },
        { 0xF67F4B82, "onPopupTouch2Line", 0 },
        { 0xF7A4EE9D, "onSxmSourcePressOnToggle", 0 },
        { 0xF84B3BD1, "OnZoomOutFinished", 0 },
        { 0xF93FDB5D, "onSxmAudioRewindStop", 0 },
        { 0xF96478DC, "onHMISubStateChanged_CLOCK", 0 },
        { 0xFBEEA58F, "OnZoomInFinished", 0 },
        { 0xFF554537, "onSxmSFWhite", 0 },
    };
    const EventNameMapping* eventEntry = ::Courier::BinarySearch(eventId, events, 133, &EventNameMappingCmp);
    if (eventEntry && (eventId == eventEntry->mEventId)) {
        if (0 != eventEntry->mGetEventArguments) {
            eventEntry->mGetEventArguments(message, eventArguments);
        }
        return eventEntry->mEventName;
    }
    return 0;
}
#endif
// ------------------------------------------------------------------------
struct IdToNameMapping
{
    ::FeatStd::UInt32 mId;
    const ::FeatStd::Char* mName;
};

static ::FeatStd::Int IdToNameMappingCmp(::FeatStd::UInt32 id, const IdToNameMapping& nm)
{
    return (id == nm.mId) ? 0 : ((id < nm.mId) ? -1 : 1);
}

const ::FeatStd::Char * AppHmi_SxmStateMachineImpl::GetNameFromId(::FeatStd::UInt32 id)
{
    static IdToNameMapping names[54] = {
        { 0x05947A83, "Sxm#SxmPopups#SXM_RADIO__POPUP_REMOVE_ALL_ARTISTS_USERCONF" },
        { 0x0A9E01DA, "Sxm#SxmPopups#SXM_RADIO__TPOP_FAILURE_CHANNEL_NA" },
        { 0x0B541CDC, "Sxm#SxmPopups#SXM_RADIO__ICPOP_SF_REPLAY" },
        { 0x0E7A3E61, "Sxm#Scenes#SERVICE__SXM_STM_MAIN" },
        { 0x19FC7FCB, "Sxm#Scenes#SXM_RADIO__MENU" },
        { 0x1F291400, "Sxm#Scenes#SXM_RADIO__CUSTOMIZE_CHANNELLIST" },
        { 0x21FB187E, "Sxm#Scenes#SETTINGS__RADIO_SXM" },
        { 0x27F3C4CB, "Sxm#Scenes#SXM_RADIO__SPORTSFLASH_SETTINGS_SPORTS" },
        { 0x2AFA27A4, "Sxm#SxmPopups#SXM_RADIO__TPOP_SPORTSFLASH_MONITORING" },
        { 0x2E942C65, "Sxm#Scenes#SXM_RADIO__FAVORITE_LIST" },
        { 0x334875D7, "Sxm#SxmPopups#SXM_RADIO__ICPOP_SF_NOGAME_FAVTEAM" },
        { 0x34A7F5D4, "Sxm#SxmPopups#SXM_RADIO__TPOP_TWN_NO_INFO" },
        { 0x3A63CB6C, "Sxm#SxmPopups#SXM_RADIO__TPOP_FAILURE_NO_SIGNAL" },
        { 0x4048D204, "Sxm#Scenes#SXM_RADIO__ALERT_SONGLIST" },
        { 0x46289B90, "Sxm#SxmPopups#SXM_RADIO__TPOP_AUDIO_WITH_STATIONNAME" },
        { 0x46D10D7D, "Sxm#SxmPopups#SXM_RADIO__POPUP_ALL_ARTISTSONG_USERCONF" },
        { 0x49706DD5, "Sxm#Scenes#SXM_RADIO__MAIN" },
        { 0x4A3E9E2E, "Sxm#Scenes#SXM_RADIO__ALERT_SONGLIST_EDIT" },
        { 0x56ADA22D, "Sxm#Scenes#SERVICE__SXM_DTM_MAIN" },
        { 0x5A974FCA, "Sxm#SxmPopups#SXM_RADIO__ICPOP_SPORTS_DEFINE_TEAM" },
        { 0x5DAD7810, "SxmGadgets#Gadgets#SXM__GADGET_AUDIO_SXM_LARGE" },
        { 0x6008BA33, "Sxm#SxmPopups#SXM_RADIO__TPOP_FAILURE_CHECK_ANTENNA" },
        { 0x69321ADA, "Sxm#SxmPopups#SXM_RADIO__MPOP_SPORTSFLASH_MAX_FAV" },
        { 0x6B4A7D43, "Sxm#SxmPopups#SXM_RADIO__POPUP_REMOVE_ARTISTS_USERCONF" },
        { 0x6D09DC3F, "Sxm#Scenes#SXM_RADIO__ALERT_SPORTSFLASHLIST" },
        { 0x6DB20911, "Sxm" },
        { 0x6E5213D2, "Sxm#SxmPopups#SXM_RADIO__ICPOP_SF_FAVTEAM_GAME_AVAIL" },
        { 0x7528F518, "Sxm#SxmPopups#SXM_RADIO__TPOP_FAILURE_CHANNEL_NOT_SUBSCRIBED" },
        { 0x7A65C2C1, "Sxm#SxmPopups#SXM_RADIO__ICPOP_TWN_DEFINE_CITY" },
        { 0x7F5FC5D1, "Sxm#Scenes#SXM_RADIO__EDIT_SPORTSFLASH_TEAMS" },
        { 0x808F2CBA, "Sxm#Scenes#SXM_RADIO__TWN_SETTINGS" },
        { 0x984AA41E, "Sxm#Scenes#SXM_RADIO__FAVORITE_REPLACELIST" },
        { 0x9C3D9E30, "Sxm#SxmPopups#SXM_RADIO__ITPOP_ALERT_NOTIFICATION" },
        { 0xA19AC651, "Sxm#SxmPopups#SXM_RADIO__TPOP_SPORTSFLASH_TEAM_SELECTED" },
        { 0xA314C9F4, "Sxm#SxmPopups#SXM__MPOP_SUBSCRIPTION_ADVISORY" },
        { 0xABFAD89A, "Sxm#Scenes#SXM_RADIO__DIRECTTUNE" },
        { 0xAEAFD3CE, "Sxm#SxmPopups#SERVICE__SXM_DTM_POPUP_SYSIND" },
        { 0xAF2D5F6C, "Sxm#Scenes#SXM_RADIO__ALERT_ARTISTLIST_EDIT" },
        { 0xB11EC5CE, "Sxm#Scenes#SERVICE__SXM_DEV_TESTMODE_MONITOR" },
        { 0xB1A692E0, "Sxm#SxmPopups#SXM_RADIO__ITPOP_SPORTSFLASH_RETURN" },
        { 0xB330DB57, "Sxm#Scenes#SXM_RADIO__SETTING_OPTION" },
        { 0xBB1DDE56, "Sxm#SxmPopups#SXM_RADIO__ITPOP_SPORTSFLASH_ACTIVE" },
        { 0xBC03C0EC, "Sxm#Scenes#SXM_RADIO__CHANNELLIST_3" },
        { 0xBCB03CCD, "Sxm#SxmPopups#SXM_RADIO__TPOP_SUBSCRIPTION_UPDATED" },
        { 0xBF70E592, "Sxm#Scenes#SXM_RADIO__CATEGORYLIST" },
        { 0xC43FDC33, "Sxm#SxmPopups#SXM_RADIO__TPOP_DELETE_FAVORITE_TEAM" },
        { 0xC5300340, "Sxm#Scenes#SXM_RADIO__SPORTSFLASH_SETTINGS_TEAMS" },
        { 0xD322A884, "Sxm#Scenes#SXM_RADIO__SPORTSFLASH_REPLACE_TEAM" },
        { 0xD560474D, "Sxm#SxmPopups#SERVICE__MPOP_SXM_DTM_RESET_SXM_MODULE" },
        { 0xDA15D64A, "Sxm#SxmPopups#SXM_RADIO__POPUP_ALERT_ARTIST_SONG_SYSDLG" },
        { 0xE728ECB8, "Sxm#Scenes#SXM_RADIO__ALERT_SETTING" },
        { 0xEA5AB18E, "Sxm#SxmPopups#SXM_RADIO__TPOP_CHANNEL_SKIPPED" },
        { 0xF71CCC47, "Sxm#Scenes#SXM_TAB_MAIN" },
        { 0xFCEA0CC6, "Sxm#Scenes#SXM_RADIO__ALERT_ARTISTLIST" },
    };
    const IdToNameMapping *nameEntry = ::Courier::BinarySearch(id, names, 54, &IdToNameMappingCmp);
    if(nameEntry != 0 && id == nameEntry->mId) {
        return nameEntry->mName;
    }
    return "";
}

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSxmContextSwitchScreen(::FeatStd::UInt32 aContextId)
{
    Action_acSxmContextSwitchScreen(Courier::UInt32(aContextId));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSxmSelectedTab(::FeatStd::UInt32 aListId, ::FeatStd::UInt8 aTabIndex, ::FeatStd::UInt8 aTriggerType)
{
    Action_acSxmSelectedTab(Courier::UInt32(aListId), Courier::UInt8(aTabIndex), Courier::UInt8(aTriggerType));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSxmTabListEntrySelection(::FeatStd::UInt32 aListId, ::FeatStd::UInt32 aHdl, ::FeatStd::UInt32 aSubHdl)
{
    Action_acSxmTabListEntrySelection(Courier::UInt32(aListId), Courier::UInt32(aHdl), Courier::UInt32(aSubHdl));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSxmUpdateCurrentBindingIndexMsg(::FeatStd::UInt8 aTabIndex)
{
    Action_acSxmUpdateCurrentBindingIndexMsg(Courier::UInt8(aTabIndex));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMSourceChangeReqMsg()
{
    Action_acSXMSourceChangeReqMsg();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMClearActiveContexts()
{
    Action_acSXMClearActiveContexts();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSxmSportsContextViewMsg(::FeatStd::UInt32 aContextId, bool aAddRemove)
{
    Action_acSxmSportsContextViewMsg(Courier::UInt32(aContextId), bool(aAddRemove));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMAudioMonitorUpdatesMsg(::FeatStd::UInt32 aListId, bool aEnableMonitoring)
{
    Action_acSXMAudioMonitorUpdatesMsg(Courier::UInt32(aListId), bool(aEnableMonitoring));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMPopUpStateUpdMsg(bool aVisible)
{
    Action_acSXMPopUpStateUpdMsg(bool(aVisible));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMActiveServiceMsg(::FeatStd::UInt8 aServiceType, ::FeatStd::UInt8 aServiceEntryExitStatus)
{
    Action_acSXMActiveServiceMsg(Courier::UInt8(aServiceType), Courier::UInt8(aServiceEntryExitStatus));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMTuneToChannel(::FeatStd::UInt8 aSelectionMode, ::FeatStd::UInt16 aCidOrSidNumber, ::FeatStd::Int8 aSteps)
{
    Action_acSXMTuneToChannel(Courier::UInt8(aSelectionMode), Courier::UInt16(aCidOrSidNumber), Courier::Int8(aSteps));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMTuneSelectedChannelItem(::FeatStd::UInt32 aListId, ::FeatStd::UInt32 aRowId)
{
    Action_acSXMTuneSelectedChannelItem(Courier::UInt32(aListId), Courier::UInt32(aRowId));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSxmAudioCategories()
{
    Action_acSxmAudioCategories();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSxmAudioUpdatePresetList()
{
    Action_acSxmAudioUpdatePresetList();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSxmAudioChangePresetBank(::FeatStd::Int8 aDirection)
{
    Action_acSxmAudioChangePresetBank(Courier::Int8(aDirection));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMAudioChannelList(::FeatStd::UInt32 aRowId, ::FeatStd::UInt32 aListId)
{
    Action_acSXMAudioChannelList(Courier::UInt32(aRowId), Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMAudioRecallorStore(::FeatStd::UInt8 aPresetRowIndex, ::FeatStd::UInt8 aPresetColIndex, ::FeatStd::UInt8 aPresetAction)
{
    Action_acSXMAudioRecallorStore(Courier::UInt8(aPresetRowIndex), Courier::UInt8(aPresetColIndex), Courier::UInt8(aPresetAction));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSxmAudioContentAlertList(::FeatStd::UInt8 aHdl, ::FeatStd::UInt8 aFavType)
{
    Action_acSxmAudioContentAlertList(Courier::UInt8(aHdl), Courier::UInt8(aFavType));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSxmAudioAlertSettingOnOff(::FeatStd::UInt32 aHdl)
{
    Action_acSxmAudioAlertSettingOnOff(Courier::UInt32(aHdl));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSxmAudioPresetControl(::FeatStd::UInt8 aPressedButton)
{
    Action_acSxmAudioPresetControl(Courier::UInt8(aPressedButton));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMAudioReplayControl(::FeatStd::UInt32 aPressedButton)
{
    Action_acSXMAudioReplayControl(Courier::UInt8(aPressedButton));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMAudioCustomizeList()
{
    Action_acSXMAudioCustomizeList();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMAudioCustomizeControl(::FeatStd::UInt32 aHdl)
{
    Action_acSXMAudioCustomizeControl(Courier::UInt32(aHdl));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMAudioCustomizeClearSelect(::FeatStd::UInt8 aValue)
{
    Action_acSXMAudioCustomizeClearSelect(Courier::UInt8(aValue));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMAudioAlertsTurnOnOff(::FeatStd::UInt32 aOnOffStatus, ::FeatStd::UInt32 aFavoriteType)
{
    Action_acSXMAudioAlertsTurnOnOff(Courier::Int32(aOnOffStatus), Courier::Int32(aFavoriteType));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMAudioEnableDeleteFav(::FeatStd::UInt32 aFavoriteType, ::FeatStd::UInt32 aHdl, ::FeatStd::UInt32 aSubHdl)
{
    Action_acSXMAudioEnableDeleteFav(Courier::Int32(aFavoriteType), Courier::Int32(aHdl), Courier::Int32(aSubHdl));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMSettingTestmodeListUpdate(::FeatStd::UInt32 aHdl, ::FeatStd::UInt32 aTestmodeListId)
{
    Action_acSXMSettingTestmodeListUpdate(Courier::UInt32(aHdl), Courier::UInt32(aTestmodeListId));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMAudioDirectTuneOk()
{
    Action_acSXMAudioDirectTuneOk();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMAudioDirectTuneClearSpeller()
{
    Action_acSXMAudioDirectTuneClearSpeller();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMAudioDirectTuneDeletePos()
{
    Action_acSXMAudioDirectTuneDeletePos();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMAudioTuneStart()
{
    Action_acSXMAudioTuneStart();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMAudioScanOpertation(::FeatStd::UInt8 aOperationType)
{
    Action_acSXMAudioScanOpertation(Courier::UInt8(aOperationType));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMAudioSportsLeagueList()
{
    Action_acSXMAudioSportsLeagueList();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMAudioSportsTeamListForLeague(::FeatStd::UInt32 aHdl)
{
    Action_acSXMAudioSportsTeamListForLeague(Courier::UInt32(aHdl));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMAudioSportsOnPressTeamName(::FeatStd::UInt32 aHdl)
{
    Action_acSXMAudioSportsOnPressTeamName(Courier::UInt32(aHdl));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMAudioSportsCloseOfMaxFavPopup()
{
    Action_acSXMAudioSportsCloseOfMaxFavPopup();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMAudioSportsOnPressReplaceTeamName(::FeatStd::UInt32 aHdl)
{
    Action_acSXMAudioSportsOnPressReplaceTeamName(Courier::UInt32(aHdl));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMAudioSportsRefreshTeamList()
{
    Action_acSXMAudioSportsRefreshTeamList();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMAudioSportsAlertList()
{
    Action_acSXMAudioSportsAlertList();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMAudioSportsFavList()
{
    Action_acSXMAudioSportsFavList();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMAudioGoToAudioMain()
{
    Action_acSXMAudioGoToAudioMain();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMAudioSportsflashTurnAlertOn(::FeatStd::UInt8 aSxm_SportsflashAlertStatus)
{
    Action_acSXMAudioSportsflashTurnAlertOn(Courier::UInt32(aSxm_SportsflashAlertStatus));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMAudioSportsflashDeleteFavtTeam(::FeatStd::UInt32 aListId, ::FeatStd::UInt32 aHdl, ::FeatStd::UInt32 aSubHdl)
{
    Action_acSXMAudioSportsflashDeleteFavtTeam(Courier::UInt32(aListId), Courier::UInt32(aHdl), Courier::UInt32(aSubHdl));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSxmSFButtonPress(::FeatStd::UInt32 aButtonColor)
{
    Action_acSxmSFButtonPress(Courier::UInt32(aButtonColor));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSxmSFDisableMonitorMsg()
{
    Action_acSxmSFDisableMonitorMsg();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSxmSFYesForMonitorPopupMsg()
{
    Action_acSxmSFYesForMonitorPopupMsg();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSxmSFTuneChannelMsg()
{
    Action_acSxmSFTuneChannelMsg();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSxmSFReturnChannelMsg()
{
    Action_acSxmSFReturnChannelMsg();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSxmSFAlertClose()
{
    Action_acSxmSFAlertClose();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSxmTWNListSettings()
{
    Action_acSxmTWNListSettings();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSxmTWNYesForPopup()
{
    Action_acSxmTWNYesForPopup();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSxmTWNListSelect(::FeatStd::UInt32 aListId, ::FeatStd::UInt32 aHdl)
{
    Action_acSxmTWNListSelect(Courier::UInt32(aListId), Courier::UInt32(aHdl));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSxmTWNButtonPress(::FeatStd::UInt32 aBtnColor)
{
    Action_acSxmTWNButtonPress(Courier::UInt32(aBtnColor));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSxmAudioSaveFav(::FeatStd::UInt32 aFavoriteType)
{
    Action_acSxmAudioSaveFav(Courier::UInt32(aFavoriteType));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSxmAudioDeleteallFav(::FeatStd::UInt32 aFavoriteType)
{
    Action_acSxmAudioDeleteallFav(Courier::UInt32(aFavoriteType));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSxmAudioDeleteAllConfirmMsg()
{
    Action_acSxmAudioDeleteAllConfirmMsg();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSxmAudioCloseFavMaxReachedPopup()
{
    Action_acSxmAudioCloseFavMaxReachedPopup();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSxmAudioReplaceSelectedFav(::FeatStd::UInt32 aRowId)
{
    Action_acSxmAudioReplaceSelectedFav(Courier::UInt32(aRowId));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSxmAudioTunetoContentAlert()
{
    Action_acSxmAudioTunetoContentAlert();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSxmAudioCloseContentAlertPopup()
{
    Action_acSxmAudioCloseContentAlertPopup();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSxmAudioChannelLockStatus()
{
    Action_acSxmAudioChannelLockStatus();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSetTpopInfo(bool aIsActive)
{
    Action_acSetTpopInfo(bool(aIsActive));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSxmAudioFocusReset(::FeatStd::UInt32 aViewId)
{
    Action_acSxmAudioFocusReset(Courier::UInt32(aViewId));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMInfoUpdatedatabinding()
{
    Action_acSXMInfoUpdatedatabinding();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSxmDTMTestModeMonitorSel(bool aStartMonitor)
{
    Action_acSxmDTMTestModeMonitorSel(bool(aStartMonitor));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSxmWaitSyncCancelled()
{
    Action_acSxmWaitSyncCancelled();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSXMFooterListIdReqMsg(::FeatStd::UInt32 aListId)
{
    Action_acSXMFooterListIdReqMsg(Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::Notify_Init_Finished()
{
    Action_Notify_Init_Finished();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacChangeLanguageReq(::FeatStd::Int32 aLanguageId)
{
    Action_gacChangeLanguageReq(enLanguageId(aLanguageId));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacHideFocusInViewReq(::FeatStd::UInt32 aView)
{
    Action_gacHideFocusInViewReq(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(aView)));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::NextLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_NextLevelTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::PreviousLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_PreviousLevelTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::DualViewLeftTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_DualViewLeftTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::DualViewRightTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_DualViewRightTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::PageFlipBackTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_PageFlipBackTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::PageFlipFrontTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_PageFlipFrontTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::ZoomInTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos)
{
    Action_ZoomInTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView), Candera::UInt8(aPos));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::ZoomOutTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos)
{
    Action_ZoomOutTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView), Candera::UInt8(aPos));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::FadeTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_FadeTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacWaitAnimationStartReq()
{
    Action_gacWaitAnimationStartReq();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acFocusOnRightEncoderReqUpd(bool aIsFocusUsed)
{
    Action_acFocusOnRightEncoderReqUpd(bool(aIsFocusUsed));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acSetGadgetSceenActiveStatus(bool aIsGadgetAtive)
{
    Action_acSetGadgetSceenActiveStatus(bool(aIsGadgetAtive));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acHKNotificationMsg(::FeatStd::Int8 aHKCode, ::FeatStd::Int8 aHKState)
{
    Action_acHKNotificationMsg(Courier::UInt8(aHKCode), Courier::UInt8(aHKState));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acPerform_CloseAllDropdowns()
{
    Action_acPerform_CloseAllDropdowns();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acPerform_CloseDropdown(::FeatStd::UInt32 aListId)
{
    Action_acPerform_CloseDropdown(::Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acPerform_OpenDropdown(::FeatStd::UInt32 aListId)
{
    Action_acPerform_OpenDropdown(::Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acPerform_ToggleDropdown(::FeatStd::UInt32 aListId)
{
    Action_acPerform_ToggleDropdown(::Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acStartAppPopupTimer(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aTimeout)
{
    Action_acStartAppPopupTimer(Courier::UInt32(aViewId), Courier::UInt32(aTimeout));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acStopAppPopupTimer(::FeatStd::UInt32 aViewId)
{
    Action_acStopAppPopupTimer(Courier::UInt32(aViewId));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acPostBeep(::FeatStd::Int8 aBeepType)
{
    Action_acPostBeep(Courier::Int32(aBeepType));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacCheckToClosePopup(::FeatStd::UInt32 aPopupId)
{
    Action_gacCheckToClosePopup(Courier::UInt32(aPopupId));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::acRestartAppPopupTimer(::FeatStd::UInt32 aViewId)
{
    Action_acRestartAppPopupTimer(Courier::UInt32(aViewId));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacContextSwitchBackRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchBackRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacContextSwitchCompleteRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchCompleteRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacContextSwitchFailedRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchFailedRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacContextSwitchDoneRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchDoneRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacContextSwitchOutReq(::FeatStd::UInt32 aTargetContextId, ::FeatStd::UInt32 aSourceContextId, ::FeatStd::UInt32 aTargetAppId)
{
    Action_gacContextSwitchOutReq(Courier::UInt32(aTargetContextId), Courier::UInt32(aSourceContextId), Courier::UInt32(aTargetAppId));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacCurrentScreenDisplayReq()
{
    Action_gacCurrentScreenDisplayReq();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacLaunchBarDisplayReq(bool aVisibility)
{
    Action_gacLaunchBarDisplayReq(bool(aVisibility));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacNavTBTSwipe()
{
    Action_gacNavTBTSwipe();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacPerformListBtnRightEncoderChangeUpd(::FeatStd::Int8 aSteps, ::FeatStd::UInt32 aListId, ::FeatStd::UInt32 aRowId, ::FeatStd::UInt32 aColumnId)
{
    Action_gacPerformListBtnRightEncoderChangeUpd(Courier::Int8(aSteps), Courier::UInt32(aListId), Courier::UInt32(aRowId), Courier::UInt32(aColumnId));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacScrollListUp()
{
    Action_gacScrollListUp();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacScrollListDown()
{
    Action_gacScrollListDown();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacScrollPageUp()
{
    Action_gacScrollPageUp();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacScrollPageDown()
{
    Action_gacScrollPageDown();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacScrollListFocusUp(::FeatStd::UInt32 aListId)
{
    Action_gacScrollListFocusUp(Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacScrollListFocusDown(::FeatStd::UInt32 aListId)
{
    Action_gacScrollListFocusDown(Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacPerformListFocusLockDataResetUpd()
{
    Action_gacPerformListFocusLockDataResetUpd();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacSetApplicationMode(::FeatStd::UInt32 aModeId)
{
    Action_gacSetApplicationMode(Courier::UInt32(aModeId));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacSpellerBbehaviorReq(bool aEnable)
{
    Action_gacSpellerBbehaviorReq(bool(aEnable));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacStatusBarDisplayReq(bool aVisibility, ::FeatStd::Int32 aHeaderType)
{
    Action_gacStatusBarDisplayReq(bool(aVisibility), Courier::Int32(aHeaderType));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacTBTRetriggerAcousticOutput()
{
    Action_gacTBTRetriggerAcousticOutput();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacWaitAnimationStopReq()
{
    Action_gacWaitAnimationStopReq();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacViewCreateReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateReq(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacViewCreateAllReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateAllReq(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacViewDestroyReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewDestroyReq(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacViewClearReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewClearReq(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacViewShowReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewShowReq(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacViewHideReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewHideReq(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacViewCreateWithoutLoadReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateWithoutLoadReq(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacViewAsyncLoadReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewAsyncLoadReq(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacViewActivateWithoutRenderingReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacPopupCreateAndSBShowReq(::FeatStd::UInt32 aViewId)
{
    Action_gacPopupCreateAndSBShowReq(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacPopupCreateAndSBShowReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId)
{
    Action_gacPopupCreateAndSBShowReqForMultiDisplay(Courier::UInt32(aPopupDisplayID), ::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacPopupSBCloseReq(::FeatStd::UInt32 aViewId)
{
    Action_gacPopupSBCloseReq(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacPopupSBCloseReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId)
{
    Action_gacPopupSBCloseReqForMultiDisplay(Courier::UInt32(aPopupDisplayID), ::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacPopupRestartTimerReq(::FeatStd::UInt32 aViewId)
{
    Action_gacPopupRestartTimerReq(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacPopupRestartTimerReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId)
{
    Action_gacPopupRestartTimerReqForMultiDisplay(Courier::UInt32(aPopupDisplayID), ::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacViewCreateAndShowReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateAndShowReq(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacViewHideAndDestroyReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewHideAndDestroyReq(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacSceneTransitionEnter(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint)
{
    Action_gacSceneTransitionEnter(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(aViewId)), Courier::UInt32(aHint));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacSceneTransitionLeave(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint)
{
    Action_gacSceneTransitionLeave(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(aViewId)), Courier::UInt32(aHint));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacDisplayStatusLineReq(::FeatStd::Int32 aDisplayRegionType)
{
    Action_gacDisplayStatusLineReq(Courier::Int32(aDisplayRegionType));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacHideStatusLineReq(::FeatStd::Int32 aDisplayRegionType)
{
    Action_gacHideStatusLineReq(Courier::Int32(aDisplayRegionType));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacDisplayFooterLineReq()
{
    Action_gacDisplayFooterLineReq();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacHideFooterLineReq()
{
    Action_gacHideFooterLineReq();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacDisplayStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacDisplayStatusLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacHideStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacHideStatusLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacDisplayFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacDisplayFooterLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacHideFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacHideFooterLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacRegisterForCloseOnTouchSession(::FeatStd::UInt32 aViewId)
{
    Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacDeregisterForCloseOnTouchSessionReq(::FeatStd::UInt32 aViewId)
{
    Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacPopupFilterPrioEnableReq(::FeatStd::UInt32 aPrio)
{
    Action_gacPopupFilterPrioEnableReq(Courier::UInt32(aPrio));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacPopupFilterAllEnableReq()
{
    Action_gacPopupFilterAllEnableReq();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacPopupFilterDisableReq()
{
    Action_gacPopupFilterDisableReq();
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacProfileChange(::FeatStd::Int8 aProfile)
{
    Action_gacProfileChange(Courier::UInt32(aProfile));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacPopupFilterPrioEnableReqForDisplay(::FeatStd::UInt32 aPrio, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacPopupFilterPrioEnableReqForDisplay(Courier::UInt32(aPrio), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacPopupFilterAllEnableReqForDisplay(::FeatStd::UInt32 aDisplayID)
{
    Action_gacPopupFilterAllEnableReqForDisplay(Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacPopupFilterDisableReqForDisplay(::FeatStd::UInt32 aDisplayID)
{
    Action_gacPopupFilterDisableReqForDisplay(Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacStartSceneTransitionAnimation(::FeatStd::UInt32 aSourceView, ::FeatStd::UInt32 aDestinationView, ::FeatStd::UInt32 aUserData1, ::FeatStd::Int8 aUserData2)
{
    Action_gacStartSceneTransitionAnimation(::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(aSourceView)), ::Courier::ViewId(AppHmi_SxmStateMachineImpl::GetNameFromId(aDestinationView)), Courier::UInt32(aUserData1), Courier::Int8(aUserData2));
}

// ------------------------------------------------------------------------
void AppHmi_SxmStateMachineImpl::gacDecrementActiveAnimationCount()
{
    Action_gacDecrementActiveAnimationCount();
}

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
static inline ::FeatStd::UInt8 Action_gacGetDataServiceStatus(::FeatStd::UInt8 aServiceType)
{
    return gacGetDataServiceStatus(aServiceType);
}

::FeatStd::UInt8 AppHmi_SxmStateMachineImpl::gacGetDataServiceStatus(::FeatStd::UInt8 aServiceType)
{
    return Action_gacGetDataServiceStatus(aServiceType);
}

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
bool AppHmi_SxmStateMachineImpl::dgSxmAudioScanStatus()
{
    return Action_dgSxmAudioScanStatus();
}

// ------------------------------------------------------------------------
bool AppHmi_SxmStateMachineImpl::dgSxmPopupVisible()
{
    return Action_dgSxmPopupVisible();
}

// ------------------------------------------------------------------------
bool AppHmi_SxmStateMachineImpl::dgSxmApplicationState()
{
    return Action_dgSxmApplicationState();
}
#ifdef CIT_SIMULATION
struct ActionMapping
{
    ::FeatStd::UInt32 mHashId;
    bool (*mActionCallHandler)(const ::Json::Value& parameters, ::Json::Value &response);
};

static ::FeatStd::Int ActionMappingCmp(::FeatStd::UInt32 hash, const ActionMapping& am)
{
    return (hash == am.mHashId) ? 0 : ((hash < am.mHashId) ? -1 : 1);
}

bool AppHmi_SxmStateMachineImpl::CallAction(const ::FeatStd::Char* actionName, const ::Json::Value& parameters, ::Json::Value &response)
{
    static ActionMapping actions[155] = {
        { 0x072B2360, CallAction_acSxmSFYesForMonitorPopupMsg },
        { 0x0884F877, CallAction_gacScrollListUp },
        { 0x090A895B, CallAction_gacScrollListFocusDown },
        { 0x0A4C5DC9, CallAction_gacDisplayStatusLineMultiDisplayReq },
        { 0x0C279721, CallAction_gacDecrementActiveAnimationCount },
        { 0x0C3360AB, CallAction_acSxmAudioChangePresetBank },
        { 0x1162E64E, CallAction_acSXMAudioEnableDeleteFav },
        { 0x11915CFE, CallAction_acStopAppPopupTimer },
        { 0x15061065, CallAction_gacViewShowReq },
        { 0x17140875, CallAction_acSXMAudioSportsAlertList },
        { 0x175D044B, CallAction_acSXMAudioChannelList },
        { 0x186A69F1, CallAction_gacWaitAnimationStopReq },
        { 0x187DA604, CallAction_acPerform_OpenDropdown },
        { 0x1915D8BB, CallAction_acSXMPopUpStateUpdMsg },
        { 0x1A30563D, CallAction_acSXMAudioSportsOnPressReplaceTeamName },
        { 0x1BC6E0A9, CallAction_ZoomInTransition },
        { 0x21E3828E, CallAction_gacDisplayStatusLineReq },
        { 0x251DE22F, CallAction_gacContextSwitchCompleteRes },
        { 0x254E0D94, CallAction_gacViewHideReq },
        { 0x258104C2, CallAction_DualViewLeftTransition },
        { 0x264B8E81, CallAction_gacPopupRestartTimerReqForMultiDisplay },
        { 0x26DAB4AC, CallAction_acSxmTWNYesForPopup },
        { 0x27CE647F, CallAction_gacScrollListFocusUp },
        { 0x29D14586, CallAction_gacDisplayFooterLineMultiDisplayReq },
        { 0x2A1E6CB2, CallAction_gacDeregisterForCloseOnTouchSessionReq },
        { 0x2AE288D8, CallAction_gacViewDestroyReq },
        { 0x2DA83FC9, CallAction_acSxmAudioFocusReset },
        { 0x30C8D840, CallAction_gacStartSceneTransitionAnimation },
        { 0x325BE13A, CallAction_gacViewCreateReq },
        { 0x334571BF, CallAction_acHKNotificationMsg },
        { 0x34047ACD, CallAction_acSXMSourceChangeReqMsg },
        { 0x34A3ED90, CallAction_acSXMAudioGoToAudioMain },
        { 0x34E0F35A, CallAction_acSxmAudioChannelLockStatus },
        { 0x3931F9AA, CallAction_acSXMAudioTuneStart },
        { 0x3BB18A69, CallAction_gacPopupFilterAllEnableReq },
        { 0x3E4CE5A1, CallAction_gacContextSwitchDoneRes },
        { 0x3E7F9726, CallAction_gacSceneTransitionEnter },
        { 0x3F852A21, CallAction_acSXMTuneSelectedChannelItem },
        { 0x3FBDD797, CallAction_acSxmWaitSyncCancelled },
        { 0x3FCD48F4, CallAction_acSXMAudioMonitorUpdatesMsg },
        { 0x3FE9C494, CallAction_acSxmAudioDeleteAllConfirmMsg },
        { 0x41201119, CallAction_acStartAppPopupTimer },
        { 0x43D712EF, CallAction_acSxmAudioDeleteallFav },
        { 0x440A20CA, CallAction_acSXMAudioSportsCloseOfMaxFavPopup },
        { 0x4B888B40, CallAction_acSXMAudioReplayControl },
        { 0x4BE0F4ED, CallAction_acSxmAudioReplaceSelectedFav },
        { 0x4DD23FDA, CallAction_acSetTpopInfo },
        { 0x53C1E0B3, CallAction_acSxmSportsContextViewMsg },
        { 0x5645A75A, CallAction_acSXMActiveServiceMsg },
        { 0x567F1338, CallAction_acSxmTabListEntrySelection },
        { 0x573EB339, CallAction_gacContextSwitchFailedRes },
        { 0x57AA275B, CallAction_gacViewCreateWithoutLoadReq },
        { 0x59148CB0, CallAction_FadeTransition },
        { 0x593FF9C7, CallAction_acSXMAudioDirectTuneClearSpeller },
        { 0x59C82D8E, CallAction_NextLevelTransition },
        { 0x59F03621, CallAction_gacChangeLanguageReq },
        { 0x5E984C1C, CallAction_acSXMAudioCustomizeControl },
        { 0x60E513C0, CallAction_gacTBTRetriggerAcousticOutput },
        { 0x629132A7, CallAction_gacPopupFilterDisableReq },
        { 0x67B7653B, CallAction_gacDisplayFooterLineReq },
        { 0x687A18C8, CallAction_acSXMAudioCustomizeClearSelect },
        { 0x6D96FDAF, CallAction_acSxmAudioUpdatePresetList },
        { 0x6DAEEAF4, CallAction_acSXMClearActiveContexts },
        { 0x72734335, CallAction_acSxmAudioCategories },
        { 0x72D73508, CallAction_acSxmUpdateCurrentBindingIndexMsg },
        { 0x7531D066, CallAction_Notify_Init_Finished },
        { 0x75E49D1D, CallAction_gacPerformListFocusLockDataResetUpd },
        { 0x76EE4CA4, CallAction_gacHideStatusLineMultiDisplayReq },
        { 0x791DF896, CallAction_acPerform_CloseAllDropdowns },
        { 0x7BF31051, CallAction_acSXMAudioCustomizeList },
        { 0x7D7B49B4, CallAction_acFocusOnRightEncoderReqUpd },
        { 0x7EE4AB88, CallAction_gacPopupRestartTimerReq },
        { 0x82D15005, CallAction_PageFlipBackTransition },
        { 0x85475720, CallAction_gacGetDataServiceStatus },
        { 0x857D50C6, CallAction_acSxmTWNListSelect },
        { 0x862418A1, CallAction_acSXMAudioSportsflashDeleteFavtTeam },
        { 0x8661C818, CallAction_acSxmTWNListSettings },
        { 0x87E8BD0C, CallAction_acSxmTWNButtonPress },
        { 0x881D2454, CallAction_gacPopupFilterAllEnableReqForDisplay },
        { 0x88685CC9, CallAction_dgSxmAudioScanStatus },
        { 0x8C1FA16A, CallAction_dgSxmApplicationState },
        { 0x8DED2A1C, CallAction_acSXMAudioRecallorStore },
        { 0x8E2CFA7A, CallAction_acSxmAudioCloseContentAlertPopup },
        { 0x91BB105A, CallAction_gacLaunchBarDisplayReq },
        { 0x920635EC, CallAction_acSxmAudioTunetoContentAlert },
        { 0x93218F8C, CallAction_gacContextSwitchOutReq },
        { 0x948F96CC, CallAction_gacScrollListDown },
        { 0x96350312, CallAction_acSetGadgetSceenActiveStatus },
        { 0x96D3C730, CallAction_gacPopupSBCloseReqForMultiDisplay },
        { 0x99258E0B, CallAction_gacStatusBarDisplayReq },
        { 0x9947A809, CallAction_acSxmAudioAlertSettingOnOff },
        { 0x998D1CE7, CallAction_acSxmAudioContentAlertList },
        { 0x9F87F08B, CallAction_acPostBeep },
        { 0x9FA26D73, CallAction_gacPopupFilterDisableReqForDisplay },
        { 0xA0A6F9FA, CallAction_gacViewHideAndDestroyReq },
        { 0xA3709DFA, CallAction_acSXMTuneToChannel },
        { 0xA4E982DB, CallAction_acSXMAudioScanOpertation },
        { 0xA7B62A65, CallAction_gacPopupFilterPrioEnableReqForDisplay },
        { 0xA84DC23C, CallAction_gacHideFocusInViewReq },
        { 0xA9B50089, CallAction_acSxmDTMTestModeMonitorSel },
        { 0xA9C7F42F, CallAction_gacHideStatusLineReq },
        { 0xAB49461E, CallAction_gacViewCreateAndShowReq },
        { 0xAC313E6A, CallAction_acSXMAudioDirectTuneDeletePos },
        { 0xAD947FF9, CallAction_gacCurrentScreenDisplayReq },
        { 0xAE48BF55, CallAction_DualViewRightTransition },
        { 0xAFB14254, CallAction_gacWaitAnimationStartReq },
        { 0xB1D0C98F, CallAction_acSXMAudioSportsLeagueList },
        { 0xBB441DAC, CallAction_gacRegisterForCloseOnTouchSession },
        { 0xBDECE418, CallAction_gacSetApplicationMode },
        { 0xBEF6021E, CallAction_acPerform_ToggleDropdown },
        { 0xC37EE8E9, CallAction_gacPopupFilterPrioEnableReq },
        { 0xC41384F0, CallAction_acSXMAudioAlertsTurnOnOff },
        { 0xC4F61813, CallAction_dgSxmPopupVisible },
        { 0xC51CE603, CallAction_gacViewCreateAllReq },
        { 0xC5DD5738, CallAction_gacProfileChange },
        { 0xC65CAED0, CallAction_gacSpellerBbehaviorReq },
        { 0xC8539D8B, CallAction_gacSceneTransitionLeave },
        { 0xC8EA8B79, CallAction_acRestartAppPopupTimer },
        { 0xC9EB88D6, CallAction_gacViewClearReq },
        { 0xCA9E3642, CallAction_acSXMAudioSportsTeamListForLeague },
        { 0xCB6001FC, CallAction_acSXMSettingTestmodeListUpdate },
        { 0xCB8DBDEF, CallAction_gacHideFooterLineReq },
        { 0xCBFD6A3D, CallAction_acSxmSelectedTab },
        { 0xCCF1A98B, CallAction_PreviousLevelTransition },
        { 0xCE4771D4, CallAction_acSxmSFReturnChannelMsg },
        { 0xD1AA4F4D, CallAction_ZoomOutTransition },
        { 0xD3DE11A4, CallAction_acSxmSFTuneChannelMsg },
        { 0xD58AAC89, CallAction_acSXMAudioSportsflashTurnAlertOn },
        { 0xD5F685D5, CallAction_PageFlipFrontTransition },
        { 0xD63C2357, CallAction_gacViewAsyncLoadReq },
        { 0xD7334205, CallAction_acSxmAudioSaveFav },
        { 0xD871CADA, CallAction_acSxmContextSwitchScreen },
        { 0xD98C6419, CallAction_gacViewActivateWithoutRenderingReq },
        { 0xDB665FD5, CallAction_acPerform_CloseDropdown },
        { 0xDD4D179D, CallAction_gacHideFooterLineMultiDisplayReq },
        { 0xDD71F921, CallAction_gacPerformListBtnRightEncoderChangeUpd },
        { 0xE04DC756, CallAction_acSxmAudioCloseFavMaxReachedPopup },
        { 0xE0EF3086, CallAction_gacPopupCreateAndSBShowReqForMultiDisplay },
        { 0xE18DC8F1, CallAction_acSxmSFButtonPress },
        { 0xE4177413, CallAction_acSXMAudioSportsRefreshTeamList },
        { 0xE500B03C, CallAction_gacContextSwitchBackRes },
        { 0xE70D9C12, CallAction_acSxmSFDisableMonitorMsg },
        { 0xEB51CB7E, CallAction_gacPopupSBCloseReq },
        { 0xEB5A32BE, CallAction_acSXMAudioDirectTuneOk },
        { 0xEC64DB0F, CallAction_gacScrollPageDown },
        { 0xEE11F57F, CallAction_gacScrollPageUp },
        { 0xEE131A83, CallAction_gacNavTBTSwipe },
        { 0xEF139CD0, CallAction_acSXMAudioSportsOnPressTeamName },
        { 0xF0A1D4B5, CallAction_gacCheckToClosePopup },
        { 0xF17E085D, CallAction_gacPopupCreateAndSBShowReq },
        { 0xF9525D72, CallAction_acSxmSFAlertClose },
        { 0xF96885B1, CallAction_acSXMFooterListIdReqMsg },
        { 0xF9FD5EC9, CallAction_acSXMInfoUpdatedatabinding },
        { 0xFBD710BD, CallAction_acSXMAudioSportsFavList },
        { 0xFDBBB9A0, CallAction_acSxmAudioPresetControl },
    };
    ::FeatStd::UInt32 hashId = ::Courier::Identifier::CalcHash(actionName);
    const ActionMapping* action = ::Courier::BinarySearch(hashId, actions, 155, &ActionMappingCmp);
    if (action && (hashId == action->mHashId)) {
        return action->mActionCallHandler(parameters, response);
    }
    return false;
}
#endif
namespace Courier {
    COURIER_MESSAGE_CONFIGURATION( ::Courier::UpdateModelMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TouchMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::KeyDownMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewReqMsg, 50);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ActivationReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ActivationResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewRenderingReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewRenderingResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewMessagingReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewMessagingResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupActivationReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupActivationResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TryLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DelayedUnloadMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LoadResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TryAsyncLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AsyncLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AsyncLoadResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AsyncLoadIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupLoadResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ThemeReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ThemeResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AnimationReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AnimationResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AnimationIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetPropertyReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetPropertyResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetFocusReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetFocusResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LostFocusIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::InvalidateReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::RenderReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::RenderResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LayerReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LayerResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewActivateEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewRenderingEnabledEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewInitContentEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewLoadEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::FocusEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LostFocusEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionStartedEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionFinishedEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetCultureReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetCultureResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CultureChangeIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewPlaceholderReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewPlaceholderResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::WidgetMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::DataBindingMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::BindingSourceBaseMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::ReleaseDataItemMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::DataItemMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::ListEventMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::input::TouchAbort, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::input::TouchSessionStartEvent, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::input::TouchSessionStopEvent, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::IdUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ConsumerMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ProviderUpdateIndicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::TouchForwardReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::TouchAbortReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ActivateImageProviderReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ExternalImageProviderReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ExternalImageProviderGroupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DrmAllocationStatusMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DrmGarbageCollectorReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DrmGCTimeoutMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::PositionBaseMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::SlaveSurfaceRepositionBaseMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DirectTextureConsumerContentIndicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::PositionInfoReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::PositionInfoResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::SlaveSurfaceRepositionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::SlaveSurfaceRepositionResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::WidgetCheckReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NotifierMessage, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TimerExpiredMsg, 15);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::GuiStartupFinishedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CreateNewDestroyOld, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EnterKeyStatusChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusControlReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusGroupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateFocusSessionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RefreshFocusSessionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusSessionFinishedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RegisterFocusableWidgetsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::JoystickStatusChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusChangedReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SurfaceStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LayerStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SBPopupTimerExpiryUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HMISubStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::QueryTraceInfoReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FollowUpActionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::WidgetPropertySetterReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SimTouchReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CloseOnTouchReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RegisterForCloseOnTouchSessionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetClosePopupExternalTouchMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ClosePopupOnExternalTouchReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PlayBeepReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeHmiSubStateReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EvalSubSurfaceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExecuteSubSurfaceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExecuteSubSurfaceResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExtendedViewReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LocalizationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DecrementActiveAnimationCountMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetApplicationAsMandatoryReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplicationStateUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SubSurfaceUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplicationRenderedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplicationSwitchCompleteUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SubSurfaceSwitchCompleteUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SbAnimationStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SbCurrentStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupDisplayStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowHMISubSurfaceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartLayerAnimationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupFilterPrioEnableReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupFilterAllEnableReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupFilterDisableReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MultiDisplayPopupFilterReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RestartMenuTimeoutTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RenderingCompleteMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CreateTextMetaDataCollectionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DumpScreenReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TraverseViewsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckSourceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckSourceResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckDestinationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckDestinationResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCompleteReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCompleteResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropAbortReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ProfileSwitchMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TransitionMediatorOnDataCompleteMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ManualSceneActionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EglWaitNativeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EglWaitNativeResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ResetGadgetCacheReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AttachedAnimationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::SenderMessage, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::TouchUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AnimationWidgetReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AnimationWidgetIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonListItemUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonReactionMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonSlideMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonGroupReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ColorBarDataUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::combobox::ComboBoxUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::combobox::ComboBoxReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DropdownCurrentValueChangedMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DropdownChangeMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::editfield::EditFieldUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::editfield::EditFieldHightlightReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::GestureMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::TapGestureMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::DragGestureMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::SwipeGestureMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::PinchSpreadGestureMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::RotateGestureMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gizmo::GizmoUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListDateProviderReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListDateProviderResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListDataProviderUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListChangeMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListAnimatedChangeReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListChangedUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListMovementFinishedUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListStatusUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListVisibiltyUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusChangeReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SliderCurrentValueChangedMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LockOutMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListItemExpandReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListItemExpandEndUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCustomAnimationReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCustomAnimationResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCustomAnimationIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListMorphReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListContentUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListVisualContentUpdateMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCacheReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::pageedit::PageEditUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PanelSlideReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PanelStateMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerKeyPressed, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerCtrlKeyPressed, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerStatusChangedUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SubSpellerStatusUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TimerWidgetExpiryMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HWR_CandidateUpdate, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HWR_TextWidgetUpdate, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ScrollableTextUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActiveSurfaceViewUpdateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeLanguageReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartPopupTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StopPopupTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RestartPopupTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExpiredPopupTimerResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusResetReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EnableCameraRenderingReq, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchApplicationStateReq, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DisableCameraRenderingReq, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DummyMess, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivityMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateApplicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DeactivateApplicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HardKeyPressNotificationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusOnRightEncoderReqUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StoreActiveGadgetReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CheckToClosePopupMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ContextSwitchOutReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ContextSwitchInResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CurrentScreenDisplayReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LaunchBarDisplayReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NavTBTSwipeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListItemRightEncoderChangeUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusLockDataResetReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusScrollReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetApplicationModeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerBbehaviorReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StatusBarDisplayReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TBTRetriggerAcousticMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartGadgetAnimationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ControlPanelButtonPressInfo, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NavigationCarModeInfo, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmStringBoundaryReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmStringBoundaryResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMSourceChangeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmRenderCompleteMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmKeyRegisterStatusMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmSportsContextViewMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMSportsBroadScopeUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMTuneToChannelReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMActiveServiceMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMPopUpStateUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMTuneSelectedChannelItemReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmWaitAnimationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmSceneTransitionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmWaitSyncCancelledMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmClearContextsMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmSurfaceStateChngUpdtMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMClearActiveContextsMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmContextSwitchScreenReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMFooterIsUpdatedMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioMonitorUpdatesMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmAudioCategoriesReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmAudioChangePresetBankReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmAudioUpdatePresetListReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmAudioDisplayAdvioryRecallFailureReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmUpdatePresetlistReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmAudioContentAlertListReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmAudioAlertSettingOnOffReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmAudioFocusResetReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmAudioSaveFavReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmAudioCloseFavMaxReachedPopupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmAudioFavReplaceListReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmAudioReplaceSelectedFavReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmAudioTunetoContentAlertReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmAudioCloseContentAlertPopupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMTPopUpAudioStateUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioAlertFavtUpdatePopupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMSourceStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioChannelListReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioScanReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmAudioPresetControlReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioReplayControlReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioCustomizeListReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioCustomizeControlReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioCustomizeClearSelectReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioAdvisoryReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioRecallorStoreReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMActivatePopUpMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMDeActivatePopUpMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioDirectTuneOkReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioDirectTuneDeletePosReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioDirectTuneClearSpellerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioGotoAudioMainMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioGotoAudioSettingsMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioGotoAudioSXMMonitorMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioGotoAudioSXMDTMSettingsMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioAlertsTurnOnOffReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioEnableDeleteFavReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioPostTimeZoneChangeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioPostLocalTimeChangeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioTuneStartReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioScanAbortReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioScanOpertationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioSportsLeagueListReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioSportsTeamListForLeagueReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioSportsOnPressTeamNameReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioSportsCloseOfMaxFavPopupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioSportsOnPressReplaceTeamNameReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioSportsRefreshTeamListReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioSportsRefreshSFStatusReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioSportsAlertListReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioSportsFavListReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioSportsflashTurnAlertAllOnReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMAudioSportsflashDeleteFavtTeamReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmSFButtonPressReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmSFDisableMonitorReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmSFYesForMonitorPopupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmSFTuneChannelReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmSFReturnChannelReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmSFAlertCloseReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmSFIconStatusReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmAudioDeleteAllConfirmReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmTWNSettingsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmTWNYesForPopupMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmTWNListSelectReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmTWNButtonPressReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmChannelLockSettingReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmChannelLockStatusReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmAudioDeleteAllFavReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmAudioSonglistReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMSettingsTestModeListReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmDTMTestModeMonitorSelReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmContextSwitchInfoUpdateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RouteGuidanceUpdateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMSpeedLockStatusUpMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMInfoUpdatedatabindingReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmFooterListIdReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmSelectedTabReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmTabListEntrySelectionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmUpdateCurrentBindingIndexMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMActiveTabUpdateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMSwitchToActiveTabMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmLaunchBarActivationResponseUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SXMStatusBarActivationResponseUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmClearAllDBdataUpdtMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmTouchReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ViewSXMActivityId, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SxmActiveRenderedViewMsg, 5);
} // namespace Courier

// ------------------------------------------------------------------------
HeaderTextDataBindingSource::HeaderTextDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HeaderTextItem)
{
}

// ------------------------------------------------------------------------
AudioMuteInfoDataBindingSource::AudioMuteInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::AudioMuteInfoItem)
{
}

// ------------------------------------------------------------------------
SxmTabControlListDataBindingSource::SxmTabControlListDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmTabControlListItem)
{
}

// ------------------------------------------------------------------------
SxmSpeedLockUpdateForListItemScrollDataBindingSource::SxmSpeedLockUpdateForListItemScrollDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmSpeedLockUpdateForListItemScrollItem)
{
}

// ------------------------------------------------------------------------
SxmAudioFavArtistSongTeamListDataBindingSource::SxmAudioFavArtistSongTeamListDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmAudioFavArtistSongTeamListItem)
{
}

// ------------------------------------------------------------------------
SxmUpdateFooterDataBindingSource::SxmUpdateFooterDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmUpdateFooterItem)
{
}

// ------------------------------------------------------------------------
SxmPopupInfoDataBindingSource::SxmPopupInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmPopupInfoItem)
{
}

// ------------------------------------------------------------------------
SxmPresetListDataBindingSource::SxmPresetListDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmPresetListItem)
{
}

// ------------------------------------------------------------------------
SxmAudioLoadingInfoDataBindingSource::SxmAudioLoadingInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmAudioLoadingInfoItem)
{
}

// ------------------------------------------------------------------------
SxmAudioModeDataBindingSource::SxmAudioModeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmAudioModeItem)
{
}

// ------------------------------------------------------------------------
SxmAudioMaintextAnimationDataBindingSource::SxmAudioMaintextAnimationDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmAudioMaintextAnimationItem)
{
}

// ------------------------------------------------------------------------
SxmAudioTuneScanDataBindingSource::SxmAudioTuneScanDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmAudioTuneScanItem)
{
}

// ------------------------------------------------------------------------
SxmMenuListDataBindingSource::SxmMenuListDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmMenuListItem)
{
}

// ------------------------------------------------------------------------
SxmMenuItemDataBindingSource::SxmMenuItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmMenuItemItem)
{
}

// ------------------------------------------------------------------------
SxmChannelInfoDataBindingSource::SxmChannelInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmChannelInfoItem)
{
}

// ------------------------------------------------------------------------
SxmTpopChannelInfoDataBindingSource::SxmTpopChannelInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmTpopChannelInfoItem)
{
}

// ------------------------------------------------------------------------
SxmGadgetChannelInfoDataBindingSource::SxmGadgetChannelInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmGadgetChannelInfoItem)
{
}

// ------------------------------------------------------------------------
SxmAudioInfoForPopupDataBindingSource::SxmAudioInfoForPopupDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmAudioInfoForPopupItem)
{
}

// ------------------------------------------------------------------------
SxmActivePresetBankDataBindingSource::SxmActivePresetBankDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmActivePresetBankItem)
{
}

// ------------------------------------------------------------------------
SxmCategoriesListDataBindingSource::SxmCategoriesListDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmCategoriesListItem)
{
}

// ------------------------------------------------------------------------
SxmChannelLogoDataBindingSource::SxmChannelLogoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmChannelLogoItem)
{
}

// ------------------------------------------------------------------------
SxmAudioPresetControlDataBindingSource::SxmAudioPresetControlDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmAudioPresetControlItem)
{
}

// ------------------------------------------------------------------------
SxmAudioPlayPauseDataBindingSource::SxmAudioPlayPauseDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmAudioPlayPauseItem)
{
}

// ------------------------------------------------------------------------
SxmAudioAlertSettingDataBindingSource::SxmAudioAlertSettingDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmAudioAlertSettingItem)
{
}

// ------------------------------------------------------------------------
SxmAudioFavAlertButtonEnableDataBindingSource::SxmAudioFavAlertButtonEnableDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmAudioFavAlertButtonEnableItem)
{
}

// ------------------------------------------------------------------------
SxmAudioAlertFavtUpdatePopupDataBindingSource::SxmAudioAlertFavtUpdatePopupDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmAudioAlertFavtUpdatePopupItem)
{
}

// ------------------------------------------------------------------------
SxmPresetItemDataBindingSource::SxmPresetItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmPresetItemItem)
{
}

// ------------------------------------------------------------------------
SxmAudioChannelListDataBindingSource::SxmAudioChannelListDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmAudioChannelListItem)
{
}

// ------------------------------------------------------------------------
SxmAudioSubScreenHeaderTextDataBindingSource::SxmAudioSubScreenHeaderTextDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmAudioSubScreenHeaderTextItem)
{
}

// ------------------------------------------------------------------------
SxmAudioFavoriteArtistDataBindingSource::SxmAudioFavoriteArtistDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmAudioFavoriteArtistItem)
{
}

// ------------------------------------------------------------------------
SxmAudioFavoriteSongDataBindingSource::SxmAudioFavoriteSongDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmAudioFavoriteSongItem)
{
}

// ------------------------------------------------------------------------
SxmLeagueOrReplaceListDataBindingSource::SxmLeagueOrReplaceListDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmLeagueOrReplaceListItem)
{
}

// ------------------------------------------------------------------------
SxmInfoButtonEnableDataBindingSource::SxmInfoButtonEnableDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmInfoButtonEnableItem)
{
}

// ------------------------------------------------------------------------
SxmAudioReplayContentDataBindingSource::SxmAudioReplayContentDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmAudioReplayContentItem)
{
}

// ------------------------------------------------------------------------
SXMAudioCustomizeChannelDataBindingSource::SXMAudioCustomizeChannelDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SXMAudioCustomizeChannelItem)
{
}

// ------------------------------------------------------------------------
SXMAudioCustomizeChannelListItemDataBindingSource::SXMAudioCustomizeChannelListItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SXMAudioCustomizeChannelListItemItem)
{
}

// ------------------------------------------------------------------------
SxmAudioDirectTuneTextInfoDataBindingSource::SxmAudioDirectTuneTextInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmAudioDirectTuneTextInfoItem)
{
}

// ------------------------------------------------------------------------
SxmAudioDirectTuneKeyPressInfoDataBindingSource::SxmAudioDirectTuneKeyPressInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmAudioDirectTuneKeyPressInfoItem)
{
}

// ------------------------------------------------------------------------
SpellerDeleteBtnStateDataBindingSource::SpellerDeleteBtnStateDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SpellerDeleteBtnStateItem)
{
}

// ------------------------------------------------------------------------
SxmAudioChannelNotAvailablePopupDataBindingSource::SxmAudioChannelNotAvailablePopupDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmAudioChannelNotAvailablePopupItem)
{
}

// ------------------------------------------------------------------------
SxmAudioChannelNotSubscribedPopupDataBindingSource::SxmAudioChannelNotSubscribedPopupDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmAudioChannelNotSubscribedPopupItem)
{
}

// ------------------------------------------------------------------------
SxmAudioTuneStartDataBindingSource::SxmAudioTuneStartDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmAudioTuneStartItem)
{
}

// ------------------------------------------------------------------------
SxmAudioScanDataBindingSource::SxmAudioScanDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmAudioScanItem)
{
}

// ------------------------------------------------------------------------
SxmAudioSportsFlashTeamNamePopupDataBindingSource::SxmAudioSportsFlashTeamNamePopupDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmAudioSportsFlashTeamNamePopupItem)
{
}

// ------------------------------------------------------------------------
SxmAudioSportsFlashAlertAdvisoryDataBindingSource::SxmAudioSportsFlashAlertAdvisoryDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmAudioSportsFlashAlertAdvisoryItem)
{
}

// ------------------------------------------------------------------------
SXMAudioSportsflashAlertDataBindingSource::SXMAudioSportsflashAlertDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SXMAudioSportsflashAlertItem)
{
}

// ------------------------------------------------------------------------
SXMAudioSportsflashListItemAlertDataBindingSource::SXMAudioSportsflashListItemAlertDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SXMAudioSportsflashListItemAlertItem)
{
}

// ------------------------------------------------------------------------
SXMAudioSportsflashFavAdvisoryDataBindingSource::SXMAudioSportsflashFavAdvisoryDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SXMAudioSportsflashFavAdvisoryItem)
{
}

// ------------------------------------------------------------------------
SxmAudioSportsflashEnableDataBindingSource::SxmAudioSportsflashEnableDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmAudioSportsflashEnableItem)
{
}

// ------------------------------------------------------------------------
SxmAudioMenuChannelLockDataBindingSource::SxmAudioMenuChannelLockDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmAudioMenuChannelLockItem)
{
}

// ------------------------------------------------------------------------
SxmAudioCustomizeButtonDataBindingSource::SxmAudioCustomizeButtonDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmAudioCustomizeButtonItem)
{
}

// ------------------------------------------------------------------------
SXMAudioTWNDataBindingSource::SXMAudioTWNDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SXMAudioTWNItem)
{
}

// ------------------------------------------------------------------------
SXMAudioTWNNoInfoDataBindingSource::SXMAudioTWNNoInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SXMAudioTWNNoInfoItem)
{
}

// ------------------------------------------------------------------------
SXTWNButtonDataBindingSource::SXTWNButtonDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SXTWNButtonItem)
{
}

// ------------------------------------------------------------------------
SXMSFButtonDataBindingSource::SXMSFButtonDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SXMSFButtonItem)
{
}

// ------------------------------------------------------------------------
SxmSFTunePopupDataBindingSource::SxmSFTunePopupDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmSFTunePopupItem)
{
}

// ------------------------------------------------------------------------
SxmAudioSliderConfDataBindingSource::SxmAudioSliderConfDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmAudioSliderConfItem)
{
}

// ------------------------------------------------------------------------
SxmSettingTestmodeUpdatePopupDataBindingSource::SxmSettingTestmodeUpdatePopupDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmSettingTestmodeUpdatePopupItem)
{
}

// ------------------------------------------------------------------------
SxmSettingTestmodeExternalDiagDataBindingSource::SxmSettingTestmodeExternalDiagDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmSettingTestmodeExternalDiagItem)
{
}

// ------------------------------------------------------------------------
SxmAudioContentAlertDataBindingSource::SxmAudioContentAlertDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmAudioContentAlertItem)
{
}

// ------------------------------------------------------------------------
SxmFavtUpdatePopupDataBindingSource::SxmFavtUpdatePopupDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmFavtUpdatePopupItem)
{
}

// ------------------------------------------------------------------------
SxmFavtDeletePopupDataBindingSource::SxmFavtDeletePopupDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmFavtDeletePopupItem)
{
}

// ------------------------------------------------------------------------
SxmApplicationStateDataBindingSource::SxmApplicationStateDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SxmApplicationStateItem)
{
}

// ------------------------------------------------------------------------
ListScrollBarInfoDataBindingSource::ListScrollBarInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ListScrollBarInfoItem)
{
}

// ------------------------------------------------------------------------
CarModeVisibilityDataBindingSource::CarModeVisibilityDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::CarModeVisibilityItem)
{
}

typedef void InvalidData;
struct InvalidDataBindingSource {
    static const ::FeatStd::UInt32 cHierarchyNodeCount = 1;
};

// table of shared DataItemDescriptor
static const ::Courier::Internal::DataBinding::DataItemDescriptor gItemDesc[cDataItemDescriptorCount] = {
    {   // 0 - ::InvalidData
        COURIER_DATA_ITEM_TYPE_ID(::InvalidData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 1 - ::HeaderTextData
        COURIER_DATA_ITEM_TYPE_ID(::HeaderTextData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 2 - ::HeaderTextData::mHeaderText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::HeaderTextData, mHeaderText)
    },
    {   // 3 - ::HeaderTextData::mVisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::HeaderTextData, mVisible)
    },
    {   // 4 - ::AudioMuteInfoData
        COURIER_DATA_ITEM_TYPE_ID(::AudioMuteInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 5 - ::AudioMuteInfoData::mMuteStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AudioMuteInfoData, mMuteStatus)
    },
    {   // 6 - ::SxmTabControlListData
        COURIER_DATA_ITEM_TYPE_ID(::SxmTabControlListData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 7 - ::SxmTabControlListData::mCurrentActiveTabIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::SxmTabControlListData, mCurrentActiveTabIndex)
    },
    {   // 8 - ::SxmTabControlListData::mIsTab1ButtonEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmTabControlListData, mIsTab1ButtonEnabled)
    },
    {   // 9 - ::SxmTabControlListData::mIsTab2ButtonEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmTabControlListData, mIsTab2ButtonEnabled)
    },
    {   // 10 - ::SxmTabControlListData::mIsTab3ButtonEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmTabControlListData, mIsTab3ButtonEnabled)
    },
    {   // 11 - ::SxmTabControlListData::mIsTab4ButtonEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmTabControlListData, mIsTab4ButtonEnabled)
    },
    {   // 12 - ::SxmTabControlListData::mIsTab1ButtonActive
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmTabControlListData, mIsTab1ButtonActive)
    },
    {   // 13 - ::SxmTabControlListData::mIsTab2ButtonActive
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmTabControlListData, mIsTab2ButtonActive)
    },
    {   // 14 - ::SxmTabControlListData::mIsTab3ButtonActive
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmTabControlListData, mIsTab3ButtonActive)
    },
    {   // 15 - ::SxmTabControlListData::mIsTab4ButtonActive
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmTabControlListData, mIsTab4ButtonActive)
    },
    {   // 16 - ::SxmTabControlListData::mTab1ButtonNameText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmTabControlListData, mTab1ButtonNameText)
    },
    {   // 17 - ::SxmTabControlListData::mTab2ButtonNameText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmTabControlListData, mTab2ButtonNameText)
    },
    {   // 18 - ::SxmTabControlListData::mTab3ButtonNameText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmTabControlListData, mTab3ButtonNameText)
    },
    {   // 19 - ::SxmTabControlListData::mTab4ButtonNameText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmTabControlListData, mTab4ButtonNameText)
    },
    {   // 20 - ::SxmTabControlListData::mHeaderText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmTabControlListData, mHeaderText)
    },
    {   // 21 - ::SxmTabControlListData::mCurrentServiceHeaderIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::SxmTabControlListData, mCurrentServiceHeaderIndex)
    },
    {   // 22 - ::SxmTabControlListData::mTab3BtnSwitchIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::SxmTabControlListData, mTab3BtnSwitchIndex)
    },
    {   // 23 - ::SxmSpeedLockUpdateForListItemScrollData
        COURIER_DATA_ITEM_TYPE_ID(::SxmSpeedLockUpdateForListItemScrollData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 24 - ::SxmSpeedLockUpdateForListItemScrollData::misFocusGain
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmSpeedLockUpdateForListItemScrollData, misFocusGain)
    },
    {   // 25 - ::SxmAudioFavArtistSongTeamListData
        COURIER_DATA_ITEM_TYPE_ID(::SxmAudioFavArtistSongTeamListData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 26 - ::SxmAudioFavArtistSongTeamListData::mOnOrOff
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmAudioFavArtistSongTeamListData, mOnOrOff)
    },
    {   // 27 - ::SxmAudioFavArtistSongTeamListData::mFavName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioFavArtistSongTeamListData, mFavName)
    },
    {   // 28 - ::SxmUpdateFooterData
        COURIER_DATA_ITEM_TYPE_ID(::SxmUpdateFooterData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 29 - ::SxmUpdateFooterData::mFocusedIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmUpdateFooterData, mFocusedIndex)
    },
    {   // 30 - ::SxmUpdateFooterData::mTotalCount
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmUpdateFooterData, mTotalCount)
    },
    {   // 31 - ::SxmUpdateFooterData::mFooterVisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmUpdateFooterData, mFooterVisible)
    },
    {   // 32 - ::SxmPopupInfoData
        COURIER_DATA_ITEM_TYPE_ID(::SxmPopupInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 33 - ::SxmPopupInfoData::mPopupVisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmPopupInfoData, mPopupVisible)
    },
    {   // 34 - ::SxmPresetListData
        COURIER_DATA_ITEM_TYPE_ID(::SxmPresetListData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 35 - ::SxmPresetListData::mBtnListLeftEnable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmPresetListData, mBtnListLeftEnable)
    },
    {   // 36 - ::SxmPresetListData::mBtnListRightEnable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmPresetListData, mBtnListRightEnable)
    },
    {   // 37 - ::SxmPresetListData::mPageIndicator
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::SxmPresetListData, mPageIndicator)
    },
    {   // 38 - ::SxmAudioLoadingInfoData
        COURIER_DATA_ITEM_TYPE_ID(::SxmAudioLoadingInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 39 - ::SxmAudioLoadingInfoData::mLoad1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioLoadingInfoData, mLoad1)
    },
    {   // 40 - ::SxmAudioLoadingInfoData::mLoad2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioLoadingInfoData, mLoad2)
    },
    {   // 41 - ::SxmAudioLoadingInfoData::mLoad3
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioLoadingInfoData, mLoad3)
    },
    {   // 42 - ::SxmAudioLoadingInfoData::mLoad4
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioLoadingInfoData, mLoad4)
    },
    {   // 43 - ::SxmAudioModeData
        COURIER_DATA_ITEM_TYPE_ID(::SxmAudioModeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 44 - ::SxmAudioModeData::mScan1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioModeData, mScan1)
    },
    {   // 45 - ::SxmAudioModeData::mScan2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioModeData, mScan2)
    },
    {   // 46 - ::SxmAudioModeData::mScan3
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioModeData, mScan3)
    },
    {   // 47 - ::SxmAudioModeData::mScan4
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioModeData, mScan4)
    },
    {   // 48 - ::SxmAudioMaintextAnimationData
        COURIER_DATA_ITEM_TYPE_ID(::SxmAudioMaintextAnimationData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 49 - ::SxmAudioMaintextAnimationData::mshouldrun
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmAudioMaintextAnimationData, mshouldrun)
    },
    {   // 50 - ::SxmAudioMaintextAnimationData::mtextInformation
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioMaintextAnimationData, mtextInformation)
    },
    {   // 51 - ::SxmAudioTuneScanData
        COURIER_DATA_ITEM_TYPE_ID(::SxmAudioTuneScanData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 52 - ::SxmAudioTuneScanData::mEnable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmAudioTuneScanData, mEnable)
    },
    {   // 53 - ::SxmMenuListData
        COURIER_DATA_ITEM_TYPE_ID(::SxmMenuListData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 54 - ::SxmMenuListData::mSxmMenuLogo
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::SxmMenuListData, mSxmMenuLogo)
    },
    {   // 55 - ::SxmMenuListData::mEnable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmMenuListData, mEnable)
    },
    {   // 56 - ::SxmMenuListData::mMenuText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmMenuListData, mMenuText)
    },
    {   // 57 - ::SxmMenuListData::mSignalQuality
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmMenuListData, mSignalQuality)
    },
    {   // 58 - ::SxmMenuListData::mTuneScanChoice
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmMenuListData, mTuneScanChoice)
    },
    {   // 59 - ::SxmMenuItemData
        COURIER_DATA_ITEM_TYPE_ID(::SxmMenuItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 60 - ::SxmMenuItemData::mArtistEnable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmMenuItemData, mArtistEnable)
    },
    {   // 61 - ::SxmMenuItemData::mSongEnable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmMenuItemData, mSongEnable)
    },
    {   // 62 - ::SxmChannelInfoData
        COURIER_DATA_ITEM_TYPE_ID(::SxmChannelInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 63 - ::SxmChannelInfoData::mChannelID
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmChannelInfoData, mChannelID)
    },
    {   // 64 - ::SxmChannelInfoData::mCategoryName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmChannelInfoData, mCategoryName)
    },
    {   // 65 - ::SxmChannelInfoData::mArtistName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmChannelInfoData, mArtistName)
    },
    {   // 66 - ::SxmChannelInfoData::mSongTitle
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmChannelInfoData, mSongTitle)
    },
    {   // 67 - ::SxmChannelInfoData::mPresetNumber
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmChannelInfoData, mPresetNumber)
    },
    {   // 68 - ::SxmChannelInfoData::mChannelName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmChannelInfoData, mChannelName)
    },
    {   // 69 - ::SxmChannelInfoData::mSxmCG
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::SxmChannelInfoData, mSxmCG)
    },
    {   // 70 - ::SxmChannelInfoData::mSxmCGVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmChannelInfoData, mSxmCGVisibility)
    },
    {   // 71 - ::SxmChannelInfoData::mSxmAlbumart
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::SxmChannelInfoData, mSxmAlbumart)
    },
    {   // 72 - ::SxmChannelInfoData::mSxmAlbumartVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmChannelInfoData, mSxmAlbumartVisibility)
    },
    {   // 73 - ::SxmChannelInfoData::mPresetNumberVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmChannelInfoData, mPresetNumberVisibility)
    },
    {   // 74 - ::SxmChannelInfoData::mAdvisoryMessage
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmChannelInfoData, mAdvisoryMessage)
    },
    {   // 75 - ::SxmChannelInfoData::mAdvisoryMessageVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmChannelInfoData, mAdvisoryMessageVisibility)
    },
    {   // 76 - ::SxmChannelInfoData::mStatusLineTextorIcon
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmChannelInfoData, mStatusLineTextorIcon)
    },
    {   // 77 - ::SxmChannelInfoData::mPresetNumberForGadget
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmChannelInfoData, mPresetNumberForGadget)
    },
    {   // 78 - ::SxmChannelInfoData::mSxmInitialized
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmChannelInfoData, mSxmInitialized)
    },
    {   // 79 - ::SxmTpopChannelInfoData
        COURIER_DATA_ITEM_TYPE_ID(::SxmTpopChannelInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 80 - ::SxmTpopChannelInfoData::mChannelID
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmTpopChannelInfoData, mChannelID)
    },
    {   // 81 - ::SxmTpopChannelInfoData::mChannelName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmTpopChannelInfoData, mChannelName)
    },
    {   // 82 - ::SxmGadgetChannelInfoData
        COURIER_DATA_ITEM_TYPE_ID(::SxmGadgetChannelInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 83 - ::SxmGadgetChannelInfoData::mAdvisoryMessage
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmGadgetChannelInfoData, mAdvisoryMessage)
    },
    {   // 84 - ::SxmGadgetChannelInfoData::mAdvisoryMessageVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmGadgetChannelInfoData, mAdvisoryMessageVisibility)
    },
    {   // 85 - ::SxmGadgetChannelInfoData::mSxmInitialized
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmGadgetChannelInfoData, mSxmInitialized)
    },
    {   // 86 - ::SxmAudioInfoForPopupData
        COURIER_DATA_ITEM_TYPE_ID(::SxmAudioInfoForPopupData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 87 - ::SxmAudioInfoForPopupData::mChannelNumber
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioInfoForPopupData, mChannelNumber)
    },
    {   // 88 - ::SxmAudioInfoForPopupData::mChannelName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioInfoForPopupData, mChannelName)
    },
    {   // 89 - ::SxmAudioInfoForPopupData::mArtistName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioInfoForPopupData, mArtistName)
    },
    {   // 90 - ::SxmAudioInfoForPopupData::mSongName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioInfoForPopupData, mSongName)
    },
    {   // 91 - ::SxmAudioInfoForPopupData::mChannelLocked
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioInfoForPopupData, mChannelLocked)
    },
    {   // 92 - ::SxmAudioInfoForPopupData::mChannelMature
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioInfoForPopupData, mChannelMature)
    },
    {   // 93 - ::SxmAudioInfoForPopupData::mChannelNotAvailable
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioInfoForPopupData, mChannelNotAvailable)
    },
    {   // 94 - ::SxmAudioInfoForPopupData::mChannelNotSubscribed
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioInfoForPopupData, mChannelNotSubscribed)
    },
    {   // 95 - ::SxmActivePresetBankData
        COURIER_DATA_ITEM_TYPE_ID(::SxmActivePresetBankData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 96 - ::SxmActivePresetBankData::mActivePresetBank
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmActivePresetBankData, mActivePresetBank)
    },
    {   // 97 - ::SxmCategoriesListData
        COURIER_DATA_ITEM_TYPE_ID(::SxmCategoriesListData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 98 - ::SxmCategoriesListData::mCategoryName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmCategoriesListData, mCategoryName)
    },
    {   // 99 - ::SxmCategoriesListData::mCurrentCategory
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmCategoriesListData, mCurrentCategory)
    },
    {   // 100 - ::SxmChannelLogoData
        COURIER_DATA_ITEM_TYPE_ID(::SxmChannelLogoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 101 - ::SxmChannelLogoData::mImageSize
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::SxmChannelLogoData, mImageSize)
    },
    {   // 102 - ::SxmChannelLogoData::mSxmCGLogo
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::SxmChannelLogoData, mSxmCGLogo)
    },
    {   // 103 - ::SxmAudioPresetControlData
        COURIER_DATA_ITEM_TYPE_ID(::SxmAudioPresetControlData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 104 - ::SxmAudioPresetControlData::mSwitchPresetOrCtrlButton
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmAudioPresetControlData, mSwitchPresetOrCtrlButton)
    },
    {   // 105 - ::SxmAudioPresetControlData::mEnabilityPresetOrCtrlButton
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmAudioPresetControlData, mEnabilityPresetOrCtrlButton)
    },
    {   // 106 - ::SxmAudioPresetControlData::mSwitchPresetOrCtrlOrScan
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::SxmAudioPresetControlData, mSwitchPresetOrCtrlOrScan)
    },
    {   // 107 - ::SxmAudioPresetControlData::mDefaultFocus
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::SxmAudioPresetControlData, mDefaultFocus)
    },
    {   // 108 - ::SxmAudioPresetControlData::mLapFocus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmAudioPresetControlData, mLapFocus)
    },
    {   // 109 - ::SxmAudioPlayPauseData
        COURIER_DATA_ITEM_TYPE_ID(::SxmAudioPlayPauseData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 110 - ::SxmAudioPlayPauseData::mPlayOrPause
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmAudioPlayPauseData, mPlayOrPause)
    },
    {   // 111 - ::SxmAudioAlertSettingData
        COURIER_DATA_ITEM_TYPE_ID(::SxmAudioAlertSettingData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 112 - ::SxmAudioAlertSettingData::mAlertText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioAlertSettingData, mAlertText)
    },
    {   // 113 - ::SxmAudioAlertSettingData::mOnOrOff
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmAudioAlertSettingData, mOnOrOff)
    },
    {   // 114 - ::SxmAudioFavAlertButtonEnableData
        COURIER_DATA_ITEM_TYPE_ID(::SxmAudioFavAlertButtonEnableData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 115 - ::SxmAudioFavAlertButtonEnableData::mEnable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmAudioFavAlertButtonEnableData, mEnable)
    },
    {   // 116 - ::SxmAudioAlertFavtUpdatePopupData
        COURIER_DATA_ITEM_TYPE_ID(::SxmAudioAlertFavtUpdatePopupData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 117 - ::SxmAudioAlertFavtUpdatePopupData::mTextType
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioAlertFavtUpdatePopupData, mTextType)
    },
    {   // 118 - ::SxmAudioAlertFavtUpdatePopupData::mTextChInfo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioAlertFavtUpdatePopupData, mTextChInfo)
    },
    {   // 119 - ::SxmAudioAlertFavtUpdatePopupData::mTextDetailInfo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioAlertFavtUpdatePopupData, mTextDetailInfo)
    },
    {   // 120 - ::SxmAudioAlertFavtUpdatePopupData::mAlertIcon
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::SxmAudioAlertFavtUpdatePopupData, mAlertIcon)
    },
    {   // 121 - ::SxmAudioAlertFavtUpdatePopupData::misRegionTextAllowed
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmAudioAlertFavtUpdatePopupData, misRegionTextAllowed)
    },
    {   // 122 - ::SxmPresetItemData
        COURIER_DATA_ITEM_TYPE_ID(::SxmPresetItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 123 - ::SxmPresetItemData::mChannelNo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmPresetItemData, mChannelNo)
    },
    {   // 124 - ::SxmPresetItemData::mPresetNo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmPresetItemData, mPresetNo)
    },
    {   // 125 - ::SxmPresetItemData::mIsSmartFav
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmPresetItemData, mIsSmartFav)
    },
    {   // 126 - ::SxmPresetItemData::mSxmLogo
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::SxmPresetItemData, mSxmLogo)
    },
    {   // 127 - ::SxmPresetItemData::mIsEnable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmPresetItemData, mIsEnable)
    },
    {   // 128 - ::SxmPresetItemData::mIsSelected
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::SxmPresetItemData, mIsSelected)
    },
    {   // 129 - ::SxmAudioChannelListData
        COURIER_DATA_ITEM_TYPE_ID(::SxmAudioChannelListData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 130 - ::SxmAudioChannelListData::mChannelNumber
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioChannelListData, mChannelNumber)
    },
    {   // 131 - ::SxmAudioChannelListData::mSxmLogo
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::SxmAudioChannelListData, mSxmLogo)
    },
    {   // 132 - ::SxmAudioChannelListData::mChannelName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioChannelListData, mChannelName)
    },
    {   // 133 - ::SxmAudioChannelListData::mArtist
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioChannelListData, mArtist)
    },
    {   // 134 - ::SxmAudioChannelListData::mSong
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioChannelListData, mSong)
    },
    {   // 135 - ::SxmAudioChannelListData::mCurrentPlay
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmAudioChannelListData, mCurrentPlay)
    },
    {   // 136 - ::SxmAudioSubScreenHeaderTextData
        COURIER_DATA_ITEM_TYPE_ID(::SxmAudioSubScreenHeaderTextData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 137 - ::SxmAudioSubScreenHeaderTextData::mIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::SxmAudioSubScreenHeaderTextData, mIndex)
    },
    {   // 138 - ::SxmAudioFavoriteArtistData
        COURIER_DATA_ITEM_TYPE_ID(::SxmAudioFavoriteArtistData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 139 - ::SxmAudioFavoriteArtistData::mSwitchArtistOnOrOffOrDelete
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::SxmAudioFavoriteArtistData, mSwitchArtistOnOrOffOrDelete)
    },
    {   // 140 - ::SxmAudioFavoriteSongData
        COURIER_DATA_ITEM_TYPE_ID(::SxmAudioFavoriteSongData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 141 - ::SxmAudioFavoriteSongData::mSwitchSongtOnOrOffOrDelete
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::SxmAudioFavoriteSongData, mSwitchSongtOnOrOffOrDelete)
    },
    {   // 142 - ::SxmLeagueOrReplaceListData
        COURIER_DATA_ITEM_TYPE_ID(::SxmLeagueOrReplaceListData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 143 - ::SxmLeagueOrReplaceListData::mText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmLeagueOrReplaceListData, mText)
    },
    {   // 144 - ::SxmLeagueOrReplaceListData::mIsEnable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmLeagueOrReplaceListData, mIsEnable)
    },
    {   // 145 - ::SxmInfoButtonEnableData
        COURIER_DATA_ITEM_TYPE_ID(::SxmInfoButtonEnableData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 146 - ::SxmInfoButtonEnableData::mEnable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmInfoButtonEnableData, mEnable)
    },
    {   // 147 - ::SxmAudioReplayContentData
        COURIER_DATA_ITEM_TYPE_ID(::SxmAudioReplayContentData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 148 - ::SxmAudioReplayContentData::mActiveReplayMode
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioReplayContentData, mActiveReplayMode)
    },
    {   // 149 - ::SxmAudioReplayContentData::mReplayOrScan
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmAudioReplayContentData, mReplayOrScan)
    },
    {   // 150 - ::SxmAudioReplayContentData::mReplayModeTextVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmAudioReplayContentData, mReplayModeTextVisibility)
    },
    {   // 151 - ::SxmAudioReplayContentData::mTimeToLive
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioReplayContentData, mTimeToLive)
    },
    {   // 152 - ::SxmAudioReplayContentData::mPlayEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmAudioReplayContentData, mPlayEnabled)
    },
    {   // 153 - ::SxmAudioReplayContentData::mPauseEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmAudioReplayContentData, mPauseEnabled)
    },
    {   // 154 - ::SxmAudioReplayContentData::mSkipBackEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmAudioReplayContentData, mSkipBackEnabled)
    },
    {   // 155 - ::SxmAudioReplayContentData::mRewindEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmAudioReplayContentData, mRewindEnabled)
    },
    {   // 156 - ::SxmAudioReplayContentData::mFastForwardEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmAudioReplayContentData, mFastForwardEnabled)
    },
    {   // 157 - ::SxmAudioReplayContentData::mForwardEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmAudioReplayContentData, mForwardEnabled)
    },
    {   // 158 - ::SXMAudioCustomizeChannelData
        COURIER_DATA_ITEM_TYPE_ID(::SXMAudioCustomizeChannelData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 159 - ::SXMAudioCustomizeChannelData::mSwitchClearOrSelect
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::SXMAudioCustomizeChannelData, mSwitchClearOrSelect)
    },
    {   // 160 - ::SXMAudioCustomizeChannelListItemData
        COURIER_DATA_ITEM_TYPE_ID(::SXMAudioCustomizeChannelListItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 161 - ::SXMAudioCustomizeChannelListItemData::mChannelNumber
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SXMAudioCustomizeChannelListItemData, mChannelNumber)
    },
    {   // 162 - ::SXMAudioCustomizeChannelListItemData::mChannelName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SXMAudioCustomizeChannelListItemData, mChannelName)
    },
    {   // 163 - ::SXMAudioCustomizeChannelListItemData::mIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::SXMAudioCustomizeChannelListItemData, mIndex)
    },
    {   // 164 - ::SXMAudioCustomizeChannelListItemData::mEnable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SXMAudioCustomizeChannelListItemData, mEnable)
    },
    {   // 165 - ::SXMAudioCustomizeChannelListItemData::mVisiblity
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SXMAudioCustomizeChannelListItemData, mVisiblity)
    },
    {   // 166 - ::SXMAudioCustomizeChannelListItemData::mSxmLogo
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::SXMAudioCustomizeChannelListItemData, mSxmLogo)
    },
    {   // 167 - ::SxmAudioDirectTuneTextInfoData
        COURIER_DATA_ITEM_TYPE_ID(::SxmAudioDirectTuneTextInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 168 - ::SxmAudioDirectTuneTextInfoData::mEditorText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioDirectTuneTextInfoData, mEditorText)
    },
    {   // 169 - ::SxmAudioDirectTuneTextInfoData::mOkButtonEnability
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmAudioDirectTuneTextInfoData, mOkButtonEnability)
    },
    {   // 170 - ::SxmAudioDirectTuneTextInfoData::mIsMaxCharReached
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmAudioDirectTuneTextInfoData, mIsMaxCharReached)
    },
    {   // 171 - ::SxmAudioDirectTuneKeyPressInfoData
        COURIER_DATA_ITEM_TYPE_ID(::SxmAudioDirectTuneKeyPressInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 172 - ::SxmAudioDirectTuneKeyPressInfoData::mKeyPressed
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioDirectTuneKeyPressInfoData, mKeyPressed)
    },
    {   // 173 - ::SpellerDeleteBtnStateData
        COURIER_DATA_ITEM_TYPE_ID(::SpellerDeleteBtnStateData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 174 - ::SpellerDeleteBtnStateData::mIsEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SpellerDeleteBtnStateData, mIsEnabled)
    },
    {   // 175 - ::SxmAudioChannelNotAvailablePopupData
        COURIER_DATA_ITEM_TYPE_ID(::SxmAudioChannelNotAvailablePopupData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 176 - ::SxmAudioChannelNotAvailablePopupData::mText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioChannelNotAvailablePopupData, mText)
    },
    {   // 177 - ::SxmAudioChannelNotSubscribedPopupData
        COURIER_DATA_ITEM_TYPE_ID(::SxmAudioChannelNotSubscribedPopupData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 178 - ::SxmAudioChannelNotSubscribedPopupData::mText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioChannelNotSubscribedPopupData, mText)
    },
    {   // 179 - ::SxmAudioTuneStartData
        COURIER_DATA_ITEM_TYPE_ID(::SxmAudioTuneStartData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 180 - ::SxmAudioTuneStartData::mTuneStartOn
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmAudioTuneStartData, mTuneStartOn)
    },
    {   // 181 - ::SxmAudioScanData
        COURIER_DATA_ITEM_TYPE_ID(::SxmAudioScanData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 182 - ::SxmAudioScanData::mScanOn
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmAudioScanData, mScanOn)
    },
    {   // 183 - ::SxmAudioScanData::mScanContentAvail
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmAudioScanData, mScanContentAvail)
    },
    {   // 184 - ::SxmAudioSportsFlashTeamNamePopupData
        COURIER_DATA_ITEM_TYPE_ID(::SxmAudioSportsFlashTeamNamePopupData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 185 - ::SxmAudioSportsFlashTeamNamePopupData::mText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioSportsFlashTeamNamePopupData, mText)
    },
    {   // 186 - ::SxmAudioSportsFlashAlertAdvisoryData
        COURIER_DATA_ITEM_TYPE_ID(::SxmAudioSportsFlashAlertAdvisoryData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 187 - ::SxmAudioSportsFlashAlertAdvisoryData::mText1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioSportsFlashAlertAdvisoryData, mText1)
    },
    {   // 188 - ::SXMAudioSportsflashAlertData
        COURIER_DATA_ITEM_TYPE_ID(::SXMAudioSportsflashAlertData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 189 - ::SXMAudioSportsflashAlertData::mSwitchOnorOff
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SXMAudioSportsflashAlertData, mSwitchOnorOff)
    },
    {   // 190 - ::SXMAudioSportsflashListItemAlertData
        COURIER_DATA_ITEM_TYPE_ID(::SXMAudioSportsflashListItemAlertData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 191 - ::SXMAudioSportsflashListItemAlertData::mSwitchOnorOff
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::SXMAudioSportsflashListItemAlertData, mSwitchOnorOff)
    },
    {   // 192 - ::SXMAudioSportsflashFavAdvisoryData
        COURIER_DATA_ITEM_TYPE_ID(::SXMAudioSportsflashFavAdvisoryData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 193 - ::SXMAudioSportsflashFavAdvisoryData::mAdvisoryText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SXMAudioSportsflashFavAdvisoryData, mAdvisoryText)
    },
    {   // 194 - ::SxmAudioSportsflashEnableData
        COURIER_DATA_ITEM_TYPE_ID(::SxmAudioSportsflashEnableData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 195 - ::SxmAudioSportsflashEnableData::mEnableOn
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmAudioSportsflashEnableData, mEnableOn)
    },
    {   // 196 - ::SxmAudioMenuChannelLockData
        COURIER_DATA_ITEM_TYPE_ID(::SxmAudioMenuChannelLockData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 197 - ::SxmAudioMenuChannelLockData::mOffOrOn
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmAudioMenuChannelLockData, mOffOrOn)
    },
    {   // 198 - ::SxmAudioCustomizeButtonData
        COURIER_DATA_ITEM_TYPE_ID(::SxmAudioCustomizeButtonData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 199 - ::SxmAudioCustomizeButtonData::mEnableOrDisable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmAudioCustomizeButtonData, mEnableOrDisable)
    },
    {   // 200 - ::SXMAudioTWNData
        COURIER_DATA_ITEM_TYPE_ID(::SXMAudioTWNData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 201 - ::SXMAudioTWNData::mOnOrOff
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::SXMAudioTWNData, mOnOrOff)
    },
    {   // 202 - ::SXMAudioTWNData::mCity
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SXMAudioTWNData, mCity)
    },
    {   // 203 - ::SXMAudioTWNNoInfoData
        COURIER_DATA_ITEM_TYPE_ID(::SXMAudioTWNNoInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 204 - ::SXMAudioTWNNoInfoData::mtext
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SXMAudioTWNNoInfoData, mtext)
    },
    {   // 205 - ::SXTWNButtonData
        COURIER_DATA_ITEM_TYPE_ID(::SXTWNButtonData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 206 - ::SXTWNButtonData::mTWNButton
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::SXTWNButtonData, mTWNButton)
    },
    {   // 207 - ::SXTWNButtonData::mBtnEnable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SXTWNButtonData, mBtnEnable)
    },
    {   // 208 - ::SXTWNButtonData::mAdvisoryorList
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SXTWNButtonData, mAdvisoryorList)
    },
    {   // 209 - ::SXMSFButtonData
        COURIER_DATA_ITEM_TYPE_ID(::SXMSFButtonData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 210 - ::SXMSFButtonData::mSFButton
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::SXMSFButtonData, mSFButton)
    },
    {   // 211 - ::SXMSFButtonData::mAdvisoryorList
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SXMSFButtonData, mAdvisoryorList)
    },
    {   // 212 - ::SXMSFButtonData::mBtnEnable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SXMSFButtonData, mBtnEnable)
    },
    {   // 213 - ::SxmSFTunePopupData
        COURIER_DATA_ITEM_TYPE_ID(::SxmSFTunePopupData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 214 - ::SxmSFTunePopupData::mTeams
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmSFTunePopupData, mTeams)
    },
    {   // 215 - ::SxmSFTunePopupData::mSFTextType
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmSFTunePopupData, mSFTextType)
    },
    {   // 216 - ::SxmSFTunePopupData::misRegionTextAllowed
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmSFTunePopupData, misRegionTextAllowed)
    },
    {   // 217 - ::SxmAudioSliderConfData
        COURIER_DATA_ITEM_TYPE_ID(::SxmAudioSliderConfData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 218 - ::SxmAudioSliderConfData::mSliderValue
        COURIER_DATA_ITEM_TYPE_ID(Candera::Float),
        COURIER_ITEM_MEMBER(::SxmAudioSliderConfData, mSliderValue)
    },
    {   // 219 - ::SxmAudioSliderConfData::mBufferValue
        COURIER_DATA_ITEM_TYPE_ID(Candera::Float),
        COURIER_ITEM_MEMBER(::SxmAudioSliderConfData, mBufferValue)
    },
    {   // 220 - ::SxmSettingTestmodeUpdatePopupData
        COURIER_DATA_ITEM_TYPE_ID(::SxmSettingTestmodeUpdatePopupData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 221 - ::SxmSettingTestmodeUpdatePopupData::mText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmSettingTestmodeUpdatePopupData, mText)
    },
    {   // 222 - ::SxmSettingTestmodeExternalDiagData
        COURIER_DATA_ITEM_TYPE_ID(::SxmSettingTestmodeExternalDiagData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 223 - ::SxmSettingTestmodeExternalDiagData::mExternOnorOff
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmSettingTestmodeExternalDiagData, mExternOnorOff)
    },
    {   // 224 - ::SxmAudioContentAlertData
        COURIER_DATA_ITEM_TYPE_ID(::SxmAudioContentAlertData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 225 - ::SxmAudioContentAlertData::mAdvisoryMessage
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmAudioContentAlertData, mAdvisoryMessage)
    },
    {   // 226 - ::SxmAudioContentAlertData::mAdvisoryorList
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmAudioContentAlertData, mAdvisoryorList)
    },
    {   // 227 - ::SxmAudioContentAlertData::mAdvisoryLoading
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmAudioContentAlertData, mAdvisoryLoading)
    },
    {   // 228 - ::SxmFavtUpdatePopupData
        COURIER_DATA_ITEM_TYPE_ID(::SxmFavtUpdatePopupData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 229 - ::SxmFavtUpdatePopupData::mText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmFavtUpdatePopupData, mText)
    },
    {   // 230 - ::SxmFavtUpdatePopupData::mPopupType
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::SxmFavtUpdatePopupData, mPopupType)
    },
    {   // 231 - ::SxmFavtDeletePopupData
        COURIER_DATA_ITEM_TYPE_ID(::SxmFavtDeletePopupData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 232 - ::SxmFavtDeletePopupData::mText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SxmFavtDeletePopupData, mText)
    },
    {   // 233 - ::SxmApplicationStateData
        COURIER_DATA_ITEM_TYPE_ID(::SxmApplicationStateData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 234 - ::SxmApplicationStateData::mState
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SxmApplicationStateData, mState)
    },
    {   // 235 - ::ListScrollBarInfoData
        COURIER_DATA_ITEM_TYPE_ID(::ListScrollBarInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 236 - ::ListScrollBarInfoData::mEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ListScrollBarInfoData, mEnabled)
    },
    {   // 237 - ::CarModeVisibilityData
        COURIER_DATA_ITEM_TYPE_ID(::CarModeVisibilityData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 238 - ::CarModeVisibilityData::mVisibleStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::CarModeVisibilityData, mVisibleStatus)
    },
};

// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gInvalidHierarchyNodes[InvalidDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x00000000, /Invalid),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 0,
        /* mParentIndex        */ 0,    // ItemKey::InvalidItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 0,    // ::InvalidData
        /* mItemKey            */ 0
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gHeaderTextHierarchyNodes[HeaderTextDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5CECC8CD, /HeaderText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::HeaderTextItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 1,    // ::HeaderTextData
        /* mItemKey            */ 79
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF3FFC5A3, /HeaderText/HeaderText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::HeaderTextItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 2,    // ::HeaderTextData::mHeaderText
        /* mItemKey            */ 223
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x02AC7E72, /HeaderText/Visible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::HeaderTextItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 3,    // ::HeaderTextData::mVisible
        /* mItemKey            */ 4
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gAudioMuteInfoHierarchyNodes[AudioMuteInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x831EC93B, /AudioMuteInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::AudioMuteInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 4,    // ::AudioMuteInfoData
        /* mItemKey            */ 115
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5ABA9FBF, /AudioMuteInfo/MuteStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::AudioMuteInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 5,    // ::AudioMuteInfoData::mMuteStatus
        /* mItemKey            */ 75
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmTabControlListHierarchyNodes[SxmTabControlListDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x923DE547, /SxmTabControlList),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::SxmTabControlListItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 6,    // ::SxmTabControlListData
        /* mItemKey            */ 132
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x23598452, /SxmTabControlList/CurrentActiveTabIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::SxmTabControlListItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 7,    // ::SxmTabControlListData::mCurrentActiveTabIndex
        /* mItemKey            */ 30
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9DA215DA, /SxmTabControlList/IsTab1ButtonEnabled),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::SxmTabControlListItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 8,    // ::SxmTabControlListData::mIsTab1ButtonEnabled
        /* mItemKey            */ 140
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF4FF924D, /SxmTabControlList/IsTab2ButtonEnabled),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::SxmTabControlListItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 9,    // ::SxmTabControlListData::mIsTab2ButtonEnabled
        /* mItemKey            */ 224
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6BEC3CEF, /SxmTabControlList/IsTab3ButtonEnabled),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::SxmTabControlListItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 10,    // ::SxmTabControlListData::mIsTab3ButtonEnabled
        /* mItemKey            */ 96
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x574F25D2, /SxmTabControlList/IsTab4ButtonEnabled),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::SxmTabControlListItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 11,    // ::SxmTabControlListData::mIsTab4ButtonEnabled
        /* mItemKey            */ 72
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDBDB5F83, /SxmTabControlList/IsTab1ButtonActive),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::SxmTabControlListItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 12,    // ::SxmTabControlListData::mIsTab1ButtonActive
        /* mItemKey            */ 196
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF1B09CA0, /SxmTabControlList/IsTab2ButtonActive),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::SxmTabControlListItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 13,    // ::SxmTabControlListData::mIsTab2ButtonActive
        /* mItemKey            */ 218
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3AFB879E, /SxmTabControlList/IsTab3ButtonActive),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::SxmTabControlListItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 14,    // ::SxmTabControlListData::mIsTab3ButtonActive
        /* mItemKey            */ 55
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0CB60395, /SxmTabControlList/IsTab4ButtonActive),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::SxmTabControlListItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 15,    // ::SxmTabControlListData::mIsTab4ButtonActive
        /* mItemKey            */ 16
    },
    { // 10
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x310CA6D7, /SxmTabControlList/Tab1ButtonNameText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::SxmTabControlListItem
        /* mLocalIndex         */ 10,
        /* mDescriptorIndex    */ 16,    // ::SxmTabControlListData::mTab1ButtonNameText
        /* mItemKey            */ 41
    },
    { // 11
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE02ABFE2, /SxmTabControlList/Tab2ButtonNameText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::SxmTabControlListItem
        /* mLocalIndex         */ 11,
        /* mDescriptorIndex    */ 17,    // ::SxmTabControlListData::mTab2ButtonNameText
        /* mItemKey            */ 203
    },
    { // 12
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCAD43265, /SxmTabControlList/Tab3ButtonNameText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::SxmTabControlListItem
        /* mLocalIndex         */ 12,
        /* mDescriptorIndex    */ 18,    // ::SxmTabControlListData::mTab3ButtonNameText
        /* mItemKey            */ 180
    },
    { // 13
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7A15AE71, /SxmTabControlList/Tab4ButtonNameText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::SxmTabControlListItem
        /* mLocalIndex         */ 13,
        /* mDescriptorIndex    */ 19,    // ::SxmTabControlListData::mTab4ButtonNameText
        /* mItemKey            */ 108
    },
    { // 14
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7D4F2733, /SxmTabControlList/HeaderText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::SxmTabControlListItem
        /* mLocalIndex         */ 14,
        /* mDescriptorIndex    */ 20,    // ::SxmTabControlListData::mHeaderText
        /* mItemKey            */ 111
    },
    { // 15
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x78C69E8C, /SxmTabControlList/CurrentServiceHeaderIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::SxmTabControlListItem
        /* mLocalIndex         */ 15,
        /* mDescriptorIndex    */ 21,    // ::SxmTabControlListData::mCurrentServiceHeaderIndex
        /* mItemKey            */ 107
    },
    { // 16
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF7E9D849, /SxmTabControlList/Tab3BtnSwitchIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::SxmTabControlListItem
        /* mLocalIndex         */ 16,
        /* mDescriptorIndex    */ 22,    // ::SxmTabControlListData::mTab3BtnSwitchIndex
        /* mItemKey            */ 229
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmSpeedLockUpdateForListItemScrollHierarchyNodes[SxmSpeedLockUpdateForListItemScrollDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0F6D0B4C, /SxmSpeedLockUpdateForListItemScroll),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::SxmSpeedLockUpdateForListItemScrollItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 23,    // ::SxmSpeedLockUpdateForListItemScrollData
        /* mItemKey            */ 19
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x66628BC0, /SxmSpeedLockUpdateForListItemScroll/isFocusGain),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::SxmSpeedLockUpdateForListItemScrollItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 24,    // ::SxmSpeedLockUpdateForListItemScrollData::misFocusGain
        /* mItemKey            */ 89
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmAudioFavArtistSongTeamListHierarchyNodes[SxmAudioFavArtistSongTeamListDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x70C736A2, /SxmAudioFavArtistSongTeamList),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioFavArtistSongTeamListItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 25,    // ::SxmAudioFavArtistSongTeamListData
        /* mItemKey            */ 101
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFBB37C81, /SxmAudioFavArtistSongTeamList/OnOrOff),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioFavArtistSongTeamListItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 26,    // ::SxmAudioFavArtistSongTeamListData::mOnOrOff
        /* mItemKey            */ 237
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2B86CA3B, /SxmAudioFavArtistSongTeamList/FavName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioFavArtistSongTeamListItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 27,    // ::SxmAudioFavArtistSongTeamListData::mFavName
        /* mItemKey            */ 38
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmUpdateFooterHierarchyNodes[SxmUpdateFooterDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEBEFAFC1, /SxmUpdateFooter),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::SxmUpdateFooterItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 28,    // ::SxmUpdateFooterData
        /* mItemKey            */ 210
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9990FAF9, /SxmUpdateFooter/FocusedIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::SxmUpdateFooterItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 29,    // ::SxmUpdateFooterData::mFocusedIndex
        /* mItemKey            */ 139
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x238CA5B9, /SxmUpdateFooter/TotalCount),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::SxmUpdateFooterItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 30,    // ::SxmUpdateFooterData::mTotalCount
        /* mItemKey            */ 31
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCB010BD7, /SxmUpdateFooter/FooterVisible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::SxmUpdateFooterItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 31,    // ::SxmUpdateFooterData::mFooterVisible
        /* mItemKey            */ 181
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmPopupInfoHierarchyNodes[SxmPopupInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x923EC95F, /SxmPopupInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 7,
        /* mParentIndex        */ 0,    // ItemKey::SxmPopupInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 32,    // ::SxmPopupInfoData
        /* mItemKey            */ 133
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7B5635C3, /SxmPopupInfo/PopupVisible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 7,
        /* mParentIndex        */ 0,    // ItemKey::SxmPopupInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 33,    // ::SxmPopupInfoData::mPopupVisible
        /* mItemKey            */ 110
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmPresetListHierarchyNodes[SxmPresetListDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3B8332FA, /SxmPresetList),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 8,
        /* mParentIndex        */ 0,    // ItemKey::SxmPresetListItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 34,    // ::SxmPresetListData
        /* mItemKey            */ 56
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDBB97C5D, /SxmPresetList/BtnListLeftEnable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 8,
        /* mParentIndex        */ 0,    // ItemKey::SxmPresetListItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 35,    // ::SxmPresetListData::mBtnListLeftEnable
        /* mItemKey            */ 195
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD22FD90A, /SxmPresetList/BtnListRightEnable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 8,
        /* mParentIndex        */ 0,    // ItemKey::SxmPresetListItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 36,    // ::SxmPresetListData::mBtnListRightEnable
        /* mItemKey            */ 188
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x28B13DEC, /SxmPresetList/PageIndicator),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 8,
        /* mParentIndex        */ 0,    // ItemKey::SxmPresetListItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 37,    // ::SxmPresetListData::mPageIndicator
        /* mItemKey            */ 34
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmAudioLoadingInfoHierarchyNodes[SxmAudioLoadingInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x908F3540, /SxmAudioLoadingInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioLoadingInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 38,    // ::SxmAudioLoadingInfoData
        /* mItemKey            */ 129
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x905A4F4E, /SxmAudioLoadingInfo/Load1),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioLoadingInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 39,    // ::SxmAudioLoadingInfoData::mLoad1
        /* mItemKey            */ 128
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x78C1201C, /SxmAudioLoadingInfo/Load2),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioLoadingInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 40,    // ::SxmAudioLoadingInfoData::mLoad2
        /* mItemKey            */ 106
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6BDB8651, /SxmAudioLoadingInfo/Load3),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioLoadingInfoItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 41,    // ::SxmAudioLoadingInfoData::mLoad3
        /* mItemKey            */ 95
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x665B7B55, /SxmAudioLoadingInfo/Load4),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioLoadingInfoItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 42,    // ::SxmAudioLoadingInfoData::mLoad4
        /* mItemKey            */ 88
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmAudioModeHierarchyNodes[SxmAudioModeDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x81A7CF1C, /SxmAudioMode),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 10,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioModeItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 43,    // ::SxmAudioModeData
        /* mItemKey            */ 113
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCD7732C3, /SxmAudioMode/Scan1),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 10,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioModeItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 44,    // ::SxmAudioModeData::mScan1
        /* mItemKey            */ 184
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBB4C0E6D, /SxmAudioMode/Scan2),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 10,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioModeItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 45,    // ::SxmAudioModeData::mScan2
        /* mItemKey            */ 164
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF1B7FB44, /SxmAudioMode/Scan3),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 10,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioModeItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 46,    // ::SxmAudioModeData::mScan3
        /* mItemKey            */ 219
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDE91D4F8, /SxmAudioMode/Scan4),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 10,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioModeItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 47,    // ::SxmAudioModeData::mScan4
        /* mItemKey            */ 200
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmAudioMaintextAnimationHierarchyNodes[SxmAudioMaintextAnimationDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x62151548, /SxmAudioMaintextAnimation),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 11,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioMaintextAnimationItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 48,    // ::SxmAudioMaintextAnimationData
        /* mItemKey            */ 84
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x749A2B8D, /SxmAudioMaintextAnimation/shouldrun),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 11,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioMaintextAnimationItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 49,    // ::SxmAudioMaintextAnimationData::mshouldrun
        /* mItemKey            */ 104
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA3983430, /SxmAudioMaintextAnimation/textInformation),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 11,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioMaintextAnimationItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 50,    // ::SxmAudioMaintextAnimationData::mtextInformation
        /* mItemKey            */ 146
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmAudioTuneScanHierarchyNodes[SxmAudioTuneScanDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7B4300E8, /SxmAudioTuneScan),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 12,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioTuneScanItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 51,    // ::SxmAudioTuneScanData
        /* mItemKey            */ 109
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1ABEFB74, /SxmAudioTuneScan/Enable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 12,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioTuneScanItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 52,    // ::SxmAudioTuneScanData::mEnable
        /* mItemKey            */ 28
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmMenuListHierarchyNodes[SxmMenuListDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA77CDAC1, /SxmMenuList),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 13,
        /* mParentIndex        */ 0,    // ItemKey::SxmMenuListItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 53,    // ::SxmMenuListData
        /* mItemKey            */ 150
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCDB5D6C8, /SxmMenuList/SxmMenuLogo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 13,
        /* mParentIndex        */ 0,    // ItemKey::SxmMenuListItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 54,    // ::SxmMenuListData::mSxmMenuLogo
        /* mItemKey            */ 185
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9DC45AAB, /SxmMenuList/Enable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 13,
        /* mParentIndex        */ 0,    // ItemKey::SxmMenuListItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 55,    // ::SxmMenuListData::mEnable
        /* mItemKey            */ 141
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8FDF08BF, /SxmMenuList/MenuText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 13,
        /* mParentIndex        */ 0,    // ItemKey::SxmMenuListItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 56,    // ::SxmMenuListData::mMenuText
        /* mItemKey            */ 125
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEF49AE91, /SxmMenuList/SignalQuality),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 13,
        /* mParentIndex        */ 0,    // ItemKey::SxmMenuListItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 57,    // ::SxmMenuListData::mSignalQuality
        /* mItemKey            */ 213
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA55969C9, /SxmMenuList/TuneScanChoice),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 13,
        /* mParentIndex        */ 0,    // ItemKey::SxmMenuListItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 58,    // ::SxmMenuListData::mTuneScanChoice
        /* mItemKey            */ 148
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmMenuItemHierarchyNodes[SxmMenuItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF6ECCA62, /SxmMenuItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 14,
        /* mParentIndex        */ 0,    // ItemKey::SxmMenuItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 59,    // ::SxmMenuItemData
        /* mItemKey            */ 226
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0A3DF4E4, /SxmMenuItem/ArtistEnable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 14,
        /* mParentIndex        */ 0,    // ItemKey::SxmMenuItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 60,    // ::SxmMenuItemData::mArtistEnable
        /* mItemKey            */ 13
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x36C67091, /SxmMenuItem/SongEnable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 14,
        /* mParentIndex        */ 0,    // ItemKey::SxmMenuItemItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 61,    // ::SxmMenuItemData::mSongEnable
        /* mItemKey            */ 50
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmChannelInfoHierarchyNodes[SxmChannelInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0A2E7FE3, /SxmChannelInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 62,    // ::SxmChannelInfoData
        /* mItemKey            */ 12
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xAEA1A668, /SxmChannelInfo/ChannelID),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 63,    // ::SxmChannelInfoData::mChannelID
        /* mItemKey            */ 155
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC0693249, /SxmChannelInfo/CategoryName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 64,    // ::SxmChannelInfoData::mCategoryName
        /* mItemKey            */ 172
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1166AD4B, /SxmChannelInfo/ArtistName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 65,    // ::SxmChannelInfoData::mArtistName
        /* mItemKey            */ 23
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA57ABDA7, /SxmChannelInfo/SongTitle),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 66,    // ::SxmChannelInfoData::mSongTitle
        /* mItemKey            */ 149
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF9CFAC0A, /SxmChannelInfo/PresetNumber),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 67,    // ::SxmChannelInfoData::mPresetNumber
        /* mItemKey            */ 234
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x06EA7CCA, /SxmChannelInfo/ChannelName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 68,    // ::SxmChannelInfoData::mChannelName
        /* mItemKey            */ 9
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA9B58B14, /SxmChannelInfo/SxmCG),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 69,    // ::SxmChannelInfoData::mSxmCG
        /* mItemKey            */ 151
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE63D4ABA, /SxmChannelInfo/SxmCGVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 70,    // ::SxmChannelInfoData::mSxmCGVisibility
        /* mItemKey            */ 208
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xED3B67DF, /SxmChannelInfo/SxmAlbumart),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 71,    // ::SxmChannelInfoData::mSxmAlbumart
        /* mItemKey            */ 212
    },
    { // 10
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBA3432D1, /SxmChannelInfo/SxmAlbumartVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 10,
        /* mDescriptorIndex    */ 72,    // ::SxmChannelInfoData::mSxmAlbumartVisibility
        /* mItemKey            */ 162
    },
    { // 11
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x26162EE8, /SxmChannelInfo/PresetNumberVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 11,
        /* mDescriptorIndex    */ 73,    // ::SxmChannelInfoData::mPresetNumberVisibility
        /* mItemKey            */ 32
    },
    { // 12
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDBE22E07, /SxmChannelInfo/AdvisoryMessage),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 12,
        /* mDescriptorIndex    */ 74,    // ::SxmChannelInfoData::mAdvisoryMessage
        /* mItemKey            */ 197
    },
    { // 13
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xAAFB7CA7, /SxmChannelInfo/AdvisoryMessageVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 13,
        /* mDescriptorIndex    */ 75,    // ::SxmChannelInfoData::mAdvisoryMessageVisibility
        /* mItemKey            */ 154
    },
    { // 14
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x018FCC6C, /SxmChannelInfo/StatusLineTextorIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 14,
        /* mDescriptorIndex    */ 76,    // ::SxmChannelInfoData::mStatusLineTextorIcon
        /* mItemKey            */ 2
    },
    { // 15
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7508FBE6, /SxmChannelInfo/PresetNumberForGadget),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 15,
        /* mDescriptorIndex    */ 77,    // ::SxmChannelInfoData::mPresetNumberForGadget
        /* mItemKey            */ 105
    },
    { // 16
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFBEC37F1, /SxmChannelInfo/SxmInitialized),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelInfoItem
        /* mLocalIndex         */ 16,
        /* mDescriptorIndex    */ 78,    // ::SxmChannelInfoData::mSxmInitialized
        /* mItemKey            */ 238
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmTpopChannelInfoHierarchyNodes[SxmTpopChannelInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x37A7310A, /SxmTpopChannelInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 16,
        /* mParentIndex        */ 0,    // ItemKey::SxmTpopChannelInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 79,    // ::SxmTpopChannelInfoData
        /* mItemKey            */ 51
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x06574A17, /SxmTpopChannelInfo/ChannelID),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 16,
        /* mParentIndex        */ 0,    // ItemKey::SxmTpopChannelInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 80,    // ::SxmTpopChannelInfoData::mChannelID
        /* mItemKey            */ 7
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x671F63A6, /SxmTpopChannelInfo/ChannelName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 16,
        /* mParentIndex        */ 0,    // ItemKey::SxmTpopChannelInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 81,    // ::SxmTpopChannelInfoData::mChannelName
        /* mItemKey            */ 91
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmGadgetChannelInfoHierarchyNodes[SxmGadgetChannelInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x89F2D48F, /SxmGadgetChannelInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 17,
        /* mParentIndex        */ 0,    // ItemKey::SxmGadgetChannelInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 82,    // ::SxmGadgetChannelInfoData
        /* mItemKey            */ 122
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x537D5C24, /SxmGadgetChannelInfo/AdvisoryMessage),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 17,
        /* mParentIndex        */ 0,    // ItemKey::SxmGadgetChannelInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 83,    // ::SxmGadgetChannelInfoData::mAdvisoryMessage
        /* mItemKey            */ 69
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x35992BEF, /SxmGadgetChannelInfo/AdvisoryMessageVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 17,
        /* mParentIndex        */ 0,    // ItemKey::SxmGadgetChannelInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 84,    // ::SxmGadgetChannelInfoData::mAdvisoryMessageVisibility
        /* mItemKey            */ 46
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF940FFF7, /SxmGadgetChannelInfo/SxmInitialized),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 17,
        /* mParentIndex        */ 0,    // ItemKey::SxmGadgetChannelInfoItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 85,    // ::SxmGadgetChannelInfoData::mSxmInitialized
        /* mItemKey            */ 231
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmAudioInfoForPopupHierarchyNodes[SxmAudioInfoForPopupDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6D1090BC, /SxmAudioInfoForPopup),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioInfoForPopupItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 86,    // ::SxmAudioInfoForPopupData
        /* mItemKey            */ 99
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x623505C8, /SxmAudioInfoForPopup/ChannelNumber),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioInfoForPopupItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 87,    // ::SxmAudioInfoForPopupData::mChannelNumber
        /* mItemKey            */ 85
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x657BED31, /SxmAudioInfoForPopup/ChannelName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioInfoForPopupItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 88,    // ::SxmAudioInfoForPopupData::mChannelName
        /* mItemKey            */ 87
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC82C3234, /SxmAudioInfoForPopup/ArtistName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioInfoForPopupItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 89,    // ::SxmAudioInfoForPopupData::mArtistName
        /* mItemKey            */ 176
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5A624656, /SxmAudioInfoForPopup/SongName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioInfoForPopupItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 90,    // ::SxmAudioInfoForPopupData::mSongName
        /* mItemKey            */ 74
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6D095A42, /SxmAudioInfoForPopup/ChannelLocked),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioInfoForPopupItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 91,    // ::SxmAudioInfoForPopupData::mChannelLocked
        /* mItemKey            */ 98
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x272A3F2F, /SxmAudioInfoForPopup/ChannelMature),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioInfoForPopupItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 92,    // ::SxmAudioInfoForPopupData::mChannelMature
        /* mItemKey            */ 33
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1FD7DE48, /SxmAudioInfoForPopup/ChannelNotAvailable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioInfoForPopupItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 93,    // ::SxmAudioInfoForPopupData::mChannelNotAvailable
        /* mItemKey            */ 29
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8888BC6E, /SxmAudioInfoForPopup/ChannelNotSubscribed),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioInfoForPopupItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 94,    // ::SxmAudioInfoForPopupData::mChannelNotSubscribed
        /* mItemKey            */ 121
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmActivePresetBankHierarchyNodes[SxmActivePresetBankDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x61CACB01, /SxmActivePresetBank),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 19,
        /* mParentIndex        */ 0,    // ItemKey::SxmActivePresetBankItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 95,    // ::SxmActivePresetBankData
        /* mItemKey            */ 83
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF99B8BFC, /SxmActivePresetBank/ActivePresetBank),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 19,
        /* mParentIndex        */ 0,    // ItemKey::SxmActivePresetBankItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 96,    // ::SxmActivePresetBankData::mActivePresetBank
        /* mItemKey            */ 233
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmCategoriesListHierarchyNodes[SxmCategoriesListDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x98708947, /SxmCategoriesList),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 20,
        /* mParentIndex        */ 0,    // ItemKey::SxmCategoriesListItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 97,    // ::SxmCategoriesListData
        /* mItemKey            */ 137
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4A1FCD23, /SxmCategoriesList/CategoryName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 20,
        /* mParentIndex        */ 0,    // ItemKey::SxmCategoriesListItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 98,    // ::SxmCategoriesListData::mCategoryName
        /* mItemKey            */ 65
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9EC81ED4, /SxmCategoriesList/CurrentCategory),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 20,
        /* mParentIndex        */ 0,    // ItemKey::SxmCategoriesListItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 99,    // ::SxmCategoriesListData::mCurrentCategory
        /* mItemKey            */ 144
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmChannelLogoHierarchyNodes[SxmChannelLogoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE07E82CF, /SxmChannelLogo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelLogoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 100,    // ::SxmChannelLogoData
        /* mItemKey            */ 204
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x31327F38, /SxmChannelLogo/ImageSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelLogoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 101,    // ::SxmChannelLogoData::mImageSize
        /* mItemKey            */ 42
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDAD6F168, /SxmChannelLogo/SxmCGLogo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::SxmChannelLogoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 102,    // ::SxmChannelLogoData::mSxmCGLogo
        /* mItemKey            */ 194
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmAudioPresetControlHierarchyNodes[SxmAudioPresetControlDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3F8EDD77, /SxmAudioPresetControl),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 22,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioPresetControlItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 103,    // ::SxmAudioPresetControlData
        /* mItemKey            */ 62
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCA404369, /SxmAudioPresetControl/SwitchPresetOrCtrlButton),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 22,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioPresetControlItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 104,    // ::SxmAudioPresetControlData::mSwitchPresetOrCtrlButton
        /* mItemKey            */ 177
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD5B0AD04, /SxmAudioPresetControl/EnabilityPresetOrCtrlButton),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 22,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioPresetControlItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 105,    // ::SxmAudioPresetControlData::mEnabilityPresetOrCtrlButton
        /* mItemKey            */ 192
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x174DFF17, /SxmAudioPresetControl/SwitchPresetOrCtrlOrScan),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 22,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioPresetControlItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 106,    // ::SxmAudioPresetControlData::mSwitchPresetOrCtrlOrScan
        /* mItemKey            */ 26
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBE0373EC, /SxmAudioPresetControl/DefaultFocus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 22,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioPresetControlItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 107,    // ::SxmAudioPresetControlData::mDefaultFocus
        /* mItemKey            */ 171
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8A323550, /SxmAudioPresetControl/LapFocus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 22,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioPresetControlItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 108,    // ::SxmAudioPresetControlData::mLapFocus
        /* mItemKey            */ 123
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmAudioPlayPauseHierarchyNodes[SxmAudioPlayPauseDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x937E6755, /SxmAudioPlayPause),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 23,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioPlayPauseItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 109,    // ::SxmAudioPlayPauseData
        /* mItemKey            */ 135
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x398F956C, /SxmAudioPlayPause/PlayOrPause),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 23,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioPlayPauseItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 110,    // ::SxmAudioPlayPauseData::mPlayOrPause
        /* mItemKey            */ 54
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmAudioAlertSettingHierarchyNodes[SxmAudioAlertSettingDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x909D7ACE, /SxmAudioAlertSetting),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 24,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioAlertSettingItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 111,    // ::SxmAudioAlertSettingData
        /* mItemKey            */ 130
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDE5C0818, /SxmAudioAlertSetting/AlertText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 24,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioAlertSettingItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 112,    // ::SxmAudioAlertSettingData::mAlertText
        /* mItemKey            */ 199
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE34312B0, /SxmAudioAlertSetting/OnOrOff),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 24,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioAlertSettingItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 113,    // ::SxmAudioAlertSettingData::mOnOrOff
        /* mItemKey            */ 207
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmAudioFavAlertButtonEnableHierarchyNodes[SxmAudioFavAlertButtonEnableDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0FA17B3E, /SxmAudioFavAlertButtonEnable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 25,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioFavAlertButtonEnableItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 114,    // ::SxmAudioFavAlertButtonEnableData
        /* mItemKey            */ 21
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2E1AA8AF, /SxmAudioFavAlertButtonEnable/Enable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 25,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioFavAlertButtonEnableItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 115,    // ::SxmAudioFavAlertButtonEnableData::mEnable
        /* mItemKey            */ 40
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmAudioAlertFavtUpdatePopupHierarchyNodes[SxmAudioAlertFavtUpdatePopupDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6AD981DE, /SxmAudioAlertFavtUpdatePopup),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 26,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioAlertFavtUpdatePopupItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 116,    // ::SxmAudioAlertFavtUpdatePopupData
        /* mItemKey            */ 93
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBA17BD29, /SxmAudioAlertFavtUpdatePopup/TextType),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 26,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioAlertFavtUpdatePopupItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 117,    // ::SxmAudioAlertFavtUpdatePopupData::mTextType
        /* mItemKey            */ 161
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x824A923D, /SxmAudioAlertFavtUpdatePopup/TextChInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 26,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioAlertFavtUpdatePopupItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 118,    // ::SxmAudioAlertFavtUpdatePopupData::mTextChInfo
        /* mItemKey            */ 114
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF731CF28, /SxmAudioAlertFavtUpdatePopup/TextDetailInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 26,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioAlertFavtUpdatePopupItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 119,    // ::SxmAudioAlertFavtUpdatePopupData::mTextDetailInfo
        /* mItemKey            */ 227
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF894F5A5, /SxmAudioAlertFavtUpdatePopup/AlertIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 26,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioAlertFavtUpdatePopupItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 120,    // ::SxmAudioAlertFavtUpdatePopupData::mAlertIcon
        /* mItemKey            */ 230
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF7A9AC39, /SxmAudioAlertFavtUpdatePopup/isRegionTextAllowed),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 26,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioAlertFavtUpdatePopupItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 121,    // ::SxmAudioAlertFavtUpdatePopupData::misRegionTextAllowed
        /* mItemKey            */ 228
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmPresetItemHierarchyNodes[SxmPresetItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x09172A6C, /SxmPresetItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::SxmPresetItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 122,    // ::SxmPresetItemData
        /* mItemKey            */ 11
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB3F4B92C, /SxmPresetItem/ChannelNo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::SxmPresetItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 123,    // ::SxmPresetItemData::mChannelNo
        /* mItemKey            */ 157
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x108CFDEF, /SxmPresetItem/PresetNo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::SxmPresetItemItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 124,    // ::SxmPresetItemData::mPresetNo
        /* mItemKey            */ 22
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3BD01E5A, /SxmPresetItem/IsSmartFav),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::SxmPresetItemItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 125,    // ::SxmPresetItemData::mIsSmartFav
        /* mItemKey            */ 57
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3DA60206, /SxmPresetItem/SxmLogo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::SxmPresetItemItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 126,    // ::SxmPresetItemData::mSxmLogo
        /* mItemKey            */ 59
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCBEE4959, /SxmPresetItem/IsEnable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::SxmPresetItemItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 127,    // ::SxmPresetItemData::mIsEnable
        /* mItemKey            */ 182
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9E79ED27, /SxmPresetItem/IsSelected),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::SxmPresetItemItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 128,    // ::SxmPresetItemData::mIsSelected
        /* mItemKey            */ 142
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmAudioChannelListHierarchyNodes[SxmAudioChannelListDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCD51DB48, /SxmAudioChannelList),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 28,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioChannelListItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 129,    // ::SxmAudioChannelListData
        /* mItemKey            */ 183
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6E18AA2E, /SxmAudioChannelList/ChannelNumber),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 28,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioChannelListItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 130,    // ::SxmAudioChannelListData::mChannelNumber
        /* mItemKey            */ 100
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDEA77FED, /SxmAudioChannelList/SxmLogo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 28,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioChannelListItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 131,    // ::SxmAudioChannelListData::mSxmLogo
        /* mItemKey            */ 201
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBCD9EE4F, /SxmAudioChannelList/ChannelName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 28,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioChannelListItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 132,    // ::SxmAudioChannelListData::mChannelName
        /* mItemKey            */ 167
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x84C8E916, /SxmAudioChannelList/Artist),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 28,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioChannelListItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 133,    // ::SxmAudioChannelListData::mArtist
        /* mItemKey            */ 119
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE146263F, /SxmAudioChannelList/Song),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 28,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioChannelListItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 134,    // ::SxmAudioChannelListData::mSong
        /* mItemKey            */ 205
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x90590477, /SxmAudioChannelList/CurrentPlay),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 28,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioChannelListItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 135,    // ::SxmAudioChannelListData::mCurrentPlay
        /* mItemKey            */ 127
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmAudioSubScreenHeaderTextHierarchyNodes[SxmAudioSubScreenHeaderTextDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6AECEB01, /SxmAudioSubScreenHeaderText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 29,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioSubScreenHeaderTextItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 136,    // ::SxmAudioSubScreenHeaderTextData
        /* mItemKey            */ 94
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1244AAAA, /SxmAudioSubScreenHeaderText/Index),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 29,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioSubScreenHeaderTextItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 137,    // ::SxmAudioSubScreenHeaderTextData::mIndex
        /* mItemKey            */ 24
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmAudioFavoriteArtistHierarchyNodes[SxmAudioFavoriteArtistDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF081E7CD, /SxmAudioFavoriteArtist),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 30,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioFavoriteArtistItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 138,    // ::SxmAudioFavoriteArtistData
        /* mItemKey            */ 215
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA500E6AF, /SxmAudioFavoriteArtist/SwitchArtistOnOrOffOrDelete),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 30,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioFavoriteArtistItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 139,    // ::SxmAudioFavoriteArtistData::mSwitchArtistOnOrOffOrDelete
        /* mItemKey            */ 147
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmAudioFavoriteSongHierarchyNodes[SxmAudioFavoriteSongDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x842FA477, /SxmAudioFavoriteSong),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 31,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioFavoriteSongItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 140,    // ::SxmAudioFavoriteSongData
        /* mItemKey            */ 117
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0CB5863D, /SxmAudioFavoriteSong/SwitchSongtOnOrOffOrDelete),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 31,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioFavoriteSongItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 141,    // ::SxmAudioFavoriteSongData::mSwitchSongtOnOrOffOrDelete
        /* mItemKey            */ 15
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmLeagueOrReplaceListHierarchyNodes[SxmLeagueOrReplaceListDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3C3F6A0F, /SxmLeagueOrReplaceList),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 32,
        /* mParentIndex        */ 0,    // ItemKey::SxmLeagueOrReplaceListItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 142,    // ::SxmLeagueOrReplaceListData
        /* mItemKey            */ 58
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0772DAE1, /SxmLeagueOrReplaceList/Text),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 32,
        /* mParentIndex        */ 0,    // ItemKey::SxmLeagueOrReplaceListItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 143,    // ::SxmLeagueOrReplaceListData::mText
        /* mItemKey            */ 10
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x05FF2CBB, /SxmLeagueOrReplaceList/IsEnable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 32,
        /* mParentIndex        */ 0,    // ItemKey::SxmLeagueOrReplaceListItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 144,    // ::SxmLeagueOrReplaceListData::mIsEnable
        /* mItemKey            */ 6
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmInfoButtonEnableHierarchyNodes[SxmInfoButtonEnableDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5FEBDB9C, /SxmInfoButtonEnable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 33,
        /* mParentIndex        */ 0,    // ItemKey::SxmInfoButtonEnableItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 145,    // ::SxmInfoButtonEnableData
        /* mItemKey            */ 81
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5ABBA3A0, /SxmInfoButtonEnable/Enable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 33,
        /* mParentIndex        */ 0,    // ItemKey::SxmInfoButtonEnableItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 146,    // ::SxmInfoButtonEnableData::mEnable
        /* mItemKey            */ 76
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmAudioReplayContentHierarchyNodes[SxmAudioReplayContentDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3F07D2C5, /SxmAudioReplayContent),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 34,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioReplayContentItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 147,    // ::SxmAudioReplayContentData
        /* mItemKey            */ 61
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBBE2970C, /SxmAudioReplayContent/ActiveReplayMode),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 34,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioReplayContentItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 148,    // ::SxmAudioReplayContentData::mActiveReplayMode
        /* mItemKey            */ 165
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x32BB1E4C, /SxmAudioReplayContent/ReplayOrScan),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 34,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioReplayContentItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 149,    // ::SxmAudioReplayContentData::mReplayOrScan
        /* mItemKey            */ 44
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF0343315, /SxmAudioReplayContent/ReplayModeTextVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 34,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioReplayContentItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 150,    // ::SxmAudioReplayContentData::mReplayModeTextVisibility
        /* mItemKey            */ 214
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB5F47DE7, /SxmAudioReplayContent/TimeToLive),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 34,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioReplayContentItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 151,    // ::SxmAudioReplayContentData::mTimeToLive
        /* mItemKey            */ 159
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF3BEBCD6, /SxmAudioReplayContent/PlayEnabled),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 34,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioReplayContentItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 152,    // ::SxmAudioReplayContentData::mPlayEnabled
        /* mItemKey            */ 220
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4EE2FFA8, /SxmAudioReplayContent/PauseEnabled),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 34,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioReplayContentItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 153,    // ::SxmAudioReplayContentData::mPauseEnabled
        /* mItemKey            */ 67
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF3CEC984, /SxmAudioReplayContent/SkipBackEnabled),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 34,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioReplayContentItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 154,    // ::SxmAudioReplayContentData::mSkipBackEnabled
        /* mItemKey            */ 221
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8DAB650B, /SxmAudioReplayContent/RewindEnabled),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 34,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioReplayContentItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 155,    // ::SxmAudioReplayContentData::mRewindEnabled
        /* mItemKey            */ 124
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF5CEFD48, /SxmAudioReplayContent/FastForwardEnabled),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 34,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioReplayContentItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 156,    // ::SxmAudioReplayContentData::mFastForwardEnabled
        /* mItemKey            */ 225
    },
    { // 10
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDDB39763, /SxmAudioReplayContent/ForwardEnabled),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 34,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioReplayContentItem
        /* mLocalIndex         */ 10,
        /* mDescriptorIndex    */ 157,    // ::SxmAudioReplayContentData::mForwardEnabled
        /* mItemKey            */ 198
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSXMAudioCustomizeChannelHierarchyNodes[SXMAudioCustomizeChannelDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x405628B6, /SXMAudioCustomizeChannel),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 35,
        /* mParentIndex        */ 0,    // ItemKey::SXMAudioCustomizeChannelItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 158,    // ::SXMAudioCustomizeChannelData
        /* mItemKey            */ 63
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF12F2D92, /SXMAudioCustomizeChannel/SwitchClearOrSelect),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 35,
        /* mParentIndex        */ 0,    // ItemKey::SXMAudioCustomizeChannelItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 159,    // ::SXMAudioCustomizeChannelData::mSwitchClearOrSelect
        /* mItemKey            */ 216
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSXMAudioCustomizeChannelListItemHierarchyNodes[SXMAudioCustomizeChannelListItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0CADFABE, /SXMAudioCustomizeChannelListItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 36,
        /* mParentIndex        */ 0,    // ItemKey::SXMAudioCustomizeChannelListItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 160,    // ::SXMAudioCustomizeChannelListItemData
        /* mItemKey            */ 14
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x62B8AB24, /SXMAudioCustomizeChannelListItem/ChannelNumber),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 36,
        /* mParentIndex        */ 0,    // ItemKey::SXMAudioCustomizeChannelListItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 161,    // ::SXMAudioCustomizeChannelListItemData::mChannelNumber
        /* mItemKey            */ 86
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2966CB16, /SXMAudioCustomizeChannelListItem/ChannelName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 36,
        /* mParentIndex        */ 0,    // ItemKey::SXMAudioCustomizeChannelListItemItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 162,    // ::SXMAudioCustomizeChannelListItemData::mChannelName
        /* mItemKey            */ 35
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x38563FF0, /SXMAudioCustomizeChannelListItem/Index),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 36,
        /* mParentIndex        */ 0,    // ItemKey::SXMAudioCustomizeChannelListItemItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 163,    // ::SXMAudioCustomizeChannelListItemData::mIndex
        /* mItemKey            */ 52
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFA85A8A7, /SXMAudioCustomizeChannelListItem/Enable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 36,
        /* mParentIndex        */ 0,    // ItemKey::SXMAudioCustomizeChannelListItemItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 164,    // ::SXMAudioCustomizeChannelListItemData::mEnable
        /* mItemKey            */ 235
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4C24D6A5, /SXMAudioCustomizeChannelListItem/Visiblity),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 36,
        /* mParentIndex        */ 0,    // ItemKey::SXMAudioCustomizeChannelListItemItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 165,    // ::SXMAudioCustomizeChannelListItemData::mVisiblity
        /* mItemKey            */ 66
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC811E07C, /SXMAudioCustomizeChannelListItem/SxmLogo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 36,
        /* mParentIndex        */ 0,    // ItemKey::SXMAudioCustomizeChannelListItemItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 166,    // ::SXMAudioCustomizeChannelListItemData::mSxmLogo
        /* mItemKey            */ 175
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmAudioDirectTuneTextInfoHierarchyNodes[SxmAudioDirectTuneTextInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0EA6E531, /SxmAudioDirectTuneTextInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 37,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioDirectTuneTextInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 167,    // ::SxmAudioDirectTuneTextInfoData
        /* mItemKey            */ 18
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCAB1A16B, /SxmAudioDirectTuneTextInfo/EditorText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 37,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioDirectTuneTextInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 168,    // ::SxmAudioDirectTuneTextInfoData::mEditorText
        /* mItemKey            */ 179
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2A788173, /SxmAudioDirectTuneTextInfo/OkButtonEnability),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 37,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioDirectTuneTextInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 169,    // ::SxmAudioDirectTuneTextInfoData::mOkButtonEnability
        /* mItemKey            */ 36
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x36A81184, /SxmAudioDirectTuneTextInfo/IsMaxCharReached),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 37,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioDirectTuneTextInfoItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 170,    // ::SxmAudioDirectTuneTextInfoData::mIsMaxCharReached
        /* mItemKey            */ 49
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmAudioDirectTuneKeyPressInfoHierarchyNodes[SxmAudioDirectTuneKeyPressInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x59773BBD, /SxmAudioDirectTuneKeyPressInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 38,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioDirectTuneKeyPressInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 171,    // ::SxmAudioDirectTuneKeyPressInfoData
        /* mItemKey            */ 73
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEBFC0A30, /SxmAudioDirectTuneKeyPressInfo/KeyPressed),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 38,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioDirectTuneKeyPressInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 172,    // ::SxmAudioDirectTuneKeyPressInfoData::mKeyPressed
        /* mItemKey            */ 211
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSpellerDeleteBtnStateHierarchyNodes[SpellerDeleteBtnStateDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA9F222F9, /SpellerDeleteBtnState),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 39,
        /* mParentIndex        */ 0,    // ItemKey::SpellerDeleteBtnStateItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 173,    // ::SpellerDeleteBtnStateData
        /* mItemKey            */ 152
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x14571BF4, /SpellerDeleteBtnState/IsEnabled),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 39,
        /* mParentIndex        */ 0,    // ItemKey::SpellerDeleteBtnStateItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 174,    // ::SpellerDeleteBtnStateData::mIsEnabled
        /* mItemKey            */ 25
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmAudioChannelNotAvailablePopupHierarchyNodes[SxmAudioChannelNotAvailablePopupDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCAA53781, /SxmAudioChannelNotAvailablePopup),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 40,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioChannelNotAvailablePopupItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 175,    // ::SxmAudioChannelNotAvailablePopupData
        /* mItemKey            */ 178
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6C46AD2B, /SxmAudioChannelNotAvailablePopup/Text),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 40,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioChannelNotAvailablePopupItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 176,    // ::SxmAudioChannelNotAvailablePopupData::mText
        /* mItemKey            */ 97
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmAudioChannelNotSubscribedPopupHierarchyNodes[SxmAudioChannelNotSubscribedPopupDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x324B5CFC, /SxmAudioChannelNotSubscribedPopup),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 41,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioChannelNotSubscribedPopupItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 177,    // ::SxmAudioChannelNotSubscribedPopupData
        /* mItemKey            */ 43
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBD2B1ECE, /SxmAudioChannelNotSubscribedPopup/Text),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 41,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioChannelNotSubscribedPopupItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 178,    // ::SxmAudioChannelNotSubscribedPopupData::mText
        /* mItemKey            */ 169
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmAudioTuneStartHierarchyNodes[SxmAudioTuneStartDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9EC2C1E2, /SxmAudioTuneStart),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 42,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioTuneStartItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 179,    // ::SxmAudioTuneStartData
        /* mItemKey            */ 143
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x904DF52E, /SxmAudioTuneStart/TuneStartOn),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 42,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioTuneStartItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 180,    // ::SxmAudioTuneStartData::mTuneStartOn
        /* mItemKey            */ 126
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmAudioScanHierarchyNodes[SxmAudioScanDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD366BE25, /SxmAudioScan),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 43,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioScanItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 181,    // ::SxmAudioScanData
        /* mItemKey            */ 189
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x36442F88, /SxmAudioScan/ScanOn),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 43,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioScanItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 182,    // ::SxmAudioScanData::mScanOn
        /* mItemKey            */ 47
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5B8EA23E, /SxmAudioScan/ScanContentAvail),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 43,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioScanItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 183,    // ::SxmAudioScanData::mScanContentAvail
        /* mItemKey            */ 78
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmAudioSportsFlashTeamNamePopupHierarchyNodes[SxmAudioSportsFlashTeamNamePopupDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD64872D3, /SxmAudioSportsFlashTeamNamePopup),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 44,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioSportsFlashTeamNamePopupItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 184,    // ::SxmAudioSportsFlashTeamNamePopupData
        /* mItemKey            */ 193
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7D9385B9, /SxmAudioSportsFlashTeamNamePopup/Text),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 44,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioSportsFlashTeamNamePopupItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 185,    // ::SxmAudioSportsFlashTeamNamePopupData::mText
        /* mItemKey            */ 112
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmAudioSportsFlashAlertAdvisoryHierarchyNodes[SxmAudioSportsFlashAlertAdvisoryDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x039A00A2, /SxmAudioSportsFlashAlertAdvisory),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 45,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioSportsFlashAlertAdvisoryItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 186,    // ::SxmAudioSportsFlashAlertAdvisoryData
        /* mItemKey            */ 5
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x56F16928, /SxmAudioSportsFlashAlertAdvisory/Text1),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 45,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioSportsFlashAlertAdvisoryItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 187,    // ::SxmAudioSportsFlashAlertAdvisoryData::mText1
        /* mItemKey            */ 71
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSXMAudioSportsflashAlertHierarchyNodes[SXMAudioSportsflashAlertDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3684ED09, /SXMAudioSportsflashAlert),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 46,
        /* mParentIndex        */ 0,    // ItemKey::SXMAudioSportsflashAlertItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 188,    // ::SXMAudioSportsflashAlertData
        /* mItemKey            */ 48
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD07A0C58, /SXMAudioSportsflashAlert/SwitchOnorOff),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 46,
        /* mParentIndex        */ 0,    // ItemKey::SXMAudioSportsflashAlertItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 189,    // ::SXMAudioSportsflashAlertData::mSwitchOnorOff
        /* mItemKey            */ 187
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSXMAudioSportsflashListItemAlertHierarchyNodes[SXMAudioSportsflashListItemAlertDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBC7635F1, /SXMAudioSportsflashListItemAlert),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 47,
        /* mParentIndex        */ 0,    // ItemKey::SXMAudioSportsflashListItemAlertItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 190,    // ::SXMAudioSportsflashListItemAlertData
        /* mItemKey            */ 166
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB574162C, /SXMAudioSportsflashListItemAlert/SwitchOnorOff),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 47,
        /* mParentIndex        */ 0,    // ItemKey::SXMAudioSportsflashListItemAlertItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 191,    // ::SXMAudioSportsflashListItemAlertData::mSwitchOnorOff
        /* mItemKey            */ 158
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSXMAudioSportsflashFavAdvisoryHierarchyNodes[SXMAudioSportsflashFavAdvisoryDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2A8730F8, /SXMAudioSportsflashFavAdvisory),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 48,
        /* mParentIndex        */ 0,    // ItemKey::SXMAudioSportsflashFavAdvisoryItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 192,    // ::SXMAudioSportsflashFavAdvisoryData
        /* mItemKey            */ 37
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD3EA428F, /SXMAudioSportsflashFavAdvisory/AdvisoryText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 48,
        /* mParentIndex        */ 0,    // ItemKey::SXMAudioSportsflashFavAdvisoryItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 193,    // ::SXMAudioSportsflashFavAdvisoryData::mAdvisoryText
        /* mItemKey            */ 190
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmAudioSportsflashEnableHierarchyNodes[SxmAudioSportsflashEnableDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB1B172B4, /SxmAudioSportsflashEnable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 49,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioSportsflashEnableItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 194,    // ::SxmAudioSportsflashEnableData
        /* mItemKey            */ 156
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFBAADC4A, /SxmAudioSportsflashEnable/EnableOn),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 49,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioSportsflashEnableItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 195,    // ::SxmAudioSportsflashEnableData::mEnableOn
        /* mItemKey            */ 236
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmAudioMenuChannelLockHierarchyNodes[SxmAudioMenuChannelLockDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0F944B70, /SxmAudioMenuChannelLock),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 50,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioMenuChannelLockItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 196,    // ::SxmAudioMenuChannelLockData
        /* mItemKey            */ 20
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x51FB2866, /SxmAudioMenuChannelLock/OffOrOn),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 50,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioMenuChannelLockItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 197,    // ::SxmAudioMenuChannelLockData::mOffOrOn
        /* mItemKey            */ 68
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmAudioCustomizeButtonHierarchyNodes[SxmAudioCustomizeButtonDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x60EF6DD8, /SxmAudioCustomizeButton),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 51,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioCustomizeButtonItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 198,    // ::SxmAudioCustomizeButtonData
        /* mItemKey            */ 82
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9555FD70, /SxmAudioCustomizeButton/EnableOrDisable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 51,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioCustomizeButtonItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 199,    // ::SxmAudioCustomizeButtonData::mEnableOrDisable
        /* mItemKey            */ 136
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSXMAudioTWNHierarchyNodes[SXMAudioTWNDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x91F2069E, /SXMAudioTWN),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 52,
        /* mParentIndex        */ 0,    // ItemKey::SXMAudioTWNItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 200,    // ::SXMAudioTWNData
        /* mItemKey            */ 131
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x836561B4, /SXMAudioTWN/OnOrOff),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 52,
        /* mParentIndex        */ 0,    // ItemKey::SXMAudioTWNItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 201,    // ::SXMAudioTWNData::mOnOrOff
        /* mItemKey            */ 116
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBB425002, /SXMAudioTWN/City),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 52,
        /* mParentIndex        */ 0,    // ItemKey::SXMAudioTWNItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 202,    // ::SXMAudioTWNData::mCity
        /* mItemKey            */ 163
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSXMAudioTWNNoInfoHierarchyNodes[SXMAudioTWNNoInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE872FB47, /SXMAudioTWNNoInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 53,
        /* mParentIndex        */ 0,    // ItemKey::SXMAudioTWNNoInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 203,    // ::SXMAudioTWNNoInfoData
        /* mItemKey            */ 209
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2C27A465, /SXMAudioTWNNoInfo/text),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 53,
        /* mParentIndex        */ 0,    // ItemKey::SXMAudioTWNNoInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 204,    // ::SXMAudioTWNNoInfoData::mtext
        /* mItemKey            */ 39
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSXTWNButtonHierarchyNodes[SXTWNButtonDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x88172C3B, /SXTWNButton),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 54,
        /* mParentIndex        */ 0,    // ItemKey::SXTWNButtonItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 205,    // ::SXTWNButtonData
        /* mItemKey            */ 120
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC5E8E013, /SXTWNButton/TWNButton),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 54,
        /* mParentIndex        */ 0,    // ItemKey::SXTWNButtonItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 206,    // ::SXTWNButtonData::mTWNButton
        /* mItemKey            */ 174
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6680ACCE, /SXTWNButton/BtnEnable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 54,
        /* mParentIndex        */ 0,    // ItemKey::SXTWNButtonItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 207,    // ::SXTWNButtonData::mBtnEnable
        /* mItemKey            */ 90
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x350123FB, /SXTWNButton/AdvisoryorList),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 54,
        /* mParentIndex        */ 0,    // ItemKey::SXTWNButtonItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 208,    // ::SXTWNButtonData::mAdvisoryorList
        /* mItemKey            */ 45
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSXMSFButtonHierarchyNodes[SXMSFButtonDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA33921D3, /SXMSFButton),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::SXMSFButtonItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 209,    // ::SXMSFButtonData
        /* mItemKey            */ 145
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC571C655, /SXMSFButton/SFButton),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::SXMSFButtonItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 210,    // ::SXMSFButtonData::mSFButton
        /* mItemKey            */ 173
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF98725C7, /SXMSFButton/AdvisoryorList),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::SXMSFButtonItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 211,    // ::SXMSFButtonData::mAdvisoryorList
        /* mItemKey            */ 232
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF3D3B219, /SXMSFButton/BtnEnable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::SXMSFButtonItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 212,    // ::SXMSFButtonData::mBtnEnable
        /* mItemKey            */ 222
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmSFTunePopupHierarchyNodes[SxmSFTunePopupDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x00C9D3AB, /SxmSFTunePopup),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 56,
        /* mParentIndex        */ 0,    // ItemKey::SxmSFTunePopupItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 213,    // ::SxmSFTunePopupData
        /* mItemKey            */ 1
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0E8B9FE7, /SxmSFTunePopup/Teams),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 56,
        /* mParentIndex        */ 0,    // ItemKey::SxmSFTunePopupItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 214,    // ::SxmSFTunePopupData::mTeams
        /* mItemKey            */ 17
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDEECBA73, /SxmSFTunePopup/SFTextType),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 56,
        /* mParentIndex        */ 0,    // ItemKey::SxmSFTunePopupItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 215,    // ::SxmSFTunePopupData::mSFTextType
        /* mItemKey            */ 202
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5D63EB5B, /SxmSFTunePopup/isRegionTextAllowed),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 56,
        /* mParentIndex        */ 0,    // ItemKey::SxmSFTunePopupItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 216,    // ::SxmSFTunePopupData::misRegionTextAllowed
        /* mItemKey            */ 80
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmAudioSliderConfHierarchyNodes[SxmAudioSliderConfDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x92F91655, /SxmAudioSliderConf),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 57,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioSliderConfItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 217,    // ::SxmAudioSliderConfData
        /* mItemKey            */ 134
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBD4C3A43, /SxmAudioSliderConf/SliderValue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 57,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioSliderConfItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 218,    // ::SxmAudioSliderConfData::mSliderValue
        /* mItemKey            */ 170
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF1988CC5, /SxmAudioSliderConf/BufferValue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 57,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioSliderConfItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 219,    // ::SxmAudioSliderConfData::mBufferValue
        /* mItemKey            */ 217
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmSettingTestmodeUpdatePopupHierarchyNodes[SxmSettingTestmodeUpdatePopupDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x98B6F81A, /SxmSettingTestmodeUpdatePopup),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 58,
        /* mParentIndex        */ 0,    // ItemKey::SxmSettingTestmodeUpdatePopupItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 220,    // ::SxmSettingTestmodeUpdatePopupData
        /* mItemKey            */ 138
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x736375CB, /SxmSettingTestmodeUpdatePopup/Text),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 58,
        /* mParentIndex        */ 0,    // ItemKey::SxmSettingTestmodeUpdatePopupItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 221,    // ::SxmSettingTestmodeUpdatePopupData::mText
        /* mItemKey            */ 102
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmSettingTestmodeExternalDiagHierarchyNodes[SxmSettingTestmodeExternalDiagDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x84B6DEC5, /SxmSettingTestmodeExternalDiag),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 59,
        /* mParentIndex        */ 0,    // ItemKey::SxmSettingTestmodeExternalDiagItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 222,    // ::SxmSettingTestmodeExternalDiagData
        /* mItemKey            */ 118
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB772E64F, /SxmSettingTestmodeExternalDiag/ExternOnorOff),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 59,
        /* mParentIndex        */ 0,    // ItemKey::SxmSettingTestmodeExternalDiagItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 223,    // ::SxmSettingTestmodeExternalDiagData::mExternOnorOff
        /* mItemKey            */ 160
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmAudioContentAlertHierarchyNodes[SxmAudioContentAlertDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBCFEE130, /SxmAudioContentAlert),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 60,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioContentAlertItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 224,    // ::SxmAudioContentAlertData
        /* mItemKey            */ 168
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD46CC342, /SxmAudioContentAlert/AdvisoryMessage),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 60,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioContentAlertItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 225,    // ::SxmAudioContentAlertData::mAdvisoryMessage
        /* mItemKey            */ 191
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCE1B555E, /SxmAudioContentAlert/AdvisoryorList),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 60,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioContentAlertItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 226,    // ::SxmAudioContentAlertData::mAdvisoryorList
        /* mItemKey            */ 186
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3DE7DAA4, /SxmAudioContentAlert/AdvisoryLoading),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 60,
        /* mParentIndex        */ 0,    // ItemKey::SxmAudioContentAlertItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 227,    // ::SxmAudioContentAlertData::mAdvisoryLoading
        /* mItemKey            */ 60
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmFavtUpdatePopupHierarchyNodes[SxmFavtUpdatePopupDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x686DF908, /SxmFavtUpdatePopup),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::SxmFavtUpdatePopupItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 228,    // ::SxmFavtUpdatePopupData
        /* mItemKey            */ 92
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5493144D, /SxmFavtUpdatePopup/Text),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::SxmFavtUpdatePopupItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 229,    // ::SxmFavtUpdatePopupData::mText
        /* mItemKey            */ 70
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5B733EA1, /SxmFavtUpdatePopup/PopupType),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::SxmFavtUpdatePopupItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 230,    // ::SxmFavtUpdatePopupData::mPopupType
        /* mItemKey            */ 77
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmFavtDeletePopupHierarchyNodes[SxmFavtDeletePopupDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x01F7AEB2, /SxmFavtDeletePopup),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 62,
        /* mParentIndex        */ 0,    // ItemKey::SxmFavtDeletePopupItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 231,    // ::SxmFavtDeletePopupData
        /* mItemKey            */ 3
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xAA5DEC08, /SxmFavtDeletePopup/Text),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 62,
        /* mParentIndex        */ 0,    // ItemKey::SxmFavtDeletePopupItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 232,    // ::SxmFavtDeletePopupData::mText
        /* mItemKey            */ 153
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSxmApplicationStateHierarchyNodes[SxmApplicationStateDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x38ACA1F1, /SxmApplicationState),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 63,
        /* mParentIndex        */ 0,    // ItemKey::SxmApplicationStateItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 233,    // ::SxmApplicationStateData
        /* mItemKey            */ 53
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x73FAC131, /SxmApplicationState/State),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 63,
        /* mParentIndex        */ 0,    // ItemKey::SxmApplicationStateItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 234,    // ::SxmApplicationStateData::mState
        /* mItemKey            */ 103
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gListScrollBarInfoHierarchyNodes[ListScrollBarInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x44E9662C, /ListScrollBarInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 64,
        /* mParentIndex        */ 0,    // ItemKey::ListScrollBarInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 235,    // ::ListScrollBarInfoData
        /* mItemKey            */ 64
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE2697E96, /ListScrollBarInfo/Enabled),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 64,
        /* mParentIndex        */ 0,    // ItemKey::ListScrollBarInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 236,    // ::ListScrollBarInfoData::mEnabled
        /* mItemKey            */ 206
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gCarModeVisibilityHierarchyNodes[CarModeVisibilityDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x06815284, /CarModeVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 65,
        /* mParentIndex        */ 0,    // ItemKey::CarModeVisibilityItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 237,    // ::CarModeVisibilityData
        /* mItemKey            */ 8
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x19B4C071, /CarModeVisibility/VisibleStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 65,
        /* mParentIndex        */ 0,    // ItemKey::CarModeVisibilityItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 238,    // ::CarModeVisibilityData::mVisibleStatus
        /* mItemKey            */ 27
    },
};

// array of pointers to all hierarchy nodes - sorted by HashId
const ::Courier::Internal::DataBinding::DataItemHierarchyNode * const gGlobalHierachyNodeTable[cGlobalDataItemHierarchyNodeCount] = {
    &gInvalidHierarchyNodes[0],
    &gSxmSFTunePopupHierarchyNodes[0],
    &gSxmChannelInfoHierarchyNodes[14],
    &gSxmFavtDeletePopupHierarchyNodes[0],
    &gHeaderTextHierarchyNodes[2],
    &gSxmAudioSportsFlashAlertAdvisoryHierarchyNodes[0],
    &gSxmLeagueOrReplaceListHierarchyNodes[2],
    &gSxmTpopChannelInfoHierarchyNodes[1],
    &gCarModeVisibilityHierarchyNodes[0],
    &gSxmChannelInfoHierarchyNodes[6],
    &gSxmLeagueOrReplaceListHierarchyNodes[1],
    &gSxmPresetItemHierarchyNodes[0],
    &gSxmChannelInfoHierarchyNodes[0],
    &gSxmMenuItemHierarchyNodes[1],
    &gSXMAudioCustomizeChannelListItemHierarchyNodes[0],
    &gSxmAudioFavoriteSongHierarchyNodes[1],
    &gSxmTabControlListHierarchyNodes[9],
    &gSxmSFTunePopupHierarchyNodes[1],
    &gSxmAudioDirectTuneTextInfoHierarchyNodes[0],
    &gSxmSpeedLockUpdateForListItemScrollHierarchyNodes[0],
    &gSxmAudioMenuChannelLockHierarchyNodes[0],
    &gSxmAudioFavAlertButtonEnableHierarchyNodes[0],
    &gSxmPresetItemHierarchyNodes[2],
    &gSxmChannelInfoHierarchyNodes[3],
    &gSxmAudioSubScreenHeaderTextHierarchyNodes[1],
    &gSpellerDeleteBtnStateHierarchyNodes[1],
    &gSxmAudioPresetControlHierarchyNodes[3],
    &gCarModeVisibilityHierarchyNodes[1],
    &gSxmAudioTuneScanHierarchyNodes[1],
    &gSxmAudioInfoForPopupHierarchyNodes[7],
    &gSxmTabControlListHierarchyNodes[1],
    &gSxmUpdateFooterHierarchyNodes[2],
    &gSxmChannelInfoHierarchyNodes[11],
    &gSxmAudioInfoForPopupHierarchyNodes[6],
    &gSxmPresetListHierarchyNodes[3],
    &gSXMAudioCustomizeChannelListItemHierarchyNodes[2],
    &gSxmAudioDirectTuneTextInfoHierarchyNodes[2],
    &gSXMAudioSportsflashFavAdvisoryHierarchyNodes[0],
    &gSxmAudioFavArtistSongTeamListHierarchyNodes[2],
    &gSXMAudioTWNNoInfoHierarchyNodes[1],
    &gSxmAudioFavAlertButtonEnableHierarchyNodes[1],
    &gSxmTabControlListHierarchyNodes[10],
    &gSxmChannelLogoHierarchyNodes[1],
    &gSxmAudioChannelNotSubscribedPopupHierarchyNodes[0],
    &gSxmAudioReplayContentHierarchyNodes[2],
    &gSXTWNButtonHierarchyNodes[3],
    &gSxmGadgetChannelInfoHierarchyNodes[2],
    &gSxmAudioScanHierarchyNodes[1],
    &gSXMAudioSportsflashAlertHierarchyNodes[0],
    &gSxmAudioDirectTuneTextInfoHierarchyNodes[3],
    &gSxmMenuItemHierarchyNodes[2],
    &gSxmTpopChannelInfoHierarchyNodes[0],
    &gSXMAudioCustomizeChannelListItemHierarchyNodes[3],
    &gSxmApplicationStateHierarchyNodes[0],
    &gSxmAudioPlayPauseHierarchyNodes[1],
    &gSxmTabControlListHierarchyNodes[8],
    &gSxmPresetListHierarchyNodes[0],
    &gSxmPresetItemHierarchyNodes[3],
    &gSxmLeagueOrReplaceListHierarchyNodes[0],
    &gSxmPresetItemHierarchyNodes[4],
    &gSxmAudioContentAlertHierarchyNodes[3],
    &gSxmAudioReplayContentHierarchyNodes[0],
    &gSxmAudioPresetControlHierarchyNodes[0],
    &gSXMAudioCustomizeChannelHierarchyNodes[0],
    &gListScrollBarInfoHierarchyNodes[0],
    &gSxmCategoriesListHierarchyNodes[1],
    &gSXMAudioCustomizeChannelListItemHierarchyNodes[5],
    &gSxmAudioReplayContentHierarchyNodes[6],
    &gSxmAudioMenuChannelLockHierarchyNodes[1],
    &gSxmGadgetChannelInfoHierarchyNodes[1],
    &gSxmFavtUpdatePopupHierarchyNodes[1],
    &gSxmAudioSportsFlashAlertAdvisoryHierarchyNodes[1],
    &gSxmTabControlListHierarchyNodes[5],
    &gSxmAudioDirectTuneKeyPressInfoHierarchyNodes[0],
    &gSxmAudioInfoForPopupHierarchyNodes[4],
    &gAudioMuteInfoHierarchyNodes[1],
    &gSxmInfoButtonEnableHierarchyNodes[1],
    &gSxmFavtUpdatePopupHierarchyNodes[2],
    &gSxmAudioScanHierarchyNodes[2],
    &gHeaderTextHierarchyNodes[0],
    &gSxmSFTunePopupHierarchyNodes[3],
    &gSxmInfoButtonEnableHierarchyNodes[0],
    &gSxmAudioCustomizeButtonHierarchyNodes[0],
    &gSxmActivePresetBankHierarchyNodes[0],
    &gSxmAudioMaintextAnimationHierarchyNodes[0],
    &gSxmAudioInfoForPopupHierarchyNodes[1],
    &gSXMAudioCustomizeChannelListItemHierarchyNodes[1],
    &gSxmAudioInfoForPopupHierarchyNodes[2],
    &gSxmAudioLoadingInfoHierarchyNodes[4],
    &gSxmSpeedLockUpdateForListItemScrollHierarchyNodes[1],
    &gSXTWNButtonHierarchyNodes[2],
    &gSxmTpopChannelInfoHierarchyNodes[2],
    &gSxmFavtUpdatePopupHierarchyNodes[0],
    &gSxmAudioAlertFavtUpdatePopupHierarchyNodes[0],
    &gSxmAudioSubScreenHeaderTextHierarchyNodes[0],
    &gSxmAudioLoadingInfoHierarchyNodes[3],
    &gSxmTabControlListHierarchyNodes[4],
    &gSxmAudioChannelNotAvailablePopupHierarchyNodes[1],
    &gSxmAudioInfoForPopupHierarchyNodes[5],
    &gSxmAudioInfoForPopupHierarchyNodes[0],
    &gSxmAudioChannelListHierarchyNodes[1],
    &gSxmAudioFavArtistSongTeamListHierarchyNodes[0],
    &gSxmSettingTestmodeUpdatePopupHierarchyNodes[1],
    &gSxmApplicationStateHierarchyNodes[1],
    &gSxmAudioMaintextAnimationHierarchyNodes[1],
    &gSxmChannelInfoHierarchyNodes[15],
    &gSxmAudioLoadingInfoHierarchyNodes[2],
    &gSxmTabControlListHierarchyNodes[15],
    &gSxmTabControlListHierarchyNodes[13],
    &gSxmAudioTuneScanHierarchyNodes[0],
    &gSxmPopupInfoHierarchyNodes[1],
    &gSxmTabControlListHierarchyNodes[14],
    &gSxmAudioSportsFlashTeamNamePopupHierarchyNodes[1],
    &gSxmAudioModeHierarchyNodes[0],
    &gSxmAudioAlertFavtUpdatePopupHierarchyNodes[2],
    &gAudioMuteInfoHierarchyNodes[0],
    &gSXMAudioTWNHierarchyNodes[1],
    &gSxmAudioFavoriteSongHierarchyNodes[0],
    &gSxmSettingTestmodeExternalDiagHierarchyNodes[0],
    &gSxmAudioChannelListHierarchyNodes[4],
    &gSXTWNButtonHierarchyNodes[0],
    &gSxmAudioInfoForPopupHierarchyNodes[8],
    &gSxmGadgetChannelInfoHierarchyNodes[0],
    &gSxmAudioPresetControlHierarchyNodes[5],
    &gSxmAudioReplayContentHierarchyNodes[8],
    &gSxmMenuListHierarchyNodes[3],
    &gSxmAudioTuneStartHierarchyNodes[1],
    &gSxmAudioChannelListHierarchyNodes[6],
    &gSxmAudioLoadingInfoHierarchyNodes[1],
    &gSxmAudioLoadingInfoHierarchyNodes[0],
    &gSxmAudioAlertSettingHierarchyNodes[0],
    &gSXMAudioTWNHierarchyNodes[0],
    &gSxmTabControlListHierarchyNodes[0],
    &gSxmPopupInfoHierarchyNodes[0],
    &gSxmAudioSliderConfHierarchyNodes[0],
    &gSxmAudioPlayPauseHierarchyNodes[0],
    &gSxmAudioCustomizeButtonHierarchyNodes[1],
    &gSxmCategoriesListHierarchyNodes[0],
    &gSxmSettingTestmodeUpdatePopupHierarchyNodes[0],
    &gSxmUpdateFooterHierarchyNodes[1],
    &gSxmTabControlListHierarchyNodes[2],
    &gSxmMenuListHierarchyNodes[2],
    &gSxmPresetItemHierarchyNodes[6],
    &gSxmAudioTuneStartHierarchyNodes[0],
    &gSxmCategoriesListHierarchyNodes[2],
    &gSXMSFButtonHierarchyNodes[0],
    &gSxmAudioMaintextAnimationHierarchyNodes[2],
    &gSxmAudioFavoriteArtistHierarchyNodes[1],
    &gSxmMenuListHierarchyNodes[5],
    &gSxmChannelInfoHierarchyNodes[4],
    &gSxmMenuListHierarchyNodes[0],
    &gSxmChannelInfoHierarchyNodes[7],
    &gSpellerDeleteBtnStateHierarchyNodes[0],
    &gSxmFavtDeletePopupHierarchyNodes[1],
    &gSxmChannelInfoHierarchyNodes[13],
    &gSxmChannelInfoHierarchyNodes[1],
    &gSxmAudioSportsflashEnableHierarchyNodes[0],
    &gSxmPresetItemHierarchyNodes[1],
    &gSXMAudioSportsflashListItemAlertHierarchyNodes[1],
    &gSxmAudioReplayContentHierarchyNodes[4],
    &gSxmSettingTestmodeExternalDiagHierarchyNodes[1],
    &gSxmAudioAlertFavtUpdatePopupHierarchyNodes[1],
    &gSxmChannelInfoHierarchyNodes[10],
    &gSXMAudioTWNHierarchyNodes[2],
    &gSxmAudioModeHierarchyNodes[2],
    &gSxmAudioReplayContentHierarchyNodes[1],
    &gSXMAudioSportsflashListItemAlertHierarchyNodes[0],
    &gSxmAudioChannelListHierarchyNodes[3],
    &gSxmAudioContentAlertHierarchyNodes[0],
    &gSxmAudioChannelNotSubscribedPopupHierarchyNodes[1],
    &gSxmAudioSliderConfHierarchyNodes[1],
    &gSxmAudioPresetControlHierarchyNodes[4],
    &gSxmChannelInfoHierarchyNodes[2],
    &gSXMSFButtonHierarchyNodes[1],
    &gSXTWNButtonHierarchyNodes[1],
    &gSXMAudioCustomizeChannelListItemHierarchyNodes[6],
    &gSxmAudioInfoForPopupHierarchyNodes[3],
    &gSxmAudioPresetControlHierarchyNodes[1],
    &gSxmAudioChannelNotAvailablePopupHierarchyNodes[0],
    &gSxmAudioDirectTuneTextInfoHierarchyNodes[1],
    &gSxmTabControlListHierarchyNodes[12],
    &gSxmUpdateFooterHierarchyNodes[3],
    &gSxmPresetItemHierarchyNodes[5],
    &gSxmAudioChannelListHierarchyNodes[0],
    &gSxmAudioModeHierarchyNodes[1],
    &gSxmMenuListHierarchyNodes[1],
    &gSxmAudioContentAlertHierarchyNodes[2],
    &gSXMAudioSportsflashAlertHierarchyNodes[1],
    &gSxmPresetListHierarchyNodes[2],
    &gSxmAudioScanHierarchyNodes[0],
    &gSXMAudioSportsflashFavAdvisoryHierarchyNodes[1],
    &gSxmAudioContentAlertHierarchyNodes[1],
    &gSxmAudioPresetControlHierarchyNodes[2],
    &gSxmAudioSportsFlashTeamNamePopupHierarchyNodes[0],
    &gSxmChannelLogoHierarchyNodes[2],
    &gSxmPresetListHierarchyNodes[1],
    &gSxmTabControlListHierarchyNodes[6],
    &gSxmChannelInfoHierarchyNodes[12],
    &gSxmAudioReplayContentHierarchyNodes[10],
    &gSxmAudioAlertSettingHierarchyNodes[1],
    &gSxmAudioModeHierarchyNodes[4],
    &gSxmAudioChannelListHierarchyNodes[2],
    &gSxmSFTunePopupHierarchyNodes[2],
    &gSxmTabControlListHierarchyNodes[11],
    &gSxmChannelLogoHierarchyNodes[0],
    &gSxmAudioChannelListHierarchyNodes[5],
    &gListScrollBarInfoHierarchyNodes[1],
    &gSxmAudioAlertSettingHierarchyNodes[2],
    &gSxmChannelInfoHierarchyNodes[8],
    &gSXMAudioTWNNoInfoHierarchyNodes[0],
    &gSxmUpdateFooterHierarchyNodes[0],
    &gSxmAudioDirectTuneKeyPressInfoHierarchyNodes[1],
    &gSxmChannelInfoHierarchyNodes[9],
    &gSxmMenuListHierarchyNodes[4],
    &gSxmAudioReplayContentHierarchyNodes[3],
    &gSxmAudioFavoriteArtistHierarchyNodes[0],
    &gSXMAudioCustomizeChannelHierarchyNodes[1],
    &gSxmAudioSliderConfHierarchyNodes[2],
    &gSxmTabControlListHierarchyNodes[7],
    &gSxmAudioModeHierarchyNodes[3],
    &gSxmAudioReplayContentHierarchyNodes[5],
    &gSxmAudioReplayContentHierarchyNodes[7],
    &gSXMSFButtonHierarchyNodes[3],
    &gHeaderTextHierarchyNodes[1],
    &gSxmTabControlListHierarchyNodes[3],
    &gSxmAudioReplayContentHierarchyNodes[9],
    &gSxmMenuItemHierarchyNodes[0],
    &gSxmAudioAlertFavtUpdatePopupHierarchyNodes[3],
    &gSxmAudioAlertFavtUpdatePopupHierarchyNodes[5],
    &gSxmTabControlListHierarchyNodes[16],
    &gSxmAudioAlertFavtUpdatePopupHierarchyNodes[4],
    &gSxmGadgetChannelInfoHierarchyNodes[3],
    &gSXMSFButtonHierarchyNodes[2],
    &gSxmActivePresetBankHierarchyNodes[1],
    &gSxmChannelInfoHierarchyNodes[5],
    &gSXMAudioCustomizeChannelListItemHierarchyNodes[4],
    &gSxmAudioSportsflashEnableHierarchyNodes[1],
    &gSxmAudioFavArtistSongTeamListHierarchyNodes[1],
    &gSxmChannelInfoHierarchyNodes[16],
};

// binding source root table - indexed with BindingSourceIndex 
static const ::Courier::Internal::DataBinding::BindingSourceRootStorage gBindingSourceMap[cBindingSourceCount] = {
    { InvalidDataBindingSource::cHierarchyNodeCount, gInvalidHierarchyNodes },
    { HeaderTextDataBindingSource::cHierarchyNodeCount, gHeaderTextHierarchyNodes },
    { AudioMuteInfoDataBindingSource::cHierarchyNodeCount, gAudioMuteInfoHierarchyNodes },
    { SxmTabControlListDataBindingSource::cHierarchyNodeCount, gSxmTabControlListHierarchyNodes },
    { SxmSpeedLockUpdateForListItemScrollDataBindingSource::cHierarchyNodeCount, gSxmSpeedLockUpdateForListItemScrollHierarchyNodes },
    { SxmAudioFavArtistSongTeamListDataBindingSource::cHierarchyNodeCount, gSxmAudioFavArtistSongTeamListHierarchyNodes },
    { SxmUpdateFooterDataBindingSource::cHierarchyNodeCount, gSxmUpdateFooterHierarchyNodes },
    { SxmPopupInfoDataBindingSource::cHierarchyNodeCount, gSxmPopupInfoHierarchyNodes },
    { SxmPresetListDataBindingSource::cHierarchyNodeCount, gSxmPresetListHierarchyNodes },
    { SxmAudioLoadingInfoDataBindingSource::cHierarchyNodeCount, gSxmAudioLoadingInfoHierarchyNodes },
    { SxmAudioModeDataBindingSource::cHierarchyNodeCount, gSxmAudioModeHierarchyNodes },
    { SxmAudioMaintextAnimationDataBindingSource::cHierarchyNodeCount, gSxmAudioMaintextAnimationHierarchyNodes },
    { SxmAudioTuneScanDataBindingSource::cHierarchyNodeCount, gSxmAudioTuneScanHierarchyNodes },
    { SxmMenuListDataBindingSource::cHierarchyNodeCount, gSxmMenuListHierarchyNodes },
    { SxmMenuItemDataBindingSource::cHierarchyNodeCount, gSxmMenuItemHierarchyNodes },
    { SxmChannelInfoDataBindingSource::cHierarchyNodeCount, gSxmChannelInfoHierarchyNodes },
    { SxmTpopChannelInfoDataBindingSource::cHierarchyNodeCount, gSxmTpopChannelInfoHierarchyNodes },
    { SxmGadgetChannelInfoDataBindingSource::cHierarchyNodeCount, gSxmGadgetChannelInfoHierarchyNodes },
    { SxmAudioInfoForPopupDataBindingSource::cHierarchyNodeCount, gSxmAudioInfoForPopupHierarchyNodes },
    { SxmActivePresetBankDataBindingSource::cHierarchyNodeCount, gSxmActivePresetBankHierarchyNodes },
    { SxmCategoriesListDataBindingSource::cHierarchyNodeCount, gSxmCategoriesListHierarchyNodes },
    { SxmChannelLogoDataBindingSource::cHierarchyNodeCount, gSxmChannelLogoHierarchyNodes },
    { SxmAudioPresetControlDataBindingSource::cHierarchyNodeCount, gSxmAudioPresetControlHierarchyNodes },
    { SxmAudioPlayPauseDataBindingSource::cHierarchyNodeCount, gSxmAudioPlayPauseHierarchyNodes },
    { SxmAudioAlertSettingDataBindingSource::cHierarchyNodeCount, gSxmAudioAlertSettingHierarchyNodes },
    { SxmAudioFavAlertButtonEnableDataBindingSource::cHierarchyNodeCount, gSxmAudioFavAlertButtonEnableHierarchyNodes },
    { SxmAudioAlertFavtUpdatePopupDataBindingSource::cHierarchyNodeCount, gSxmAudioAlertFavtUpdatePopupHierarchyNodes },
    { SxmPresetItemDataBindingSource::cHierarchyNodeCount, gSxmPresetItemHierarchyNodes },
    { SxmAudioChannelListDataBindingSource::cHierarchyNodeCount, gSxmAudioChannelListHierarchyNodes },
    { SxmAudioSubScreenHeaderTextDataBindingSource::cHierarchyNodeCount, gSxmAudioSubScreenHeaderTextHierarchyNodes },
    { SxmAudioFavoriteArtistDataBindingSource::cHierarchyNodeCount, gSxmAudioFavoriteArtistHierarchyNodes },
    { SxmAudioFavoriteSongDataBindingSource::cHierarchyNodeCount, gSxmAudioFavoriteSongHierarchyNodes },
    { SxmLeagueOrReplaceListDataBindingSource::cHierarchyNodeCount, gSxmLeagueOrReplaceListHierarchyNodes },
    { SxmInfoButtonEnableDataBindingSource::cHierarchyNodeCount, gSxmInfoButtonEnableHierarchyNodes },
    { SxmAudioReplayContentDataBindingSource::cHierarchyNodeCount, gSxmAudioReplayContentHierarchyNodes },
    { SXMAudioCustomizeChannelDataBindingSource::cHierarchyNodeCount, gSXMAudioCustomizeChannelHierarchyNodes },
    { SXMAudioCustomizeChannelListItemDataBindingSource::cHierarchyNodeCount, gSXMAudioCustomizeChannelListItemHierarchyNodes },
    { SxmAudioDirectTuneTextInfoDataBindingSource::cHierarchyNodeCount, gSxmAudioDirectTuneTextInfoHierarchyNodes },
    { SxmAudioDirectTuneKeyPressInfoDataBindingSource::cHierarchyNodeCount, gSxmAudioDirectTuneKeyPressInfoHierarchyNodes },
    { SpellerDeleteBtnStateDataBindingSource::cHierarchyNodeCount, gSpellerDeleteBtnStateHierarchyNodes },
    { SxmAudioChannelNotAvailablePopupDataBindingSource::cHierarchyNodeCount, gSxmAudioChannelNotAvailablePopupHierarchyNodes },
    { SxmAudioChannelNotSubscribedPopupDataBindingSource::cHierarchyNodeCount, gSxmAudioChannelNotSubscribedPopupHierarchyNodes },
    { SxmAudioTuneStartDataBindingSource::cHierarchyNodeCount, gSxmAudioTuneStartHierarchyNodes },
    { SxmAudioScanDataBindingSource::cHierarchyNodeCount, gSxmAudioScanHierarchyNodes },
    { SxmAudioSportsFlashTeamNamePopupDataBindingSource::cHierarchyNodeCount, gSxmAudioSportsFlashTeamNamePopupHierarchyNodes },
    { SxmAudioSportsFlashAlertAdvisoryDataBindingSource::cHierarchyNodeCount, gSxmAudioSportsFlashAlertAdvisoryHierarchyNodes },
    { SXMAudioSportsflashAlertDataBindingSource::cHierarchyNodeCount, gSXMAudioSportsflashAlertHierarchyNodes },
    { SXMAudioSportsflashListItemAlertDataBindingSource::cHierarchyNodeCount, gSXMAudioSportsflashListItemAlertHierarchyNodes },
    { SXMAudioSportsflashFavAdvisoryDataBindingSource::cHierarchyNodeCount, gSXMAudioSportsflashFavAdvisoryHierarchyNodes },
    { SxmAudioSportsflashEnableDataBindingSource::cHierarchyNodeCount, gSxmAudioSportsflashEnableHierarchyNodes },
    { SxmAudioMenuChannelLockDataBindingSource::cHierarchyNodeCount, gSxmAudioMenuChannelLockHierarchyNodes },
    { SxmAudioCustomizeButtonDataBindingSource::cHierarchyNodeCount, gSxmAudioCustomizeButtonHierarchyNodes },
    { SXMAudioTWNDataBindingSource::cHierarchyNodeCount, gSXMAudioTWNHierarchyNodes },
    { SXMAudioTWNNoInfoDataBindingSource::cHierarchyNodeCount, gSXMAudioTWNNoInfoHierarchyNodes },
    { SXTWNButtonDataBindingSource::cHierarchyNodeCount, gSXTWNButtonHierarchyNodes },
    { SXMSFButtonDataBindingSource::cHierarchyNodeCount, gSXMSFButtonHierarchyNodes },
    { SxmSFTunePopupDataBindingSource::cHierarchyNodeCount, gSxmSFTunePopupHierarchyNodes },
    { SxmAudioSliderConfDataBindingSource::cHierarchyNodeCount, gSxmAudioSliderConfHierarchyNodes },
    { SxmSettingTestmodeUpdatePopupDataBindingSource::cHierarchyNodeCount, gSxmSettingTestmodeUpdatePopupHierarchyNodes },
    { SxmSettingTestmodeExternalDiagDataBindingSource::cHierarchyNodeCount, gSxmSettingTestmodeExternalDiagHierarchyNodes },
    { SxmAudioContentAlertDataBindingSource::cHierarchyNodeCount, gSxmAudioContentAlertHierarchyNodes },
    { SxmFavtUpdatePopupDataBindingSource::cHierarchyNodeCount, gSxmFavtUpdatePopupHierarchyNodes },
    { SxmFavtDeletePopupDataBindingSource::cHierarchyNodeCount, gSxmFavtDeletePopupHierarchyNodes },
    { SxmApplicationStateDataBindingSource::cHierarchyNodeCount, gSxmApplicationStateHierarchyNodes },
    { ListScrollBarInfoDataBindingSource::cHierarchyNodeCount, gListScrollBarInfoHierarchyNodes },
    { CarModeVisibilityDataBindingSource::cHierarchyNodeCount, gCarModeVisibilityHierarchyNodes },
};

// Init function prototype
static bool InitDataBindingGenerated(void);

// Infrastructure defnition
static const ::Courier::Internal::DataBinding::DataBindingInfrastructure gInfrastructure = { 
    cGlobalDataItemHierarchyNodeCount, gGlobalHierachyNodeTable, 
    cBindingSourceCount, gBindingSourceMap,
    cDataItemDescriptorCount, gItemDesc,
    &InitDataBindingGenerated
};

// ------------------------------------------------------------------------
static bool InitDataBindingGenerated(void)
{
    /* if one of these assertion fails, increase the limits defined in Courier/DataBinding/Infrastructure.h */
    COURIER_COMPILETIME_ASSERT(cBindingSourceItemCountMax < ::Courier::cBindingSourceHierarchyNodeMax);
    COURIER_COMPILETIME_ASSERT(cDataItemDescriptorCount < ::Courier::cItemDescriptorMax);
    COURIER_COMPILETIME_ASSERT(cBindingSourceCount < ::Courier::cBindingSourceMax);

    static ::Courier::Internal::DataBinding::BindingSourceRevisionStoreImpl<cBindingSourceCount> theRevisionStore;

    bool ok = true;
    {
        FEATSTD_UNSYNCED_STATIC_OBJECT(HeaderTextDataBindingSource, bsHeaderText);
        FEATSTD_UNSYNCED_STATIC_OBJECT(AudioMuteInfoDataBindingSource, bsAudioMuteInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmTabControlListDataBindingSource, bsSxmTabControlList);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmSpeedLockUpdateForListItemScrollDataBindingSource, bsSxmSpeedLockUpdateForListItemScroll);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmAudioFavArtistSongTeamListDataBindingSource, bsSxmAudioFavArtistSongTeamList);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmUpdateFooterDataBindingSource, bsSxmUpdateFooter);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmPresetListDataBindingSource, bsSxmPresetList);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmAudioLoadingInfoDataBindingSource, bsSxmAudioLoadingInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmAudioModeDataBindingSource, bsSxmAudioMode);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmAudioMaintextAnimationDataBindingSource, bsSxmAudioMaintextAnimation);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmAudioTuneScanDataBindingSource, bsSxmAudioTuneScan);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmMenuListDataBindingSource, bsSxmMenuList);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmMenuItemDataBindingSource, bsSxmMenuItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmChannelInfoDataBindingSource, bsSxmChannelInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmTpopChannelInfoDataBindingSource, bsSxmTpopChannelInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmGadgetChannelInfoDataBindingSource, bsSxmGadgetChannelInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmAudioInfoForPopupDataBindingSource, bsSxmAudioInfoForPopup);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmActivePresetBankDataBindingSource, bsSxmActivePresetBank);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmCategoriesListDataBindingSource, bsSxmCategoriesList);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmChannelLogoDataBindingSource, bsSxmChannelLogo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmAudioPresetControlDataBindingSource, bsSxmAudioPresetControl);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmAudioPlayPauseDataBindingSource, bsSxmAudioPlayPause);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmAudioAlertSettingDataBindingSource, bsSxmAudioAlertSetting);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmAudioFavAlertButtonEnableDataBindingSource, bsSxmAudioFavAlertButtonEnable);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmAudioAlertFavtUpdatePopupDataBindingSource, bsSxmAudioAlertFavtUpdatePopup);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmPresetItemDataBindingSource, bsSxmPresetItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmAudioChannelListDataBindingSource, bsSxmAudioChannelList);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmAudioSubScreenHeaderTextDataBindingSource, bsSxmAudioSubScreenHeaderText);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmAudioFavoriteArtistDataBindingSource, bsSxmAudioFavoriteArtist);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmAudioFavoriteSongDataBindingSource, bsSxmAudioFavoriteSong);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmLeagueOrReplaceListDataBindingSource, bsSxmLeagueOrReplaceList);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmInfoButtonEnableDataBindingSource, bsSxmInfoButtonEnable);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmAudioReplayContentDataBindingSource, bsSxmAudioReplayContent);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SXMAudioCustomizeChannelDataBindingSource, bsSXMAudioCustomizeChannel);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SXMAudioCustomizeChannelListItemDataBindingSource, bsSXMAudioCustomizeChannelListItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmAudioDirectTuneTextInfoDataBindingSource, bsSxmAudioDirectTuneTextInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmAudioDirectTuneKeyPressInfoDataBindingSource, bsSxmAudioDirectTuneKeyPressInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SpellerDeleteBtnStateDataBindingSource, bsSpellerDeleteBtnState);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmAudioChannelNotAvailablePopupDataBindingSource, bsSxmAudioChannelNotAvailablePopup);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmAudioChannelNotSubscribedPopupDataBindingSource, bsSxmAudioChannelNotSubscribedPopup);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmAudioTuneStartDataBindingSource, bsSxmAudioTuneStart);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmAudioScanDataBindingSource, bsSxmAudioScan);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmAudioSportsFlashTeamNamePopupDataBindingSource, bsSxmAudioSportsFlashTeamNamePopup);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmAudioSportsFlashAlertAdvisoryDataBindingSource, bsSxmAudioSportsFlashAlertAdvisory);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SXMAudioSportsflashAlertDataBindingSource, bsSXMAudioSportsflashAlert);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SXMAudioSportsflashListItemAlertDataBindingSource, bsSXMAudioSportsflashListItemAlert);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SXMAudioSportsflashFavAdvisoryDataBindingSource, bsSXMAudioSportsflashFavAdvisory);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmAudioSportsflashEnableDataBindingSource, bsSxmAudioSportsflashEnable);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmAudioMenuChannelLockDataBindingSource, bsSxmAudioMenuChannelLock);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmAudioCustomizeButtonDataBindingSource, bsSxmAudioCustomizeButton);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SXMAudioTWNDataBindingSource, bsSXMAudioTWN);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SXMAudioTWNNoInfoDataBindingSource, bsSXMAudioTWNNoInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SXTWNButtonDataBindingSource, bsSXTWNButton);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SXMSFButtonDataBindingSource, bsSXMSFButton);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmSFTunePopupDataBindingSource, bsSxmSFTunePopup);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmAudioSliderConfDataBindingSource, bsSxmAudioSliderConf);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmSettingTestmodeUpdatePopupDataBindingSource, bsSxmSettingTestmodeUpdatePopup);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmSettingTestmodeExternalDiagDataBindingSource, bsSxmSettingTestmodeExternalDiag);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmAudioContentAlertDataBindingSource, bsSxmAudioContentAlert);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmFavtUpdatePopupDataBindingSource, bsSxmFavtUpdatePopup);
        FEATSTD_UNSYNCED_STATIC_OBJECT(SxmFavtDeletePopupDataBindingSource, bsSxmFavtDeletePopup);
        FEATSTD_UNSYNCED_STATIC_OBJECT(ListScrollBarInfoDataBindingSource, bsListScrollBarInfo);
        FEATSTD_UNSYNCED_STATIC_OBJECT(CarModeVisibilityDataBindingSource, bsCarModeVisibility);
        static ::Courier::Internal::ModelBindingSource *bindingSources[cBindingSourceCount] = { 
            0,
            &bsHeaderText, 
            &bsAudioMuteInfo, 
            &bsSxmTabControlList, 
            &bsSxmSpeedLockUpdateForListItemScroll, 
            &bsSxmAudioFavArtistSongTeamList, 
            &bsSxmUpdateFooter, 
            0,
            &bsSxmPresetList, 
            &bsSxmAudioLoadingInfo, 
            &bsSxmAudioMode, 
            &bsSxmAudioMaintextAnimation, 
            &bsSxmAudioTuneScan, 
            &bsSxmMenuList, 
            &bsSxmMenuItem, 
            &bsSxmChannelInfo, 
            &bsSxmTpopChannelInfo, 
            &bsSxmGadgetChannelInfo, 
            &bsSxmAudioInfoForPopup, 
            &bsSxmActivePresetBank, 
            &bsSxmCategoriesList, 
            &bsSxmChannelLogo, 
            &bsSxmAudioPresetControl, 
            &bsSxmAudioPlayPause, 
            &bsSxmAudioAlertSetting, 
            &bsSxmAudioFavAlertButtonEnable, 
            &bsSxmAudioAlertFavtUpdatePopup, 
            &bsSxmPresetItem, 
            &bsSxmAudioChannelList, 
            &bsSxmAudioSubScreenHeaderText, 
            &bsSxmAudioFavoriteArtist, 
            &bsSxmAudioFavoriteSong, 
            &bsSxmLeagueOrReplaceList, 
            &bsSxmInfoButtonEnable, 
            &bsSxmAudioReplayContent, 
            &bsSXMAudioCustomizeChannel, 
            &bsSXMAudioCustomizeChannelListItem, 
            &bsSxmAudioDirectTuneTextInfo, 
            &bsSxmAudioDirectTuneKeyPressInfo, 
            &bsSpellerDeleteBtnState, 
            &bsSxmAudioChannelNotAvailablePopup, 
            &bsSxmAudioChannelNotSubscribedPopup, 
            &bsSxmAudioTuneStart, 
            &bsSxmAudioScan, 
            &bsSxmAudioSportsFlashTeamNamePopup, 
            &bsSxmAudioSportsFlashAlertAdvisory, 
            &bsSXMAudioSportsflashAlert, 
            &bsSXMAudioSportsflashListItemAlert, 
            &bsSXMAudioSportsflashFavAdvisory, 
            &bsSxmAudioSportsflashEnable, 
            &bsSxmAudioMenuChannelLock, 
            &bsSxmAudioCustomizeButton, 
            &bsSXMAudioTWN, 
            &bsSXMAudioTWNNoInfo, 
            &bsSXTWNButton, 
            &bsSXMSFButton, 
            &bsSxmSFTunePopup, 
            &bsSxmAudioSliderConf, 
            &bsSxmSettingTestmodeUpdatePopup, 
            &bsSxmSettingTestmodeExternalDiag, 
            &bsSxmAudioContentAlert, 
            &bsSxmFavtUpdatePopup, 
            &bsSxmFavtDeletePopup, 
            0,
            &bsListScrollBarInfo, 
            &bsCarModeVisibility, 
        };
        ok = ok && ::Courier::Register(::Courier::ComponentId(::Courier::ComponentType::View), bindingSources, cBindingSourceCount);
    }
    {
        FEATSTD_UNSYNCED_STATIC_OBJECT(::Courier::Internal::AsyncGenericModelBindingSource, bsHeaderText, ItemKey::HeaderTextItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(::Courier::Internal::AsyncGenericModelBindingSource, bsSxmTabControlList, ItemKey::SxmTabControlListItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(::Courier::Internal::AsyncGenericModelBindingSource, bsSxmPopupInfo, ItemKey::SxmPopupInfoItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(::Courier::Internal::AsyncGenericModelBindingSource, bsSxmAudioScan, ItemKey::SxmAudioScanItem);
        FEATSTD_UNSYNCED_STATIC_OBJECT(::Courier::Internal::AsyncGenericModelBindingSource, bsSxmApplicationState, ItemKey::SxmApplicationStateItem);
        static ::Courier::Internal::ModelBindingSource *bindingSources[cBindingSourceCount] = { 
            0,
            &bsHeaderText, 
            0,
            &bsSxmTabControlList, 
            0,
            0,
            0,
            &bsSxmPopupInfo, 
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            &bsSxmAudioScan, 
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            &bsSxmApplicationState, 
            0,
            0,
        };
        ok = ok && ::Courier::Register(::Courier::ComponentId(::Courier::ComponentType::Controller), bindingSources, cBindingSourceCount);
    }
    return ok;
}

namespace Courier {
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::HeaderTextDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::AudioMuteInfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmTabControlListDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmSpeedLockUpdateForListItemScrollDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmAudioFavArtistSongTeamListDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmUpdateFooterDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmPopupInfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmPresetListDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmAudioLoadingInfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmAudioModeDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmAudioMaintextAnimationDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmAudioTuneScanDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmMenuListDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmMenuItemDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmChannelInfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmTpopChannelInfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmGadgetChannelInfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmAudioInfoForPopupDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmActivePresetBankDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmCategoriesListDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmChannelLogoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmAudioPresetControlDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmAudioPlayPauseDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmAudioAlertSettingDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmAudioFavAlertButtonEnableDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmAudioAlertFavtUpdatePopupDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmPresetItemDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmAudioChannelListDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmAudioSubScreenHeaderTextDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmAudioFavoriteArtistDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmAudioFavoriteSongDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmLeagueOrReplaceListDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmInfoButtonEnableDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmAudioReplayContentDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SXMAudioCustomizeChannelDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SXMAudioCustomizeChannelListItemDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmAudioDirectTuneTextInfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmAudioDirectTuneKeyPressInfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SpellerDeleteBtnStateDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmAudioChannelNotAvailablePopupDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmAudioChannelNotSubscribedPopupDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmAudioTuneStartDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmAudioScanDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmAudioSportsFlashTeamNamePopupDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmAudioSportsFlashAlertAdvisoryDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SXMAudioSportsflashAlertDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SXMAudioSportsflashListItemAlertDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SXMAudioSportsflashFavAdvisoryDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmAudioSportsflashEnableDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmAudioMenuChannelLockDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmAudioCustomizeButtonDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SXMAudioTWNDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SXMAudioTWNNoInfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SXTWNButtonDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SXMSFButtonDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmSFTunePopupDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmAudioSliderConfDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmSettingTestmodeUpdatePopupDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmSettingTestmodeExternalDiagDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmAudioContentAlertDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmFavtUpdatePopupDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmFavtDeletePopupDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::SxmApplicationStateDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::ListScrollBarInfoDataBindingSource>, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DataItemMsg< ::CarModeVisibilityDataBindingSource>, 5);
} // namespace Courier

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HeaderTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HeaderTextDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AudioMuteInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AudioMuteInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmTabControlListDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmTabControlListDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmSpeedLockUpdateForListItemScrollDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmSpeedLockUpdateForListItemScrollDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioFavArtistSongTeamListDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioFavArtistSongTeamListDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmUpdateFooterDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmUpdateFooterDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmPopupInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmPopupInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmPresetListDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmPresetListDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioLoadingInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioLoadingInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioModeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioModeDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioMaintextAnimationDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioMaintextAnimationDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioTuneScanDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioTuneScanDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmMenuListDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmMenuListDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmMenuItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmMenuItemDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmChannelInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmChannelInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmTpopChannelInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmTpopChannelInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmGadgetChannelInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmGadgetChannelInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioInfoForPopupDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioInfoForPopupDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmActivePresetBankDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmActivePresetBankDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmCategoriesListDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmCategoriesListDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmChannelLogoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmChannelLogoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioPresetControlDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioPresetControlDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioPlayPauseDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioPlayPauseDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioAlertSettingDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioAlertSettingDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioFavAlertButtonEnableDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioFavAlertButtonEnableDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioAlertFavtUpdatePopupDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioAlertFavtUpdatePopupDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmPresetItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmPresetItemDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioChannelListDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioChannelListDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioSubScreenHeaderTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioSubScreenHeaderTextDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioFavoriteArtistDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioFavoriteArtistDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioFavoriteSongDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioFavoriteSongDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmLeagueOrReplaceListDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmLeagueOrReplaceListDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmInfoButtonEnableDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmInfoButtonEnableDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioReplayContentDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioReplayContentDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SXMAudioCustomizeChannelDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SXMAudioCustomizeChannelDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SXMAudioCustomizeChannelListItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SXMAudioCustomizeChannelListItemDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioDirectTuneTextInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioDirectTuneTextInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioDirectTuneKeyPressInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioDirectTuneKeyPressInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SpellerDeleteBtnStateDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SpellerDeleteBtnStateDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioChannelNotAvailablePopupDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioChannelNotAvailablePopupDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioChannelNotSubscribedPopupDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioChannelNotSubscribedPopupDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioTuneStartDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioTuneStartDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioScanDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioScanDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioSportsFlashTeamNamePopupDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioSportsFlashTeamNamePopupDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioSportsFlashAlertAdvisoryDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioSportsFlashAlertAdvisoryDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SXMAudioSportsflashAlertDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SXMAudioSportsflashAlertDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SXMAudioSportsflashListItemAlertDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SXMAudioSportsflashListItemAlertDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SXMAudioSportsflashFavAdvisoryDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SXMAudioSportsflashFavAdvisoryDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioSportsflashEnableDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioSportsflashEnableDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioMenuChannelLockDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioMenuChannelLockDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioCustomizeButtonDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioCustomizeButtonDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SXMAudioTWNDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SXMAudioTWNDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SXMAudioTWNNoInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SXMAudioTWNNoInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SXTWNButtonDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SXTWNButtonDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SXMSFButtonDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SXMSFButtonDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmSFTunePopupDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmSFTunePopupDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioSliderConfDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioSliderConfDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmSettingTestmodeUpdatePopupDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmSettingTestmodeUpdatePopupDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmSettingTestmodeExternalDiagDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmSettingTestmodeExternalDiagDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmAudioContentAlertDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmAudioContentAlertDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmFavtUpdatePopupDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmFavtUpdatePopupDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmFavtDeletePopupDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmFavtDeletePopupDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SxmApplicationStateDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SxmApplicationStateDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::CarModeVisibilityDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::CarModeVisibilityDataBindingSource > const& dataItemContainer) {
        ::FeatStd::UInt32 tcharCount = 0;
        tcharCount += stringBuffer.AppendObject(*dataItemContainer);
        return tcharCount;
    }
} // namespace FeatStd
#endif
COURIER_DATABINDING_INFRASTRUCTURE(::gInfrastructure);
